# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from ._enums import *

__all__ = [
    'AuthenticationModeProperties',
    'ClusterEndpoint',
]

@pulumi.output_type
class AuthenticationModeProperties(dict):
    """
    Denotes whether the user requires a password to authenticate.

    *Example:*

    `mynewdbuser: Type: AWS::MemoryDB::User Properties: AccessString: on ~* &* +@all AuthenticationMode: Passwords: '1234567890123456' Type: password UserName: mynewdbuser AuthenticationMode: { "Passwords": ["1234567890123456"], "Type": "Password" }`
    """
    def __init__(__self__, *,
                 passwords: Optional[Sequence[builtins.str]] = None,
                 type: Optional['UserAuthenticationModePropertiesType'] = None):
        """
        Denotes whether the user requires a password to authenticate.

        *Example:*

        `mynewdbuser: Type: AWS::MemoryDB::User Properties: AccessString: on ~* &* +@all AuthenticationMode: Passwords: '1234567890123456' Type: password UserName: mynewdbuser AuthenticationMode: { "Passwords": ["1234567890123456"], "Type": "Password" }`
        :param Sequence[builtins.str] passwords: Passwords used for this user account. You can create up to two passwords for each user.
        :param 'UserAuthenticationModePropertiesType' type: Type of authentication strategy for this user.
        """
        if passwords is not None:
            pulumi.set(__self__, "passwords", passwords)
        if type is not None:
            pulumi.set(__self__, "type", type)

    @property
    @pulumi.getter
    def passwords(self) -> Optional[Sequence[builtins.str]]:
        """
        Passwords used for this user account. You can create up to two passwords for each user.
        """
        return pulumi.get(self, "passwords")

    @property
    @pulumi.getter
    def type(self) -> Optional['UserAuthenticationModePropertiesType']:
        """
        Type of authentication strategy for this user.
        """
        return pulumi.get(self, "type")


@pulumi.output_type
class ClusterEndpoint(dict):
    def __init__(__self__, *,
                 address: Optional[builtins.str] = None,
                 port: Optional[builtins.int] = None):
        """
        :param builtins.str address: The DNS address of the primary read-write node.
        :param builtins.int port: The port number that the engine is listening on. 
        """
        if address is not None:
            pulumi.set(__self__, "address", address)
        if port is not None:
            pulumi.set(__self__, "port", port)

    @property
    @pulumi.getter
    def address(self) -> Optional[builtins.str]:
        """
        The DNS address of the primary read-write node.
        """
        return pulumi.get(self, "address")

    @property
    @pulumi.getter
    def port(self) -> Optional[builtins.int]:
        """
        The port number that the engine is listening on. 
        """
        return pulumi.get(self, "port")


