# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from .. import _inputs as _root_inputs
from .. import outputs as _root_outputs
from ._enums import *

__all__ = ['MultiRegionClusterArgs', 'MultiRegionCluster']

@pulumi.input_type
class MultiRegionClusterArgs:
    def __init__(__self__, *,
                 node_type: pulumi.Input[builtins.str],
                 description: Optional[pulumi.Input[builtins.str]] = None,
                 engine: Optional[pulumi.Input[builtins.str]] = None,
                 engine_version: Optional[pulumi.Input[builtins.str]] = None,
                 multi_region_cluster_name_suffix: Optional[pulumi.Input[builtins.str]] = None,
                 multi_region_parameter_group_name: Optional[pulumi.Input[builtins.str]] = None,
                 num_shards: Optional[pulumi.Input[builtins.int]] = None,
                 tags: Optional[pulumi.Input[Sequence[pulumi.Input['_root_inputs.TagArgs']]]] = None,
                 tls_enabled: Optional[pulumi.Input[builtins.bool]] = None,
                 update_strategy: Optional[pulumi.Input['MultiRegionClusterUpdateStrategy']] = None):
        """
        The set of arguments for constructing a MultiRegionCluster resource.
        :param pulumi.Input[builtins.str] node_type: The compute and memory capacity of the nodes in the multi region cluster.
        :param pulumi.Input[builtins.str] description: Description of the multi region cluster.
        :param pulumi.Input[builtins.str] engine: The engine type used by the multi region cluster.
        :param pulumi.Input[builtins.str] engine_version: The Redis engine version used by the multi region cluster.
        :param pulumi.Input[builtins.str] multi_region_cluster_name_suffix: The name of the Multi Region cluster. This value must be unique as it also serves as the multi region cluster identifier.
        :param pulumi.Input[builtins.str] multi_region_parameter_group_name: The name of the parameter group associated with the multi region cluster.
        :param pulumi.Input[builtins.int] num_shards: The number of shards the multi region cluster will contain.
        :param pulumi.Input[Sequence[pulumi.Input['_root_inputs.TagArgs']]] tags: An array of key-value pairs to apply to this multi region cluster.
        :param pulumi.Input[builtins.bool] tls_enabled: A flag that enables in-transit encryption when set to true.
               
               You cannot modify the value of TransitEncryptionEnabled after the cluster is created. To enable in-transit encryption on a cluster you must set TransitEncryptionEnabled to true when you create a cluster.
        :param pulumi.Input['MultiRegionClusterUpdateStrategy'] update_strategy: An enum string value that determines the update strategy for scaling. Possible values are 'COORDINATED' and 'UNCOORDINATED'. Default is 'COORDINATED'.
        """
        pulumi.set(__self__, "node_type", node_type)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if engine is not None:
            pulumi.set(__self__, "engine", engine)
        if engine_version is not None:
            pulumi.set(__self__, "engine_version", engine_version)
        if multi_region_cluster_name_suffix is not None:
            pulumi.set(__self__, "multi_region_cluster_name_suffix", multi_region_cluster_name_suffix)
        if multi_region_parameter_group_name is not None:
            pulumi.set(__self__, "multi_region_parameter_group_name", multi_region_parameter_group_name)
        if num_shards is not None:
            pulumi.set(__self__, "num_shards", num_shards)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)
        if tls_enabled is not None:
            pulumi.set(__self__, "tls_enabled", tls_enabled)
        if update_strategy is not None:
            pulumi.set(__self__, "update_strategy", update_strategy)

    @property
    @pulumi.getter(name="nodeType")
    def node_type(self) -> pulumi.Input[builtins.str]:
        """
        The compute and memory capacity of the nodes in the multi region cluster.
        """
        return pulumi.get(self, "node_type")

    @node_type.setter
    def node_type(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "node_type", value)

    @property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Description of the multi region cluster.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "description", value)

    @property
    @pulumi.getter
    def engine(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The engine type used by the multi region cluster.
        """
        return pulumi.get(self, "engine")

    @engine.setter
    def engine(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "engine", value)

    @property
    @pulumi.getter(name="engineVersion")
    def engine_version(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The Redis engine version used by the multi region cluster.
        """
        return pulumi.get(self, "engine_version")

    @engine_version.setter
    def engine_version(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "engine_version", value)

    @property
    @pulumi.getter(name="multiRegionClusterNameSuffix")
    def multi_region_cluster_name_suffix(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The name of the Multi Region cluster. This value must be unique as it also serves as the multi region cluster identifier.
        """
        return pulumi.get(self, "multi_region_cluster_name_suffix")

    @multi_region_cluster_name_suffix.setter
    def multi_region_cluster_name_suffix(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "multi_region_cluster_name_suffix", value)

    @property
    @pulumi.getter(name="multiRegionParameterGroupName")
    def multi_region_parameter_group_name(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The name of the parameter group associated with the multi region cluster.
        """
        return pulumi.get(self, "multi_region_parameter_group_name")

    @multi_region_parameter_group_name.setter
    def multi_region_parameter_group_name(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "multi_region_parameter_group_name", value)

    @property
    @pulumi.getter(name="numShards")
    def num_shards(self) -> Optional[pulumi.Input[builtins.int]]:
        """
        The number of shards the multi region cluster will contain.
        """
        return pulumi.get(self, "num_shards")

    @num_shards.setter
    def num_shards(self, value: Optional[pulumi.Input[builtins.int]]):
        pulumi.set(self, "num_shards", value)

    @property
    @pulumi.getter
    def tags(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['_root_inputs.TagArgs']]]]:
        """
        An array of key-value pairs to apply to this multi region cluster.
        """
        return pulumi.get(self, "tags")

    @tags.setter
    def tags(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['_root_inputs.TagArgs']]]]):
        pulumi.set(self, "tags", value)

    @property
    @pulumi.getter(name="tlsEnabled")
    def tls_enabled(self) -> Optional[pulumi.Input[builtins.bool]]:
        """
        A flag that enables in-transit encryption when set to true.

        You cannot modify the value of TransitEncryptionEnabled after the cluster is created. To enable in-transit encryption on a cluster you must set TransitEncryptionEnabled to true when you create a cluster.
        """
        return pulumi.get(self, "tls_enabled")

    @tls_enabled.setter
    def tls_enabled(self, value: Optional[pulumi.Input[builtins.bool]]):
        pulumi.set(self, "tls_enabled", value)

    @property
    @pulumi.getter(name="updateStrategy")
    def update_strategy(self) -> Optional[pulumi.Input['MultiRegionClusterUpdateStrategy']]:
        """
        An enum string value that determines the update strategy for scaling. Possible values are 'COORDINATED' and 'UNCOORDINATED'. Default is 'COORDINATED'.
        """
        return pulumi.get(self, "update_strategy")

    @update_strategy.setter
    def update_strategy(self, value: Optional[pulumi.Input['MultiRegionClusterUpdateStrategy']]):
        pulumi.set(self, "update_strategy", value)


@pulumi.type_token("aws-native:memorydb:MultiRegionCluster")
class MultiRegionCluster(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 description: Optional[pulumi.Input[builtins.str]] = None,
                 engine: Optional[pulumi.Input[builtins.str]] = None,
                 engine_version: Optional[pulumi.Input[builtins.str]] = None,
                 multi_region_cluster_name_suffix: Optional[pulumi.Input[builtins.str]] = None,
                 multi_region_parameter_group_name: Optional[pulumi.Input[builtins.str]] = None,
                 node_type: Optional[pulumi.Input[builtins.str]] = None,
                 num_shards: Optional[pulumi.Input[builtins.int]] = None,
                 tags: Optional[pulumi.Input[Sequence[pulumi.Input[Union['_root_inputs.TagArgs', '_root_inputs.TagArgsDict']]]]] = None,
                 tls_enabled: Optional[pulumi.Input[builtins.bool]] = None,
                 update_strategy: Optional[pulumi.Input['MultiRegionClusterUpdateStrategy']] = None,
                 __props__=None):
        """
        The AWS::MemoryDB::Multi Region Cluster resource creates an Amazon MemoryDB Multi Region Cluster.

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[builtins.str] description: Description of the multi region cluster.
        :param pulumi.Input[builtins.str] engine: The engine type used by the multi region cluster.
        :param pulumi.Input[builtins.str] engine_version: The Redis engine version used by the multi region cluster.
        :param pulumi.Input[builtins.str] multi_region_cluster_name_suffix: The name of the Multi Region cluster. This value must be unique as it also serves as the multi region cluster identifier.
        :param pulumi.Input[builtins.str] multi_region_parameter_group_name: The name of the parameter group associated with the multi region cluster.
        :param pulumi.Input[builtins.str] node_type: The compute and memory capacity of the nodes in the multi region cluster.
        :param pulumi.Input[builtins.int] num_shards: The number of shards the multi region cluster will contain.
        :param pulumi.Input[Sequence[pulumi.Input[Union['_root_inputs.TagArgs', '_root_inputs.TagArgsDict']]]] tags: An array of key-value pairs to apply to this multi region cluster.
        :param pulumi.Input[builtins.bool] tls_enabled: A flag that enables in-transit encryption when set to true.
               
               You cannot modify the value of TransitEncryptionEnabled after the cluster is created. To enable in-transit encryption on a cluster you must set TransitEncryptionEnabled to true when you create a cluster.
        :param pulumi.Input['MultiRegionClusterUpdateStrategy'] update_strategy: An enum string value that determines the update strategy for scaling. Possible values are 'COORDINATED' and 'UNCOORDINATED'. Default is 'COORDINATED'.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: MultiRegionClusterArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        The AWS::MemoryDB::Multi Region Cluster resource creates an Amazon MemoryDB Multi Region Cluster.

        :param str resource_name: The name of the resource.
        :param MultiRegionClusterArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(MultiRegionClusterArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 description: Optional[pulumi.Input[builtins.str]] = None,
                 engine: Optional[pulumi.Input[builtins.str]] = None,
                 engine_version: Optional[pulumi.Input[builtins.str]] = None,
                 multi_region_cluster_name_suffix: Optional[pulumi.Input[builtins.str]] = None,
                 multi_region_parameter_group_name: Optional[pulumi.Input[builtins.str]] = None,
                 node_type: Optional[pulumi.Input[builtins.str]] = None,
                 num_shards: Optional[pulumi.Input[builtins.int]] = None,
                 tags: Optional[pulumi.Input[Sequence[pulumi.Input[Union['_root_inputs.TagArgs', '_root_inputs.TagArgsDict']]]]] = None,
                 tls_enabled: Optional[pulumi.Input[builtins.bool]] = None,
                 update_strategy: Optional[pulumi.Input['MultiRegionClusterUpdateStrategy']] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = MultiRegionClusterArgs.__new__(MultiRegionClusterArgs)

            __props__.__dict__["description"] = description
            __props__.__dict__["engine"] = engine
            __props__.__dict__["engine_version"] = engine_version
            __props__.__dict__["multi_region_cluster_name_suffix"] = multi_region_cluster_name_suffix
            __props__.__dict__["multi_region_parameter_group_name"] = multi_region_parameter_group_name
            if node_type is None and not opts.urn:
                raise TypeError("Missing required property 'node_type'")
            __props__.__dict__["node_type"] = node_type
            __props__.__dict__["num_shards"] = num_shards
            __props__.__dict__["tags"] = tags
            __props__.__dict__["tls_enabled"] = tls_enabled
            __props__.__dict__["update_strategy"] = update_strategy
            __props__.__dict__["arn"] = None
            __props__.__dict__["multi_region_cluster_name"] = None
            __props__.__dict__["status"] = None
        replace_on_changes = pulumi.ResourceOptions(replace_on_changes=["engineVersion", "multiRegionClusterNameSuffix", "multiRegionParameterGroupName", "tlsEnabled"])
        opts = pulumi.ResourceOptions.merge(opts, replace_on_changes)
        super(MultiRegionCluster, __self__).__init__(
            'aws-native:memorydb:MultiRegionCluster',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None) -> 'MultiRegionCluster':
        """
        Get an existing MultiRegionCluster resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = MultiRegionClusterArgs.__new__(MultiRegionClusterArgs)

        __props__.__dict__["arn"] = None
        __props__.__dict__["description"] = None
        __props__.__dict__["engine"] = None
        __props__.__dict__["engine_version"] = None
        __props__.__dict__["multi_region_cluster_name"] = None
        __props__.__dict__["multi_region_cluster_name_suffix"] = None
        __props__.__dict__["multi_region_parameter_group_name"] = None
        __props__.__dict__["node_type"] = None
        __props__.__dict__["num_shards"] = None
        __props__.__dict__["status"] = None
        __props__.__dict__["tags"] = None
        __props__.__dict__["tls_enabled"] = None
        __props__.__dict__["update_strategy"] = None
        return MultiRegionCluster(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter
    def arn(self) -> pulumi.Output[builtins.str]:
        """
        The Amazon Resource Name (ARN) of the multi region cluster.
        """
        return pulumi.get(self, "arn")

    @property
    @pulumi.getter
    def description(self) -> pulumi.Output[Optional[builtins.str]]:
        """
        Description of the multi region cluster.
        """
        return pulumi.get(self, "description")

    @property
    @pulumi.getter
    def engine(self) -> pulumi.Output[Optional[builtins.str]]:
        """
        The engine type used by the multi region cluster.
        """
        return pulumi.get(self, "engine")

    @property
    @pulumi.getter(name="engineVersion")
    def engine_version(self) -> pulumi.Output[Optional[builtins.str]]:
        """
        The Redis engine version used by the multi region cluster.
        """
        return pulumi.get(self, "engine_version")

    @property
    @pulumi.getter(name="multiRegionClusterName")
    def multi_region_cluster_name(self) -> pulumi.Output[builtins.str]:
        """
        The name of the Global Datastore, it is generated by MemoryDB adding a prefix to MultiRegionClusterNameSuffix.
        """
        return pulumi.get(self, "multi_region_cluster_name")

    @property
    @pulumi.getter(name="multiRegionClusterNameSuffix")
    def multi_region_cluster_name_suffix(self) -> pulumi.Output[Optional[builtins.str]]:
        """
        The name of the Multi Region cluster. This value must be unique as it also serves as the multi region cluster identifier.
        """
        return pulumi.get(self, "multi_region_cluster_name_suffix")

    @property
    @pulumi.getter(name="multiRegionParameterGroupName")
    def multi_region_parameter_group_name(self) -> pulumi.Output[Optional[builtins.str]]:
        """
        The name of the parameter group associated with the multi region cluster.
        """
        return pulumi.get(self, "multi_region_parameter_group_name")

    @property
    @pulumi.getter(name="nodeType")
    def node_type(self) -> pulumi.Output[builtins.str]:
        """
        The compute and memory capacity of the nodes in the multi region cluster.
        """
        return pulumi.get(self, "node_type")

    @property
    @pulumi.getter(name="numShards")
    def num_shards(self) -> pulumi.Output[Optional[builtins.int]]:
        """
        The number of shards the multi region cluster will contain.
        """
        return pulumi.get(self, "num_shards")

    @property
    @pulumi.getter
    def status(self) -> pulumi.Output[builtins.str]:
        """
        The status of the multi region cluster. For example, Available, Updating, Creating.
        """
        return pulumi.get(self, "status")

    @property
    @pulumi.getter
    def tags(self) -> pulumi.Output[Optional[Sequence['_root_outputs.Tag']]]:
        """
        An array of key-value pairs to apply to this multi region cluster.
        """
        return pulumi.get(self, "tags")

    @property
    @pulumi.getter(name="tlsEnabled")
    def tls_enabled(self) -> pulumi.Output[Optional[builtins.bool]]:
        """
        A flag that enables in-transit encryption when set to true.

        You cannot modify the value of TransitEncryptionEnabled after the cluster is created. To enable in-transit encryption on a cluster you must set TransitEncryptionEnabled to true when you create a cluster.
        """
        return pulumi.get(self, "tls_enabled")

    @property
    @pulumi.getter(name="updateStrategy")
    def update_strategy(self) -> pulumi.Output[Optional['MultiRegionClusterUpdateStrategy']]:
        """
        An enum string value that determines the update strategy for scaling. Possible values are 'COORDINATED' and 'UNCOORDINATED'. Default is 'COORDINATED'.
        """
        return pulumi.get(self, "update_strategy")

