# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from .. import outputs as _root_outputs

__all__ = [
    'GetSubnetGroupResult',
    'AwaitableGetSubnetGroupResult',
    'get_subnet_group',
    'get_subnet_group_output',
]

@pulumi.output_type
class GetSubnetGroupResult:
    def __init__(__self__, arn=None, description=None, subnet_ids=None, supported_network_types=None, tags=None):
        if arn and not isinstance(arn, str):
            raise TypeError("Expected argument 'arn' to be a str")
        pulumi.set(__self__, "arn", arn)
        if description and not isinstance(description, str):
            raise TypeError("Expected argument 'description' to be a str")
        pulumi.set(__self__, "description", description)
        if subnet_ids and not isinstance(subnet_ids, list):
            raise TypeError("Expected argument 'subnet_ids' to be a list")
        pulumi.set(__self__, "subnet_ids", subnet_ids)
        if supported_network_types and not isinstance(supported_network_types, list):
            raise TypeError("Expected argument 'supported_network_types' to be a list")
        pulumi.set(__self__, "supported_network_types", supported_network_types)
        if tags and not isinstance(tags, list):
            raise TypeError("Expected argument 'tags' to be a list")
        pulumi.set(__self__, "tags", tags)

    @property
    @pulumi.getter
    def arn(self) -> Optional[builtins.str]:
        """
        The Amazon Resource Name (ARN) of the subnet group.
        """
        return pulumi.get(self, "arn")

    @property
    @pulumi.getter
    def description(self) -> Optional[builtins.str]:
        """
        An optional description of the subnet group.
        """
        return pulumi.get(self, "description")

    @property
    @pulumi.getter(name="subnetIds")
    def subnet_ids(self) -> Optional[Sequence[builtins.str]]:
        """
        A list of VPC subnet IDs for the subnet group.
        """
        return pulumi.get(self, "subnet_ids")

    @property
    @pulumi.getter(name="supportedNetworkTypes")
    def supported_network_types(self) -> Optional[Sequence[builtins.str]]:
        """
        Supported network types would be a list of network types supported by subnet group and can be either [ipv4] or [ipv4, dual_stack] or [ipv6].
        """
        return pulumi.get(self, "supported_network_types")

    @property
    @pulumi.getter
    def tags(self) -> Optional[Sequence['_root_outputs.Tag']]:
        """
        An array of key-value pairs to apply to this subnet group.
        """
        return pulumi.get(self, "tags")


class AwaitableGetSubnetGroupResult(GetSubnetGroupResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetSubnetGroupResult(
            arn=self.arn,
            description=self.description,
            subnet_ids=self.subnet_ids,
            supported_network_types=self.supported_network_types,
            tags=self.tags)


def get_subnet_group(subnet_group_name: Optional[builtins.str] = None,
                     opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetSubnetGroupResult:
    """
    The AWS::MemoryDB::SubnetGroup resource creates an Amazon MemoryDB Subnet Group.


    :param builtins.str subnet_group_name: The name of the subnet group. This value must be unique as it also serves as the subnet group identifier.
    """
    __args__ = dict()
    __args__['subnetGroupName'] = subnet_group_name
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('aws-native:memorydb:getSubnetGroup', __args__, opts=opts, typ=GetSubnetGroupResult).value

    return AwaitableGetSubnetGroupResult(
        arn=pulumi.get(__ret__, 'arn'),
        description=pulumi.get(__ret__, 'description'),
        subnet_ids=pulumi.get(__ret__, 'subnet_ids'),
        supported_network_types=pulumi.get(__ret__, 'supported_network_types'),
        tags=pulumi.get(__ret__, 'tags'))
def get_subnet_group_output(subnet_group_name: Optional[pulumi.Input[builtins.str]] = None,
                            opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetSubnetGroupResult]:
    """
    The AWS::MemoryDB::SubnetGroup resource creates an Amazon MemoryDB Subnet Group.


    :param builtins.str subnet_group_name: The name of the subnet group. This value must be unique as it also serves as the subnet group identifier.
    """
    __args__ = dict()
    __args__['subnetGroupName'] = subnet_group_name
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('aws-native:memorydb:getSubnetGroup', __args__, opts=opts, typ=GetSubnetGroupResult)
    return __ret__.apply(lambda __response__: GetSubnetGroupResult(
        arn=pulumi.get(__response__, 'arn'),
        description=pulumi.get(__response__, 'description'),
        subnet_ids=pulumi.get(__response__, 'subnet_ids'),
        supported_network_types=pulumi.get(__response__, 'supported_network_types'),
        tags=pulumi.get(__response__, 'tags')))
