# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from .. import outputs as _root_outputs

__all__ = [
    'GetMultiRegionClusterResult',
    'AwaitableGetMultiRegionClusterResult',
    'get_multi_region_cluster',
    'get_multi_region_cluster_output',
]

@pulumi.output_type
class GetMultiRegionClusterResult:
    def __init__(__self__, arn=None, description=None, engine=None, multi_region_cluster_name=None, node_type=None, num_shards=None, status=None, tags=None):
        if arn and not isinstance(arn, str):
            raise TypeError("Expected argument 'arn' to be a str")
        pulumi.set(__self__, "arn", arn)
        if description and not isinstance(description, str):
            raise TypeError("Expected argument 'description' to be a str")
        pulumi.set(__self__, "description", description)
        if engine and not isinstance(engine, str):
            raise TypeError("Expected argument 'engine' to be a str")
        pulumi.set(__self__, "engine", engine)
        if multi_region_cluster_name and not isinstance(multi_region_cluster_name, str):
            raise TypeError("Expected argument 'multi_region_cluster_name' to be a str")
        pulumi.set(__self__, "multi_region_cluster_name", multi_region_cluster_name)
        if node_type and not isinstance(node_type, str):
            raise TypeError("Expected argument 'node_type' to be a str")
        pulumi.set(__self__, "node_type", node_type)
        if num_shards and not isinstance(num_shards, int):
            raise TypeError("Expected argument 'num_shards' to be a int")
        pulumi.set(__self__, "num_shards", num_shards)
        if status and not isinstance(status, str):
            raise TypeError("Expected argument 'status' to be a str")
        pulumi.set(__self__, "status", status)
        if tags and not isinstance(tags, list):
            raise TypeError("Expected argument 'tags' to be a list")
        pulumi.set(__self__, "tags", tags)

    @property
    @pulumi.getter
    def arn(self) -> Optional[builtins.str]:
        """
        The Amazon Resource Name (ARN) of the multi region cluster.
        """
        return pulumi.get(self, "arn")

    @property
    @pulumi.getter
    def description(self) -> Optional[builtins.str]:
        """
        Description of the multi region cluster.
        """
        return pulumi.get(self, "description")

    @property
    @pulumi.getter
    def engine(self) -> Optional[builtins.str]:
        """
        The engine type used by the multi region cluster.
        """
        return pulumi.get(self, "engine")

    @property
    @pulumi.getter(name="multiRegionClusterName")
    def multi_region_cluster_name(self) -> Optional[builtins.str]:
        """
        The name of the Global Datastore, it is generated by MemoryDB adding a prefix to MultiRegionClusterNameSuffix.
        """
        return pulumi.get(self, "multi_region_cluster_name")

    @property
    @pulumi.getter(name="nodeType")
    def node_type(self) -> Optional[builtins.str]:
        """
        The compute and memory capacity of the nodes in the multi region cluster.
        """
        return pulumi.get(self, "node_type")

    @property
    @pulumi.getter(name="numShards")
    def num_shards(self) -> Optional[builtins.int]:
        """
        The number of shards the multi region cluster will contain.
        """
        return pulumi.get(self, "num_shards")

    @property
    @pulumi.getter
    def status(self) -> Optional[builtins.str]:
        """
        The status of the multi region cluster. For example, Available, Updating, Creating.
        """
        return pulumi.get(self, "status")

    @property
    @pulumi.getter
    def tags(self) -> Optional[Sequence['_root_outputs.Tag']]:
        """
        An array of key-value pairs to apply to this multi region cluster.
        """
        return pulumi.get(self, "tags")


class AwaitableGetMultiRegionClusterResult(GetMultiRegionClusterResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetMultiRegionClusterResult(
            arn=self.arn,
            description=self.description,
            engine=self.engine,
            multi_region_cluster_name=self.multi_region_cluster_name,
            node_type=self.node_type,
            num_shards=self.num_shards,
            status=self.status,
            tags=self.tags)


def get_multi_region_cluster(multi_region_cluster_name: Optional[builtins.str] = None,
                             opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetMultiRegionClusterResult:
    """
    The AWS::MemoryDB::Multi Region Cluster resource creates an Amazon MemoryDB Multi Region Cluster.


    :param builtins.str multi_region_cluster_name: The name of the Global Datastore, it is generated by MemoryDB adding a prefix to MultiRegionClusterNameSuffix.
    """
    __args__ = dict()
    __args__['multiRegionClusterName'] = multi_region_cluster_name
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('aws-native:memorydb:getMultiRegionCluster', __args__, opts=opts, typ=GetMultiRegionClusterResult).value

    return AwaitableGetMultiRegionClusterResult(
        arn=pulumi.get(__ret__, 'arn'),
        description=pulumi.get(__ret__, 'description'),
        engine=pulumi.get(__ret__, 'engine'),
        multi_region_cluster_name=pulumi.get(__ret__, 'multi_region_cluster_name'),
        node_type=pulumi.get(__ret__, 'node_type'),
        num_shards=pulumi.get(__ret__, 'num_shards'),
        status=pulumi.get(__ret__, 'status'),
        tags=pulumi.get(__ret__, 'tags'))
def get_multi_region_cluster_output(multi_region_cluster_name: Optional[pulumi.Input[builtins.str]] = None,
                                    opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetMultiRegionClusterResult]:
    """
    The AWS::MemoryDB::Multi Region Cluster resource creates an Amazon MemoryDB Multi Region Cluster.


    :param builtins.str multi_region_cluster_name: The name of the Global Datastore, it is generated by MemoryDB adding a prefix to MultiRegionClusterNameSuffix.
    """
    __args__ = dict()
    __args__['multiRegionClusterName'] = multi_region_cluster_name
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('aws-native:memorydb:getMultiRegionCluster', __args__, opts=opts, typ=GetMultiRegionClusterResult)
    return __ret__.apply(lambda __response__: GetMultiRegionClusterResult(
        arn=pulumi.get(__response__, 'arn'),
        description=pulumi.get(__response__, 'description'),
        engine=pulumi.get(__response__, 'engine'),
        multi_region_cluster_name=pulumi.get(__response__, 'multi_region_cluster_name'),
        node_type=pulumi.get(__response__, 'node_type'),
        num_shards=pulumi.get(__response__, 'num_shards'),
        status=pulumi.get(__response__, 'status'),
        tags=pulumi.get(__response__, 'tags')))
