# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs
from .. import _inputs as _root_inputs
from .. import outputs as _root_outputs
from ._enums import *
from ._inputs import *

__all__ = ['ClusterArgs', 'Cluster']

@pulumi.input_type
class ClusterArgs:
    def __init__(__self__, *,
                 acl_name: pulumi.Input[builtins.str],
                 node_type: pulumi.Input[builtins.str],
                 auto_minor_version_upgrade: Optional[pulumi.Input[builtins.bool]] = None,
                 cluster_endpoint: Optional[pulumi.Input['ClusterEndpointArgs']] = None,
                 cluster_name: Optional[pulumi.Input[builtins.str]] = None,
                 data_tiering: Optional[pulumi.Input['ClusterDataTieringStatus']] = None,
                 description: Optional[pulumi.Input[builtins.str]] = None,
                 engine: Optional[pulumi.Input[builtins.str]] = None,
                 engine_version: Optional[pulumi.Input[builtins.str]] = None,
                 final_snapshot_name: Optional[pulumi.Input[builtins.str]] = None,
                 ip_discovery: Optional[pulumi.Input['ClusterSupportedIpDiscoveryTypes']] = None,
                 kms_key_id: Optional[pulumi.Input[builtins.str]] = None,
                 maintenance_window: Optional[pulumi.Input[builtins.str]] = None,
                 multi_region_cluster_name: Optional[pulumi.Input[builtins.str]] = None,
                 network_type: Optional[pulumi.Input['ClusterSupportedNetworkTypes']] = None,
                 num_replicas_per_shard: Optional[pulumi.Input[builtins.int]] = None,
                 num_shards: Optional[pulumi.Input[builtins.int]] = None,
                 parameter_group_name: Optional[pulumi.Input[builtins.str]] = None,
                 port: Optional[pulumi.Input[builtins.int]] = None,
                 security_group_ids: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
                 snapshot_arns: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
                 snapshot_name: Optional[pulumi.Input[builtins.str]] = None,
                 snapshot_retention_limit: Optional[pulumi.Input[builtins.int]] = None,
                 snapshot_window: Optional[pulumi.Input[builtins.str]] = None,
                 sns_topic_arn: Optional[pulumi.Input[builtins.str]] = None,
                 sns_topic_status: Optional[pulumi.Input[builtins.str]] = None,
                 subnet_group_name: Optional[pulumi.Input[builtins.str]] = None,
                 tags: Optional[pulumi.Input[Sequence[pulumi.Input['_root_inputs.TagArgs']]]] = None,
                 tls_enabled: Optional[pulumi.Input[builtins.bool]] = None):
        """
        The set of arguments for constructing a Cluster resource.
        :param pulumi.Input[builtins.str] acl_name: The name of the Access Control List to associate with the cluster.
        :param pulumi.Input[builtins.str] node_type: The compute and memory capacity of the nodes in the cluster.
        :param pulumi.Input[builtins.bool] auto_minor_version_upgrade: A flag that enables automatic minor version upgrade when set to true.
               
               You cannot modify the value of AutoMinorVersionUpgrade after the cluster is created. To enable AutoMinorVersionUpgrade on a cluster you must set AutoMinorVersionUpgrade to true when you create a cluster.
        :param pulumi.Input['ClusterEndpointArgs'] cluster_endpoint: The cluster endpoint.
        :param pulumi.Input[builtins.str] cluster_name: The name of the cluster. This value must be unique as it also serves as the cluster identifier.
        :param pulumi.Input['ClusterDataTieringStatus'] data_tiering: Enables data tiering. Data tiering is only supported for clusters using the r6gd node type. This parameter must be set when using r6gd nodes.
        :param pulumi.Input[builtins.str] description: An optional description of the cluster.
        :param pulumi.Input[builtins.str] engine: The engine type used by the cluster.
        :param pulumi.Input[builtins.str] engine_version: The Redis engine version used by the cluster.
        :param pulumi.Input[builtins.str] final_snapshot_name: The user-supplied name of a final cluster snapshot. This is the unique name that identifies the snapshot. MemoryDB creates the snapshot, and then deletes the cluster immediately afterward.
        :param pulumi.Input['ClusterSupportedIpDiscoveryTypes'] ip_discovery: For clusters wth dual stack NetworkType, IpDiscovery controls the Ip protocol (ipv4 or ipv6) returned by the engine commands such as `cluster info` and `cluster nodes` which are used by clients to connect to the nodes in the cluster.
        :param pulumi.Input[builtins.str] kms_key_id: The ID of the KMS key used to encrypt the cluster.
        :param pulumi.Input[builtins.str] maintenance_window: Specifies the weekly time range during which maintenance on the cluster is performed. It is specified as a range in the format ddd:hh24:mi-ddd:hh24:mi (24H Clock UTC). The minimum maintenance window is a 60 minute period.
        :param pulumi.Input[builtins.str] multi_region_cluster_name: The name of the Global Datastore, it is generated by MemoryDB adding a prefix to MultiRegionClusterNameSuffix.
        :param pulumi.Input['ClusterSupportedNetworkTypes'] network_type: Must be either ipv4 | ipv6 | dual_stack.
        :param pulumi.Input[builtins.int] num_replicas_per_shard: The number of replicas to apply to each shard. The limit is 5.
        :param pulumi.Input[builtins.int] num_shards: The number of shards the cluster will contain.
        :param pulumi.Input[builtins.str] parameter_group_name: The name of the parameter group associated with the cluster.
        :param pulumi.Input[builtins.int] port: The port number on which each member of the cluster accepts connections.
        :param pulumi.Input[Sequence[pulumi.Input[builtins.str]]] security_group_ids: One or more Amazon VPC security groups associated with this cluster.
        :param pulumi.Input[Sequence[pulumi.Input[builtins.str]]] snapshot_arns: A list of Amazon Resource Names (ARN) that uniquely identify the RDB snapshot files stored in Amazon S3. The snapshot files are used to populate the new cluster. The Amazon S3 object name in the ARN cannot contain any commas.
        :param pulumi.Input[builtins.str] snapshot_name: The name of a snapshot from which to restore data into the new cluster. The snapshot status changes to restoring while the new cluster is being created.
        :param pulumi.Input[builtins.int] snapshot_retention_limit: The number of days for which MemoryDB retains automatic snapshots before deleting them. For example, if you set SnapshotRetentionLimit to 5, a snapshot that was taken today is retained for 5 days before being deleted.
        :param pulumi.Input[builtins.str] snapshot_window: The daily time range (in UTC) during which MemoryDB begins taking a daily snapshot of your cluster.
        :param pulumi.Input[builtins.str] sns_topic_arn: The Amazon Resource Name (ARN) of the Amazon Simple Notification Service (SNS) topic to which notifications are sent.
        :param pulumi.Input[builtins.str] sns_topic_status: The status of the Amazon SNS notification topic. Notifications are sent only if the status is enabled.
        :param pulumi.Input[builtins.str] subnet_group_name: The name of the subnet group to be used for the cluster.
        :param pulumi.Input[Sequence[pulumi.Input['_root_inputs.TagArgs']]] tags: An array of key-value pairs to apply to this cluster.
        :param pulumi.Input[builtins.bool] tls_enabled: A flag that enables in-transit encryption when set to true.
               
               You cannot modify the value of TransitEncryptionEnabled after the cluster is created. To enable in-transit encryption on a cluster you must set TransitEncryptionEnabled to true when you create a cluster.
        """
        pulumi.set(__self__, "acl_name", acl_name)
        pulumi.set(__self__, "node_type", node_type)
        if auto_minor_version_upgrade is not None:
            pulumi.set(__self__, "auto_minor_version_upgrade", auto_minor_version_upgrade)
        if cluster_endpoint is not None:
            pulumi.set(__self__, "cluster_endpoint", cluster_endpoint)
        if cluster_name is not None:
            pulumi.set(__self__, "cluster_name", cluster_name)
        if data_tiering is not None:
            pulumi.set(__self__, "data_tiering", data_tiering)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if engine is not None:
            pulumi.set(__self__, "engine", engine)
        if engine_version is not None:
            pulumi.set(__self__, "engine_version", engine_version)
        if final_snapshot_name is not None:
            pulumi.set(__self__, "final_snapshot_name", final_snapshot_name)
        if ip_discovery is not None:
            pulumi.set(__self__, "ip_discovery", ip_discovery)
        if kms_key_id is not None:
            pulumi.set(__self__, "kms_key_id", kms_key_id)
        if maintenance_window is not None:
            pulumi.set(__self__, "maintenance_window", maintenance_window)
        if multi_region_cluster_name is not None:
            pulumi.set(__self__, "multi_region_cluster_name", multi_region_cluster_name)
        if network_type is not None:
            pulumi.set(__self__, "network_type", network_type)
        if num_replicas_per_shard is not None:
            pulumi.set(__self__, "num_replicas_per_shard", num_replicas_per_shard)
        if num_shards is not None:
            pulumi.set(__self__, "num_shards", num_shards)
        if parameter_group_name is not None:
            pulumi.set(__self__, "parameter_group_name", parameter_group_name)
        if port is not None:
            pulumi.set(__self__, "port", port)
        if security_group_ids is not None:
            pulumi.set(__self__, "security_group_ids", security_group_ids)
        if snapshot_arns is not None:
            pulumi.set(__self__, "snapshot_arns", snapshot_arns)
        if snapshot_name is not None:
            pulumi.set(__self__, "snapshot_name", snapshot_name)
        if snapshot_retention_limit is not None:
            pulumi.set(__self__, "snapshot_retention_limit", snapshot_retention_limit)
        if snapshot_window is not None:
            pulumi.set(__self__, "snapshot_window", snapshot_window)
        if sns_topic_arn is not None:
            pulumi.set(__self__, "sns_topic_arn", sns_topic_arn)
        if sns_topic_status is not None:
            pulumi.set(__self__, "sns_topic_status", sns_topic_status)
        if subnet_group_name is not None:
            pulumi.set(__self__, "subnet_group_name", subnet_group_name)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)
        if tls_enabled is not None:
            pulumi.set(__self__, "tls_enabled", tls_enabled)

    @property
    @pulumi.getter(name="aclName")
    def acl_name(self) -> pulumi.Input[builtins.str]:
        """
        The name of the Access Control List to associate with the cluster.
        """
        return pulumi.get(self, "acl_name")

    @acl_name.setter
    def acl_name(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "acl_name", value)

    @property
    @pulumi.getter(name="nodeType")
    def node_type(self) -> pulumi.Input[builtins.str]:
        """
        The compute and memory capacity of the nodes in the cluster.
        """
        return pulumi.get(self, "node_type")

    @node_type.setter
    def node_type(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "node_type", value)

    @property
    @pulumi.getter(name="autoMinorVersionUpgrade")
    def auto_minor_version_upgrade(self) -> Optional[pulumi.Input[builtins.bool]]:
        """
        A flag that enables automatic minor version upgrade when set to true.

        You cannot modify the value of AutoMinorVersionUpgrade after the cluster is created. To enable AutoMinorVersionUpgrade on a cluster you must set AutoMinorVersionUpgrade to true when you create a cluster.
        """
        return pulumi.get(self, "auto_minor_version_upgrade")

    @auto_minor_version_upgrade.setter
    def auto_minor_version_upgrade(self, value: Optional[pulumi.Input[builtins.bool]]):
        pulumi.set(self, "auto_minor_version_upgrade", value)

    @property
    @pulumi.getter(name="clusterEndpoint")
    def cluster_endpoint(self) -> Optional[pulumi.Input['ClusterEndpointArgs']]:
        """
        The cluster endpoint.
        """
        return pulumi.get(self, "cluster_endpoint")

    @cluster_endpoint.setter
    def cluster_endpoint(self, value: Optional[pulumi.Input['ClusterEndpointArgs']]):
        pulumi.set(self, "cluster_endpoint", value)

    @property
    @pulumi.getter(name="clusterName")
    def cluster_name(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The name of the cluster. This value must be unique as it also serves as the cluster identifier.
        """
        return pulumi.get(self, "cluster_name")

    @cluster_name.setter
    def cluster_name(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "cluster_name", value)

    @property
    @pulumi.getter(name="dataTiering")
    def data_tiering(self) -> Optional[pulumi.Input['ClusterDataTieringStatus']]:
        """
        Enables data tiering. Data tiering is only supported for clusters using the r6gd node type. This parameter must be set when using r6gd nodes.
        """
        return pulumi.get(self, "data_tiering")

    @data_tiering.setter
    def data_tiering(self, value: Optional[pulumi.Input['ClusterDataTieringStatus']]):
        pulumi.set(self, "data_tiering", value)

    @property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        An optional description of the cluster.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "description", value)

    @property
    @pulumi.getter
    def engine(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The engine type used by the cluster.
        """
        return pulumi.get(self, "engine")

    @engine.setter
    def engine(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "engine", value)

    @property
    @pulumi.getter(name="engineVersion")
    def engine_version(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The Redis engine version used by the cluster.
        """
        return pulumi.get(self, "engine_version")

    @engine_version.setter
    def engine_version(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "engine_version", value)

    @property
    @pulumi.getter(name="finalSnapshotName")
    def final_snapshot_name(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The user-supplied name of a final cluster snapshot. This is the unique name that identifies the snapshot. MemoryDB creates the snapshot, and then deletes the cluster immediately afterward.
        """
        return pulumi.get(self, "final_snapshot_name")

    @final_snapshot_name.setter
    def final_snapshot_name(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "final_snapshot_name", value)

    @property
    @pulumi.getter(name="ipDiscovery")
    def ip_discovery(self) -> Optional[pulumi.Input['ClusterSupportedIpDiscoveryTypes']]:
        """
        For clusters wth dual stack NetworkType, IpDiscovery controls the Ip protocol (ipv4 or ipv6) returned by the engine commands such as `cluster info` and `cluster nodes` which are used by clients to connect to the nodes in the cluster.
        """
        return pulumi.get(self, "ip_discovery")

    @ip_discovery.setter
    def ip_discovery(self, value: Optional[pulumi.Input['ClusterSupportedIpDiscoveryTypes']]):
        pulumi.set(self, "ip_discovery", value)

    @property
    @pulumi.getter(name="kmsKeyId")
    def kms_key_id(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The ID of the KMS key used to encrypt the cluster.
        """
        return pulumi.get(self, "kms_key_id")

    @kms_key_id.setter
    def kms_key_id(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "kms_key_id", value)

    @property
    @pulumi.getter(name="maintenanceWindow")
    def maintenance_window(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Specifies the weekly time range during which maintenance on the cluster is performed. It is specified as a range in the format ddd:hh24:mi-ddd:hh24:mi (24H Clock UTC). The minimum maintenance window is a 60 minute period.
        """
        return pulumi.get(self, "maintenance_window")

    @maintenance_window.setter
    def maintenance_window(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "maintenance_window", value)

    @property
    @pulumi.getter(name="multiRegionClusterName")
    def multi_region_cluster_name(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The name of the Global Datastore, it is generated by MemoryDB adding a prefix to MultiRegionClusterNameSuffix.
        """
        return pulumi.get(self, "multi_region_cluster_name")

    @multi_region_cluster_name.setter
    def multi_region_cluster_name(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "multi_region_cluster_name", value)

    @property
    @pulumi.getter(name="networkType")
    def network_type(self) -> Optional[pulumi.Input['ClusterSupportedNetworkTypes']]:
        """
        Must be either ipv4 | ipv6 | dual_stack.
        """
        return pulumi.get(self, "network_type")

    @network_type.setter
    def network_type(self, value: Optional[pulumi.Input['ClusterSupportedNetworkTypes']]):
        pulumi.set(self, "network_type", value)

    @property
    @pulumi.getter(name="numReplicasPerShard")
    def num_replicas_per_shard(self) -> Optional[pulumi.Input[builtins.int]]:
        """
        The number of replicas to apply to each shard. The limit is 5.
        """
        return pulumi.get(self, "num_replicas_per_shard")

    @num_replicas_per_shard.setter
    def num_replicas_per_shard(self, value: Optional[pulumi.Input[builtins.int]]):
        pulumi.set(self, "num_replicas_per_shard", value)

    @property
    @pulumi.getter(name="numShards")
    def num_shards(self) -> Optional[pulumi.Input[builtins.int]]:
        """
        The number of shards the cluster will contain.
        """
        return pulumi.get(self, "num_shards")

    @num_shards.setter
    def num_shards(self, value: Optional[pulumi.Input[builtins.int]]):
        pulumi.set(self, "num_shards", value)

    @property
    @pulumi.getter(name="parameterGroupName")
    def parameter_group_name(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The name of the parameter group associated with the cluster.
        """
        return pulumi.get(self, "parameter_group_name")

    @parameter_group_name.setter
    def parameter_group_name(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "parameter_group_name", value)

    @property
    @pulumi.getter
    def port(self) -> Optional[pulumi.Input[builtins.int]]:
        """
        The port number on which each member of the cluster accepts connections.
        """
        return pulumi.get(self, "port")

    @port.setter
    def port(self, value: Optional[pulumi.Input[builtins.int]]):
        pulumi.set(self, "port", value)

    @property
    @pulumi.getter(name="securityGroupIds")
    def security_group_ids(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]:
        """
        One or more Amazon VPC security groups associated with this cluster.
        """
        return pulumi.get(self, "security_group_ids")

    @security_group_ids.setter
    def security_group_ids(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "security_group_ids", value)

    @property
    @pulumi.getter(name="snapshotArns")
    def snapshot_arns(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]:
        """
        A list of Amazon Resource Names (ARN) that uniquely identify the RDB snapshot files stored in Amazon S3. The snapshot files are used to populate the new cluster. The Amazon S3 object name in the ARN cannot contain any commas.
        """
        return pulumi.get(self, "snapshot_arns")

    @snapshot_arns.setter
    def snapshot_arns(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "snapshot_arns", value)

    @property
    @pulumi.getter(name="snapshotName")
    def snapshot_name(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The name of a snapshot from which to restore data into the new cluster. The snapshot status changes to restoring while the new cluster is being created.
        """
        return pulumi.get(self, "snapshot_name")

    @snapshot_name.setter
    def snapshot_name(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "snapshot_name", value)

    @property
    @pulumi.getter(name="snapshotRetentionLimit")
    def snapshot_retention_limit(self) -> Optional[pulumi.Input[builtins.int]]:
        """
        The number of days for which MemoryDB retains automatic snapshots before deleting them. For example, if you set SnapshotRetentionLimit to 5, a snapshot that was taken today is retained for 5 days before being deleted.
        """
        return pulumi.get(self, "snapshot_retention_limit")

    @snapshot_retention_limit.setter
    def snapshot_retention_limit(self, value: Optional[pulumi.Input[builtins.int]]):
        pulumi.set(self, "snapshot_retention_limit", value)

    @property
    @pulumi.getter(name="snapshotWindow")
    def snapshot_window(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The daily time range (in UTC) during which MemoryDB begins taking a daily snapshot of your cluster.
        """
        return pulumi.get(self, "snapshot_window")

    @snapshot_window.setter
    def snapshot_window(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "snapshot_window", value)

    @property
    @pulumi.getter(name="snsTopicArn")
    def sns_topic_arn(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The Amazon Resource Name (ARN) of the Amazon Simple Notification Service (SNS) topic to which notifications are sent.
        """
        return pulumi.get(self, "sns_topic_arn")

    @sns_topic_arn.setter
    def sns_topic_arn(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "sns_topic_arn", value)

    @property
    @pulumi.getter(name="snsTopicStatus")
    def sns_topic_status(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The status of the Amazon SNS notification topic. Notifications are sent only if the status is enabled.
        """
        return pulumi.get(self, "sns_topic_status")

    @sns_topic_status.setter
    def sns_topic_status(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "sns_topic_status", value)

    @property
    @pulumi.getter(name="subnetGroupName")
    def subnet_group_name(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The name of the subnet group to be used for the cluster.
        """
        return pulumi.get(self, "subnet_group_name")

    @subnet_group_name.setter
    def subnet_group_name(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "subnet_group_name", value)

    @property
    @pulumi.getter
    def tags(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['_root_inputs.TagArgs']]]]:
        """
        An array of key-value pairs to apply to this cluster.
        """
        return pulumi.get(self, "tags")

    @tags.setter
    def tags(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['_root_inputs.TagArgs']]]]):
        pulumi.set(self, "tags", value)

    @property
    @pulumi.getter(name="tlsEnabled")
    def tls_enabled(self) -> Optional[pulumi.Input[builtins.bool]]:
        """
        A flag that enables in-transit encryption when set to true.

        You cannot modify the value of TransitEncryptionEnabled after the cluster is created. To enable in-transit encryption on a cluster you must set TransitEncryptionEnabled to true when you create a cluster.
        """
        return pulumi.get(self, "tls_enabled")

    @tls_enabled.setter
    def tls_enabled(self, value: Optional[pulumi.Input[builtins.bool]]):
        pulumi.set(self, "tls_enabled", value)


@pulumi.type_token("aws-native:memorydb:Cluster")
class Cluster(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 acl_name: Optional[pulumi.Input[builtins.str]] = None,
                 auto_minor_version_upgrade: Optional[pulumi.Input[builtins.bool]] = None,
                 cluster_endpoint: Optional[pulumi.Input[Union['ClusterEndpointArgs', 'ClusterEndpointArgsDict']]] = None,
                 cluster_name: Optional[pulumi.Input[builtins.str]] = None,
                 data_tiering: Optional[pulumi.Input['ClusterDataTieringStatus']] = None,
                 description: Optional[pulumi.Input[builtins.str]] = None,
                 engine: Optional[pulumi.Input[builtins.str]] = None,
                 engine_version: Optional[pulumi.Input[builtins.str]] = None,
                 final_snapshot_name: Optional[pulumi.Input[builtins.str]] = None,
                 ip_discovery: Optional[pulumi.Input['ClusterSupportedIpDiscoveryTypes']] = None,
                 kms_key_id: Optional[pulumi.Input[builtins.str]] = None,
                 maintenance_window: Optional[pulumi.Input[builtins.str]] = None,
                 multi_region_cluster_name: Optional[pulumi.Input[builtins.str]] = None,
                 network_type: Optional[pulumi.Input['ClusterSupportedNetworkTypes']] = None,
                 node_type: Optional[pulumi.Input[builtins.str]] = None,
                 num_replicas_per_shard: Optional[pulumi.Input[builtins.int]] = None,
                 num_shards: Optional[pulumi.Input[builtins.int]] = None,
                 parameter_group_name: Optional[pulumi.Input[builtins.str]] = None,
                 port: Optional[pulumi.Input[builtins.int]] = None,
                 security_group_ids: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
                 snapshot_arns: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
                 snapshot_name: Optional[pulumi.Input[builtins.str]] = None,
                 snapshot_retention_limit: Optional[pulumi.Input[builtins.int]] = None,
                 snapshot_window: Optional[pulumi.Input[builtins.str]] = None,
                 sns_topic_arn: Optional[pulumi.Input[builtins.str]] = None,
                 sns_topic_status: Optional[pulumi.Input[builtins.str]] = None,
                 subnet_group_name: Optional[pulumi.Input[builtins.str]] = None,
                 tags: Optional[pulumi.Input[Sequence[pulumi.Input[Union['_root_inputs.TagArgs', '_root_inputs.TagArgsDict']]]]] = None,
                 tls_enabled: Optional[pulumi.Input[builtins.bool]] = None,
                 __props__=None):
        """
        The AWS::MemoryDB::Cluster resource creates an Amazon MemoryDB Cluster.

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[builtins.str] acl_name: The name of the Access Control List to associate with the cluster.
        :param pulumi.Input[builtins.bool] auto_minor_version_upgrade: A flag that enables automatic minor version upgrade when set to true.
               
               You cannot modify the value of AutoMinorVersionUpgrade after the cluster is created. To enable AutoMinorVersionUpgrade on a cluster you must set AutoMinorVersionUpgrade to true when you create a cluster.
        :param pulumi.Input[Union['ClusterEndpointArgs', 'ClusterEndpointArgsDict']] cluster_endpoint: The cluster endpoint.
        :param pulumi.Input[builtins.str] cluster_name: The name of the cluster. This value must be unique as it also serves as the cluster identifier.
        :param pulumi.Input['ClusterDataTieringStatus'] data_tiering: Enables data tiering. Data tiering is only supported for clusters using the r6gd node type. This parameter must be set when using r6gd nodes.
        :param pulumi.Input[builtins.str] description: An optional description of the cluster.
        :param pulumi.Input[builtins.str] engine: The engine type used by the cluster.
        :param pulumi.Input[builtins.str] engine_version: The Redis engine version used by the cluster.
        :param pulumi.Input[builtins.str] final_snapshot_name: The user-supplied name of a final cluster snapshot. This is the unique name that identifies the snapshot. MemoryDB creates the snapshot, and then deletes the cluster immediately afterward.
        :param pulumi.Input['ClusterSupportedIpDiscoveryTypes'] ip_discovery: For clusters wth dual stack NetworkType, IpDiscovery controls the Ip protocol (ipv4 or ipv6) returned by the engine commands such as `cluster info` and `cluster nodes` which are used by clients to connect to the nodes in the cluster.
        :param pulumi.Input[builtins.str] kms_key_id: The ID of the KMS key used to encrypt the cluster.
        :param pulumi.Input[builtins.str] maintenance_window: Specifies the weekly time range during which maintenance on the cluster is performed. It is specified as a range in the format ddd:hh24:mi-ddd:hh24:mi (24H Clock UTC). The minimum maintenance window is a 60 minute period.
        :param pulumi.Input[builtins.str] multi_region_cluster_name: The name of the Global Datastore, it is generated by MemoryDB adding a prefix to MultiRegionClusterNameSuffix.
        :param pulumi.Input['ClusterSupportedNetworkTypes'] network_type: Must be either ipv4 | ipv6 | dual_stack.
        :param pulumi.Input[builtins.str] node_type: The compute and memory capacity of the nodes in the cluster.
        :param pulumi.Input[builtins.int] num_replicas_per_shard: The number of replicas to apply to each shard. The limit is 5.
        :param pulumi.Input[builtins.int] num_shards: The number of shards the cluster will contain.
        :param pulumi.Input[builtins.str] parameter_group_name: The name of the parameter group associated with the cluster.
        :param pulumi.Input[builtins.int] port: The port number on which each member of the cluster accepts connections.
        :param pulumi.Input[Sequence[pulumi.Input[builtins.str]]] security_group_ids: One or more Amazon VPC security groups associated with this cluster.
        :param pulumi.Input[Sequence[pulumi.Input[builtins.str]]] snapshot_arns: A list of Amazon Resource Names (ARN) that uniquely identify the RDB snapshot files stored in Amazon S3. The snapshot files are used to populate the new cluster. The Amazon S3 object name in the ARN cannot contain any commas.
        :param pulumi.Input[builtins.str] snapshot_name: The name of a snapshot from which to restore data into the new cluster. The snapshot status changes to restoring while the new cluster is being created.
        :param pulumi.Input[builtins.int] snapshot_retention_limit: The number of days for which MemoryDB retains automatic snapshots before deleting them. For example, if you set SnapshotRetentionLimit to 5, a snapshot that was taken today is retained for 5 days before being deleted.
        :param pulumi.Input[builtins.str] snapshot_window: The daily time range (in UTC) during which MemoryDB begins taking a daily snapshot of your cluster.
        :param pulumi.Input[builtins.str] sns_topic_arn: The Amazon Resource Name (ARN) of the Amazon Simple Notification Service (SNS) topic to which notifications are sent.
        :param pulumi.Input[builtins.str] sns_topic_status: The status of the Amazon SNS notification topic. Notifications are sent only if the status is enabled.
        :param pulumi.Input[builtins.str] subnet_group_name: The name of the subnet group to be used for the cluster.
        :param pulumi.Input[Sequence[pulumi.Input[Union['_root_inputs.TagArgs', '_root_inputs.TagArgsDict']]]] tags: An array of key-value pairs to apply to this cluster.
        :param pulumi.Input[builtins.bool] tls_enabled: A flag that enables in-transit encryption when set to true.
               
               You cannot modify the value of TransitEncryptionEnabled after the cluster is created. To enable in-transit encryption on a cluster you must set TransitEncryptionEnabled to true when you create a cluster.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: ClusterArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        The AWS::MemoryDB::Cluster resource creates an Amazon MemoryDB Cluster.

        :param str resource_name: The name of the resource.
        :param ClusterArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(ClusterArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 acl_name: Optional[pulumi.Input[builtins.str]] = None,
                 auto_minor_version_upgrade: Optional[pulumi.Input[builtins.bool]] = None,
                 cluster_endpoint: Optional[pulumi.Input[Union['ClusterEndpointArgs', 'ClusterEndpointArgsDict']]] = None,
                 cluster_name: Optional[pulumi.Input[builtins.str]] = None,
                 data_tiering: Optional[pulumi.Input['ClusterDataTieringStatus']] = None,
                 description: Optional[pulumi.Input[builtins.str]] = None,
                 engine: Optional[pulumi.Input[builtins.str]] = None,
                 engine_version: Optional[pulumi.Input[builtins.str]] = None,
                 final_snapshot_name: Optional[pulumi.Input[builtins.str]] = None,
                 ip_discovery: Optional[pulumi.Input['ClusterSupportedIpDiscoveryTypes']] = None,
                 kms_key_id: Optional[pulumi.Input[builtins.str]] = None,
                 maintenance_window: Optional[pulumi.Input[builtins.str]] = None,
                 multi_region_cluster_name: Optional[pulumi.Input[builtins.str]] = None,
                 network_type: Optional[pulumi.Input['ClusterSupportedNetworkTypes']] = None,
                 node_type: Optional[pulumi.Input[builtins.str]] = None,
                 num_replicas_per_shard: Optional[pulumi.Input[builtins.int]] = None,
                 num_shards: Optional[pulumi.Input[builtins.int]] = None,
                 parameter_group_name: Optional[pulumi.Input[builtins.str]] = None,
                 port: Optional[pulumi.Input[builtins.int]] = None,
                 security_group_ids: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
                 snapshot_arns: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
                 snapshot_name: Optional[pulumi.Input[builtins.str]] = None,
                 snapshot_retention_limit: Optional[pulumi.Input[builtins.int]] = None,
                 snapshot_window: Optional[pulumi.Input[builtins.str]] = None,
                 sns_topic_arn: Optional[pulumi.Input[builtins.str]] = None,
                 sns_topic_status: Optional[pulumi.Input[builtins.str]] = None,
                 subnet_group_name: Optional[pulumi.Input[builtins.str]] = None,
                 tags: Optional[pulumi.Input[Sequence[pulumi.Input[Union['_root_inputs.TagArgs', '_root_inputs.TagArgsDict']]]]] = None,
                 tls_enabled: Optional[pulumi.Input[builtins.bool]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = ClusterArgs.__new__(ClusterArgs)

            if acl_name is None and not opts.urn:
                raise TypeError("Missing required property 'acl_name'")
            __props__.__dict__["acl_name"] = acl_name
            __props__.__dict__["auto_minor_version_upgrade"] = auto_minor_version_upgrade
            __props__.__dict__["cluster_endpoint"] = cluster_endpoint
            __props__.__dict__["cluster_name"] = cluster_name
            __props__.__dict__["data_tiering"] = data_tiering
            __props__.__dict__["description"] = description
            __props__.__dict__["engine"] = engine
            __props__.__dict__["engine_version"] = engine_version
            __props__.__dict__["final_snapshot_name"] = final_snapshot_name
            __props__.__dict__["ip_discovery"] = ip_discovery
            __props__.__dict__["kms_key_id"] = kms_key_id
            __props__.__dict__["maintenance_window"] = maintenance_window
            __props__.__dict__["multi_region_cluster_name"] = multi_region_cluster_name
            __props__.__dict__["network_type"] = network_type
            if node_type is None and not opts.urn:
                raise TypeError("Missing required property 'node_type'")
            __props__.__dict__["node_type"] = node_type
            __props__.__dict__["num_replicas_per_shard"] = num_replicas_per_shard
            __props__.__dict__["num_shards"] = num_shards
            __props__.__dict__["parameter_group_name"] = parameter_group_name
            __props__.__dict__["port"] = port
            __props__.__dict__["security_group_ids"] = security_group_ids
            __props__.__dict__["snapshot_arns"] = snapshot_arns
            __props__.__dict__["snapshot_name"] = snapshot_name
            __props__.__dict__["snapshot_retention_limit"] = snapshot_retention_limit
            __props__.__dict__["snapshot_window"] = snapshot_window
            __props__.__dict__["sns_topic_arn"] = sns_topic_arn
            __props__.__dict__["sns_topic_status"] = sns_topic_status
            __props__.__dict__["subnet_group_name"] = subnet_group_name
            __props__.__dict__["tags"] = tags
            __props__.__dict__["tls_enabled"] = tls_enabled
            __props__.__dict__["arn"] = None
            __props__.__dict__["parameter_group_status"] = None
            __props__.__dict__["status"] = None
        replace_on_changes = pulumi.ResourceOptions(replace_on_changes=["clusterName", "dataTiering", "kmsKeyId", "multiRegionClusterName", "networkType", "port", "snapshotArns[*]", "snapshotName", "subnetGroupName", "tlsEnabled"])
        opts = pulumi.ResourceOptions.merge(opts, replace_on_changes)
        super(Cluster, __self__).__init__(
            'aws-native:memorydb:Cluster',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None) -> 'Cluster':
        """
        Get an existing Cluster resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = ClusterArgs.__new__(ClusterArgs)

        __props__.__dict__["acl_name"] = None
        __props__.__dict__["arn"] = None
        __props__.__dict__["auto_minor_version_upgrade"] = None
        __props__.__dict__["cluster_endpoint"] = None
        __props__.__dict__["cluster_name"] = None
        __props__.__dict__["data_tiering"] = None
        __props__.__dict__["description"] = None
        __props__.__dict__["engine"] = None
        __props__.__dict__["engine_version"] = None
        __props__.__dict__["final_snapshot_name"] = None
        __props__.__dict__["ip_discovery"] = None
        __props__.__dict__["kms_key_id"] = None
        __props__.__dict__["maintenance_window"] = None
        __props__.__dict__["multi_region_cluster_name"] = None
        __props__.__dict__["network_type"] = None
        __props__.__dict__["node_type"] = None
        __props__.__dict__["num_replicas_per_shard"] = None
        __props__.__dict__["num_shards"] = None
        __props__.__dict__["parameter_group_name"] = None
        __props__.__dict__["parameter_group_status"] = None
        __props__.__dict__["port"] = None
        __props__.__dict__["security_group_ids"] = None
        __props__.__dict__["snapshot_arns"] = None
        __props__.__dict__["snapshot_name"] = None
        __props__.__dict__["snapshot_retention_limit"] = None
        __props__.__dict__["snapshot_window"] = None
        __props__.__dict__["sns_topic_arn"] = None
        __props__.__dict__["sns_topic_status"] = None
        __props__.__dict__["status"] = None
        __props__.__dict__["subnet_group_name"] = None
        __props__.__dict__["tags"] = None
        __props__.__dict__["tls_enabled"] = None
        return Cluster(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter(name="aclName")
    def acl_name(self) -> pulumi.Output[builtins.str]:
        """
        The name of the Access Control List to associate with the cluster.
        """
        return pulumi.get(self, "acl_name")

    @property
    @pulumi.getter
    def arn(self) -> pulumi.Output[builtins.str]:
        """
        The Amazon Resource Name (ARN) of the cluster.
        """
        return pulumi.get(self, "arn")

    @property
    @pulumi.getter(name="autoMinorVersionUpgrade")
    def auto_minor_version_upgrade(self) -> pulumi.Output[Optional[builtins.bool]]:
        """
        A flag that enables automatic minor version upgrade when set to true.

        You cannot modify the value of AutoMinorVersionUpgrade after the cluster is created. To enable AutoMinorVersionUpgrade on a cluster you must set AutoMinorVersionUpgrade to true when you create a cluster.
        """
        return pulumi.get(self, "auto_minor_version_upgrade")

    @property
    @pulumi.getter(name="clusterEndpoint")
    def cluster_endpoint(self) -> pulumi.Output[Optional['outputs.ClusterEndpoint']]:
        """
        The cluster endpoint.
        """
        return pulumi.get(self, "cluster_endpoint")

    @property
    @pulumi.getter(name="clusterName")
    def cluster_name(self) -> pulumi.Output[builtins.str]:
        """
        The name of the cluster. This value must be unique as it also serves as the cluster identifier.
        """
        return pulumi.get(self, "cluster_name")

    @property
    @pulumi.getter(name="dataTiering")
    def data_tiering(self) -> pulumi.Output[Optional['ClusterDataTieringStatus']]:
        """
        Enables data tiering. Data tiering is only supported for clusters using the r6gd node type. This parameter must be set when using r6gd nodes.
        """
        return pulumi.get(self, "data_tiering")

    @property
    @pulumi.getter
    def description(self) -> pulumi.Output[Optional[builtins.str]]:
        """
        An optional description of the cluster.
        """
        return pulumi.get(self, "description")

    @property
    @pulumi.getter
    def engine(self) -> pulumi.Output[Optional[builtins.str]]:
        """
        The engine type used by the cluster.
        """
        return pulumi.get(self, "engine")

    @property
    @pulumi.getter(name="engineVersion")
    def engine_version(self) -> pulumi.Output[Optional[builtins.str]]:
        """
        The Redis engine version used by the cluster.
        """
        return pulumi.get(self, "engine_version")

    @property
    @pulumi.getter(name="finalSnapshotName")
    def final_snapshot_name(self) -> pulumi.Output[Optional[builtins.str]]:
        """
        The user-supplied name of a final cluster snapshot. This is the unique name that identifies the snapshot. MemoryDB creates the snapshot, and then deletes the cluster immediately afterward.
        """
        return pulumi.get(self, "final_snapshot_name")

    @property
    @pulumi.getter(name="ipDiscovery")
    def ip_discovery(self) -> pulumi.Output[Optional['ClusterSupportedIpDiscoveryTypes']]:
        """
        For clusters wth dual stack NetworkType, IpDiscovery controls the Ip protocol (ipv4 or ipv6) returned by the engine commands such as `cluster info` and `cluster nodes` which are used by clients to connect to the nodes in the cluster.
        """
        return pulumi.get(self, "ip_discovery")

    @property
    @pulumi.getter(name="kmsKeyId")
    def kms_key_id(self) -> pulumi.Output[Optional[builtins.str]]:
        """
        The ID of the KMS key used to encrypt the cluster.
        """
        return pulumi.get(self, "kms_key_id")

    @property
    @pulumi.getter(name="maintenanceWindow")
    def maintenance_window(self) -> pulumi.Output[Optional[builtins.str]]:
        """
        Specifies the weekly time range during which maintenance on the cluster is performed. It is specified as a range in the format ddd:hh24:mi-ddd:hh24:mi (24H Clock UTC). The minimum maintenance window is a 60 minute period.
        """
        return pulumi.get(self, "maintenance_window")

    @property
    @pulumi.getter(name="multiRegionClusterName")
    def multi_region_cluster_name(self) -> pulumi.Output[Optional[builtins.str]]:
        """
        The name of the Global Datastore, it is generated by MemoryDB adding a prefix to MultiRegionClusterNameSuffix.
        """
        return pulumi.get(self, "multi_region_cluster_name")

    @property
    @pulumi.getter(name="networkType")
    def network_type(self) -> pulumi.Output[Optional['ClusterSupportedNetworkTypes']]:
        """
        Must be either ipv4 | ipv6 | dual_stack.
        """
        return pulumi.get(self, "network_type")

    @property
    @pulumi.getter(name="nodeType")
    def node_type(self) -> pulumi.Output[builtins.str]:
        """
        The compute and memory capacity of the nodes in the cluster.
        """
        return pulumi.get(self, "node_type")

    @property
    @pulumi.getter(name="numReplicasPerShard")
    def num_replicas_per_shard(self) -> pulumi.Output[Optional[builtins.int]]:
        """
        The number of replicas to apply to each shard. The limit is 5.
        """
        return pulumi.get(self, "num_replicas_per_shard")

    @property
    @pulumi.getter(name="numShards")
    def num_shards(self) -> pulumi.Output[Optional[builtins.int]]:
        """
        The number of shards the cluster will contain.
        """
        return pulumi.get(self, "num_shards")

    @property
    @pulumi.getter(name="parameterGroupName")
    def parameter_group_name(self) -> pulumi.Output[Optional[builtins.str]]:
        """
        The name of the parameter group associated with the cluster.
        """
        return pulumi.get(self, "parameter_group_name")

    @property
    @pulumi.getter(name="parameterGroupStatus")
    def parameter_group_status(self) -> pulumi.Output[builtins.str]:
        """
        The status of the parameter group used by the cluster.
        """
        return pulumi.get(self, "parameter_group_status")

    @property
    @pulumi.getter
    def port(self) -> pulumi.Output[Optional[builtins.int]]:
        """
        The port number on which each member of the cluster accepts connections.
        """
        return pulumi.get(self, "port")

    @property
    @pulumi.getter(name="securityGroupIds")
    def security_group_ids(self) -> pulumi.Output[Optional[Sequence[builtins.str]]]:
        """
        One or more Amazon VPC security groups associated with this cluster.
        """
        return pulumi.get(self, "security_group_ids")

    @property
    @pulumi.getter(name="snapshotArns")
    def snapshot_arns(self) -> pulumi.Output[Optional[Sequence[builtins.str]]]:
        """
        A list of Amazon Resource Names (ARN) that uniquely identify the RDB snapshot files stored in Amazon S3. The snapshot files are used to populate the new cluster. The Amazon S3 object name in the ARN cannot contain any commas.
        """
        return pulumi.get(self, "snapshot_arns")

    @property
    @pulumi.getter(name="snapshotName")
    def snapshot_name(self) -> pulumi.Output[Optional[builtins.str]]:
        """
        The name of a snapshot from which to restore data into the new cluster. The snapshot status changes to restoring while the new cluster is being created.
        """
        return pulumi.get(self, "snapshot_name")

    @property
    @pulumi.getter(name="snapshotRetentionLimit")
    def snapshot_retention_limit(self) -> pulumi.Output[Optional[builtins.int]]:
        """
        The number of days for which MemoryDB retains automatic snapshots before deleting them. For example, if you set SnapshotRetentionLimit to 5, a snapshot that was taken today is retained for 5 days before being deleted.
        """
        return pulumi.get(self, "snapshot_retention_limit")

    @property
    @pulumi.getter(name="snapshotWindow")
    def snapshot_window(self) -> pulumi.Output[Optional[builtins.str]]:
        """
        The daily time range (in UTC) during which MemoryDB begins taking a daily snapshot of your cluster.
        """
        return pulumi.get(self, "snapshot_window")

    @property
    @pulumi.getter(name="snsTopicArn")
    def sns_topic_arn(self) -> pulumi.Output[Optional[builtins.str]]:
        """
        The Amazon Resource Name (ARN) of the Amazon Simple Notification Service (SNS) topic to which notifications are sent.
        """
        return pulumi.get(self, "sns_topic_arn")

    @property
    @pulumi.getter(name="snsTopicStatus")
    def sns_topic_status(self) -> pulumi.Output[Optional[builtins.str]]:
        """
        The status of the Amazon SNS notification topic. Notifications are sent only if the status is enabled.
        """
        return pulumi.get(self, "sns_topic_status")

    @property
    @pulumi.getter
    def status(self) -> pulumi.Output[builtins.str]:
        """
        The status of the cluster. For example, Available, Updating, Creating.
        """
        return pulumi.get(self, "status")

    @property
    @pulumi.getter(name="subnetGroupName")
    def subnet_group_name(self) -> pulumi.Output[Optional[builtins.str]]:
        """
        The name of the subnet group to be used for the cluster.
        """
        return pulumi.get(self, "subnet_group_name")

    @property
    @pulumi.getter
    def tags(self) -> pulumi.Output[Optional[Sequence['_root_outputs.Tag']]]:
        """
        An array of key-value pairs to apply to this cluster.
        """
        return pulumi.get(self, "tags")

    @property
    @pulumi.getter(name="tlsEnabled")
    def tls_enabled(self) -> pulumi.Output[Optional[builtins.bool]]:
        """
        A flag that enables in-transit encryption when set to true.

        You cannot modify the value of TransitEncryptionEnabled after the cluster is created. To enable in-transit encryption on a cluster you must set TransitEncryptionEnabled to true when you create a cluster.
        """
        return pulumi.get(self, "tls_enabled")

