# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from ._enums import *

__all__ = [
    'AuthenticationModePropertiesArgs',
    'AuthenticationModePropertiesArgsDict',
    'ClusterEndpointArgs',
    'ClusterEndpointArgsDict',
]

MYPY = False

if not MYPY:
    class AuthenticationModePropertiesArgsDict(TypedDict):
        """
        Denotes whether the user requires a password to authenticate.

        *Example:*

        `mynewdbuser: Type: AWS::MemoryDB::User Properties: AccessString: on ~* &* +@all AuthenticationMode: Passwords: '1234567890123456' Type: password UserName: mynewdbuser AuthenticationMode: { "Passwords": ["1234567890123456"], "Type": "Password" }`
        """
        passwords: NotRequired[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]
        """
        Passwords used for this user account. You can create up to two passwords for each user.
        """
        type: NotRequired[pulumi.Input['UserAuthenticationModePropertiesType']]
        """
        Type of authentication strategy for this user.
        """
elif False:
    AuthenticationModePropertiesArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class AuthenticationModePropertiesArgs:
    def __init__(__self__, *,
                 passwords: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
                 type: Optional[pulumi.Input['UserAuthenticationModePropertiesType']] = None):
        """
        Denotes whether the user requires a password to authenticate.

        *Example:*

        `mynewdbuser: Type: AWS::MemoryDB::User Properties: AccessString: on ~* &* +@all AuthenticationMode: Passwords: '1234567890123456' Type: password UserName: mynewdbuser AuthenticationMode: { "Passwords": ["1234567890123456"], "Type": "Password" }`
        :param pulumi.Input[Sequence[pulumi.Input[builtins.str]]] passwords: Passwords used for this user account. You can create up to two passwords for each user.
        :param pulumi.Input['UserAuthenticationModePropertiesType'] type: Type of authentication strategy for this user.
        """
        if passwords is not None:
            pulumi.set(__self__, "passwords", passwords)
        if type is not None:
            pulumi.set(__self__, "type", type)

    @property
    @pulumi.getter
    def passwords(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]:
        """
        Passwords used for this user account. You can create up to two passwords for each user.
        """
        return pulumi.get(self, "passwords")

    @passwords.setter
    def passwords(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "passwords", value)

    @property
    @pulumi.getter
    def type(self) -> Optional[pulumi.Input['UserAuthenticationModePropertiesType']]:
        """
        Type of authentication strategy for this user.
        """
        return pulumi.get(self, "type")

    @type.setter
    def type(self, value: Optional[pulumi.Input['UserAuthenticationModePropertiesType']]):
        pulumi.set(self, "type", value)


if not MYPY:
    class ClusterEndpointArgsDict(TypedDict):
        address: NotRequired[pulumi.Input[builtins.str]]
        """
        The DNS address of the primary read-write node.
        """
        port: NotRequired[pulumi.Input[builtins.int]]
        """
        The port number that the engine is listening on. 
        """
elif False:
    ClusterEndpointArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class ClusterEndpointArgs:
    def __init__(__self__, *,
                 address: Optional[pulumi.Input[builtins.str]] = None,
                 port: Optional[pulumi.Input[builtins.int]] = None):
        """
        :param pulumi.Input[builtins.str] address: The DNS address of the primary read-write node.
        :param pulumi.Input[builtins.int] port: The port number that the engine is listening on. 
        """
        if address is not None:
            pulumi.set(__self__, "address", address)
        if port is not None:
            pulumi.set(__self__, "port", port)

    @property
    @pulumi.getter
    def address(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The DNS address of the primary read-write node.
        """
        return pulumi.get(self, "address")

    @address.setter
    def address(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "address", value)

    @property
    @pulumi.getter
    def port(self) -> Optional[pulumi.Input[builtins.int]]:
        """
        The port number that the engine is listening on. 
        """
        return pulumi.get(self, "port")

    @port.setter
    def port(self, value: Optional[pulumi.Input[builtins.int]]):
        pulumi.set(self, "port", value)


