# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs
from ._enums import *

__all__ = [
    'ChannelDashPlaylistSettings',
    'ChannelHlsPlaylistSettings',
    'ChannelLogConfigurationForChannel',
    'ChannelRequestOutputItem',
    'ChannelSlateSource',
    'ChannelTimeShiftConfiguration',
    'LiveSourceHttpPackageConfiguration',
    'PlaybackConfigurationAdConditioningConfiguration',
    'PlaybackConfigurationAdMarkerPassthrough',
    'PlaybackConfigurationAvailSuppression',
    'PlaybackConfigurationBumper',
    'PlaybackConfigurationCdnConfiguration',
    'PlaybackConfigurationDashConfiguration',
    'PlaybackConfigurationHlsConfiguration',
    'PlaybackConfigurationLivePreRollConfiguration',
    'PlaybackConfigurationManifestProcessingRules',
    'SourceLocationAccessConfiguration',
    'SourceLocationDefaultSegmentDeliveryConfiguration',
    'SourceLocationHttpConfiguration',
    'SourceLocationSecretsManagerAccessTokenConfiguration',
    'SourceLocationSegmentDeliveryConfiguration',
    'VodSourceHttpPackageConfiguration',
]

@pulumi.output_type
class ChannelDashPlaylistSettings(dict):
    """
    <p>Dash manifest configuration parameters.</p>
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "manifestWindowSeconds":
            suggest = "manifest_window_seconds"
        elif key == "minBufferTimeSeconds":
            suggest = "min_buffer_time_seconds"
        elif key == "minUpdatePeriodSeconds":
            suggest = "min_update_period_seconds"
        elif key == "suggestedPresentationDelaySeconds":
            suggest = "suggested_presentation_delay_seconds"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ChannelDashPlaylistSettings. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ChannelDashPlaylistSettings.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ChannelDashPlaylistSettings.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 manifest_window_seconds: Optional[builtins.float] = None,
                 min_buffer_time_seconds: Optional[builtins.float] = None,
                 min_update_period_seconds: Optional[builtins.float] = None,
                 suggested_presentation_delay_seconds: Optional[builtins.float] = None):
        """
        <p>Dash manifest configuration parameters.</p>
        :param builtins.float manifest_window_seconds: <p>The total duration (in seconds) of each manifest. Minimum value: <code>30</code> seconds. Maximum value: <code>3600</code> seconds.</p>
        :param builtins.float min_buffer_time_seconds: <p>Minimum amount of content (measured in seconds) that a player must keep available in the buffer. Minimum value: <code>2</code> seconds. Maximum value: <code>60</code> seconds.</p>
        :param builtins.float min_update_period_seconds: <p>Minimum amount of time (in seconds) that the player should wait before requesting updates to the manifest. Minimum value: <code>2</code> seconds. Maximum value: <code>60</code> seconds.</p>
        :param builtins.float suggested_presentation_delay_seconds: <p>Amount of time (in seconds) that the player should be from the live point at the end of the manifest. Minimum value: <code>2</code> seconds. Maximum value: <code>60</code> seconds.</p>
        """
        if manifest_window_seconds is not None:
            pulumi.set(__self__, "manifest_window_seconds", manifest_window_seconds)
        if min_buffer_time_seconds is not None:
            pulumi.set(__self__, "min_buffer_time_seconds", min_buffer_time_seconds)
        if min_update_period_seconds is not None:
            pulumi.set(__self__, "min_update_period_seconds", min_update_period_seconds)
        if suggested_presentation_delay_seconds is not None:
            pulumi.set(__self__, "suggested_presentation_delay_seconds", suggested_presentation_delay_seconds)

    @property
    @pulumi.getter(name="manifestWindowSeconds")
    def manifest_window_seconds(self) -> Optional[builtins.float]:
        """
        <p>The total duration (in seconds) of each manifest. Minimum value: <code>30</code> seconds. Maximum value: <code>3600</code> seconds.</p>
        """
        return pulumi.get(self, "manifest_window_seconds")

    @property
    @pulumi.getter(name="minBufferTimeSeconds")
    def min_buffer_time_seconds(self) -> Optional[builtins.float]:
        """
        <p>Minimum amount of content (measured in seconds) that a player must keep available in the buffer. Minimum value: <code>2</code> seconds. Maximum value: <code>60</code> seconds.</p>
        """
        return pulumi.get(self, "min_buffer_time_seconds")

    @property
    @pulumi.getter(name="minUpdatePeriodSeconds")
    def min_update_period_seconds(self) -> Optional[builtins.float]:
        """
        <p>Minimum amount of time (in seconds) that the player should wait before requesting updates to the manifest. Minimum value: <code>2</code> seconds. Maximum value: <code>60</code> seconds.</p>
        """
        return pulumi.get(self, "min_update_period_seconds")

    @property
    @pulumi.getter(name="suggestedPresentationDelaySeconds")
    def suggested_presentation_delay_seconds(self) -> Optional[builtins.float]:
        """
        <p>Amount of time (in seconds) that the player should be from the live point at the end of the manifest. Minimum value: <code>2</code> seconds. Maximum value: <code>60</code> seconds.</p>
        """
        return pulumi.get(self, "suggested_presentation_delay_seconds")


@pulumi.output_type
class ChannelHlsPlaylistSettings(dict):
    """
    <p>HLS playlist configuration parameters.</p>
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "adMarkupType":
            suggest = "ad_markup_type"
        elif key == "manifestWindowSeconds":
            suggest = "manifest_window_seconds"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ChannelHlsPlaylistSettings. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ChannelHlsPlaylistSettings.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ChannelHlsPlaylistSettings.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 ad_markup_type: Optional[Sequence['ChannelAdMarkupType']] = None,
                 manifest_window_seconds: Optional[builtins.float] = None):
        """
        <p>HLS playlist configuration parameters.</p>
        :param Sequence['ChannelAdMarkupType'] ad_markup_type: <p>Determines the type of SCTE 35 tags to use in ad markup. Specify <code>DATERANGE</code> to use <code>DATERANGE</code> tags (for live or VOD content). Specify <code>SCTE35_ENHANCED</code> to use <code>EXT-X-CUE-OUT</code> and <code>EXT-X-CUE-IN</code> tags (for VOD content only).</p>
        :param builtins.float manifest_window_seconds: <p>The total duration (in seconds) of each manifest. Minimum value: <code>30</code> seconds. Maximum value: <code>3600</code> seconds.</p>
        """
        if ad_markup_type is not None:
            pulumi.set(__self__, "ad_markup_type", ad_markup_type)
        if manifest_window_seconds is not None:
            pulumi.set(__self__, "manifest_window_seconds", manifest_window_seconds)

    @property
    @pulumi.getter(name="adMarkupType")
    def ad_markup_type(self) -> Optional[Sequence['ChannelAdMarkupType']]:
        """
        <p>Determines the type of SCTE 35 tags to use in ad markup. Specify <code>DATERANGE</code> to use <code>DATERANGE</code> tags (for live or VOD content). Specify <code>SCTE35_ENHANCED</code> to use <code>EXT-X-CUE-OUT</code> and <code>EXT-X-CUE-IN</code> tags (for VOD content only).</p>
        """
        return pulumi.get(self, "ad_markup_type")

    @property
    @pulumi.getter(name="manifestWindowSeconds")
    def manifest_window_seconds(self) -> Optional[builtins.float]:
        """
        <p>The total duration (in seconds) of each manifest. Minimum value: <code>30</code> seconds. Maximum value: <code>3600</code> seconds.</p>
        """
        return pulumi.get(self, "manifest_window_seconds")


@pulumi.output_type
class ChannelLogConfigurationForChannel(dict):
    """
    <p>The log configuration for the channel.</p>
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "logTypes":
            suggest = "log_types"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ChannelLogConfigurationForChannel. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ChannelLogConfigurationForChannel.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ChannelLogConfigurationForChannel.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 log_types: Optional[Sequence['ChannelLogType']] = None):
        """
        <p>The log configuration for the channel.</p>
        :param Sequence['ChannelLogType'] log_types: <p>The log types.</p>
        """
        if log_types is not None:
            pulumi.set(__self__, "log_types", log_types)

    @property
    @pulumi.getter(name="logTypes")
    def log_types(self) -> Optional[Sequence['ChannelLogType']]:
        """
        <p>The log types.</p>
        """
        return pulumi.get(self, "log_types")


@pulumi.output_type
class ChannelRequestOutputItem(dict):
    """
    <p>The output configuration for this channel.</p>
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "manifestName":
            suggest = "manifest_name"
        elif key == "sourceGroup":
            suggest = "source_group"
        elif key == "dashPlaylistSettings":
            suggest = "dash_playlist_settings"
        elif key == "hlsPlaylistSettings":
            suggest = "hls_playlist_settings"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ChannelRequestOutputItem. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ChannelRequestOutputItem.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ChannelRequestOutputItem.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 manifest_name: builtins.str,
                 source_group: builtins.str,
                 dash_playlist_settings: Optional['outputs.ChannelDashPlaylistSettings'] = None,
                 hls_playlist_settings: Optional['outputs.ChannelHlsPlaylistSettings'] = None):
        """
        <p>The output configuration for this channel.</p>
        :param builtins.str manifest_name: <p>The name of the manifest for the channel. The name appears in the <code>PlaybackUrl</code>.</p>
        :param builtins.str source_group: <p>A string used to match which <code>HttpPackageConfiguration</code> is used for each <code>VodSource</code>.</p>
        :param 'ChannelDashPlaylistSettings' dash_playlist_settings: DASH manifest configuration parameters.
        :param 'ChannelHlsPlaylistSettings' hls_playlist_settings: HLS playlist configuration parameters.
        """
        pulumi.set(__self__, "manifest_name", manifest_name)
        pulumi.set(__self__, "source_group", source_group)
        if dash_playlist_settings is not None:
            pulumi.set(__self__, "dash_playlist_settings", dash_playlist_settings)
        if hls_playlist_settings is not None:
            pulumi.set(__self__, "hls_playlist_settings", hls_playlist_settings)

    @property
    @pulumi.getter(name="manifestName")
    def manifest_name(self) -> builtins.str:
        """
        <p>The name of the manifest for the channel. The name appears in the <code>PlaybackUrl</code>.</p>
        """
        return pulumi.get(self, "manifest_name")

    @property
    @pulumi.getter(name="sourceGroup")
    def source_group(self) -> builtins.str:
        """
        <p>A string used to match which <code>HttpPackageConfiguration</code> is used for each <code>VodSource</code>.</p>
        """
        return pulumi.get(self, "source_group")

    @property
    @pulumi.getter(name="dashPlaylistSettings")
    def dash_playlist_settings(self) -> Optional['outputs.ChannelDashPlaylistSettings']:
        """
        DASH manifest configuration parameters.
        """
        return pulumi.get(self, "dash_playlist_settings")

    @property
    @pulumi.getter(name="hlsPlaylistSettings")
    def hls_playlist_settings(self) -> Optional['outputs.ChannelHlsPlaylistSettings']:
        """
        HLS playlist configuration parameters.
        """
        return pulumi.get(self, "hls_playlist_settings")


@pulumi.output_type
class ChannelSlateSource(dict):
    """
    <p>Slate VOD source configuration.</p>
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "sourceLocationName":
            suggest = "source_location_name"
        elif key == "vodSourceName":
            suggest = "vod_source_name"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ChannelSlateSource. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ChannelSlateSource.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ChannelSlateSource.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 source_location_name: Optional[builtins.str] = None,
                 vod_source_name: Optional[builtins.str] = None):
        """
        <p>Slate VOD source configuration.</p>
        :param builtins.str source_location_name: <p>The name of the source location where the slate VOD source is stored.</p>
        :param builtins.str vod_source_name: <p>The slate VOD source name. The VOD source must already exist in a source location before it can be used for slate.</p>
        """
        if source_location_name is not None:
            pulumi.set(__self__, "source_location_name", source_location_name)
        if vod_source_name is not None:
            pulumi.set(__self__, "vod_source_name", vod_source_name)

    @property
    @pulumi.getter(name="sourceLocationName")
    def source_location_name(self) -> Optional[builtins.str]:
        """
        <p>The name of the source location where the slate VOD source is stored.</p>
        """
        return pulumi.get(self, "source_location_name")

    @property
    @pulumi.getter(name="vodSourceName")
    def vod_source_name(self) -> Optional[builtins.str]:
        """
        <p>The slate VOD source name. The VOD source must already exist in a source location before it can be used for slate.</p>
        """
        return pulumi.get(self, "vod_source_name")


@pulumi.output_type
class ChannelTimeShiftConfiguration(dict):
    """
    <p>The configuration for time-shifted viewing.</p>
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "maxTimeDelaySeconds":
            suggest = "max_time_delay_seconds"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ChannelTimeShiftConfiguration. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ChannelTimeShiftConfiguration.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ChannelTimeShiftConfiguration.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 max_time_delay_seconds: builtins.float):
        """
        <p>The configuration for time-shifted viewing.</p>
        :param builtins.float max_time_delay_seconds: <p>The maximum time delay for time-shifted viewing. The minimum allowed maximum time delay is 0 seconds, and the maximum allowed maximum time delay is 21600 seconds (6 hours).</p>
        """
        pulumi.set(__self__, "max_time_delay_seconds", max_time_delay_seconds)

    @property
    @pulumi.getter(name="maxTimeDelaySeconds")
    def max_time_delay_seconds(self) -> builtins.float:
        """
        <p>The maximum time delay for time-shifted viewing. The minimum allowed maximum time delay is 0 seconds, and the maximum allowed maximum time delay is 21600 seconds (6 hours).</p>
        """
        return pulumi.get(self, "max_time_delay_seconds")


@pulumi.output_type
class LiveSourceHttpPackageConfiguration(dict):
    """
    <p>The HTTP package configuration properties for the requested VOD source.</p>
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "sourceGroup":
            suggest = "source_group"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in LiveSourceHttpPackageConfiguration. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        LiveSourceHttpPackageConfiguration.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        LiveSourceHttpPackageConfiguration.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 path: builtins.str,
                 source_group: builtins.str,
                 type: 'LiveSourceType'):
        """
        <p>The HTTP package configuration properties for the requested VOD source.</p>
        :param builtins.str path: <p>The relative path to the URL for this VOD source. This is combined with <code>SourceLocation::HttpConfiguration::BaseUrl</code> to form a valid URL.</p>
        :param builtins.str source_group: <p>The name of the source group. This has to match one of the <code>Channel::Outputs::SourceGroup</code>.</p>
        :param 'LiveSourceType' type: The streaming protocol for this package configuration. Supported values are `HLS` and `DASH` .
        """
        pulumi.set(__self__, "path", path)
        pulumi.set(__self__, "source_group", source_group)
        pulumi.set(__self__, "type", type)

    @property
    @pulumi.getter
    def path(self) -> builtins.str:
        """
        <p>The relative path to the URL for this VOD source. This is combined with <code>SourceLocation::HttpConfiguration::BaseUrl</code> to form a valid URL.</p>
        """
        return pulumi.get(self, "path")

    @property
    @pulumi.getter(name="sourceGroup")
    def source_group(self) -> builtins.str:
        """
        <p>The name of the source group. This has to match one of the <code>Channel::Outputs::SourceGroup</code>.</p>
        """
        return pulumi.get(self, "source_group")

    @property
    @pulumi.getter
    def type(self) -> 'LiveSourceType':
        """
        The streaming protocol for this package configuration. Supported values are `HLS` and `DASH` .
        """
        return pulumi.get(self, "type")


@pulumi.output_type
class PlaybackConfigurationAdConditioningConfiguration(dict):
    """
    <p>The setting that indicates what conditioning MediaTailor will perform on ads that the ad decision server (ADS) returns.</p>
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "streamingMediaFileConditioning":
            suggest = "streaming_media_file_conditioning"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in PlaybackConfigurationAdConditioningConfiguration. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        PlaybackConfigurationAdConditioningConfiguration.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        PlaybackConfigurationAdConditioningConfiguration.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 streaming_media_file_conditioning: 'PlaybackConfigurationStreamingMediaFileConditioning'):
        """
        <p>The setting that indicates what conditioning MediaTailor will perform on ads that the ad decision server (ADS) returns.</p>
        :param 'PlaybackConfigurationStreamingMediaFileConditioning' streaming_media_file_conditioning: For ads that have media files with streaming delivery and supported file extensions, indicates what transcoding action MediaTailor takes when it first receives these ads from the ADS. `TRANSCODE` indicates that MediaTailor must transcode the ads. `NONE` indicates that you have already transcoded the ads outside of MediaTailor and don't need them transcoded as part of the ad insertion workflow. For more information about ad conditioning see [Using preconditioned ads](https://docs.aws.amazon.com/mediatailor/latest/ug/precondition-ads.html) in the AWS Elemental MediaTailor user guide.
        """
        pulumi.set(__self__, "streaming_media_file_conditioning", streaming_media_file_conditioning)

    @property
    @pulumi.getter(name="streamingMediaFileConditioning")
    def streaming_media_file_conditioning(self) -> 'PlaybackConfigurationStreamingMediaFileConditioning':
        """
        For ads that have media files with streaming delivery and supported file extensions, indicates what transcoding action MediaTailor takes when it first receives these ads from the ADS. `TRANSCODE` indicates that MediaTailor must transcode the ads. `NONE` indicates that you have already transcoded the ads outside of MediaTailor and don't need them transcoded as part of the ad insertion workflow. For more information about ad conditioning see [Using preconditioned ads](https://docs.aws.amazon.com/mediatailor/latest/ug/precondition-ads.html) in the AWS Elemental MediaTailor user guide.
        """
        return pulumi.get(self, "streaming_media_file_conditioning")


@pulumi.output_type
class PlaybackConfigurationAdMarkerPassthrough(dict):
    """
    For HLS, when set to true, MediaTailor passes through EXT-X-CUE-IN, EXT-X-CUE-OUT, and EXT-X-SPLICEPOINT-SCTE35 ad markers from the origin manifest to the MediaTailor personalized manifest. No logic is applied to these ad markers. For example, if EXT-X-CUE-OUT has a value of 60, but no ads are filled for that ad break, MediaTailor will not set the value to 0.
    """
    def __init__(__self__, *,
                 enabled: Optional[builtins.bool] = None):
        """
        For HLS, when set to true, MediaTailor passes through EXT-X-CUE-IN, EXT-X-CUE-OUT, and EXT-X-SPLICEPOINT-SCTE35 ad markers from the origin manifest to the MediaTailor personalized manifest. No logic is applied to these ad markers. For example, if EXT-X-CUE-OUT has a value of 60, but no ads are filled for that ad break, MediaTailor will not set the value to 0.
        :param builtins.bool enabled: Enables ad marker passthrough for your configuration.
        """
        if enabled is not None:
            pulumi.set(__self__, "enabled", enabled)

    @property
    @pulumi.getter
    def enabled(self) -> Optional[builtins.bool]:
        """
        Enables ad marker passthrough for your configuration.
        """
        return pulumi.get(self, "enabled")


@pulumi.output_type
class PlaybackConfigurationAvailSuppression(dict):
    """
    The configuration for avail suppression, also known as ad suppression. For more information about ad suppression, see Ad Suppression (https://docs.aws.amazon.com/mediatailor/latest/ug/ad-behavior.html).
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "fillPolicy":
            suggest = "fill_policy"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in PlaybackConfigurationAvailSuppression. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        PlaybackConfigurationAvailSuppression.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        PlaybackConfigurationAvailSuppression.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 fill_policy: Optional['PlaybackConfigurationAvailSuppressionFillPolicy'] = None,
                 mode: Optional['PlaybackConfigurationAvailSuppressionMode'] = None,
                 value: Optional[builtins.str] = None):
        """
        The configuration for avail suppression, also known as ad suppression. For more information about ad suppression, see Ad Suppression (https://docs.aws.amazon.com/mediatailor/latest/ug/ad-behavior.html).
        :param 'PlaybackConfigurationAvailSuppressionFillPolicy' fill_policy: Defines the policy to apply to the avail suppression mode. BEHIND_LIVE_EDGE will always use the full avail suppression policy. AFTER_LIVE_EDGE mode can be used to invoke partial ad break fills when a session starts mid-break. Valid values are FULL_AVAIL_ONLY and PARTIAL_AVAIL
        :param 'PlaybackConfigurationAvailSuppressionMode' mode: Sets the ad suppression mode. By default, ad suppression is off and all ad breaks are filled with ads or slate. When Mode is set to BEHIND_LIVE_EDGE, ad suppression is active and MediaTailor won't fill ad breaks on or behind the ad suppression Value time in the manifest lookback window. When Mode is set to AFTER_LIVE_EDGE, ad suppression is active and MediaTailor won't fill ad breaks that are within the live edge plus the avail suppression value.
        :param builtins.str value: A live edge offset time in HH:MM:SS. MediaTailor won't fill ad breaks on or behind this time in the manifest lookback window. If Value is set to 00:00:00, it is in sync with the live edge, and MediaTailor won't fill any ad breaks on or behind the live edge. If you set a Value time, MediaTailor won't fill any ad breaks on or behind this time in the manifest lookback window. For example, if you set 00:45:00, then MediaTailor will fill ad breaks that occur within 45 minutes behind the live edge, but won't fill ad breaks on or behind 45 minutes behind the live edge.
        """
        if fill_policy is not None:
            pulumi.set(__self__, "fill_policy", fill_policy)
        if mode is not None:
            pulumi.set(__self__, "mode", mode)
        if value is not None:
            pulumi.set(__self__, "value", value)

    @property
    @pulumi.getter(name="fillPolicy")
    def fill_policy(self) -> Optional['PlaybackConfigurationAvailSuppressionFillPolicy']:
        """
        Defines the policy to apply to the avail suppression mode. BEHIND_LIVE_EDGE will always use the full avail suppression policy. AFTER_LIVE_EDGE mode can be used to invoke partial ad break fills when a session starts mid-break. Valid values are FULL_AVAIL_ONLY and PARTIAL_AVAIL
        """
        return pulumi.get(self, "fill_policy")

    @property
    @pulumi.getter
    def mode(self) -> Optional['PlaybackConfigurationAvailSuppressionMode']:
        """
        Sets the ad suppression mode. By default, ad suppression is off and all ad breaks are filled with ads or slate. When Mode is set to BEHIND_LIVE_EDGE, ad suppression is active and MediaTailor won't fill ad breaks on or behind the ad suppression Value time in the manifest lookback window. When Mode is set to AFTER_LIVE_EDGE, ad suppression is active and MediaTailor won't fill ad breaks that are within the live edge plus the avail suppression value.
        """
        return pulumi.get(self, "mode")

    @property
    @pulumi.getter
    def value(self) -> Optional[builtins.str]:
        """
        A live edge offset time in HH:MM:SS. MediaTailor won't fill ad breaks on or behind this time in the manifest lookback window. If Value is set to 00:00:00, it is in sync with the live edge, and MediaTailor won't fill any ad breaks on or behind the live edge. If you set a Value time, MediaTailor won't fill any ad breaks on or behind this time in the manifest lookback window. For example, if you set 00:45:00, then MediaTailor will fill ad breaks that occur within 45 minutes behind the live edge, but won't fill ad breaks on or behind 45 minutes behind the live edge.
        """
        return pulumi.get(self, "value")


@pulumi.output_type
class PlaybackConfigurationBumper(dict):
    """
    The configuration for bumpers. Bumpers are short audio or video clips that play at the start or before the end of an ad break. To learn more about bumpers, see Bumpers (https://docs.aws.amazon.com/mediatailor/latest/ug/bumpers.html).
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "endUrl":
            suggest = "end_url"
        elif key == "startUrl":
            suggest = "start_url"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in PlaybackConfigurationBumper. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        PlaybackConfigurationBumper.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        PlaybackConfigurationBumper.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 end_url: Optional[builtins.str] = None,
                 start_url: Optional[builtins.str] = None):
        """
        The configuration for bumpers. Bumpers are short audio or video clips that play at the start or before the end of an ad break. To learn more about bumpers, see Bumpers (https://docs.aws.amazon.com/mediatailor/latest/ug/bumpers.html).
        :param builtins.str end_url: The URL for the end bumper asset.
        :param builtins.str start_url: The URL for the start bumper asset.
        """
        if end_url is not None:
            pulumi.set(__self__, "end_url", end_url)
        if start_url is not None:
            pulumi.set(__self__, "start_url", start_url)

    @property
    @pulumi.getter(name="endUrl")
    def end_url(self) -> Optional[builtins.str]:
        """
        The URL for the end bumper asset.
        """
        return pulumi.get(self, "end_url")

    @property
    @pulumi.getter(name="startUrl")
    def start_url(self) -> Optional[builtins.str]:
        """
        The URL for the start bumper asset.
        """
        return pulumi.get(self, "start_url")


@pulumi.output_type
class PlaybackConfigurationCdnConfiguration(dict):
    """
    The configuration for using a content delivery network (CDN), like Amazon CloudFront, for content and ad segment management.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "adSegmentUrlPrefix":
            suggest = "ad_segment_url_prefix"
        elif key == "contentSegmentUrlPrefix":
            suggest = "content_segment_url_prefix"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in PlaybackConfigurationCdnConfiguration. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        PlaybackConfigurationCdnConfiguration.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        PlaybackConfigurationCdnConfiguration.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 ad_segment_url_prefix: Optional[builtins.str] = None,
                 content_segment_url_prefix: Optional[builtins.str] = None):
        """
        The configuration for using a content delivery network (CDN), like Amazon CloudFront, for content and ad segment management.
        :param builtins.str ad_segment_url_prefix: A non-default content delivery network (CDN) to serve ad segments. By default, AWS Elemental MediaTailor uses Amazon CloudFront with default cache settings as its CDN for ad segments. To set up an alternate CDN, create a rule in your CDN for the origin ads.mediatailor.&lt;region>.amazonaws.com. Then specify the rule's name in this AdSegmentUrlPrefix. When AWS Elemental MediaTailor serves a manifest, it reports your CDN as the source for ad segments.
        :param builtins.str content_segment_url_prefix: A content delivery network (CDN) to cache content segments, so that content requests don't always have to go to the origin server. First, create a rule in your CDN for the content segment origin server. Then specify the rule's name in this ContentSegmentUrlPrefix. When AWS Elemental MediaTailor serves a manifest, it reports your CDN as the source for content segments.
        """
        if ad_segment_url_prefix is not None:
            pulumi.set(__self__, "ad_segment_url_prefix", ad_segment_url_prefix)
        if content_segment_url_prefix is not None:
            pulumi.set(__self__, "content_segment_url_prefix", content_segment_url_prefix)

    @property
    @pulumi.getter(name="adSegmentUrlPrefix")
    def ad_segment_url_prefix(self) -> Optional[builtins.str]:
        """
        A non-default content delivery network (CDN) to serve ad segments. By default, AWS Elemental MediaTailor uses Amazon CloudFront with default cache settings as its CDN for ad segments. To set up an alternate CDN, create a rule in your CDN for the origin ads.mediatailor.&lt;region>.amazonaws.com. Then specify the rule's name in this AdSegmentUrlPrefix. When AWS Elemental MediaTailor serves a manifest, it reports your CDN as the source for ad segments.
        """
        return pulumi.get(self, "ad_segment_url_prefix")

    @property
    @pulumi.getter(name="contentSegmentUrlPrefix")
    def content_segment_url_prefix(self) -> Optional[builtins.str]:
        """
        A content delivery network (CDN) to cache content segments, so that content requests don't always have to go to the origin server. First, create a rule in your CDN for the content segment origin server. Then specify the rule's name in this ContentSegmentUrlPrefix. When AWS Elemental MediaTailor serves a manifest, it reports your CDN as the source for content segments.
        """
        return pulumi.get(self, "content_segment_url_prefix")


@pulumi.output_type
class PlaybackConfigurationDashConfiguration(dict):
    """
    The configuration for DASH PUT operations.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "manifestEndpointPrefix":
            suggest = "manifest_endpoint_prefix"
        elif key == "mpdLocation":
            suggest = "mpd_location"
        elif key == "originManifestType":
            suggest = "origin_manifest_type"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in PlaybackConfigurationDashConfiguration. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        PlaybackConfigurationDashConfiguration.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        PlaybackConfigurationDashConfiguration.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 manifest_endpoint_prefix: Optional[builtins.str] = None,
                 mpd_location: Optional[builtins.str] = None,
                 origin_manifest_type: Optional['PlaybackConfigurationDashConfigurationOriginManifestType'] = None):
        """
        The configuration for DASH PUT operations.
        :param builtins.str manifest_endpoint_prefix: The URL generated by MediaTailor to initiate a DASH playback session. The session uses server-side reporting.
        :param builtins.str mpd_location: The setting that controls whether MediaTailor includes the Location tag in DASH manifests. MediaTailor populates the Location tag with the URL for manifest update requests, to be used by players that don't support sticky redirects. Disable this if you have CDN routing rules set up for accessing MediaTailor manifests, and you are either using client-side reporting or your players support sticky HTTP redirects. Valid values are DISABLED and EMT_DEFAULT. The EMT_DEFAULT setting enables the inclusion of the tag and is the default value.
        :param 'PlaybackConfigurationDashConfigurationOriginManifestType' origin_manifest_type: The setting that controls whether MediaTailor handles manifests from the origin server as multi-period manifests or single-period manifests. If your origin server produces single-period manifests, set this to SINGLE_PERIOD. The default setting is MULTI_PERIOD. For multi-period manifests, omit this setting or set it to MULTI_PERIOD.
        """
        if manifest_endpoint_prefix is not None:
            pulumi.set(__self__, "manifest_endpoint_prefix", manifest_endpoint_prefix)
        if mpd_location is not None:
            pulumi.set(__self__, "mpd_location", mpd_location)
        if origin_manifest_type is not None:
            pulumi.set(__self__, "origin_manifest_type", origin_manifest_type)

    @property
    @pulumi.getter(name="manifestEndpointPrefix")
    def manifest_endpoint_prefix(self) -> Optional[builtins.str]:
        """
        The URL generated by MediaTailor to initiate a DASH playback session. The session uses server-side reporting.
        """
        return pulumi.get(self, "manifest_endpoint_prefix")

    @property
    @pulumi.getter(name="mpdLocation")
    def mpd_location(self) -> Optional[builtins.str]:
        """
        The setting that controls whether MediaTailor includes the Location tag in DASH manifests. MediaTailor populates the Location tag with the URL for manifest update requests, to be used by players that don't support sticky redirects. Disable this if you have CDN routing rules set up for accessing MediaTailor manifests, and you are either using client-side reporting or your players support sticky HTTP redirects. Valid values are DISABLED and EMT_DEFAULT. The EMT_DEFAULT setting enables the inclusion of the tag and is the default value.
        """
        return pulumi.get(self, "mpd_location")

    @property
    @pulumi.getter(name="originManifestType")
    def origin_manifest_type(self) -> Optional['PlaybackConfigurationDashConfigurationOriginManifestType']:
        """
        The setting that controls whether MediaTailor handles manifests from the origin server as multi-period manifests or single-period manifests. If your origin server produces single-period manifests, set this to SINGLE_PERIOD. The default setting is MULTI_PERIOD. For multi-period manifests, omit this setting or set it to MULTI_PERIOD.
        """
        return pulumi.get(self, "origin_manifest_type")


@pulumi.output_type
class PlaybackConfigurationHlsConfiguration(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "manifestEndpointPrefix":
            suggest = "manifest_endpoint_prefix"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in PlaybackConfigurationHlsConfiguration. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        PlaybackConfigurationHlsConfiguration.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        PlaybackConfigurationHlsConfiguration.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 manifest_endpoint_prefix: Optional[builtins.str] = None):
        """
        :param builtins.str manifest_endpoint_prefix: The URL that is used to initiate a playback session for devices that support Apple HLS. The session uses server-side reporting.
        """
        if manifest_endpoint_prefix is not None:
            pulumi.set(__self__, "manifest_endpoint_prefix", manifest_endpoint_prefix)

    @property
    @pulumi.getter(name="manifestEndpointPrefix")
    def manifest_endpoint_prefix(self) -> Optional[builtins.str]:
        """
        The URL that is used to initiate a playback session for devices that support Apple HLS. The session uses server-side reporting.
        """
        return pulumi.get(self, "manifest_endpoint_prefix")


@pulumi.output_type
class PlaybackConfigurationLivePreRollConfiguration(dict):
    """
    The configuration for pre-roll ad insertion.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "adDecisionServerUrl":
            suggest = "ad_decision_server_url"
        elif key == "maxDurationSeconds":
            suggest = "max_duration_seconds"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in PlaybackConfigurationLivePreRollConfiguration. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        PlaybackConfigurationLivePreRollConfiguration.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        PlaybackConfigurationLivePreRollConfiguration.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 ad_decision_server_url: Optional[builtins.str] = None,
                 max_duration_seconds: Optional[builtins.int] = None):
        """
        The configuration for pre-roll ad insertion.
        :param builtins.str ad_decision_server_url: The URL for the ad decision server (ADS) for pre-roll ads. This includes the specification of static parameters and placeholders for dynamic parameters. AWS Elemental MediaTailor substitutes player-specific and session-specific parameters as needed when calling the ADS. Alternately, for testing, you can provide a static VAST URL. The maximum length is 25,000 characters.
        :param builtins.int max_duration_seconds: The maximum allowed duration for the pre-roll ad avail. AWS Elemental MediaTailor won't play pre-roll ads to exceed this duration, regardless of the total duration of ads that the ADS returns.
        """
        if ad_decision_server_url is not None:
            pulumi.set(__self__, "ad_decision_server_url", ad_decision_server_url)
        if max_duration_seconds is not None:
            pulumi.set(__self__, "max_duration_seconds", max_duration_seconds)

    @property
    @pulumi.getter(name="adDecisionServerUrl")
    def ad_decision_server_url(self) -> Optional[builtins.str]:
        """
        The URL for the ad decision server (ADS) for pre-roll ads. This includes the specification of static parameters and placeholders for dynamic parameters. AWS Elemental MediaTailor substitutes player-specific and session-specific parameters as needed when calling the ADS. Alternately, for testing, you can provide a static VAST URL. The maximum length is 25,000 characters.
        """
        return pulumi.get(self, "ad_decision_server_url")

    @property
    @pulumi.getter(name="maxDurationSeconds")
    def max_duration_seconds(self) -> Optional[builtins.int]:
        """
        The maximum allowed duration for the pre-roll ad avail. AWS Elemental MediaTailor won't play pre-roll ads to exceed this duration, regardless of the total duration of ads that the ADS returns.
        """
        return pulumi.get(self, "max_duration_seconds")


@pulumi.output_type
class PlaybackConfigurationManifestProcessingRules(dict):
    """
    The configuration for manifest processing rules. Manifest processing rules enable customization of the personalized manifests created by MediaTailor.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "adMarkerPassthrough":
            suggest = "ad_marker_passthrough"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in PlaybackConfigurationManifestProcessingRules. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        PlaybackConfigurationManifestProcessingRules.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        PlaybackConfigurationManifestProcessingRules.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 ad_marker_passthrough: Optional['outputs.PlaybackConfigurationAdMarkerPassthrough'] = None):
        """
        The configuration for manifest processing rules. Manifest processing rules enable customization of the personalized manifests created by MediaTailor.
        :param 'PlaybackConfigurationAdMarkerPassthrough' ad_marker_passthrough: For HLS, when set to true, MediaTailor passes through EXT-X-CUE-IN, EXT-X-CUE-OUT, and EXT-X-SPLICEPOINT-SCTE35 ad markers from the origin manifest to the MediaTailor personalized manifest. No logic is applied to these ad markers. For example, if EXT-X-CUE-OUT has a value of 60, but no ads are filled for that ad break, MediaTailor will not set the value to 0.
        """
        if ad_marker_passthrough is not None:
            pulumi.set(__self__, "ad_marker_passthrough", ad_marker_passthrough)

    @property
    @pulumi.getter(name="adMarkerPassthrough")
    def ad_marker_passthrough(self) -> Optional['outputs.PlaybackConfigurationAdMarkerPassthrough']:
        """
        For HLS, when set to true, MediaTailor passes through EXT-X-CUE-IN, EXT-X-CUE-OUT, and EXT-X-SPLICEPOINT-SCTE35 ad markers from the origin manifest to the MediaTailor personalized manifest. No logic is applied to these ad markers. For example, if EXT-X-CUE-OUT has a value of 60, but no ads are filled for that ad break, MediaTailor will not set the value to 0.
        """
        return pulumi.get(self, "ad_marker_passthrough")


@pulumi.output_type
class SourceLocationAccessConfiguration(dict):
    """
    <p>Access configuration parameters.</p>
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "accessType":
            suggest = "access_type"
        elif key == "secretsManagerAccessTokenConfiguration":
            suggest = "secrets_manager_access_token_configuration"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in SourceLocationAccessConfiguration. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        SourceLocationAccessConfiguration.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        SourceLocationAccessConfiguration.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 access_type: Optional['SourceLocationAccessType'] = None,
                 secrets_manager_access_token_configuration: Optional['outputs.SourceLocationSecretsManagerAccessTokenConfiguration'] = None):
        """
        <p>Access configuration parameters.</p>
        :param 'SourceLocationAccessType' access_type: The type of authentication used to access content from `HttpConfiguration::BaseUrl` on your source location. Accepted value: `S3_SIGV4` .
               
               `S3_SIGV4` - AWS Signature Version 4 authentication for Amazon S3 hosted virtual-style access. If your source location base URL is an Amazon S3 bucket, MediaTailor can use AWS Signature Version 4 (SigV4) authentication to access the bucket where your source content is stored. Your MediaTailor source location baseURL must follow the S3 virtual hosted-style request URL format. For example, https://bucket-name.s3.Region.amazonaws.com/key-name.
               
               Before you can use `S3_SIGV4` , you must meet these requirements:
               
               • You must allow MediaTailor to access your S3 bucket by granting mediatailor.amazonaws.com principal access in IAM. For information about configuring access in IAM, see Access management in the IAM User Guide.
               
               • The mediatailor.amazonaws.com service principal must have permissions to read all top level manifests referenced by the VodSource packaging configurations.
               
               • The caller of the API must have s3:GetObject IAM permissions to read all top level manifests referenced by your MediaTailor VodSource packaging configurations.
        :param 'SourceLocationSecretsManagerAccessTokenConfiguration' secrets_manager_access_token_configuration: AWS Secrets Manager access token configuration parameters.
        """
        if access_type is not None:
            pulumi.set(__self__, "access_type", access_type)
        if secrets_manager_access_token_configuration is not None:
            pulumi.set(__self__, "secrets_manager_access_token_configuration", secrets_manager_access_token_configuration)

    @property
    @pulumi.getter(name="accessType")
    def access_type(self) -> Optional['SourceLocationAccessType']:
        """
        The type of authentication used to access content from `HttpConfiguration::BaseUrl` on your source location. Accepted value: `S3_SIGV4` .

        `S3_SIGV4` - AWS Signature Version 4 authentication for Amazon S3 hosted virtual-style access. If your source location base URL is an Amazon S3 bucket, MediaTailor can use AWS Signature Version 4 (SigV4) authentication to access the bucket where your source content is stored. Your MediaTailor source location baseURL must follow the S3 virtual hosted-style request URL format. For example, https://bucket-name.s3.Region.amazonaws.com/key-name.

        Before you can use `S3_SIGV4` , you must meet these requirements:

        • You must allow MediaTailor to access your S3 bucket by granting mediatailor.amazonaws.com principal access in IAM. For information about configuring access in IAM, see Access management in the IAM User Guide.

        • The mediatailor.amazonaws.com service principal must have permissions to read all top level manifests referenced by the VodSource packaging configurations.

        • The caller of the API must have s3:GetObject IAM permissions to read all top level manifests referenced by your MediaTailor VodSource packaging configurations.
        """
        return pulumi.get(self, "access_type")

    @property
    @pulumi.getter(name="secretsManagerAccessTokenConfiguration")
    def secrets_manager_access_token_configuration(self) -> Optional['outputs.SourceLocationSecretsManagerAccessTokenConfiguration']:
        """
        AWS Secrets Manager access token configuration parameters.
        """
        return pulumi.get(self, "secrets_manager_access_token_configuration")


@pulumi.output_type
class SourceLocationDefaultSegmentDeliveryConfiguration(dict):
    """
    <p>The optional configuration for a server that serves segments. Use this if you want the segment delivery server to be different from the source location server. For example, you can configure your source location server to be an origination server, such as MediaPackage, and the segment delivery server to be a content delivery network (CDN), such as CloudFront. If you don't specify a segment delivery server, then the source location server is used.</p>
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "baseUrl":
            suggest = "base_url"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in SourceLocationDefaultSegmentDeliveryConfiguration. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        SourceLocationDefaultSegmentDeliveryConfiguration.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        SourceLocationDefaultSegmentDeliveryConfiguration.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 base_url: Optional[builtins.str] = None):
        """
        <p>The optional configuration for a server that serves segments. Use this if you want the segment delivery server to be different from the source location server. For example, you can configure your source location server to be an origination server, such as MediaPackage, and the segment delivery server to be a content delivery network (CDN), such as CloudFront. If you don't specify a segment delivery server, then the source location server is used.</p>
        :param builtins.str base_url: <p>The hostname of the server that will be used to serve segments. This string must include the protocol, such as <b>https://</b>.</p>
        """
        if base_url is not None:
            pulumi.set(__self__, "base_url", base_url)

    @property
    @pulumi.getter(name="baseUrl")
    def base_url(self) -> Optional[builtins.str]:
        """
        <p>The hostname of the server that will be used to serve segments. This string must include the protocol, such as <b>https://</b>.</p>
        """
        return pulumi.get(self, "base_url")


@pulumi.output_type
class SourceLocationHttpConfiguration(dict):
    """
    <p>The HTTP configuration for the source location.</p>
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "baseUrl":
            suggest = "base_url"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in SourceLocationHttpConfiguration. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        SourceLocationHttpConfiguration.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        SourceLocationHttpConfiguration.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 base_url: builtins.str):
        """
        <p>The HTTP configuration for the source location.</p>
        :param builtins.str base_url: <p>The base URL for the source location host server. This string must include the protocol, such as <b>https://</b>.</p>
        """
        pulumi.set(__self__, "base_url", base_url)

    @property
    @pulumi.getter(name="baseUrl")
    def base_url(self) -> builtins.str:
        """
        <p>The base URL for the source location host server. This string must include the protocol, such as <b>https://</b>.</p>
        """
        return pulumi.get(self, "base_url")


@pulumi.output_type
class SourceLocationSecretsManagerAccessTokenConfiguration(dict):
    """
    <p>AWS Secrets Manager access token configuration parameters. For information about Secrets Manager access token authentication, see <a href="https://docs.aws.amazon.com/mediatailor/latest/ug/channel-assembly-access-configuration-access-token.html">Working with AWS Secrets Manager access token authentication</a>.</p>
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "headerName":
            suggest = "header_name"
        elif key == "secretArn":
            suggest = "secret_arn"
        elif key == "secretStringKey":
            suggest = "secret_string_key"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in SourceLocationSecretsManagerAccessTokenConfiguration. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        SourceLocationSecretsManagerAccessTokenConfiguration.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        SourceLocationSecretsManagerAccessTokenConfiguration.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 header_name: Optional[builtins.str] = None,
                 secret_arn: Optional[builtins.str] = None,
                 secret_string_key: Optional[builtins.str] = None):
        """
        <p>AWS Secrets Manager access token configuration parameters. For information about Secrets Manager access token authentication, see <a href="https://docs.aws.amazon.com/mediatailor/latest/ug/channel-assembly-access-configuration-access-token.html">Working with AWS Secrets Manager access token authentication</a>.</p>
        :param builtins.str header_name: <p>The name of the HTTP header used to supply the access token in requests to the source location.</p>
        :param builtins.str secret_arn: <p>The Amazon Resource Name (ARN) of the AWS Secrets Manager secret that contains the access token.</p>
        :param builtins.str secret_string_key: <p>The AWS Secrets Manager <a href="https://docs.aws.amazon.com/secretsmanager/latest/apireference/API_CreateSecret.html#SecretsManager-CreateSecret-request-SecretString.html">SecretString</a> key associated with the access token. MediaTailor uses the key to look up SecretString key and value pair containing the access token.</p>
        """
        if header_name is not None:
            pulumi.set(__self__, "header_name", header_name)
        if secret_arn is not None:
            pulumi.set(__self__, "secret_arn", secret_arn)
        if secret_string_key is not None:
            pulumi.set(__self__, "secret_string_key", secret_string_key)

    @property
    @pulumi.getter(name="headerName")
    def header_name(self) -> Optional[builtins.str]:
        """
        <p>The name of the HTTP header used to supply the access token in requests to the source location.</p>
        """
        return pulumi.get(self, "header_name")

    @property
    @pulumi.getter(name="secretArn")
    def secret_arn(self) -> Optional[builtins.str]:
        """
        <p>The Amazon Resource Name (ARN) of the AWS Secrets Manager secret that contains the access token.</p>
        """
        return pulumi.get(self, "secret_arn")

    @property
    @pulumi.getter(name="secretStringKey")
    def secret_string_key(self) -> Optional[builtins.str]:
        """
        <p>The AWS Secrets Manager <a href="https://docs.aws.amazon.com/secretsmanager/latest/apireference/API_CreateSecret.html#SecretsManager-CreateSecret-request-SecretString.html">SecretString</a> key associated with the access token. MediaTailor uses the key to look up SecretString key and value pair containing the access token.</p>
        """
        return pulumi.get(self, "secret_string_key")


@pulumi.output_type
class SourceLocationSegmentDeliveryConfiguration(dict):
    """
    <p>The segment delivery configuration settings.</p>
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "baseUrl":
            suggest = "base_url"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in SourceLocationSegmentDeliveryConfiguration. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        SourceLocationSegmentDeliveryConfiguration.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        SourceLocationSegmentDeliveryConfiguration.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 base_url: Optional[builtins.str] = None,
                 name: Optional[builtins.str] = None):
        """
        <p>The segment delivery configuration settings.</p>
        :param builtins.str base_url: <p>The base URL of the host or path of the segment delivery server that you're using to serve segments. This is typically a content delivery network (CDN). The URL can be absolute or relative. To use an absolute URL include the protocol, such as <code>https://example.com/some/path</code>. To use a relative URL specify the relative path, such as <code>/some/path*</code>.</p>
        :param builtins.str name: <p>A unique identifier used to distinguish between multiple segment delivery configurations in a source location.</p>
        """
        if base_url is not None:
            pulumi.set(__self__, "base_url", base_url)
        if name is not None:
            pulumi.set(__self__, "name", name)

    @property
    @pulumi.getter(name="baseUrl")
    def base_url(self) -> Optional[builtins.str]:
        """
        <p>The base URL of the host or path of the segment delivery server that you're using to serve segments. This is typically a content delivery network (CDN). The URL can be absolute or relative. To use an absolute URL include the protocol, such as <code>https://example.com/some/path</code>. To use a relative URL specify the relative path, such as <code>/some/path*</code>.</p>
        """
        return pulumi.get(self, "base_url")

    @property
    @pulumi.getter
    def name(self) -> Optional[builtins.str]:
        """
        <p>A unique identifier used to distinguish between multiple segment delivery configurations in a source location.</p>
        """
        return pulumi.get(self, "name")


@pulumi.output_type
class VodSourceHttpPackageConfiguration(dict):
    """
    <p>The HTTP package configuration properties for the requested VOD source.</p>
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "sourceGroup":
            suggest = "source_group"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in VodSourceHttpPackageConfiguration. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        VodSourceHttpPackageConfiguration.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        VodSourceHttpPackageConfiguration.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 path: builtins.str,
                 source_group: builtins.str,
                 type: 'VodSourceType'):
        """
        <p>The HTTP package configuration properties for the requested VOD source.</p>
        :param builtins.str path: <p>The relative path to the URL for this VOD source. This is combined with <code>SourceLocation::HttpConfiguration::BaseUrl</code> to form a valid URL.</p>
        :param builtins.str source_group: <p>The name of the source group. This has to match one of the <code>Channel::Outputs::SourceGroup</code>.</p>
        :param 'VodSourceType' type: The streaming protocol for this package configuration. Supported values are `HLS` and `DASH` .
        """
        pulumi.set(__self__, "path", path)
        pulumi.set(__self__, "source_group", source_group)
        pulumi.set(__self__, "type", type)

    @property
    @pulumi.getter
    def path(self) -> builtins.str:
        """
        <p>The relative path to the URL for this VOD source. This is combined with <code>SourceLocation::HttpConfiguration::BaseUrl</code> to form a valid URL.</p>
        """
        return pulumi.get(self, "path")

    @property
    @pulumi.getter(name="sourceGroup")
    def source_group(self) -> builtins.str:
        """
        <p>The name of the source group. This has to match one of the <code>Channel::Outputs::SourceGroup</code>.</p>
        """
        return pulumi.get(self, "source_group")

    @property
    @pulumi.getter
    def type(self) -> 'VodSourceType':
        """
        The streaming protocol for this package configuration. Supported values are `HLS` and `DASH` .
        """
        return pulumi.get(self, "type")


