# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs
from .. import outputs as _root_outputs
from ._enums import *

__all__ = [
    'GetChannelResult',
    'AwaitableGetChannelResult',
    'get_channel',
    'get_channel_output',
]

@pulumi.output_type
class GetChannelResult:
    def __init__(__self__, arn=None, audiences=None, filler_slate=None, log_configuration=None, outputs=None, playback_mode=None, tags=None, time_shift_configuration=None):
        if arn and not isinstance(arn, str):
            raise TypeError("Expected argument 'arn' to be a str")
        pulumi.set(__self__, "arn", arn)
        if audiences and not isinstance(audiences, list):
            raise TypeError("Expected argument 'audiences' to be a list")
        pulumi.set(__self__, "audiences", audiences)
        if filler_slate and not isinstance(filler_slate, dict):
            raise TypeError("Expected argument 'filler_slate' to be a dict")
        pulumi.set(__self__, "filler_slate", filler_slate)
        if log_configuration and not isinstance(log_configuration, dict):
            raise TypeError("Expected argument 'log_configuration' to be a dict")
        pulumi.set(__self__, "log_configuration", log_configuration)
        if outputs and not isinstance(outputs, list):
            raise TypeError("Expected argument 'outputs' to be a list")
        pulumi.set(__self__, "outputs", outputs)
        if playback_mode and not isinstance(playback_mode, str):
            raise TypeError("Expected argument 'playback_mode' to be a str")
        pulumi.set(__self__, "playback_mode", playback_mode)
        if tags and not isinstance(tags, list):
            raise TypeError("Expected argument 'tags' to be a list")
        pulumi.set(__self__, "tags", tags)
        if time_shift_configuration and not isinstance(time_shift_configuration, dict):
            raise TypeError("Expected argument 'time_shift_configuration' to be a dict")
        pulumi.set(__self__, "time_shift_configuration", time_shift_configuration)

    @property
    @pulumi.getter
    def arn(self) -> Optional[builtins.str]:
        """
        <p>The ARN of the channel.</p>
        """
        return pulumi.get(self, "arn")

    @property
    @pulumi.getter
    def audiences(self) -> Optional[Sequence[builtins.str]]:
        """
        <p>The list of audiences defined in channel.</p>
        """
        return pulumi.get(self, "audiences")

    @property
    @pulumi.getter(name="fillerSlate")
    def filler_slate(self) -> Optional['outputs.ChannelSlateSource']:
        """
        The slate used to fill gaps between programs in the schedule. You must configure filler slate if your channel uses the `LINEAR` `PlaybackMode` . MediaTailor doesn't support filler slate for channels using the `LOOP` `PlaybackMode` .
        """
        return pulumi.get(self, "filler_slate")

    @property
    @pulumi.getter(name="logConfiguration")
    def log_configuration(self) -> Optional['outputs.ChannelLogConfigurationForChannel']:
        """
        The log configuration.
        """
        return pulumi.get(self, "log_configuration")

    @property
    @pulumi.getter
    def outputs(self) -> Optional[Sequence['outputs.ChannelRequestOutputItem']]:
        """
        <p>The channel's output properties.</p>
        """
        return pulumi.get(self, "outputs")

    @property
    @pulumi.getter(name="playbackMode")
    def playback_mode(self) -> Optional['ChannelPlaybackMode']:
        """
        The type of playback mode for this channel.

        `LINEAR` - Programs play back-to-back only once.

        `LOOP` - Programs play back-to-back in an endless loop. When the last program in the schedule plays, playback loops back to the first program in the schedule.
        """
        return pulumi.get(self, "playback_mode")

    @property
    @pulumi.getter
    def tags(self) -> Optional[Sequence['_root_outputs.Tag']]:
        """
        The tags to assign to the channel.
        """
        return pulumi.get(self, "tags")

    @property
    @pulumi.getter(name="timeShiftConfiguration")
    def time_shift_configuration(self) -> Optional['outputs.ChannelTimeShiftConfiguration']:
        """
        The configuration for time-shifted viewing.
        """
        return pulumi.get(self, "time_shift_configuration")


class AwaitableGetChannelResult(GetChannelResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetChannelResult(
            arn=self.arn,
            audiences=self.audiences,
            filler_slate=self.filler_slate,
            log_configuration=self.log_configuration,
            outputs=self.outputs,
            playback_mode=self.playback_mode,
            tags=self.tags,
            time_shift_configuration=self.time_shift_configuration)


def get_channel(channel_name: Optional[builtins.str] = None,
                opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetChannelResult:
    """
    Definition of AWS::MediaTailor::Channel Resource Type


    :param builtins.str channel_name: The name of the channel.
    """
    __args__ = dict()
    __args__['channelName'] = channel_name
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('aws-native:mediatailor:getChannel', __args__, opts=opts, typ=GetChannelResult).value

    return AwaitableGetChannelResult(
        arn=pulumi.get(__ret__, 'arn'),
        audiences=pulumi.get(__ret__, 'audiences'),
        filler_slate=pulumi.get(__ret__, 'filler_slate'),
        log_configuration=pulumi.get(__ret__, 'log_configuration'),
        outputs=pulumi.get(__ret__, 'outputs'),
        playback_mode=pulumi.get(__ret__, 'playback_mode'),
        tags=pulumi.get(__ret__, 'tags'),
        time_shift_configuration=pulumi.get(__ret__, 'time_shift_configuration'))
def get_channel_output(channel_name: Optional[pulumi.Input[builtins.str]] = None,
                       opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetChannelResult]:
    """
    Definition of AWS::MediaTailor::Channel Resource Type


    :param builtins.str channel_name: The name of the channel.
    """
    __args__ = dict()
    __args__['channelName'] = channel_name
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('aws-native:mediatailor:getChannel', __args__, opts=opts, typ=GetChannelResult)
    return __ret__.apply(lambda __response__: GetChannelResult(
        arn=pulumi.get(__response__, 'arn'),
        audiences=pulumi.get(__response__, 'audiences'),
        filler_slate=pulumi.get(__response__, 'filler_slate'),
        log_configuration=pulumi.get(__response__, 'log_configuration'),
        outputs=pulumi.get(__response__, 'outputs'),
        playback_mode=pulumi.get(__response__, 'playback_mode'),
        tags=pulumi.get(__response__, 'tags'),
        time_shift_configuration=pulumi.get(__response__, 'time_shift_configuration')))
