# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from ._enums import *

__all__ = [
    'ChannelDashPlaylistSettingsArgs',
    'ChannelDashPlaylistSettingsArgsDict',
    'ChannelHlsPlaylistSettingsArgs',
    'ChannelHlsPlaylistSettingsArgsDict',
    'ChannelLogConfigurationForChannelArgs',
    'ChannelLogConfigurationForChannelArgsDict',
    'ChannelRequestOutputItemArgs',
    'ChannelRequestOutputItemArgsDict',
    'ChannelSlateSourceArgs',
    'ChannelSlateSourceArgsDict',
    'ChannelTimeShiftConfigurationArgs',
    'ChannelTimeShiftConfigurationArgsDict',
    'LiveSourceHttpPackageConfigurationArgs',
    'LiveSourceHttpPackageConfigurationArgsDict',
    'PlaybackConfigurationAdConditioningConfigurationArgs',
    'PlaybackConfigurationAdConditioningConfigurationArgsDict',
    'PlaybackConfigurationAdMarkerPassthroughArgs',
    'PlaybackConfigurationAdMarkerPassthroughArgsDict',
    'PlaybackConfigurationAvailSuppressionArgs',
    'PlaybackConfigurationAvailSuppressionArgsDict',
    'PlaybackConfigurationBumperArgs',
    'PlaybackConfigurationBumperArgsDict',
    'PlaybackConfigurationCdnConfigurationArgs',
    'PlaybackConfigurationCdnConfigurationArgsDict',
    'PlaybackConfigurationDashConfigurationArgs',
    'PlaybackConfigurationDashConfigurationArgsDict',
    'PlaybackConfigurationHlsConfigurationArgs',
    'PlaybackConfigurationHlsConfigurationArgsDict',
    'PlaybackConfigurationLivePreRollConfigurationArgs',
    'PlaybackConfigurationLivePreRollConfigurationArgsDict',
    'PlaybackConfigurationManifestProcessingRulesArgs',
    'PlaybackConfigurationManifestProcessingRulesArgsDict',
    'SourceLocationAccessConfigurationArgs',
    'SourceLocationAccessConfigurationArgsDict',
    'SourceLocationDefaultSegmentDeliveryConfigurationArgs',
    'SourceLocationDefaultSegmentDeliveryConfigurationArgsDict',
    'SourceLocationHttpConfigurationArgs',
    'SourceLocationHttpConfigurationArgsDict',
    'SourceLocationSecretsManagerAccessTokenConfigurationArgs',
    'SourceLocationSecretsManagerAccessTokenConfigurationArgsDict',
    'SourceLocationSegmentDeliveryConfigurationArgs',
    'SourceLocationSegmentDeliveryConfigurationArgsDict',
    'VodSourceHttpPackageConfigurationArgs',
    'VodSourceHttpPackageConfigurationArgsDict',
]

MYPY = False

if not MYPY:
    class ChannelDashPlaylistSettingsArgsDict(TypedDict):
        """
        <p>Dash manifest configuration parameters.</p>
        """
        manifest_window_seconds: NotRequired[pulumi.Input[builtins.float]]
        """
        <p>The total duration (in seconds) of each manifest. Minimum value: <code>30</code> seconds. Maximum value: <code>3600</code> seconds.</p>
        """
        min_buffer_time_seconds: NotRequired[pulumi.Input[builtins.float]]
        """
        <p>Minimum amount of content (measured in seconds) that a player must keep available in the buffer. Minimum value: <code>2</code> seconds. Maximum value: <code>60</code> seconds.</p>
        """
        min_update_period_seconds: NotRequired[pulumi.Input[builtins.float]]
        """
        <p>Minimum amount of time (in seconds) that the player should wait before requesting updates to the manifest. Minimum value: <code>2</code> seconds. Maximum value: <code>60</code> seconds.</p>
        """
        suggested_presentation_delay_seconds: NotRequired[pulumi.Input[builtins.float]]
        """
        <p>Amount of time (in seconds) that the player should be from the live point at the end of the manifest. Minimum value: <code>2</code> seconds. Maximum value: <code>60</code> seconds.</p>
        """
elif False:
    ChannelDashPlaylistSettingsArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class ChannelDashPlaylistSettingsArgs:
    def __init__(__self__, *,
                 manifest_window_seconds: Optional[pulumi.Input[builtins.float]] = None,
                 min_buffer_time_seconds: Optional[pulumi.Input[builtins.float]] = None,
                 min_update_period_seconds: Optional[pulumi.Input[builtins.float]] = None,
                 suggested_presentation_delay_seconds: Optional[pulumi.Input[builtins.float]] = None):
        """
        <p>Dash manifest configuration parameters.</p>
        :param pulumi.Input[builtins.float] manifest_window_seconds: <p>The total duration (in seconds) of each manifest. Minimum value: <code>30</code> seconds. Maximum value: <code>3600</code> seconds.</p>
        :param pulumi.Input[builtins.float] min_buffer_time_seconds: <p>Minimum amount of content (measured in seconds) that a player must keep available in the buffer. Minimum value: <code>2</code> seconds. Maximum value: <code>60</code> seconds.</p>
        :param pulumi.Input[builtins.float] min_update_period_seconds: <p>Minimum amount of time (in seconds) that the player should wait before requesting updates to the manifest. Minimum value: <code>2</code> seconds. Maximum value: <code>60</code> seconds.</p>
        :param pulumi.Input[builtins.float] suggested_presentation_delay_seconds: <p>Amount of time (in seconds) that the player should be from the live point at the end of the manifest. Minimum value: <code>2</code> seconds. Maximum value: <code>60</code> seconds.</p>
        """
        if manifest_window_seconds is not None:
            pulumi.set(__self__, "manifest_window_seconds", manifest_window_seconds)
        if min_buffer_time_seconds is not None:
            pulumi.set(__self__, "min_buffer_time_seconds", min_buffer_time_seconds)
        if min_update_period_seconds is not None:
            pulumi.set(__self__, "min_update_period_seconds", min_update_period_seconds)
        if suggested_presentation_delay_seconds is not None:
            pulumi.set(__self__, "suggested_presentation_delay_seconds", suggested_presentation_delay_seconds)

    @property
    @pulumi.getter(name="manifestWindowSeconds")
    def manifest_window_seconds(self) -> Optional[pulumi.Input[builtins.float]]:
        """
        <p>The total duration (in seconds) of each manifest. Minimum value: <code>30</code> seconds. Maximum value: <code>3600</code> seconds.</p>
        """
        return pulumi.get(self, "manifest_window_seconds")

    @manifest_window_seconds.setter
    def manifest_window_seconds(self, value: Optional[pulumi.Input[builtins.float]]):
        pulumi.set(self, "manifest_window_seconds", value)

    @property
    @pulumi.getter(name="minBufferTimeSeconds")
    def min_buffer_time_seconds(self) -> Optional[pulumi.Input[builtins.float]]:
        """
        <p>Minimum amount of content (measured in seconds) that a player must keep available in the buffer. Minimum value: <code>2</code> seconds. Maximum value: <code>60</code> seconds.</p>
        """
        return pulumi.get(self, "min_buffer_time_seconds")

    @min_buffer_time_seconds.setter
    def min_buffer_time_seconds(self, value: Optional[pulumi.Input[builtins.float]]):
        pulumi.set(self, "min_buffer_time_seconds", value)

    @property
    @pulumi.getter(name="minUpdatePeriodSeconds")
    def min_update_period_seconds(self) -> Optional[pulumi.Input[builtins.float]]:
        """
        <p>Minimum amount of time (in seconds) that the player should wait before requesting updates to the manifest. Minimum value: <code>2</code> seconds. Maximum value: <code>60</code> seconds.</p>
        """
        return pulumi.get(self, "min_update_period_seconds")

    @min_update_period_seconds.setter
    def min_update_period_seconds(self, value: Optional[pulumi.Input[builtins.float]]):
        pulumi.set(self, "min_update_period_seconds", value)

    @property
    @pulumi.getter(name="suggestedPresentationDelaySeconds")
    def suggested_presentation_delay_seconds(self) -> Optional[pulumi.Input[builtins.float]]:
        """
        <p>Amount of time (in seconds) that the player should be from the live point at the end of the manifest. Minimum value: <code>2</code> seconds. Maximum value: <code>60</code> seconds.</p>
        """
        return pulumi.get(self, "suggested_presentation_delay_seconds")

    @suggested_presentation_delay_seconds.setter
    def suggested_presentation_delay_seconds(self, value: Optional[pulumi.Input[builtins.float]]):
        pulumi.set(self, "suggested_presentation_delay_seconds", value)


if not MYPY:
    class ChannelHlsPlaylistSettingsArgsDict(TypedDict):
        """
        <p>HLS playlist configuration parameters.</p>
        """
        ad_markup_type: NotRequired[pulumi.Input[Sequence[pulumi.Input['ChannelAdMarkupType']]]]
        """
        <p>Determines the type of SCTE 35 tags to use in ad markup. Specify <code>DATERANGE</code> to use <code>DATERANGE</code> tags (for live or VOD content). Specify <code>SCTE35_ENHANCED</code> to use <code>EXT-X-CUE-OUT</code> and <code>EXT-X-CUE-IN</code> tags (for VOD content only).</p>
        """
        manifest_window_seconds: NotRequired[pulumi.Input[builtins.float]]
        """
        <p>The total duration (in seconds) of each manifest. Minimum value: <code>30</code> seconds. Maximum value: <code>3600</code> seconds.</p>
        """
elif False:
    ChannelHlsPlaylistSettingsArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class ChannelHlsPlaylistSettingsArgs:
    def __init__(__self__, *,
                 ad_markup_type: Optional[pulumi.Input[Sequence[pulumi.Input['ChannelAdMarkupType']]]] = None,
                 manifest_window_seconds: Optional[pulumi.Input[builtins.float]] = None):
        """
        <p>HLS playlist configuration parameters.</p>
        :param pulumi.Input[Sequence[pulumi.Input['ChannelAdMarkupType']]] ad_markup_type: <p>Determines the type of SCTE 35 tags to use in ad markup. Specify <code>DATERANGE</code> to use <code>DATERANGE</code> tags (for live or VOD content). Specify <code>SCTE35_ENHANCED</code> to use <code>EXT-X-CUE-OUT</code> and <code>EXT-X-CUE-IN</code> tags (for VOD content only).</p>
        :param pulumi.Input[builtins.float] manifest_window_seconds: <p>The total duration (in seconds) of each manifest. Minimum value: <code>30</code> seconds. Maximum value: <code>3600</code> seconds.</p>
        """
        if ad_markup_type is not None:
            pulumi.set(__self__, "ad_markup_type", ad_markup_type)
        if manifest_window_seconds is not None:
            pulumi.set(__self__, "manifest_window_seconds", manifest_window_seconds)

    @property
    @pulumi.getter(name="adMarkupType")
    def ad_markup_type(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['ChannelAdMarkupType']]]]:
        """
        <p>Determines the type of SCTE 35 tags to use in ad markup. Specify <code>DATERANGE</code> to use <code>DATERANGE</code> tags (for live or VOD content). Specify <code>SCTE35_ENHANCED</code> to use <code>EXT-X-CUE-OUT</code> and <code>EXT-X-CUE-IN</code> tags (for VOD content only).</p>
        """
        return pulumi.get(self, "ad_markup_type")

    @ad_markup_type.setter
    def ad_markup_type(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['ChannelAdMarkupType']]]]):
        pulumi.set(self, "ad_markup_type", value)

    @property
    @pulumi.getter(name="manifestWindowSeconds")
    def manifest_window_seconds(self) -> Optional[pulumi.Input[builtins.float]]:
        """
        <p>The total duration (in seconds) of each manifest. Minimum value: <code>30</code> seconds. Maximum value: <code>3600</code> seconds.</p>
        """
        return pulumi.get(self, "manifest_window_seconds")

    @manifest_window_seconds.setter
    def manifest_window_seconds(self, value: Optional[pulumi.Input[builtins.float]]):
        pulumi.set(self, "manifest_window_seconds", value)


if not MYPY:
    class ChannelLogConfigurationForChannelArgsDict(TypedDict):
        """
        <p>The log configuration for the channel.</p>
        """
        log_types: NotRequired[pulumi.Input[Sequence[pulumi.Input['ChannelLogType']]]]
        """
        <p>The log types.</p>
        """
elif False:
    ChannelLogConfigurationForChannelArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class ChannelLogConfigurationForChannelArgs:
    def __init__(__self__, *,
                 log_types: Optional[pulumi.Input[Sequence[pulumi.Input['ChannelLogType']]]] = None):
        """
        <p>The log configuration for the channel.</p>
        :param pulumi.Input[Sequence[pulumi.Input['ChannelLogType']]] log_types: <p>The log types.</p>
        """
        if log_types is not None:
            pulumi.set(__self__, "log_types", log_types)

    @property
    @pulumi.getter(name="logTypes")
    def log_types(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['ChannelLogType']]]]:
        """
        <p>The log types.</p>
        """
        return pulumi.get(self, "log_types")

    @log_types.setter
    def log_types(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['ChannelLogType']]]]):
        pulumi.set(self, "log_types", value)


if not MYPY:
    class ChannelRequestOutputItemArgsDict(TypedDict):
        """
        <p>The output configuration for this channel.</p>
        """
        manifest_name: pulumi.Input[builtins.str]
        """
        <p>The name of the manifest for the channel. The name appears in the <code>PlaybackUrl</code>.</p>
        """
        source_group: pulumi.Input[builtins.str]
        """
        <p>A string used to match which <code>HttpPackageConfiguration</code> is used for each <code>VodSource</code>.</p>
        """
        dash_playlist_settings: NotRequired[pulumi.Input['ChannelDashPlaylistSettingsArgsDict']]
        """
        DASH manifest configuration parameters.
        """
        hls_playlist_settings: NotRequired[pulumi.Input['ChannelHlsPlaylistSettingsArgsDict']]
        """
        HLS playlist configuration parameters.
        """
elif False:
    ChannelRequestOutputItemArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class ChannelRequestOutputItemArgs:
    def __init__(__self__, *,
                 manifest_name: pulumi.Input[builtins.str],
                 source_group: pulumi.Input[builtins.str],
                 dash_playlist_settings: Optional[pulumi.Input['ChannelDashPlaylistSettingsArgs']] = None,
                 hls_playlist_settings: Optional[pulumi.Input['ChannelHlsPlaylistSettingsArgs']] = None):
        """
        <p>The output configuration for this channel.</p>
        :param pulumi.Input[builtins.str] manifest_name: <p>The name of the manifest for the channel. The name appears in the <code>PlaybackUrl</code>.</p>
        :param pulumi.Input[builtins.str] source_group: <p>A string used to match which <code>HttpPackageConfiguration</code> is used for each <code>VodSource</code>.</p>
        :param pulumi.Input['ChannelDashPlaylistSettingsArgs'] dash_playlist_settings: DASH manifest configuration parameters.
        :param pulumi.Input['ChannelHlsPlaylistSettingsArgs'] hls_playlist_settings: HLS playlist configuration parameters.
        """
        pulumi.set(__self__, "manifest_name", manifest_name)
        pulumi.set(__self__, "source_group", source_group)
        if dash_playlist_settings is not None:
            pulumi.set(__self__, "dash_playlist_settings", dash_playlist_settings)
        if hls_playlist_settings is not None:
            pulumi.set(__self__, "hls_playlist_settings", hls_playlist_settings)

    @property
    @pulumi.getter(name="manifestName")
    def manifest_name(self) -> pulumi.Input[builtins.str]:
        """
        <p>The name of the manifest for the channel. The name appears in the <code>PlaybackUrl</code>.</p>
        """
        return pulumi.get(self, "manifest_name")

    @manifest_name.setter
    def manifest_name(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "manifest_name", value)

    @property
    @pulumi.getter(name="sourceGroup")
    def source_group(self) -> pulumi.Input[builtins.str]:
        """
        <p>A string used to match which <code>HttpPackageConfiguration</code> is used for each <code>VodSource</code>.</p>
        """
        return pulumi.get(self, "source_group")

    @source_group.setter
    def source_group(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "source_group", value)

    @property
    @pulumi.getter(name="dashPlaylistSettings")
    def dash_playlist_settings(self) -> Optional[pulumi.Input['ChannelDashPlaylistSettingsArgs']]:
        """
        DASH manifest configuration parameters.
        """
        return pulumi.get(self, "dash_playlist_settings")

    @dash_playlist_settings.setter
    def dash_playlist_settings(self, value: Optional[pulumi.Input['ChannelDashPlaylistSettingsArgs']]):
        pulumi.set(self, "dash_playlist_settings", value)

    @property
    @pulumi.getter(name="hlsPlaylistSettings")
    def hls_playlist_settings(self) -> Optional[pulumi.Input['ChannelHlsPlaylistSettingsArgs']]:
        """
        HLS playlist configuration parameters.
        """
        return pulumi.get(self, "hls_playlist_settings")

    @hls_playlist_settings.setter
    def hls_playlist_settings(self, value: Optional[pulumi.Input['ChannelHlsPlaylistSettingsArgs']]):
        pulumi.set(self, "hls_playlist_settings", value)


if not MYPY:
    class ChannelSlateSourceArgsDict(TypedDict):
        """
        <p>Slate VOD source configuration.</p>
        """
        source_location_name: NotRequired[pulumi.Input[builtins.str]]
        """
        <p>The name of the source location where the slate VOD source is stored.</p>
        """
        vod_source_name: NotRequired[pulumi.Input[builtins.str]]
        """
        <p>The slate VOD source name. The VOD source must already exist in a source location before it can be used for slate.</p>
        """
elif False:
    ChannelSlateSourceArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class ChannelSlateSourceArgs:
    def __init__(__self__, *,
                 source_location_name: Optional[pulumi.Input[builtins.str]] = None,
                 vod_source_name: Optional[pulumi.Input[builtins.str]] = None):
        """
        <p>Slate VOD source configuration.</p>
        :param pulumi.Input[builtins.str] source_location_name: <p>The name of the source location where the slate VOD source is stored.</p>
        :param pulumi.Input[builtins.str] vod_source_name: <p>The slate VOD source name. The VOD source must already exist in a source location before it can be used for slate.</p>
        """
        if source_location_name is not None:
            pulumi.set(__self__, "source_location_name", source_location_name)
        if vod_source_name is not None:
            pulumi.set(__self__, "vod_source_name", vod_source_name)

    @property
    @pulumi.getter(name="sourceLocationName")
    def source_location_name(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        <p>The name of the source location where the slate VOD source is stored.</p>
        """
        return pulumi.get(self, "source_location_name")

    @source_location_name.setter
    def source_location_name(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "source_location_name", value)

    @property
    @pulumi.getter(name="vodSourceName")
    def vod_source_name(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        <p>The slate VOD source name. The VOD source must already exist in a source location before it can be used for slate.</p>
        """
        return pulumi.get(self, "vod_source_name")

    @vod_source_name.setter
    def vod_source_name(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "vod_source_name", value)


if not MYPY:
    class ChannelTimeShiftConfigurationArgsDict(TypedDict):
        """
        <p>The configuration for time-shifted viewing.</p>
        """
        max_time_delay_seconds: pulumi.Input[builtins.float]
        """
        <p>The maximum time delay for time-shifted viewing. The minimum allowed maximum time delay is 0 seconds, and the maximum allowed maximum time delay is 21600 seconds (6 hours).</p>
        """
elif False:
    ChannelTimeShiftConfigurationArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class ChannelTimeShiftConfigurationArgs:
    def __init__(__self__, *,
                 max_time_delay_seconds: pulumi.Input[builtins.float]):
        """
        <p>The configuration for time-shifted viewing.</p>
        :param pulumi.Input[builtins.float] max_time_delay_seconds: <p>The maximum time delay for time-shifted viewing. The minimum allowed maximum time delay is 0 seconds, and the maximum allowed maximum time delay is 21600 seconds (6 hours).</p>
        """
        pulumi.set(__self__, "max_time_delay_seconds", max_time_delay_seconds)

    @property
    @pulumi.getter(name="maxTimeDelaySeconds")
    def max_time_delay_seconds(self) -> pulumi.Input[builtins.float]:
        """
        <p>The maximum time delay for time-shifted viewing. The minimum allowed maximum time delay is 0 seconds, and the maximum allowed maximum time delay is 21600 seconds (6 hours).</p>
        """
        return pulumi.get(self, "max_time_delay_seconds")

    @max_time_delay_seconds.setter
    def max_time_delay_seconds(self, value: pulumi.Input[builtins.float]):
        pulumi.set(self, "max_time_delay_seconds", value)


if not MYPY:
    class LiveSourceHttpPackageConfigurationArgsDict(TypedDict):
        """
        <p>The HTTP package configuration properties for the requested VOD source.</p>
        """
        path: pulumi.Input[builtins.str]
        """
        <p>The relative path to the URL for this VOD source. This is combined with <code>SourceLocation::HttpConfiguration::BaseUrl</code> to form a valid URL.</p>
        """
        source_group: pulumi.Input[builtins.str]
        """
        <p>The name of the source group. This has to match one of the <code>Channel::Outputs::SourceGroup</code>.</p>
        """
        type: pulumi.Input['LiveSourceType']
        """
        The streaming protocol for this package configuration. Supported values are `HLS` and `DASH` .
        """
elif False:
    LiveSourceHttpPackageConfigurationArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class LiveSourceHttpPackageConfigurationArgs:
    def __init__(__self__, *,
                 path: pulumi.Input[builtins.str],
                 source_group: pulumi.Input[builtins.str],
                 type: pulumi.Input['LiveSourceType']):
        """
        <p>The HTTP package configuration properties for the requested VOD source.</p>
        :param pulumi.Input[builtins.str] path: <p>The relative path to the URL for this VOD source. This is combined with <code>SourceLocation::HttpConfiguration::BaseUrl</code> to form a valid URL.</p>
        :param pulumi.Input[builtins.str] source_group: <p>The name of the source group. This has to match one of the <code>Channel::Outputs::SourceGroup</code>.</p>
        :param pulumi.Input['LiveSourceType'] type: The streaming protocol for this package configuration. Supported values are `HLS` and `DASH` .
        """
        pulumi.set(__self__, "path", path)
        pulumi.set(__self__, "source_group", source_group)
        pulumi.set(__self__, "type", type)

    @property
    @pulumi.getter
    def path(self) -> pulumi.Input[builtins.str]:
        """
        <p>The relative path to the URL for this VOD source. This is combined with <code>SourceLocation::HttpConfiguration::BaseUrl</code> to form a valid URL.</p>
        """
        return pulumi.get(self, "path")

    @path.setter
    def path(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "path", value)

    @property
    @pulumi.getter(name="sourceGroup")
    def source_group(self) -> pulumi.Input[builtins.str]:
        """
        <p>The name of the source group. This has to match one of the <code>Channel::Outputs::SourceGroup</code>.</p>
        """
        return pulumi.get(self, "source_group")

    @source_group.setter
    def source_group(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "source_group", value)

    @property
    @pulumi.getter
    def type(self) -> pulumi.Input['LiveSourceType']:
        """
        The streaming protocol for this package configuration. Supported values are `HLS` and `DASH` .
        """
        return pulumi.get(self, "type")

    @type.setter
    def type(self, value: pulumi.Input['LiveSourceType']):
        pulumi.set(self, "type", value)


if not MYPY:
    class PlaybackConfigurationAdConditioningConfigurationArgsDict(TypedDict):
        """
        <p>The setting that indicates what conditioning MediaTailor will perform on ads that the ad decision server (ADS) returns.</p>
        """
        streaming_media_file_conditioning: pulumi.Input['PlaybackConfigurationStreamingMediaFileConditioning']
        """
        For ads that have media files with streaming delivery and supported file extensions, indicates what transcoding action MediaTailor takes when it first receives these ads from the ADS. `TRANSCODE` indicates that MediaTailor must transcode the ads. `NONE` indicates that you have already transcoded the ads outside of MediaTailor and don't need them transcoded as part of the ad insertion workflow. For more information about ad conditioning see [Using preconditioned ads](https://docs.aws.amazon.com/mediatailor/latest/ug/precondition-ads.html) in the AWS Elemental MediaTailor user guide.
        """
elif False:
    PlaybackConfigurationAdConditioningConfigurationArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class PlaybackConfigurationAdConditioningConfigurationArgs:
    def __init__(__self__, *,
                 streaming_media_file_conditioning: pulumi.Input['PlaybackConfigurationStreamingMediaFileConditioning']):
        """
        <p>The setting that indicates what conditioning MediaTailor will perform on ads that the ad decision server (ADS) returns.</p>
        :param pulumi.Input['PlaybackConfigurationStreamingMediaFileConditioning'] streaming_media_file_conditioning: For ads that have media files with streaming delivery and supported file extensions, indicates what transcoding action MediaTailor takes when it first receives these ads from the ADS. `TRANSCODE` indicates that MediaTailor must transcode the ads. `NONE` indicates that you have already transcoded the ads outside of MediaTailor and don't need them transcoded as part of the ad insertion workflow. For more information about ad conditioning see [Using preconditioned ads](https://docs.aws.amazon.com/mediatailor/latest/ug/precondition-ads.html) in the AWS Elemental MediaTailor user guide.
        """
        pulumi.set(__self__, "streaming_media_file_conditioning", streaming_media_file_conditioning)

    @property
    @pulumi.getter(name="streamingMediaFileConditioning")
    def streaming_media_file_conditioning(self) -> pulumi.Input['PlaybackConfigurationStreamingMediaFileConditioning']:
        """
        For ads that have media files with streaming delivery and supported file extensions, indicates what transcoding action MediaTailor takes when it first receives these ads from the ADS. `TRANSCODE` indicates that MediaTailor must transcode the ads. `NONE` indicates that you have already transcoded the ads outside of MediaTailor and don't need them transcoded as part of the ad insertion workflow. For more information about ad conditioning see [Using preconditioned ads](https://docs.aws.amazon.com/mediatailor/latest/ug/precondition-ads.html) in the AWS Elemental MediaTailor user guide.
        """
        return pulumi.get(self, "streaming_media_file_conditioning")

    @streaming_media_file_conditioning.setter
    def streaming_media_file_conditioning(self, value: pulumi.Input['PlaybackConfigurationStreamingMediaFileConditioning']):
        pulumi.set(self, "streaming_media_file_conditioning", value)


if not MYPY:
    class PlaybackConfigurationAdMarkerPassthroughArgsDict(TypedDict):
        """
        For HLS, when set to true, MediaTailor passes through EXT-X-CUE-IN, EXT-X-CUE-OUT, and EXT-X-SPLICEPOINT-SCTE35 ad markers from the origin manifest to the MediaTailor personalized manifest. No logic is applied to these ad markers. For example, if EXT-X-CUE-OUT has a value of 60, but no ads are filled for that ad break, MediaTailor will not set the value to 0.
        """
        enabled: NotRequired[pulumi.Input[builtins.bool]]
        """
        Enables ad marker passthrough for your configuration.
        """
elif False:
    PlaybackConfigurationAdMarkerPassthroughArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class PlaybackConfigurationAdMarkerPassthroughArgs:
    def __init__(__self__, *,
                 enabled: Optional[pulumi.Input[builtins.bool]] = None):
        """
        For HLS, when set to true, MediaTailor passes through EXT-X-CUE-IN, EXT-X-CUE-OUT, and EXT-X-SPLICEPOINT-SCTE35 ad markers from the origin manifest to the MediaTailor personalized manifest. No logic is applied to these ad markers. For example, if EXT-X-CUE-OUT has a value of 60, but no ads are filled for that ad break, MediaTailor will not set the value to 0.
        :param pulumi.Input[builtins.bool] enabled: Enables ad marker passthrough for your configuration.
        """
        if enabled is not None:
            pulumi.set(__self__, "enabled", enabled)

    @property
    @pulumi.getter
    def enabled(self) -> Optional[pulumi.Input[builtins.bool]]:
        """
        Enables ad marker passthrough for your configuration.
        """
        return pulumi.get(self, "enabled")

    @enabled.setter
    def enabled(self, value: Optional[pulumi.Input[builtins.bool]]):
        pulumi.set(self, "enabled", value)


if not MYPY:
    class PlaybackConfigurationAvailSuppressionArgsDict(TypedDict):
        """
        The configuration for avail suppression, also known as ad suppression. For more information about ad suppression, see Ad Suppression (https://docs.aws.amazon.com/mediatailor/latest/ug/ad-behavior.html).
        """
        fill_policy: NotRequired[pulumi.Input['PlaybackConfigurationAvailSuppressionFillPolicy']]
        """
        Defines the policy to apply to the avail suppression mode. BEHIND_LIVE_EDGE will always use the full avail suppression policy. AFTER_LIVE_EDGE mode can be used to invoke partial ad break fills when a session starts mid-break. Valid values are FULL_AVAIL_ONLY and PARTIAL_AVAIL
        """
        mode: NotRequired[pulumi.Input['PlaybackConfigurationAvailSuppressionMode']]
        """
        Sets the ad suppression mode. By default, ad suppression is off and all ad breaks are filled with ads or slate. When Mode is set to BEHIND_LIVE_EDGE, ad suppression is active and MediaTailor won't fill ad breaks on or behind the ad suppression Value time in the manifest lookback window. When Mode is set to AFTER_LIVE_EDGE, ad suppression is active and MediaTailor won't fill ad breaks that are within the live edge plus the avail suppression value.
        """
        value: NotRequired[pulumi.Input[builtins.str]]
        """
        A live edge offset time in HH:MM:SS. MediaTailor won't fill ad breaks on or behind this time in the manifest lookback window. If Value is set to 00:00:00, it is in sync with the live edge, and MediaTailor won't fill any ad breaks on or behind the live edge. If you set a Value time, MediaTailor won't fill any ad breaks on or behind this time in the manifest lookback window. For example, if you set 00:45:00, then MediaTailor will fill ad breaks that occur within 45 minutes behind the live edge, but won't fill ad breaks on or behind 45 minutes behind the live edge.
        """
elif False:
    PlaybackConfigurationAvailSuppressionArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class PlaybackConfigurationAvailSuppressionArgs:
    def __init__(__self__, *,
                 fill_policy: Optional[pulumi.Input['PlaybackConfigurationAvailSuppressionFillPolicy']] = None,
                 mode: Optional[pulumi.Input['PlaybackConfigurationAvailSuppressionMode']] = None,
                 value: Optional[pulumi.Input[builtins.str]] = None):
        """
        The configuration for avail suppression, also known as ad suppression. For more information about ad suppression, see Ad Suppression (https://docs.aws.amazon.com/mediatailor/latest/ug/ad-behavior.html).
        :param pulumi.Input['PlaybackConfigurationAvailSuppressionFillPolicy'] fill_policy: Defines the policy to apply to the avail suppression mode. BEHIND_LIVE_EDGE will always use the full avail suppression policy. AFTER_LIVE_EDGE mode can be used to invoke partial ad break fills when a session starts mid-break. Valid values are FULL_AVAIL_ONLY and PARTIAL_AVAIL
        :param pulumi.Input['PlaybackConfigurationAvailSuppressionMode'] mode: Sets the ad suppression mode. By default, ad suppression is off and all ad breaks are filled with ads or slate. When Mode is set to BEHIND_LIVE_EDGE, ad suppression is active and MediaTailor won't fill ad breaks on or behind the ad suppression Value time in the manifest lookback window. When Mode is set to AFTER_LIVE_EDGE, ad suppression is active and MediaTailor won't fill ad breaks that are within the live edge plus the avail suppression value.
        :param pulumi.Input[builtins.str] value: A live edge offset time in HH:MM:SS. MediaTailor won't fill ad breaks on or behind this time in the manifest lookback window. If Value is set to 00:00:00, it is in sync with the live edge, and MediaTailor won't fill any ad breaks on or behind the live edge. If you set a Value time, MediaTailor won't fill any ad breaks on or behind this time in the manifest lookback window. For example, if you set 00:45:00, then MediaTailor will fill ad breaks that occur within 45 minutes behind the live edge, but won't fill ad breaks on or behind 45 minutes behind the live edge.
        """
        if fill_policy is not None:
            pulumi.set(__self__, "fill_policy", fill_policy)
        if mode is not None:
            pulumi.set(__self__, "mode", mode)
        if value is not None:
            pulumi.set(__self__, "value", value)

    @property
    @pulumi.getter(name="fillPolicy")
    def fill_policy(self) -> Optional[pulumi.Input['PlaybackConfigurationAvailSuppressionFillPolicy']]:
        """
        Defines the policy to apply to the avail suppression mode. BEHIND_LIVE_EDGE will always use the full avail suppression policy. AFTER_LIVE_EDGE mode can be used to invoke partial ad break fills when a session starts mid-break. Valid values are FULL_AVAIL_ONLY and PARTIAL_AVAIL
        """
        return pulumi.get(self, "fill_policy")

    @fill_policy.setter
    def fill_policy(self, value: Optional[pulumi.Input['PlaybackConfigurationAvailSuppressionFillPolicy']]):
        pulumi.set(self, "fill_policy", value)

    @property
    @pulumi.getter
    def mode(self) -> Optional[pulumi.Input['PlaybackConfigurationAvailSuppressionMode']]:
        """
        Sets the ad suppression mode. By default, ad suppression is off and all ad breaks are filled with ads or slate. When Mode is set to BEHIND_LIVE_EDGE, ad suppression is active and MediaTailor won't fill ad breaks on or behind the ad suppression Value time in the manifest lookback window. When Mode is set to AFTER_LIVE_EDGE, ad suppression is active and MediaTailor won't fill ad breaks that are within the live edge plus the avail suppression value.
        """
        return pulumi.get(self, "mode")

    @mode.setter
    def mode(self, value: Optional[pulumi.Input['PlaybackConfigurationAvailSuppressionMode']]):
        pulumi.set(self, "mode", value)

    @property
    @pulumi.getter
    def value(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        A live edge offset time in HH:MM:SS. MediaTailor won't fill ad breaks on or behind this time in the manifest lookback window. If Value is set to 00:00:00, it is in sync with the live edge, and MediaTailor won't fill any ad breaks on or behind the live edge. If you set a Value time, MediaTailor won't fill any ad breaks on or behind this time in the manifest lookback window. For example, if you set 00:45:00, then MediaTailor will fill ad breaks that occur within 45 minutes behind the live edge, but won't fill ad breaks on or behind 45 minutes behind the live edge.
        """
        return pulumi.get(self, "value")

    @value.setter
    def value(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "value", value)


if not MYPY:
    class PlaybackConfigurationBumperArgsDict(TypedDict):
        """
        The configuration for bumpers. Bumpers are short audio or video clips that play at the start or before the end of an ad break. To learn more about bumpers, see Bumpers (https://docs.aws.amazon.com/mediatailor/latest/ug/bumpers.html).
        """
        end_url: NotRequired[pulumi.Input[builtins.str]]
        """
        The URL for the end bumper asset.
        """
        start_url: NotRequired[pulumi.Input[builtins.str]]
        """
        The URL for the start bumper asset.
        """
elif False:
    PlaybackConfigurationBumperArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class PlaybackConfigurationBumperArgs:
    def __init__(__self__, *,
                 end_url: Optional[pulumi.Input[builtins.str]] = None,
                 start_url: Optional[pulumi.Input[builtins.str]] = None):
        """
        The configuration for bumpers. Bumpers are short audio or video clips that play at the start or before the end of an ad break. To learn more about bumpers, see Bumpers (https://docs.aws.amazon.com/mediatailor/latest/ug/bumpers.html).
        :param pulumi.Input[builtins.str] end_url: The URL for the end bumper asset.
        :param pulumi.Input[builtins.str] start_url: The URL for the start bumper asset.
        """
        if end_url is not None:
            pulumi.set(__self__, "end_url", end_url)
        if start_url is not None:
            pulumi.set(__self__, "start_url", start_url)

    @property
    @pulumi.getter(name="endUrl")
    def end_url(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The URL for the end bumper asset.
        """
        return pulumi.get(self, "end_url")

    @end_url.setter
    def end_url(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "end_url", value)

    @property
    @pulumi.getter(name="startUrl")
    def start_url(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The URL for the start bumper asset.
        """
        return pulumi.get(self, "start_url")

    @start_url.setter
    def start_url(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "start_url", value)


if not MYPY:
    class PlaybackConfigurationCdnConfigurationArgsDict(TypedDict):
        """
        The configuration for using a content delivery network (CDN), like Amazon CloudFront, for content and ad segment management.
        """
        ad_segment_url_prefix: NotRequired[pulumi.Input[builtins.str]]
        """
        A non-default content delivery network (CDN) to serve ad segments. By default, AWS Elemental MediaTailor uses Amazon CloudFront with default cache settings as its CDN for ad segments. To set up an alternate CDN, create a rule in your CDN for the origin ads.mediatailor.&lt;region>.amazonaws.com. Then specify the rule's name in this AdSegmentUrlPrefix. When AWS Elemental MediaTailor serves a manifest, it reports your CDN as the source for ad segments.
        """
        content_segment_url_prefix: NotRequired[pulumi.Input[builtins.str]]
        """
        A content delivery network (CDN) to cache content segments, so that content requests don't always have to go to the origin server. First, create a rule in your CDN for the content segment origin server. Then specify the rule's name in this ContentSegmentUrlPrefix. When AWS Elemental MediaTailor serves a manifest, it reports your CDN as the source for content segments.
        """
elif False:
    PlaybackConfigurationCdnConfigurationArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class PlaybackConfigurationCdnConfigurationArgs:
    def __init__(__self__, *,
                 ad_segment_url_prefix: Optional[pulumi.Input[builtins.str]] = None,
                 content_segment_url_prefix: Optional[pulumi.Input[builtins.str]] = None):
        """
        The configuration for using a content delivery network (CDN), like Amazon CloudFront, for content and ad segment management.
        :param pulumi.Input[builtins.str] ad_segment_url_prefix: A non-default content delivery network (CDN) to serve ad segments. By default, AWS Elemental MediaTailor uses Amazon CloudFront with default cache settings as its CDN for ad segments. To set up an alternate CDN, create a rule in your CDN for the origin ads.mediatailor.&lt;region>.amazonaws.com. Then specify the rule's name in this AdSegmentUrlPrefix. When AWS Elemental MediaTailor serves a manifest, it reports your CDN as the source for ad segments.
        :param pulumi.Input[builtins.str] content_segment_url_prefix: A content delivery network (CDN) to cache content segments, so that content requests don't always have to go to the origin server. First, create a rule in your CDN for the content segment origin server. Then specify the rule's name in this ContentSegmentUrlPrefix. When AWS Elemental MediaTailor serves a manifest, it reports your CDN as the source for content segments.
        """
        if ad_segment_url_prefix is not None:
            pulumi.set(__self__, "ad_segment_url_prefix", ad_segment_url_prefix)
        if content_segment_url_prefix is not None:
            pulumi.set(__self__, "content_segment_url_prefix", content_segment_url_prefix)

    @property
    @pulumi.getter(name="adSegmentUrlPrefix")
    def ad_segment_url_prefix(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        A non-default content delivery network (CDN) to serve ad segments. By default, AWS Elemental MediaTailor uses Amazon CloudFront with default cache settings as its CDN for ad segments. To set up an alternate CDN, create a rule in your CDN for the origin ads.mediatailor.&lt;region>.amazonaws.com. Then specify the rule's name in this AdSegmentUrlPrefix. When AWS Elemental MediaTailor serves a manifest, it reports your CDN as the source for ad segments.
        """
        return pulumi.get(self, "ad_segment_url_prefix")

    @ad_segment_url_prefix.setter
    def ad_segment_url_prefix(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "ad_segment_url_prefix", value)

    @property
    @pulumi.getter(name="contentSegmentUrlPrefix")
    def content_segment_url_prefix(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        A content delivery network (CDN) to cache content segments, so that content requests don't always have to go to the origin server. First, create a rule in your CDN for the content segment origin server. Then specify the rule's name in this ContentSegmentUrlPrefix. When AWS Elemental MediaTailor serves a manifest, it reports your CDN as the source for content segments.
        """
        return pulumi.get(self, "content_segment_url_prefix")

    @content_segment_url_prefix.setter
    def content_segment_url_prefix(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "content_segment_url_prefix", value)


if not MYPY:
    class PlaybackConfigurationDashConfigurationArgsDict(TypedDict):
        """
        The configuration for DASH PUT operations.
        """
        manifest_endpoint_prefix: NotRequired[pulumi.Input[builtins.str]]
        """
        The URL generated by MediaTailor to initiate a DASH playback session. The session uses server-side reporting.
        """
        mpd_location: NotRequired[pulumi.Input[builtins.str]]
        """
        The setting that controls whether MediaTailor includes the Location tag in DASH manifests. MediaTailor populates the Location tag with the URL for manifest update requests, to be used by players that don't support sticky redirects. Disable this if you have CDN routing rules set up for accessing MediaTailor manifests, and you are either using client-side reporting or your players support sticky HTTP redirects. Valid values are DISABLED and EMT_DEFAULT. The EMT_DEFAULT setting enables the inclusion of the tag and is the default value.
        """
        origin_manifest_type: NotRequired[pulumi.Input['PlaybackConfigurationDashConfigurationOriginManifestType']]
        """
        The setting that controls whether MediaTailor handles manifests from the origin server as multi-period manifests or single-period manifests. If your origin server produces single-period manifests, set this to SINGLE_PERIOD. The default setting is MULTI_PERIOD. For multi-period manifests, omit this setting or set it to MULTI_PERIOD.
        """
elif False:
    PlaybackConfigurationDashConfigurationArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class PlaybackConfigurationDashConfigurationArgs:
    def __init__(__self__, *,
                 manifest_endpoint_prefix: Optional[pulumi.Input[builtins.str]] = None,
                 mpd_location: Optional[pulumi.Input[builtins.str]] = None,
                 origin_manifest_type: Optional[pulumi.Input['PlaybackConfigurationDashConfigurationOriginManifestType']] = None):
        """
        The configuration for DASH PUT operations.
        :param pulumi.Input[builtins.str] manifest_endpoint_prefix: The URL generated by MediaTailor to initiate a DASH playback session. The session uses server-side reporting.
        :param pulumi.Input[builtins.str] mpd_location: The setting that controls whether MediaTailor includes the Location tag in DASH manifests. MediaTailor populates the Location tag with the URL for manifest update requests, to be used by players that don't support sticky redirects. Disable this if you have CDN routing rules set up for accessing MediaTailor manifests, and you are either using client-side reporting or your players support sticky HTTP redirects. Valid values are DISABLED and EMT_DEFAULT. The EMT_DEFAULT setting enables the inclusion of the tag and is the default value.
        :param pulumi.Input['PlaybackConfigurationDashConfigurationOriginManifestType'] origin_manifest_type: The setting that controls whether MediaTailor handles manifests from the origin server as multi-period manifests or single-period manifests. If your origin server produces single-period manifests, set this to SINGLE_PERIOD. The default setting is MULTI_PERIOD. For multi-period manifests, omit this setting or set it to MULTI_PERIOD.
        """
        if manifest_endpoint_prefix is not None:
            pulumi.set(__self__, "manifest_endpoint_prefix", manifest_endpoint_prefix)
        if mpd_location is not None:
            pulumi.set(__self__, "mpd_location", mpd_location)
        if origin_manifest_type is not None:
            pulumi.set(__self__, "origin_manifest_type", origin_manifest_type)

    @property
    @pulumi.getter(name="manifestEndpointPrefix")
    def manifest_endpoint_prefix(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The URL generated by MediaTailor to initiate a DASH playback session. The session uses server-side reporting.
        """
        return pulumi.get(self, "manifest_endpoint_prefix")

    @manifest_endpoint_prefix.setter
    def manifest_endpoint_prefix(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "manifest_endpoint_prefix", value)

    @property
    @pulumi.getter(name="mpdLocation")
    def mpd_location(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The setting that controls whether MediaTailor includes the Location tag in DASH manifests. MediaTailor populates the Location tag with the URL for manifest update requests, to be used by players that don't support sticky redirects. Disable this if you have CDN routing rules set up for accessing MediaTailor manifests, and you are either using client-side reporting or your players support sticky HTTP redirects. Valid values are DISABLED and EMT_DEFAULT. The EMT_DEFAULT setting enables the inclusion of the tag and is the default value.
        """
        return pulumi.get(self, "mpd_location")

    @mpd_location.setter
    def mpd_location(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "mpd_location", value)

    @property
    @pulumi.getter(name="originManifestType")
    def origin_manifest_type(self) -> Optional[pulumi.Input['PlaybackConfigurationDashConfigurationOriginManifestType']]:
        """
        The setting that controls whether MediaTailor handles manifests from the origin server as multi-period manifests or single-period manifests. If your origin server produces single-period manifests, set this to SINGLE_PERIOD. The default setting is MULTI_PERIOD. For multi-period manifests, omit this setting or set it to MULTI_PERIOD.
        """
        return pulumi.get(self, "origin_manifest_type")

    @origin_manifest_type.setter
    def origin_manifest_type(self, value: Optional[pulumi.Input['PlaybackConfigurationDashConfigurationOriginManifestType']]):
        pulumi.set(self, "origin_manifest_type", value)


if not MYPY:
    class PlaybackConfigurationHlsConfigurationArgsDict(TypedDict):
        manifest_endpoint_prefix: NotRequired[pulumi.Input[builtins.str]]
        """
        The URL that is used to initiate a playback session for devices that support Apple HLS. The session uses server-side reporting.
        """
elif False:
    PlaybackConfigurationHlsConfigurationArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class PlaybackConfigurationHlsConfigurationArgs:
    def __init__(__self__, *,
                 manifest_endpoint_prefix: Optional[pulumi.Input[builtins.str]] = None):
        """
        :param pulumi.Input[builtins.str] manifest_endpoint_prefix: The URL that is used to initiate a playback session for devices that support Apple HLS. The session uses server-side reporting.
        """
        if manifest_endpoint_prefix is not None:
            pulumi.set(__self__, "manifest_endpoint_prefix", manifest_endpoint_prefix)

    @property
    @pulumi.getter(name="manifestEndpointPrefix")
    def manifest_endpoint_prefix(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The URL that is used to initiate a playback session for devices that support Apple HLS. The session uses server-side reporting.
        """
        return pulumi.get(self, "manifest_endpoint_prefix")

    @manifest_endpoint_prefix.setter
    def manifest_endpoint_prefix(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "manifest_endpoint_prefix", value)


if not MYPY:
    class PlaybackConfigurationLivePreRollConfigurationArgsDict(TypedDict):
        """
        The configuration for pre-roll ad insertion.
        """
        ad_decision_server_url: NotRequired[pulumi.Input[builtins.str]]
        """
        The URL for the ad decision server (ADS) for pre-roll ads. This includes the specification of static parameters and placeholders for dynamic parameters. AWS Elemental MediaTailor substitutes player-specific and session-specific parameters as needed when calling the ADS. Alternately, for testing, you can provide a static VAST URL. The maximum length is 25,000 characters.
        """
        max_duration_seconds: NotRequired[pulumi.Input[builtins.int]]
        """
        The maximum allowed duration for the pre-roll ad avail. AWS Elemental MediaTailor won't play pre-roll ads to exceed this duration, regardless of the total duration of ads that the ADS returns.
        """
elif False:
    PlaybackConfigurationLivePreRollConfigurationArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class PlaybackConfigurationLivePreRollConfigurationArgs:
    def __init__(__self__, *,
                 ad_decision_server_url: Optional[pulumi.Input[builtins.str]] = None,
                 max_duration_seconds: Optional[pulumi.Input[builtins.int]] = None):
        """
        The configuration for pre-roll ad insertion.
        :param pulumi.Input[builtins.str] ad_decision_server_url: The URL for the ad decision server (ADS) for pre-roll ads. This includes the specification of static parameters and placeholders for dynamic parameters. AWS Elemental MediaTailor substitutes player-specific and session-specific parameters as needed when calling the ADS. Alternately, for testing, you can provide a static VAST URL. The maximum length is 25,000 characters.
        :param pulumi.Input[builtins.int] max_duration_seconds: The maximum allowed duration for the pre-roll ad avail. AWS Elemental MediaTailor won't play pre-roll ads to exceed this duration, regardless of the total duration of ads that the ADS returns.
        """
        if ad_decision_server_url is not None:
            pulumi.set(__self__, "ad_decision_server_url", ad_decision_server_url)
        if max_duration_seconds is not None:
            pulumi.set(__self__, "max_duration_seconds", max_duration_seconds)

    @property
    @pulumi.getter(name="adDecisionServerUrl")
    def ad_decision_server_url(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The URL for the ad decision server (ADS) for pre-roll ads. This includes the specification of static parameters and placeholders for dynamic parameters. AWS Elemental MediaTailor substitutes player-specific and session-specific parameters as needed when calling the ADS. Alternately, for testing, you can provide a static VAST URL. The maximum length is 25,000 characters.
        """
        return pulumi.get(self, "ad_decision_server_url")

    @ad_decision_server_url.setter
    def ad_decision_server_url(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "ad_decision_server_url", value)

    @property
    @pulumi.getter(name="maxDurationSeconds")
    def max_duration_seconds(self) -> Optional[pulumi.Input[builtins.int]]:
        """
        The maximum allowed duration for the pre-roll ad avail. AWS Elemental MediaTailor won't play pre-roll ads to exceed this duration, regardless of the total duration of ads that the ADS returns.
        """
        return pulumi.get(self, "max_duration_seconds")

    @max_duration_seconds.setter
    def max_duration_seconds(self, value: Optional[pulumi.Input[builtins.int]]):
        pulumi.set(self, "max_duration_seconds", value)


if not MYPY:
    class PlaybackConfigurationManifestProcessingRulesArgsDict(TypedDict):
        """
        The configuration for manifest processing rules. Manifest processing rules enable customization of the personalized manifests created by MediaTailor.
        """
        ad_marker_passthrough: NotRequired[pulumi.Input['PlaybackConfigurationAdMarkerPassthroughArgsDict']]
        """
        For HLS, when set to true, MediaTailor passes through EXT-X-CUE-IN, EXT-X-CUE-OUT, and EXT-X-SPLICEPOINT-SCTE35 ad markers from the origin manifest to the MediaTailor personalized manifest. No logic is applied to these ad markers. For example, if EXT-X-CUE-OUT has a value of 60, but no ads are filled for that ad break, MediaTailor will not set the value to 0.
        """
elif False:
    PlaybackConfigurationManifestProcessingRulesArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class PlaybackConfigurationManifestProcessingRulesArgs:
    def __init__(__self__, *,
                 ad_marker_passthrough: Optional[pulumi.Input['PlaybackConfigurationAdMarkerPassthroughArgs']] = None):
        """
        The configuration for manifest processing rules. Manifest processing rules enable customization of the personalized manifests created by MediaTailor.
        :param pulumi.Input['PlaybackConfigurationAdMarkerPassthroughArgs'] ad_marker_passthrough: For HLS, when set to true, MediaTailor passes through EXT-X-CUE-IN, EXT-X-CUE-OUT, and EXT-X-SPLICEPOINT-SCTE35 ad markers from the origin manifest to the MediaTailor personalized manifest. No logic is applied to these ad markers. For example, if EXT-X-CUE-OUT has a value of 60, but no ads are filled for that ad break, MediaTailor will not set the value to 0.
        """
        if ad_marker_passthrough is not None:
            pulumi.set(__self__, "ad_marker_passthrough", ad_marker_passthrough)

    @property
    @pulumi.getter(name="adMarkerPassthrough")
    def ad_marker_passthrough(self) -> Optional[pulumi.Input['PlaybackConfigurationAdMarkerPassthroughArgs']]:
        """
        For HLS, when set to true, MediaTailor passes through EXT-X-CUE-IN, EXT-X-CUE-OUT, and EXT-X-SPLICEPOINT-SCTE35 ad markers from the origin manifest to the MediaTailor personalized manifest. No logic is applied to these ad markers. For example, if EXT-X-CUE-OUT has a value of 60, but no ads are filled for that ad break, MediaTailor will not set the value to 0.
        """
        return pulumi.get(self, "ad_marker_passthrough")

    @ad_marker_passthrough.setter
    def ad_marker_passthrough(self, value: Optional[pulumi.Input['PlaybackConfigurationAdMarkerPassthroughArgs']]):
        pulumi.set(self, "ad_marker_passthrough", value)


if not MYPY:
    class SourceLocationAccessConfigurationArgsDict(TypedDict):
        """
        <p>Access configuration parameters.</p>
        """
        access_type: NotRequired[pulumi.Input['SourceLocationAccessType']]
        """
        The type of authentication used to access content from `HttpConfiguration::BaseUrl` on your source location. Accepted value: `S3_SIGV4` .

        `S3_SIGV4` - AWS Signature Version 4 authentication for Amazon S3 hosted virtual-style access. If your source location base URL is an Amazon S3 bucket, MediaTailor can use AWS Signature Version 4 (SigV4) authentication to access the bucket where your source content is stored. Your MediaTailor source location baseURL must follow the S3 virtual hosted-style request URL format. For example, https://bucket-name.s3.Region.amazonaws.com/key-name.

        Before you can use `S3_SIGV4` , you must meet these requirements:

        • You must allow MediaTailor to access your S3 bucket by granting mediatailor.amazonaws.com principal access in IAM. For information about configuring access in IAM, see Access management in the IAM User Guide.

        • The mediatailor.amazonaws.com service principal must have permissions to read all top level manifests referenced by the VodSource packaging configurations.

        • The caller of the API must have s3:GetObject IAM permissions to read all top level manifests referenced by your MediaTailor VodSource packaging configurations.
        """
        secrets_manager_access_token_configuration: NotRequired[pulumi.Input['SourceLocationSecretsManagerAccessTokenConfigurationArgsDict']]
        """
        AWS Secrets Manager access token configuration parameters.
        """
elif False:
    SourceLocationAccessConfigurationArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class SourceLocationAccessConfigurationArgs:
    def __init__(__self__, *,
                 access_type: Optional[pulumi.Input['SourceLocationAccessType']] = None,
                 secrets_manager_access_token_configuration: Optional[pulumi.Input['SourceLocationSecretsManagerAccessTokenConfigurationArgs']] = None):
        """
        <p>Access configuration parameters.</p>
        :param pulumi.Input['SourceLocationAccessType'] access_type: The type of authentication used to access content from `HttpConfiguration::BaseUrl` on your source location. Accepted value: `S3_SIGV4` .
               
               `S3_SIGV4` - AWS Signature Version 4 authentication for Amazon S3 hosted virtual-style access. If your source location base URL is an Amazon S3 bucket, MediaTailor can use AWS Signature Version 4 (SigV4) authentication to access the bucket where your source content is stored. Your MediaTailor source location baseURL must follow the S3 virtual hosted-style request URL format. For example, https://bucket-name.s3.Region.amazonaws.com/key-name.
               
               Before you can use `S3_SIGV4` , you must meet these requirements:
               
               • You must allow MediaTailor to access your S3 bucket by granting mediatailor.amazonaws.com principal access in IAM. For information about configuring access in IAM, see Access management in the IAM User Guide.
               
               • The mediatailor.amazonaws.com service principal must have permissions to read all top level manifests referenced by the VodSource packaging configurations.
               
               • The caller of the API must have s3:GetObject IAM permissions to read all top level manifests referenced by your MediaTailor VodSource packaging configurations.
        :param pulumi.Input['SourceLocationSecretsManagerAccessTokenConfigurationArgs'] secrets_manager_access_token_configuration: AWS Secrets Manager access token configuration parameters.
        """
        if access_type is not None:
            pulumi.set(__self__, "access_type", access_type)
        if secrets_manager_access_token_configuration is not None:
            pulumi.set(__self__, "secrets_manager_access_token_configuration", secrets_manager_access_token_configuration)

    @property
    @pulumi.getter(name="accessType")
    def access_type(self) -> Optional[pulumi.Input['SourceLocationAccessType']]:
        """
        The type of authentication used to access content from `HttpConfiguration::BaseUrl` on your source location. Accepted value: `S3_SIGV4` .

        `S3_SIGV4` - AWS Signature Version 4 authentication for Amazon S3 hosted virtual-style access. If your source location base URL is an Amazon S3 bucket, MediaTailor can use AWS Signature Version 4 (SigV4) authentication to access the bucket where your source content is stored. Your MediaTailor source location baseURL must follow the S3 virtual hosted-style request URL format. For example, https://bucket-name.s3.Region.amazonaws.com/key-name.

        Before you can use `S3_SIGV4` , you must meet these requirements:

        • You must allow MediaTailor to access your S3 bucket by granting mediatailor.amazonaws.com principal access in IAM. For information about configuring access in IAM, see Access management in the IAM User Guide.

        • The mediatailor.amazonaws.com service principal must have permissions to read all top level manifests referenced by the VodSource packaging configurations.

        • The caller of the API must have s3:GetObject IAM permissions to read all top level manifests referenced by your MediaTailor VodSource packaging configurations.
        """
        return pulumi.get(self, "access_type")

    @access_type.setter
    def access_type(self, value: Optional[pulumi.Input['SourceLocationAccessType']]):
        pulumi.set(self, "access_type", value)

    @property
    @pulumi.getter(name="secretsManagerAccessTokenConfiguration")
    def secrets_manager_access_token_configuration(self) -> Optional[pulumi.Input['SourceLocationSecretsManagerAccessTokenConfigurationArgs']]:
        """
        AWS Secrets Manager access token configuration parameters.
        """
        return pulumi.get(self, "secrets_manager_access_token_configuration")

    @secrets_manager_access_token_configuration.setter
    def secrets_manager_access_token_configuration(self, value: Optional[pulumi.Input['SourceLocationSecretsManagerAccessTokenConfigurationArgs']]):
        pulumi.set(self, "secrets_manager_access_token_configuration", value)


if not MYPY:
    class SourceLocationDefaultSegmentDeliveryConfigurationArgsDict(TypedDict):
        """
        <p>The optional configuration for a server that serves segments. Use this if you want the segment delivery server to be different from the source location server. For example, you can configure your source location server to be an origination server, such as MediaPackage, and the segment delivery server to be a content delivery network (CDN), such as CloudFront. If you don't specify a segment delivery server, then the source location server is used.</p>
        """
        base_url: NotRequired[pulumi.Input[builtins.str]]
        """
        <p>The hostname of the server that will be used to serve segments. This string must include the protocol, such as <b>https://</b>.</p>
        """
elif False:
    SourceLocationDefaultSegmentDeliveryConfigurationArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class SourceLocationDefaultSegmentDeliveryConfigurationArgs:
    def __init__(__self__, *,
                 base_url: Optional[pulumi.Input[builtins.str]] = None):
        """
        <p>The optional configuration for a server that serves segments. Use this if you want the segment delivery server to be different from the source location server. For example, you can configure your source location server to be an origination server, such as MediaPackage, and the segment delivery server to be a content delivery network (CDN), such as CloudFront. If you don't specify a segment delivery server, then the source location server is used.</p>
        :param pulumi.Input[builtins.str] base_url: <p>The hostname of the server that will be used to serve segments. This string must include the protocol, such as <b>https://</b>.</p>
        """
        if base_url is not None:
            pulumi.set(__self__, "base_url", base_url)

    @property
    @pulumi.getter(name="baseUrl")
    def base_url(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        <p>The hostname of the server that will be used to serve segments. This string must include the protocol, such as <b>https://</b>.</p>
        """
        return pulumi.get(self, "base_url")

    @base_url.setter
    def base_url(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "base_url", value)


if not MYPY:
    class SourceLocationHttpConfigurationArgsDict(TypedDict):
        """
        <p>The HTTP configuration for the source location.</p>
        """
        base_url: pulumi.Input[builtins.str]
        """
        <p>The base URL for the source location host server. This string must include the protocol, such as <b>https://</b>.</p>
        """
elif False:
    SourceLocationHttpConfigurationArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class SourceLocationHttpConfigurationArgs:
    def __init__(__self__, *,
                 base_url: pulumi.Input[builtins.str]):
        """
        <p>The HTTP configuration for the source location.</p>
        :param pulumi.Input[builtins.str] base_url: <p>The base URL for the source location host server. This string must include the protocol, such as <b>https://</b>.</p>
        """
        pulumi.set(__self__, "base_url", base_url)

    @property
    @pulumi.getter(name="baseUrl")
    def base_url(self) -> pulumi.Input[builtins.str]:
        """
        <p>The base URL for the source location host server. This string must include the protocol, such as <b>https://</b>.</p>
        """
        return pulumi.get(self, "base_url")

    @base_url.setter
    def base_url(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "base_url", value)


if not MYPY:
    class SourceLocationSecretsManagerAccessTokenConfigurationArgsDict(TypedDict):
        """
        <p>AWS Secrets Manager access token configuration parameters. For information about Secrets Manager access token authentication, see <a href="https://docs.aws.amazon.com/mediatailor/latest/ug/channel-assembly-access-configuration-access-token.html">Working with AWS Secrets Manager access token authentication</a>.</p>
        """
        header_name: NotRequired[pulumi.Input[builtins.str]]
        """
        <p>The name of the HTTP header used to supply the access token in requests to the source location.</p>
        """
        secret_arn: NotRequired[pulumi.Input[builtins.str]]
        """
        <p>The Amazon Resource Name (ARN) of the AWS Secrets Manager secret that contains the access token.</p>
        """
        secret_string_key: NotRequired[pulumi.Input[builtins.str]]
        """
        <p>The AWS Secrets Manager <a href="https://docs.aws.amazon.com/secretsmanager/latest/apireference/API_CreateSecret.html#SecretsManager-CreateSecret-request-SecretString.html">SecretString</a> key associated with the access token. MediaTailor uses the key to look up SecretString key and value pair containing the access token.</p>
        """
elif False:
    SourceLocationSecretsManagerAccessTokenConfigurationArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class SourceLocationSecretsManagerAccessTokenConfigurationArgs:
    def __init__(__self__, *,
                 header_name: Optional[pulumi.Input[builtins.str]] = None,
                 secret_arn: Optional[pulumi.Input[builtins.str]] = None,
                 secret_string_key: Optional[pulumi.Input[builtins.str]] = None):
        """
        <p>AWS Secrets Manager access token configuration parameters. For information about Secrets Manager access token authentication, see <a href="https://docs.aws.amazon.com/mediatailor/latest/ug/channel-assembly-access-configuration-access-token.html">Working with AWS Secrets Manager access token authentication</a>.</p>
        :param pulumi.Input[builtins.str] header_name: <p>The name of the HTTP header used to supply the access token in requests to the source location.</p>
        :param pulumi.Input[builtins.str] secret_arn: <p>The Amazon Resource Name (ARN) of the AWS Secrets Manager secret that contains the access token.</p>
        :param pulumi.Input[builtins.str] secret_string_key: <p>The AWS Secrets Manager <a href="https://docs.aws.amazon.com/secretsmanager/latest/apireference/API_CreateSecret.html#SecretsManager-CreateSecret-request-SecretString.html">SecretString</a> key associated with the access token. MediaTailor uses the key to look up SecretString key and value pair containing the access token.</p>
        """
        if header_name is not None:
            pulumi.set(__self__, "header_name", header_name)
        if secret_arn is not None:
            pulumi.set(__self__, "secret_arn", secret_arn)
        if secret_string_key is not None:
            pulumi.set(__self__, "secret_string_key", secret_string_key)

    @property
    @pulumi.getter(name="headerName")
    def header_name(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        <p>The name of the HTTP header used to supply the access token in requests to the source location.</p>
        """
        return pulumi.get(self, "header_name")

    @header_name.setter
    def header_name(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "header_name", value)

    @property
    @pulumi.getter(name="secretArn")
    def secret_arn(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        <p>The Amazon Resource Name (ARN) of the AWS Secrets Manager secret that contains the access token.</p>
        """
        return pulumi.get(self, "secret_arn")

    @secret_arn.setter
    def secret_arn(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "secret_arn", value)

    @property
    @pulumi.getter(name="secretStringKey")
    def secret_string_key(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        <p>The AWS Secrets Manager <a href="https://docs.aws.amazon.com/secretsmanager/latest/apireference/API_CreateSecret.html#SecretsManager-CreateSecret-request-SecretString.html">SecretString</a> key associated with the access token. MediaTailor uses the key to look up SecretString key and value pair containing the access token.</p>
        """
        return pulumi.get(self, "secret_string_key")

    @secret_string_key.setter
    def secret_string_key(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "secret_string_key", value)


if not MYPY:
    class SourceLocationSegmentDeliveryConfigurationArgsDict(TypedDict):
        """
        <p>The segment delivery configuration settings.</p>
        """
        base_url: NotRequired[pulumi.Input[builtins.str]]
        """
        <p>The base URL of the host or path of the segment delivery server that you're using to serve segments. This is typically a content delivery network (CDN). The URL can be absolute or relative. To use an absolute URL include the protocol, such as <code>https://example.com/some/path</code>. To use a relative URL specify the relative path, such as <code>/some/path*</code>.</p>
        """
        name: NotRequired[pulumi.Input[builtins.str]]
        """
        <p>A unique identifier used to distinguish between multiple segment delivery configurations in a source location.</p>
        """
elif False:
    SourceLocationSegmentDeliveryConfigurationArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class SourceLocationSegmentDeliveryConfigurationArgs:
    def __init__(__self__, *,
                 base_url: Optional[pulumi.Input[builtins.str]] = None,
                 name: Optional[pulumi.Input[builtins.str]] = None):
        """
        <p>The segment delivery configuration settings.</p>
        :param pulumi.Input[builtins.str] base_url: <p>The base URL of the host or path of the segment delivery server that you're using to serve segments. This is typically a content delivery network (CDN). The URL can be absolute or relative. To use an absolute URL include the protocol, such as <code>https://example.com/some/path</code>. To use a relative URL specify the relative path, such as <code>/some/path*</code>.</p>
        :param pulumi.Input[builtins.str] name: <p>A unique identifier used to distinguish between multiple segment delivery configurations in a source location.</p>
        """
        if base_url is not None:
            pulumi.set(__self__, "base_url", base_url)
        if name is not None:
            pulumi.set(__self__, "name", name)

    @property
    @pulumi.getter(name="baseUrl")
    def base_url(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        <p>The base URL of the host or path of the segment delivery server that you're using to serve segments. This is typically a content delivery network (CDN). The URL can be absolute or relative. To use an absolute URL include the protocol, such as <code>https://example.com/some/path</code>. To use a relative URL specify the relative path, such as <code>/some/path*</code>.</p>
        """
        return pulumi.get(self, "base_url")

    @base_url.setter
    def base_url(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "base_url", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        <p>A unique identifier used to distinguish between multiple segment delivery configurations in a source location.</p>
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "name", value)


if not MYPY:
    class VodSourceHttpPackageConfigurationArgsDict(TypedDict):
        """
        <p>The HTTP package configuration properties for the requested VOD source.</p>
        """
        path: pulumi.Input[builtins.str]
        """
        <p>The relative path to the URL for this VOD source. This is combined with <code>SourceLocation::HttpConfiguration::BaseUrl</code> to form a valid URL.</p>
        """
        source_group: pulumi.Input[builtins.str]
        """
        <p>The name of the source group. This has to match one of the <code>Channel::Outputs::SourceGroup</code>.</p>
        """
        type: pulumi.Input['VodSourceType']
        """
        The streaming protocol for this package configuration. Supported values are `HLS` and `DASH` .
        """
elif False:
    VodSourceHttpPackageConfigurationArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class VodSourceHttpPackageConfigurationArgs:
    def __init__(__self__, *,
                 path: pulumi.Input[builtins.str],
                 source_group: pulumi.Input[builtins.str],
                 type: pulumi.Input['VodSourceType']):
        """
        <p>The HTTP package configuration properties for the requested VOD source.</p>
        :param pulumi.Input[builtins.str] path: <p>The relative path to the URL for this VOD source. This is combined with <code>SourceLocation::HttpConfiguration::BaseUrl</code> to form a valid URL.</p>
        :param pulumi.Input[builtins.str] source_group: <p>The name of the source group. This has to match one of the <code>Channel::Outputs::SourceGroup</code>.</p>
        :param pulumi.Input['VodSourceType'] type: The streaming protocol for this package configuration. Supported values are `HLS` and `DASH` .
        """
        pulumi.set(__self__, "path", path)
        pulumi.set(__self__, "source_group", source_group)
        pulumi.set(__self__, "type", type)

    @property
    @pulumi.getter
    def path(self) -> pulumi.Input[builtins.str]:
        """
        <p>The relative path to the URL for this VOD source. This is combined with <code>SourceLocation::HttpConfiguration::BaseUrl</code> to form a valid URL.</p>
        """
        return pulumi.get(self, "path")

    @path.setter
    def path(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "path", value)

    @property
    @pulumi.getter(name="sourceGroup")
    def source_group(self) -> pulumi.Input[builtins.str]:
        """
        <p>The name of the source group. This has to match one of the <code>Channel::Outputs::SourceGroup</code>.</p>
        """
        return pulumi.get(self, "source_group")

    @source_group.setter
    def source_group(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "source_group", value)

    @property
    @pulumi.getter
    def type(self) -> pulumi.Input['VodSourceType']:
        """
        The streaming protocol for this package configuration. Supported values are `HLS` and `DASH` .
        """
        return pulumi.get(self, "type")

    @type.setter
    def type(self, value: pulumi.Input['VodSourceType']):
        pulumi.set(self, "type", value)


