# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs
from ._enums import *

__all__ = [
    'ChannelIngestEndpoint',
    'ChannelInputSwitchConfiguration',
    'ChannelOutputHeaderConfiguration',
    'OriginEndpointDashManifestConfiguration',
    'OriginEndpointDashUtcTiming',
    'OriginEndpointEncryption',
    'OriginEndpointEncryptionContractConfiguration',
    'OriginEndpointEncryptionMethod',
    'OriginEndpointFilterConfiguration',
    'OriginEndpointForceEndpointErrorConfiguration',
    'OriginEndpointHlsManifestConfiguration',
    'OriginEndpointLowLatencyHlsManifestConfiguration',
    'OriginEndpointScte',
    'OriginEndpointScteDash',
    'OriginEndpointScteHls',
    'OriginEndpointSegment',
    'OriginEndpointSpekeKeyProvider',
    'OriginEndpointStartTag',
]

@pulumi.output_type
class ChannelIngestEndpoint(dict):
    """
    <p>The ingest domain URL where the source stream should be sent.</p>
    """
    def __init__(__self__, *,
                 id: Optional[builtins.str] = None,
                 url: Optional[builtins.str] = None):
        """
        <p>The ingest domain URL where the source stream should be sent.</p>
        :param builtins.str id: <p>The system-generated unique identifier for the IngestEndpoint.</p>
        :param builtins.str url: <p>The ingest domain URL where the source stream should be sent.</p>
        """
        if id is not None:
            pulumi.set(__self__, "id", id)
        if url is not None:
            pulumi.set(__self__, "url", url)

    @property
    @pulumi.getter
    def id(self) -> Optional[builtins.str]:
        """
        <p>The system-generated unique identifier for the IngestEndpoint.</p>
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter
    def url(self) -> Optional[builtins.str]:
        """
        <p>The ingest domain URL where the source stream should be sent.</p>
        """
        return pulumi.get(self, "url")


@pulumi.output_type
class ChannelInputSwitchConfiguration(dict):
    """
    <p>The configuration for input switching based on the media quality confidence score (MQCS) as provided from AWS Elemental MediaLive.</p>
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "mqcsInputSwitching":
            suggest = "mqcs_input_switching"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ChannelInputSwitchConfiguration. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ChannelInputSwitchConfiguration.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ChannelInputSwitchConfiguration.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 mqcs_input_switching: Optional[builtins.bool] = None):
        """
        <p>The configuration for input switching based on the media quality confidence score (MQCS) as provided from AWS Elemental MediaLive.</p>
        :param builtins.bool mqcs_input_switching: <p>When true, AWS Elemental MediaPackage performs input switching based on the MQCS. Default is true. This setting is valid only when <code>InputType</code> is <code>CMAF</code>.</p>
        """
        if mqcs_input_switching is not None:
            pulumi.set(__self__, "mqcs_input_switching", mqcs_input_switching)

    @property
    @pulumi.getter(name="mqcsInputSwitching")
    def mqcs_input_switching(self) -> Optional[builtins.bool]:
        """
        <p>When true, AWS Elemental MediaPackage performs input switching based on the MQCS. Default is true. This setting is valid only when <code>InputType</code> is <code>CMAF</code>.</p>
        """
        return pulumi.get(self, "mqcs_input_switching")


@pulumi.output_type
class ChannelOutputHeaderConfiguration(dict):
    """
    <p>The settings for what common media server data (CMSD) headers AWS Elemental MediaPackage includes in responses to the CDN.</p>
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "publishMqcs":
            suggest = "publish_mqcs"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ChannelOutputHeaderConfiguration. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ChannelOutputHeaderConfiguration.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ChannelOutputHeaderConfiguration.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 publish_mqcs: Optional[builtins.bool] = None):
        """
        <p>The settings for what common media server data (CMSD) headers AWS Elemental MediaPackage includes in responses to the CDN.</p>
        :param builtins.bool publish_mqcs: <p>When true, AWS Elemental MediaPackage includes the MQCS in responses to the CDN. This setting is valid only when <code>InputType</code> is <code>CMAF</code>.</p>
        """
        if publish_mqcs is not None:
            pulumi.set(__self__, "publish_mqcs", publish_mqcs)

    @property
    @pulumi.getter(name="publishMqcs")
    def publish_mqcs(self) -> Optional[builtins.bool]:
        """
        <p>When true, AWS Elemental MediaPackage includes the MQCS in responses to the CDN. This setting is valid only when <code>InputType</code> is <code>CMAF</code>.</p>
        """
        return pulumi.get(self, "publish_mqcs")


@pulumi.output_type
class OriginEndpointDashManifestConfiguration(dict):
    """
    <p>Retrieve the DASH manifest configuration.</p>
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "manifestName":
            suggest = "manifest_name"
        elif key == "drmSignaling":
            suggest = "drm_signaling"
        elif key == "filterConfiguration":
            suggest = "filter_configuration"
        elif key == "manifestWindowSeconds":
            suggest = "manifest_window_seconds"
        elif key == "minBufferTimeSeconds":
            suggest = "min_buffer_time_seconds"
        elif key == "minUpdatePeriodSeconds":
            suggest = "min_update_period_seconds"
        elif key == "periodTriggers":
            suggest = "period_triggers"
        elif key == "scteDash":
            suggest = "scte_dash"
        elif key == "segmentTemplateFormat":
            suggest = "segment_template_format"
        elif key == "suggestedPresentationDelaySeconds":
            suggest = "suggested_presentation_delay_seconds"
        elif key == "utcTiming":
            suggest = "utc_timing"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in OriginEndpointDashManifestConfiguration. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        OriginEndpointDashManifestConfiguration.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        OriginEndpointDashManifestConfiguration.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 manifest_name: builtins.str,
                 drm_signaling: Optional['OriginEndpointDashDrmSignaling'] = None,
                 filter_configuration: Optional['outputs.OriginEndpointFilterConfiguration'] = None,
                 manifest_window_seconds: Optional[builtins.int] = None,
                 min_buffer_time_seconds: Optional[builtins.int] = None,
                 min_update_period_seconds: Optional[builtins.int] = None,
                 period_triggers: Optional[Sequence['OriginEndpointDashPeriodTrigger']] = None,
                 scte_dash: Optional['outputs.OriginEndpointScteDash'] = None,
                 segment_template_format: Optional['OriginEndpointDashSegmentTemplateFormat'] = None,
                 suggested_presentation_delay_seconds: Optional[builtins.int] = None,
                 utc_timing: Optional['outputs.OriginEndpointDashUtcTiming'] = None):
        """
        <p>Retrieve the DASH manifest configuration.</p>
        :param builtins.str manifest_name: <p>A short string that's appended to the endpoint URL. The manifest name creates a unique path to this endpoint. If you don't enter a value, MediaPackage uses the default manifest name, index. </p>
        :param builtins.int manifest_window_seconds: <p>The total duration (in seconds) of the manifest's content.</p>
        :param builtins.int min_buffer_time_seconds: <p>Minimum amount of content (in seconds) that a player must keep available in the buffer.</p>
        :param builtins.int min_update_period_seconds: <p>Minimum amount of time (in seconds) that the player should wait before requesting updates to the manifest.</p>
        :param Sequence['OriginEndpointDashPeriodTrigger'] period_triggers: <p>A list of triggers that controls when AWS Elemental MediaPackage separates the MPEG-DASH manifest into multiple periods. Leave this value empty to indicate that the manifest is contained all in one period.
                        For more information about periods in the DASH manifest, see <a href="https://docs.aws.amazon.com/mediapackage/latest/userguide/multi-period.html">Multi-period DASH in AWS Elemental MediaPackage</a>.</p>
        :param builtins.int suggested_presentation_delay_seconds: <p>The amount of time (in seconds) that the player should be from the end of the manifest.</p>
        """
        pulumi.set(__self__, "manifest_name", manifest_name)
        if drm_signaling is not None:
            pulumi.set(__self__, "drm_signaling", drm_signaling)
        if filter_configuration is not None:
            pulumi.set(__self__, "filter_configuration", filter_configuration)
        if manifest_window_seconds is not None:
            pulumi.set(__self__, "manifest_window_seconds", manifest_window_seconds)
        if min_buffer_time_seconds is not None:
            pulumi.set(__self__, "min_buffer_time_seconds", min_buffer_time_seconds)
        if min_update_period_seconds is not None:
            pulumi.set(__self__, "min_update_period_seconds", min_update_period_seconds)
        if period_triggers is not None:
            pulumi.set(__self__, "period_triggers", period_triggers)
        if scte_dash is not None:
            pulumi.set(__self__, "scte_dash", scte_dash)
        if segment_template_format is not None:
            pulumi.set(__self__, "segment_template_format", segment_template_format)
        if suggested_presentation_delay_seconds is not None:
            pulumi.set(__self__, "suggested_presentation_delay_seconds", suggested_presentation_delay_seconds)
        if utc_timing is not None:
            pulumi.set(__self__, "utc_timing", utc_timing)

    @property
    @pulumi.getter(name="manifestName")
    def manifest_name(self) -> builtins.str:
        """
        <p>A short string that's appended to the endpoint URL. The manifest name creates a unique path to this endpoint. If you don't enter a value, MediaPackage uses the default manifest name, index. </p>
        """
        return pulumi.get(self, "manifest_name")

    @property
    @pulumi.getter(name="drmSignaling")
    def drm_signaling(self) -> Optional['OriginEndpointDashDrmSignaling']:
        return pulumi.get(self, "drm_signaling")

    @property
    @pulumi.getter(name="filterConfiguration")
    def filter_configuration(self) -> Optional['outputs.OriginEndpointFilterConfiguration']:
        return pulumi.get(self, "filter_configuration")

    @property
    @pulumi.getter(name="manifestWindowSeconds")
    def manifest_window_seconds(self) -> Optional[builtins.int]:
        """
        <p>The total duration (in seconds) of the manifest's content.</p>
        """
        return pulumi.get(self, "manifest_window_seconds")

    @property
    @pulumi.getter(name="minBufferTimeSeconds")
    def min_buffer_time_seconds(self) -> Optional[builtins.int]:
        """
        <p>Minimum amount of content (in seconds) that a player must keep available in the buffer.</p>
        """
        return pulumi.get(self, "min_buffer_time_seconds")

    @property
    @pulumi.getter(name="minUpdatePeriodSeconds")
    def min_update_period_seconds(self) -> Optional[builtins.int]:
        """
        <p>Minimum amount of time (in seconds) that the player should wait before requesting updates to the manifest.</p>
        """
        return pulumi.get(self, "min_update_period_seconds")

    @property
    @pulumi.getter(name="periodTriggers")
    def period_triggers(self) -> Optional[Sequence['OriginEndpointDashPeriodTrigger']]:
        """
        <p>A list of triggers that controls when AWS Elemental MediaPackage separates the MPEG-DASH manifest into multiple periods. Leave this value empty to indicate that the manifest is contained all in one period.
                 For more information about periods in the DASH manifest, see <a href="https://docs.aws.amazon.com/mediapackage/latest/userguide/multi-period.html">Multi-period DASH in AWS Elemental MediaPackage</a>.</p>
        """
        return pulumi.get(self, "period_triggers")

    @property
    @pulumi.getter(name="scteDash")
    def scte_dash(self) -> Optional['outputs.OriginEndpointScteDash']:
        return pulumi.get(self, "scte_dash")

    @property
    @pulumi.getter(name="segmentTemplateFormat")
    def segment_template_format(self) -> Optional['OriginEndpointDashSegmentTemplateFormat']:
        return pulumi.get(self, "segment_template_format")

    @property
    @pulumi.getter(name="suggestedPresentationDelaySeconds")
    def suggested_presentation_delay_seconds(self) -> Optional[builtins.int]:
        """
        <p>The amount of time (in seconds) that the player should be from the end of the manifest.</p>
        """
        return pulumi.get(self, "suggested_presentation_delay_seconds")

    @property
    @pulumi.getter(name="utcTiming")
    def utc_timing(self) -> Optional['outputs.OriginEndpointDashUtcTiming']:
        return pulumi.get(self, "utc_timing")


@pulumi.output_type
class OriginEndpointDashUtcTiming(dict):
    """
    <p>Determines the type of UTC timing included in the DASH Media Presentation Description (MPD).</p>
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "timingMode":
            suggest = "timing_mode"
        elif key == "timingSource":
            suggest = "timing_source"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in OriginEndpointDashUtcTiming. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        OriginEndpointDashUtcTiming.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        OriginEndpointDashUtcTiming.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 timing_mode: Optional['OriginEndpointDashUtcTimingMode'] = None,
                 timing_source: Optional[builtins.str] = None):
        """
        <p>Determines the type of UTC timing included in the DASH Media Presentation Description (MPD).</p>
        :param 'OriginEndpointDashUtcTimingMode' timing_mode: The UTC timing mode.
        :param builtins.str timing_source: <p>The the method that the player uses to synchronize to coordinated universal time (UTC) wall clock time.</p>
        """
        if timing_mode is not None:
            pulumi.set(__self__, "timing_mode", timing_mode)
        if timing_source is not None:
            pulumi.set(__self__, "timing_source", timing_source)

    @property
    @pulumi.getter(name="timingMode")
    def timing_mode(self) -> Optional['OriginEndpointDashUtcTimingMode']:
        """
        The UTC timing mode.
        """
        return pulumi.get(self, "timing_mode")

    @property
    @pulumi.getter(name="timingSource")
    def timing_source(self) -> Optional[builtins.str]:
        """
        <p>The the method that the player uses to synchronize to coordinated universal time (UTC) wall clock time.</p>
        """
        return pulumi.get(self, "timing_source")


@pulumi.output_type
class OriginEndpointEncryption(dict):
    """
    <p>The parameters for encrypting content.</p>
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "encryptionMethod":
            suggest = "encryption_method"
        elif key == "spekeKeyProvider":
            suggest = "speke_key_provider"
        elif key == "constantInitializationVector":
            suggest = "constant_initialization_vector"
        elif key == "keyRotationIntervalSeconds":
            suggest = "key_rotation_interval_seconds"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in OriginEndpointEncryption. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        OriginEndpointEncryption.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        OriginEndpointEncryption.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 encryption_method: 'outputs.OriginEndpointEncryptionMethod',
                 speke_key_provider: 'outputs.OriginEndpointSpekeKeyProvider',
                 constant_initialization_vector: Optional[builtins.str] = None,
                 key_rotation_interval_seconds: Optional[builtins.int] = None):
        """
        <p>The parameters for encrypting content.</p>
        :param 'OriginEndpointEncryptionMethod' encryption_method: The encryption method to use.
        :param 'OriginEndpointSpekeKeyProvider' speke_key_provider: The SPEKE key provider to use for encryption.
        :param builtins.str constant_initialization_vector: <p>A 128-bit, 16-byte hex value represented by a 32-character string, used in conjunction with the key for encrypting content. If you don't specify a value, then MediaPackage creates the constant initialization vector (IV).</p>
        :param builtins.int key_rotation_interval_seconds: <p>The frequency (in seconds) of key changes for live workflows, in which content is streamed real time. The service retrieves content keys before the live content begins streaming, and then retrieves them as needed over the lifetime of the workflow. By default, key rotation is set to 300 seconds (5 minutes), the minimum rotation interval, which is equivalent to setting it to 300. If you don't enter an interval, content keys aren't rotated.</p>
                        <p>The following example setting causes the service to rotate keys every thirty minutes: <code>1800</code>
                        </p>
        """
        pulumi.set(__self__, "encryption_method", encryption_method)
        pulumi.set(__self__, "speke_key_provider", speke_key_provider)
        if constant_initialization_vector is not None:
            pulumi.set(__self__, "constant_initialization_vector", constant_initialization_vector)
        if key_rotation_interval_seconds is not None:
            pulumi.set(__self__, "key_rotation_interval_seconds", key_rotation_interval_seconds)

    @property
    @pulumi.getter(name="encryptionMethod")
    def encryption_method(self) -> 'outputs.OriginEndpointEncryptionMethod':
        """
        The encryption method to use.
        """
        return pulumi.get(self, "encryption_method")

    @property
    @pulumi.getter(name="spekeKeyProvider")
    def speke_key_provider(self) -> 'outputs.OriginEndpointSpekeKeyProvider':
        """
        The SPEKE key provider to use for encryption.
        """
        return pulumi.get(self, "speke_key_provider")

    @property
    @pulumi.getter(name="constantInitializationVector")
    def constant_initialization_vector(self) -> Optional[builtins.str]:
        """
        <p>A 128-bit, 16-byte hex value represented by a 32-character string, used in conjunction with the key for encrypting content. If you don't specify a value, then MediaPackage creates the constant initialization vector (IV).</p>
        """
        return pulumi.get(self, "constant_initialization_vector")

    @property
    @pulumi.getter(name="keyRotationIntervalSeconds")
    def key_rotation_interval_seconds(self) -> Optional[builtins.int]:
        """
        <p>The frequency (in seconds) of key changes for live workflows, in which content is streamed real time. The service retrieves content keys before the live content begins streaming, and then retrieves them as needed over the lifetime of the workflow. By default, key rotation is set to 300 seconds (5 minutes), the minimum rotation interval, which is equivalent to setting it to 300. If you don't enter an interval, content keys aren't rotated.</p>
                 <p>The following example setting causes the service to rotate keys every thirty minutes: <code>1800</code>
                 </p>
        """
        return pulumi.get(self, "key_rotation_interval_seconds")


@pulumi.output_type
class OriginEndpointEncryptionContractConfiguration(dict):
    """
    <p>Configure one or more content encryption keys for your endpoints that use SPEKE Version 2.0. The encryption contract defines which content keys are used to encrypt the audio and video tracks in your stream. To configure the encryption contract, specify which audio and video encryption presets to use.</p>
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "presetSpeke20Audio":
            suggest = "preset_speke20_audio"
        elif key == "presetSpeke20Video":
            suggest = "preset_speke20_video"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in OriginEndpointEncryptionContractConfiguration. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        OriginEndpointEncryptionContractConfiguration.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        OriginEndpointEncryptionContractConfiguration.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 preset_speke20_audio: 'OriginEndpointPresetSpeke20Audio',
                 preset_speke20_video: 'OriginEndpointPresetSpeke20Video'):
        """
        <p>Configure one or more content encryption keys for your endpoints that use SPEKE Version 2.0. The encryption contract defines which content keys are used to encrypt the audio and video tracks in your stream. To configure the encryption contract, specify which audio and video encryption presets to use.</p>
        :param 'OriginEndpointPresetSpeke20Audio' preset_speke20_audio: A collection of audio encryption presets.
               
               Value description:
               
               - `PRESET-AUDIO-1` - Use one content key to encrypt all of the audio tracks in your stream.
               - `PRESET-AUDIO-2` - Use one content key to encrypt all of the stereo audio tracks and one content key to encrypt all of the multichannel audio tracks.
               - `PRESET-AUDIO-3` - Use one content key to encrypt all of the stereo audio tracks, one content key to encrypt all of the multichannel audio tracks with 3 to 6 channels, and one content key to encrypt all of the multichannel audio tracks with more than 6 channels.
               - `SHARED` - Use the same content key for all of the audio and video tracks in your stream.
               - `UNENCRYPTED` - Don't encrypt any of the audio tracks in your stream.
        :param 'OriginEndpointPresetSpeke20Video' preset_speke20_video: The SPEKE Version 2.0 preset video associated with the encryption contract configuration of the origin endpoint.
               
               A collection of video encryption presets.
               
               Value description:
               
               - `PRESET-VIDEO-1` - Use one content key to encrypt all of the video tracks in your stream.
               - `PRESET-VIDEO-2` - Use one content key to encrypt all of the SD video tracks and one content key for all HD and higher resolutions video tracks.
               - `PRESET-VIDEO-3` - Use one content key to encrypt all of the SD video tracks, one content key for HD video tracks and one content key for all UHD video tracks.
               - `PRESET-VIDEO-4` - Use one content key to encrypt all of the SD video tracks, one content key for HD video tracks, one content key for all UHD1 video tracks and one content key for all UHD2 video tracks.
               - `PRESET-VIDEO-5` - Use one content key to encrypt all of the SD video tracks, one content key for HD1 video tracks, one content key for HD2 video tracks, one content key for all UHD1 video tracks and one content key for all UHD2 video tracks.
               - `PRESET-VIDEO-6` - Use one content key to encrypt all of the SD video tracks, one content key for HD1 video tracks, one content key for HD2 video tracks and one content key for all UHD video tracks.
               - `PRESET-VIDEO-7` - Use one content key to encrypt all of the SD+HD1 video tracks, one content key for HD2 video tracks and one content key for all UHD video tracks.
               - `PRESET-VIDEO-8` - Use one content key to encrypt all of the SD+HD1 video tracks, one content key for HD2 video tracks, one content key for all UHD1 video tracks and one content key for all UHD2 video tracks.
               - `SHARED` - Use the same content key for all of the video and audio tracks in your stream.
               - `UNENCRYPTED` - Don't encrypt any of the video tracks in your stream.
        """
        pulumi.set(__self__, "preset_speke20_audio", preset_speke20_audio)
        pulumi.set(__self__, "preset_speke20_video", preset_speke20_video)

    @property
    @pulumi.getter(name="presetSpeke20Audio")
    def preset_speke20_audio(self) -> 'OriginEndpointPresetSpeke20Audio':
        """
        A collection of audio encryption presets.

        Value description:

        - `PRESET-AUDIO-1` - Use one content key to encrypt all of the audio tracks in your stream.
        - `PRESET-AUDIO-2` - Use one content key to encrypt all of the stereo audio tracks and one content key to encrypt all of the multichannel audio tracks.
        - `PRESET-AUDIO-3` - Use one content key to encrypt all of the stereo audio tracks, one content key to encrypt all of the multichannel audio tracks with 3 to 6 channels, and one content key to encrypt all of the multichannel audio tracks with more than 6 channels.
        - `SHARED` - Use the same content key for all of the audio and video tracks in your stream.
        - `UNENCRYPTED` - Don't encrypt any of the audio tracks in your stream.
        """
        return pulumi.get(self, "preset_speke20_audio")

    @property
    @pulumi.getter(name="presetSpeke20Video")
    def preset_speke20_video(self) -> 'OriginEndpointPresetSpeke20Video':
        """
        The SPEKE Version 2.0 preset video associated with the encryption contract configuration of the origin endpoint.

        A collection of video encryption presets.

        Value description:

        - `PRESET-VIDEO-1` - Use one content key to encrypt all of the video tracks in your stream.
        - `PRESET-VIDEO-2` - Use one content key to encrypt all of the SD video tracks and one content key for all HD and higher resolutions video tracks.
        - `PRESET-VIDEO-3` - Use one content key to encrypt all of the SD video tracks, one content key for HD video tracks and one content key for all UHD video tracks.
        - `PRESET-VIDEO-4` - Use one content key to encrypt all of the SD video tracks, one content key for HD video tracks, one content key for all UHD1 video tracks and one content key for all UHD2 video tracks.
        - `PRESET-VIDEO-5` - Use one content key to encrypt all of the SD video tracks, one content key for HD1 video tracks, one content key for HD2 video tracks, one content key for all UHD1 video tracks and one content key for all UHD2 video tracks.
        - `PRESET-VIDEO-6` - Use one content key to encrypt all of the SD video tracks, one content key for HD1 video tracks, one content key for HD2 video tracks and one content key for all UHD video tracks.
        - `PRESET-VIDEO-7` - Use one content key to encrypt all of the SD+HD1 video tracks, one content key for HD2 video tracks and one content key for all UHD video tracks.
        - `PRESET-VIDEO-8` - Use one content key to encrypt all of the SD+HD1 video tracks, one content key for HD2 video tracks, one content key for all UHD1 video tracks and one content key for all UHD2 video tracks.
        - `SHARED` - Use the same content key for all of the video and audio tracks in your stream.
        - `UNENCRYPTED` - Don't encrypt any of the video tracks in your stream.
        """
        return pulumi.get(self, "preset_speke20_video")


@pulumi.output_type
class OriginEndpointEncryptionMethod(dict):
    """
    <p>The encryption type.</p>
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "cmafEncryptionMethod":
            suggest = "cmaf_encryption_method"
        elif key == "tsEncryptionMethod":
            suggest = "ts_encryption_method"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in OriginEndpointEncryptionMethod. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        OriginEndpointEncryptionMethod.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        OriginEndpointEncryptionMethod.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 cmaf_encryption_method: Optional['OriginEndpointCmafEncryptionMethod'] = None,
                 ts_encryption_method: Optional['OriginEndpointTsEncryptionMethod'] = None):
        """
        <p>The encryption type.</p>
        :param 'OriginEndpointCmafEncryptionMethod' cmaf_encryption_method: The encryption method to use.
        :param 'OriginEndpointTsEncryptionMethod' ts_encryption_method: The encryption method to use.
        """
        if cmaf_encryption_method is not None:
            pulumi.set(__self__, "cmaf_encryption_method", cmaf_encryption_method)
        if ts_encryption_method is not None:
            pulumi.set(__self__, "ts_encryption_method", ts_encryption_method)

    @property
    @pulumi.getter(name="cmafEncryptionMethod")
    def cmaf_encryption_method(self) -> Optional['OriginEndpointCmafEncryptionMethod']:
        """
        The encryption method to use.
        """
        return pulumi.get(self, "cmaf_encryption_method")

    @property
    @pulumi.getter(name="tsEncryptionMethod")
    def ts_encryption_method(self) -> Optional['OriginEndpointTsEncryptionMethod']:
        """
        The encryption method to use.
        """
        return pulumi.get(self, "ts_encryption_method")


@pulumi.output_type
class OriginEndpointFilterConfiguration(dict):
    """
    <p>Filter configuration includes settings for manifest filtering, start and end times, and time delay that apply to all of your egress requests for this manifest. </p>
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "clipStartTime":
            suggest = "clip_start_time"
        elif key == "manifestFilter":
            suggest = "manifest_filter"
        elif key == "timeDelaySeconds":
            suggest = "time_delay_seconds"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in OriginEndpointFilterConfiguration. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        OriginEndpointFilterConfiguration.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        OriginEndpointFilterConfiguration.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 clip_start_time: Optional[builtins.str] = None,
                 end: Optional[builtins.str] = None,
                 manifest_filter: Optional[builtins.str] = None,
                 start: Optional[builtins.str] = None,
                 time_delay_seconds: Optional[builtins.int] = None):
        """
        <p>Filter configuration includes settings for manifest filtering, start and end times, and time delay that apply to all of your egress requests for this manifest. </p>
        :param builtins.str clip_start_time: <p>Optionally specify the clip start time for all of your manifest egress requests. When you include clip start time, note that you cannot use clip start time query parameters for this manifest's endpoint URL.</p>
        :param builtins.str end: <p>Optionally specify the end time for all of your manifest egress requests. When you include end time, note that you cannot use end time query parameters for this manifest's endpoint URL.</p>
        :param builtins.str manifest_filter: <p>Optionally specify one or more manifest filters for all of your manifest egress requests. When you include a manifest filter, note that you cannot use an identical manifest filter query parameter for this manifest's endpoint URL.</p>
        :param builtins.str start: <p>Optionally specify the start time for all of your manifest egress requests. When you include start time, note that you cannot use start time query parameters for this manifest's endpoint URL.</p>
        :param builtins.int time_delay_seconds: <p>Optionally specify the time delay for all of your manifest egress requests. Enter a value that is smaller than your endpoint's startover window. When you include time delay, note that you cannot use time delay query parameters for this manifest's endpoint URL.</p>
        """
        if clip_start_time is not None:
            pulumi.set(__self__, "clip_start_time", clip_start_time)
        if end is not None:
            pulumi.set(__self__, "end", end)
        if manifest_filter is not None:
            pulumi.set(__self__, "manifest_filter", manifest_filter)
        if start is not None:
            pulumi.set(__self__, "start", start)
        if time_delay_seconds is not None:
            pulumi.set(__self__, "time_delay_seconds", time_delay_seconds)

    @property
    @pulumi.getter(name="clipStartTime")
    def clip_start_time(self) -> Optional[builtins.str]:
        """
        <p>Optionally specify the clip start time for all of your manifest egress requests. When you include clip start time, note that you cannot use clip start time query parameters for this manifest's endpoint URL.</p>
        """
        return pulumi.get(self, "clip_start_time")

    @property
    @pulumi.getter
    def end(self) -> Optional[builtins.str]:
        """
        <p>Optionally specify the end time for all of your manifest egress requests. When you include end time, note that you cannot use end time query parameters for this manifest's endpoint URL.</p>
        """
        return pulumi.get(self, "end")

    @property
    @pulumi.getter(name="manifestFilter")
    def manifest_filter(self) -> Optional[builtins.str]:
        """
        <p>Optionally specify one or more manifest filters for all of your manifest egress requests. When you include a manifest filter, note that you cannot use an identical manifest filter query parameter for this manifest's endpoint URL.</p>
        """
        return pulumi.get(self, "manifest_filter")

    @property
    @pulumi.getter
    def start(self) -> Optional[builtins.str]:
        """
        <p>Optionally specify the start time for all of your manifest egress requests. When you include start time, note that you cannot use start time query parameters for this manifest's endpoint URL.</p>
        """
        return pulumi.get(self, "start")

    @property
    @pulumi.getter(name="timeDelaySeconds")
    def time_delay_seconds(self) -> Optional[builtins.int]:
        """
        <p>Optionally specify the time delay for all of your manifest egress requests. Enter a value that is smaller than your endpoint's startover window. When you include time delay, note that you cannot use time delay query parameters for this manifest's endpoint URL.</p>
        """
        return pulumi.get(self, "time_delay_seconds")


@pulumi.output_type
class OriginEndpointForceEndpointErrorConfiguration(dict):
    """
    <p>The failover settings for the endpoint.</p>
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "endpointErrorConditions":
            suggest = "endpoint_error_conditions"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in OriginEndpointForceEndpointErrorConfiguration. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        OriginEndpointForceEndpointErrorConfiguration.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        OriginEndpointForceEndpointErrorConfiguration.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 endpoint_error_conditions: Optional[Sequence['OriginEndpointEndpointErrorCondition']] = None):
        """
        <p>The failover settings for the endpoint.</p>
        :param Sequence['OriginEndpointEndpointErrorCondition'] endpoint_error_conditions: <p>The failover conditions for the endpoint. The options are:</p>
                        <ul>
                           <li>
                              <p>
                                 <code>STALE_MANIFEST</code> - The manifest stalled and there are no new segments or parts.</p>
                           </li>
                           <li>
                              <p>
                                 <code>INCOMPLETE_MANIFEST</code> - There is a gap in the manifest.</p>
                           </li>
                           <li>
                              <p>
                                 <code>MISSING_DRM_KEY</code> - Key rotation is enabled but we're unable to fetch the key for the current key period.</p>
                           </li>
                           <li>
                              <p>
                                 <code>SLATE_INPUT</code> - The segments which contain slate content are considered to be missing content.</p>
                           </li>
                        </ul>
        """
        if endpoint_error_conditions is not None:
            pulumi.set(__self__, "endpoint_error_conditions", endpoint_error_conditions)

    @property
    @pulumi.getter(name="endpointErrorConditions")
    def endpoint_error_conditions(self) -> Optional[Sequence['OriginEndpointEndpointErrorCondition']]:
        """
        <p>The failover conditions for the endpoint. The options are:</p>
                 <ul>
                    <li>
                       <p>
                          <code>STALE_MANIFEST</code> - The manifest stalled and there are no new segments or parts.</p>
                    </li>
                    <li>
                       <p>
                          <code>INCOMPLETE_MANIFEST</code> - There is a gap in the manifest.</p>
                    </li>
                    <li>
                       <p>
                          <code>MISSING_DRM_KEY</code> - Key rotation is enabled but we're unable to fetch the key for the current key period.</p>
                    </li>
                    <li>
                       <p>
                          <code>SLATE_INPUT</code> - The segments which contain slate content are considered to be missing content.</p>
                    </li>
                 </ul>
        """
        return pulumi.get(self, "endpoint_error_conditions")


@pulumi.output_type
class OriginEndpointHlsManifestConfiguration(dict):
    """
    <p>Retrieve the HTTP live streaming (HLS) manifest configuration.</p>
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "manifestName":
            suggest = "manifest_name"
        elif key == "childManifestName":
            suggest = "child_manifest_name"
        elif key == "filterConfiguration":
            suggest = "filter_configuration"
        elif key == "manifestWindowSeconds":
            suggest = "manifest_window_seconds"
        elif key == "programDateTimeIntervalSeconds":
            suggest = "program_date_time_interval_seconds"
        elif key == "scteHls":
            suggest = "scte_hls"
        elif key == "startTag":
            suggest = "start_tag"
        elif key == "urlEncodeChildManifest":
            suggest = "url_encode_child_manifest"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in OriginEndpointHlsManifestConfiguration. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        OriginEndpointHlsManifestConfiguration.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        OriginEndpointHlsManifestConfiguration.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 manifest_name: builtins.str,
                 child_manifest_name: Optional[builtins.str] = None,
                 filter_configuration: Optional['outputs.OriginEndpointFilterConfiguration'] = None,
                 manifest_window_seconds: Optional[builtins.int] = None,
                 program_date_time_interval_seconds: Optional[builtins.int] = None,
                 scte_hls: Optional['outputs.OriginEndpointScteHls'] = None,
                 start_tag: Optional['outputs.OriginEndpointStartTag'] = None,
                 url: Optional[builtins.str] = None,
                 url_encode_child_manifest: Optional[builtins.bool] = None):
        """
        <p>Retrieve the HTTP live streaming (HLS) manifest configuration.</p>
        :param builtins.str manifest_name: <p>A short short string that's appended to the endpoint URL. The manifest name creates a unique path to this endpoint. If you don't enter a value, MediaPackage uses the default manifest name, index. MediaPackage automatically inserts the format extension, such as .m3u8. You can't use the same manifest name if you use HLS manifest and low-latency HLS manifest. The manifestName on the HLSManifest object overrides the manifestName you provided on the originEndpoint object.</p>
        :param builtins.str child_manifest_name: <p>A short string that's appended to the endpoint URL. The child manifest name creates a unique path to this endpoint. If you don't enter a value, MediaPackage uses the default child manifest name, index_1. The manifestName on the HLSManifest object overrides the manifestName you provided on the originEndpoint object.</p>
        :param builtins.int manifest_window_seconds: <p>The total duration (in seconds) of the manifest's content.</p>
        :param builtins.int program_date_time_interval_seconds: <p>Inserts EXT-X-PROGRAM-DATE-TIME tags in the output manifest at the interval that you specify. If you don't enter an interval,
                        EXT-X-PROGRAM-DATE-TIME tags aren't included in the manifest.
                        The tags sync the stream to the wall clock so that viewers can seek to a specific time in the playback timeline on the player.</p>
                        <p>Irrespective of this parameter, if any ID3Timed metadata is in the HLS input, it is passed through to the HLS output.</p>
        :param 'OriginEndpointScteHls' scte_hls: THE SCTE-35 HLS configuration associated with the HLS manifest configuration.
        :param builtins.str url: <p>The egress domain URL for stream delivery from MediaPackage.</p>
        :param builtins.bool url_encode_child_manifest: <p>When enabled, MediaPackage URL-encodes the query string for API requests for HLS child manifests to comply with Amazon Web Services Signature Version 4 (SigV4) signature signing protocol.
                        For more information, see <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_sigv.html">Amazon Web Services Signature Version 4 for API requests</a> in <i>Identity and Access Management User Guide</i>.</p>
        """
        pulumi.set(__self__, "manifest_name", manifest_name)
        if child_manifest_name is not None:
            pulumi.set(__self__, "child_manifest_name", child_manifest_name)
        if filter_configuration is not None:
            pulumi.set(__self__, "filter_configuration", filter_configuration)
        if manifest_window_seconds is not None:
            pulumi.set(__self__, "manifest_window_seconds", manifest_window_seconds)
        if program_date_time_interval_seconds is not None:
            pulumi.set(__self__, "program_date_time_interval_seconds", program_date_time_interval_seconds)
        if scte_hls is not None:
            pulumi.set(__self__, "scte_hls", scte_hls)
        if start_tag is not None:
            pulumi.set(__self__, "start_tag", start_tag)
        if url is not None:
            pulumi.set(__self__, "url", url)
        if url_encode_child_manifest is not None:
            pulumi.set(__self__, "url_encode_child_manifest", url_encode_child_manifest)

    @property
    @pulumi.getter(name="manifestName")
    def manifest_name(self) -> builtins.str:
        """
        <p>A short short string that's appended to the endpoint URL. The manifest name creates a unique path to this endpoint. If you don't enter a value, MediaPackage uses the default manifest name, index. MediaPackage automatically inserts the format extension, such as .m3u8. You can't use the same manifest name if you use HLS manifest and low-latency HLS manifest. The manifestName on the HLSManifest object overrides the manifestName you provided on the originEndpoint object.</p>
        """
        return pulumi.get(self, "manifest_name")

    @property
    @pulumi.getter(name="childManifestName")
    def child_manifest_name(self) -> Optional[builtins.str]:
        """
        <p>A short string that's appended to the endpoint URL. The child manifest name creates a unique path to this endpoint. If you don't enter a value, MediaPackage uses the default child manifest name, index_1. The manifestName on the HLSManifest object overrides the manifestName you provided on the originEndpoint object.</p>
        """
        return pulumi.get(self, "child_manifest_name")

    @property
    @pulumi.getter(name="filterConfiguration")
    def filter_configuration(self) -> Optional['outputs.OriginEndpointFilterConfiguration']:
        return pulumi.get(self, "filter_configuration")

    @property
    @pulumi.getter(name="manifestWindowSeconds")
    def manifest_window_seconds(self) -> Optional[builtins.int]:
        """
        <p>The total duration (in seconds) of the manifest's content.</p>
        """
        return pulumi.get(self, "manifest_window_seconds")

    @property
    @pulumi.getter(name="programDateTimeIntervalSeconds")
    def program_date_time_interval_seconds(self) -> Optional[builtins.int]:
        """
        <p>Inserts EXT-X-PROGRAM-DATE-TIME tags in the output manifest at the interval that you specify. If you don't enter an interval,
                 EXT-X-PROGRAM-DATE-TIME tags aren't included in the manifest.
                 The tags sync the stream to the wall clock so that viewers can seek to a specific time in the playback timeline on the player.</p>
                 <p>Irrespective of this parameter, if any ID3Timed metadata is in the HLS input, it is passed through to the HLS output.</p>
        """
        return pulumi.get(self, "program_date_time_interval_seconds")

    @property
    @pulumi.getter(name="scteHls")
    def scte_hls(self) -> Optional['outputs.OriginEndpointScteHls']:
        """
        THE SCTE-35 HLS configuration associated with the HLS manifest configuration.
        """
        return pulumi.get(self, "scte_hls")

    @property
    @pulumi.getter(name="startTag")
    def start_tag(self) -> Optional['outputs.OriginEndpointStartTag']:
        return pulumi.get(self, "start_tag")

    @property
    @pulumi.getter
    def url(self) -> Optional[builtins.str]:
        """
        <p>The egress domain URL for stream delivery from MediaPackage.</p>
        """
        return pulumi.get(self, "url")

    @property
    @pulumi.getter(name="urlEncodeChildManifest")
    def url_encode_child_manifest(self) -> Optional[builtins.bool]:
        """
        <p>When enabled, MediaPackage URL-encodes the query string for API requests for HLS child manifests to comply with Amazon Web Services Signature Version 4 (SigV4) signature signing protocol.
                 For more information, see <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_sigv.html">Amazon Web Services Signature Version 4 for API requests</a> in <i>Identity and Access Management User Guide</i>.</p>
        """
        return pulumi.get(self, "url_encode_child_manifest")


@pulumi.output_type
class OriginEndpointLowLatencyHlsManifestConfiguration(dict):
    """
    <p>Retrieve the low-latency HTTP live streaming (HLS) manifest configuration.</p>
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "manifestName":
            suggest = "manifest_name"
        elif key == "childManifestName":
            suggest = "child_manifest_name"
        elif key == "filterConfiguration":
            suggest = "filter_configuration"
        elif key == "manifestWindowSeconds":
            suggest = "manifest_window_seconds"
        elif key == "programDateTimeIntervalSeconds":
            suggest = "program_date_time_interval_seconds"
        elif key == "scteHls":
            suggest = "scte_hls"
        elif key == "startTag":
            suggest = "start_tag"
        elif key == "urlEncodeChildManifest":
            suggest = "url_encode_child_manifest"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in OriginEndpointLowLatencyHlsManifestConfiguration. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        OriginEndpointLowLatencyHlsManifestConfiguration.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        OriginEndpointLowLatencyHlsManifestConfiguration.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 manifest_name: builtins.str,
                 child_manifest_name: Optional[builtins.str] = None,
                 filter_configuration: Optional['outputs.OriginEndpointFilterConfiguration'] = None,
                 manifest_window_seconds: Optional[builtins.int] = None,
                 program_date_time_interval_seconds: Optional[builtins.int] = None,
                 scte_hls: Optional['outputs.OriginEndpointScteHls'] = None,
                 start_tag: Optional['outputs.OriginEndpointStartTag'] = None,
                 url: Optional[builtins.str] = None,
                 url_encode_child_manifest: Optional[builtins.bool] = None):
        """
        <p>Retrieve the low-latency HTTP live streaming (HLS) manifest configuration.</p>
        :param builtins.str manifest_name: <p>A short short string that's appended to the endpoint URL. The manifest name creates a unique path to this endpoint. If you don't enter a value, MediaPackage uses the default manifest name, index. MediaPackage automatically inserts the format extension, such as .m3u8. You can't use the same manifest name if you use HLS manifest and low-latency HLS manifest. The manifestName on the HLSManifest object overrides the manifestName you provided on the originEndpoint object.</p>
        :param builtins.str child_manifest_name: <p>A short string that's appended to the endpoint URL. The child manifest name creates a unique path to this endpoint. If you don't enter a value, MediaPackage uses the default child manifest name, index_1. The manifestName on the HLSManifest object overrides the manifestName you provided on the originEndpoint object.</p>
        :param builtins.int manifest_window_seconds: <p>The total duration (in seconds) of the manifest's content.</p>
        :param builtins.int program_date_time_interval_seconds: <p>Inserts EXT-X-PROGRAM-DATE-TIME tags in the output manifest at the interval that you specify. If you don't enter an interval,
                        EXT-X-PROGRAM-DATE-TIME tags aren't included in the manifest.
                        The tags sync the stream to the wall clock so that viewers can seek to a specific time in the playback timeline on the player.</p>
                        <p>Irrespective of this parameter, if any ID3Timed metadata is in the HLS input, it is passed through to the HLS output.</p>
        :param 'OriginEndpointScteHls' scte_hls: The SCTE-35 HLS configuration associated with the low-latency HLS (LL-HLS) manifest configuration of the origin endpoint.
        :param builtins.str url: <p>The egress domain URL for stream delivery from MediaPackage.</p>
        :param builtins.bool url_encode_child_manifest: <p>When enabled, MediaPackage URL-encodes the query string for API requests for LL-HLS child manifests to comply with Amazon Web Services Signature Version 4 (SigV4) signature signing protocol.
                        For more information, see <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_sigv.html">Amazon Web Services Signature Version 4 for API requests</a> in <i>Identity and Access Management User Guide</i>.</p>
        """
        pulumi.set(__self__, "manifest_name", manifest_name)
        if child_manifest_name is not None:
            pulumi.set(__self__, "child_manifest_name", child_manifest_name)
        if filter_configuration is not None:
            pulumi.set(__self__, "filter_configuration", filter_configuration)
        if manifest_window_seconds is not None:
            pulumi.set(__self__, "manifest_window_seconds", manifest_window_seconds)
        if program_date_time_interval_seconds is not None:
            pulumi.set(__self__, "program_date_time_interval_seconds", program_date_time_interval_seconds)
        if scte_hls is not None:
            pulumi.set(__self__, "scte_hls", scte_hls)
        if start_tag is not None:
            pulumi.set(__self__, "start_tag", start_tag)
        if url is not None:
            pulumi.set(__self__, "url", url)
        if url_encode_child_manifest is not None:
            pulumi.set(__self__, "url_encode_child_manifest", url_encode_child_manifest)

    @property
    @pulumi.getter(name="manifestName")
    def manifest_name(self) -> builtins.str:
        """
        <p>A short short string that's appended to the endpoint URL. The manifest name creates a unique path to this endpoint. If you don't enter a value, MediaPackage uses the default manifest name, index. MediaPackage automatically inserts the format extension, such as .m3u8. You can't use the same manifest name if you use HLS manifest and low-latency HLS manifest. The manifestName on the HLSManifest object overrides the manifestName you provided on the originEndpoint object.</p>
        """
        return pulumi.get(self, "manifest_name")

    @property
    @pulumi.getter(name="childManifestName")
    def child_manifest_name(self) -> Optional[builtins.str]:
        """
        <p>A short string that's appended to the endpoint URL. The child manifest name creates a unique path to this endpoint. If you don't enter a value, MediaPackage uses the default child manifest name, index_1. The manifestName on the HLSManifest object overrides the manifestName you provided on the originEndpoint object.</p>
        """
        return pulumi.get(self, "child_manifest_name")

    @property
    @pulumi.getter(name="filterConfiguration")
    def filter_configuration(self) -> Optional['outputs.OriginEndpointFilterConfiguration']:
        return pulumi.get(self, "filter_configuration")

    @property
    @pulumi.getter(name="manifestWindowSeconds")
    def manifest_window_seconds(self) -> Optional[builtins.int]:
        """
        <p>The total duration (in seconds) of the manifest's content.</p>
        """
        return pulumi.get(self, "manifest_window_seconds")

    @property
    @pulumi.getter(name="programDateTimeIntervalSeconds")
    def program_date_time_interval_seconds(self) -> Optional[builtins.int]:
        """
        <p>Inserts EXT-X-PROGRAM-DATE-TIME tags in the output manifest at the interval that you specify. If you don't enter an interval,
                 EXT-X-PROGRAM-DATE-TIME tags aren't included in the manifest.
                 The tags sync the stream to the wall clock so that viewers can seek to a specific time in the playback timeline on the player.</p>
                 <p>Irrespective of this parameter, if any ID3Timed metadata is in the HLS input, it is passed through to the HLS output.</p>
        """
        return pulumi.get(self, "program_date_time_interval_seconds")

    @property
    @pulumi.getter(name="scteHls")
    def scte_hls(self) -> Optional['outputs.OriginEndpointScteHls']:
        """
        The SCTE-35 HLS configuration associated with the low-latency HLS (LL-HLS) manifest configuration of the origin endpoint.
        """
        return pulumi.get(self, "scte_hls")

    @property
    @pulumi.getter(name="startTag")
    def start_tag(self) -> Optional['outputs.OriginEndpointStartTag']:
        return pulumi.get(self, "start_tag")

    @property
    @pulumi.getter
    def url(self) -> Optional[builtins.str]:
        """
        <p>The egress domain URL for stream delivery from MediaPackage.</p>
        """
        return pulumi.get(self, "url")

    @property
    @pulumi.getter(name="urlEncodeChildManifest")
    def url_encode_child_manifest(self) -> Optional[builtins.bool]:
        """
        <p>When enabled, MediaPackage URL-encodes the query string for API requests for LL-HLS child manifests to comply with Amazon Web Services Signature Version 4 (SigV4) signature signing protocol.
                 For more information, see <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_sigv.html">Amazon Web Services Signature Version 4 for API requests</a> in <i>Identity and Access Management User Guide</i>.</p>
        """
        return pulumi.get(self, "url_encode_child_manifest")


@pulumi.output_type
class OriginEndpointScte(dict):
    """
    <p>The SCTE configuration.</p>
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "scteFilter":
            suggest = "scte_filter"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in OriginEndpointScte. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        OriginEndpointScte.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        OriginEndpointScte.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 scte_filter: Optional[Sequence['OriginEndpointScteFilter']] = None):
        """
        <p>The SCTE configuration.</p>
        :param Sequence['OriginEndpointScteFilter'] scte_filter: <p>The SCTE-35 message types that you want to be treated as ad markers in the output.</p>
        """
        if scte_filter is not None:
            pulumi.set(__self__, "scte_filter", scte_filter)

    @property
    @pulumi.getter(name="scteFilter")
    def scte_filter(self) -> Optional[Sequence['OriginEndpointScteFilter']]:
        """
        <p>The SCTE-35 message types that you want to be treated as ad markers in the output.</p>
        """
        return pulumi.get(self, "scte_filter")


@pulumi.output_type
class OriginEndpointScteDash(dict):
    """
    <p>The SCTE configuration.</p>
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "adMarkerDash":
            suggest = "ad_marker_dash"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in OriginEndpointScteDash. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        OriginEndpointScteDash.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        OriginEndpointScteDash.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 ad_marker_dash: Optional['OriginEndpointAdMarkerDash'] = None):
        """
        <p>The SCTE configuration.</p>
        :param 'OriginEndpointAdMarkerDash' ad_marker_dash: Choose how ad markers are included in the packaged content. If you include ad markers in the content stream in your upstream encoders, then you need to inform MediaPackage what to do with the ad markers in the output.
               
               Value description:
               
               - `Binary` - The SCTE-35 marker is expressed as a hex-string (Base64 string) rather than full XML.
               - `XML` - The SCTE marker is expressed fully in XML.
        """
        if ad_marker_dash is not None:
            pulumi.set(__self__, "ad_marker_dash", ad_marker_dash)

    @property
    @pulumi.getter(name="adMarkerDash")
    def ad_marker_dash(self) -> Optional['OriginEndpointAdMarkerDash']:
        """
        Choose how ad markers are included in the packaged content. If you include ad markers in the content stream in your upstream encoders, then you need to inform MediaPackage what to do with the ad markers in the output.

        Value description:

        - `Binary` - The SCTE-35 marker is expressed as a hex-string (Base64 string) rather than full XML.
        - `XML` - The SCTE marker is expressed fully in XML.
        """
        return pulumi.get(self, "ad_marker_dash")


@pulumi.output_type
class OriginEndpointScteHls(dict):
    """
    <p>The SCTE configuration.</p>
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "adMarkerHls":
            suggest = "ad_marker_hls"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in OriginEndpointScteHls. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        OriginEndpointScteHls.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        OriginEndpointScteHls.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 ad_marker_hls: Optional['OriginEndpointAdMarkerHls'] = None):
        """
        <p>The SCTE configuration.</p>
        :param 'OriginEndpointAdMarkerHls' ad_marker_hls: The SCTE-35 HLS ad-marker configuration.
        """
        if ad_marker_hls is not None:
            pulumi.set(__self__, "ad_marker_hls", ad_marker_hls)

    @property
    @pulumi.getter(name="adMarkerHls")
    def ad_marker_hls(self) -> Optional['OriginEndpointAdMarkerHls']:
        """
        The SCTE-35 HLS ad-marker configuration.
        """
        return pulumi.get(self, "ad_marker_hls")


@pulumi.output_type
class OriginEndpointSegment(dict):
    """
    <p>The segment configuration, including the segment name, duration, and other configuration values.</p>
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "includeIframeOnlyStreams":
            suggest = "include_iframe_only_streams"
        elif key == "segmentDurationSeconds":
            suggest = "segment_duration_seconds"
        elif key == "segmentName":
            suggest = "segment_name"
        elif key == "tsIncludeDvbSubtitles":
            suggest = "ts_include_dvb_subtitles"
        elif key == "tsUseAudioRenditionGroup":
            suggest = "ts_use_audio_rendition_group"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in OriginEndpointSegment. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        OriginEndpointSegment.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        OriginEndpointSegment.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 encryption: Optional['outputs.OriginEndpointEncryption'] = None,
                 include_iframe_only_streams: Optional[builtins.bool] = None,
                 scte: Optional['outputs.OriginEndpointScte'] = None,
                 segment_duration_seconds: Optional[builtins.int] = None,
                 segment_name: Optional[builtins.str] = None,
                 ts_include_dvb_subtitles: Optional[builtins.bool] = None,
                 ts_use_audio_rendition_group: Optional[builtins.bool] = None):
        """
        <p>The segment configuration, including the segment name, duration, and other configuration values.</p>
        :param 'OriginEndpointEncryption' encryption: Whether to use encryption for the segment.
        :param builtins.bool include_iframe_only_streams: <p>When selected, the stream set includes an additional I-frame only stream, along with the other tracks. If false, this extra stream is not included. MediaPackage generates an I-frame only stream from the first rendition in the manifest. The service inserts EXT-I-FRAMES-ONLY tags in the output manifest, and then generates and includes an I-frames only playlist in the stream. This playlist permits player functionality like fast forward and rewind.</p>
        :param 'OriginEndpointScte' scte: The SCTE-35 configuration associated with the segment.
        :param builtins.int segment_duration_seconds: <p>The duration (in seconds) of each segment. Enter a value equal to, or a multiple of, the input segment duration. If the value that you enter is different from the input segment duration, MediaPackage rounds segments to the nearest multiple of the input segment duration.</p>
        :param builtins.str segment_name: <p>The name that describes the segment. The name is the base name of the segment used in all content manifests inside of the endpoint. You can't use spaces in the name.</p>
        :param builtins.bool ts_include_dvb_subtitles: <p>By default, MediaPackage excludes all digital video broadcasting (DVB) subtitles from the output. When selected, MediaPackage passes through DVB subtitles into the output.</p>
        :param builtins.bool ts_use_audio_rendition_group: <p>When selected, MediaPackage bundles all audio tracks in a rendition group. All other tracks in the stream can be used with any audio rendition from the group.</p>
        """
        if encryption is not None:
            pulumi.set(__self__, "encryption", encryption)
        if include_iframe_only_streams is not None:
            pulumi.set(__self__, "include_iframe_only_streams", include_iframe_only_streams)
        if scte is not None:
            pulumi.set(__self__, "scte", scte)
        if segment_duration_seconds is not None:
            pulumi.set(__self__, "segment_duration_seconds", segment_duration_seconds)
        if segment_name is not None:
            pulumi.set(__self__, "segment_name", segment_name)
        if ts_include_dvb_subtitles is not None:
            pulumi.set(__self__, "ts_include_dvb_subtitles", ts_include_dvb_subtitles)
        if ts_use_audio_rendition_group is not None:
            pulumi.set(__self__, "ts_use_audio_rendition_group", ts_use_audio_rendition_group)

    @property
    @pulumi.getter
    def encryption(self) -> Optional['outputs.OriginEndpointEncryption']:
        """
        Whether to use encryption for the segment.
        """
        return pulumi.get(self, "encryption")

    @property
    @pulumi.getter(name="includeIframeOnlyStreams")
    def include_iframe_only_streams(self) -> Optional[builtins.bool]:
        """
        <p>When selected, the stream set includes an additional I-frame only stream, along with the other tracks. If false, this extra stream is not included. MediaPackage generates an I-frame only stream from the first rendition in the manifest. The service inserts EXT-I-FRAMES-ONLY tags in the output manifest, and then generates and includes an I-frames only playlist in the stream. This playlist permits player functionality like fast forward and rewind.</p>
        """
        return pulumi.get(self, "include_iframe_only_streams")

    @property
    @pulumi.getter
    def scte(self) -> Optional['outputs.OriginEndpointScte']:
        """
        The SCTE-35 configuration associated with the segment.
        """
        return pulumi.get(self, "scte")

    @property
    @pulumi.getter(name="segmentDurationSeconds")
    def segment_duration_seconds(self) -> Optional[builtins.int]:
        """
        <p>The duration (in seconds) of each segment. Enter a value equal to, or a multiple of, the input segment duration. If the value that you enter is different from the input segment duration, MediaPackage rounds segments to the nearest multiple of the input segment duration.</p>
        """
        return pulumi.get(self, "segment_duration_seconds")

    @property
    @pulumi.getter(name="segmentName")
    def segment_name(self) -> Optional[builtins.str]:
        """
        <p>The name that describes the segment. The name is the base name of the segment used in all content manifests inside of the endpoint. You can't use spaces in the name.</p>
        """
        return pulumi.get(self, "segment_name")

    @property
    @pulumi.getter(name="tsIncludeDvbSubtitles")
    def ts_include_dvb_subtitles(self) -> Optional[builtins.bool]:
        """
        <p>By default, MediaPackage excludes all digital video broadcasting (DVB) subtitles from the output. When selected, MediaPackage passes through DVB subtitles into the output.</p>
        """
        return pulumi.get(self, "ts_include_dvb_subtitles")

    @property
    @pulumi.getter(name="tsUseAudioRenditionGroup")
    def ts_use_audio_rendition_group(self) -> Optional[builtins.bool]:
        """
        <p>When selected, MediaPackage bundles all audio tracks in a rendition group. All other tracks in the stream can be used with any audio rendition from the group.</p>
        """
        return pulumi.get(self, "ts_use_audio_rendition_group")


@pulumi.output_type
class OriginEndpointSpekeKeyProvider(dict):
    """
    <p>The parameters for the SPEKE key provider.</p>
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "drmSystems":
            suggest = "drm_systems"
        elif key == "encryptionContractConfiguration":
            suggest = "encryption_contract_configuration"
        elif key == "resourceId":
            suggest = "resource_id"
        elif key == "roleArn":
            suggest = "role_arn"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in OriginEndpointSpekeKeyProvider. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        OriginEndpointSpekeKeyProvider.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        OriginEndpointSpekeKeyProvider.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 drm_systems: Sequence['OriginEndpointDrmSystem'],
                 encryption_contract_configuration: 'outputs.OriginEndpointEncryptionContractConfiguration',
                 resource_id: builtins.str,
                 role_arn: builtins.str,
                 url: builtins.str):
        """
        <p>The parameters for the SPEKE key provider.</p>
        :param Sequence['OriginEndpointDrmSystem'] drm_systems: <p>The DRM solution provider you're using to protect your content during distribution.</p>
        :param 'OriginEndpointEncryptionContractConfiguration' encryption_contract_configuration: The encryption contract configuration associated with the SPEKE key provider.
        :param builtins.str resource_id: <p>The unique identifier for the content. The service sends this to the key server to identify the current endpoint. How unique you make this depends on how fine-grained you want access controls to be. The service does not permit you to use the same ID for two simultaneous encryption processes. The resource ID is also known as the content ID.</p>
                        <p>The following example shows a resource ID: <code>MovieNight20171126093045</code>
                        </p>
        :param builtins.str role_arn: <p>The ARN for the IAM role granted by the key provider that provides access to the key provider API. This role must have a trust policy that allows MediaPackage to assume the role, and it must have a sufficient permissions policy to allow access to the specific key retrieval URL. Get this from your DRM solution provider.</p>
                        <p>Valid format: <code>arn:aws:iam::{accountID}:role/{name}</code>. The following example shows a role ARN: <code>arn:aws:iam::444455556666:role/SpekeAccess</code>
                        </p>
        :param builtins.str url: <p>The URL of the API Gateway proxy that you set up to talk to your key server. The API Gateway proxy must reside in the same AWS Region as MediaPackage and must start with https://.</p>
                        <p>The following example shows a URL: <code>https://1wm2dx1f33.execute-api.us-west-2.amazonaws.com/SpekeSample/copyProtection</code>
                        </p>
        """
        pulumi.set(__self__, "drm_systems", drm_systems)
        pulumi.set(__self__, "encryption_contract_configuration", encryption_contract_configuration)
        pulumi.set(__self__, "resource_id", resource_id)
        pulumi.set(__self__, "role_arn", role_arn)
        pulumi.set(__self__, "url", url)

    @property
    @pulumi.getter(name="drmSystems")
    def drm_systems(self) -> Sequence['OriginEndpointDrmSystem']:
        """
        <p>The DRM solution provider you're using to protect your content during distribution.</p>
        """
        return pulumi.get(self, "drm_systems")

    @property
    @pulumi.getter(name="encryptionContractConfiguration")
    def encryption_contract_configuration(self) -> 'outputs.OriginEndpointEncryptionContractConfiguration':
        """
        The encryption contract configuration associated with the SPEKE key provider.
        """
        return pulumi.get(self, "encryption_contract_configuration")

    @property
    @pulumi.getter(name="resourceId")
    def resource_id(self) -> builtins.str:
        """
        <p>The unique identifier for the content. The service sends this to the key server to identify the current endpoint. How unique you make this depends on how fine-grained you want access controls to be. The service does not permit you to use the same ID for two simultaneous encryption processes. The resource ID is also known as the content ID.</p>
                 <p>The following example shows a resource ID: <code>MovieNight20171126093045</code>
                 </p>
        """
        return pulumi.get(self, "resource_id")

    @property
    @pulumi.getter(name="roleArn")
    def role_arn(self) -> builtins.str:
        """
        <p>The ARN for the IAM role granted by the key provider that provides access to the key provider API. This role must have a trust policy that allows MediaPackage to assume the role, and it must have a sufficient permissions policy to allow access to the specific key retrieval URL. Get this from your DRM solution provider.</p>
                 <p>Valid format: <code>arn:aws:iam::{accountID}:role/{name}</code>. The following example shows a role ARN: <code>arn:aws:iam::444455556666:role/SpekeAccess</code>
                 </p>
        """
        return pulumi.get(self, "role_arn")

    @property
    @pulumi.getter
    def url(self) -> builtins.str:
        """
        <p>The URL of the API Gateway proxy that you set up to talk to your key server. The API Gateway proxy must reside in the same AWS Region as MediaPackage and must start with https://.</p>
                 <p>The following example shows a URL: <code>https://1wm2dx1f33.execute-api.us-west-2.amazonaws.com/SpekeSample/copyProtection</code>
                 </p>
        """
        return pulumi.get(self, "url")


@pulumi.output_type
class OriginEndpointStartTag(dict):
    """
    <p>To insert an EXT-X-START tag in your HLS playlist, specify a StartTag configuration object with a valid TimeOffset. When you do, you can also optionally specify whether to include a PRECISE value in the EXT-X-START tag.</p>
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "timeOffset":
            suggest = "time_offset"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in OriginEndpointStartTag. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        OriginEndpointStartTag.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        OriginEndpointStartTag.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 time_offset: builtins.float,
                 precise: Optional[builtins.bool] = None):
        """
        <p>To insert an EXT-X-START tag in your HLS playlist, specify a StartTag configuration object with a valid TimeOffset. When you do, you can also optionally specify whether to include a PRECISE value in the EXT-X-START tag.</p>
        :param builtins.float time_offset: <p>Specify the value for TIME-OFFSET within your EXT-X-START tag. Enter a signed floating point value which, if positive, must be less than the configured manifest duration minus three times the configured segment target duration. If negative, the absolute value must be larger than three times the configured segment target duration, and the absolute value must be smaller than the configured manifest duration.</p>
        :param builtins.bool precise: <p>Specify the value for PRECISE within your EXT-X-START tag. Leave blank, or choose false, to use the default value NO. Choose yes to use the value YES.</p>
        """
        pulumi.set(__self__, "time_offset", time_offset)
        if precise is not None:
            pulumi.set(__self__, "precise", precise)

    @property
    @pulumi.getter(name="timeOffset")
    def time_offset(self) -> builtins.float:
        """
        <p>Specify the value for TIME-OFFSET within your EXT-X-START tag. Enter a signed floating point value which, if positive, must be less than the configured manifest duration minus three times the configured segment target duration. If negative, the absolute value must be larger than three times the configured segment target duration, and the absolute value must be smaller than the configured manifest duration.</p>
        """
        return pulumi.get(self, "time_offset")

    @property
    @pulumi.getter
    def precise(self) -> Optional[builtins.bool]:
        """
        <p>Specify the value for PRECISE within your EXT-X-START tag. Leave blank, or choose false, to use the default value NO. Choose yes to use the value YES.</p>
        """
        return pulumi.get(self, "precise")


