# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs
from .. import outputs as _root_outputs

__all__ = [
    'GetChannelResult',
    'AwaitableGetChannelResult',
    'get_channel',
    'get_channel_output',
]

@pulumi.output_type
class GetChannelResult:
    def __init__(__self__, arn=None, created_at=None, description=None, ingest_endpoint_urls=None, ingest_endpoints=None, input_switch_configuration=None, modified_at=None, output_header_configuration=None, tags=None):
        if arn and not isinstance(arn, str):
            raise TypeError("Expected argument 'arn' to be a str")
        pulumi.set(__self__, "arn", arn)
        if created_at and not isinstance(created_at, str):
            raise TypeError("Expected argument 'created_at' to be a str")
        pulumi.set(__self__, "created_at", created_at)
        if description and not isinstance(description, str):
            raise TypeError("Expected argument 'description' to be a str")
        pulumi.set(__self__, "description", description)
        if ingest_endpoint_urls and not isinstance(ingest_endpoint_urls, list):
            raise TypeError("Expected argument 'ingest_endpoint_urls' to be a list")
        pulumi.set(__self__, "ingest_endpoint_urls", ingest_endpoint_urls)
        if ingest_endpoints and not isinstance(ingest_endpoints, list):
            raise TypeError("Expected argument 'ingest_endpoints' to be a list")
        pulumi.set(__self__, "ingest_endpoints", ingest_endpoints)
        if input_switch_configuration and not isinstance(input_switch_configuration, dict):
            raise TypeError("Expected argument 'input_switch_configuration' to be a dict")
        pulumi.set(__self__, "input_switch_configuration", input_switch_configuration)
        if modified_at and not isinstance(modified_at, str):
            raise TypeError("Expected argument 'modified_at' to be a str")
        pulumi.set(__self__, "modified_at", modified_at)
        if output_header_configuration and not isinstance(output_header_configuration, dict):
            raise TypeError("Expected argument 'output_header_configuration' to be a dict")
        pulumi.set(__self__, "output_header_configuration", output_header_configuration)
        if tags and not isinstance(tags, list):
            raise TypeError("Expected argument 'tags' to be a list")
        pulumi.set(__self__, "tags", tags)

    @property
    @pulumi.getter
    def arn(self) -> Optional[builtins.str]:
        """
        <p>The Amazon Resource Name (ARN) associated with the resource.</p>
        """
        return pulumi.get(self, "arn")

    @property
    @pulumi.getter(name="createdAt")
    def created_at(self) -> Optional[builtins.str]:
        """
        <p>The date and time the channel was created.</p>
        """
        return pulumi.get(self, "created_at")

    @property
    @pulumi.getter
    def description(self) -> Optional[builtins.str]:
        """
        <p>Enter any descriptive text that helps you to identify the channel.</p>
        """
        return pulumi.get(self, "description")

    @property
    @pulumi.getter(name="ingestEndpointUrls")
    def ingest_endpoint_urls(self) -> Optional[Sequence[builtins.str]]:
        return pulumi.get(self, "ingest_endpoint_urls")

    @property
    @pulumi.getter(name="ingestEndpoints")
    def ingest_endpoints(self) -> Optional[Sequence['outputs.ChannelIngestEndpoint']]:
        """
        <p>The list of ingest endpoints.</p>
        """
        return pulumi.get(self, "ingest_endpoints")

    @property
    @pulumi.getter(name="inputSwitchConfiguration")
    def input_switch_configuration(self) -> Optional['outputs.ChannelInputSwitchConfiguration']:
        """
        The configuration for input switching based on the media quality confidence score (MQCS) as provided from AWS Elemental MediaLive.
        """
        return pulumi.get(self, "input_switch_configuration")

    @property
    @pulumi.getter(name="modifiedAt")
    def modified_at(self) -> Optional[builtins.str]:
        """
        <p>The date and time the channel was modified.</p>
        """
        return pulumi.get(self, "modified_at")

    @property
    @pulumi.getter(name="outputHeaderConfiguration")
    def output_header_configuration(self) -> Optional['outputs.ChannelOutputHeaderConfiguration']:
        """
        The settings for what common media server data (CMSD) headers AWS Elemental MediaPackage includes in responses to the CDN.
        """
        return pulumi.get(self, "output_header_configuration")

    @property
    @pulumi.getter
    def tags(self) -> Optional[Sequence['_root_outputs.Tag']]:
        """
        The tags associated with the channel.
        """
        return pulumi.get(self, "tags")


class AwaitableGetChannelResult(GetChannelResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetChannelResult(
            arn=self.arn,
            created_at=self.created_at,
            description=self.description,
            ingest_endpoint_urls=self.ingest_endpoint_urls,
            ingest_endpoints=self.ingest_endpoints,
            input_switch_configuration=self.input_switch_configuration,
            modified_at=self.modified_at,
            output_header_configuration=self.output_header_configuration,
            tags=self.tags)


def get_channel(arn: Optional[builtins.str] = None,
                opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetChannelResult:
    """
    <p>Represents an entry point into AWS Elemental MediaPackage for an ABR video content stream sent from an upstream encoder such as AWS Elemental MediaLive. The channel continuously analyzes the content that it receives and prepares it to be distributed to consumers via one or more origin endpoints.</p>


    :param builtins.str arn: <p>The Amazon Resource Name (ARN) associated with the resource.</p>
    """
    __args__ = dict()
    __args__['arn'] = arn
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('aws-native:mediapackagev2:getChannel', __args__, opts=opts, typ=GetChannelResult).value

    return AwaitableGetChannelResult(
        arn=pulumi.get(__ret__, 'arn'),
        created_at=pulumi.get(__ret__, 'created_at'),
        description=pulumi.get(__ret__, 'description'),
        ingest_endpoint_urls=pulumi.get(__ret__, 'ingest_endpoint_urls'),
        ingest_endpoints=pulumi.get(__ret__, 'ingest_endpoints'),
        input_switch_configuration=pulumi.get(__ret__, 'input_switch_configuration'),
        modified_at=pulumi.get(__ret__, 'modified_at'),
        output_header_configuration=pulumi.get(__ret__, 'output_header_configuration'),
        tags=pulumi.get(__ret__, 'tags'))
def get_channel_output(arn: Optional[pulumi.Input[builtins.str]] = None,
                       opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetChannelResult]:
    """
    <p>Represents an entry point into AWS Elemental MediaPackage for an ABR video content stream sent from an upstream encoder such as AWS Elemental MediaLive. The channel continuously analyzes the content that it receives and prepares it to be distributed to consumers via one or more origin endpoints.</p>


    :param builtins.str arn: <p>The Amazon Resource Name (ARN) associated with the resource.</p>
    """
    __args__ = dict()
    __args__['arn'] = arn
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('aws-native:mediapackagev2:getChannel', __args__, opts=opts, typ=GetChannelResult)
    return __ret__.apply(lambda __response__: GetChannelResult(
        arn=pulumi.get(__response__, 'arn'),
        created_at=pulumi.get(__response__, 'created_at'),
        description=pulumi.get(__response__, 'description'),
        ingest_endpoint_urls=pulumi.get(__response__, 'ingest_endpoint_urls'),
        ingest_endpoints=pulumi.get(__response__, 'ingest_endpoints'),
        input_switch_configuration=pulumi.get(__response__, 'input_switch_configuration'),
        modified_at=pulumi.get(__response__, 'modified_at'),
        output_header_configuration=pulumi.get(__response__, 'output_header_configuration'),
        tags=pulumi.get(__response__, 'tags')))
