# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs
from ._enums import *

__all__ = ['SignalMapArgs', 'SignalMap']

@pulumi.input_type
class SignalMapArgs:
    def __init__(__self__, *,
                 discovery_entry_point_arn: pulumi.Input[builtins.str],
                 cloud_watch_alarm_template_group_identifiers: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
                 description: Optional[pulumi.Input[builtins.str]] = None,
                 event_bridge_rule_template_group_identifiers: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
                 force_rediscovery: Optional[pulumi.Input[builtins.bool]] = None,
                 name: Optional[pulumi.Input[builtins.str]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None):
        """
        The set of arguments for constructing a SignalMap resource.
        :param pulumi.Input[builtins.str] discovery_entry_point_arn: A top-level supported AWS resource ARN to discovery a signal map from.
        :param pulumi.Input[Sequence[pulumi.Input[builtins.str]]] cloud_watch_alarm_template_group_identifiers: A cloudwatch alarm template group's identifier. Can be either be its id or current name.
        :param pulumi.Input[builtins.str] description: A resource's optional description.
        :param pulumi.Input[Sequence[pulumi.Input[builtins.str]]] event_bridge_rule_template_group_identifiers: An eventbridge rule template group's identifier. Can be either be its id or current name.
        :param pulumi.Input[builtins.bool] force_rediscovery: If true, will force a rediscovery of a signal map if an unchanged discoveryEntryPointArn is provided.
        :param pulumi.Input[builtins.str] name: A resource's name. Names must be unique within the scope of a resource type in a specific region.
        """
        pulumi.set(__self__, "discovery_entry_point_arn", discovery_entry_point_arn)
        if cloud_watch_alarm_template_group_identifiers is not None:
            pulumi.set(__self__, "cloud_watch_alarm_template_group_identifiers", cloud_watch_alarm_template_group_identifiers)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if event_bridge_rule_template_group_identifiers is not None:
            pulumi.set(__self__, "event_bridge_rule_template_group_identifiers", event_bridge_rule_template_group_identifiers)
        if force_rediscovery is not None:
            pulumi.set(__self__, "force_rediscovery", force_rediscovery)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)

    @property
    @pulumi.getter(name="discoveryEntryPointArn")
    def discovery_entry_point_arn(self) -> pulumi.Input[builtins.str]:
        """
        A top-level supported AWS resource ARN to discovery a signal map from.
        """
        return pulumi.get(self, "discovery_entry_point_arn")

    @discovery_entry_point_arn.setter
    def discovery_entry_point_arn(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "discovery_entry_point_arn", value)

    @property
    @pulumi.getter(name="cloudWatchAlarmTemplateGroupIdentifiers")
    def cloud_watch_alarm_template_group_identifiers(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]:
        """
        A cloudwatch alarm template group's identifier. Can be either be its id or current name.
        """
        return pulumi.get(self, "cloud_watch_alarm_template_group_identifiers")

    @cloud_watch_alarm_template_group_identifiers.setter
    def cloud_watch_alarm_template_group_identifiers(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "cloud_watch_alarm_template_group_identifiers", value)

    @property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        A resource's optional description.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "description", value)

    @property
    @pulumi.getter(name="eventBridgeRuleTemplateGroupIdentifiers")
    def event_bridge_rule_template_group_identifiers(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]:
        """
        An eventbridge rule template group's identifier. Can be either be its id or current name.
        """
        return pulumi.get(self, "event_bridge_rule_template_group_identifiers")

    @event_bridge_rule_template_group_identifiers.setter
    def event_bridge_rule_template_group_identifiers(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "event_bridge_rule_template_group_identifiers", value)

    @property
    @pulumi.getter(name="forceRediscovery")
    def force_rediscovery(self) -> Optional[pulumi.Input[builtins.bool]]:
        """
        If true, will force a rediscovery of a signal map if an unchanged discoveryEntryPointArn is provided.
        """
        return pulumi.get(self, "force_rediscovery")

    @force_rediscovery.setter
    def force_rediscovery(self, value: Optional[pulumi.Input[builtins.bool]]):
        pulumi.set(self, "force_rediscovery", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        A resource's name. Names must be unique within the scope of a resource type in a specific region.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter
    def tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]:
        return pulumi.get(self, "tags")

    @tags.setter
    def tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "tags", value)


@pulumi.type_token("aws-native:medialive:SignalMap")
class SignalMap(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 cloud_watch_alarm_template_group_identifiers: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
                 description: Optional[pulumi.Input[builtins.str]] = None,
                 discovery_entry_point_arn: Optional[pulumi.Input[builtins.str]] = None,
                 event_bridge_rule_template_group_identifiers: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
                 force_rediscovery: Optional[pulumi.Input[builtins.bool]] = None,
                 name: Optional[pulumi.Input[builtins.str]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
                 __props__=None):
        """
        Definition of AWS::MediaLive::SignalMap Resource Type

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[Sequence[pulumi.Input[builtins.str]]] cloud_watch_alarm_template_group_identifiers: A cloudwatch alarm template group's identifier. Can be either be its id or current name.
        :param pulumi.Input[builtins.str] description: A resource's optional description.
        :param pulumi.Input[builtins.str] discovery_entry_point_arn: A top-level supported AWS resource ARN to discovery a signal map from.
        :param pulumi.Input[Sequence[pulumi.Input[builtins.str]]] event_bridge_rule_template_group_identifiers: An eventbridge rule template group's identifier. Can be either be its id or current name.
        :param pulumi.Input[builtins.bool] force_rediscovery: If true, will force a rediscovery of a signal map if an unchanged discoveryEntryPointArn is provided.
        :param pulumi.Input[builtins.str] name: A resource's name. Names must be unique within the scope of a resource type in a specific region.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: SignalMapArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Definition of AWS::MediaLive::SignalMap Resource Type

        :param str resource_name: The name of the resource.
        :param SignalMapArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(SignalMapArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 cloud_watch_alarm_template_group_identifiers: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
                 description: Optional[pulumi.Input[builtins.str]] = None,
                 discovery_entry_point_arn: Optional[pulumi.Input[builtins.str]] = None,
                 event_bridge_rule_template_group_identifiers: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
                 force_rediscovery: Optional[pulumi.Input[builtins.bool]] = None,
                 name: Optional[pulumi.Input[builtins.str]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = SignalMapArgs.__new__(SignalMapArgs)

            __props__.__dict__["cloud_watch_alarm_template_group_identifiers"] = cloud_watch_alarm_template_group_identifiers
            __props__.__dict__["description"] = description
            if discovery_entry_point_arn is None and not opts.urn:
                raise TypeError("Missing required property 'discovery_entry_point_arn'")
            __props__.__dict__["discovery_entry_point_arn"] = discovery_entry_point_arn
            __props__.__dict__["event_bridge_rule_template_group_identifiers"] = event_bridge_rule_template_group_identifiers
            __props__.__dict__["force_rediscovery"] = force_rediscovery
            __props__.__dict__["name"] = name
            __props__.__dict__["tags"] = tags
            __props__.__dict__["arn"] = None
            __props__.__dict__["aws_id"] = None
            __props__.__dict__["cloud_watch_alarm_template_group_ids"] = None
            __props__.__dict__["created_at"] = None
            __props__.__dict__["error_message"] = None
            __props__.__dict__["event_bridge_rule_template_group_ids"] = None
            __props__.__dict__["failed_media_resource_map"] = None
            __props__.__dict__["identifier"] = None
            __props__.__dict__["last_discovered_at"] = None
            __props__.__dict__["last_successful_monitor_deployment"] = None
            __props__.__dict__["media_resource_map"] = None
            __props__.__dict__["modified_at"] = None
            __props__.__dict__["monitor_changes_pending_deployment"] = None
            __props__.__dict__["monitor_deployment"] = None
            __props__.__dict__["status"] = None
        replace_on_changes = pulumi.ResourceOptions(replace_on_changes=["tags.*"])
        opts = pulumi.ResourceOptions.merge(opts, replace_on_changes)
        super(SignalMap, __self__).__init__(
            'aws-native:medialive:SignalMap',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None) -> 'SignalMap':
        """
        Get an existing SignalMap resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = SignalMapArgs.__new__(SignalMapArgs)

        __props__.__dict__["arn"] = None
        __props__.__dict__["aws_id"] = None
        __props__.__dict__["cloud_watch_alarm_template_group_identifiers"] = None
        __props__.__dict__["cloud_watch_alarm_template_group_ids"] = None
        __props__.__dict__["created_at"] = None
        __props__.__dict__["description"] = None
        __props__.__dict__["discovery_entry_point_arn"] = None
        __props__.__dict__["error_message"] = None
        __props__.__dict__["event_bridge_rule_template_group_identifiers"] = None
        __props__.__dict__["event_bridge_rule_template_group_ids"] = None
        __props__.__dict__["failed_media_resource_map"] = None
        __props__.__dict__["force_rediscovery"] = None
        __props__.__dict__["identifier"] = None
        __props__.__dict__["last_discovered_at"] = None
        __props__.__dict__["last_successful_monitor_deployment"] = None
        __props__.__dict__["media_resource_map"] = None
        __props__.__dict__["modified_at"] = None
        __props__.__dict__["monitor_changes_pending_deployment"] = None
        __props__.__dict__["monitor_deployment"] = None
        __props__.__dict__["name"] = None
        __props__.__dict__["status"] = None
        __props__.__dict__["tags"] = None
        return SignalMap(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter
    def arn(self) -> pulumi.Output[builtins.str]:
        """
        A signal map's ARN (Amazon Resource Name)
        """
        return pulumi.get(self, "arn")

    @property
    @pulumi.getter(name="awsId")
    def aws_id(self) -> pulumi.Output[builtins.str]:
        """
        A signal map's id.
        """
        return pulumi.get(self, "aws_id")

    @property
    @pulumi.getter(name="cloudWatchAlarmTemplateGroupIdentifiers")
    def cloud_watch_alarm_template_group_identifiers(self) -> pulumi.Output[Optional[Sequence[builtins.str]]]:
        """
        A cloudwatch alarm template group's identifier. Can be either be its id or current name.
        """
        return pulumi.get(self, "cloud_watch_alarm_template_group_identifiers")

    @property
    @pulumi.getter(name="cloudWatchAlarmTemplateGroupIds")
    def cloud_watch_alarm_template_group_ids(self) -> pulumi.Output[Sequence[builtins.str]]:
        """
        An alarm template group's id.
        """
        return pulumi.get(self, "cloud_watch_alarm_template_group_ids")

    @property
    @pulumi.getter(name="createdAt")
    def created_at(self) -> pulumi.Output[builtins.str]:
        """
        The date and time of resource creation.
        """
        return pulumi.get(self, "created_at")

    @property
    @pulumi.getter
    def description(self) -> pulumi.Output[Optional[builtins.str]]:
        """
        A resource's optional description.
        """
        return pulumi.get(self, "description")

    @property
    @pulumi.getter(name="discoveryEntryPointArn")
    def discovery_entry_point_arn(self) -> pulumi.Output[builtins.str]:
        """
        A top-level supported AWS resource ARN to discovery a signal map from.
        """
        return pulumi.get(self, "discovery_entry_point_arn")

    @property
    @pulumi.getter(name="errorMessage")
    def error_message(self) -> pulumi.Output[builtins.str]:
        """
        Error message associated with a failed creation or failed update attempt of a signal map.
        """
        return pulumi.get(self, "error_message")

    @property
    @pulumi.getter(name="eventBridgeRuleTemplateGroupIdentifiers")
    def event_bridge_rule_template_group_identifiers(self) -> pulumi.Output[Optional[Sequence[builtins.str]]]:
        """
        An eventbridge rule template group's identifier. Can be either be its id or current name.
        """
        return pulumi.get(self, "event_bridge_rule_template_group_identifiers")

    @property
    @pulumi.getter(name="eventBridgeRuleTemplateGroupIds")
    def event_bridge_rule_template_group_ids(self) -> pulumi.Output[Sequence[builtins.str]]:
        """
        An eventbridge rule template group's id.
        """
        return pulumi.get(self, "event_bridge_rule_template_group_ids")

    @property
    @pulumi.getter(name="failedMediaResourceMap")
    def failed_media_resource_map(self) -> pulumi.Output[Mapping[str, 'outputs.SignalMapMediaResource']]:
        return pulumi.get(self, "failed_media_resource_map")

    @property
    @pulumi.getter(name="forceRediscovery")
    def force_rediscovery(self) -> pulumi.Output[Optional[builtins.bool]]:
        """
        If true, will force a rediscovery of a signal map if an unchanged discoveryEntryPointArn is provided.
        """
        return pulumi.get(self, "force_rediscovery")

    @property
    @pulumi.getter
    def identifier(self) -> pulumi.Output[builtins.str]:
        return pulumi.get(self, "identifier")

    @property
    @pulumi.getter(name="lastDiscoveredAt")
    def last_discovered_at(self) -> pulumi.Output[builtins.str]:
        """
        The date and time of latest discovery.
        """
        return pulumi.get(self, "last_discovered_at")

    @property
    @pulumi.getter(name="lastSuccessfulMonitorDeployment")
    def last_successful_monitor_deployment(self) -> pulumi.Output['outputs.SignalMapSuccessfulMonitorDeployment']:
        return pulumi.get(self, "last_successful_monitor_deployment")

    @property
    @pulumi.getter(name="mediaResourceMap")
    def media_resource_map(self) -> pulumi.Output[Mapping[str, 'outputs.SignalMapMediaResource']]:
        return pulumi.get(self, "media_resource_map")

    @property
    @pulumi.getter(name="modifiedAt")
    def modified_at(self) -> pulumi.Output[builtins.str]:
        """
        The date and time of latest resource modification.
        """
        return pulumi.get(self, "modified_at")

    @property
    @pulumi.getter(name="monitorChangesPendingDeployment")
    def monitor_changes_pending_deployment(self) -> pulumi.Output[builtins.bool]:
        """
        If true, there are pending monitor changes for this signal map that can be deployed.
        """
        return pulumi.get(self, "monitor_changes_pending_deployment")

    @property
    @pulumi.getter(name="monitorDeployment")
    def monitor_deployment(self) -> pulumi.Output['outputs.SignalMapMonitorDeployment']:
        return pulumi.get(self, "monitor_deployment")

    @property
    @pulumi.getter
    def name(self) -> pulumi.Output[builtins.str]:
        """
        A resource's name. Names must be unique within the scope of a resource type in a specific region.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def status(self) -> pulumi.Output['SignalMapStatus']:
        """
        A signal map's current status, which is dependent on its lifecycle actions or associated jobs.
        """
        return pulumi.get(self, "status")

    @property
    @pulumi.getter
    def tags(self) -> pulumi.Output[Optional[Mapping[str, builtins.str]]]:
        return pulumi.get(self, "tags")

