# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs
from ._enums import *

__all__ = [
    'GetMultiplexprogramResult',
    'AwaitableGetMultiplexprogramResult',
    'get_multiplexprogram',
    'get_multiplexprogram_output',
]

@pulumi.output_type
class GetMultiplexprogramResult:
    def __init__(__self__, channel_id=None, multiplex_program_settings=None, packet_identifiers_map=None, pipeline_details=None):
        if channel_id and not isinstance(channel_id, str):
            raise TypeError("Expected argument 'channel_id' to be a str")
        pulumi.set(__self__, "channel_id", channel_id)
        if multiplex_program_settings and not isinstance(multiplex_program_settings, dict):
            raise TypeError("Expected argument 'multiplex_program_settings' to be a dict")
        pulumi.set(__self__, "multiplex_program_settings", multiplex_program_settings)
        if packet_identifiers_map and not isinstance(packet_identifiers_map, dict):
            raise TypeError("Expected argument 'packet_identifiers_map' to be a dict")
        pulumi.set(__self__, "packet_identifiers_map", packet_identifiers_map)
        if pipeline_details and not isinstance(pipeline_details, list):
            raise TypeError("Expected argument 'pipeline_details' to be a list")
        pulumi.set(__self__, "pipeline_details", pipeline_details)

    @property
    @pulumi.getter(name="channelId")
    def channel_id(self) -> Optional[builtins.str]:
        """
        The MediaLive channel associated with the program.
        """
        return pulumi.get(self, "channel_id")

    @property
    @pulumi.getter(name="multiplexProgramSettings")
    def multiplex_program_settings(self) -> Optional['outputs.MultiplexprogramMultiplexProgramSettings']:
        """
        The settings for this multiplex program.
        """
        return pulumi.get(self, "multiplex_program_settings")

    @property
    @pulumi.getter(name="packetIdentifiersMap")
    def packet_identifiers_map(self) -> Optional['outputs.MultiplexprogramMultiplexProgramPacketIdentifiersMap']:
        """
        The packet identifier map for this multiplex program.
        """
        return pulumi.get(self, "packet_identifiers_map")

    @property
    @pulumi.getter(name="pipelineDetails")
    def pipeline_details(self) -> Optional[Sequence['outputs.MultiplexprogramMultiplexProgramPipelineDetail']]:
        """
        Contains information about the current sources for the specified program in the specified multiplex. Keep in mind that each multiplex pipeline connects to both pipelines in a given source channel (the channel identified by the program). But only one of those channel pipelines is ever active at one time.
        """
        return pulumi.get(self, "pipeline_details")


class AwaitableGetMultiplexprogramResult(GetMultiplexprogramResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetMultiplexprogramResult(
            channel_id=self.channel_id,
            multiplex_program_settings=self.multiplex_program_settings,
            packet_identifiers_map=self.packet_identifiers_map,
            pipeline_details=self.pipeline_details)


def get_multiplexprogram(multiplex_id: Optional[builtins.str] = None,
                         program_name: Optional[builtins.str] = None,
                         opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetMultiplexprogramResult:
    """
    Resource schema for AWS::MediaLive::Multiplexprogram


    :param builtins.str multiplex_id: The ID of the multiplex that the program belongs to.
    :param builtins.str program_name: The name of the multiplex program.
    """
    __args__ = dict()
    __args__['multiplexId'] = multiplex_id
    __args__['programName'] = program_name
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('aws-native:medialive:getMultiplexprogram', __args__, opts=opts, typ=GetMultiplexprogramResult).value

    return AwaitableGetMultiplexprogramResult(
        channel_id=pulumi.get(__ret__, 'channel_id'),
        multiplex_program_settings=pulumi.get(__ret__, 'multiplex_program_settings'),
        packet_identifiers_map=pulumi.get(__ret__, 'packet_identifiers_map'),
        pipeline_details=pulumi.get(__ret__, 'pipeline_details'))
def get_multiplexprogram_output(multiplex_id: Optional[pulumi.Input[builtins.str]] = None,
                                program_name: Optional[pulumi.Input[builtins.str]] = None,
                                opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetMultiplexprogramResult]:
    """
    Resource schema for AWS::MediaLive::Multiplexprogram


    :param builtins.str multiplex_id: The ID of the multiplex that the program belongs to.
    :param builtins.str program_name: The name of the multiplex program.
    """
    __args__ = dict()
    __args__['multiplexId'] = multiplex_id
    __args__['programName'] = program_name
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('aws-native:medialive:getMultiplexprogram', __args__, opts=opts, typ=GetMultiplexprogramResult)
    return __ret__.apply(lambda __response__: GetMultiplexprogramResult(
        channel_id=pulumi.get(__response__, 'channel_id'),
        multiplex_program_settings=pulumi.get(__response__, 'multiplex_program_settings'),
        packet_identifiers_map=pulumi.get(__response__, 'packet_identifiers_map'),
        pipeline_details=pulumi.get(__response__, 'pipeline_details')))
