# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from .. import outputs as _root_outputs
from ._enums import *

__all__ = [
    'GetChannelPlacementGroupResult',
    'AwaitableGetChannelPlacementGroupResult',
    'get_channel_placement_group',
    'get_channel_placement_group_output',
]

@pulumi.output_type
class GetChannelPlacementGroupResult:
    def __init__(__self__, arn=None, channels=None, id=None, name=None, nodes=None, state=None, tags=None):
        if arn and not isinstance(arn, str):
            raise TypeError("Expected argument 'arn' to be a str")
        pulumi.set(__self__, "arn", arn)
        if channels and not isinstance(channels, list):
            raise TypeError("Expected argument 'channels' to be a list")
        pulumi.set(__self__, "channels", channels)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if name and not isinstance(name, str):
            raise TypeError("Expected argument 'name' to be a str")
        pulumi.set(__self__, "name", name)
        if nodes and not isinstance(nodes, list):
            raise TypeError("Expected argument 'nodes' to be a list")
        pulumi.set(__self__, "nodes", nodes)
        if state and not isinstance(state, str):
            raise TypeError("Expected argument 'state' to be a str")
        pulumi.set(__self__, "state", state)
        if tags and not isinstance(tags, list):
            raise TypeError("Expected argument 'tags' to be a list")
        pulumi.set(__self__, "tags", tags)

    @property
    @pulumi.getter
    def arn(self) -> Optional[builtins.str]:
        """
        The ARN of the channel placement group.
        """
        return pulumi.get(self, "arn")

    @property
    @pulumi.getter
    def channels(self) -> Optional[Sequence[builtins.str]]:
        """
        List of channel IDs added to the channel placement group.
        """
        return pulumi.get(self, "channels")

    @property
    @pulumi.getter
    def id(self) -> Optional[builtins.str]:
        """
        Unique internal identifier.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter
    def name(self) -> Optional[builtins.str]:
        """
        The name of the channel placement group.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def nodes(self) -> Optional[Sequence[builtins.str]]:
        """
        List of nodes added to the channel placement group
        """
        return pulumi.get(self, "nodes")

    @property
    @pulumi.getter
    def state(self) -> Optional['ChannelPlacementGroupState']:
        return pulumi.get(self, "state")

    @property
    @pulumi.getter
    def tags(self) -> Optional[Sequence['_root_outputs.Tag']]:
        """
        A collection of key-value pairs.
        """
        return pulumi.get(self, "tags")


class AwaitableGetChannelPlacementGroupResult(GetChannelPlacementGroupResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetChannelPlacementGroupResult(
            arn=self.arn,
            channels=self.channels,
            id=self.id,
            name=self.name,
            nodes=self.nodes,
            state=self.state,
            tags=self.tags)


def get_channel_placement_group(cluster_id: Optional[builtins.str] = None,
                                id: Optional[builtins.str] = None,
                                opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetChannelPlacementGroupResult:
    """
    Definition of AWS::MediaLive::ChannelPlacementGroup Resource Type


    :param builtins.str cluster_id: The ID of the cluster the node is on.
    :param builtins.str id: Unique internal identifier.
    """
    __args__ = dict()
    __args__['clusterId'] = cluster_id
    __args__['id'] = id
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('aws-native:medialive:getChannelPlacementGroup', __args__, opts=opts, typ=GetChannelPlacementGroupResult).value

    return AwaitableGetChannelPlacementGroupResult(
        arn=pulumi.get(__ret__, 'arn'),
        channels=pulumi.get(__ret__, 'channels'),
        id=pulumi.get(__ret__, 'id'),
        name=pulumi.get(__ret__, 'name'),
        nodes=pulumi.get(__ret__, 'nodes'),
        state=pulumi.get(__ret__, 'state'),
        tags=pulumi.get(__ret__, 'tags'))
def get_channel_placement_group_output(cluster_id: Optional[pulumi.Input[builtins.str]] = None,
                                       id: Optional[pulumi.Input[builtins.str]] = None,
                                       opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetChannelPlacementGroupResult]:
    """
    Definition of AWS::MediaLive::ChannelPlacementGroup Resource Type


    :param builtins.str cluster_id: The ID of the cluster the node is on.
    :param builtins.str id: Unique internal identifier.
    """
    __args__ = dict()
    __args__['clusterId'] = cluster_id
    __args__['id'] = id
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('aws-native:medialive:getChannelPlacementGroup', __args__, opts=opts, typ=GetChannelPlacementGroupResult)
    return __ret__.apply(lambda __response__: GetChannelPlacementGroupResult(
        arn=pulumi.get(__response__, 'arn'),
        channels=pulumi.get(__response__, 'channels'),
        id=pulumi.get(__response__, 'id'),
        name=pulumi.get(__response__, 'name'),
        nodes=pulumi.get(__response__, 'nodes'),
        state=pulumi.get(__response__, 'state'),
        tags=pulumi.get(__response__, 'tags')))
