# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs
from ._enums import *

__all__ = [
    'BridgeEgressGatewayBridge',
    'BridgeFailoverConfig',
    'BridgeFlowSource',
    'BridgeIngressGatewayBridge',
    'BridgeMulticastSourceSettings',
    'BridgeNetworkOutput',
    'BridgeNetworkSource',
    'BridgeOutput',
    'BridgeOutputResourceBridgeNetworkOutput',
    'BridgeSource',
    'BridgeSourceBridgeFlowSource',
    'BridgeSourceBridgeNetworkSource',
    'BridgeSourceMulticastSourceSettings',
    'BridgeSourcePriority',
    'BridgeSourceVpcInterfaceAttachment',
    'BridgeVpcInterfaceAttachment',
    'FlowAudioMonitoringSetting',
    'FlowBlackFrames',
    'FlowEncryption',
    'FlowEntitlementEncryption',
    'FlowFailoverConfig',
    'FlowFailoverConfigSourcePriorityProperties',
    'FlowFmtp',
    'FlowFrozenFrames',
    'FlowGatewayBridgeSource',
    'FlowInputConfiguration',
    'FlowInterface',
    'FlowMaintenance',
    'FlowMediaStream',
    'FlowMediaStreamAttributes',
    'FlowMediaStreamSourceConfiguration',
    'FlowNdiConfig',
    'FlowNdiDiscoveryServerConfig',
    'FlowOutputDestinationConfiguration',
    'FlowOutputEncodingParameters',
    'FlowOutputEncryption',
    'FlowOutputInterface',
    'FlowOutputMediaStreamOutputConfiguration',
    'FlowOutputVpcInterfaceAttachment',
    'FlowSilentAudio',
    'FlowSource',
    'FlowSourceEncryption',
    'FlowSourceGatewayBridgeSource',
    'FlowSourceMonitoringConfig',
    'FlowSourceVpcInterfaceAttachment',
    'FlowVideoMonitoringSetting',
    'FlowVpcInterface',
    'FlowVpcInterfaceAttachment',
    'GatewayNetwork',
]

@pulumi.output_type
class BridgeEgressGatewayBridge(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "maxBitrate":
            suggest = "max_bitrate"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in BridgeEgressGatewayBridge. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        BridgeEgressGatewayBridge.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        BridgeEgressGatewayBridge.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 max_bitrate: builtins.int):
        """
        :param builtins.int max_bitrate: The maximum expected bitrate of the egress bridge.
        """
        pulumi.set(__self__, "max_bitrate", max_bitrate)

    @property
    @pulumi.getter(name="maxBitrate")
    def max_bitrate(self) -> builtins.int:
        """
        The maximum expected bitrate of the egress bridge.
        """
        return pulumi.get(self, "max_bitrate")


@pulumi.output_type
class BridgeFailoverConfig(dict):
    """
    The settings for source failover.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "failoverMode":
            suggest = "failover_mode"
        elif key == "sourcePriority":
            suggest = "source_priority"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in BridgeFailoverConfig. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        BridgeFailoverConfig.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        BridgeFailoverConfig.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 failover_mode: 'BridgeFailoverModeEnum',
                 source_priority: Optional['outputs.BridgeSourcePriority'] = None,
                 state: Optional['BridgeFailoverConfigStateEnum'] = None):
        """
        The settings for source failover.
        :param 'BridgeFailoverModeEnum' failover_mode: The type of failover you choose for this flow. FAILOVER allows switching between different streams.
        :param 'BridgeSourcePriority' source_priority: The priority you want to assign to a source. You can have a primary stream and a backup stream or two equally prioritized streams.
        :param 'BridgeFailoverConfigStateEnum' state: The state of source failover on the flow. If the state is inactive, the flow can have only one source. If the state is active, the flow can have one or two sources.
        """
        pulumi.set(__self__, "failover_mode", failover_mode)
        if source_priority is not None:
            pulumi.set(__self__, "source_priority", source_priority)
        if state is not None:
            pulumi.set(__self__, "state", state)

    @property
    @pulumi.getter(name="failoverMode")
    def failover_mode(self) -> 'BridgeFailoverModeEnum':
        """
        The type of failover you choose for this flow. FAILOVER allows switching between different streams.
        """
        return pulumi.get(self, "failover_mode")

    @property
    @pulumi.getter(name="sourcePriority")
    def source_priority(self) -> Optional['outputs.BridgeSourcePriority']:
        """
        The priority you want to assign to a source. You can have a primary stream and a backup stream or two equally prioritized streams.
        """
        return pulumi.get(self, "source_priority")

    @property
    @pulumi.getter
    def state(self) -> Optional['BridgeFailoverConfigStateEnum']:
        """
        The state of source failover on the flow. If the state is inactive, the flow can have only one source. If the state is active, the flow can have one or two sources.
        """
        return pulumi.get(self, "state")


@pulumi.output_type
class BridgeFlowSource(dict):
    """
    The source of the bridge. A flow source originates in MediaConnect as an existing cloud flow.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "flowArn":
            suggest = "flow_arn"
        elif key == "flowVpcInterfaceAttachment":
            suggest = "flow_vpc_interface_attachment"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in BridgeFlowSource. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        BridgeFlowSource.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        BridgeFlowSource.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 flow_arn: builtins.str,
                 name: builtins.str,
                 flow_vpc_interface_attachment: Optional['outputs.BridgeVpcInterfaceAttachment'] = None):
        """
        The source of the bridge. A flow source originates in MediaConnect as an existing cloud flow.
        :param builtins.str flow_arn: The ARN of the cloud flow used as a source of this bridge.
        :param builtins.str name: The name of the flow source.
        :param 'BridgeVpcInterfaceAttachment' flow_vpc_interface_attachment: The name of the VPC interface attachment to use for this source.
        """
        pulumi.set(__self__, "flow_arn", flow_arn)
        pulumi.set(__self__, "name", name)
        if flow_vpc_interface_attachment is not None:
            pulumi.set(__self__, "flow_vpc_interface_attachment", flow_vpc_interface_attachment)

    @property
    @pulumi.getter(name="flowArn")
    def flow_arn(self) -> builtins.str:
        """
        The ARN of the cloud flow used as a source of this bridge.
        """
        return pulumi.get(self, "flow_arn")

    @property
    @pulumi.getter
    def name(self) -> builtins.str:
        """
        The name of the flow source.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="flowVpcInterfaceAttachment")
    def flow_vpc_interface_attachment(self) -> Optional['outputs.BridgeVpcInterfaceAttachment']:
        """
        The name of the VPC interface attachment to use for this source.
        """
        return pulumi.get(self, "flow_vpc_interface_attachment")


@pulumi.output_type
class BridgeIngressGatewayBridge(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "maxBitrate":
            suggest = "max_bitrate"
        elif key == "maxOutputs":
            suggest = "max_outputs"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in BridgeIngressGatewayBridge. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        BridgeIngressGatewayBridge.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        BridgeIngressGatewayBridge.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 max_bitrate: builtins.int,
                 max_outputs: builtins.int):
        """
        :param builtins.int max_bitrate: The maximum expected bitrate of the ingress bridge.
        :param builtins.int max_outputs: The maximum number of outputs on the ingress bridge.
        """
        pulumi.set(__self__, "max_bitrate", max_bitrate)
        pulumi.set(__self__, "max_outputs", max_outputs)

    @property
    @pulumi.getter(name="maxBitrate")
    def max_bitrate(self) -> builtins.int:
        """
        The maximum expected bitrate of the ingress bridge.
        """
        return pulumi.get(self, "max_bitrate")

    @property
    @pulumi.getter(name="maxOutputs")
    def max_outputs(self) -> builtins.int:
        """
        The maximum number of outputs on the ingress bridge.
        """
        return pulumi.get(self, "max_outputs")


@pulumi.output_type
class BridgeMulticastSourceSettings(dict):
    """
    The settings related to the multicast source.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "multicastSourceIp":
            suggest = "multicast_source_ip"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in BridgeMulticastSourceSettings. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        BridgeMulticastSourceSettings.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        BridgeMulticastSourceSettings.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 multicast_source_ip: Optional[builtins.str] = None):
        """
        The settings related to the multicast source.
        :param builtins.str multicast_source_ip: The IP address of the source for source-specific multicast (SSM).
        """
        if multicast_source_ip is not None:
            pulumi.set(__self__, "multicast_source_ip", multicast_source_ip)

    @property
    @pulumi.getter(name="multicastSourceIp")
    def multicast_source_ip(self) -> Optional[builtins.str]:
        """
        The IP address of the source for source-specific multicast (SSM).
        """
        return pulumi.get(self, "multicast_source_ip")


@pulumi.output_type
class BridgeNetworkOutput(dict):
    """
    The output of the bridge. A network output is delivered to your premises.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "ipAddress":
            suggest = "ip_address"
        elif key == "networkName":
            suggest = "network_name"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in BridgeNetworkOutput. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        BridgeNetworkOutput.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        BridgeNetworkOutput.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 ip_address: builtins.str,
                 name: builtins.str,
                 network_name: builtins.str,
                 port: builtins.int,
                 protocol: 'BridgeProtocolEnum',
                 ttl: builtins.int):
        """
        The output of the bridge. A network output is delivered to your premises.
        :param builtins.str ip_address: The network output IP Address.
        :param builtins.str name: The network output name.
        :param builtins.str network_name: The network output's gateway network name.
        :param builtins.int port: The network output port.
        :param 'BridgeProtocolEnum' protocol: The network output protocol.
        :param builtins.int ttl: The network output TTL.
        """
        pulumi.set(__self__, "ip_address", ip_address)
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "network_name", network_name)
        pulumi.set(__self__, "port", port)
        pulumi.set(__self__, "protocol", protocol)
        pulumi.set(__self__, "ttl", ttl)

    @property
    @pulumi.getter(name="ipAddress")
    def ip_address(self) -> builtins.str:
        """
        The network output IP Address.
        """
        return pulumi.get(self, "ip_address")

    @property
    @pulumi.getter
    def name(self) -> builtins.str:
        """
        The network output name.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="networkName")
    def network_name(self) -> builtins.str:
        """
        The network output's gateway network name.
        """
        return pulumi.get(self, "network_name")

    @property
    @pulumi.getter
    def port(self) -> builtins.int:
        """
        The network output port.
        """
        return pulumi.get(self, "port")

    @property
    @pulumi.getter
    def protocol(self) -> 'BridgeProtocolEnum':
        """
        The network output protocol.
        """
        return pulumi.get(self, "protocol")

    @property
    @pulumi.getter
    def ttl(self) -> builtins.int:
        """
        The network output TTL.
        """
        return pulumi.get(self, "ttl")


@pulumi.output_type
class BridgeNetworkSource(dict):
    """
    The source of the bridge. A network source originates at your premises.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "multicastIp":
            suggest = "multicast_ip"
        elif key == "networkName":
            suggest = "network_name"
        elif key == "multicastSourceSettings":
            suggest = "multicast_source_settings"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in BridgeNetworkSource. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        BridgeNetworkSource.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        BridgeNetworkSource.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 multicast_ip: builtins.str,
                 name: builtins.str,
                 network_name: builtins.str,
                 port: builtins.int,
                 protocol: 'BridgeProtocolEnum',
                 multicast_source_settings: Optional['outputs.BridgeMulticastSourceSettings'] = None):
        """
        The source of the bridge. A network source originates at your premises.
        :param builtins.str multicast_ip: The network source multicast IP.
        :param builtins.str name: The name of the network source.
        :param builtins.str network_name: The network source's gateway network name.
        :param builtins.int port: The network source port.
        :param 'BridgeProtocolEnum' protocol: The network source protocol.
        :param 'BridgeMulticastSourceSettings' multicast_source_settings: The settings related to the multicast source.
        """
        pulumi.set(__self__, "multicast_ip", multicast_ip)
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "network_name", network_name)
        pulumi.set(__self__, "port", port)
        pulumi.set(__self__, "protocol", protocol)
        if multicast_source_settings is not None:
            pulumi.set(__self__, "multicast_source_settings", multicast_source_settings)

    @property
    @pulumi.getter(name="multicastIp")
    def multicast_ip(self) -> builtins.str:
        """
        The network source multicast IP.
        """
        return pulumi.get(self, "multicast_ip")

    @property
    @pulumi.getter
    def name(self) -> builtins.str:
        """
        The name of the network source.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="networkName")
    def network_name(self) -> builtins.str:
        """
        The network source's gateway network name.
        """
        return pulumi.get(self, "network_name")

    @property
    @pulumi.getter
    def port(self) -> builtins.int:
        """
        The network source port.
        """
        return pulumi.get(self, "port")

    @property
    @pulumi.getter
    def protocol(self) -> 'BridgeProtocolEnum':
        """
        The network source protocol.
        """
        return pulumi.get(self, "protocol")

    @property
    @pulumi.getter(name="multicastSourceSettings")
    def multicast_source_settings(self) -> Optional['outputs.BridgeMulticastSourceSettings']:
        """
        The settings related to the multicast source.
        """
        return pulumi.get(self, "multicast_source_settings")


@pulumi.output_type
class BridgeOutput(dict):
    """
    The output of the bridge.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "networkOutput":
            suggest = "network_output"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in BridgeOutput. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        BridgeOutput.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        BridgeOutput.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 network_output: Optional['outputs.BridgeNetworkOutput'] = None):
        """
        The output of the bridge.
        :param 'BridgeNetworkOutput' network_output: The output of the bridge. A network output is delivered to your premises.
        """
        if network_output is not None:
            pulumi.set(__self__, "network_output", network_output)

    @property
    @pulumi.getter(name="networkOutput")
    def network_output(self) -> Optional['outputs.BridgeNetworkOutput']:
        """
        The output of the bridge. A network output is delivered to your premises.
        """
        return pulumi.get(self, "network_output")


@pulumi.output_type
class BridgeOutputResourceBridgeNetworkOutput(dict):
    """
    The output of the bridge. A network output is delivered to your premises.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "ipAddress":
            suggest = "ip_address"
        elif key == "networkName":
            suggest = "network_name"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in BridgeOutputResourceBridgeNetworkOutput. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        BridgeOutputResourceBridgeNetworkOutput.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        BridgeOutputResourceBridgeNetworkOutput.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 ip_address: builtins.str,
                 network_name: builtins.str,
                 port: builtins.int,
                 protocol: 'BridgeOutputResourceBridgeNetworkOutputProtocol',
                 ttl: builtins.int):
        """
        The output of the bridge. A network output is delivered to your premises.
        :param builtins.str ip_address: The network output IP Address.
        :param builtins.str network_name: The network output's gateway network name.
        :param builtins.int port: The network output port.
        :param 'BridgeOutputResourceBridgeNetworkOutputProtocol' protocol: The network output protocol.
        :param builtins.int ttl: The network output TTL.
        """
        pulumi.set(__self__, "ip_address", ip_address)
        pulumi.set(__self__, "network_name", network_name)
        pulumi.set(__self__, "port", port)
        pulumi.set(__self__, "protocol", protocol)
        pulumi.set(__self__, "ttl", ttl)

    @property
    @pulumi.getter(name="ipAddress")
    def ip_address(self) -> builtins.str:
        """
        The network output IP Address.
        """
        return pulumi.get(self, "ip_address")

    @property
    @pulumi.getter(name="networkName")
    def network_name(self) -> builtins.str:
        """
        The network output's gateway network name.
        """
        return pulumi.get(self, "network_name")

    @property
    @pulumi.getter
    def port(self) -> builtins.int:
        """
        The network output port.
        """
        return pulumi.get(self, "port")

    @property
    @pulumi.getter
    def protocol(self) -> 'BridgeOutputResourceBridgeNetworkOutputProtocol':
        """
        The network output protocol.
        """
        return pulumi.get(self, "protocol")

    @property
    @pulumi.getter
    def ttl(self) -> builtins.int:
        """
        The network output TTL.
        """
        return pulumi.get(self, "ttl")


@pulumi.output_type
class BridgeSource(dict):
    """
    The bridge's source.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "flowSource":
            suggest = "flow_source"
        elif key == "networkSource":
            suggest = "network_source"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in BridgeSource. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        BridgeSource.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        BridgeSource.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 flow_source: Optional['outputs.BridgeFlowSource'] = None,
                 network_source: Optional['outputs.BridgeNetworkSource'] = None):
        """
        The bridge's source.
        :param 'BridgeFlowSource' flow_source: The source of the bridge. A flow source originates in MediaConnect as an existing cloud flow.
        :param 'BridgeNetworkSource' network_source: The source of the bridge. A network source originates at your premises.
        """
        if flow_source is not None:
            pulumi.set(__self__, "flow_source", flow_source)
        if network_source is not None:
            pulumi.set(__self__, "network_source", network_source)

    @property
    @pulumi.getter(name="flowSource")
    def flow_source(self) -> Optional['outputs.BridgeFlowSource']:
        """
        The source of the bridge. A flow source originates in MediaConnect as an existing cloud flow.
        """
        return pulumi.get(self, "flow_source")

    @property
    @pulumi.getter(name="networkSource")
    def network_source(self) -> Optional['outputs.BridgeNetworkSource']:
        """
        The source of the bridge. A network source originates at your premises.
        """
        return pulumi.get(self, "network_source")


@pulumi.output_type
class BridgeSourceBridgeFlowSource(dict):
    """
    The source of the bridge. A flow source originates in MediaConnect as an existing cloud flow.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "flowArn":
            suggest = "flow_arn"
        elif key == "flowVpcInterfaceAttachment":
            suggest = "flow_vpc_interface_attachment"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in BridgeSourceBridgeFlowSource. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        BridgeSourceBridgeFlowSource.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        BridgeSourceBridgeFlowSource.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 flow_arn: builtins.str,
                 flow_vpc_interface_attachment: Optional['outputs.BridgeSourceVpcInterfaceAttachment'] = None):
        """
        The source of the bridge. A flow source originates in MediaConnect as an existing cloud flow.
        :param builtins.str flow_arn: The ARN of the cloud flow used as a source of this bridge.
        :param 'BridgeSourceVpcInterfaceAttachment' flow_vpc_interface_attachment: The name of the VPC interface attachment to use for this source.
        """
        pulumi.set(__self__, "flow_arn", flow_arn)
        if flow_vpc_interface_attachment is not None:
            pulumi.set(__self__, "flow_vpc_interface_attachment", flow_vpc_interface_attachment)

    @property
    @pulumi.getter(name="flowArn")
    def flow_arn(self) -> builtins.str:
        """
        The ARN of the cloud flow used as a source of this bridge.
        """
        return pulumi.get(self, "flow_arn")

    @property
    @pulumi.getter(name="flowVpcInterfaceAttachment")
    def flow_vpc_interface_attachment(self) -> Optional['outputs.BridgeSourceVpcInterfaceAttachment']:
        """
        The name of the VPC interface attachment to use for this source.
        """
        return pulumi.get(self, "flow_vpc_interface_attachment")


@pulumi.output_type
class BridgeSourceBridgeNetworkSource(dict):
    """
    The source of the bridge. A network source originates at your premises.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "multicastIp":
            suggest = "multicast_ip"
        elif key == "networkName":
            suggest = "network_name"
        elif key == "multicastSourceSettings":
            suggest = "multicast_source_settings"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in BridgeSourceBridgeNetworkSource. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        BridgeSourceBridgeNetworkSource.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        BridgeSourceBridgeNetworkSource.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 multicast_ip: builtins.str,
                 network_name: builtins.str,
                 port: builtins.int,
                 protocol: 'BridgeSourceProtocolEnum',
                 multicast_source_settings: Optional['outputs.BridgeSourceMulticastSourceSettings'] = None):
        """
        The source of the bridge. A network source originates at your premises.
        :param builtins.str multicast_ip: The network source multicast IP.
        :param builtins.str network_name: The network source's gateway network name.
        :param builtins.int port: The network source port.
        :param 'BridgeSourceProtocolEnum' protocol: The network source protocol.
        :param 'BridgeSourceMulticastSourceSettings' multicast_source_settings: The settings related to the multicast source.
        """
        pulumi.set(__self__, "multicast_ip", multicast_ip)
        pulumi.set(__self__, "network_name", network_name)
        pulumi.set(__self__, "port", port)
        pulumi.set(__self__, "protocol", protocol)
        if multicast_source_settings is not None:
            pulumi.set(__self__, "multicast_source_settings", multicast_source_settings)

    @property
    @pulumi.getter(name="multicastIp")
    def multicast_ip(self) -> builtins.str:
        """
        The network source multicast IP.
        """
        return pulumi.get(self, "multicast_ip")

    @property
    @pulumi.getter(name="networkName")
    def network_name(self) -> builtins.str:
        """
        The network source's gateway network name.
        """
        return pulumi.get(self, "network_name")

    @property
    @pulumi.getter
    def port(self) -> builtins.int:
        """
        The network source port.
        """
        return pulumi.get(self, "port")

    @property
    @pulumi.getter
    def protocol(self) -> 'BridgeSourceProtocolEnum':
        """
        The network source protocol.
        """
        return pulumi.get(self, "protocol")

    @property
    @pulumi.getter(name="multicastSourceSettings")
    def multicast_source_settings(self) -> Optional['outputs.BridgeSourceMulticastSourceSettings']:
        """
        The settings related to the multicast source.
        """
        return pulumi.get(self, "multicast_source_settings")


@pulumi.output_type
class BridgeSourceMulticastSourceSettings(dict):
    """
    The settings related to the multicast source.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "multicastSourceIp":
            suggest = "multicast_source_ip"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in BridgeSourceMulticastSourceSettings. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        BridgeSourceMulticastSourceSettings.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        BridgeSourceMulticastSourceSettings.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 multicast_source_ip: Optional[builtins.str] = None):
        """
        The settings related to the multicast source.
        :param builtins.str multicast_source_ip: The IP address of the source for source-specific multicast (SSM).
        """
        if multicast_source_ip is not None:
            pulumi.set(__self__, "multicast_source_ip", multicast_source_ip)

    @property
    @pulumi.getter(name="multicastSourceIp")
    def multicast_source_ip(self) -> Optional[builtins.str]:
        """
        The IP address of the source for source-specific multicast (SSM).
        """
        return pulumi.get(self, "multicast_source_ip")


@pulumi.output_type
class BridgeSourcePriority(dict):
    """
    The priority you want to assign to a source. You can have a primary stream and a backup stream or two equally prioritized streams.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "primarySource":
            suggest = "primary_source"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in BridgeSourcePriority. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        BridgeSourcePriority.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        BridgeSourcePriority.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 primary_source: Optional[builtins.str] = None):
        """
        The priority you want to assign to a source. You can have a primary stream and a backup stream or two equally prioritized streams.
        :param builtins.str primary_source: The name of the source you choose as the primary source for this flow.
        """
        if primary_source is not None:
            pulumi.set(__self__, "primary_source", primary_source)

    @property
    @pulumi.getter(name="primarySource")
    def primary_source(self) -> Optional[builtins.str]:
        """
        The name of the source you choose as the primary source for this flow.
        """
        return pulumi.get(self, "primary_source")


@pulumi.output_type
class BridgeSourceVpcInterfaceAttachment(dict):
    """
    The settings for attaching a VPC interface to an resource.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "vpcInterfaceName":
            suggest = "vpc_interface_name"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in BridgeSourceVpcInterfaceAttachment. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        BridgeSourceVpcInterfaceAttachment.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        BridgeSourceVpcInterfaceAttachment.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 vpc_interface_name: Optional[builtins.str] = None):
        """
        The settings for attaching a VPC interface to an resource.
        :param builtins.str vpc_interface_name: The name of the VPC interface to use for this resource.
        """
        if vpc_interface_name is not None:
            pulumi.set(__self__, "vpc_interface_name", vpc_interface_name)

    @property
    @pulumi.getter(name="vpcInterfaceName")
    def vpc_interface_name(self) -> Optional[builtins.str]:
        """
        The name of the VPC interface to use for this resource.
        """
        return pulumi.get(self, "vpc_interface_name")


@pulumi.output_type
class BridgeVpcInterfaceAttachment(dict):
    """
    The settings for attaching a VPC interface to an resource.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "vpcInterfaceName":
            suggest = "vpc_interface_name"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in BridgeVpcInterfaceAttachment. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        BridgeVpcInterfaceAttachment.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        BridgeVpcInterfaceAttachment.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 vpc_interface_name: Optional[builtins.str] = None):
        """
        The settings for attaching a VPC interface to an resource.
        :param builtins.str vpc_interface_name: The name of the VPC interface to use for this resource.
        """
        if vpc_interface_name is not None:
            pulumi.set(__self__, "vpc_interface_name", vpc_interface_name)

    @property
    @pulumi.getter(name="vpcInterfaceName")
    def vpc_interface_name(self) -> Optional[builtins.str]:
        """
        The name of the VPC interface to use for this resource.
        """
        return pulumi.get(self, "vpc_interface_name")


@pulumi.output_type
class FlowAudioMonitoringSetting(dict):
    """
    Specifies the configuration for audio stream metrics monitoring.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "silentAudio":
            suggest = "silent_audio"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in FlowAudioMonitoringSetting. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        FlowAudioMonitoringSetting.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        FlowAudioMonitoringSetting.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 silent_audio: Optional['outputs.FlowSilentAudio'] = None):
        """
        Specifies the configuration for audio stream metrics monitoring.
        :param 'FlowSilentAudio' silent_audio: Detects periods of silence.
        """
        if silent_audio is not None:
            pulumi.set(__self__, "silent_audio", silent_audio)

    @property
    @pulumi.getter(name="silentAudio")
    def silent_audio(self) -> Optional['outputs.FlowSilentAudio']:
        """
        Detects periods of silence.
        """
        return pulumi.get(self, "silent_audio")


@pulumi.output_type
class FlowBlackFrames(dict):
    """
    Configures settings for the BlackFrames metric.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "thresholdSeconds":
            suggest = "threshold_seconds"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in FlowBlackFrames. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        FlowBlackFrames.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        FlowBlackFrames.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 state: Optional['FlowBlackFramesState'] = None,
                 threshold_seconds: Optional[builtins.int] = None):
        """
        Configures settings for the BlackFrames metric.
        :param 'FlowBlackFramesState' state: Indicates whether the BlackFrames metric is enabled or disabled.
        :param builtins.int threshold_seconds: Specifies the number of consecutive seconds of black frames that triggers an event or alert.
        """
        if state is not None:
            pulumi.set(__self__, "state", state)
        if threshold_seconds is not None:
            pulumi.set(__self__, "threshold_seconds", threshold_seconds)

    @property
    @pulumi.getter
    def state(self) -> Optional['FlowBlackFramesState']:
        """
        Indicates whether the BlackFrames metric is enabled or disabled.
        """
        return pulumi.get(self, "state")

    @property
    @pulumi.getter(name="thresholdSeconds")
    def threshold_seconds(self) -> Optional[builtins.int]:
        """
        Specifies the number of consecutive seconds of black frames that triggers an event or alert.
        """
        return pulumi.get(self, "threshold_seconds")


@pulumi.output_type
class FlowEncryption(dict):
    """
    Information about the encryption of the flow.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "roleArn":
            suggest = "role_arn"
        elif key == "constantInitializationVector":
            suggest = "constant_initialization_vector"
        elif key == "deviceId":
            suggest = "device_id"
        elif key == "keyType":
            suggest = "key_type"
        elif key == "resourceId":
            suggest = "resource_id"
        elif key == "secretArn":
            suggest = "secret_arn"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in FlowEncryption. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        FlowEncryption.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        FlowEncryption.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 role_arn: builtins.str,
                 algorithm: Optional['FlowEncryptionAlgorithm'] = None,
                 constant_initialization_vector: Optional[builtins.str] = None,
                 device_id: Optional[builtins.str] = None,
                 key_type: Optional['FlowEncryptionKeyType'] = None,
                 region: Optional[builtins.str] = None,
                 resource_id: Optional[builtins.str] = None,
                 secret_arn: Optional[builtins.str] = None,
                 url: Optional[builtins.str] = None):
        """
        Information about the encryption of the flow.
        :param builtins.str role_arn: The ARN of the role that you created during setup (when you set up AWS Elemental MediaConnect as a trusted entity).
        :param 'FlowEncryptionAlgorithm' algorithm: The type of algorithm that is used for the encryption (such as aes128, aes192, or aes256).
        :param builtins.str constant_initialization_vector: A 128-bit, 16-byte hex value represented by a 32-character string, to be used with the key for encrypting content. This parameter is not valid for static key encryption.
        :param builtins.str device_id: The value of one of the devices that you configured with your digital rights management (DRM) platform key provider. This parameter is required for SPEKE encryption and is not valid for static key encryption.
        :param 'FlowEncryptionKeyType' key_type: The type of key that is used for the encryption. If no keyType is provided, the service will use the default setting (static-key).
        :param builtins.str region: The AWS Region that the API Gateway proxy endpoint was created in. This parameter is required for SPEKE encryption and is not valid for static key encryption.
        :param builtins.str resource_id: An identifier for the content. The service sends this value to the key server to identify the current endpoint. The resource ID is also known as the content ID. This parameter is required for SPEKE encryption and is not valid for static key encryption.
        :param builtins.str secret_arn:  The ARN of the secret that you created in AWS Secrets Manager to store the encryption key. This parameter is required for static key encryption and is not valid for SPEKE encryption.
        :param builtins.str url: The URL from the API Gateway proxy that you set up to talk to your key server. This parameter is required for SPEKE encryption and is not valid for static key encryption.
        """
        pulumi.set(__self__, "role_arn", role_arn)
        if algorithm is not None:
            pulumi.set(__self__, "algorithm", algorithm)
        if constant_initialization_vector is not None:
            pulumi.set(__self__, "constant_initialization_vector", constant_initialization_vector)
        if device_id is not None:
            pulumi.set(__self__, "device_id", device_id)
        if key_type is not None:
            pulumi.set(__self__, "key_type", key_type)
        if region is not None:
            pulumi.set(__self__, "region", region)
        if resource_id is not None:
            pulumi.set(__self__, "resource_id", resource_id)
        if secret_arn is not None:
            pulumi.set(__self__, "secret_arn", secret_arn)
        if url is not None:
            pulumi.set(__self__, "url", url)

    @property
    @pulumi.getter(name="roleArn")
    def role_arn(self) -> builtins.str:
        """
        The ARN of the role that you created during setup (when you set up AWS Elemental MediaConnect as a trusted entity).
        """
        return pulumi.get(self, "role_arn")

    @property
    @pulumi.getter
    def algorithm(self) -> Optional['FlowEncryptionAlgorithm']:
        """
        The type of algorithm that is used for the encryption (such as aes128, aes192, or aes256).
        """
        return pulumi.get(self, "algorithm")

    @property
    @pulumi.getter(name="constantInitializationVector")
    def constant_initialization_vector(self) -> Optional[builtins.str]:
        """
        A 128-bit, 16-byte hex value represented by a 32-character string, to be used with the key for encrypting content. This parameter is not valid for static key encryption.
        """
        return pulumi.get(self, "constant_initialization_vector")

    @property
    @pulumi.getter(name="deviceId")
    def device_id(self) -> Optional[builtins.str]:
        """
        The value of one of the devices that you configured with your digital rights management (DRM) platform key provider. This parameter is required for SPEKE encryption and is not valid for static key encryption.
        """
        return pulumi.get(self, "device_id")

    @property
    @pulumi.getter(name="keyType")
    def key_type(self) -> Optional['FlowEncryptionKeyType']:
        """
        The type of key that is used for the encryption. If no keyType is provided, the service will use the default setting (static-key).
        """
        return pulumi.get(self, "key_type")

    @property
    @pulumi.getter
    def region(self) -> Optional[builtins.str]:
        """
        The AWS Region that the API Gateway proxy endpoint was created in. This parameter is required for SPEKE encryption and is not valid for static key encryption.
        """
        return pulumi.get(self, "region")

    @property
    @pulumi.getter(name="resourceId")
    def resource_id(self) -> Optional[builtins.str]:
        """
        An identifier for the content. The service sends this value to the key server to identify the current endpoint. The resource ID is also known as the content ID. This parameter is required for SPEKE encryption and is not valid for static key encryption.
        """
        return pulumi.get(self, "resource_id")

    @property
    @pulumi.getter(name="secretArn")
    def secret_arn(self) -> Optional[builtins.str]:
        """
         The ARN of the secret that you created in AWS Secrets Manager to store the encryption key. This parameter is required for static key encryption and is not valid for SPEKE encryption.
        """
        return pulumi.get(self, "secret_arn")

    @property
    @pulumi.getter
    def url(self) -> Optional[builtins.str]:
        """
        The URL from the API Gateway proxy that you set up to talk to your key server. This parameter is required for SPEKE encryption and is not valid for static key encryption.
        """
        return pulumi.get(self, "url")


@pulumi.output_type
class FlowEntitlementEncryption(dict):
    """
    Information about the encryption of the flow.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "roleArn":
            suggest = "role_arn"
        elif key == "constantInitializationVector":
            suggest = "constant_initialization_vector"
        elif key == "deviceId":
            suggest = "device_id"
        elif key == "keyType":
            suggest = "key_type"
        elif key == "resourceId":
            suggest = "resource_id"
        elif key == "secretArn":
            suggest = "secret_arn"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in FlowEntitlementEncryption. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        FlowEntitlementEncryption.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        FlowEntitlementEncryption.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 algorithm: 'FlowEntitlementEncryptionAlgorithm',
                 role_arn: builtins.str,
                 constant_initialization_vector: Optional[builtins.str] = None,
                 device_id: Optional[builtins.str] = None,
                 key_type: Optional['FlowEntitlementEncryptionKeyType'] = None,
                 region: Optional[builtins.str] = None,
                 resource_id: Optional[builtins.str] = None,
                 secret_arn: Optional[builtins.str] = None,
                 url: Optional[builtins.str] = None):
        """
        Information about the encryption of the flow.
        :param 'FlowEntitlementEncryptionAlgorithm' algorithm: The type of algorithm that is used for the encryption (such as aes128, aes192, or aes256).
        :param builtins.str role_arn: The ARN of the role that you created during setup (when you set up AWS Elemental MediaConnect as a trusted entity).
        :param builtins.str constant_initialization_vector: A 128-bit, 16-byte hex value represented by a 32-character string, to be used with the key for encrypting content. This parameter is not valid for static key encryption.
        :param builtins.str device_id: The value of one of the devices that you configured with your digital rights management (DRM) platform key provider. This parameter is required for SPEKE encryption and is not valid for static key encryption.
        :param 'FlowEntitlementEncryptionKeyType' key_type: The type of key that is used for the encryption. If no keyType is provided, the service will use the default setting (static-key).
        :param builtins.str region: The AWS Region that the API Gateway proxy endpoint was created in. This parameter is required for SPEKE encryption and is not valid for static key encryption.
        :param builtins.str resource_id: An identifier for the content. The service sends this value to the key server to identify the current endpoint. The resource ID is also known as the content ID. This parameter is required for SPEKE encryption and is not valid for static key encryption.
        :param builtins.str secret_arn:  The ARN of the secret that you created in AWS Secrets Manager to store the encryption key. This parameter is required for static key encryption and is not valid for SPEKE encryption.
        :param builtins.str url: The URL from the API Gateway proxy that you set up to talk to your key server. This parameter is required for SPEKE encryption and is not valid for static key encryption.
        """
        pulumi.set(__self__, "algorithm", algorithm)
        pulumi.set(__self__, "role_arn", role_arn)
        if constant_initialization_vector is not None:
            pulumi.set(__self__, "constant_initialization_vector", constant_initialization_vector)
        if device_id is not None:
            pulumi.set(__self__, "device_id", device_id)
        if key_type is not None:
            pulumi.set(__self__, "key_type", key_type)
        if region is not None:
            pulumi.set(__self__, "region", region)
        if resource_id is not None:
            pulumi.set(__self__, "resource_id", resource_id)
        if secret_arn is not None:
            pulumi.set(__self__, "secret_arn", secret_arn)
        if url is not None:
            pulumi.set(__self__, "url", url)

    @property
    @pulumi.getter
    def algorithm(self) -> 'FlowEntitlementEncryptionAlgorithm':
        """
        The type of algorithm that is used for the encryption (such as aes128, aes192, or aes256).
        """
        return pulumi.get(self, "algorithm")

    @property
    @pulumi.getter(name="roleArn")
    def role_arn(self) -> builtins.str:
        """
        The ARN of the role that you created during setup (when you set up AWS Elemental MediaConnect as a trusted entity).
        """
        return pulumi.get(self, "role_arn")

    @property
    @pulumi.getter(name="constantInitializationVector")
    def constant_initialization_vector(self) -> Optional[builtins.str]:
        """
        A 128-bit, 16-byte hex value represented by a 32-character string, to be used with the key for encrypting content. This parameter is not valid for static key encryption.
        """
        return pulumi.get(self, "constant_initialization_vector")

    @property
    @pulumi.getter(name="deviceId")
    def device_id(self) -> Optional[builtins.str]:
        """
        The value of one of the devices that you configured with your digital rights management (DRM) platform key provider. This parameter is required for SPEKE encryption and is not valid for static key encryption.
        """
        return pulumi.get(self, "device_id")

    @property
    @pulumi.getter(name="keyType")
    def key_type(self) -> Optional['FlowEntitlementEncryptionKeyType']:
        """
        The type of key that is used for the encryption. If no keyType is provided, the service will use the default setting (static-key).
        """
        return pulumi.get(self, "key_type")

    @property
    @pulumi.getter
    def region(self) -> Optional[builtins.str]:
        """
        The AWS Region that the API Gateway proxy endpoint was created in. This parameter is required for SPEKE encryption and is not valid for static key encryption.
        """
        return pulumi.get(self, "region")

    @property
    @pulumi.getter(name="resourceId")
    def resource_id(self) -> Optional[builtins.str]:
        """
        An identifier for the content. The service sends this value to the key server to identify the current endpoint. The resource ID is also known as the content ID. This parameter is required for SPEKE encryption and is not valid for static key encryption.
        """
        return pulumi.get(self, "resource_id")

    @property
    @pulumi.getter(name="secretArn")
    def secret_arn(self) -> Optional[builtins.str]:
        """
         The ARN of the secret that you created in AWS Secrets Manager to store the encryption key. This parameter is required for static key encryption and is not valid for SPEKE encryption.
        """
        return pulumi.get(self, "secret_arn")

    @property
    @pulumi.getter
    def url(self) -> Optional[builtins.str]:
        """
        The URL from the API Gateway proxy that you set up to talk to your key server. This parameter is required for SPEKE encryption and is not valid for static key encryption.
        """
        return pulumi.get(self, "url")


@pulumi.output_type
class FlowFailoverConfig(dict):
    """
    The settings for source failover
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "failoverMode":
            suggest = "failover_mode"
        elif key == "recoveryWindow":
            suggest = "recovery_window"
        elif key == "sourcePriority":
            suggest = "source_priority"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in FlowFailoverConfig. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        FlowFailoverConfig.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        FlowFailoverConfig.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 failover_mode: Optional['FlowFailoverConfigFailoverMode'] = None,
                 recovery_window: Optional[builtins.int] = None,
                 source_priority: Optional['outputs.FlowFailoverConfigSourcePriorityProperties'] = None,
                 state: Optional['FlowFailoverConfigState'] = None):
        """
        The settings for source failover
        :param 'FlowFailoverConfigFailoverMode' failover_mode: The type of failover you choose for this flow. MERGE combines the source streams into a single stream, allowing graceful recovery from any single-source loss. FAILOVER allows switching between different streams.
        :param builtins.int recovery_window: Search window time to look for dash-7 packets
        :param 'FlowFailoverConfigSourcePriorityProperties' source_priority: The priority you want to assign to a source. You can have a primary stream and a backup stream or two equally prioritized streams.
        :param 'FlowFailoverConfigState' state: The state of source failover on the flow. If the state is inactive, the flow can have only one source. If the state is active, the flow can have one or two sources.
        """
        if failover_mode is not None:
            pulumi.set(__self__, "failover_mode", failover_mode)
        if recovery_window is not None:
            pulumi.set(__self__, "recovery_window", recovery_window)
        if source_priority is not None:
            pulumi.set(__self__, "source_priority", source_priority)
        if state is not None:
            pulumi.set(__self__, "state", state)

    @property
    @pulumi.getter(name="failoverMode")
    def failover_mode(self) -> Optional['FlowFailoverConfigFailoverMode']:
        """
        The type of failover you choose for this flow. MERGE combines the source streams into a single stream, allowing graceful recovery from any single-source loss. FAILOVER allows switching between different streams.
        """
        return pulumi.get(self, "failover_mode")

    @property
    @pulumi.getter(name="recoveryWindow")
    def recovery_window(self) -> Optional[builtins.int]:
        """
        Search window time to look for dash-7 packets
        """
        return pulumi.get(self, "recovery_window")

    @property
    @pulumi.getter(name="sourcePriority")
    def source_priority(self) -> Optional['outputs.FlowFailoverConfigSourcePriorityProperties']:
        """
        The priority you want to assign to a source. You can have a primary stream and a backup stream or two equally prioritized streams.
        """
        return pulumi.get(self, "source_priority")

    @property
    @pulumi.getter
    def state(self) -> Optional['FlowFailoverConfigState']:
        """
        The state of source failover on the flow. If the state is inactive, the flow can have only one source. If the state is active, the flow can have one or two sources.
        """
        return pulumi.get(self, "state")


@pulumi.output_type
class FlowFailoverConfigSourcePriorityProperties(dict):
    """
    The priority you want to assign to a source. You can have a primary stream and a backup stream or two equally prioritized streams.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "primarySource":
            suggest = "primary_source"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in FlowFailoverConfigSourcePriorityProperties. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        FlowFailoverConfigSourcePriorityProperties.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        FlowFailoverConfigSourcePriorityProperties.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 primary_source: builtins.str):
        """
        The priority you want to assign to a source. You can have a primary stream and a backup stream or two equally prioritized streams.
        :param builtins.str primary_source: The name of the source you choose as the primary source for this flow.
        """
        pulumi.set(__self__, "primary_source", primary_source)

    @property
    @pulumi.getter(name="primarySource")
    def primary_source(self) -> builtins.str:
        """
        The name of the source you choose as the primary source for this flow.
        """
        return pulumi.get(self, "primary_source")


@pulumi.output_type
class FlowFmtp(dict):
    """
    A set of parameters that define the media stream.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "channelOrder":
            suggest = "channel_order"
        elif key == "exactFramerate":
            suggest = "exact_framerate"
        elif key == "scanMode":
            suggest = "scan_mode"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in FlowFmtp. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        FlowFmtp.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        FlowFmtp.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 channel_order: Optional[builtins.str] = None,
                 colorimetry: Optional['FlowFmtpColorimetry'] = None,
                 exact_framerate: Optional[builtins.str] = None,
                 par: Optional[builtins.str] = None,
                 range: Optional['FlowFmtpRange'] = None,
                 scan_mode: Optional['FlowFmtpScanMode'] = None,
                 tcs: Optional['FlowFmtpTcs'] = None):
        """
        A set of parameters that define the media stream.
        :param builtins.str channel_order: The format of the audio channel.
        :param 'FlowFmtpColorimetry' colorimetry: The format used for the representation of color.
        :param builtins.str exact_framerate: The frame rate for the video stream, in frames/second. For example: 60000/1001.
        :param builtins.str par: The pixel aspect ratio (PAR) of the video.
        :param 'FlowFmtpRange' range: The encoding range of the video.
        :param 'FlowFmtpScanMode' scan_mode: The type of compression that was used to smooth the video's appearance.
        :param 'FlowFmtpTcs' tcs: The transfer characteristic system (TCS) that is used in the video.
        """
        if channel_order is not None:
            pulumi.set(__self__, "channel_order", channel_order)
        if colorimetry is not None:
            pulumi.set(__self__, "colorimetry", colorimetry)
        if exact_framerate is not None:
            pulumi.set(__self__, "exact_framerate", exact_framerate)
        if par is not None:
            pulumi.set(__self__, "par", par)
        if range is not None:
            pulumi.set(__self__, "range", range)
        if scan_mode is not None:
            pulumi.set(__self__, "scan_mode", scan_mode)
        if tcs is not None:
            pulumi.set(__self__, "tcs", tcs)

    @property
    @pulumi.getter(name="channelOrder")
    def channel_order(self) -> Optional[builtins.str]:
        """
        The format of the audio channel.
        """
        return pulumi.get(self, "channel_order")

    @property
    @pulumi.getter
    def colorimetry(self) -> Optional['FlowFmtpColorimetry']:
        """
        The format used for the representation of color.
        """
        return pulumi.get(self, "colorimetry")

    @property
    @pulumi.getter(name="exactFramerate")
    def exact_framerate(self) -> Optional[builtins.str]:
        """
        The frame rate for the video stream, in frames/second. For example: 60000/1001.
        """
        return pulumi.get(self, "exact_framerate")

    @property
    @pulumi.getter
    def par(self) -> Optional[builtins.str]:
        """
        The pixel aspect ratio (PAR) of the video.
        """
        return pulumi.get(self, "par")

    @property
    @pulumi.getter
    def range(self) -> Optional['FlowFmtpRange']:
        """
        The encoding range of the video.
        """
        return pulumi.get(self, "range")

    @property
    @pulumi.getter(name="scanMode")
    def scan_mode(self) -> Optional['FlowFmtpScanMode']:
        """
        The type of compression that was used to smooth the video's appearance.
        """
        return pulumi.get(self, "scan_mode")

    @property
    @pulumi.getter
    def tcs(self) -> Optional['FlowFmtpTcs']:
        """
        The transfer characteristic system (TCS) that is used in the video.
        """
        return pulumi.get(self, "tcs")


@pulumi.output_type
class FlowFrozenFrames(dict):
    """
    Configures settings for the FrozenFrames metric.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "thresholdSeconds":
            suggest = "threshold_seconds"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in FlowFrozenFrames. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        FlowFrozenFrames.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        FlowFrozenFrames.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 state: Optional['FlowFrozenFramesState'] = None,
                 threshold_seconds: Optional[builtins.int] = None):
        """
        Configures settings for the FrozenFrames metric.
        :param 'FlowFrozenFramesState' state: Indicates whether the FrozenFrames metric is enabled or disabled.
        :param builtins.int threshold_seconds: Specifies the number of consecutive seconds of a static image that triggers an event or alert.
        """
        if state is not None:
            pulumi.set(__self__, "state", state)
        if threshold_seconds is not None:
            pulumi.set(__self__, "threshold_seconds", threshold_seconds)

    @property
    @pulumi.getter
    def state(self) -> Optional['FlowFrozenFramesState']:
        """
        Indicates whether the FrozenFrames metric is enabled or disabled.
        """
        return pulumi.get(self, "state")

    @property
    @pulumi.getter(name="thresholdSeconds")
    def threshold_seconds(self) -> Optional[builtins.int]:
        """
        Specifies the number of consecutive seconds of a static image that triggers an event or alert.
        """
        return pulumi.get(self, "threshold_seconds")


@pulumi.output_type
class FlowGatewayBridgeSource(dict):
    """
    The source configuration for cloud flows receiving a stream from a bridge.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "bridgeArn":
            suggest = "bridge_arn"
        elif key == "vpcInterfaceAttachment":
            suggest = "vpc_interface_attachment"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in FlowGatewayBridgeSource. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        FlowGatewayBridgeSource.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        FlowGatewayBridgeSource.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 bridge_arn: builtins.str,
                 vpc_interface_attachment: Optional['outputs.FlowVpcInterfaceAttachment'] = None):
        """
        The source configuration for cloud flows receiving a stream from a bridge.
        :param builtins.str bridge_arn: The ARN of the bridge feeding this flow.
        :param 'FlowVpcInterfaceAttachment' vpc_interface_attachment: The name of the VPC interface attachment to use for this bridge source.
        """
        pulumi.set(__self__, "bridge_arn", bridge_arn)
        if vpc_interface_attachment is not None:
            pulumi.set(__self__, "vpc_interface_attachment", vpc_interface_attachment)

    @property
    @pulumi.getter(name="bridgeArn")
    def bridge_arn(self) -> builtins.str:
        """
        The ARN of the bridge feeding this flow.
        """
        return pulumi.get(self, "bridge_arn")

    @property
    @pulumi.getter(name="vpcInterfaceAttachment")
    def vpc_interface_attachment(self) -> Optional['outputs.FlowVpcInterfaceAttachment']:
        """
        The name of the VPC interface attachment to use for this bridge source.
        """
        return pulumi.get(self, "vpc_interface_attachment")


@pulumi.output_type
class FlowInputConfiguration(dict):
    """
    The transport parameters associated with an incoming media stream.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "inputPort":
            suggest = "input_port"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in FlowInputConfiguration. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        FlowInputConfiguration.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        FlowInputConfiguration.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 input_port: builtins.int,
                 interface: 'outputs.FlowInterface'):
        """
        The transport parameters associated with an incoming media stream.
        :param builtins.int input_port: The port that the flow listens on for an incoming media stream.
        :param 'FlowInterface' interface: The VPC interface where the media stream comes in from.
        """
        pulumi.set(__self__, "input_port", input_port)
        pulumi.set(__self__, "interface", interface)

    @property
    @pulumi.getter(name="inputPort")
    def input_port(self) -> builtins.int:
        """
        The port that the flow listens on for an incoming media stream.
        """
        return pulumi.get(self, "input_port")

    @property
    @pulumi.getter
    def interface(self) -> 'outputs.FlowInterface':
        """
        The VPC interface where the media stream comes in from.
        """
        return pulumi.get(self, "interface")


@pulumi.output_type
class FlowInterface(dict):
    """
    The VPC interface that you want to use for the media stream associated with the output.
    """
    def __init__(__self__, *,
                 name: builtins.str):
        """
        The VPC interface that you want to use for the media stream associated with the output.
        :param builtins.str name: The name of the VPC interface that you want to use for the media stream associated with the output.
        """
        pulumi.set(__self__, "name", name)

    @property
    @pulumi.getter
    def name(self) -> builtins.str:
        """
        The name of the VPC interface that you want to use for the media stream associated with the output.
        """
        return pulumi.get(self, "name")


@pulumi.output_type
class FlowMaintenance(dict):
    """
    The maintenance setting of a flow.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "maintenanceDay":
            suggest = "maintenance_day"
        elif key == "maintenanceStartHour":
            suggest = "maintenance_start_hour"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in FlowMaintenance. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        FlowMaintenance.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        FlowMaintenance.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 maintenance_day: 'FlowMaintenanceMaintenanceDay',
                 maintenance_start_hour: builtins.str):
        """
        The maintenance setting of a flow.
        :param 'FlowMaintenanceMaintenanceDay' maintenance_day: A day of a week when the maintenance will happen. Use Monday/Tuesday/Wednesday/Thursday/Friday/Saturday/Sunday.
        :param builtins.str maintenance_start_hour: UTC time when the maintenance will happen. Use 24-hour HH:MM format. Minutes must be 00. Example: 13:00. The default value is 02:00.
        """
        pulumi.set(__self__, "maintenance_day", maintenance_day)
        pulumi.set(__self__, "maintenance_start_hour", maintenance_start_hour)

    @property
    @pulumi.getter(name="maintenanceDay")
    def maintenance_day(self) -> 'FlowMaintenanceMaintenanceDay':
        """
        A day of a week when the maintenance will happen. Use Monday/Tuesday/Wednesday/Thursday/Friday/Saturday/Sunday.
        """
        return pulumi.get(self, "maintenance_day")

    @property
    @pulumi.getter(name="maintenanceStartHour")
    def maintenance_start_hour(self) -> builtins.str:
        """
        UTC time when the maintenance will happen. Use 24-hour HH:MM format. Minutes must be 00. Example: 13:00. The default value is 02:00.
        """
        return pulumi.get(self, "maintenance_start_hour")


@pulumi.output_type
class FlowMediaStream(dict):
    """
    A single track or stream of media that contains video, audio, or ancillary data. After you add a media stream to a flow, you can associate it with sources and outputs on that flow, as long as they use the CDI protocol or the ST 2110 JPEG XS protocol. Each source or output can consist of one or many media streams.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "mediaStreamId":
            suggest = "media_stream_id"
        elif key == "mediaStreamName":
            suggest = "media_stream_name"
        elif key == "mediaStreamType":
            suggest = "media_stream_type"
        elif key == "clockRate":
            suggest = "clock_rate"
        elif key == "videoFormat":
            suggest = "video_format"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in FlowMediaStream. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        FlowMediaStream.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        FlowMediaStream.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 media_stream_id: builtins.int,
                 media_stream_name: builtins.str,
                 media_stream_type: 'FlowMediaStreamMediaStreamType',
                 attributes: Optional['outputs.FlowMediaStreamAttributes'] = None,
                 clock_rate: Optional[builtins.int] = None,
                 description: Optional[builtins.str] = None,
                 fmt: Optional[builtins.int] = None,
                 video_format: Optional['FlowMediaStreamVideoFormat'] = None):
        """
        A single track or stream of media that contains video, audio, or ancillary data. After you add a media stream to a flow, you can associate it with sources and outputs on that flow, as long as they use the CDI protocol or the ST 2110 JPEG XS protocol. Each source or output can consist of one or many media streams.
        :param builtins.int media_stream_id: A unique identifier for the media stream.
        :param builtins.str media_stream_name: A name that helps you distinguish one media stream from another.
        :param 'FlowMediaStreamMediaStreamType' media_stream_type: The type of media stream.
        :param 'FlowMediaStreamAttributes' attributes: Attributes that are related to the media stream.
        :param builtins.int clock_rate: The sample rate for the stream. This value in measured in kHz.
        :param builtins.str description: A description that can help you quickly identify what your media stream is used for.
        :param builtins.int fmt: The format type number (sometimes referred to as RTP payload type) of the media stream. MediaConnect assigns this value to the media stream. For ST 2110 JPEG XS outputs, you need to provide this value to the receiver.
        :param 'FlowMediaStreamVideoFormat' video_format: The resolution of the video.
        """
        pulumi.set(__self__, "media_stream_id", media_stream_id)
        pulumi.set(__self__, "media_stream_name", media_stream_name)
        pulumi.set(__self__, "media_stream_type", media_stream_type)
        if attributes is not None:
            pulumi.set(__self__, "attributes", attributes)
        if clock_rate is not None:
            pulumi.set(__self__, "clock_rate", clock_rate)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if fmt is not None:
            pulumi.set(__self__, "fmt", fmt)
        if video_format is not None:
            pulumi.set(__self__, "video_format", video_format)

    @property
    @pulumi.getter(name="mediaStreamId")
    def media_stream_id(self) -> builtins.int:
        """
        A unique identifier for the media stream.
        """
        return pulumi.get(self, "media_stream_id")

    @property
    @pulumi.getter(name="mediaStreamName")
    def media_stream_name(self) -> builtins.str:
        """
        A name that helps you distinguish one media stream from another.
        """
        return pulumi.get(self, "media_stream_name")

    @property
    @pulumi.getter(name="mediaStreamType")
    def media_stream_type(self) -> 'FlowMediaStreamMediaStreamType':
        """
        The type of media stream.
        """
        return pulumi.get(self, "media_stream_type")

    @property
    @pulumi.getter
    def attributes(self) -> Optional['outputs.FlowMediaStreamAttributes']:
        """
        Attributes that are related to the media stream.
        """
        return pulumi.get(self, "attributes")

    @property
    @pulumi.getter(name="clockRate")
    def clock_rate(self) -> Optional[builtins.int]:
        """
        The sample rate for the stream. This value in measured in kHz.
        """
        return pulumi.get(self, "clock_rate")

    @property
    @pulumi.getter
    def description(self) -> Optional[builtins.str]:
        """
        A description that can help you quickly identify what your media stream is used for.
        """
        return pulumi.get(self, "description")

    @property
    @pulumi.getter
    def fmt(self) -> Optional[builtins.int]:
        """
        The format type number (sometimes referred to as RTP payload type) of the media stream. MediaConnect assigns this value to the media stream. For ST 2110 JPEG XS outputs, you need to provide this value to the receiver.
        """
        return pulumi.get(self, "fmt")

    @property
    @pulumi.getter(name="videoFormat")
    def video_format(self) -> Optional['FlowMediaStreamVideoFormat']:
        """
        The resolution of the video.
        """
        return pulumi.get(self, "video_format")


@pulumi.output_type
class FlowMediaStreamAttributes(dict):
    """
    Attributes that are related to the media stream.
    """
    def __init__(__self__, *,
                 fmtp: Optional['outputs.FlowFmtp'] = None,
                 lang: Optional[builtins.str] = None):
        """
        Attributes that are related to the media stream.
        :param 'FlowFmtp' fmtp: A set of parameters that define the media stream.
        :param builtins.str lang: The audio language, in a format that is recognized by the receiver.
        """
        if fmtp is not None:
            pulumi.set(__self__, "fmtp", fmtp)
        if lang is not None:
            pulumi.set(__self__, "lang", lang)

    @property
    @pulumi.getter
    def fmtp(self) -> Optional['outputs.FlowFmtp']:
        """
        A set of parameters that define the media stream.
        """
        return pulumi.get(self, "fmtp")

    @property
    @pulumi.getter
    def lang(self) -> Optional[builtins.str]:
        """
        The audio language, in a format that is recognized by the receiver.
        """
        return pulumi.get(self, "lang")


@pulumi.output_type
class FlowMediaStreamSourceConfiguration(dict):
    """
    The media stream that is associated with the source, and the parameters for that association.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "encodingName":
            suggest = "encoding_name"
        elif key == "mediaStreamName":
            suggest = "media_stream_name"
        elif key == "inputConfigurations":
            suggest = "input_configurations"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in FlowMediaStreamSourceConfiguration. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        FlowMediaStreamSourceConfiguration.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        FlowMediaStreamSourceConfiguration.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 encoding_name: 'FlowMediaStreamSourceConfigurationEncodingName',
                 media_stream_name: builtins.str,
                 input_configurations: Optional[Sequence['outputs.FlowInputConfiguration']] = None):
        """
        The media stream that is associated with the source, and the parameters for that association.
        :param 'FlowMediaStreamSourceConfigurationEncodingName' encoding_name: The format that was used to encode the data. For ancillary data streams, set the encoding name to smpte291. For audio streams, set the encoding name to pcm. For video, 2110 streams, set the encoding name to raw. For video, JPEG XS streams, set the encoding name to jxsv.
        :param builtins.str media_stream_name: A name that helps you distinguish one media stream from another.
        :param Sequence['FlowInputConfiguration'] input_configurations: The media streams that you want to associate with the source.
        """
        pulumi.set(__self__, "encoding_name", encoding_name)
        pulumi.set(__self__, "media_stream_name", media_stream_name)
        if input_configurations is not None:
            pulumi.set(__self__, "input_configurations", input_configurations)

    @property
    @pulumi.getter(name="encodingName")
    def encoding_name(self) -> 'FlowMediaStreamSourceConfigurationEncodingName':
        """
        The format that was used to encode the data. For ancillary data streams, set the encoding name to smpte291. For audio streams, set the encoding name to pcm. For video, 2110 streams, set the encoding name to raw. For video, JPEG XS streams, set the encoding name to jxsv.
        """
        return pulumi.get(self, "encoding_name")

    @property
    @pulumi.getter(name="mediaStreamName")
    def media_stream_name(self) -> builtins.str:
        """
        A name that helps you distinguish one media stream from another.
        """
        return pulumi.get(self, "media_stream_name")

    @property
    @pulumi.getter(name="inputConfigurations")
    def input_configurations(self) -> Optional[Sequence['outputs.FlowInputConfiguration']]:
        """
        The media streams that you want to associate with the source.
        """
        return pulumi.get(self, "input_configurations")


@pulumi.output_type
class FlowNdiConfig(dict):
    """
    Specifies the configuration settings for NDI outputs. Required when the flow includes NDI outputs.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "machineName":
            suggest = "machine_name"
        elif key == "ndiDiscoveryServers":
            suggest = "ndi_discovery_servers"
        elif key == "ndiState":
            suggest = "ndi_state"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in FlowNdiConfig. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        FlowNdiConfig.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        FlowNdiConfig.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 machine_name: Optional[builtins.str] = None,
                 ndi_discovery_servers: Optional[Sequence['outputs.FlowNdiDiscoveryServerConfig']] = None,
                 ndi_state: Optional['FlowNdiConfigNdiState'] = None):
        """
        Specifies the configuration settings for NDI outputs. Required when the flow includes NDI outputs.
        :param builtins.str machine_name: A prefix for the names of the NDI sources that the flow creates. If a custom name isn't specified, MediaConnect generates a unique 12-character ID as the prefix.
        :param Sequence['FlowNdiDiscoveryServerConfig'] ndi_discovery_servers: A list of up to three NDI discovery server configurations. While not required by the API, this configuration is necessary for NDI functionality to work properly.
        :param 'FlowNdiConfigNdiState' ndi_state: A setting that controls whether NDI outputs can be used in the flow. Must be ENABLED to add NDI outputs. Default is DISABLED.
        """
        if machine_name is not None:
            pulumi.set(__self__, "machine_name", machine_name)
        if ndi_discovery_servers is not None:
            pulumi.set(__self__, "ndi_discovery_servers", ndi_discovery_servers)
        if ndi_state is not None:
            pulumi.set(__self__, "ndi_state", ndi_state)

    @property
    @pulumi.getter(name="machineName")
    def machine_name(self) -> Optional[builtins.str]:
        """
        A prefix for the names of the NDI sources that the flow creates. If a custom name isn't specified, MediaConnect generates a unique 12-character ID as the prefix.
        """
        return pulumi.get(self, "machine_name")

    @property
    @pulumi.getter(name="ndiDiscoveryServers")
    def ndi_discovery_servers(self) -> Optional[Sequence['outputs.FlowNdiDiscoveryServerConfig']]:
        """
        A list of up to three NDI discovery server configurations. While not required by the API, this configuration is necessary for NDI functionality to work properly.
        """
        return pulumi.get(self, "ndi_discovery_servers")

    @property
    @pulumi.getter(name="ndiState")
    def ndi_state(self) -> Optional['FlowNdiConfigNdiState']:
        """
        A setting that controls whether NDI outputs can be used in the flow. Must be ENABLED to add NDI outputs. Default is DISABLED.
        """
        return pulumi.get(self, "ndi_state")


@pulumi.output_type
class FlowNdiDiscoveryServerConfig(dict):
    """
    Specifies the configuration settings for individual NDI discovery servers. A maximum of 3 servers is allowed.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "discoveryServerAddress":
            suggest = "discovery_server_address"
        elif key == "vpcInterfaceAdapter":
            suggest = "vpc_interface_adapter"
        elif key == "discoveryServerPort":
            suggest = "discovery_server_port"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in FlowNdiDiscoveryServerConfig. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        FlowNdiDiscoveryServerConfig.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        FlowNdiDiscoveryServerConfig.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 discovery_server_address: builtins.str,
                 vpc_interface_adapter: builtins.str,
                 discovery_server_port: Optional[builtins.int] = None):
        """
        Specifies the configuration settings for individual NDI discovery servers. A maximum of 3 servers is allowed.
        :param builtins.str discovery_server_address: The unique network address of the NDI discovery server.
        :param builtins.str vpc_interface_adapter: The identifier for the Virtual Private Cloud (VPC) network interface used by the flow.
        :param builtins.int discovery_server_port: The port for the NDI discovery server. Defaults to 5959 if a custom port isn't specified.
        """
        pulumi.set(__self__, "discovery_server_address", discovery_server_address)
        pulumi.set(__self__, "vpc_interface_adapter", vpc_interface_adapter)
        if discovery_server_port is not None:
            pulumi.set(__self__, "discovery_server_port", discovery_server_port)

    @property
    @pulumi.getter(name="discoveryServerAddress")
    def discovery_server_address(self) -> builtins.str:
        """
        The unique network address of the NDI discovery server.
        """
        return pulumi.get(self, "discovery_server_address")

    @property
    @pulumi.getter(name="vpcInterfaceAdapter")
    def vpc_interface_adapter(self) -> builtins.str:
        """
        The identifier for the Virtual Private Cloud (VPC) network interface used by the flow.
        """
        return pulumi.get(self, "vpc_interface_adapter")

    @property
    @pulumi.getter(name="discoveryServerPort")
    def discovery_server_port(self) -> Optional[builtins.int]:
        """
        The port for the NDI discovery server. Defaults to 5959 if a custom port isn't specified.
        """
        return pulumi.get(self, "discovery_server_port")


@pulumi.output_type
class FlowOutputDestinationConfiguration(dict):
    """
    The definition of a media stream that is associated with the output.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "destinationIp":
            suggest = "destination_ip"
        elif key == "destinationPort":
            suggest = "destination_port"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in FlowOutputDestinationConfiguration. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        FlowOutputDestinationConfiguration.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        FlowOutputDestinationConfiguration.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 destination_ip: builtins.str,
                 destination_port: builtins.int,
                 interface: 'outputs.FlowOutputInterface'):
        """
        The definition of a media stream that is associated with the output.
        :param builtins.str destination_ip: The IP address where contents of the media stream will be sent.
        :param builtins.int destination_port: The port to use when the content of the media stream is distributed to the output.
        :param 'FlowOutputInterface' interface: The VPC interface that is used for the media stream associated with the output.
        """
        pulumi.set(__self__, "destination_ip", destination_ip)
        pulumi.set(__self__, "destination_port", destination_port)
        pulumi.set(__self__, "interface", interface)

    @property
    @pulumi.getter(name="destinationIp")
    def destination_ip(self) -> builtins.str:
        """
        The IP address where contents of the media stream will be sent.
        """
        return pulumi.get(self, "destination_ip")

    @property
    @pulumi.getter(name="destinationPort")
    def destination_port(self) -> builtins.int:
        """
        The port to use when the content of the media stream is distributed to the output.
        """
        return pulumi.get(self, "destination_port")

    @property
    @pulumi.getter
    def interface(self) -> 'outputs.FlowOutputInterface':
        """
        The VPC interface that is used for the media stream associated with the output.
        """
        return pulumi.get(self, "interface")


@pulumi.output_type
class FlowOutputEncodingParameters(dict):
    """
    A collection of parameters that determine how MediaConnect will convert the content. These fields only apply to outputs on flows that have a CDI source.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "compressionFactor":
            suggest = "compression_factor"
        elif key == "encoderProfile":
            suggest = "encoder_profile"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in FlowOutputEncodingParameters. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        FlowOutputEncodingParameters.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        FlowOutputEncodingParameters.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 compression_factor: builtins.float,
                 encoder_profile: Optional['FlowOutputEncodingParametersEncoderProfile'] = None):
        """
        A collection of parameters that determine how MediaConnect will convert the content. These fields only apply to outputs on flows that have a CDI source.
        :param builtins.float compression_factor: A value that is used to calculate compression for an output. The bitrate of the output is calculated as follows: Output bitrate = (1 / compressionFactor) * (source bitrate) This property only applies to outputs that use the ST 2110 JPEG XS protocol, with a flow source that uses the CDI protocol. Valid values are in the range of 3.0 to 10.0, inclusive.
        :param 'FlowOutputEncodingParametersEncoderProfile' encoder_profile: A setting on the encoder that drives compression settings. This property only applies to video media streams associated with outputs that use the ST 2110 JPEG XS protocol, with a flow source that uses the CDI protocol.
        """
        pulumi.set(__self__, "compression_factor", compression_factor)
        if encoder_profile is not None:
            pulumi.set(__self__, "encoder_profile", encoder_profile)

    @property
    @pulumi.getter(name="compressionFactor")
    def compression_factor(self) -> builtins.float:
        """
        A value that is used to calculate compression for an output. The bitrate of the output is calculated as follows: Output bitrate = (1 / compressionFactor) * (source bitrate) This property only applies to outputs that use the ST 2110 JPEG XS protocol, with a flow source that uses the CDI protocol. Valid values are in the range of 3.0 to 10.0, inclusive.
        """
        return pulumi.get(self, "compression_factor")

    @property
    @pulumi.getter(name="encoderProfile")
    def encoder_profile(self) -> Optional['FlowOutputEncodingParametersEncoderProfile']:
        """
        A setting on the encoder that drives compression settings. This property only applies to video media streams associated with outputs that use the ST 2110 JPEG XS protocol, with a flow source that uses the CDI protocol.
        """
        return pulumi.get(self, "encoder_profile")


@pulumi.output_type
class FlowOutputEncryption(dict):
    """
    Information about the encryption of the flow.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "roleArn":
            suggest = "role_arn"
        elif key == "secretArn":
            suggest = "secret_arn"
        elif key == "keyType":
            suggest = "key_type"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in FlowOutputEncryption. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        FlowOutputEncryption.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        FlowOutputEncryption.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 role_arn: builtins.str,
                 secret_arn: builtins.str,
                 algorithm: Optional['FlowOutputEncryptionAlgorithm'] = None,
                 key_type: Optional['FlowOutputEncryptionKeyType'] = None):
        """
        Information about the encryption of the flow.
        :param builtins.str role_arn: The ARN of the role that you created during setup (when you set up AWS Elemental MediaConnect as a trusted entity).
        :param builtins.str secret_arn:  The ARN of the secret that you created in AWS Secrets Manager to store the encryption key. This parameter is required for static key encryption and is not valid for SPEKE encryption.
        :param 'FlowOutputEncryptionAlgorithm' algorithm: The type of algorithm that is used for the encryption (such as aes128, aes192, or aes256).
        :param 'FlowOutputEncryptionKeyType' key_type: The type of key that is used for the encryption. If no keyType is provided, the service will use the default setting (static-key).
        """
        pulumi.set(__self__, "role_arn", role_arn)
        pulumi.set(__self__, "secret_arn", secret_arn)
        if algorithm is not None:
            pulumi.set(__self__, "algorithm", algorithm)
        if key_type is not None:
            pulumi.set(__self__, "key_type", key_type)

    @property
    @pulumi.getter(name="roleArn")
    def role_arn(self) -> builtins.str:
        """
        The ARN of the role that you created during setup (when you set up AWS Elemental MediaConnect as a trusted entity).
        """
        return pulumi.get(self, "role_arn")

    @property
    @pulumi.getter(name="secretArn")
    def secret_arn(self) -> builtins.str:
        """
         The ARN of the secret that you created in AWS Secrets Manager to store the encryption key. This parameter is required for static key encryption and is not valid for SPEKE encryption.
        """
        return pulumi.get(self, "secret_arn")

    @property
    @pulumi.getter
    def algorithm(self) -> Optional['FlowOutputEncryptionAlgorithm']:
        """
        The type of algorithm that is used for the encryption (such as aes128, aes192, or aes256).
        """
        return pulumi.get(self, "algorithm")

    @property
    @pulumi.getter(name="keyType")
    def key_type(self) -> Optional['FlowOutputEncryptionKeyType']:
        """
        The type of key that is used for the encryption. If no keyType is provided, the service will use the default setting (static-key).
        """
        return pulumi.get(self, "key_type")


@pulumi.output_type
class FlowOutputInterface(dict):
    """
    The VPC interface that you want to use for the media stream associated with the output.
    """
    def __init__(__self__, *,
                 name: builtins.str):
        """
        The VPC interface that you want to use for the media stream associated with the output.
        :param builtins.str name: The name of the VPC interface that you want to use for the media stream associated with the output.
        """
        pulumi.set(__self__, "name", name)

    @property
    @pulumi.getter
    def name(self) -> builtins.str:
        """
        The name of the VPC interface that you want to use for the media stream associated with the output.
        """
        return pulumi.get(self, "name")


@pulumi.output_type
class FlowOutputMediaStreamOutputConfiguration(dict):
    """
    The media stream that is associated with the output, and the parameters for that association.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "encodingName":
            suggest = "encoding_name"
        elif key == "mediaStreamName":
            suggest = "media_stream_name"
        elif key == "destinationConfigurations":
            suggest = "destination_configurations"
        elif key == "encodingParameters":
            suggest = "encoding_parameters"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in FlowOutputMediaStreamOutputConfiguration. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        FlowOutputMediaStreamOutputConfiguration.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        FlowOutputMediaStreamOutputConfiguration.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 encoding_name: 'FlowOutputMediaStreamOutputConfigurationEncodingName',
                 media_stream_name: builtins.str,
                 destination_configurations: Optional[Sequence['outputs.FlowOutputDestinationConfiguration']] = None,
                 encoding_parameters: Optional['outputs.FlowOutputEncodingParameters'] = None):
        """
        The media stream that is associated with the output, and the parameters for that association.
        :param 'FlowOutputMediaStreamOutputConfigurationEncodingName' encoding_name: The format that will be used to encode the data. For ancillary data streams, set the encoding name to smpte291. For audio streams, set the encoding name to pcm. For video streams on sources or outputs that use the CDI protocol, set the encoding name to raw. For video streams on sources or outputs that use the ST 2110 JPEG XS protocol, set the encoding name to jxsv.
        :param builtins.str media_stream_name: A name that helps you distinguish one media stream from another.
        :param Sequence['FlowOutputDestinationConfiguration'] destination_configurations: The media streams that you want to associate with the output.
        :param 'FlowOutputEncodingParameters' encoding_parameters: A collection of parameters that determine how MediaConnect will convert the content. These fields only apply to outputs on flows that have a CDI source.
        """
        pulumi.set(__self__, "encoding_name", encoding_name)
        pulumi.set(__self__, "media_stream_name", media_stream_name)
        if destination_configurations is not None:
            pulumi.set(__self__, "destination_configurations", destination_configurations)
        if encoding_parameters is not None:
            pulumi.set(__self__, "encoding_parameters", encoding_parameters)

    @property
    @pulumi.getter(name="encodingName")
    def encoding_name(self) -> 'FlowOutputMediaStreamOutputConfigurationEncodingName':
        """
        The format that will be used to encode the data. For ancillary data streams, set the encoding name to smpte291. For audio streams, set the encoding name to pcm. For video streams on sources or outputs that use the CDI protocol, set the encoding name to raw. For video streams on sources or outputs that use the ST 2110 JPEG XS protocol, set the encoding name to jxsv.
        """
        return pulumi.get(self, "encoding_name")

    @property
    @pulumi.getter(name="mediaStreamName")
    def media_stream_name(self) -> builtins.str:
        """
        A name that helps you distinguish one media stream from another.
        """
        return pulumi.get(self, "media_stream_name")

    @property
    @pulumi.getter(name="destinationConfigurations")
    def destination_configurations(self) -> Optional[Sequence['outputs.FlowOutputDestinationConfiguration']]:
        """
        The media streams that you want to associate with the output.
        """
        return pulumi.get(self, "destination_configurations")

    @property
    @pulumi.getter(name="encodingParameters")
    def encoding_parameters(self) -> Optional['outputs.FlowOutputEncodingParameters']:
        """
        A collection of parameters that determine how MediaConnect will convert the content. These fields only apply to outputs on flows that have a CDI source.
        """
        return pulumi.get(self, "encoding_parameters")


@pulumi.output_type
class FlowOutputVpcInterfaceAttachment(dict):
    """
    The settings for attaching a VPC interface to an output.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "vpcInterfaceName":
            suggest = "vpc_interface_name"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in FlowOutputVpcInterfaceAttachment. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        FlowOutputVpcInterfaceAttachment.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        FlowOutputVpcInterfaceAttachment.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 vpc_interface_name: Optional[builtins.str] = None):
        """
        The settings for attaching a VPC interface to an output.
        :param builtins.str vpc_interface_name: The name of the VPC interface to use for this output.
        """
        if vpc_interface_name is not None:
            pulumi.set(__self__, "vpc_interface_name", vpc_interface_name)

    @property
    @pulumi.getter(name="vpcInterfaceName")
    def vpc_interface_name(self) -> Optional[builtins.str]:
        """
        The name of the VPC interface to use for this output.
        """
        return pulumi.get(self, "vpc_interface_name")


@pulumi.output_type
class FlowSilentAudio(dict):
    """
    Configures settings for the SilentAudio metric.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "thresholdSeconds":
            suggest = "threshold_seconds"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in FlowSilentAudio. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        FlowSilentAudio.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        FlowSilentAudio.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 state: Optional['FlowSilentAudioState'] = None,
                 threshold_seconds: Optional[builtins.int] = None):
        """
        Configures settings for the SilentAudio metric.
        :param 'FlowSilentAudioState' state: Indicates whether the SilentAudio metric is enabled or disabled.
        :param builtins.int threshold_seconds: Specifies the number of consecutive seconds of silence that triggers an event or alert.
        """
        if state is not None:
            pulumi.set(__self__, "state", state)
        if threshold_seconds is not None:
            pulumi.set(__self__, "threshold_seconds", threshold_seconds)

    @property
    @pulumi.getter
    def state(self) -> Optional['FlowSilentAudioState']:
        """
        Indicates whether the SilentAudio metric is enabled or disabled.
        """
        return pulumi.get(self, "state")

    @property
    @pulumi.getter(name="thresholdSeconds")
    def threshold_seconds(self) -> Optional[builtins.int]:
        """
        Specifies the number of consecutive seconds of silence that triggers an event or alert.
        """
        return pulumi.get(self, "threshold_seconds")


@pulumi.output_type
class FlowSource(dict):
    """
    The settings for the source of the flow.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "entitlementArn":
            suggest = "entitlement_arn"
        elif key == "gatewayBridgeSource":
            suggest = "gateway_bridge_source"
        elif key == "ingestIp":
            suggest = "ingest_ip"
        elif key == "ingestPort":
            suggest = "ingest_port"
        elif key == "maxBitrate":
            suggest = "max_bitrate"
        elif key == "maxLatency":
            suggest = "max_latency"
        elif key == "maxSyncBuffer":
            suggest = "max_sync_buffer"
        elif key == "mediaStreamSourceConfigurations":
            suggest = "media_stream_source_configurations"
        elif key == "minLatency":
            suggest = "min_latency"
        elif key == "senderControlPort":
            suggest = "sender_control_port"
        elif key == "senderIpAddress":
            suggest = "sender_ip_address"
        elif key == "sourceArn":
            suggest = "source_arn"
        elif key == "sourceIngestPort":
            suggest = "source_ingest_port"
        elif key == "sourceListenerAddress":
            suggest = "source_listener_address"
        elif key == "sourceListenerPort":
            suggest = "source_listener_port"
        elif key == "streamId":
            suggest = "stream_id"
        elif key == "vpcInterfaceName":
            suggest = "vpc_interface_name"
        elif key == "whitelistCidr":
            suggest = "whitelist_cidr"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in FlowSource. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        FlowSource.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        FlowSource.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 decryption: Optional['outputs.FlowEncryption'] = None,
                 description: Optional[builtins.str] = None,
                 entitlement_arn: Optional[builtins.str] = None,
                 gateway_bridge_source: Optional['outputs.FlowGatewayBridgeSource'] = None,
                 ingest_ip: Optional[builtins.str] = None,
                 ingest_port: Optional[builtins.int] = None,
                 max_bitrate: Optional[builtins.int] = None,
                 max_latency: Optional[builtins.int] = None,
                 max_sync_buffer: Optional[builtins.int] = None,
                 media_stream_source_configurations: Optional[Sequence['outputs.FlowMediaStreamSourceConfiguration']] = None,
                 min_latency: Optional[builtins.int] = None,
                 name: Optional[builtins.str] = None,
                 protocol: Optional['FlowSourceProtocol'] = None,
                 sender_control_port: Optional[builtins.int] = None,
                 sender_ip_address: Optional[builtins.str] = None,
                 source_arn: Optional[builtins.str] = None,
                 source_ingest_port: Optional[builtins.str] = None,
                 source_listener_address: Optional[builtins.str] = None,
                 source_listener_port: Optional[builtins.int] = None,
                 stream_id: Optional[builtins.str] = None,
                 vpc_interface_name: Optional[builtins.str] = None,
                 whitelist_cidr: Optional[builtins.str] = None):
        """
        The settings for the source of the flow.
        :param 'FlowEncryption' decryption: The type of decryption that is used on the content ingested from this source.
        :param builtins.str description: A description for the source. This value is not used or seen outside of the current AWS Elemental MediaConnect account.
        :param builtins.str entitlement_arn: The ARN of the entitlement that allows you to subscribe to content that comes from another AWS account. The entitlement is set by the content originator and the ARN is generated as part of the originator's flow.
        :param 'FlowGatewayBridgeSource' gateway_bridge_source: The source configuration for cloud flows receiving a stream from a bridge.
        :param builtins.str ingest_ip: The IP address that the flow will be listening on for incoming content.
        :param builtins.int ingest_port: The port that the flow will be listening on for incoming content.
        :param builtins.int max_bitrate: The smoothing max bitrate for RIST, RTP, and RTP-FEC streams.
        :param builtins.int max_latency: The maximum latency in milliseconds. This parameter applies only to RIST-based and Zixi-based streams.
        :param builtins.int max_sync_buffer: The size of the buffer (in milliseconds) to use to sync incoming source data.
        :param Sequence['FlowMediaStreamSourceConfiguration'] media_stream_source_configurations: The media stream that is associated with the source, and the parameters for that association.
        :param builtins.int min_latency: The minimum latency in milliseconds.
        :param builtins.str name: The name of the source.
        :param 'FlowSourceProtocol' protocol: The protocol that is used by the source.
        :param builtins.int sender_control_port: The port that the flow uses to send outbound requests to initiate connection with the sender for fujitsu-qos protocol.
        :param builtins.str sender_ip_address: The IP address that the flow communicates with to initiate connection with the sender for fujitsu-qos protocol.
        :param builtins.str source_arn: The ARN of the source.
        :param builtins.str source_ingest_port: The port that the flow will be listening on for incoming content.(ReadOnly)
        :param builtins.str source_listener_address: Source IP or domain name for SRT-caller protocol.
        :param builtins.int source_listener_port: Source port for SRT-caller protocol.
        :param builtins.str stream_id: The stream ID that you want to use for this transport. This parameter applies only to Zixi-based streams.
        :param builtins.str vpc_interface_name: The name of the VPC Interface this Source is configured with.
        :param builtins.str whitelist_cidr: The range of IP addresses that should be allowed to contribute content to your source. These IP addresses should be in the form of a Classless Inter-Domain Routing (CIDR) block; for example, 10.0.0.0/16.
        """
        if decryption is not None:
            pulumi.set(__self__, "decryption", decryption)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if entitlement_arn is not None:
            pulumi.set(__self__, "entitlement_arn", entitlement_arn)
        if gateway_bridge_source is not None:
            pulumi.set(__self__, "gateway_bridge_source", gateway_bridge_source)
        if ingest_ip is not None:
            pulumi.set(__self__, "ingest_ip", ingest_ip)
        if ingest_port is not None:
            pulumi.set(__self__, "ingest_port", ingest_port)
        if max_bitrate is not None:
            pulumi.set(__self__, "max_bitrate", max_bitrate)
        if max_latency is not None:
            pulumi.set(__self__, "max_latency", max_latency)
        if max_sync_buffer is not None:
            pulumi.set(__self__, "max_sync_buffer", max_sync_buffer)
        if media_stream_source_configurations is not None:
            pulumi.set(__self__, "media_stream_source_configurations", media_stream_source_configurations)
        if min_latency is not None:
            pulumi.set(__self__, "min_latency", min_latency)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if protocol is not None:
            pulumi.set(__self__, "protocol", protocol)
        if sender_control_port is not None:
            pulumi.set(__self__, "sender_control_port", sender_control_port)
        if sender_ip_address is not None:
            pulumi.set(__self__, "sender_ip_address", sender_ip_address)
        if source_arn is not None:
            pulumi.set(__self__, "source_arn", source_arn)
        if source_ingest_port is not None:
            pulumi.set(__self__, "source_ingest_port", source_ingest_port)
        if source_listener_address is not None:
            pulumi.set(__self__, "source_listener_address", source_listener_address)
        if source_listener_port is not None:
            pulumi.set(__self__, "source_listener_port", source_listener_port)
        if stream_id is not None:
            pulumi.set(__self__, "stream_id", stream_id)
        if vpc_interface_name is not None:
            pulumi.set(__self__, "vpc_interface_name", vpc_interface_name)
        if whitelist_cidr is not None:
            pulumi.set(__self__, "whitelist_cidr", whitelist_cidr)

    @property
    @pulumi.getter
    def decryption(self) -> Optional['outputs.FlowEncryption']:
        """
        The type of decryption that is used on the content ingested from this source.
        """
        return pulumi.get(self, "decryption")

    @property
    @pulumi.getter
    def description(self) -> Optional[builtins.str]:
        """
        A description for the source. This value is not used or seen outside of the current AWS Elemental MediaConnect account.
        """
        return pulumi.get(self, "description")

    @property
    @pulumi.getter(name="entitlementArn")
    def entitlement_arn(self) -> Optional[builtins.str]:
        """
        The ARN of the entitlement that allows you to subscribe to content that comes from another AWS account. The entitlement is set by the content originator and the ARN is generated as part of the originator's flow.
        """
        return pulumi.get(self, "entitlement_arn")

    @property
    @pulumi.getter(name="gatewayBridgeSource")
    def gateway_bridge_source(self) -> Optional['outputs.FlowGatewayBridgeSource']:
        """
        The source configuration for cloud flows receiving a stream from a bridge.
        """
        return pulumi.get(self, "gateway_bridge_source")

    @property
    @pulumi.getter(name="ingestIp")
    def ingest_ip(self) -> Optional[builtins.str]:
        """
        The IP address that the flow will be listening on for incoming content.
        """
        return pulumi.get(self, "ingest_ip")

    @property
    @pulumi.getter(name="ingestPort")
    def ingest_port(self) -> Optional[builtins.int]:
        """
        The port that the flow will be listening on for incoming content.
        """
        return pulumi.get(self, "ingest_port")

    @property
    @pulumi.getter(name="maxBitrate")
    def max_bitrate(self) -> Optional[builtins.int]:
        """
        The smoothing max bitrate for RIST, RTP, and RTP-FEC streams.
        """
        return pulumi.get(self, "max_bitrate")

    @property
    @pulumi.getter(name="maxLatency")
    def max_latency(self) -> Optional[builtins.int]:
        """
        The maximum latency in milliseconds. This parameter applies only to RIST-based and Zixi-based streams.
        """
        return pulumi.get(self, "max_latency")

    @property
    @pulumi.getter(name="maxSyncBuffer")
    def max_sync_buffer(self) -> Optional[builtins.int]:
        """
        The size of the buffer (in milliseconds) to use to sync incoming source data.
        """
        return pulumi.get(self, "max_sync_buffer")

    @property
    @pulumi.getter(name="mediaStreamSourceConfigurations")
    def media_stream_source_configurations(self) -> Optional[Sequence['outputs.FlowMediaStreamSourceConfiguration']]:
        """
        The media stream that is associated with the source, and the parameters for that association.
        """
        return pulumi.get(self, "media_stream_source_configurations")

    @property
    @pulumi.getter(name="minLatency")
    def min_latency(self) -> Optional[builtins.int]:
        """
        The minimum latency in milliseconds.
        """
        return pulumi.get(self, "min_latency")

    @property
    @pulumi.getter
    def name(self) -> Optional[builtins.str]:
        """
        The name of the source.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def protocol(self) -> Optional['FlowSourceProtocol']:
        """
        The protocol that is used by the source.
        """
        return pulumi.get(self, "protocol")

    @property
    @pulumi.getter(name="senderControlPort")
    def sender_control_port(self) -> Optional[builtins.int]:
        """
        The port that the flow uses to send outbound requests to initiate connection with the sender for fujitsu-qos protocol.
        """
        return pulumi.get(self, "sender_control_port")

    @property
    @pulumi.getter(name="senderIpAddress")
    def sender_ip_address(self) -> Optional[builtins.str]:
        """
        The IP address that the flow communicates with to initiate connection with the sender for fujitsu-qos protocol.
        """
        return pulumi.get(self, "sender_ip_address")

    @property
    @pulumi.getter(name="sourceArn")
    def source_arn(self) -> Optional[builtins.str]:
        """
        The ARN of the source.
        """
        return pulumi.get(self, "source_arn")

    @property
    @pulumi.getter(name="sourceIngestPort")
    def source_ingest_port(self) -> Optional[builtins.str]:
        """
        The port that the flow will be listening on for incoming content.(ReadOnly)
        """
        return pulumi.get(self, "source_ingest_port")

    @property
    @pulumi.getter(name="sourceListenerAddress")
    def source_listener_address(self) -> Optional[builtins.str]:
        """
        Source IP or domain name for SRT-caller protocol.
        """
        return pulumi.get(self, "source_listener_address")

    @property
    @pulumi.getter(name="sourceListenerPort")
    def source_listener_port(self) -> Optional[builtins.int]:
        """
        Source port for SRT-caller protocol.
        """
        return pulumi.get(self, "source_listener_port")

    @property
    @pulumi.getter(name="streamId")
    def stream_id(self) -> Optional[builtins.str]:
        """
        The stream ID that you want to use for this transport. This parameter applies only to Zixi-based streams.
        """
        return pulumi.get(self, "stream_id")

    @property
    @pulumi.getter(name="vpcInterfaceName")
    def vpc_interface_name(self) -> Optional[builtins.str]:
        """
        The name of the VPC Interface this Source is configured with.
        """
        return pulumi.get(self, "vpc_interface_name")

    @property
    @pulumi.getter(name="whitelistCidr")
    def whitelist_cidr(self) -> Optional[builtins.str]:
        """
        The range of IP addresses that should be allowed to contribute content to your source. These IP addresses should be in the form of a Classless Inter-Domain Routing (CIDR) block; for example, 10.0.0.0/16.
        """
        return pulumi.get(self, "whitelist_cidr")


@pulumi.output_type
class FlowSourceEncryption(dict):
    """
    Information about the encryption of the flow.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "roleArn":
            suggest = "role_arn"
        elif key == "constantInitializationVector":
            suggest = "constant_initialization_vector"
        elif key == "deviceId":
            suggest = "device_id"
        elif key == "keyType":
            suggest = "key_type"
        elif key == "resourceId":
            suggest = "resource_id"
        elif key == "secretArn":
            suggest = "secret_arn"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in FlowSourceEncryption. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        FlowSourceEncryption.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        FlowSourceEncryption.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 role_arn: builtins.str,
                 algorithm: Optional['FlowSourceEncryptionAlgorithm'] = None,
                 constant_initialization_vector: Optional[builtins.str] = None,
                 device_id: Optional[builtins.str] = None,
                 key_type: Optional['FlowSourceEncryptionKeyType'] = None,
                 region: Optional[builtins.str] = None,
                 resource_id: Optional[builtins.str] = None,
                 secret_arn: Optional[builtins.str] = None,
                 url: Optional[builtins.str] = None):
        """
        Information about the encryption of the flow.
        :param builtins.str role_arn: The ARN of the role that you created during setup (when you set up AWS Elemental MediaConnect as a trusted entity).
        :param 'FlowSourceEncryptionAlgorithm' algorithm: The type of algorithm that is used for the encryption (such as aes128, aes192, or aes256).
        :param builtins.str constant_initialization_vector: A 128-bit, 16-byte hex value represented by a 32-character string, to be used with the key for encrypting content. This parameter is not valid for static key encryption.
        :param builtins.str device_id: The value of one of the devices that you configured with your digital rights management (DRM) platform key provider. This parameter is required for SPEKE encryption and is not valid for static key encryption.
        :param 'FlowSourceEncryptionKeyType' key_type: The type of key that is used for the encryption. If no keyType is provided, the service will use the default setting (static-key).
        :param builtins.str region: The AWS Region that the API Gateway proxy endpoint was created in. This parameter is required for SPEKE encryption and is not valid for static key encryption.
        :param builtins.str resource_id: An identifier for the content. The service sends this value to the key server to identify the current endpoint. The resource ID is also known as the content ID. This parameter is required for SPEKE encryption and is not valid for static key encryption.
        :param builtins.str secret_arn:  The ARN of the secret that you created in AWS Secrets Manager to store the encryption key. This parameter is required for static key encryption and is not valid for SPEKE encryption.
        :param builtins.str url: The URL from the API Gateway proxy that you set up to talk to your key server. This parameter is required for SPEKE encryption and is not valid for static key encryption.
        """
        pulumi.set(__self__, "role_arn", role_arn)
        if algorithm is not None:
            pulumi.set(__self__, "algorithm", algorithm)
        if constant_initialization_vector is not None:
            pulumi.set(__self__, "constant_initialization_vector", constant_initialization_vector)
        if device_id is not None:
            pulumi.set(__self__, "device_id", device_id)
        if key_type is not None:
            pulumi.set(__self__, "key_type", key_type)
        if region is not None:
            pulumi.set(__self__, "region", region)
        if resource_id is not None:
            pulumi.set(__self__, "resource_id", resource_id)
        if secret_arn is not None:
            pulumi.set(__self__, "secret_arn", secret_arn)
        if url is not None:
            pulumi.set(__self__, "url", url)

    @property
    @pulumi.getter(name="roleArn")
    def role_arn(self) -> builtins.str:
        """
        The ARN of the role that you created during setup (when you set up AWS Elemental MediaConnect as a trusted entity).
        """
        return pulumi.get(self, "role_arn")

    @property
    @pulumi.getter
    def algorithm(self) -> Optional['FlowSourceEncryptionAlgorithm']:
        """
        The type of algorithm that is used for the encryption (such as aes128, aes192, or aes256).
        """
        return pulumi.get(self, "algorithm")

    @property
    @pulumi.getter(name="constantInitializationVector")
    def constant_initialization_vector(self) -> Optional[builtins.str]:
        """
        A 128-bit, 16-byte hex value represented by a 32-character string, to be used with the key for encrypting content. This parameter is not valid for static key encryption.
        """
        return pulumi.get(self, "constant_initialization_vector")

    @property
    @pulumi.getter(name="deviceId")
    def device_id(self) -> Optional[builtins.str]:
        """
        The value of one of the devices that you configured with your digital rights management (DRM) platform key provider. This parameter is required for SPEKE encryption and is not valid for static key encryption.
        """
        return pulumi.get(self, "device_id")

    @property
    @pulumi.getter(name="keyType")
    def key_type(self) -> Optional['FlowSourceEncryptionKeyType']:
        """
        The type of key that is used for the encryption. If no keyType is provided, the service will use the default setting (static-key).
        """
        return pulumi.get(self, "key_type")

    @property
    @pulumi.getter
    def region(self) -> Optional[builtins.str]:
        """
        The AWS Region that the API Gateway proxy endpoint was created in. This parameter is required for SPEKE encryption and is not valid for static key encryption.
        """
        return pulumi.get(self, "region")

    @property
    @pulumi.getter(name="resourceId")
    def resource_id(self) -> Optional[builtins.str]:
        """
        An identifier for the content. The service sends this value to the key server to identify the current endpoint. The resource ID is also known as the content ID. This parameter is required for SPEKE encryption and is not valid for static key encryption.
        """
        return pulumi.get(self, "resource_id")

    @property
    @pulumi.getter(name="secretArn")
    def secret_arn(self) -> Optional[builtins.str]:
        """
         The ARN of the secret that you created in AWS Secrets Manager to store the encryption key. This parameter is required for static key encryption and is not valid for SPEKE encryption.
        """
        return pulumi.get(self, "secret_arn")

    @property
    @pulumi.getter
    def url(self) -> Optional[builtins.str]:
        """
        The URL from the API Gateway proxy that you set up to talk to your key server. This parameter is required for SPEKE encryption and is not valid for static key encryption.
        """
        return pulumi.get(self, "url")


@pulumi.output_type
class FlowSourceGatewayBridgeSource(dict):
    """
    The source configuration for cloud flows receiving a stream from a bridge.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "bridgeArn":
            suggest = "bridge_arn"
        elif key == "vpcInterfaceAttachment":
            suggest = "vpc_interface_attachment"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in FlowSourceGatewayBridgeSource. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        FlowSourceGatewayBridgeSource.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        FlowSourceGatewayBridgeSource.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 bridge_arn: builtins.str,
                 vpc_interface_attachment: Optional['outputs.FlowSourceVpcInterfaceAttachment'] = None):
        """
        The source configuration for cloud flows receiving a stream from a bridge.
        :param builtins.str bridge_arn: The ARN of the bridge feeding this flow.
        :param 'FlowSourceVpcInterfaceAttachment' vpc_interface_attachment: The name of the VPC interface attachment to use for this bridge source.
        """
        pulumi.set(__self__, "bridge_arn", bridge_arn)
        if vpc_interface_attachment is not None:
            pulumi.set(__self__, "vpc_interface_attachment", vpc_interface_attachment)

    @property
    @pulumi.getter(name="bridgeArn")
    def bridge_arn(self) -> builtins.str:
        """
        The ARN of the bridge feeding this flow.
        """
        return pulumi.get(self, "bridge_arn")

    @property
    @pulumi.getter(name="vpcInterfaceAttachment")
    def vpc_interface_attachment(self) -> Optional['outputs.FlowSourceVpcInterfaceAttachment']:
        """
        The name of the VPC interface attachment to use for this bridge source.
        """
        return pulumi.get(self, "vpc_interface_attachment")


@pulumi.output_type
class FlowSourceMonitoringConfig(dict):
    """
    The settings for source monitoring.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "audioMonitoringSettings":
            suggest = "audio_monitoring_settings"
        elif key == "contentQualityAnalysisState":
            suggest = "content_quality_analysis_state"
        elif key == "thumbnailState":
            suggest = "thumbnail_state"
        elif key == "videoMonitoringSettings":
            suggest = "video_monitoring_settings"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in FlowSourceMonitoringConfig. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        FlowSourceMonitoringConfig.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        FlowSourceMonitoringConfig.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 audio_monitoring_settings: Optional[Sequence['outputs.FlowAudioMonitoringSetting']] = None,
                 content_quality_analysis_state: Optional['FlowSourceMonitoringConfigContentQualityAnalysisState'] = None,
                 thumbnail_state: Optional['FlowSourceMonitoringConfigThumbnailState'] = None,
                 video_monitoring_settings: Optional[Sequence['outputs.FlowVideoMonitoringSetting']] = None):
        """
        The settings for source monitoring.
        :param Sequence['FlowAudioMonitoringSetting'] audio_monitoring_settings: Contains the settings for audio stream metrics monitoring.
        :param 'FlowSourceMonitoringConfigContentQualityAnalysisState' content_quality_analysis_state: Indicates whether content quality analysis is enabled or disabled.
        :param 'FlowSourceMonitoringConfigThumbnailState' thumbnail_state: The state of thumbnail monitoring.
        :param Sequence['FlowVideoMonitoringSetting'] video_monitoring_settings: Contains the settings for video stream metrics monitoring.
        """
        if audio_monitoring_settings is not None:
            pulumi.set(__self__, "audio_monitoring_settings", audio_monitoring_settings)
        if content_quality_analysis_state is not None:
            pulumi.set(__self__, "content_quality_analysis_state", content_quality_analysis_state)
        if thumbnail_state is not None:
            pulumi.set(__self__, "thumbnail_state", thumbnail_state)
        if video_monitoring_settings is not None:
            pulumi.set(__self__, "video_monitoring_settings", video_monitoring_settings)

    @property
    @pulumi.getter(name="audioMonitoringSettings")
    def audio_monitoring_settings(self) -> Optional[Sequence['outputs.FlowAudioMonitoringSetting']]:
        """
        Contains the settings for audio stream metrics monitoring.
        """
        return pulumi.get(self, "audio_monitoring_settings")

    @property
    @pulumi.getter(name="contentQualityAnalysisState")
    def content_quality_analysis_state(self) -> Optional['FlowSourceMonitoringConfigContentQualityAnalysisState']:
        """
        Indicates whether content quality analysis is enabled or disabled.
        """
        return pulumi.get(self, "content_quality_analysis_state")

    @property
    @pulumi.getter(name="thumbnailState")
    def thumbnail_state(self) -> Optional['FlowSourceMonitoringConfigThumbnailState']:
        """
        The state of thumbnail monitoring.
        """
        return pulumi.get(self, "thumbnail_state")

    @property
    @pulumi.getter(name="videoMonitoringSettings")
    def video_monitoring_settings(self) -> Optional[Sequence['outputs.FlowVideoMonitoringSetting']]:
        """
        Contains the settings for video stream metrics monitoring.
        """
        return pulumi.get(self, "video_monitoring_settings")


@pulumi.output_type
class FlowSourceVpcInterfaceAttachment(dict):
    """
    The settings for attaching a VPC interface to an resource.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "vpcInterfaceName":
            suggest = "vpc_interface_name"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in FlowSourceVpcInterfaceAttachment. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        FlowSourceVpcInterfaceAttachment.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        FlowSourceVpcInterfaceAttachment.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 vpc_interface_name: Optional[builtins.str] = None):
        """
        The settings for attaching a VPC interface to an resource.
        :param builtins.str vpc_interface_name: The name of the VPC interface to use for this resource.
        """
        if vpc_interface_name is not None:
            pulumi.set(__self__, "vpc_interface_name", vpc_interface_name)

    @property
    @pulumi.getter(name="vpcInterfaceName")
    def vpc_interface_name(self) -> Optional[builtins.str]:
        """
        The name of the VPC interface to use for this resource.
        """
        return pulumi.get(self, "vpc_interface_name")


@pulumi.output_type
class FlowVideoMonitoringSetting(dict):
    """
    Specifies the configuration for video stream metrics monitoring.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "blackFrames":
            suggest = "black_frames"
        elif key == "frozenFrames":
            suggest = "frozen_frames"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in FlowVideoMonitoringSetting. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        FlowVideoMonitoringSetting.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        FlowVideoMonitoringSetting.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 black_frames: Optional['outputs.FlowBlackFrames'] = None,
                 frozen_frames: Optional['outputs.FlowFrozenFrames'] = None):
        """
        Specifies the configuration for video stream metrics monitoring.
        :param 'FlowBlackFrames' black_frames: Detects video frames that are black.
        :param 'FlowFrozenFrames' frozen_frames: Detects video frames that have not changed.
        """
        if black_frames is not None:
            pulumi.set(__self__, "black_frames", black_frames)
        if frozen_frames is not None:
            pulumi.set(__self__, "frozen_frames", frozen_frames)

    @property
    @pulumi.getter(name="blackFrames")
    def black_frames(self) -> Optional['outputs.FlowBlackFrames']:
        """
        Detects video frames that are black.
        """
        return pulumi.get(self, "black_frames")

    @property
    @pulumi.getter(name="frozenFrames")
    def frozen_frames(self) -> Optional['outputs.FlowFrozenFrames']:
        """
        Detects video frames that have not changed.
        """
        return pulumi.get(self, "frozen_frames")


@pulumi.output_type
class FlowVpcInterface(dict):
    """
    The details of a VPC interface.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "roleArn":
            suggest = "role_arn"
        elif key == "securityGroupIds":
            suggest = "security_group_ids"
        elif key == "subnetId":
            suggest = "subnet_id"
        elif key == "networkInterfaceIds":
            suggest = "network_interface_ids"
        elif key == "networkInterfaceType":
            suggest = "network_interface_type"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in FlowVpcInterface. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        FlowVpcInterface.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        FlowVpcInterface.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 name: builtins.str,
                 role_arn: builtins.str,
                 security_group_ids: Sequence[builtins.str],
                 subnet_id: builtins.str,
                 network_interface_ids: Optional[Sequence[builtins.str]] = None,
                 network_interface_type: Optional['FlowVpcInterfaceNetworkInterfaceType'] = None):
        """
        The details of a VPC interface.
        :param builtins.str name: Immutable and has to be a unique against other VpcInterfaces in this Flow.
        :param builtins.str role_arn: Role Arn MediaConnect can assume to create ENIs in customer's account.
        :param Sequence[builtins.str] security_group_ids: Security Group IDs to be used on ENI.
        :param builtins.str subnet_id: Subnet must be in the AZ of the Flow
        :param Sequence[builtins.str] network_interface_ids: IDs of the network interfaces created in customer's account by MediaConnect.
        :param 'FlowVpcInterfaceNetworkInterfaceType' network_interface_type: The type of network adapter that you want MediaConnect to use on this interface. If you don't set this value, it defaults to ENA.
        """
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "role_arn", role_arn)
        pulumi.set(__self__, "security_group_ids", security_group_ids)
        pulumi.set(__self__, "subnet_id", subnet_id)
        if network_interface_ids is not None:
            pulumi.set(__self__, "network_interface_ids", network_interface_ids)
        if network_interface_type is not None:
            pulumi.set(__self__, "network_interface_type", network_interface_type)

    @property
    @pulumi.getter
    def name(self) -> builtins.str:
        """
        Immutable and has to be a unique against other VpcInterfaces in this Flow.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="roleArn")
    def role_arn(self) -> builtins.str:
        """
        Role Arn MediaConnect can assume to create ENIs in customer's account.
        """
        return pulumi.get(self, "role_arn")

    @property
    @pulumi.getter(name="securityGroupIds")
    def security_group_ids(self) -> Sequence[builtins.str]:
        """
        Security Group IDs to be used on ENI.
        """
        return pulumi.get(self, "security_group_ids")

    @property
    @pulumi.getter(name="subnetId")
    def subnet_id(self) -> builtins.str:
        """
        Subnet must be in the AZ of the Flow
        """
        return pulumi.get(self, "subnet_id")

    @property
    @pulumi.getter(name="networkInterfaceIds")
    def network_interface_ids(self) -> Optional[Sequence[builtins.str]]:
        """
        IDs of the network interfaces created in customer's account by MediaConnect.
        """
        return pulumi.get(self, "network_interface_ids")

    @property
    @pulumi.getter(name="networkInterfaceType")
    def network_interface_type(self) -> Optional['FlowVpcInterfaceNetworkInterfaceType']:
        """
        The type of network adapter that you want MediaConnect to use on this interface. If you don't set this value, it defaults to ENA.
        """
        return pulumi.get(self, "network_interface_type")


@pulumi.output_type
class FlowVpcInterfaceAttachment(dict):
    """
    The settings for attaching a VPC interface to an resource.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "vpcInterfaceName":
            suggest = "vpc_interface_name"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in FlowVpcInterfaceAttachment. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        FlowVpcInterfaceAttachment.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        FlowVpcInterfaceAttachment.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 vpc_interface_name: Optional[builtins.str] = None):
        """
        The settings for attaching a VPC interface to an resource.
        :param builtins.str vpc_interface_name: The name of the VPC interface to use for this resource.
        """
        if vpc_interface_name is not None:
            pulumi.set(__self__, "vpc_interface_name", vpc_interface_name)

    @property
    @pulumi.getter(name="vpcInterfaceName")
    def vpc_interface_name(self) -> Optional[builtins.str]:
        """
        The name of the VPC interface to use for this resource.
        """
        return pulumi.get(self, "vpc_interface_name")


@pulumi.output_type
class GatewayNetwork(dict):
    """
    The network settings for a gateway.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "cidrBlock":
            suggest = "cidr_block"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in GatewayNetwork. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        GatewayNetwork.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        GatewayNetwork.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 cidr_block: builtins.str,
                 name: builtins.str):
        """
        The network settings for a gateway.
        :param builtins.str cidr_block: A unique IP address range to use for this network. These IP addresses should be in the form of a Classless Inter-Domain Routing (CIDR) block; for example, 10.0.0.0/16.
        :param builtins.str name: The name of the network. This name is used to reference the network and must be unique among networks in this gateway.
        """
        pulumi.set(__self__, "cidr_block", cidr_block)
        pulumi.set(__self__, "name", name)

    @property
    @pulumi.getter(name="cidrBlock")
    def cidr_block(self) -> builtins.str:
        """
        A unique IP address range to use for this network. These IP addresses should be in the form of a Classless Inter-Domain Routing (CIDR) block; for example, 10.0.0.0/16.
        """
        return pulumi.get(self, "cidr_block")

    @property
    @pulumi.getter
    def name(self) -> builtins.str:
        """
        The name of the network. This name is used to reference the network and must be unique among networks in this gateway.
        """
        return pulumi.get(self, "name")


