# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities

__all__ = [
    'GetDeploymentResult',
    'AwaitableGetDeploymentResult',
    'get_deployment',
    'get_deployment_output',
]

@pulumi.output_type
class GetDeploymentResult:
    def __init__(__self__, application_version=None, deployment_id=None, status=None):
        if application_version and not isinstance(application_version, int):
            raise TypeError("Expected argument 'application_version' to be a int")
        pulumi.set(__self__, "application_version", application_version)
        if deployment_id and not isinstance(deployment_id, str):
            raise TypeError("Expected argument 'deployment_id' to be a str")
        pulumi.set(__self__, "deployment_id", deployment_id)
        if status and not isinstance(status, str):
            raise TypeError("Expected argument 'status' to be a str")
        pulumi.set(__self__, "status", status)

    @property
    @pulumi.getter(name="applicationVersion")
    def application_version(self) -> Optional[builtins.int]:
        """
        The version number of the application to deploy
        """
        return pulumi.get(self, "application_version")

    @property
    @pulumi.getter(name="deploymentId")
    def deployment_id(self) -> Optional[builtins.str]:
        """
        The deployment ID.
        """
        return pulumi.get(self, "deployment_id")

    @property
    @pulumi.getter
    def status(self) -> Optional[builtins.str]:
        """
        The status of the deployment.
        """
        return pulumi.get(self, "status")


class AwaitableGetDeploymentResult(GetDeploymentResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetDeploymentResult(
            application_version=self.application_version,
            deployment_id=self.deployment_id,
            status=self.status)


def get_deployment(application_id: Optional[builtins.str] = None,
                   opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetDeploymentResult:
    """
    Represents a deployment resource of an AWS Mainframe Modernization (M2) application to a specified environment


    :param builtins.str application_id: The application ID.
    """
    __args__ = dict()
    __args__['applicationId'] = application_id
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('aws-native:m2:getDeployment', __args__, opts=opts, typ=GetDeploymentResult).value

    return AwaitableGetDeploymentResult(
        application_version=pulumi.get(__ret__, 'application_version'),
        deployment_id=pulumi.get(__ret__, 'deployment_id'),
        status=pulumi.get(__ret__, 'status'))
def get_deployment_output(application_id: Optional[pulumi.Input[builtins.str]] = None,
                          opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetDeploymentResult]:
    """
    Represents a deployment resource of an AWS Mainframe Modernization (M2) application to a specified environment


    :param builtins.str application_id: The application ID.
    """
    __args__ = dict()
    __args__['applicationId'] = application_id
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('aws-native:m2:getDeployment', __args__, opts=opts, typ=GetDeploymentResult)
    return __ret__.apply(lambda __response__: GetDeploymentResult(
        application_version=pulumi.get(__response__, 'application_version'),
        deployment_id=pulumi.get(__response__, 'deployment_id'),
        status=pulumi.get(__response__, 'status')))
