# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities

__all__ = [
    'GetApplicationResult',
    'AwaitableGetApplicationResult',
    'get_application',
    'get_application_output',
]

@pulumi.output_type
class GetApplicationResult:
    def __init__(__self__, application_arn=None, application_id=None, description=None, tags=None):
        if application_arn and not isinstance(application_arn, str):
            raise TypeError("Expected argument 'application_arn' to be a str")
        pulumi.set(__self__, "application_arn", application_arn)
        if application_id and not isinstance(application_id, str):
            raise TypeError("Expected argument 'application_id' to be a str")
        pulumi.set(__self__, "application_id", application_id)
        if description and not isinstance(description, str):
            raise TypeError("Expected argument 'description' to be a str")
        pulumi.set(__self__, "description", description)
        if tags and not isinstance(tags, dict):
            raise TypeError("Expected argument 'tags' to be a dict")
        pulumi.set(__self__, "tags", tags)

    @property
    @pulumi.getter(name="applicationArn")
    def application_arn(self) -> Optional[builtins.str]:
        """
        The Amazon Resource Name (ARN) of the application.
        """
        return pulumi.get(self, "application_arn")

    @property
    @pulumi.getter(name="applicationId")
    def application_id(self) -> Optional[builtins.str]:
        """
        The identifier of the application.
        """
        return pulumi.get(self, "application_id")

    @property
    @pulumi.getter
    def description(self) -> Optional[builtins.str]:
        """
        The description of the application.
        """
        return pulumi.get(self, "description")

    @property
    @pulumi.getter
    def tags(self) -> Optional[Mapping[str, builtins.str]]:
        """
        An array of key-value pairs to apply to this resource.

        For more information, see [Tag](https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-resource-tags.html) .
        """
        return pulumi.get(self, "tags")


class AwaitableGetApplicationResult(GetApplicationResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetApplicationResult(
            application_arn=self.application_arn,
            application_id=self.application_id,
            description=self.description,
            tags=self.tags)


def get_application(application_arn: Optional[builtins.str] = None,
                    opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetApplicationResult:
    """
    Represents an application that runs on an AWS Mainframe Modernization Environment


    :param builtins.str application_arn: The Amazon Resource Name (ARN) of the application.
    """
    __args__ = dict()
    __args__['applicationArn'] = application_arn
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('aws-native:m2:getApplication', __args__, opts=opts, typ=GetApplicationResult).value

    return AwaitableGetApplicationResult(
        application_arn=pulumi.get(__ret__, 'application_arn'),
        application_id=pulumi.get(__ret__, 'application_id'),
        description=pulumi.get(__ret__, 'description'),
        tags=pulumi.get(__ret__, 'tags'))
def get_application_output(application_arn: Optional[pulumi.Input[builtins.str]] = None,
                           opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetApplicationResult]:
    """
    Represents an application that runs on an AWS Mainframe Modernization Environment


    :param builtins.str application_arn: The Amazon Resource Name (ARN) of the application.
    """
    __args__ = dict()
    __args__['applicationArn'] = application_arn
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('aws-native:m2:getApplication', __args__, opts=opts, typ=GetApplicationResult)
    return __ret__.apply(lambda __response__: GetApplicationResult(
        application_arn=pulumi.get(__response__, 'application_arn'),
        application_id=pulumi.get(__response__, 'application_id'),
        description=pulumi.get(__response__, 'description'),
        tags=pulumi.get(__response__, 'tags')))
