# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from ._enums import *

__all__ = [
    'AlertActionArgs',
    'AlertActionArgsDict',
    'AlertLambdaConfigurationArgs',
    'AlertLambdaConfigurationArgsDict',
    'AlertSnsConfigurationArgs',
    'AlertSnsConfigurationArgsDict',
    'AnomalyDetectorAppFlowConfigArgs',
    'AnomalyDetectorAppFlowConfigArgsDict',
    'AnomalyDetectorCloudwatchConfigArgs',
    'AnomalyDetectorCloudwatchConfigArgsDict',
    'AnomalyDetectorConfigArgs',
    'AnomalyDetectorConfigArgsDict',
    'AnomalyDetectorCsvFormatDescriptorArgs',
    'AnomalyDetectorCsvFormatDescriptorArgsDict',
    'AnomalyDetectorFileFormatDescriptorArgs',
    'AnomalyDetectorFileFormatDescriptorArgsDict',
    'AnomalyDetectorJsonFormatDescriptorArgs',
    'AnomalyDetectorJsonFormatDescriptorArgsDict',
    'AnomalyDetectorMetricSetArgs',
    'AnomalyDetectorMetricSetArgsDict',
    'AnomalyDetectorMetricSourceArgs',
    'AnomalyDetectorMetricSourceArgsDict',
    'AnomalyDetectorMetricArgs',
    'AnomalyDetectorMetricArgsDict',
    'AnomalyDetectorRdsSourceConfigArgs',
    'AnomalyDetectorRdsSourceConfigArgsDict',
    'AnomalyDetectorRedshiftSourceConfigArgs',
    'AnomalyDetectorRedshiftSourceConfigArgsDict',
    'AnomalyDetectorS3SourceConfigArgs',
    'AnomalyDetectorS3SourceConfigArgsDict',
    'AnomalyDetectorTimestampColumnArgs',
    'AnomalyDetectorTimestampColumnArgsDict',
    'AnomalyDetectorVpcConfigurationArgs',
    'AnomalyDetectorVpcConfigurationArgsDict',
]

MYPY = False

if not MYPY:
    class AlertActionArgsDict(TypedDict):
        lambda_configuration: NotRequired[pulumi.Input['AlertLambdaConfigurationArgsDict']]
        """
        A configuration for an AWS Lambda channel.
        """
        sns_configuration: NotRequired[pulumi.Input['AlertSnsConfigurationArgsDict']]
        """
        A configuration for an Amazon SNS channel.
        """
elif False:
    AlertActionArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class AlertActionArgs:
    def __init__(__self__, *,
                 lambda_configuration: Optional[pulumi.Input['AlertLambdaConfigurationArgs']] = None,
                 sns_configuration: Optional[pulumi.Input['AlertSnsConfigurationArgs']] = None):
        """
        :param pulumi.Input['AlertLambdaConfigurationArgs'] lambda_configuration: A configuration for an AWS Lambda channel.
        :param pulumi.Input['AlertSnsConfigurationArgs'] sns_configuration: A configuration for an Amazon SNS channel.
        """
        if lambda_configuration is not None:
            pulumi.set(__self__, "lambda_configuration", lambda_configuration)
        if sns_configuration is not None:
            pulumi.set(__self__, "sns_configuration", sns_configuration)

    @property
    @pulumi.getter(name="lambdaConfiguration")
    def lambda_configuration(self) -> Optional[pulumi.Input['AlertLambdaConfigurationArgs']]:
        """
        A configuration for an AWS Lambda channel.
        """
        return pulumi.get(self, "lambda_configuration")

    @lambda_configuration.setter
    def lambda_configuration(self, value: Optional[pulumi.Input['AlertLambdaConfigurationArgs']]):
        pulumi.set(self, "lambda_configuration", value)

    @property
    @pulumi.getter(name="snsConfiguration")
    def sns_configuration(self) -> Optional[pulumi.Input['AlertSnsConfigurationArgs']]:
        """
        A configuration for an Amazon SNS channel.
        """
        return pulumi.get(self, "sns_configuration")

    @sns_configuration.setter
    def sns_configuration(self, value: Optional[pulumi.Input['AlertSnsConfigurationArgs']]):
        pulumi.set(self, "sns_configuration", value)


if not MYPY:
    class AlertLambdaConfigurationArgsDict(TypedDict):
        """
        Configuration options for a Lambda alert action.
        """
        lambda_arn: pulumi.Input[builtins.str]
        """
        ARN of a Lambda to send alert notifications to.
        """
        role_arn: pulumi.Input[builtins.str]
        """
        ARN of an IAM role that LookoutMetrics should assume to access the Lambda function.
        """
elif False:
    AlertLambdaConfigurationArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class AlertLambdaConfigurationArgs:
    def __init__(__self__, *,
                 lambda_arn: pulumi.Input[builtins.str],
                 role_arn: pulumi.Input[builtins.str]):
        """
        Configuration options for a Lambda alert action.
        :param pulumi.Input[builtins.str] lambda_arn: ARN of a Lambda to send alert notifications to.
        :param pulumi.Input[builtins.str] role_arn: ARN of an IAM role that LookoutMetrics should assume to access the Lambda function.
        """
        pulumi.set(__self__, "lambda_arn", lambda_arn)
        pulumi.set(__self__, "role_arn", role_arn)

    @property
    @pulumi.getter(name="lambdaArn")
    def lambda_arn(self) -> pulumi.Input[builtins.str]:
        """
        ARN of a Lambda to send alert notifications to.
        """
        return pulumi.get(self, "lambda_arn")

    @lambda_arn.setter
    def lambda_arn(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "lambda_arn", value)

    @property
    @pulumi.getter(name="roleArn")
    def role_arn(self) -> pulumi.Input[builtins.str]:
        """
        ARN of an IAM role that LookoutMetrics should assume to access the Lambda function.
        """
        return pulumi.get(self, "role_arn")

    @role_arn.setter
    def role_arn(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "role_arn", value)


if not MYPY:
    class AlertSnsConfigurationArgsDict(TypedDict):
        """
        Configuration options for an SNS alert action.
        """
        role_arn: pulumi.Input[builtins.str]
        """
        ARN of an IAM role that LookoutMetrics should assume to access the SNS topic.
        """
        sns_topic_arn: pulumi.Input[builtins.str]
        """
        ARN of an SNS topic to send alert notifications to.
        """
elif False:
    AlertSnsConfigurationArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class AlertSnsConfigurationArgs:
    def __init__(__self__, *,
                 role_arn: pulumi.Input[builtins.str],
                 sns_topic_arn: pulumi.Input[builtins.str]):
        """
        Configuration options for an SNS alert action.
        :param pulumi.Input[builtins.str] role_arn: ARN of an IAM role that LookoutMetrics should assume to access the SNS topic.
        :param pulumi.Input[builtins.str] sns_topic_arn: ARN of an SNS topic to send alert notifications to.
        """
        pulumi.set(__self__, "role_arn", role_arn)
        pulumi.set(__self__, "sns_topic_arn", sns_topic_arn)

    @property
    @pulumi.getter(name="roleArn")
    def role_arn(self) -> pulumi.Input[builtins.str]:
        """
        ARN of an IAM role that LookoutMetrics should assume to access the SNS topic.
        """
        return pulumi.get(self, "role_arn")

    @role_arn.setter
    def role_arn(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "role_arn", value)

    @property
    @pulumi.getter(name="snsTopicArn")
    def sns_topic_arn(self) -> pulumi.Input[builtins.str]:
        """
        ARN of an SNS topic to send alert notifications to.
        """
        return pulumi.get(self, "sns_topic_arn")

    @sns_topic_arn.setter
    def sns_topic_arn(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "sns_topic_arn", value)


if not MYPY:
    class AnomalyDetectorAppFlowConfigArgsDict(TypedDict):
        flow_name: pulumi.Input[builtins.str]
        """
        name of the flow.
        """
        role_arn: pulumi.Input[builtins.str]
        """
        An IAM role that gives Amazon Lookout for Metrics permission to access the flow.
        """
elif False:
    AnomalyDetectorAppFlowConfigArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class AnomalyDetectorAppFlowConfigArgs:
    def __init__(__self__, *,
                 flow_name: pulumi.Input[builtins.str],
                 role_arn: pulumi.Input[builtins.str]):
        """
        :param pulumi.Input[builtins.str] flow_name: name of the flow.
        :param pulumi.Input[builtins.str] role_arn: An IAM role that gives Amazon Lookout for Metrics permission to access the flow.
        """
        pulumi.set(__self__, "flow_name", flow_name)
        pulumi.set(__self__, "role_arn", role_arn)

    @property
    @pulumi.getter(name="flowName")
    def flow_name(self) -> pulumi.Input[builtins.str]:
        """
        name of the flow.
        """
        return pulumi.get(self, "flow_name")

    @flow_name.setter
    def flow_name(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "flow_name", value)

    @property
    @pulumi.getter(name="roleArn")
    def role_arn(self) -> pulumi.Input[builtins.str]:
        """
        An IAM role that gives Amazon Lookout for Metrics permission to access the flow.
        """
        return pulumi.get(self, "role_arn")

    @role_arn.setter
    def role_arn(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "role_arn", value)


if not MYPY:
    class AnomalyDetectorCloudwatchConfigArgsDict(TypedDict):
        role_arn: pulumi.Input[builtins.str]
        """
        An IAM role that gives Amazon Lookout for Metrics permission to access data in Amazon CloudWatch.
        """
elif False:
    AnomalyDetectorCloudwatchConfigArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class AnomalyDetectorCloudwatchConfigArgs:
    def __init__(__self__, *,
                 role_arn: pulumi.Input[builtins.str]):
        """
        :param pulumi.Input[builtins.str] role_arn: An IAM role that gives Amazon Lookout for Metrics permission to access data in Amazon CloudWatch.
        """
        pulumi.set(__self__, "role_arn", role_arn)

    @property
    @pulumi.getter(name="roleArn")
    def role_arn(self) -> pulumi.Input[builtins.str]:
        """
        An IAM role that gives Amazon Lookout for Metrics permission to access data in Amazon CloudWatch.
        """
        return pulumi.get(self, "role_arn")

    @role_arn.setter
    def role_arn(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "role_arn", value)


if not MYPY:
    class AnomalyDetectorConfigArgsDict(TypedDict):
        anomaly_detector_frequency: pulumi.Input['AnomalyDetectorFrequency']
        """
        Frequency of anomaly detection
        """
elif False:
    AnomalyDetectorConfigArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class AnomalyDetectorConfigArgs:
    def __init__(__self__, *,
                 anomaly_detector_frequency: pulumi.Input['AnomalyDetectorFrequency']):
        """
        :param pulumi.Input['AnomalyDetectorFrequency'] anomaly_detector_frequency: Frequency of anomaly detection
        """
        pulumi.set(__self__, "anomaly_detector_frequency", anomaly_detector_frequency)

    @property
    @pulumi.getter(name="anomalyDetectorFrequency")
    def anomaly_detector_frequency(self) -> pulumi.Input['AnomalyDetectorFrequency']:
        """
        Frequency of anomaly detection
        """
        return pulumi.get(self, "anomaly_detector_frequency")

    @anomaly_detector_frequency.setter
    def anomaly_detector_frequency(self, value: pulumi.Input['AnomalyDetectorFrequency']):
        pulumi.set(self, "anomaly_detector_frequency", value)


if not MYPY:
    class AnomalyDetectorCsvFormatDescriptorArgsDict(TypedDict):
        charset: NotRequired[pulumi.Input[builtins.str]]
        """
        The character set in which the source CSV file is written.
        """
        contains_header: NotRequired[pulumi.Input[builtins.bool]]
        """
        Whether or not the source CSV file contains a header.
        """
        delimiter: NotRequired[pulumi.Input[builtins.str]]
        """
        The character used to delimit the source CSV file.
        """
        file_compression: NotRequired[pulumi.Input['AnomalyDetectorCsvFormatDescriptorFileCompression']]
        """
        The level of compression of the source CSV file.
        """
        header_list: NotRequired[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]
        """
        A list of the source CSV file's headers, if any.
        """
        quote_symbol: NotRequired[pulumi.Input[builtins.str]]
        """
        The character used as a quote character.
        """
elif False:
    AnomalyDetectorCsvFormatDescriptorArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class AnomalyDetectorCsvFormatDescriptorArgs:
    def __init__(__self__, *,
                 charset: Optional[pulumi.Input[builtins.str]] = None,
                 contains_header: Optional[pulumi.Input[builtins.bool]] = None,
                 delimiter: Optional[pulumi.Input[builtins.str]] = None,
                 file_compression: Optional[pulumi.Input['AnomalyDetectorCsvFormatDescriptorFileCompression']] = None,
                 header_list: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
                 quote_symbol: Optional[pulumi.Input[builtins.str]] = None):
        """
        :param pulumi.Input[builtins.str] charset: The character set in which the source CSV file is written.
        :param pulumi.Input[builtins.bool] contains_header: Whether or not the source CSV file contains a header.
        :param pulumi.Input[builtins.str] delimiter: The character used to delimit the source CSV file.
        :param pulumi.Input['AnomalyDetectorCsvFormatDescriptorFileCompression'] file_compression: The level of compression of the source CSV file.
        :param pulumi.Input[Sequence[pulumi.Input[builtins.str]]] header_list: A list of the source CSV file's headers, if any.
        :param pulumi.Input[builtins.str] quote_symbol: The character used as a quote character.
        """
        if charset is not None:
            pulumi.set(__self__, "charset", charset)
        if contains_header is not None:
            pulumi.set(__self__, "contains_header", contains_header)
        if delimiter is not None:
            pulumi.set(__self__, "delimiter", delimiter)
        if file_compression is not None:
            pulumi.set(__self__, "file_compression", file_compression)
        if header_list is not None:
            pulumi.set(__self__, "header_list", header_list)
        if quote_symbol is not None:
            pulumi.set(__self__, "quote_symbol", quote_symbol)

    @property
    @pulumi.getter
    def charset(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The character set in which the source CSV file is written.
        """
        return pulumi.get(self, "charset")

    @charset.setter
    def charset(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "charset", value)

    @property
    @pulumi.getter(name="containsHeader")
    def contains_header(self) -> Optional[pulumi.Input[builtins.bool]]:
        """
        Whether or not the source CSV file contains a header.
        """
        return pulumi.get(self, "contains_header")

    @contains_header.setter
    def contains_header(self, value: Optional[pulumi.Input[builtins.bool]]):
        pulumi.set(self, "contains_header", value)

    @property
    @pulumi.getter
    def delimiter(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The character used to delimit the source CSV file.
        """
        return pulumi.get(self, "delimiter")

    @delimiter.setter
    def delimiter(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "delimiter", value)

    @property
    @pulumi.getter(name="fileCompression")
    def file_compression(self) -> Optional[pulumi.Input['AnomalyDetectorCsvFormatDescriptorFileCompression']]:
        """
        The level of compression of the source CSV file.
        """
        return pulumi.get(self, "file_compression")

    @file_compression.setter
    def file_compression(self, value: Optional[pulumi.Input['AnomalyDetectorCsvFormatDescriptorFileCompression']]):
        pulumi.set(self, "file_compression", value)

    @property
    @pulumi.getter(name="headerList")
    def header_list(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]:
        """
        A list of the source CSV file's headers, if any.
        """
        return pulumi.get(self, "header_list")

    @header_list.setter
    def header_list(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "header_list", value)

    @property
    @pulumi.getter(name="quoteSymbol")
    def quote_symbol(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The character used as a quote character.
        """
        return pulumi.get(self, "quote_symbol")

    @quote_symbol.setter
    def quote_symbol(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "quote_symbol", value)


if not MYPY:
    class AnomalyDetectorFileFormatDescriptorArgsDict(TypedDict):
        csv_format_descriptor: NotRequired[pulumi.Input['AnomalyDetectorCsvFormatDescriptorArgsDict']]
        """
        Contains information about how a source CSV data file should be analyzed.
        """
        json_format_descriptor: NotRequired[pulumi.Input['AnomalyDetectorJsonFormatDescriptorArgsDict']]
        """
        Contains information about how a source JSON data file should be analyzed.
        """
elif False:
    AnomalyDetectorFileFormatDescriptorArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class AnomalyDetectorFileFormatDescriptorArgs:
    def __init__(__self__, *,
                 csv_format_descriptor: Optional[pulumi.Input['AnomalyDetectorCsvFormatDescriptorArgs']] = None,
                 json_format_descriptor: Optional[pulumi.Input['AnomalyDetectorJsonFormatDescriptorArgs']] = None):
        """
        :param pulumi.Input['AnomalyDetectorCsvFormatDescriptorArgs'] csv_format_descriptor: Contains information about how a source CSV data file should be analyzed.
        :param pulumi.Input['AnomalyDetectorJsonFormatDescriptorArgs'] json_format_descriptor: Contains information about how a source JSON data file should be analyzed.
        """
        if csv_format_descriptor is not None:
            pulumi.set(__self__, "csv_format_descriptor", csv_format_descriptor)
        if json_format_descriptor is not None:
            pulumi.set(__self__, "json_format_descriptor", json_format_descriptor)

    @property
    @pulumi.getter(name="csvFormatDescriptor")
    def csv_format_descriptor(self) -> Optional[pulumi.Input['AnomalyDetectorCsvFormatDescriptorArgs']]:
        """
        Contains information about how a source CSV data file should be analyzed.
        """
        return pulumi.get(self, "csv_format_descriptor")

    @csv_format_descriptor.setter
    def csv_format_descriptor(self, value: Optional[pulumi.Input['AnomalyDetectorCsvFormatDescriptorArgs']]):
        pulumi.set(self, "csv_format_descriptor", value)

    @property
    @pulumi.getter(name="jsonFormatDescriptor")
    def json_format_descriptor(self) -> Optional[pulumi.Input['AnomalyDetectorJsonFormatDescriptorArgs']]:
        """
        Contains information about how a source JSON data file should be analyzed.
        """
        return pulumi.get(self, "json_format_descriptor")

    @json_format_descriptor.setter
    def json_format_descriptor(self, value: Optional[pulumi.Input['AnomalyDetectorJsonFormatDescriptorArgs']]):
        pulumi.set(self, "json_format_descriptor", value)


if not MYPY:
    class AnomalyDetectorJsonFormatDescriptorArgsDict(TypedDict):
        charset: NotRequired[pulumi.Input[builtins.str]]
        """
        The character set in which the source JSON file is written.
        """
        file_compression: NotRequired[pulumi.Input['AnomalyDetectorJsonFormatDescriptorFileCompression']]
        """
        The level of compression of the source CSV file.
        """
elif False:
    AnomalyDetectorJsonFormatDescriptorArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class AnomalyDetectorJsonFormatDescriptorArgs:
    def __init__(__self__, *,
                 charset: Optional[pulumi.Input[builtins.str]] = None,
                 file_compression: Optional[pulumi.Input['AnomalyDetectorJsonFormatDescriptorFileCompression']] = None):
        """
        :param pulumi.Input[builtins.str] charset: The character set in which the source JSON file is written.
        :param pulumi.Input['AnomalyDetectorJsonFormatDescriptorFileCompression'] file_compression: The level of compression of the source CSV file.
        """
        if charset is not None:
            pulumi.set(__self__, "charset", charset)
        if file_compression is not None:
            pulumi.set(__self__, "file_compression", file_compression)

    @property
    @pulumi.getter
    def charset(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The character set in which the source JSON file is written.
        """
        return pulumi.get(self, "charset")

    @charset.setter
    def charset(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "charset", value)

    @property
    @pulumi.getter(name="fileCompression")
    def file_compression(self) -> Optional[pulumi.Input['AnomalyDetectorJsonFormatDescriptorFileCompression']]:
        """
        The level of compression of the source CSV file.
        """
        return pulumi.get(self, "file_compression")

    @file_compression.setter
    def file_compression(self, value: Optional[pulumi.Input['AnomalyDetectorJsonFormatDescriptorFileCompression']]):
        pulumi.set(self, "file_compression", value)


if not MYPY:
    class AnomalyDetectorMetricSetArgsDict(TypedDict):
        metric_list: pulumi.Input[Sequence[pulumi.Input['AnomalyDetectorMetricArgsDict']]]
        """
        Metrics captured by this MetricSet.
        """
        metric_set_name: pulumi.Input[builtins.str]
        """
        The name of the MetricSet.
        """
        metric_source: pulumi.Input['AnomalyDetectorMetricSourceArgsDict']
        """
        Contains information about how the source data should be interpreted.
        """
        dimension_list: NotRequired[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]
        """
        Dimensions for this MetricSet.
        """
        metric_set_description: NotRequired[pulumi.Input[builtins.str]]
        """
        A description for the MetricSet.
        """
        metric_set_frequency: NotRequired[pulumi.Input['AnomalyDetectorMetricSetMetricSetFrequency']]
        """
        A frequency period to aggregate the data
        """
        offset: NotRequired[pulumi.Input[builtins.int]]
        """
        Offset, in seconds, between the frequency interval and the time at which the metrics are available.
        """
        timestamp_column: NotRequired[pulumi.Input['AnomalyDetectorTimestampColumnArgsDict']]
        """
        Contains information about the column used for tracking time in your source data.
        """
        timezone: NotRequired[pulumi.Input[builtins.str]]
        """
        The time zone in which your source data was recorded.
        """
elif False:
    AnomalyDetectorMetricSetArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class AnomalyDetectorMetricSetArgs:
    def __init__(__self__, *,
                 metric_list: pulumi.Input[Sequence[pulumi.Input['AnomalyDetectorMetricArgs']]],
                 metric_set_name: pulumi.Input[builtins.str],
                 metric_source: pulumi.Input['AnomalyDetectorMetricSourceArgs'],
                 dimension_list: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
                 metric_set_description: Optional[pulumi.Input[builtins.str]] = None,
                 metric_set_frequency: Optional[pulumi.Input['AnomalyDetectorMetricSetMetricSetFrequency']] = None,
                 offset: Optional[pulumi.Input[builtins.int]] = None,
                 timestamp_column: Optional[pulumi.Input['AnomalyDetectorTimestampColumnArgs']] = None,
                 timezone: Optional[pulumi.Input[builtins.str]] = None):
        """
        :param pulumi.Input[Sequence[pulumi.Input['AnomalyDetectorMetricArgs']]] metric_list: Metrics captured by this MetricSet.
        :param pulumi.Input[builtins.str] metric_set_name: The name of the MetricSet.
        :param pulumi.Input['AnomalyDetectorMetricSourceArgs'] metric_source: Contains information about how the source data should be interpreted.
        :param pulumi.Input[Sequence[pulumi.Input[builtins.str]]] dimension_list: Dimensions for this MetricSet.
        :param pulumi.Input[builtins.str] metric_set_description: A description for the MetricSet.
        :param pulumi.Input['AnomalyDetectorMetricSetMetricSetFrequency'] metric_set_frequency: A frequency period to aggregate the data
        :param pulumi.Input[builtins.int] offset: Offset, in seconds, between the frequency interval and the time at which the metrics are available.
        :param pulumi.Input['AnomalyDetectorTimestampColumnArgs'] timestamp_column: Contains information about the column used for tracking time in your source data.
        :param pulumi.Input[builtins.str] timezone: The time zone in which your source data was recorded.
        """
        pulumi.set(__self__, "metric_list", metric_list)
        pulumi.set(__self__, "metric_set_name", metric_set_name)
        pulumi.set(__self__, "metric_source", metric_source)
        if dimension_list is not None:
            pulumi.set(__self__, "dimension_list", dimension_list)
        if metric_set_description is not None:
            pulumi.set(__self__, "metric_set_description", metric_set_description)
        if metric_set_frequency is not None:
            pulumi.set(__self__, "metric_set_frequency", metric_set_frequency)
        if offset is not None:
            pulumi.set(__self__, "offset", offset)
        if timestamp_column is not None:
            pulumi.set(__self__, "timestamp_column", timestamp_column)
        if timezone is not None:
            pulumi.set(__self__, "timezone", timezone)

    @property
    @pulumi.getter(name="metricList")
    def metric_list(self) -> pulumi.Input[Sequence[pulumi.Input['AnomalyDetectorMetricArgs']]]:
        """
        Metrics captured by this MetricSet.
        """
        return pulumi.get(self, "metric_list")

    @metric_list.setter
    def metric_list(self, value: pulumi.Input[Sequence[pulumi.Input['AnomalyDetectorMetricArgs']]]):
        pulumi.set(self, "metric_list", value)

    @property
    @pulumi.getter(name="metricSetName")
    def metric_set_name(self) -> pulumi.Input[builtins.str]:
        """
        The name of the MetricSet.
        """
        return pulumi.get(self, "metric_set_name")

    @metric_set_name.setter
    def metric_set_name(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "metric_set_name", value)

    @property
    @pulumi.getter(name="metricSource")
    def metric_source(self) -> pulumi.Input['AnomalyDetectorMetricSourceArgs']:
        """
        Contains information about how the source data should be interpreted.
        """
        return pulumi.get(self, "metric_source")

    @metric_source.setter
    def metric_source(self, value: pulumi.Input['AnomalyDetectorMetricSourceArgs']):
        pulumi.set(self, "metric_source", value)

    @property
    @pulumi.getter(name="dimensionList")
    def dimension_list(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]:
        """
        Dimensions for this MetricSet.
        """
        return pulumi.get(self, "dimension_list")

    @dimension_list.setter
    def dimension_list(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "dimension_list", value)

    @property
    @pulumi.getter(name="metricSetDescription")
    def metric_set_description(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        A description for the MetricSet.
        """
        return pulumi.get(self, "metric_set_description")

    @metric_set_description.setter
    def metric_set_description(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "metric_set_description", value)

    @property
    @pulumi.getter(name="metricSetFrequency")
    def metric_set_frequency(self) -> Optional[pulumi.Input['AnomalyDetectorMetricSetMetricSetFrequency']]:
        """
        A frequency period to aggregate the data
        """
        return pulumi.get(self, "metric_set_frequency")

    @metric_set_frequency.setter
    def metric_set_frequency(self, value: Optional[pulumi.Input['AnomalyDetectorMetricSetMetricSetFrequency']]):
        pulumi.set(self, "metric_set_frequency", value)

    @property
    @pulumi.getter
    def offset(self) -> Optional[pulumi.Input[builtins.int]]:
        """
        Offset, in seconds, between the frequency interval and the time at which the metrics are available.
        """
        return pulumi.get(self, "offset")

    @offset.setter
    def offset(self, value: Optional[pulumi.Input[builtins.int]]):
        pulumi.set(self, "offset", value)

    @property
    @pulumi.getter(name="timestampColumn")
    def timestamp_column(self) -> Optional[pulumi.Input['AnomalyDetectorTimestampColumnArgs']]:
        """
        Contains information about the column used for tracking time in your source data.
        """
        return pulumi.get(self, "timestamp_column")

    @timestamp_column.setter
    def timestamp_column(self, value: Optional[pulumi.Input['AnomalyDetectorTimestampColumnArgs']]):
        pulumi.set(self, "timestamp_column", value)

    @property
    @pulumi.getter
    def timezone(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The time zone in which your source data was recorded.
        """
        return pulumi.get(self, "timezone")

    @timezone.setter
    def timezone(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "timezone", value)


if not MYPY:
    class AnomalyDetectorMetricSourceArgsDict(TypedDict):
        app_flow_config: NotRequired[pulumi.Input['AnomalyDetectorAppFlowConfigArgsDict']]
        """
        Details about an AppFlow datasource.
        """
        cloudwatch_config: NotRequired[pulumi.Input['AnomalyDetectorCloudwatchConfigArgsDict']]
        """
        Details about an Amazon CloudWatch monitoring datasource.
        """
        rds_source_config: NotRequired[pulumi.Input['AnomalyDetectorRdsSourceConfigArgsDict']]
        """
        Details about an Amazon Relational Database Service (RDS) datasource.
        """
        redshift_source_config: NotRequired[pulumi.Input['AnomalyDetectorRedshiftSourceConfigArgsDict']]
        """
        Details about an Amazon Redshift database datasource.
        """
        s3_source_config: NotRequired[pulumi.Input['AnomalyDetectorS3SourceConfigArgsDict']]
        """
        Contains information about the configuration of the S3 bucket that contains source files.
        """
elif False:
    AnomalyDetectorMetricSourceArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class AnomalyDetectorMetricSourceArgs:
    def __init__(__self__, *,
                 app_flow_config: Optional[pulumi.Input['AnomalyDetectorAppFlowConfigArgs']] = None,
                 cloudwatch_config: Optional[pulumi.Input['AnomalyDetectorCloudwatchConfigArgs']] = None,
                 rds_source_config: Optional[pulumi.Input['AnomalyDetectorRdsSourceConfigArgs']] = None,
                 redshift_source_config: Optional[pulumi.Input['AnomalyDetectorRedshiftSourceConfigArgs']] = None,
                 s3_source_config: Optional[pulumi.Input['AnomalyDetectorS3SourceConfigArgs']] = None):
        """
        :param pulumi.Input['AnomalyDetectorAppFlowConfigArgs'] app_flow_config: Details about an AppFlow datasource.
        :param pulumi.Input['AnomalyDetectorCloudwatchConfigArgs'] cloudwatch_config: Details about an Amazon CloudWatch monitoring datasource.
        :param pulumi.Input['AnomalyDetectorRdsSourceConfigArgs'] rds_source_config: Details about an Amazon Relational Database Service (RDS) datasource.
        :param pulumi.Input['AnomalyDetectorRedshiftSourceConfigArgs'] redshift_source_config: Details about an Amazon Redshift database datasource.
        :param pulumi.Input['AnomalyDetectorS3SourceConfigArgs'] s3_source_config: Contains information about the configuration of the S3 bucket that contains source files.
        """
        if app_flow_config is not None:
            pulumi.set(__self__, "app_flow_config", app_flow_config)
        if cloudwatch_config is not None:
            pulumi.set(__self__, "cloudwatch_config", cloudwatch_config)
        if rds_source_config is not None:
            pulumi.set(__self__, "rds_source_config", rds_source_config)
        if redshift_source_config is not None:
            pulumi.set(__self__, "redshift_source_config", redshift_source_config)
        if s3_source_config is not None:
            pulumi.set(__self__, "s3_source_config", s3_source_config)

    @property
    @pulumi.getter(name="appFlowConfig")
    def app_flow_config(self) -> Optional[pulumi.Input['AnomalyDetectorAppFlowConfigArgs']]:
        """
        Details about an AppFlow datasource.
        """
        return pulumi.get(self, "app_flow_config")

    @app_flow_config.setter
    def app_flow_config(self, value: Optional[pulumi.Input['AnomalyDetectorAppFlowConfigArgs']]):
        pulumi.set(self, "app_flow_config", value)

    @property
    @pulumi.getter(name="cloudwatchConfig")
    def cloudwatch_config(self) -> Optional[pulumi.Input['AnomalyDetectorCloudwatchConfigArgs']]:
        """
        Details about an Amazon CloudWatch monitoring datasource.
        """
        return pulumi.get(self, "cloudwatch_config")

    @cloudwatch_config.setter
    def cloudwatch_config(self, value: Optional[pulumi.Input['AnomalyDetectorCloudwatchConfigArgs']]):
        pulumi.set(self, "cloudwatch_config", value)

    @property
    @pulumi.getter(name="rdsSourceConfig")
    def rds_source_config(self) -> Optional[pulumi.Input['AnomalyDetectorRdsSourceConfigArgs']]:
        """
        Details about an Amazon Relational Database Service (RDS) datasource.
        """
        return pulumi.get(self, "rds_source_config")

    @rds_source_config.setter
    def rds_source_config(self, value: Optional[pulumi.Input['AnomalyDetectorRdsSourceConfigArgs']]):
        pulumi.set(self, "rds_source_config", value)

    @property
    @pulumi.getter(name="redshiftSourceConfig")
    def redshift_source_config(self) -> Optional[pulumi.Input['AnomalyDetectorRedshiftSourceConfigArgs']]:
        """
        Details about an Amazon Redshift database datasource.
        """
        return pulumi.get(self, "redshift_source_config")

    @redshift_source_config.setter
    def redshift_source_config(self, value: Optional[pulumi.Input['AnomalyDetectorRedshiftSourceConfigArgs']]):
        pulumi.set(self, "redshift_source_config", value)

    @property
    @pulumi.getter(name="s3SourceConfig")
    def s3_source_config(self) -> Optional[pulumi.Input['AnomalyDetectorS3SourceConfigArgs']]:
        """
        Contains information about the configuration of the S3 bucket that contains source files.
        """
        return pulumi.get(self, "s3_source_config")

    @s3_source_config.setter
    def s3_source_config(self, value: Optional[pulumi.Input['AnomalyDetectorS3SourceConfigArgs']]):
        pulumi.set(self, "s3_source_config", value)


if not MYPY:
    class AnomalyDetectorMetricArgsDict(TypedDict):
        aggregation_function: pulumi.Input['AnomalyDetectorMetricAggregationFunction']
        """
        Operator used to aggregate metric values
        """
        metric_name: pulumi.Input[builtins.str]
        """
        The name of the metric.
        """
        namespace: NotRequired[pulumi.Input[builtins.str]]
        """
        The namespace for the metric.
        """
elif False:
    AnomalyDetectorMetricArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class AnomalyDetectorMetricArgs:
    def __init__(__self__, *,
                 aggregation_function: pulumi.Input['AnomalyDetectorMetricAggregationFunction'],
                 metric_name: pulumi.Input[builtins.str],
                 namespace: Optional[pulumi.Input[builtins.str]] = None):
        """
        :param pulumi.Input['AnomalyDetectorMetricAggregationFunction'] aggregation_function: Operator used to aggregate metric values
        :param pulumi.Input[builtins.str] metric_name: The name of the metric.
        :param pulumi.Input[builtins.str] namespace: The namespace for the metric.
        """
        pulumi.set(__self__, "aggregation_function", aggregation_function)
        pulumi.set(__self__, "metric_name", metric_name)
        if namespace is not None:
            pulumi.set(__self__, "namespace", namespace)

    @property
    @pulumi.getter(name="aggregationFunction")
    def aggregation_function(self) -> pulumi.Input['AnomalyDetectorMetricAggregationFunction']:
        """
        Operator used to aggregate metric values
        """
        return pulumi.get(self, "aggregation_function")

    @aggregation_function.setter
    def aggregation_function(self, value: pulumi.Input['AnomalyDetectorMetricAggregationFunction']):
        pulumi.set(self, "aggregation_function", value)

    @property
    @pulumi.getter(name="metricName")
    def metric_name(self) -> pulumi.Input[builtins.str]:
        """
        The name of the metric.
        """
        return pulumi.get(self, "metric_name")

    @metric_name.setter
    def metric_name(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "metric_name", value)

    @property
    @pulumi.getter
    def namespace(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The namespace for the metric.
        """
        return pulumi.get(self, "namespace")

    @namespace.setter
    def namespace(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "namespace", value)


if not MYPY:
    class AnomalyDetectorRdsSourceConfigArgsDict(TypedDict):
        database_host: pulumi.Input[builtins.str]
        """
        The host name of the database.
        """
        database_name: pulumi.Input[builtins.str]
        """
        The name of the RDS database.
        """
        database_port: pulumi.Input[builtins.int]
        """
        The port number where the database can be accessed.
        """
        db_instance_identifier: pulumi.Input[builtins.str]
        """
        A string identifying the database instance.
        """
        role_arn: pulumi.Input[builtins.str]
        """
        The Amazon Resource Name (ARN) of the role.
        """
        secret_manager_arn: pulumi.Input[builtins.str]
        """
        The Amazon Resource Name (ARN) of the AWS Secrets Manager role.
        """
        table_name: pulumi.Input[builtins.str]
        """
        The name of the table in the database.
        """
        vpc_configuration: pulumi.Input['AnomalyDetectorVpcConfigurationArgsDict']
        """
        An object containing information about the Amazon Virtual Private Cloud (VPC) configuration.
        """
elif False:
    AnomalyDetectorRdsSourceConfigArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class AnomalyDetectorRdsSourceConfigArgs:
    def __init__(__self__, *,
                 database_host: pulumi.Input[builtins.str],
                 database_name: pulumi.Input[builtins.str],
                 database_port: pulumi.Input[builtins.int],
                 db_instance_identifier: pulumi.Input[builtins.str],
                 role_arn: pulumi.Input[builtins.str],
                 secret_manager_arn: pulumi.Input[builtins.str],
                 table_name: pulumi.Input[builtins.str],
                 vpc_configuration: pulumi.Input['AnomalyDetectorVpcConfigurationArgs']):
        """
        :param pulumi.Input[builtins.str] database_host: The host name of the database.
        :param pulumi.Input[builtins.str] database_name: The name of the RDS database.
        :param pulumi.Input[builtins.int] database_port: The port number where the database can be accessed.
        :param pulumi.Input[builtins.str] db_instance_identifier: A string identifying the database instance.
        :param pulumi.Input[builtins.str] role_arn: The Amazon Resource Name (ARN) of the role.
        :param pulumi.Input[builtins.str] secret_manager_arn: The Amazon Resource Name (ARN) of the AWS Secrets Manager role.
        :param pulumi.Input[builtins.str] table_name: The name of the table in the database.
        :param pulumi.Input['AnomalyDetectorVpcConfigurationArgs'] vpc_configuration: An object containing information about the Amazon Virtual Private Cloud (VPC) configuration.
        """
        pulumi.set(__self__, "database_host", database_host)
        pulumi.set(__self__, "database_name", database_name)
        pulumi.set(__self__, "database_port", database_port)
        pulumi.set(__self__, "db_instance_identifier", db_instance_identifier)
        pulumi.set(__self__, "role_arn", role_arn)
        pulumi.set(__self__, "secret_manager_arn", secret_manager_arn)
        pulumi.set(__self__, "table_name", table_name)
        pulumi.set(__self__, "vpc_configuration", vpc_configuration)

    @property
    @pulumi.getter(name="databaseHost")
    def database_host(self) -> pulumi.Input[builtins.str]:
        """
        The host name of the database.
        """
        return pulumi.get(self, "database_host")

    @database_host.setter
    def database_host(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "database_host", value)

    @property
    @pulumi.getter(name="databaseName")
    def database_name(self) -> pulumi.Input[builtins.str]:
        """
        The name of the RDS database.
        """
        return pulumi.get(self, "database_name")

    @database_name.setter
    def database_name(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "database_name", value)

    @property
    @pulumi.getter(name="databasePort")
    def database_port(self) -> pulumi.Input[builtins.int]:
        """
        The port number where the database can be accessed.
        """
        return pulumi.get(self, "database_port")

    @database_port.setter
    def database_port(self, value: pulumi.Input[builtins.int]):
        pulumi.set(self, "database_port", value)

    @property
    @pulumi.getter(name="dbInstanceIdentifier")
    def db_instance_identifier(self) -> pulumi.Input[builtins.str]:
        """
        A string identifying the database instance.
        """
        return pulumi.get(self, "db_instance_identifier")

    @db_instance_identifier.setter
    def db_instance_identifier(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "db_instance_identifier", value)

    @property
    @pulumi.getter(name="roleArn")
    def role_arn(self) -> pulumi.Input[builtins.str]:
        """
        The Amazon Resource Name (ARN) of the role.
        """
        return pulumi.get(self, "role_arn")

    @role_arn.setter
    def role_arn(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "role_arn", value)

    @property
    @pulumi.getter(name="secretManagerArn")
    def secret_manager_arn(self) -> pulumi.Input[builtins.str]:
        """
        The Amazon Resource Name (ARN) of the AWS Secrets Manager role.
        """
        return pulumi.get(self, "secret_manager_arn")

    @secret_manager_arn.setter
    def secret_manager_arn(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "secret_manager_arn", value)

    @property
    @pulumi.getter(name="tableName")
    def table_name(self) -> pulumi.Input[builtins.str]:
        """
        The name of the table in the database.
        """
        return pulumi.get(self, "table_name")

    @table_name.setter
    def table_name(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "table_name", value)

    @property
    @pulumi.getter(name="vpcConfiguration")
    def vpc_configuration(self) -> pulumi.Input['AnomalyDetectorVpcConfigurationArgs']:
        """
        An object containing information about the Amazon Virtual Private Cloud (VPC) configuration.
        """
        return pulumi.get(self, "vpc_configuration")

    @vpc_configuration.setter
    def vpc_configuration(self, value: pulumi.Input['AnomalyDetectorVpcConfigurationArgs']):
        pulumi.set(self, "vpc_configuration", value)


if not MYPY:
    class AnomalyDetectorRedshiftSourceConfigArgsDict(TypedDict):
        cluster_identifier: pulumi.Input[builtins.str]
        """
        A string identifying the Redshift cluster.
        """
        database_host: pulumi.Input[builtins.str]
        """
        The name of the database host.
        """
        database_name: pulumi.Input[builtins.str]
        """
        The Redshift database name.
        """
        database_port: pulumi.Input[builtins.int]
        """
        The port number where the database can be accessed.
        """
        role_arn: pulumi.Input[builtins.str]
        """
        The Amazon Resource Name (ARN) of the role providing access to the database.
        """
        secret_manager_arn: pulumi.Input[builtins.str]
        """
        The Amazon Resource Name (ARN) of the AWS Secrets Manager role.
        """
        table_name: pulumi.Input[builtins.str]
        """
        The table name of the Redshift database.
        """
        vpc_configuration: pulumi.Input['AnomalyDetectorVpcConfigurationArgsDict']
        """
        Contains information about the Amazon Virtual Private Cloud (VPC) configuration.
        """
elif False:
    AnomalyDetectorRedshiftSourceConfigArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class AnomalyDetectorRedshiftSourceConfigArgs:
    def __init__(__self__, *,
                 cluster_identifier: pulumi.Input[builtins.str],
                 database_host: pulumi.Input[builtins.str],
                 database_name: pulumi.Input[builtins.str],
                 database_port: pulumi.Input[builtins.int],
                 role_arn: pulumi.Input[builtins.str],
                 secret_manager_arn: pulumi.Input[builtins.str],
                 table_name: pulumi.Input[builtins.str],
                 vpc_configuration: pulumi.Input['AnomalyDetectorVpcConfigurationArgs']):
        """
        :param pulumi.Input[builtins.str] cluster_identifier: A string identifying the Redshift cluster.
        :param pulumi.Input[builtins.str] database_host: The name of the database host.
        :param pulumi.Input[builtins.str] database_name: The Redshift database name.
        :param pulumi.Input[builtins.int] database_port: The port number where the database can be accessed.
        :param pulumi.Input[builtins.str] role_arn: The Amazon Resource Name (ARN) of the role providing access to the database.
        :param pulumi.Input[builtins.str] secret_manager_arn: The Amazon Resource Name (ARN) of the AWS Secrets Manager role.
        :param pulumi.Input[builtins.str] table_name: The table name of the Redshift database.
        :param pulumi.Input['AnomalyDetectorVpcConfigurationArgs'] vpc_configuration: Contains information about the Amazon Virtual Private Cloud (VPC) configuration.
        """
        pulumi.set(__self__, "cluster_identifier", cluster_identifier)
        pulumi.set(__self__, "database_host", database_host)
        pulumi.set(__self__, "database_name", database_name)
        pulumi.set(__self__, "database_port", database_port)
        pulumi.set(__self__, "role_arn", role_arn)
        pulumi.set(__self__, "secret_manager_arn", secret_manager_arn)
        pulumi.set(__self__, "table_name", table_name)
        pulumi.set(__self__, "vpc_configuration", vpc_configuration)

    @property
    @pulumi.getter(name="clusterIdentifier")
    def cluster_identifier(self) -> pulumi.Input[builtins.str]:
        """
        A string identifying the Redshift cluster.
        """
        return pulumi.get(self, "cluster_identifier")

    @cluster_identifier.setter
    def cluster_identifier(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "cluster_identifier", value)

    @property
    @pulumi.getter(name="databaseHost")
    def database_host(self) -> pulumi.Input[builtins.str]:
        """
        The name of the database host.
        """
        return pulumi.get(self, "database_host")

    @database_host.setter
    def database_host(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "database_host", value)

    @property
    @pulumi.getter(name="databaseName")
    def database_name(self) -> pulumi.Input[builtins.str]:
        """
        The Redshift database name.
        """
        return pulumi.get(self, "database_name")

    @database_name.setter
    def database_name(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "database_name", value)

    @property
    @pulumi.getter(name="databasePort")
    def database_port(self) -> pulumi.Input[builtins.int]:
        """
        The port number where the database can be accessed.
        """
        return pulumi.get(self, "database_port")

    @database_port.setter
    def database_port(self, value: pulumi.Input[builtins.int]):
        pulumi.set(self, "database_port", value)

    @property
    @pulumi.getter(name="roleArn")
    def role_arn(self) -> pulumi.Input[builtins.str]:
        """
        The Amazon Resource Name (ARN) of the role providing access to the database.
        """
        return pulumi.get(self, "role_arn")

    @role_arn.setter
    def role_arn(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "role_arn", value)

    @property
    @pulumi.getter(name="secretManagerArn")
    def secret_manager_arn(self) -> pulumi.Input[builtins.str]:
        """
        The Amazon Resource Name (ARN) of the AWS Secrets Manager role.
        """
        return pulumi.get(self, "secret_manager_arn")

    @secret_manager_arn.setter
    def secret_manager_arn(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "secret_manager_arn", value)

    @property
    @pulumi.getter(name="tableName")
    def table_name(self) -> pulumi.Input[builtins.str]:
        """
        The table name of the Redshift database.
        """
        return pulumi.get(self, "table_name")

    @table_name.setter
    def table_name(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "table_name", value)

    @property
    @pulumi.getter(name="vpcConfiguration")
    def vpc_configuration(self) -> pulumi.Input['AnomalyDetectorVpcConfigurationArgs']:
        """
        Contains information about the Amazon Virtual Private Cloud (VPC) configuration.
        """
        return pulumi.get(self, "vpc_configuration")

    @vpc_configuration.setter
    def vpc_configuration(self, value: pulumi.Input['AnomalyDetectorVpcConfigurationArgs']):
        pulumi.set(self, "vpc_configuration", value)


if not MYPY:
    class AnomalyDetectorS3SourceConfigArgsDict(TypedDict):
        file_format_descriptor: pulumi.Input['AnomalyDetectorFileFormatDescriptorArgsDict']
        """
        Contains information about a source file's formatting.
        """
        role_arn: pulumi.Input[builtins.str]
        """
        The ARN of an IAM role that has read and write access permissions to the source S3 bucket.
        """
        historical_data_path_list: NotRequired[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]
        """
        A list of paths to the historical data files.
        """
        templated_path_list: NotRequired[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]
        """
        A list of templated paths to the source files.
        """
elif False:
    AnomalyDetectorS3SourceConfigArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class AnomalyDetectorS3SourceConfigArgs:
    def __init__(__self__, *,
                 file_format_descriptor: pulumi.Input['AnomalyDetectorFileFormatDescriptorArgs'],
                 role_arn: pulumi.Input[builtins.str],
                 historical_data_path_list: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
                 templated_path_list: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None):
        """
        :param pulumi.Input['AnomalyDetectorFileFormatDescriptorArgs'] file_format_descriptor: Contains information about a source file's formatting.
        :param pulumi.Input[builtins.str] role_arn: The ARN of an IAM role that has read and write access permissions to the source S3 bucket.
        :param pulumi.Input[Sequence[pulumi.Input[builtins.str]]] historical_data_path_list: A list of paths to the historical data files.
        :param pulumi.Input[Sequence[pulumi.Input[builtins.str]]] templated_path_list: A list of templated paths to the source files.
        """
        pulumi.set(__self__, "file_format_descriptor", file_format_descriptor)
        pulumi.set(__self__, "role_arn", role_arn)
        if historical_data_path_list is not None:
            pulumi.set(__self__, "historical_data_path_list", historical_data_path_list)
        if templated_path_list is not None:
            pulumi.set(__self__, "templated_path_list", templated_path_list)

    @property
    @pulumi.getter(name="fileFormatDescriptor")
    def file_format_descriptor(self) -> pulumi.Input['AnomalyDetectorFileFormatDescriptorArgs']:
        """
        Contains information about a source file's formatting.
        """
        return pulumi.get(self, "file_format_descriptor")

    @file_format_descriptor.setter
    def file_format_descriptor(self, value: pulumi.Input['AnomalyDetectorFileFormatDescriptorArgs']):
        pulumi.set(self, "file_format_descriptor", value)

    @property
    @pulumi.getter(name="roleArn")
    def role_arn(self) -> pulumi.Input[builtins.str]:
        """
        The ARN of an IAM role that has read and write access permissions to the source S3 bucket.
        """
        return pulumi.get(self, "role_arn")

    @role_arn.setter
    def role_arn(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "role_arn", value)

    @property
    @pulumi.getter(name="historicalDataPathList")
    def historical_data_path_list(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]:
        """
        A list of paths to the historical data files.
        """
        return pulumi.get(self, "historical_data_path_list")

    @historical_data_path_list.setter
    def historical_data_path_list(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "historical_data_path_list", value)

    @property
    @pulumi.getter(name="templatedPathList")
    def templated_path_list(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]:
        """
        A list of templated paths to the source files.
        """
        return pulumi.get(self, "templated_path_list")

    @templated_path_list.setter
    def templated_path_list(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "templated_path_list", value)


if not MYPY:
    class AnomalyDetectorTimestampColumnArgsDict(TypedDict):
        column_format: NotRequired[pulumi.Input[builtins.str]]
        """
        A timestamp format for the timestamps in the dataset
        """
        column_name: NotRequired[pulumi.Input[builtins.str]]
        """
        The name of the timestamp column.
        """
elif False:
    AnomalyDetectorTimestampColumnArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class AnomalyDetectorTimestampColumnArgs:
    def __init__(__self__, *,
                 column_format: Optional[pulumi.Input[builtins.str]] = None,
                 column_name: Optional[pulumi.Input[builtins.str]] = None):
        """
        :param pulumi.Input[builtins.str] column_format: A timestamp format for the timestamps in the dataset
        :param pulumi.Input[builtins.str] column_name: The name of the timestamp column.
        """
        if column_format is not None:
            pulumi.set(__self__, "column_format", column_format)
        if column_name is not None:
            pulumi.set(__self__, "column_name", column_name)

    @property
    @pulumi.getter(name="columnFormat")
    def column_format(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        A timestamp format for the timestamps in the dataset
        """
        return pulumi.get(self, "column_format")

    @column_format.setter
    def column_format(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "column_format", value)

    @property
    @pulumi.getter(name="columnName")
    def column_name(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The name of the timestamp column.
        """
        return pulumi.get(self, "column_name")

    @column_name.setter
    def column_name(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "column_name", value)


if not MYPY:
    class AnomalyDetectorVpcConfigurationArgsDict(TypedDict):
        security_group_id_list: pulumi.Input[Sequence[pulumi.Input[builtins.str]]]
        """
        An array of strings containing the list of security groups.
        """
        subnet_id_list: pulumi.Input[Sequence[pulumi.Input[builtins.str]]]
        """
        An array of strings containing the Amazon VPC subnet IDs (e.g., `subnet-0bb1c79de3EXAMPLE` .
        """
elif False:
    AnomalyDetectorVpcConfigurationArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class AnomalyDetectorVpcConfigurationArgs:
    def __init__(__self__, *,
                 security_group_id_list: pulumi.Input[Sequence[pulumi.Input[builtins.str]]],
                 subnet_id_list: pulumi.Input[Sequence[pulumi.Input[builtins.str]]]):
        """
        :param pulumi.Input[Sequence[pulumi.Input[builtins.str]]] security_group_id_list: An array of strings containing the list of security groups.
        :param pulumi.Input[Sequence[pulumi.Input[builtins.str]]] subnet_id_list: An array of strings containing the Amazon VPC subnet IDs (e.g., `subnet-0bb1c79de3EXAMPLE` .
        """
        pulumi.set(__self__, "security_group_id_list", security_group_id_list)
        pulumi.set(__self__, "subnet_id_list", subnet_id_list)

    @property
    @pulumi.getter(name="securityGroupIdList")
    def security_group_id_list(self) -> pulumi.Input[Sequence[pulumi.Input[builtins.str]]]:
        """
        An array of strings containing the list of security groups.
        """
        return pulumi.get(self, "security_group_id_list")

    @security_group_id_list.setter
    def security_group_id_list(self, value: pulumi.Input[Sequence[pulumi.Input[builtins.str]]]):
        pulumi.set(self, "security_group_id_list", value)

    @property
    @pulumi.getter(name="subnetIdList")
    def subnet_id_list(self) -> pulumi.Input[Sequence[pulumi.Input[builtins.str]]]:
        """
        An array of strings containing the Amazon VPC subnet IDs (e.g., `subnet-0bb1c79de3EXAMPLE` .
        """
        return pulumi.get(self, "subnet_id_list")

    @subnet_id_list.setter
    def subnet_id_list(self, value: pulumi.Input[Sequence[pulumi.Input[builtins.str]]]):
        pulumi.set(self, "subnet_id_list", value)


