# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs
from ._enums import *
from ._inputs import *

__all__ = ['TransformerArgs', 'Transformer']

@pulumi.input_type
class TransformerArgs:
    def __init__(__self__, *,
                 log_group_identifier: pulumi.Input[builtins.str],
                 transformer_config: pulumi.Input[Sequence[pulumi.Input['TransformerProcessorArgs']]]):
        """
        The set of arguments for constructing a Transformer resource.
        :param pulumi.Input[builtins.str] log_group_identifier: Existing log group that you want to associate with this transformer.
        :param pulumi.Input[Sequence[pulumi.Input['TransformerProcessorArgs']]] transformer_config: List of processors in a transformer
        """
        pulumi.set(__self__, "log_group_identifier", log_group_identifier)
        pulumi.set(__self__, "transformer_config", transformer_config)

    @property
    @pulumi.getter(name="logGroupIdentifier")
    def log_group_identifier(self) -> pulumi.Input[builtins.str]:
        """
        Existing log group that you want to associate with this transformer.
        """
        return pulumi.get(self, "log_group_identifier")

    @log_group_identifier.setter
    def log_group_identifier(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "log_group_identifier", value)

    @property
    @pulumi.getter(name="transformerConfig")
    def transformer_config(self) -> pulumi.Input[Sequence[pulumi.Input['TransformerProcessorArgs']]]:
        """
        List of processors in a transformer
        """
        return pulumi.get(self, "transformer_config")

    @transformer_config.setter
    def transformer_config(self, value: pulumi.Input[Sequence[pulumi.Input['TransformerProcessorArgs']]]):
        pulumi.set(self, "transformer_config", value)


@pulumi.type_token("aws-native:logs:Transformer")
class Transformer(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 log_group_identifier: Optional[pulumi.Input[builtins.str]] = None,
                 transformer_config: Optional[pulumi.Input[Sequence[pulumi.Input[Union['TransformerProcessorArgs', 'TransformerProcessorArgsDict']]]]] = None,
                 __props__=None):
        """
        Specifies a transformer on the log group to transform logs into consistent structured and information rich format.

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[builtins.str] log_group_identifier: Existing log group that you want to associate with this transformer.
        :param pulumi.Input[Sequence[pulumi.Input[Union['TransformerProcessorArgs', 'TransformerProcessorArgsDict']]]] transformer_config: List of processors in a transformer
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: TransformerArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Specifies a transformer on the log group to transform logs into consistent structured and information rich format.

        :param str resource_name: The name of the resource.
        :param TransformerArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(TransformerArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 log_group_identifier: Optional[pulumi.Input[builtins.str]] = None,
                 transformer_config: Optional[pulumi.Input[Sequence[pulumi.Input[Union['TransformerProcessorArgs', 'TransformerProcessorArgsDict']]]]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = TransformerArgs.__new__(TransformerArgs)

            if log_group_identifier is None and not opts.urn:
                raise TypeError("Missing required property 'log_group_identifier'")
            __props__.__dict__["log_group_identifier"] = log_group_identifier
            if transformer_config is None and not opts.urn:
                raise TypeError("Missing required property 'transformer_config'")
            __props__.__dict__["transformer_config"] = transformer_config
        replace_on_changes = pulumi.ResourceOptions(replace_on_changes=["logGroupIdentifier"])
        opts = pulumi.ResourceOptions.merge(opts, replace_on_changes)
        super(Transformer, __self__).__init__(
            'aws-native:logs:Transformer',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None) -> 'Transformer':
        """
        Get an existing Transformer resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = TransformerArgs.__new__(TransformerArgs)

        __props__.__dict__["log_group_identifier"] = None
        __props__.__dict__["transformer_config"] = None
        return Transformer(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter(name="logGroupIdentifier")
    def log_group_identifier(self) -> pulumi.Output[builtins.str]:
        """
        Existing log group that you want to associate with this transformer.
        """
        return pulumi.get(self, "log_group_identifier")

    @property
    @pulumi.getter(name="transformerConfig")
    def transformer_config(self) -> pulumi.Output[Sequence['outputs.TransformerProcessor']]:
        """
        List of processors in a transformer
        """
        return pulumi.get(self, "transformer_config")

