# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from ._enums import *

__all__ = ['QueryDefinitionArgs', 'QueryDefinition']

@pulumi.input_type
class QueryDefinitionArgs:
    def __init__(__self__, *,
                 query_string: pulumi.Input[builtins.str],
                 log_group_names: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
                 name: Optional[pulumi.Input[builtins.str]] = None,
                 query_language: Optional[pulumi.Input['QueryDefinitionQueryLanguage']] = None):
        """
        The set of arguments for constructing a QueryDefinition resource.
        :param pulumi.Input[builtins.str] query_string: The query string to use for this definition
        :param pulumi.Input[Sequence[pulumi.Input[builtins.str]]] log_group_names: Optionally define specific log groups as part of your query definition
        :param pulumi.Input[builtins.str] name: A name for the saved query definition
        :param pulumi.Input['QueryDefinitionQueryLanguage'] query_language: Query language of the query string. Possible values are CWLI, SQL, PPL, with CWLI being the default.
        """
        pulumi.set(__self__, "query_string", query_string)
        if log_group_names is not None:
            pulumi.set(__self__, "log_group_names", log_group_names)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if query_language is not None:
            pulumi.set(__self__, "query_language", query_language)

    @property
    @pulumi.getter(name="queryString")
    def query_string(self) -> pulumi.Input[builtins.str]:
        """
        The query string to use for this definition
        """
        return pulumi.get(self, "query_string")

    @query_string.setter
    def query_string(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "query_string", value)

    @property
    @pulumi.getter(name="logGroupNames")
    def log_group_names(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]:
        """
        Optionally define specific log groups as part of your query definition
        """
        return pulumi.get(self, "log_group_names")

    @log_group_names.setter
    def log_group_names(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "log_group_names", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        A name for the saved query definition
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter(name="queryLanguage")
    def query_language(self) -> Optional[pulumi.Input['QueryDefinitionQueryLanguage']]:
        """
        Query language of the query string. Possible values are CWLI, SQL, PPL, with CWLI being the default.
        """
        return pulumi.get(self, "query_language")

    @query_language.setter
    def query_language(self, value: Optional[pulumi.Input['QueryDefinitionQueryLanguage']]):
        pulumi.set(self, "query_language", value)


@pulumi.type_token("aws-native:logs:QueryDefinition")
class QueryDefinition(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 log_group_names: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
                 name: Optional[pulumi.Input[builtins.str]] = None,
                 query_language: Optional[pulumi.Input['QueryDefinitionQueryLanguage']] = None,
                 query_string: Optional[pulumi.Input[builtins.str]] = None,
                 __props__=None):
        """
        The resource schema for AWSLogs QueryDefinition

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[Sequence[pulumi.Input[builtins.str]]] log_group_names: Optionally define specific log groups as part of your query definition
        :param pulumi.Input[builtins.str] name: A name for the saved query definition
        :param pulumi.Input['QueryDefinitionQueryLanguage'] query_language: Query language of the query string. Possible values are CWLI, SQL, PPL, with CWLI being the default.
        :param pulumi.Input[builtins.str] query_string: The query string to use for this definition
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: QueryDefinitionArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        The resource schema for AWSLogs QueryDefinition

        :param str resource_name: The name of the resource.
        :param QueryDefinitionArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(QueryDefinitionArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 log_group_names: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
                 name: Optional[pulumi.Input[builtins.str]] = None,
                 query_language: Optional[pulumi.Input['QueryDefinitionQueryLanguage']] = None,
                 query_string: Optional[pulumi.Input[builtins.str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = QueryDefinitionArgs.__new__(QueryDefinitionArgs)

            __props__.__dict__["log_group_names"] = log_group_names
            __props__.__dict__["name"] = name
            __props__.__dict__["query_language"] = query_language
            if query_string is None and not opts.urn:
                raise TypeError("Missing required property 'query_string'")
            __props__.__dict__["query_string"] = query_string
            __props__.__dict__["query_definition_id"] = None
        super(QueryDefinition, __self__).__init__(
            'aws-native:logs:QueryDefinition',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None) -> 'QueryDefinition':
        """
        Get an existing QueryDefinition resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = QueryDefinitionArgs.__new__(QueryDefinitionArgs)

        __props__.__dict__["log_group_names"] = None
        __props__.__dict__["name"] = None
        __props__.__dict__["query_definition_id"] = None
        __props__.__dict__["query_language"] = None
        __props__.__dict__["query_string"] = None
        return QueryDefinition(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter(name="logGroupNames")
    def log_group_names(self) -> pulumi.Output[Optional[Sequence[builtins.str]]]:
        """
        Optionally define specific log groups as part of your query definition
        """
        return pulumi.get(self, "log_group_names")

    @property
    @pulumi.getter
    def name(self) -> pulumi.Output[builtins.str]:
        """
        A name for the saved query definition
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="queryDefinitionId")
    def query_definition_id(self) -> pulumi.Output[builtins.str]:
        """
        Unique identifier of a query definition
        """
        return pulumi.get(self, "query_definition_id")

    @property
    @pulumi.getter(name="queryLanguage")
    def query_language(self) -> pulumi.Output[Optional['QueryDefinitionQueryLanguage']]:
        """
        Query language of the query string. Possible values are CWLI, SQL, PPL, with CWLI being the default.
        """
        return pulumi.get(self, "query_language")

    @property
    @pulumi.getter(name="queryString")
    def query_string(self) -> pulumi.Output[builtins.str]:
        """
        The query string to use for this definition
        """
        return pulumi.get(self, "query_string")

