# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs
from ._enums import *

__all__ = [
    'DeliveryDestinationDestinationPolicy',
    'IntegrationOpenSearchResourceConfig',
    'MetricFilterDimension',
    'MetricFilterMetricTransformation',
    'ResourceConfigProperties',
    'TransformerAddKeyEntry',
    'TransformerCopyValueEntry',
    'TransformerMoveKeyEntry',
    'TransformerParseCloudfront',
    'TransformerParsePostgres',
    'TransformerParseRoute53',
    'TransformerParseVpc',
    'TransformerParseWaf',
    'TransformerProcessor',
    'TransformerProcessorAddKeysProperties',
    'TransformerProcessorCopyValueProperties',
    'TransformerProcessorCsvProperties',
    'TransformerProcessorDateTimeConverterProperties',
    'TransformerProcessorDeleteKeysProperties',
    'TransformerProcessorGrokProperties',
    'TransformerProcessorListToMapProperties',
    'TransformerProcessorLowerCaseStringProperties',
    'TransformerProcessorMoveKeysProperties',
    'TransformerProcessorParseJsonProperties',
    'TransformerProcessorParseKeyValueProperties',
    'TransformerProcessorRenameKeysProperties',
    'TransformerProcessorSplitStringProperties',
    'TransformerProcessorSubstituteStringProperties',
    'TransformerProcessorTrimStringProperties',
    'TransformerProcessorTypeConverterProperties',
    'TransformerProcessorUpperCaseStringProperties',
    'TransformerRenameKeyEntry',
    'TransformerSplitStringEntry',
    'TransformerSubstituteStringEntry',
    'TransformerTypeConverterEntry',
]

@pulumi.output_type
class DeliveryDestinationDestinationPolicy(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "deliveryDestinationName":
            suggest = "delivery_destination_name"
        elif key == "deliveryDestinationPolicy":
            suggest = "delivery_destination_policy"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in DeliveryDestinationDestinationPolicy. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        DeliveryDestinationDestinationPolicy.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        DeliveryDestinationDestinationPolicy.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 delivery_destination_name: Optional[builtins.str] = None,
                 delivery_destination_policy: Optional[Any] = None):
        """
        :param builtins.str delivery_destination_name: The name of the delivery destination to assign this policy to
        :param Any delivery_destination_policy: The contents of the policy attached to the delivery destination
        """
        if delivery_destination_name is not None:
            pulumi.set(__self__, "delivery_destination_name", delivery_destination_name)
        if delivery_destination_policy is not None:
            pulumi.set(__self__, "delivery_destination_policy", delivery_destination_policy)

    @property
    @pulumi.getter(name="deliveryDestinationName")
    def delivery_destination_name(self) -> Optional[builtins.str]:
        """
        The name of the delivery destination to assign this policy to
        """
        return pulumi.get(self, "delivery_destination_name")

    @property
    @pulumi.getter(name="deliveryDestinationPolicy")
    def delivery_destination_policy(self) -> Optional[Any]:
        """
        The contents of the policy attached to the delivery destination
        """
        return pulumi.get(self, "delivery_destination_policy")


@pulumi.output_type
class IntegrationOpenSearchResourceConfig(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "dashboardViewerPrincipals":
            suggest = "dashboard_viewer_principals"
        elif key == "dataSourceRoleArn":
            suggest = "data_source_role_arn"
        elif key == "applicationArn":
            suggest = "application_arn"
        elif key == "kmsKeyArn":
            suggest = "kms_key_arn"
        elif key == "retentionDays":
            suggest = "retention_days"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in IntegrationOpenSearchResourceConfig. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        IntegrationOpenSearchResourceConfig.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        IntegrationOpenSearchResourceConfig.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 dashboard_viewer_principals: Sequence[builtins.str],
                 data_source_role_arn: builtins.str,
                 application_arn: Optional[builtins.str] = None,
                 kms_key_arn: Optional[builtins.str] = None,
                 retention_days: Optional[builtins.int] = None):
        """
        :param Sequence[builtins.str] dashboard_viewer_principals: Specify the ARNs of IAM roles and IAM users who you want to grant permission to for viewing the dashboards.
               
               > In addition to specifying these users here, you must also grant them the *CloudWatchOpenSearchDashboardAccess* IAM policy. For more information, see [IAM policies for users](https://docs.aws.amazon.com/AmazonCloudWatch/latest/logs/OpenSearch-Dashboards-UserRoles.html) .
        :param builtins.str data_source_role_arn: Specify the ARN of an IAM role that CloudWatch Logs will use to create the integration. This role must have the permissions necessary to access the OpenSearch Service collection to be able to create the dashboards. For more information about the permissions needed, see [Permissions that the integration needs](https://docs.aws.amazon.com/AmazonCloudWatch/latest/logs/OpenSearch-Dashboards-CreateRole.html) in the CloudWatch Logs User Guide.
        :param builtins.str application_arn: If you want to use an existing OpenSearch Service application for your integration with OpenSearch Service, specify it here. If you omit this, a new application will be created.
        :param builtins.str kms_key_arn: To have the vended dashboard data encrypted with AWS KMS instead of the CloudWatch Logs default encryption method, specify the ARN of the AWS KMS key that you want to use.
        :param builtins.int retention_days: Specify how many days that you want the data derived by OpenSearch Service to be retained in the index that the dashboard refers to. This also sets the maximum time period that you can choose when viewing data in the dashboard. Choosing a longer time frame will incur additional costs.
        """
        pulumi.set(__self__, "dashboard_viewer_principals", dashboard_viewer_principals)
        pulumi.set(__self__, "data_source_role_arn", data_source_role_arn)
        if application_arn is not None:
            pulumi.set(__self__, "application_arn", application_arn)
        if kms_key_arn is not None:
            pulumi.set(__self__, "kms_key_arn", kms_key_arn)
        if retention_days is not None:
            pulumi.set(__self__, "retention_days", retention_days)

    @property
    @pulumi.getter(name="dashboardViewerPrincipals")
    def dashboard_viewer_principals(self) -> Sequence[builtins.str]:
        """
        Specify the ARNs of IAM roles and IAM users who you want to grant permission to for viewing the dashboards.

        > In addition to specifying these users here, you must also grant them the *CloudWatchOpenSearchDashboardAccess* IAM policy. For more information, see [IAM policies for users](https://docs.aws.amazon.com/AmazonCloudWatch/latest/logs/OpenSearch-Dashboards-UserRoles.html) .
        """
        return pulumi.get(self, "dashboard_viewer_principals")

    @property
    @pulumi.getter(name="dataSourceRoleArn")
    def data_source_role_arn(self) -> builtins.str:
        """
        Specify the ARN of an IAM role that CloudWatch Logs will use to create the integration. This role must have the permissions necessary to access the OpenSearch Service collection to be able to create the dashboards. For more information about the permissions needed, see [Permissions that the integration needs](https://docs.aws.amazon.com/AmazonCloudWatch/latest/logs/OpenSearch-Dashboards-CreateRole.html) in the CloudWatch Logs User Guide.
        """
        return pulumi.get(self, "data_source_role_arn")

    @property
    @pulumi.getter(name="applicationArn")
    def application_arn(self) -> Optional[builtins.str]:
        """
        If you want to use an existing OpenSearch Service application for your integration with OpenSearch Service, specify it here. If you omit this, a new application will be created.
        """
        return pulumi.get(self, "application_arn")

    @property
    @pulumi.getter(name="kmsKeyArn")
    def kms_key_arn(self) -> Optional[builtins.str]:
        """
        To have the vended dashboard data encrypted with AWS KMS instead of the CloudWatch Logs default encryption method, specify the ARN of the AWS KMS key that you want to use.
        """
        return pulumi.get(self, "kms_key_arn")

    @property
    @pulumi.getter(name="retentionDays")
    def retention_days(self) -> Optional[builtins.int]:
        """
        Specify how many days that you want the data derived by OpenSearch Service to be retained in the index that the dashboard refers to. This also sets the maximum time period that you can choose when viewing data in the dashboard. Choosing a longer time frame will incur additional costs.
        """
        return pulumi.get(self, "retention_days")


@pulumi.output_type
class MetricFilterDimension(dict):
    """
    Specifies the CW metric dimensions to publish with this metric.
      Because dimensions are part of the unique identifier for a metric, whenever a unique dimension name/value pair is extracted from your logs, you are creating a new variation of that metric.
     For more information about publishing dimensions with metrics created by metric filters, see [Publishing dimensions with metrics from values in JSON or space-delimited log events](https://docs.aws.amazon.com/AmazonCloudWatch/latest/logs/FilterAndPatternSyntax.html#logs-metric-filters-dimensions).
      Metrics extracted from log events are charged as custom metrics. To prevent unexpected high charges, do not specify high-cardinality fields such as ``IPAddress`` or ``requestID`` as dimensions. Each different value found for a dimension is treated as a separate metric and accrues charges as a separate custom metric. 
     To help prevent accidental high charges, Amazon disables a metric filter if it generates 1000 different name/value pairs for the dimensions that you have specified within a certain amount of time.
     You can also set up a billing alarm to alert you if your charges are higher than expected. For more information, see [Creating a Billing Alarm to Monitor Your Estimated Charges](https://docs.aws.amazon.com/AmazonCloudWatch/latest/monitoring/monitor_estimated_charges_with_cloudwatch.html).
    """
    def __init__(__self__, *,
                 key: builtins.str,
                 value: builtins.str):
        """
        Specifies the CW metric dimensions to publish with this metric.
          Because dimensions are part of the unique identifier for a metric, whenever a unique dimension name/value pair is extracted from your logs, you are creating a new variation of that metric.
         For more information about publishing dimensions with metrics created by metric filters, see [Publishing dimensions with metrics from values in JSON or space-delimited log events](https://docs.aws.amazon.com/AmazonCloudWatch/latest/logs/FilterAndPatternSyntax.html#logs-metric-filters-dimensions).
          Metrics extracted from log events are charged as custom metrics. To prevent unexpected high charges, do not specify high-cardinality fields such as ``IPAddress`` or ``requestID`` as dimensions. Each different value found for a dimension is treated as a separate metric and accrues charges as a separate custom metric. 
         To help prevent accidental high charges, Amazon disables a metric filter if it generates 1000 different name/value pairs for the dimensions that you have specified within a certain amount of time.
         You can also set up a billing alarm to alert you if your charges are higher than expected. For more information, see [Creating a Billing Alarm to Monitor Your Estimated Charges](https://docs.aws.amazon.com/AmazonCloudWatch/latest/monitoring/monitor_estimated_charges_with_cloudwatch.html).
        :param builtins.str key: The name for the CW metric dimension that the metric filter creates.
                Dimension names must contain only ASCII characters, must include at least one non-whitespace character, and cannot start with a colon (:).
        :param builtins.str value: The log event field that will contain the value for this dimension. This dimension will only be published for a metric if the value is found in the log event. For example, ``$.eventType`` for JSON log events, or ``$server`` for space-delimited log events.
        """
        pulumi.set(__self__, "key", key)
        pulumi.set(__self__, "value", value)

    @property
    @pulumi.getter
    def key(self) -> builtins.str:
        """
        The name for the CW metric dimension that the metric filter creates.
         Dimension names must contain only ASCII characters, must include at least one non-whitespace character, and cannot start with a colon (:).
        """
        return pulumi.get(self, "key")

    @property
    @pulumi.getter
    def value(self) -> builtins.str:
        """
        The log event field that will contain the value for this dimension. This dimension will only be published for a metric if the value is found in the log event. For example, ``$.eventType`` for JSON log events, or ``$server`` for space-delimited log events.
        """
        return pulumi.get(self, "value")


@pulumi.output_type
class MetricFilterMetricTransformation(dict):
    """
    ``MetricTransformation`` is a property of the ``AWS::Logs::MetricFilter`` resource that describes how to transform log streams into a CloudWatch metric.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "metricName":
            suggest = "metric_name"
        elif key == "metricNamespace":
            suggest = "metric_namespace"
        elif key == "metricValue":
            suggest = "metric_value"
        elif key == "defaultValue":
            suggest = "default_value"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in MetricFilterMetricTransformation. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        MetricFilterMetricTransformation.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        MetricFilterMetricTransformation.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 metric_name: builtins.str,
                 metric_namespace: builtins.str,
                 metric_value: builtins.str,
                 default_value: Optional[builtins.float] = None,
                 dimensions: Optional[Sequence['outputs.MetricFilterDimension']] = None,
                 unit: Optional['MetricFilterMetricTransformationUnit'] = None):
        """
        ``MetricTransformation`` is a property of the ``AWS::Logs::MetricFilter`` resource that describes how to transform log streams into a CloudWatch metric.
        :param builtins.str metric_name: The name of the CloudWatch metric.
        :param builtins.str metric_namespace: A custom namespace to contain your metric in CloudWatch. Use namespaces to group together metrics that are similar. For more information, see [Namespaces](https://docs.aws.amazon.com/AmazonCloudWatch/latest/monitoring/cloudwatch_concepts.html#Namespace).
        :param builtins.str metric_value: The value that is published to the CloudWatch metric. For example, if you're counting the occurrences of a particular term like ``Error``, specify 1 for the metric value. If you're counting the number of bytes transferred, reference the value that is in the log event by using $. followed by the name of the field that you specified in the filter pattern, such as ``$.size``.
        :param builtins.float default_value: (Optional) The value to emit when a filter pattern does not match a log event. This value can be null.
        :param Sequence['MetricFilterDimension'] dimensions: The fields to use as dimensions for the metric. One metric filter can include as many as three dimensions.
                 Metrics extracted from log events are charged as custom metrics. To prevent unexpected high charges, do not specify high-cardinality fields such as ``IPAddress`` or ``requestID`` as dimensions. Each different value found for a dimension is treated as a separate metric and accrues charges as a separate custom metric. 
                CloudWatch Logs disables a metric filter if it generates 1000 different name/value pairs for your specified dimensions within a certain amount of time. This helps to prevent accidental high charges.
                You can also set up a billing alarm to alert you if your charges are higher than expected. For more information, see [Creating a Billing Alarm to Monitor Your Estimated Charges](https://docs.aws.amazon.com/AmazonCloudWatch/latest/monitoring/monitor_estimated_charges_with_cloudwatch.html).
        :param 'MetricFilterMetricTransformationUnit' unit: The unit to assign to the metric. If you omit this, the unit is set as ``None``.
        """
        pulumi.set(__self__, "metric_name", metric_name)
        pulumi.set(__self__, "metric_namespace", metric_namespace)
        pulumi.set(__self__, "metric_value", metric_value)
        if default_value is not None:
            pulumi.set(__self__, "default_value", default_value)
        if dimensions is not None:
            pulumi.set(__self__, "dimensions", dimensions)
        if unit is not None:
            pulumi.set(__self__, "unit", unit)

    @property
    @pulumi.getter(name="metricName")
    def metric_name(self) -> builtins.str:
        """
        The name of the CloudWatch metric.
        """
        return pulumi.get(self, "metric_name")

    @property
    @pulumi.getter(name="metricNamespace")
    def metric_namespace(self) -> builtins.str:
        """
        A custom namespace to contain your metric in CloudWatch. Use namespaces to group together metrics that are similar. For more information, see [Namespaces](https://docs.aws.amazon.com/AmazonCloudWatch/latest/monitoring/cloudwatch_concepts.html#Namespace).
        """
        return pulumi.get(self, "metric_namespace")

    @property
    @pulumi.getter(name="metricValue")
    def metric_value(self) -> builtins.str:
        """
        The value that is published to the CloudWatch metric. For example, if you're counting the occurrences of a particular term like ``Error``, specify 1 for the metric value. If you're counting the number of bytes transferred, reference the value that is in the log event by using $. followed by the name of the field that you specified in the filter pattern, such as ``$.size``.
        """
        return pulumi.get(self, "metric_value")

    @property
    @pulumi.getter(name="defaultValue")
    def default_value(self) -> Optional[builtins.float]:
        """
        (Optional) The value to emit when a filter pattern does not match a log event. This value can be null.
        """
        return pulumi.get(self, "default_value")

    @property
    @pulumi.getter
    def dimensions(self) -> Optional[Sequence['outputs.MetricFilterDimension']]:
        """
        The fields to use as dimensions for the metric. One metric filter can include as many as three dimensions.
          Metrics extracted from log events are charged as custom metrics. To prevent unexpected high charges, do not specify high-cardinality fields such as ``IPAddress`` or ``requestID`` as dimensions. Each different value found for a dimension is treated as a separate metric and accrues charges as a separate custom metric. 
         CloudWatch Logs disables a metric filter if it generates 1000 different name/value pairs for your specified dimensions within a certain amount of time. This helps to prevent accidental high charges.
         You can also set up a billing alarm to alert you if your charges are higher than expected. For more information, see [Creating a Billing Alarm to Monitor Your Estimated Charges](https://docs.aws.amazon.com/AmazonCloudWatch/latest/monitoring/monitor_estimated_charges_with_cloudwatch.html).
        """
        return pulumi.get(self, "dimensions")

    @property
    @pulumi.getter
    def unit(self) -> Optional['MetricFilterMetricTransformationUnit']:
        """
        The unit to assign to the metric. If you omit this, the unit is set as ``None``.
        """
        return pulumi.get(self, "unit")


@pulumi.output_type
class ResourceConfigProperties(dict):
    """
    OpenSearchResourceConfig for the given Integration
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "openSearchResourceConfig":
            suggest = "open_search_resource_config"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ResourceConfigProperties. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ResourceConfigProperties.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ResourceConfigProperties.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 open_search_resource_config: Optional['outputs.IntegrationOpenSearchResourceConfig'] = None):
        """
        OpenSearchResourceConfig for the given Integration
        :param 'IntegrationOpenSearchResourceConfig' open_search_resource_config: This structure contains configuration details about an integration between CloudWatch Logs and OpenSearch Service.
        """
        if open_search_resource_config is not None:
            pulumi.set(__self__, "open_search_resource_config", open_search_resource_config)

    @property
    @pulumi.getter(name="openSearchResourceConfig")
    def open_search_resource_config(self) -> Optional['outputs.IntegrationOpenSearchResourceConfig']:
        """
        This structure contains configuration details about an integration between CloudWatch Logs and OpenSearch Service.
        """
        return pulumi.get(self, "open_search_resource_config")


@pulumi.output_type
class TransformerAddKeyEntry(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "overwriteIfExists":
            suggest = "overwrite_if_exists"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in TransformerAddKeyEntry. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        TransformerAddKeyEntry.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        TransformerAddKeyEntry.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 key: builtins.str,
                 value: builtins.str,
                 overwrite_if_exists: Optional[builtins.bool] = None):
        """
        :param builtins.str key: The key of the new entry to be added to the log event
        :param builtins.str value: The value of the new entry to be added to the log event
        :param builtins.bool overwrite_if_exists: Specifies whether to overwrite the value if the key already exists in the log event. If you omit this, the default is `false` .
        """
        pulumi.set(__self__, "key", key)
        pulumi.set(__self__, "value", value)
        if overwrite_if_exists is not None:
            pulumi.set(__self__, "overwrite_if_exists", overwrite_if_exists)

    @property
    @pulumi.getter
    def key(self) -> builtins.str:
        """
        The key of the new entry to be added to the log event
        """
        return pulumi.get(self, "key")

    @property
    @pulumi.getter
    def value(self) -> builtins.str:
        """
        The value of the new entry to be added to the log event
        """
        return pulumi.get(self, "value")

    @property
    @pulumi.getter(name="overwriteIfExists")
    def overwrite_if_exists(self) -> Optional[builtins.bool]:
        """
        Specifies whether to overwrite the value if the key already exists in the log event. If you omit this, the default is `false` .
        """
        return pulumi.get(self, "overwrite_if_exists")


@pulumi.output_type
class TransformerCopyValueEntry(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "overwriteIfExists":
            suggest = "overwrite_if_exists"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in TransformerCopyValueEntry. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        TransformerCopyValueEntry.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        TransformerCopyValueEntry.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 source: builtins.str,
                 target: builtins.str,
                 overwrite_if_exists: Optional[builtins.bool] = None):
        pulumi.set(__self__, "source", source)
        pulumi.set(__self__, "target", target)
        if overwrite_if_exists is not None:
            pulumi.set(__self__, "overwrite_if_exists", overwrite_if_exists)

    @property
    @pulumi.getter
    def source(self) -> builtins.str:
        return pulumi.get(self, "source")

    @property
    @pulumi.getter
    def target(self) -> builtins.str:
        return pulumi.get(self, "target")

    @property
    @pulumi.getter(name="overwriteIfExists")
    def overwrite_if_exists(self) -> Optional[builtins.bool]:
        return pulumi.get(self, "overwrite_if_exists")


@pulumi.output_type
class TransformerMoveKeyEntry(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "overwriteIfExists":
            suggest = "overwrite_if_exists"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in TransformerMoveKeyEntry. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        TransformerMoveKeyEntry.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        TransformerMoveKeyEntry.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 source: builtins.str,
                 target: builtins.str,
                 overwrite_if_exists: Optional[builtins.bool] = None):
        pulumi.set(__self__, "source", source)
        pulumi.set(__self__, "target", target)
        if overwrite_if_exists is not None:
            pulumi.set(__self__, "overwrite_if_exists", overwrite_if_exists)

    @property
    @pulumi.getter
    def source(self) -> builtins.str:
        return pulumi.get(self, "source")

    @property
    @pulumi.getter
    def target(self) -> builtins.str:
        return pulumi.get(self, "target")

    @property
    @pulumi.getter(name="overwriteIfExists")
    def overwrite_if_exists(self) -> Optional[builtins.bool]:
        return pulumi.get(self, "overwrite_if_exists")


@pulumi.output_type
class TransformerParseCloudfront(dict):
    def __init__(__self__, *,
                 source: Optional[builtins.str] = None):
        """
        :param builtins.str source: Omit this parameter and the whole log message will be processed by this processor. No other value than `@message` is allowed for `source` .
        """
        if source is not None:
            pulumi.set(__self__, "source", source)

    @property
    @pulumi.getter
    def source(self) -> Optional[builtins.str]:
        """
        Omit this parameter and the whole log message will be processed by this processor. No other value than `@message` is allowed for `source` .
        """
        return pulumi.get(self, "source")


@pulumi.output_type
class TransformerParsePostgres(dict):
    def __init__(__self__, *,
                 source: Optional[builtins.str] = None):
        """
        :param builtins.str source: Omit this parameter and the whole log message will be processed by this processor. No other value than `@message` is allowed for `source` .
        """
        if source is not None:
            pulumi.set(__self__, "source", source)

    @property
    @pulumi.getter
    def source(self) -> Optional[builtins.str]:
        """
        Omit this parameter and the whole log message will be processed by this processor. No other value than `@message` is allowed for `source` .
        """
        return pulumi.get(self, "source")


@pulumi.output_type
class TransformerParseRoute53(dict):
    def __init__(__self__, *,
                 source: Optional[builtins.str] = None):
        """
        :param builtins.str source: Omit this parameter and the whole log message will be processed by this processor. No other value than `@message` is allowed for `source` .
        """
        if source is not None:
            pulumi.set(__self__, "source", source)

    @property
    @pulumi.getter
    def source(self) -> Optional[builtins.str]:
        """
        Omit this parameter and the whole log message will be processed by this processor. No other value than `@message` is allowed for `source` .
        """
        return pulumi.get(self, "source")


@pulumi.output_type
class TransformerParseVpc(dict):
    def __init__(__self__, *,
                 source: Optional[builtins.str] = None):
        """
        :param builtins.str source: Omit this parameter and the whole log message will be processed by this processor. No other value than `@message` is allowed for `source` .
        """
        if source is not None:
            pulumi.set(__self__, "source", source)

    @property
    @pulumi.getter
    def source(self) -> Optional[builtins.str]:
        """
        Omit this parameter and the whole log message will be processed by this processor. No other value than `@message` is allowed for `source` .
        """
        return pulumi.get(self, "source")


@pulumi.output_type
class TransformerParseWaf(dict):
    def __init__(__self__, *,
                 source: Optional[builtins.str] = None):
        """
        :param builtins.str source: Omit this parameter and the whole log message will be processed by this processor. No other value than `@message` is allowed for `source` .
        """
        if source is not None:
            pulumi.set(__self__, "source", source)

    @property
    @pulumi.getter
    def source(self) -> Optional[builtins.str]:
        """
        Omit this parameter and the whole log message will be processed by this processor. No other value than `@message` is allowed for `source` .
        """
        return pulumi.get(self, "source")


@pulumi.output_type
class TransformerProcessor(dict):
    """
    Individual processor configuration
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "addKeys":
            suggest = "add_keys"
        elif key == "copyValue":
            suggest = "copy_value"
        elif key == "dateTimeConverter":
            suggest = "date_time_converter"
        elif key == "deleteKeys":
            suggest = "delete_keys"
        elif key == "listToMap":
            suggest = "list_to_map"
        elif key == "lowerCaseString":
            suggest = "lower_case_string"
        elif key == "moveKeys":
            suggest = "move_keys"
        elif key == "parseCloudfront":
            suggest = "parse_cloudfront"
        elif key == "parseJson":
            suggest = "parse_json"
        elif key == "parseKeyValue":
            suggest = "parse_key_value"
        elif key == "parsePostgres":
            suggest = "parse_postgres"
        elif key == "parseRoute53":
            suggest = "parse_route53"
        elif key == "parseVpc":
            suggest = "parse_vpc"
        elif key == "parseWaf":
            suggest = "parse_waf"
        elif key == "renameKeys":
            suggest = "rename_keys"
        elif key == "splitString":
            suggest = "split_string"
        elif key == "substituteString":
            suggest = "substitute_string"
        elif key == "trimString":
            suggest = "trim_string"
        elif key == "typeConverter":
            suggest = "type_converter"
        elif key == "upperCaseString":
            suggest = "upper_case_string"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in TransformerProcessor. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        TransformerProcessor.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        TransformerProcessor.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 add_keys: Optional['outputs.TransformerProcessorAddKeysProperties'] = None,
                 copy_value: Optional['outputs.TransformerProcessorCopyValueProperties'] = None,
                 csv: Optional['outputs.TransformerProcessorCsvProperties'] = None,
                 date_time_converter: Optional['outputs.TransformerProcessorDateTimeConverterProperties'] = None,
                 delete_keys: Optional['outputs.TransformerProcessorDeleteKeysProperties'] = None,
                 grok: Optional['outputs.TransformerProcessorGrokProperties'] = None,
                 list_to_map: Optional['outputs.TransformerProcessorListToMapProperties'] = None,
                 lower_case_string: Optional['outputs.TransformerProcessorLowerCaseStringProperties'] = None,
                 move_keys: Optional['outputs.TransformerProcessorMoveKeysProperties'] = None,
                 parse_cloudfront: Optional['outputs.TransformerParseCloudfront'] = None,
                 parse_json: Optional['outputs.TransformerProcessorParseJsonProperties'] = None,
                 parse_key_value: Optional['outputs.TransformerProcessorParseKeyValueProperties'] = None,
                 parse_postgres: Optional['outputs.TransformerParsePostgres'] = None,
                 parse_route53: Optional['outputs.TransformerParseRoute53'] = None,
                 parse_vpc: Optional['outputs.TransformerParseVpc'] = None,
                 parse_waf: Optional['outputs.TransformerParseWaf'] = None,
                 rename_keys: Optional['outputs.TransformerProcessorRenameKeysProperties'] = None,
                 split_string: Optional['outputs.TransformerProcessorSplitStringProperties'] = None,
                 substitute_string: Optional['outputs.TransformerProcessorSubstituteStringProperties'] = None,
                 trim_string: Optional['outputs.TransformerProcessorTrimStringProperties'] = None,
                 type_converter: Optional['outputs.TransformerProcessorTypeConverterProperties'] = None,
                 upper_case_string: Optional['outputs.TransformerProcessorUpperCaseStringProperties'] = None):
        """
        Individual processor configuration
        :param 'TransformerProcessorAddKeysProperties' add_keys: Use this parameter to include the [addKeys](https://docs.aws.amazon.com/AmazonCloudWatch/latest/logs/CloudWatch-Logs-Transformation.html#CloudWatch-Logs-Transformation-addKeys) processor in your transformer.
        :param 'TransformerProcessorCopyValueProperties' copy_value: Use this parameter to include the [copyValue](https://docs.aws.amazon.com/AmazonCloudWatch/latest/logs/CloudWatch-Logs-Transformation-Processors.html#CloudWatch-Logs-Transformation-copyValue) processor in your transformer.
        :param 'TransformerProcessorCsvProperties' csv: Use this parameter to include the [CSV](https://docs.aws.amazon.com/AmazonCloudWatch/latest/logs/CloudWatch-Logs-Transformation.html#CloudWatch-Logs-Transformation-CSV) processor in your transformer.
        :param 'TransformerProcessorDateTimeConverterProperties' date_time_converter: Use this parameter to include the [datetimeConverter](https://docs.aws.amazon.com/AmazonCloudWatch/latest/logs/CloudWatch-Logs-Transformation-Processors.html#CloudWatch-Logs-Transformation-datetimeConverter) processor in your transformer.
        :param 'TransformerProcessorDeleteKeysProperties' delete_keys: Use this parameter to include the [deleteKeys](https://docs.aws.amazon.com/AmazonCloudWatch/latest/logs/CloudWatch-Logs-Transformation.html#CloudWatch-Logs-Transformation-deleteKeys) processor in your transformer.
        :param 'TransformerProcessorGrokProperties' grok: Use this parameter to include the [grok](https://docs.aws.amazon.com/AmazonCloudWatch/latest/logs/CloudWatch-Logs-Transformation-Processors.html#CloudWatch-Logs-Transformation-grok) processor in your transformer.
        :param 'TransformerProcessorListToMapProperties' list_to_map: Use this parameter to include the [listToMap](https://docs.aws.amazon.com/AmazonCloudWatch/latest/logs/CloudWatch-Logs-Transformation.html#CloudWatch-Logs-Transformation-listToMap) processor in your transformer.
        :param 'TransformerProcessorLowerCaseStringProperties' lower_case_string: Use this parameter to include the [lowerCaseString](https://docs.aws.amazon.com/AmazonCloudWatch/latest/logs/CloudWatch-Logs-Transformation-Processors.html#CloudWatch-Logs-Transformation-lowerCaseString) processor in your transformer.
        :param 'TransformerProcessorMoveKeysProperties' move_keys: Use this parameter to include the [moveKeys](https://docs.aws.amazon.com/AmazonCloudWatch/latest/logs/CloudWatch-Logs-Transformation-Processors.html#CloudWatch-Logs-Transformation-moveKeys) processor in your transformer.
        :param 'TransformerParseCloudfront' parse_cloudfront: Use this parameter to include the [parseCloudfront](https://docs.aws.amazon.com/AmazonCloudWatch/latest/logs/CloudWatch-Logs-Transformation-Processors.html#CloudWatch-Logs-Transformation-parseCloudfront) processor in your transformer.
               
               If you use this processor, it must be the first processor in your transformer.
        :param 'TransformerProcessorParseJsonProperties' parse_json: Use this parameter to include the [parseJSON](https://docs.aws.amazon.com/AmazonCloudWatch/latest/logs/CloudWatch-Logs-Transformation-Processors.html#CloudWatch-Logs-Transformation-parseJSON) processor in your transformer.
        :param 'TransformerProcessorParseKeyValueProperties' parse_key_value: Use this parameter to include the [parseKeyValue](https://docs.aws.amazon.com/AmazonCloudWatch/latest/logs/CloudWatch-Logs-Transformation-Processors.html#CloudWatch-Logs-Transformation-parseKeyValue) processor in your transformer.
        :param 'TransformerParsePostgres' parse_postgres: Use this parameter to include the [parsePostGres](https://docs.aws.amazon.com/AmazonCloudWatch/latest/logs/CloudWatch-Logs-Transformation.html#CloudWatch-Logs-Transformation-parsePostGres) processor in your transformer.
               
               If you use this processor, it must be the first processor in your transformer.
        :param 'TransformerParseRoute53' parse_route53: Use this parameter to include the [parseRoute53](https://docs.aws.amazon.com/AmazonCloudWatch/latest/logs/CloudWatch-Logs-Transformation-Processors.html#CloudWatch-Logs-Transformation-parseRoute53) processor in your transformer.
               
               If you use this processor, it must be the first processor in your transformer.
        :param 'TransformerParseVpc' parse_vpc: Use this parameter to include the [parseVPC](https://docs.aws.amazon.com/AmazonCloudWatch/latest/logs/CloudWatch-Logs-Transformation-Processors.html#CloudWatch-Logs-Transformation-parseVPC) processor in your transformer.
               
               If you use this processor, it must be the first processor in your transformer.
        :param 'TransformerParseWaf' parse_waf: Use this parameter to include the [parseWAF](https://docs.aws.amazon.com/AmazonCloudWatch/latest/logs/CloudWatch-Logs-Transformation.html#CloudWatch-Logs-Transformation-parseWAF) processor in your transformer.
               
               If you use this processor, it must be the first processor in your transformer.
        :param 'TransformerProcessorRenameKeysProperties' rename_keys: Use this parameter to include the [renameKeys](https://docs.aws.amazon.com/AmazonCloudWatch/latest/logs/CloudWatch-Logs-Transformation.html#CloudWatch-Logs-Transformation-renameKeys) processor in your transformer.
        :param 'TransformerProcessorSplitStringProperties' split_string: Use this parameter to include the [splitString](https://docs.aws.amazon.com/AmazonCloudWatch/latest/logs/CloudWatch-Logs-Transformation-Processors.html#CloudWatch-Logs-Transformation-splitString) processor in your transformer.
        :param 'TransformerProcessorSubstituteStringProperties' substitute_string: Use this parameter to include the [substituteString](https://docs.aws.amazon.com/AmazonCloudWatch/latest/logs/CloudWatch-Logs-Transformation-Processors.html#CloudWatch-Logs-Transformation-substituteString) processor in your transformer.
        :param 'TransformerProcessorTrimStringProperties' trim_string: Use this parameter to include the [trimString](https://docs.aws.amazon.com/AmazonCloudWatch/latest/logs/CloudWatch-Logs-Transformation-Processors.html#CloudWatch-Logs-Transformation-trimString) processor in your transformer.
        :param 'TransformerProcessorTypeConverterProperties' type_converter: Use this parameter to include the [typeConverter](https://docs.aws.amazon.com/AmazonCloudWatch/latest/logs/CloudWatch-Logs-Transformation-Processors.html#CloudWatch-Logs-Transformation-typeConverter) processor in your transformer.
        :param 'TransformerProcessorUpperCaseStringProperties' upper_case_string: Use this parameter to include the [upperCaseString](https://docs.aws.amazon.com/AmazonCloudWatch/latest/logs/CloudWatch-Logs-Transformation-Processors.html#CloudWatch-Logs-Transformation-upperCaseString) processor in your transformer.
        """
        if add_keys is not None:
            pulumi.set(__self__, "add_keys", add_keys)
        if copy_value is not None:
            pulumi.set(__self__, "copy_value", copy_value)
        if csv is not None:
            pulumi.set(__self__, "csv", csv)
        if date_time_converter is not None:
            pulumi.set(__self__, "date_time_converter", date_time_converter)
        if delete_keys is not None:
            pulumi.set(__self__, "delete_keys", delete_keys)
        if grok is not None:
            pulumi.set(__self__, "grok", grok)
        if list_to_map is not None:
            pulumi.set(__self__, "list_to_map", list_to_map)
        if lower_case_string is not None:
            pulumi.set(__self__, "lower_case_string", lower_case_string)
        if move_keys is not None:
            pulumi.set(__self__, "move_keys", move_keys)
        if parse_cloudfront is not None:
            pulumi.set(__self__, "parse_cloudfront", parse_cloudfront)
        if parse_json is not None:
            pulumi.set(__self__, "parse_json", parse_json)
        if parse_key_value is not None:
            pulumi.set(__self__, "parse_key_value", parse_key_value)
        if parse_postgres is not None:
            pulumi.set(__self__, "parse_postgres", parse_postgres)
        if parse_route53 is not None:
            pulumi.set(__self__, "parse_route53", parse_route53)
        if parse_vpc is not None:
            pulumi.set(__self__, "parse_vpc", parse_vpc)
        if parse_waf is not None:
            pulumi.set(__self__, "parse_waf", parse_waf)
        if rename_keys is not None:
            pulumi.set(__self__, "rename_keys", rename_keys)
        if split_string is not None:
            pulumi.set(__self__, "split_string", split_string)
        if substitute_string is not None:
            pulumi.set(__self__, "substitute_string", substitute_string)
        if trim_string is not None:
            pulumi.set(__self__, "trim_string", trim_string)
        if type_converter is not None:
            pulumi.set(__self__, "type_converter", type_converter)
        if upper_case_string is not None:
            pulumi.set(__self__, "upper_case_string", upper_case_string)

    @property
    @pulumi.getter(name="addKeys")
    def add_keys(self) -> Optional['outputs.TransformerProcessorAddKeysProperties']:
        """
        Use this parameter to include the [addKeys](https://docs.aws.amazon.com/AmazonCloudWatch/latest/logs/CloudWatch-Logs-Transformation.html#CloudWatch-Logs-Transformation-addKeys) processor in your transformer.
        """
        return pulumi.get(self, "add_keys")

    @property
    @pulumi.getter(name="copyValue")
    def copy_value(self) -> Optional['outputs.TransformerProcessorCopyValueProperties']:
        """
        Use this parameter to include the [copyValue](https://docs.aws.amazon.com/AmazonCloudWatch/latest/logs/CloudWatch-Logs-Transformation-Processors.html#CloudWatch-Logs-Transformation-copyValue) processor in your transformer.
        """
        return pulumi.get(self, "copy_value")

    @property
    @pulumi.getter
    def csv(self) -> Optional['outputs.TransformerProcessorCsvProperties']:
        """
        Use this parameter to include the [CSV](https://docs.aws.amazon.com/AmazonCloudWatch/latest/logs/CloudWatch-Logs-Transformation.html#CloudWatch-Logs-Transformation-CSV) processor in your transformer.
        """
        return pulumi.get(self, "csv")

    @property
    @pulumi.getter(name="dateTimeConverter")
    def date_time_converter(self) -> Optional['outputs.TransformerProcessorDateTimeConverterProperties']:
        """
        Use this parameter to include the [datetimeConverter](https://docs.aws.amazon.com/AmazonCloudWatch/latest/logs/CloudWatch-Logs-Transformation-Processors.html#CloudWatch-Logs-Transformation-datetimeConverter) processor in your transformer.
        """
        return pulumi.get(self, "date_time_converter")

    @property
    @pulumi.getter(name="deleteKeys")
    def delete_keys(self) -> Optional['outputs.TransformerProcessorDeleteKeysProperties']:
        """
        Use this parameter to include the [deleteKeys](https://docs.aws.amazon.com/AmazonCloudWatch/latest/logs/CloudWatch-Logs-Transformation.html#CloudWatch-Logs-Transformation-deleteKeys) processor in your transformer.
        """
        return pulumi.get(self, "delete_keys")

    @property
    @pulumi.getter
    def grok(self) -> Optional['outputs.TransformerProcessorGrokProperties']:
        """
        Use this parameter to include the [grok](https://docs.aws.amazon.com/AmazonCloudWatch/latest/logs/CloudWatch-Logs-Transformation-Processors.html#CloudWatch-Logs-Transformation-grok) processor in your transformer.
        """
        return pulumi.get(self, "grok")

    @property
    @pulumi.getter(name="listToMap")
    def list_to_map(self) -> Optional['outputs.TransformerProcessorListToMapProperties']:
        """
        Use this parameter to include the [listToMap](https://docs.aws.amazon.com/AmazonCloudWatch/latest/logs/CloudWatch-Logs-Transformation.html#CloudWatch-Logs-Transformation-listToMap) processor in your transformer.
        """
        return pulumi.get(self, "list_to_map")

    @property
    @pulumi.getter(name="lowerCaseString")
    def lower_case_string(self) -> Optional['outputs.TransformerProcessorLowerCaseStringProperties']:
        """
        Use this parameter to include the [lowerCaseString](https://docs.aws.amazon.com/AmazonCloudWatch/latest/logs/CloudWatch-Logs-Transformation-Processors.html#CloudWatch-Logs-Transformation-lowerCaseString) processor in your transformer.
        """
        return pulumi.get(self, "lower_case_string")

    @property
    @pulumi.getter(name="moveKeys")
    def move_keys(self) -> Optional['outputs.TransformerProcessorMoveKeysProperties']:
        """
        Use this parameter to include the [moveKeys](https://docs.aws.amazon.com/AmazonCloudWatch/latest/logs/CloudWatch-Logs-Transformation-Processors.html#CloudWatch-Logs-Transformation-moveKeys) processor in your transformer.
        """
        return pulumi.get(self, "move_keys")

    @property
    @pulumi.getter(name="parseCloudfront")
    def parse_cloudfront(self) -> Optional['outputs.TransformerParseCloudfront']:
        """
        Use this parameter to include the [parseCloudfront](https://docs.aws.amazon.com/AmazonCloudWatch/latest/logs/CloudWatch-Logs-Transformation-Processors.html#CloudWatch-Logs-Transformation-parseCloudfront) processor in your transformer.

        If you use this processor, it must be the first processor in your transformer.
        """
        return pulumi.get(self, "parse_cloudfront")

    @property
    @pulumi.getter(name="parseJson")
    def parse_json(self) -> Optional['outputs.TransformerProcessorParseJsonProperties']:
        """
        Use this parameter to include the [parseJSON](https://docs.aws.amazon.com/AmazonCloudWatch/latest/logs/CloudWatch-Logs-Transformation-Processors.html#CloudWatch-Logs-Transformation-parseJSON) processor in your transformer.
        """
        return pulumi.get(self, "parse_json")

    @property
    @pulumi.getter(name="parseKeyValue")
    def parse_key_value(self) -> Optional['outputs.TransformerProcessorParseKeyValueProperties']:
        """
        Use this parameter to include the [parseKeyValue](https://docs.aws.amazon.com/AmazonCloudWatch/latest/logs/CloudWatch-Logs-Transformation-Processors.html#CloudWatch-Logs-Transformation-parseKeyValue) processor in your transformer.
        """
        return pulumi.get(self, "parse_key_value")

    @property
    @pulumi.getter(name="parsePostgres")
    def parse_postgres(self) -> Optional['outputs.TransformerParsePostgres']:
        """
        Use this parameter to include the [parsePostGres](https://docs.aws.amazon.com/AmazonCloudWatch/latest/logs/CloudWatch-Logs-Transformation.html#CloudWatch-Logs-Transformation-parsePostGres) processor in your transformer.

        If you use this processor, it must be the first processor in your transformer.
        """
        return pulumi.get(self, "parse_postgres")

    @property
    @pulumi.getter(name="parseRoute53")
    def parse_route53(self) -> Optional['outputs.TransformerParseRoute53']:
        """
        Use this parameter to include the [parseRoute53](https://docs.aws.amazon.com/AmazonCloudWatch/latest/logs/CloudWatch-Logs-Transformation-Processors.html#CloudWatch-Logs-Transformation-parseRoute53) processor in your transformer.

        If you use this processor, it must be the first processor in your transformer.
        """
        return pulumi.get(self, "parse_route53")

    @property
    @pulumi.getter(name="parseVpc")
    def parse_vpc(self) -> Optional['outputs.TransformerParseVpc']:
        """
        Use this parameter to include the [parseVPC](https://docs.aws.amazon.com/AmazonCloudWatch/latest/logs/CloudWatch-Logs-Transformation-Processors.html#CloudWatch-Logs-Transformation-parseVPC) processor in your transformer.

        If you use this processor, it must be the first processor in your transformer.
        """
        return pulumi.get(self, "parse_vpc")

    @property
    @pulumi.getter(name="parseWaf")
    def parse_waf(self) -> Optional['outputs.TransformerParseWaf']:
        """
        Use this parameter to include the [parseWAF](https://docs.aws.amazon.com/AmazonCloudWatch/latest/logs/CloudWatch-Logs-Transformation.html#CloudWatch-Logs-Transformation-parseWAF) processor in your transformer.

        If you use this processor, it must be the first processor in your transformer.
        """
        return pulumi.get(self, "parse_waf")

    @property
    @pulumi.getter(name="renameKeys")
    def rename_keys(self) -> Optional['outputs.TransformerProcessorRenameKeysProperties']:
        """
        Use this parameter to include the [renameKeys](https://docs.aws.amazon.com/AmazonCloudWatch/latest/logs/CloudWatch-Logs-Transformation.html#CloudWatch-Logs-Transformation-renameKeys) processor in your transformer.
        """
        return pulumi.get(self, "rename_keys")

    @property
    @pulumi.getter(name="splitString")
    def split_string(self) -> Optional['outputs.TransformerProcessorSplitStringProperties']:
        """
        Use this parameter to include the [splitString](https://docs.aws.amazon.com/AmazonCloudWatch/latest/logs/CloudWatch-Logs-Transformation-Processors.html#CloudWatch-Logs-Transformation-splitString) processor in your transformer.
        """
        return pulumi.get(self, "split_string")

    @property
    @pulumi.getter(name="substituteString")
    def substitute_string(self) -> Optional['outputs.TransformerProcessorSubstituteStringProperties']:
        """
        Use this parameter to include the [substituteString](https://docs.aws.amazon.com/AmazonCloudWatch/latest/logs/CloudWatch-Logs-Transformation-Processors.html#CloudWatch-Logs-Transformation-substituteString) processor in your transformer.
        """
        return pulumi.get(self, "substitute_string")

    @property
    @pulumi.getter(name="trimString")
    def trim_string(self) -> Optional['outputs.TransformerProcessorTrimStringProperties']:
        """
        Use this parameter to include the [trimString](https://docs.aws.amazon.com/AmazonCloudWatch/latest/logs/CloudWatch-Logs-Transformation-Processors.html#CloudWatch-Logs-Transformation-trimString) processor in your transformer.
        """
        return pulumi.get(self, "trim_string")

    @property
    @pulumi.getter(name="typeConverter")
    def type_converter(self) -> Optional['outputs.TransformerProcessorTypeConverterProperties']:
        """
        Use this parameter to include the [typeConverter](https://docs.aws.amazon.com/AmazonCloudWatch/latest/logs/CloudWatch-Logs-Transformation-Processors.html#CloudWatch-Logs-Transformation-typeConverter) processor in your transformer.
        """
        return pulumi.get(self, "type_converter")

    @property
    @pulumi.getter(name="upperCaseString")
    def upper_case_string(self) -> Optional['outputs.TransformerProcessorUpperCaseStringProperties']:
        """
        Use this parameter to include the [upperCaseString](https://docs.aws.amazon.com/AmazonCloudWatch/latest/logs/CloudWatch-Logs-Transformation-Processors.html#CloudWatch-Logs-Transformation-upperCaseString) processor in your transformer.
        """
        return pulumi.get(self, "upper_case_string")


@pulumi.output_type
class TransformerProcessorAddKeysProperties(dict):
    """
    Use this parameter to include the [addKeys](https://docs.aws.amazon.com/AmazonCloudWatch/latest/logs/CloudWatch-Logs-Transformation.html#CloudWatch-Logs-Transformation-addKeys) processor in your transformer.
    """
    def __init__(__self__, *,
                 entries: Sequence['outputs.TransformerAddKeyEntry']):
        """
        Use this parameter to include the [addKeys](https://docs.aws.amazon.com/AmazonCloudWatch/latest/logs/CloudWatch-Logs-Transformation.html#CloudWatch-Logs-Transformation-addKeys) processor in your transformer.
        """
        pulumi.set(__self__, "entries", entries)

    @property
    @pulumi.getter
    def entries(self) -> Sequence['outputs.TransformerAddKeyEntry']:
        return pulumi.get(self, "entries")


@pulumi.output_type
class TransformerProcessorCopyValueProperties(dict):
    """
    Use this parameter to include the [copyValue](https://docs.aws.amazon.com/AmazonCloudWatch/latest/logs/CloudWatch-Logs-Transformation-Processors.html#CloudWatch-Logs-Transformation-copyValue) processor in your transformer.
    """
    def __init__(__self__, *,
                 entries: Sequence['outputs.TransformerCopyValueEntry']):
        """
        Use this parameter to include the [copyValue](https://docs.aws.amazon.com/AmazonCloudWatch/latest/logs/CloudWatch-Logs-Transformation-Processors.html#CloudWatch-Logs-Transformation-copyValue) processor in your transformer.
        """
        pulumi.set(__self__, "entries", entries)

    @property
    @pulumi.getter
    def entries(self) -> Sequence['outputs.TransformerCopyValueEntry']:
        return pulumi.get(self, "entries")


@pulumi.output_type
class TransformerProcessorCsvProperties(dict):
    """
    Use this parameter to include the [CSV](https://docs.aws.amazon.com/AmazonCloudWatch/latest/logs/CloudWatch-Logs-Transformation.html#CloudWatch-Logs-Transformation-CSV) processor in your transformer.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "quoteCharacter":
            suggest = "quote_character"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in TransformerProcessorCsvProperties. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        TransformerProcessorCsvProperties.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        TransformerProcessorCsvProperties.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 columns: Optional[Sequence[builtins.str]] = None,
                 delimiter: Optional[builtins.str] = None,
                 quote_character: Optional[builtins.str] = None,
                 source: Optional[builtins.str] = None):
        """
        Use this parameter to include the [CSV](https://docs.aws.amazon.com/AmazonCloudWatch/latest/logs/CloudWatch-Logs-Transformation.html#CloudWatch-Logs-Transformation-CSV) processor in your transformer.
        """
        if columns is not None:
            pulumi.set(__self__, "columns", columns)
        if delimiter is not None:
            pulumi.set(__self__, "delimiter", delimiter)
        if quote_character is not None:
            pulumi.set(__self__, "quote_character", quote_character)
        if source is not None:
            pulumi.set(__self__, "source", source)

    @property
    @pulumi.getter
    def columns(self) -> Optional[Sequence[builtins.str]]:
        return pulumi.get(self, "columns")

    @property
    @pulumi.getter
    def delimiter(self) -> Optional[builtins.str]:
        return pulumi.get(self, "delimiter")

    @property
    @pulumi.getter(name="quoteCharacter")
    def quote_character(self) -> Optional[builtins.str]:
        return pulumi.get(self, "quote_character")

    @property
    @pulumi.getter
    def source(self) -> Optional[builtins.str]:
        return pulumi.get(self, "source")


@pulumi.output_type
class TransformerProcessorDateTimeConverterProperties(dict):
    """
    Use this parameter to include the [datetimeConverter](https://docs.aws.amazon.com/AmazonCloudWatch/latest/logs/CloudWatch-Logs-Transformation-Processors.html#CloudWatch-Logs-Transformation-datetimeConverter) processor in your transformer.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "matchPatterns":
            suggest = "match_patterns"
        elif key == "sourceTimezone":
            suggest = "source_timezone"
        elif key == "targetFormat":
            suggest = "target_format"
        elif key == "targetTimezone":
            suggest = "target_timezone"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in TransformerProcessorDateTimeConverterProperties. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        TransformerProcessorDateTimeConverterProperties.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        TransformerProcessorDateTimeConverterProperties.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 match_patterns: Sequence[builtins.str],
                 source: builtins.str,
                 target: builtins.str,
                 locale: Optional[builtins.str] = None,
                 source_timezone: Optional[builtins.str] = None,
                 target_format: Optional[builtins.str] = None,
                 target_timezone: Optional[builtins.str] = None):
        """
        Use this parameter to include the [datetimeConverter](https://docs.aws.amazon.com/AmazonCloudWatch/latest/logs/CloudWatch-Logs-Transformation-Processors.html#CloudWatch-Logs-Transformation-datetimeConverter) processor in your transformer.
        """
        pulumi.set(__self__, "match_patterns", match_patterns)
        pulumi.set(__self__, "source", source)
        pulumi.set(__self__, "target", target)
        if locale is not None:
            pulumi.set(__self__, "locale", locale)
        if source_timezone is not None:
            pulumi.set(__self__, "source_timezone", source_timezone)
        if target_format is not None:
            pulumi.set(__self__, "target_format", target_format)
        if target_timezone is not None:
            pulumi.set(__self__, "target_timezone", target_timezone)

    @property
    @pulumi.getter(name="matchPatterns")
    def match_patterns(self) -> Sequence[builtins.str]:
        return pulumi.get(self, "match_patterns")

    @property
    @pulumi.getter
    def source(self) -> builtins.str:
        return pulumi.get(self, "source")

    @property
    @pulumi.getter
    def target(self) -> builtins.str:
        return pulumi.get(self, "target")

    @property
    @pulumi.getter
    def locale(self) -> Optional[builtins.str]:
        return pulumi.get(self, "locale")

    @property
    @pulumi.getter(name="sourceTimezone")
    def source_timezone(self) -> Optional[builtins.str]:
        return pulumi.get(self, "source_timezone")

    @property
    @pulumi.getter(name="targetFormat")
    def target_format(self) -> Optional[builtins.str]:
        return pulumi.get(self, "target_format")

    @property
    @pulumi.getter(name="targetTimezone")
    def target_timezone(self) -> Optional[builtins.str]:
        return pulumi.get(self, "target_timezone")


@pulumi.output_type
class TransformerProcessorDeleteKeysProperties(dict):
    """
    Use this parameter to include the [deleteKeys](https://docs.aws.amazon.com/AmazonCloudWatch/latest/logs/CloudWatch-Logs-Transformation.html#CloudWatch-Logs-Transformation-deleteKeys) processor in your transformer.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "withKeys":
            suggest = "with_keys"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in TransformerProcessorDeleteKeysProperties. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        TransformerProcessorDeleteKeysProperties.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        TransformerProcessorDeleteKeysProperties.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 with_keys: Sequence[builtins.str]):
        """
        Use this parameter to include the [deleteKeys](https://docs.aws.amazon.com/AmazonCloudWatch/latest/logs/CloudWatch-Logs-Transformation.html#CloudWatch-Logs-Transformation-deleteKeys) processor in your transformer.
        """
        pulumi.set(__self__, "with_keys", with_keys)

    @property
    @pulumi.getter(name="withKeys")
    def with_keys(self) -> Sequence[builtins.str]:
        return pulumi.get(self, "with_keys")


@pulumi.output_type
class TransformerProcessorGrokProperties(dict):
    """
    Use this parameter to include the [grok](https://docs.aws.amazon.com/AmazonCloudWatch/latest/logs/CloudWatch-Logs-Transformation-Processors.html#CloudWatch-Logs-Transformation-grok) processor in your transformer.
    """
    def __init__(__self__, *,
                 match: builtins.str,
                 source: Optional[builtins.str] = None):
        """
        Use this parameter to include the [grok](https://docs.aws.amazon.com/AmazonCloudWatch/latest/logs/CloudWatch-Logs-Transformation-Processors.html#CloudWatch-Logs-Transformation-grok) processor in your transformer.
        """
        pulumi.set(__self__, "match", match)
        if source is not None:
            pulumi.set(__self__, "source", source)

    @property
    @pulumi.getter
    def match(self) -> builtins.str:
        return pulumi.get(self, "match")

    @property
    @pulumi.getter
    def source(self) -> Optional[builtins.str]:
        return pulumi.get(self, "source")


@pulumi.output_type
class TransformerProcessorListToMapProperties(dict):
    """
    Use this parameter to include the [listToMap](https://docs.aws.amazon.com/AmazonCloudWatch/latest/logs/CloudWatch-Logs-Transformation.html#CloudWatch-Logs-Transformation-listToMap) processor in your transformer.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "flattenedElement":
            suggest = "flattened_element"
        elif key == "valueKey":
            suggest = "value_key"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in TransformerProcessorListToMapProperties. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        TransformerProcessorListToMapProperties.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        TransformerProcessorListToMapProperties.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 key: builtins.str,
                 source: builtins.str,
                 flatten: Optional[builtins.bool] = None,
                 flattened_element: Optional['TransformerProcessorListToMapPropertiesFlattenedElement'] = None,
                 target: Optional[builtins.str] = None,
                 value_key: Optional[builtins.str] = None):
        """
        Use this parameter to include the [listToMap](https://docs.aws.amazon.com/AmazonCloudWatch/latest/logs/CloudWatch-Logs-Transformation.html#CloudWatch-Logs-Transformation-listToMap) processor in your transformer.
        """
        pulumi.set(__self__, "key", key)
        pulumi.set(__self__, "source", source)
        if flatten is not None:
            pulumi.set(__self__, "flatten", flatten)
        if flattened_element is not None:
            pulumi.set(__self__, "flattened_element", flattened_element)
        if target is not None:
            pulumi.set(__self__, "target", target)
        if value_key is not None:
            pulumi.set(__self__, "value_key", value_key)

    @property
    @pulumi.getter
    def key(self) -> builtins.str:
        return pulumi.get(self, "key")

    @property
    @pulumi.getter
    def source(self) -> builtins.str:
        return pulumi.get(self, "source")

    @property
    @pulumi.getter
    def flatten(self) -> Optional[builtins.bool]:
        return pulumi.get(self, "flatten")

    @property
    @pulumi.getter(name="flattenedElement")
    def flattened_element(self) -> Optional['TransformerProcessorListToMapPropertiesFlattenedElement']:
        return pulumi.get(self, "flattened_element")

    @property
    @pulumi.getter
    def target(self) -> Optional[builtins.str]:
        return pulumi.get(self, "target")

    @property
    @pulumi.getter(name="valueKey")
    def value_key(self) -> Optional[builtins.str]:
        return pulumi.get(self, "value_key")


@pulumi.output_type
class TransformerProcessorLowerCaseStringProperties(dict):
    """
    Use this parameter to include the [lowerCaseString](https://docs.aws.amazon.com/AmazonCloudWatch/latest/logs/CloudWatch-Logs-Transformation-Processors.html#CloudWatch-Logs-Transformation-lowerCaseString) processor in your transformer.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "withKeys":
            suggest = "with_keys"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in TransformerProcessorLowerCaseStringProperties. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        TransformerProcessorLowerCaseStringProperties.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        TransformerProcessorLowerCaseStringProperties.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 with_keys: Sequence[builtins.str]):
        """
        Use this parameter to include the [lowerCaseString](https://docs.aws.amazon.com/AmazonCloudWatch/latest/logs/CloudWatch-Logs-Transformation-Processors.html#CloudWatch-Logs-Transformation-lowerCaseString) processor in your transformer.
        """
        pulumi.set(__self__, "with_keys", with_keys)

    @property
    @pulumi.getter(name="withKeys")
    def with_keys(self) -> Sequence[builtins.str]:
        return pulumi.get(self, "with_keys")


@pulumi.output_type
class TransformerProcessorMoveKeysProperties(dict):
    """
    Use this parameter to include the [moveKeys](https://docs.aws.amazon.com/AmazonCloudWatch/latest/logs/CloudWatch-Logs-Transformation-Processors.html#CloudWatch-Logs-Transformation-moveKeys) processor in your transformer.
    """
    def __init__(__self__, *,
                 entries: Sequence['outputs.TransformerMoveKeyEntry']):
        """
        Use this parameter to include the [moveKeys](https://docs.aws.amazon.com/AmazonCloudWatch/latest/logs/CloudWatch-Logs-Transformation-Processors.html#CloudWatch-Logs-Transformation-moveKeys) processor in your transformer.
        """
        pulumi.set(__self__, "entries", entries)

    @property
    @pulumi.getter
    def entries(self) -> Sequence['outputs.TransformerMoveKeyEntry']:
        return pulumi.get(self, "entries")


@pulumi.output_type
class TransformerProcessorParseJsonProperties(dict):
    """
    Use this parameter to include the [parseJSON](https://docs.aws.amazon.com/AmazonCloudWatch/latest/logs/CloudWatch-Logs-Transformation-Processors.html#CloudWatch-Logs-Transformation-parseJSON) processor in your transformer.
    """
    def __init__(__self__, *,
                 destination: Optional[builtins.str] = None,
                 source: Optional[builtins.str] = None):
        """
        Use this parameter to include the [parseJSON](https://docs.aws.amazon.com/AmazonCloudWatch/latest/logs/CloudWatch-Logs-Transformation-Processors.html#CloudWatch-Logs-Transformation-parseJSON) processor in your transformer.
        """
        if destination is not None:
            pulumi.set(__self__, "destination", destination)
        if source is not None:
            pulumi.set(__self__, "source", source)

    @property
    @pulumi.getter
    def destination(self) -> Optional[builtins.str]:
        return pulumi.get(self, "destination")

    @property
    @pulumi.getter
    def source(self) -> Optional[builtins.str]:
        return pulumi.get(self, "source")


@pulumi.output_type
class TransformerProcessorParseKeyValueProperties(dict):
    """
    Use this parameter to include the [parseKeyValue](https://docs.aws.amazon.com/AmazonCloudWatch/latest/logs/CloudWatch-Logs-Transformation-Processors.html#CloudWatch-Logs-Transformation-parseKeyValue) processor in your transformer.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "fieldDelimiter":
            suggest = "field_delimiter"
        elif key == "keyPrefix":
            suggest = "key_prefix"
        elif key == "keyValueDelimiter":
            suggest = "key_value_delimiter"
        elif key == "nonMatchValue":
            suggest = "non_match_value"
        elif key == "overwriteIfExists":
            suggest = "overwrite_if_exists"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in TransformerProcessorParseKeyValueProperties. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        TransformerProcessorParseKeyValueProperties.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        TransformerProcessorParseKeyValueProperties.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 destination: Optional[builtins.str] = None,
                 field_delimiter: Optional[builtins.str] = None,
                 key_prefix: Optional[builtins.str] = None,
                 key_value_delimiter: Optional[builtins.str] = None,
                 non_match_value: Optional[builtins.str] = None,
                 overwrite_if_exists: Optional[builtins.bool] = None,
                 source: Optional[builtins.str] = None):
        """
        Use this parameter to include the [parseKeyValue](https://docs.aws.amazon.com/AmazonCloudWatch/latest/logs/CloudWatch-Logs-Transformation-Processors.html#CloudWatch-Logs-Transformation-parseKeyValue) processor in your transformer.
        """
        if destination is not None:
            pulumi.set(__self__, "destination", destination)
        if field_delimiter is not None:
            pulumi.set(__self__, "field_delimiter", field_delimiter)
        if key_prefix is not None:
            pulumi.set(__self__, "key_prefix", key_prefix)
        if key_value_delimiter is not None:
            pulumi.set(__self__, "key_value_delimiter", key_value_delimiter)
        if non_match_value is not None:
            pulumi.set(__self__, "non_match_value", non_match_value)
        if overwrite_if_exists is not None:
            pulumi.set(__self__, "overwrite_if_exists", overwrite_if_exists)
        if source is not None:
            pulumi.set(__self__, "source", source)

    @property
    @pulumi.getter
    def destination(self) -> Optional[builtins.str]:
        return pulumi.get(self, "destination")

    @property
    @pulumi.getter(name="fieldDelimiter")
    def field_delimiter(self) -> Optional[builtins.str]:
        return pulumi.get(self, "field_delimiter")

    @property
    @pulumi.getter(name="keyPrefix")
    def key_prefix(self) -> Optional[builtins.str]:
        return pulumi.get(self, "key_prefix")

    @property
    @pulumi.getter(name="keyValueDelimiter")
    def key_value_delimiter(self) -> Optional[builtins.str]:
        return pulumi.get(self, "key_value_delimiter")

    @property
    @pulumi.getter(name="nonMatchValue")
    def non_match_value(self) -> Optional[builtins.str]:
        return pulumi.get(self, "non_match_value")

    @property
    @pulumi.getter(name="overwriteIfExists")
    def overwrite_if_exists(self) -> Optional[builtins.bool]:
        return pulumi.get(self, "overwrite_if_exists")

    @property
    @pulumi.getter
    def source(self) -> Optional[builtins.str]:
        return pulumi.get(self, "source")


@pulumi.output_type
class TransformerProcessorRenameKeysProperties(dict):
    """
    Use this parameter to include the [renameKeys](https://docs.aws.amazon.com/AmazonCloudWatch/latest/logs/CloudWatch-Logs-Transformation.html#CloudWatch-Logs-Transformation-renameKeys) processor in your transformer.
    """
    def __init__(__self__, *,
                 entries: Sequence['outputs.TransformerRenameKeyEntry']):
        """
        Use this parameter to include the [renameKeys](https://docs.aws.amazon.com/AmazonCloudWatch/latest/logs/CloudWatch-Logs-Transformation.html#CloudWatch-Logs-Transformation-renameKeys) processor in your transformer.
        """
        pulumi.set(__self__, "entries", entries)

    @property
    @pulumi.getter
    def entries(self) -> Sequence['outputs.TransformerRenameKeyEntry']:
        return pulumi.get(self, "entries")


@pulumi.output_type
class TransformerProcessorSplitStringProperties(dict):
    """
    Use this parameter to include the [splitString](https://docs.aws.amazon.com/AmazonCloudWatch/latest/logs/CloudWatch-Logs-Transformation-Processors.html#CloudWatch-Logs-Transformation-splitString) processor in your transformer.
    """
    def __init__(__self__, *,
                 entries: Sequence['outputs.TransformerSplitStringEntry']):
        """
        Use this parameter to include the [splitString](https://docs.aws.amazon.com/AmazonCloudWatch/latest/logs/CloudWatch-Logs-Transformation-Processors.html#CloudWatch-Logs-Transformation-splitString) processor in your transformer.
        """
        pulumi.set(__self__, "entries", entries)

    @property
    @pulumi.getter
    def entries(self) -> Sequence['outputs.TransformerSplitStringEntry']:
        return pulumi.get(self, "entries")


@pulumi.output_type
class TransformerProcessorSubstituteStringProperties(dict):
    """
    Use this parameter to include the [substituteString](https://docs.aws.amazon.com/AmazonCloudWatch/latest/logs/CloudWatch-Logs-Transformation-Processors.html#CloudWatch-Logs-Transformation-substituteString) processor in your transformer.
    """
    def __init__(__self__, *,
                 entries: Sequence['outputs.TransformerSubstituteStringEntry']):
        """
        Use this parameter to include the [substituteString](https://docs.aws.amazon.com/AmazonCloudWatch/latest/logs/CloudWatch-Logs-Transformation-Processors.html#CloudWatch-Logs-Transformation-substituteString) processor in your transformer.
        """
        pulumi.set(__self__, "entries", entries)

    @property
    @pulumi.getter
    def entries(self) -> Sequence['outputs.TransformerSubstituteStringEntry']:
        return pulumi.get(self, "entries")


@pulumi.output_type
class TransformerProcessorTrimStringProperties(dict):
    """
    Use this parameter to include the [trimString](https://docs.aws.amazon.com/AmazonCloudWatch/latest/logs/CloudWatch-Logs-Transformation-Processors.html#CloudWatch-Logs-Transformation-trimString) processor in your transformer.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "withKeys":
            suggest = "with_keys"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in TransformerProcessorTrimStringProperties. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        TransformerProcessorTrimStringProperties.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        TransformerProcessorTrimStringProperties.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 with_keys: Sequence[builtins.str]):
        """
        Use this parameter to include the [trimString](https://docs.aws.amazon.com/AmazonCloudWatch/latest/logs/CloudWatch-Logs-Transformation-Processors.html#CloudWatch-Logs-Transformation-trimString) processor in your transformer.
        """
        pulumi.set(__self__, "with_keys", with_keys)

    @property
    @pulumi.getter(name="withKeys")
    def with_keys(self) -> Sequence[builtins.str]:
        return pulumi.get(self, "with_keys")


@pulumi.output_type
class TransformerProcessorTypeConverterProperties(dict):
    """
    Use this parameter to include the [typeConverter](https://docs.aws.amazon.com/AmazonCloudWatch/latest/logs/CloudWatch-Logs-Transformation-Processors.html#CloudWatch-Logs-Transformation-typeConverter) processor in your transformer.
    """
    def __init__(__self__, *,
                 entries: Sequence['outputs.TransformerTypeConverterEntry']):
        """
        Use this parameter to include the [typeConverter](https://docs.aws.amazon.com/AmazonCloudWatch/latest/logs/CloudWatch-Logs-Transformation-Processors.html#CloudWatch-Logs-Transformation-typeConverter) processor in your transformer.
        """
        pulumi.set(__self__, "entries", entries)

    @property
    @pulumi.getter
    def entries(self) -> Sequence['outputs.TransformerTypeConverterEntry']:
        return pulumi.get(self, "entries")


@pulumi.output_type
class TransformerProcessorUpperCaseStringProperties(dict):
    """
    Use this parameter to include the [upperCaseString](https://docs.aws.amazon.com/AmazonCloudWatch/latest/logs/CloudWatch-Logs-Transformation-Processors.html#CloudWatch-Logs-Transformation-upperCaseString) processor in your transformer.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "withKeys":
            suggest = "with_keys"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in TransformerProcessorUpperCaseStringProperties. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        TransformerProcessorUpperCaseStringProperties.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        TransformerProcessorUpperCaseStringProperties.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 with_keys: Sequence[builtins.str]):
        """
        Use this parameter to include the [upperCaseString](https://docs.aws.amazon.com/AmazonCloudWatch/latest/logs/CloudWatch-Logs-Transformation-Processors.html#CloudWatch-Logs-Transformation-upperCaseString) processor in your transformer.
        """
        pulumi.set(__self__, "with_keys", with_keys)

    @property
    @pulumi.getter(name="withKeys")
    def with_keys(self) -> Sequence[builtins.str]:
        return pulumi.get(self, "with_keys")


@pulumi.output_type
class TransformerRenameKeyEntry(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "renameTo":
            suggest = "rename_to"
        elif key == "overwriteIfExists":
            suggest = "overwrite_if_exists"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in TransformerRenameKeyEntry. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        TransformerRenameKeyEntry.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        TransformerRenameKeyEntry.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 key: builtins.str,
                 rename_to: builtins.str,
                 overwrite_if_exists: Optional[builtins.bool] = None):
        pulumi.set(__self__, "key", key)
        pulumi.set(__self__, "rename_to", rename_to)
        if overwrite_if_exists is not None:
            pulumi.set(__self__, "overwrite_if_exists", overwrite_if_exists)

    @property
    @pulumi.getter
    def key(self) -> builtins.str:
        return pulumi.get(self, "key")

    @property
    @pulumi.getter(name="renameTo")
    def rename_to(self) -> builtins.str:
        return pulumi.get(self, "rename_to")

    @property
    @pulumi.getter(name="overwriteIfExists")
    def overwrite_if_exists(self) -> Optional[builtins.bool]:
        return pulumi.get(self, "overwrite_if_exists")


@pulumi.output_type
class TransformerSplitStringEntry(dict):
    def __init__(__self__, *,
                 delimiter: builtins.str,
                 source: builtins.str):
        pulumi.set(__self__, "delimiter", delimiter)
        pulumi.set(__self__, "source", source)

    @property
    @pulumi.getter
    def delimiter(self) -> builtins.str:
        return pulumi.get(self, "delimiter")

    @property
    @pulumi.getter
    def source(self) -> builtins.str:
        return pulumi.get(self, "source")


@pulumi.output_type
class TransformerSubstituteStringEntry(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "from":
            suggest = "from_"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in TransformerSubstituteStringEntry. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        TransformerSubstituteStringEntry.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        TransformerSubstituteStringEntry.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 from_: builtins.str,
                 source: builtins.str,
                 to: builtins.str):
        pulumi.set(__self__, "from_", from_)
        pulumi.set(__self__, "source", source)
        pulumi.set(__self__, "to", to)

    @property
    @pulumi.getter(name="from")
    def from_(self) -> builtins.str:
        return pulumi.get(self, "from_")

    @property
    @pulumi.getter
    def source(self) -> builtins.str:
        return pulumi.get(self, "source")

    @property
    @pulumi.getter
    def to(self) -> builtins.str:
        return pulumi.get(self, "to")


@pulumi.output_type
class TransformerTypeConverterEntry(dict):
    def __init__(__self__, *,
                 key: builtins.str,
                 type: 'TransformerTypeConverterEntryType'):
        pulumi.set(__self__, "key", key)
        pulumi.set(__self__, "type", type)

    @property
    @pulumi.getter
    def key(self) -> builtins.str:
        return pulumi.get(self, "key")

    @property
    @pulumi.getter
    def type(self) -> 'TransformerTypeConverterEntryType':
        return pulumi.get(self, "type")


