# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs
from ._enums import *
from ._inputs import *

__all__ = ['IntegrationArgs', 'Integration']

@pulumi.input_type
class IntegrationArgs:
    def __init__(__self__, *,
                 integration_type: pulumi.Input['IntegrationType'],
                 resource_config: pulumi.Input['ResourceConfigPropertiesArgs'],
                 integration_name: Optional[pulumi.Input[builtins.str]] = None):
        """
        The set of arguments for constructing a Integration resource.
        :param pulumi.Input['IntegrationType'] integration_type: The type of the Integration.
        :param pulumi.Input['ResourceConfigPropertiesArgs'] resource_config: OpenSearchResourceConfig for the given Integration
        :param pulumi.Input[builtins.str] integration_name: User provided identifier for integration, unique to the user account.
        """
        pulumi.set(__self__, "integration_type", integration_type)
        pulumi.set(__self__, "resource_config", resource_config)
        if integration_name is not None:
            pulumi.set(__self__, "integration_name", integration_name)

    @property
    @pulumi.getter(name="integrationType")
    def integration_type(self) -> pulumi.Input['IntegrationType']:
        """
        The type of the Integration.
        """
        return pulumi.get(self, "integration_type")

    @integration_type.setter
    def integration_type(self, value: pulumi.Input['IntegrationType']):
        pulumi.set(self, "integration_type", value)

    @property
    @pulumi.getter(name="resourceConfig")
    def resource_config(self) -> pulumi.Input['ResourceConfigPropertiesArgs']:
        """
        OpenSearchResourceConfig for the given Integration
        """
        return pulumi.get(self, "resource_config")

    @resource_config.setter
    def resource_config(self, value: pulumi.Input['ResourceConfigPropertiesArgs']):
        pulumi.set(self, "resource_config", value)

    @property
    @pulumi.getter(name="integrationName")
    def integration_name(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        User provided identifier for integration, unique to the user account.
        """
        return pulumi.get(self, "integration_name")

    @integration_name.setter
    def integration_name(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "integration_name", value)


@pulumi.type_token("aws-native:logs:Integration")
class Integration(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 integration_name: Optional[pulumi.Input[builtins.str]] = None,
                 integration_type: Optional[pulumi.Input['IntegrationType']] = None,
                 resource_config: Optional[pulumi.Input[Union['ResourceConfigPropertiesArgs', 'ResourceConfigPropertiesArgsDict']]] = None,
                 __props__=None):
        """
        Resource Schema for Logs Integration Resource

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[builtins.str] integration_name: User provided identifier for integration, unique to the user account.
        :param pulumi.Input['IntegrationType'] integration_type: The type of the Integration.
        :param pulumi.Input[Union['ResourceConfigPropertiesArgs', 'ResourceConfigPropertiesArgsDict']] resource_config: OpenSearchResourceConfig for the given Integration
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: IntegrationArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Resource Schema for Logs Integration Resource

        :param str resource_name: The name of the resource.
        :param IntegrationArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(IntegrationArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 integration_name: Optional[pulumi.Input[builtins.str]] = None,
                 integration_type: Optional[pulumi.Input['IntegrationType']] = None,
                 resource_config: Optional[pulumi.Input[Union['ResourceConfigPropertiesArgs', 'ResourceConfigPropertiesArgsDict']]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = IntegrationArgs.__new__(IntegrationArgs)

            __props__.__dict__["integration_name"] = integration_name
            if integration_type is None and not opts.urn:
                raise TypeError("Missing required property 'integration_type'")
            __props__.__dict__["integration_type"] = integration_type
            if resource_config is None and not opts.urn:
                raise TypeError("Missing required property 'resource_config'")
            __props__.__dict__["resource_config"] = resource_config
            __props__.__dict__["integration_status"] = None
        replace_on_changes = pulumi.ResourceOptions(replace_on_changes=["integrationName", "integrationType", "resourceConfig"])
        opts = pulumi.ResourceOptions.merge(opts, replace_on_changes)
        super(Integration, __self__).__init__(
            'aws-native:logs:Integration',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None) -> 'Integration':
        """
        Get an existing Integration resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = IntegrationArgs.__new__(IntegrationArgs)

        __props__.__dict__["integration_name"] = None
        __props__.__dict__["integration_status"] = None
        __props__.__dict__["integration_type"] = None
        __props__.__dict__["resource_config"] = None
        return Integration(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter(name="integrationName")
    def integration_name(self) -> pulumi.Output[builtins.str]:
        """
        User provided identifier for integration, unique to the user account.
        """
        return pulumi.get(self, "integration_name")

    @property
    @pulumi.getter(name="integrationStatus")
    def integration_status(self) -> pulumi.Output['IntegrationStatus']:
        """
        Status of creation for the Integration and its resources
        """
        return pulumi.get(self, "integration_status")

    @property
    @pulumi.getter(name="integrationType")
    def integration_type(self) -> pulumi.Output['IntegrationType']:
        """
        The type of the Integration.
        """
        return pulumi.get(self, "integration_type")

    @property
    @pulumi.getter(name="resourceConfig")
    def resource_config(self) -> pulumi.Output['outputs.ResourceConfigProperties']:
        """
        OpenSearchResourceConfig for the given Integration
        """
        return pulumi.get(self, "resource_config")

