# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs
from ._enums import *

__all__ = [
    'GetTransformerResult',
    'AwaitableGetTransformerResult',
    'get_transformer',
    'get_transformer_output',
]

@pulumi.output_type
class GetTransformerResult:
    def __init__(__self__, transformer_config=None):
        if transformer_config and not isinstance(transformer_config, list):
            raise TypeError("Expected argument 'transformer_config' to be a list")
        pulumi.set(__self__, "transformer_config", transformer_config)

    @property
    @pulumi.getter(name="transformerConfig")
    def transformer_config(self) -> Optional[Sequence['outputs.TransformerProcessor']]:
        """
        List of processors in a transformer
        """
        return pulumi.get(self, "transformer_config")


class AwaitableGetTransformerResult(GetTransformerResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetTransformerResult(
            transformer_config=self.transformer_config)


def get_transformer(log_group_identifier: Optional[builtins.str] = None,
                    opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetTransformerResult:
    """
    Specifies a transformer on the log group to transform logs into consistent structured and information rich format.


    :param builtins.str log_group_identifier: Existing log group that you want to associate with this transformer.
    """
    __args__ = dict()
    __args__['logGroupIdentifier'] = log_group_identifier
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('aws-native:logs:getTransformer', __args__, opts=opts, typ=GetTransformerResult).value

    return AwaitableGetTransformerResult(
        transformer_config=pulumi.get(__ret__, 'transformer_config'))
def get_transformer_output(log_group_identifier: Optional[pulumi.Input[builtins.str]] = None,
                           opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetTransformerResult]:
    """
    Specifies a transformer on the log group to transform logs into consistent structured and information rich format.


    :param builtins.str log_group_identifier: Existing log group that you want to associate with this transformer.
    """
    __args__ = dict()
    __args__['logGroupIdentifier'] = log_group_identifier
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('aws-native:logs:getTransformer', __args__, opts=opts, typ=GetTransformerResult)
    return __ret__.apply(lambda __response__: GetTransformerResult(
        transformer_config=pulumi.get(__response__, 'transformer_config')))
