# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from .. import outputs as _root_outputs

__all__ = [
    'GetDeliveryResult',
    'AwaitableGetDeliveryResult',
    'get_delivery',
    'get_delivery_output',
]

@pulumi.output_type
class GetDeliveryResult:
    def __init__(__self__, arn=None, delivery_destination_type=None, delivery_id=None, field_delimiter=None, record_fields=None, s3_enable_hive_compatible_path=None, s3_suffix_path=None, tags=None):
        if arn and not isinstance(arn, str):
            raise TypeError("Expected argument 'arn' to be a str")
        pulumi.set(__self__, "arn", arn)
        if delivery_destination_type and not isinstance(delivery_destination_type, str):
            raise TypeError("Expected argument 'delivery_destination_type' to be a str")
        pulumi.set(__self__, "delivery_destination_type", delivery_destination_type)
        if delivery_id and not isinstance(delivery_id, str):
            raise TypeError("Expected argument 'delivery_id' to be a str")
        pulumi.set(__self__, "delivery_id", delivery_id)
        if field_delimiter and not isinstance(field_delimiter, str):
            raise TypeError("Expected argument 'field_delimiter' to be a str")
        pulumi.set(__self__, "field_delimiter", field_delimiter)
        if record_fields and not isinstance(record_fields, list):
            raise TypeError("Expected argument 'record_fields' to be a list")
        pulumi.set(__self__, "record_fields", record_fields)
        if s3_enable_hive_compatible_path and not isinstance(s3_enable_hive_compatible_path, bool):
            raise TypeError("Expected argument 's3_enable_hive_compatible_path' to be a bool")
        pulumi.set(__self__, "s3_enable_hive_compatible_path", s3_enable_hive_compatible_path)
        if s3_suffix_path and not isinstance(s3_suffix_path, str):
            raise TypeError("Expected argument 's3_suffix_path' to be a str")
        pulumi.set(__self__, "s3_suffix_path", s3_suffix_path)
        if tags and not isinstance(tags, list):
            raise TypeError("Expected argument 'tags' to be a list")
        pulumi.set(__self__, "tags", tags)

    @property
    @pulumi.getter
    def arn(self) -> Optional[builtins.str]:
        """
        The Amazon Resource Name (ARN) that uniquely identifies this delivery.
        """
        return pulumi.get(self, "arn")

    @property
    @pulumi.getter(name="deliveryDestinationType")
    def delivery_destination_type(self) -> Optional[builtins.str]:
        """
        Displays whether the delivery destination associated with this delivery is CloudWatch Logs, Amazon S3, or Kinesis Data Firehose.
        """
        return pulumi.get(self, "delivery_destination_type")

    @property
    @pulumi.getter(name="deliveryId")
    def delivery_id(self) -> Optional[builtins.str]:
        """
        The unique ID that identifies this delivery in your account.
        """
        return pulumi.get(self, "delivery_id")

    @property
    @pulumi.getter(name="fieldDelimiter")
    def field_delimiter(self) -> Optional[builtins.str]:
        """
        The field delimiter to use between record fields when the final output format of a delivery is in Plain , W3C , or Raw format.
        """
        return pulumi.get(self, "field_delimiter")

    @property
    @pulumi.getter(name="recordFields")
    def record_fields(self) -> Optional[Sequence[builtins.str]]:
        """
        The list of record fields to be delivered to the destination, in order. If the delivery's log source has mandatory fields, they must be included in this list.
        """
        return pulumi.get(self, "record_fields")

    @property
    @pulumi.getter(name="s3EnableHiveCompatiblePath")
    def s3_enable_hive_compatible_path(self) -> Optional[builtins.bool]:
        """
        This parameter causes the S3 objects that contain delivered logs to use a prefix structure that allows for integration with Apache Hive.
        """
        return pulumi.get(self, "s3_enable_hive_compatible_path")

    @property
    @pulumi.getter(name="s3SuffixPath")
    def s3_suffix_path(self) -> Optional[builtins.str]:
        """
        This string allows re-configuring the S3 object prefix to contain either static or variable sections. The valid variables to use in the suffix path will vary by each log source. See ConfigurationTemplate$allowedSuffixPathFields for more info on what values are supported in the suffix path for each log source.
        """
        return pulumi.get(self, "s3_suffix_path")

    @property
    @pulumi.getter
    def tags(self) -> Optional[Sequence['_root_outputs.Tag']]:
        """
        The tags that have been assigned to this delivery.
        """
        return pulumi.get(self, "tags")


class AwaitableGetDeliveryResult(GetDeliveryResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetDeliveryResult(
            arn=self.arn,
            delivery_destination_type=self.delivery_destination_type,
            delivery_id=self.delivery_id,
            field_delimiter=self.field_delimiter,
            record_fields=self.record_fields,
            s3_enable_hive_compatible_path=self.s3_enable_hive_compatible_path,
            s3_suffix_path=self.s3_suffix_path,
            tags=self.tags)


def get_delivery(delivery_id: Optional[builtins.str] = None,
                 opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetDeliveryResult:
    """
    This structure contains information about one delivery in your account.

    A delivery is a connection between a logical delivery source and a logical delivery destination.

    For more information, see [CreateDelivery](https://docs.aws.amazon.com/AmazonCloudWatchLogs/latest/APIReference/API_CreateDelivery.html).


    :param builtins.str delivery_id: The unique ID that identifies this delivery in your account.
    """
    __args__ = dict()
    __args__['deliveryId'] = delivery_id
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('aws-native:logs:getDelivery', __args__, opts=opts, typ=GetDeliveryResult).value

    return AwaitableGetDeliveryResult(
        arn=pulumi.get(__ret__, 'arn'),
        delivery_destination_type=pulumi.get(__ret__, 'delivery_destination_type'),
        delivery_id=pulumi.get(__ret__, 'delivery_id'),
        field_delimiter=pulumi.get(__ret__, 'field_delimiter'),
        record_fields=pulumi.get(__ret__, 'record_fields'),
        s3_enable_hive_compatible_path=pulumi.get(__ret__, 's3_enable_hive_compatible_path'),
        s3_suffix_path=pulumi.get(__ret__, 's3_suffix_path'),
        tags=pulumi.get(__ret__, 'tags'))
def get_delivery_output(delivery_id: Optional[pulumi.Input[builtins.str]] = None,
                        opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetDeliveryResult]:
    """
    This structure contains information about one delivery in your account.

    A delivery is a connection between a logical delivery source and a logical delivery destination.

    For more information, see [CreateDelivery](https://docs.aws.amazon.com/AmazonCloudWatchLogs/latest/APIReference/API_CreateDelivery.html).


    :param builtins.str delivery_id: The unique ID that identifies this delivery in your account.
    """
    __args__ = dict()
    __args__['deliveryId'] = delivery_id
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('aws-native:logs:getDelivery', __args__, opts=opts, typ=GetDeliveryResult)
    return __ret__.apply(lambda __response__: GetDeliveryResult(
        arn=pulumi.get(__response__, 'arn'),
        delivery_destination_type=pulumi.get(__response__, 'delivery_destination_type'),
        delivery_id=pulumi.get(__response__, 'delivery_id'),
        field_delimiter=pulumi.get(__response__, 'field_delimiter'),
        record_fields=pulumi.get(__response__, 'record_fields'),
        s3_enable_hive_compatible_path=pulumi.get(__response__, 's3_enable_hive_compatible_path'),
        s3_suffix_path=pulumi.get(__response__, 's3_suffix_path'),
        tags=pulumi.get(__response__, 'tags')))
