# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from .. import _inputs as _root_inputs
from .. import outputs as _root_outputs

__all__ = ['DeliveryArgs', 'Delivery']

@pulumi.input_type
class DeliveryArgs:
    def __init__(__self__, *,
                 delivery_destination_arn: pulumi.Input[builtins.str],
                 delivery_source_name: pulumi.Input[builtins.str],
                 field_delimiter: Optional[pulumi.Input[builtins.str]] = None,
                 record_fields: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
                 s3_enable_hive_compatible_path: Optional[pulumi.Input[builtins.bool]] = None,
                 s3_suffix_path: Optional[pulumi.Input[builtins.str]] = None,
                 tags: Optional[pulumi.Input[Sequence[pulumi.Input['_root_inputs.TagArgs']]]] = None):
        """
        The set of arguments for constructing a Delivery resource.
        :param pulumi.Input[builtins.str] delivery_destination_arn: The ARN of the delivery destination that is associated with this delivery.
        :param pulumi.Input[builtins.str] delivery_source_name: The name of the delivery source that is associated with this delivery.
        :param pulumi.Input[builtins.str] field_delimiter: The field delimiter to use between record fields when the final output format of a delivery is in Plain , W3C , or Raw format.
        :param pulumi.Input[Sequence[pulumi.Input[builtins.str]]] record_fields: The list of record fields to be delivered to the destination, in order. If the delivery's log source has mandatory fields, they must be included in this list.
        :param pulumi.Input[builtins.bool] s3_enable_hive_compatible_path: This parameter causes the S3 objects that contain delivered logs to use a prefix structure that allows for integration with Apache Hive.
        :param pulumi.Input[builtins.str] s3_suffix_path: This string allows re-configuring the S3 object prefix to contain either static or variable sections. The valid variables to use in the suffix path will vary by each log source. See ConfigurationTemplate$allowedSuffixPathFields for more info on what values are supported in the suffix path for each log source.
        :param pulumi.Input[Sequence[pulumi.Input['_root_inputs.TagArgs']]] tags: The tags that have been assigned to this delivery.
        """
        pulumi.set(__self__, "delivery_destination_arn", delivery_destination_arn)
        pulumi.set(__self__, "delivery_source_name", delivery_source_name)
        if field_delimiter is not None:
            pulumi.set(__self__, "field_delimiter", field_delimiter)
        if record_fields is not None:
            pulumi.set(__self__, "record_fields", record_fields)
        if s3_enable_hive_compatible_path is not None:
            pulumi.set(__self__, "s3_enable_hive_compatible_path", s3_enable_hive_compatible_path)
        if s3_suffix_path is not None:
            pulumi.set(__self__, "s3_suffix_path", s3_suffix_path)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)

    @property
    @pulumi.getter(name="deliveryDestinationArn")
    def delivery_destination_arn(self) -> pulumi.Input[builtins.str]:
        """
        The ARN of the delivery destination that is associated with this delivery.
        """
        return pulumi.get(self, "delivery_destination_arn")

    @delivery_destination_arn.setter
    def delivery_destination_arn(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "delivery_destination_arn", value)

    @property
    @pulumi.getter(name="deliverySourceName")
    def delivery_source_name(self) -> pulumi.Input[builtins.str]:
        """
        The name of the delivery source that is associated with this delivery.
        """
        return pulumi.get(self, "delivery_source_name")

    @delivery_source_name.setter
    def delivery_source_name(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "delivery_source_name", value)

    @property
    @pulumi.getter(name="fieldDelimiter")
    def field_delimiter(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The field delimiter to use between record fields when the final output format of a delivery is in Plain , W3C , or Raw format.
        """
        return pulumi.get(self, "field_delimiter")

    @field_delimiter.setter
    def field_delimiter(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "field_delimiter", value)

    @property
    @pulumi.getter(name="recordFields")
    def record_fields(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]:
        """
        The list of record fields to be delivered to the destination, in order. If the delivery's log source has mandatory fields, they must be included in this list.
        """
        return pulumi.get(self, "record_fields")

    @record_fields.setter
    def record_fields(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "record_fields", value)

    @property
    @pulumi.getter(name="s3EnableHiveCompatiblePath")
    def s3_enable_hive_compatible_path(self) -> Optional[pulumi.Input[builtins.bool]]:
        """
        This parameter causes the S3 objects that contain delivered logs to use a prefix structure that allows for integration with Apache Hive.
        """
        return pulumi.get(self, "s3_enable_hive_compatible_path")

    @s3_enable_hive_compatible_path.setter
    def s3_enable_hive_compatible_path(self, value: Optional[pulumi.Input[builtins.bool]]):
        pulumi.set(self, "s3_enable_hive_compatible_path", value)

    @property
    @pulumi.getter(name="s3SuffixPath")
    def s3_suffix_path(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        This string allows re-configuring the S3 object prefix to contain either static or variable sections. The valid variables to use in the suffix path will vary by each log source. See ConfigurationTemplate$allowedSuffixPathFields for more info on what values are supported in the suffix path for each log source.
        """
        return pulumi.get(self, "s3_suffix_path")

    @s3_suffix_path.setter
    def s3_suffix_path(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "s3_suffix_path", value)

    @property
    @pulumi.getter
    def tags(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['_root_inputs.TagArgs']]]]:
        """
        The tags that have been assigned to this delivery.
        """
        return pulumi.get(self, "tags")

    @tags.setter
    def tags(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['_root_inputs.TagArgs']]]]):
        pulumi.set(self, "tags", value)


@pulumi.type_token("aws-native:logs:Delivery")
class Delivery(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 delivery_destination_arn: Optional[pulumi.Input[builtins.str]] = None,
                 delivery_source_name: Optional[pulumi.Input[builtins.str]] = None,
                 field_delimiter: Optional[pulumi.Input[builtins.str]] = None,
                 record_fields: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
                 s3_enable_hive_compatible_path: Optional[pulumi.Input[builtins.bool]] = None,
                 s3_suffix_path: Optional[pulumi.Input[builtins.str]] = None,
                 tags: Optional[pulumi.Input[Sequence[pulumi.Input[Union['_root_inputs.TagArgs', '_root_inputs.TagArgsDict']]]]] = None,
                 __props__=None):
        """
        This structure contains information about one delivery in your account.

        A delivery is a connection between a logical delivery source and a logical delivery destination.

        For more information, see [CreateDelivery](https://docs.aws.amazon.com/AmazonCloudWatchLogs/latest/APIReference/API_CreateDelivery.html).

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[builtins.str] delivery_destination_arn: The ARN of the delivery destination that is associated with this delivery.
        :param pulumi.Input[builtins.str] delivery_source_name: The name of the delivery source that is associated with this delivery.
        :param pulumi.Input[builtins.str] field_delimiter: The field delimiter to use between record fields when the final output format of a delivery is in Plain , W3C , or Raw format.
        :param pulumi.Input[Sequence[pulumi.Input[builtins.str]]] record_fields: The list of record fields to be delivered to the destination, in order. If the delivery's log source has mandatory fields, they must be included in this list.
        :param pulumi.Input[builtins.bool] s3_enable_hive_compatible_path: This parameter causes the S3 objects that contain delivered logs to use a prefix structure that allows for integration with Apache Hive.
        :param pulumi.Input[builtins.str] s3_suffix_path: This string allows re-configuring the S3 object prefix to contain either static or variable sections. The valid variables to use in the suffix path will vary by each log source. See ConfigurationTemplate$allowedSuffixPathFields for more info on what values are supported in the suffix path for each log source.
        :param pulumi.Input[Sequence[pulumi.Input[Union['_root_inputs.TagArgs', '_root_inputs.TagArgsDict']]]] tags: The tags that have been assigned to this delivery.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: DeliveryArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        This structure contains information about one delivery in your account.

        A delivery is a connection between a logical delivery source and a logical delivery destination.

        For more information, see [CreateDelivery](https://docs.aws.amazon.com/AmazonCloudWatchLogs/latest/APIReference/API_CreateDelivery.html).

        :param str resource_name: The name of the resource.
        :param DeliveryArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(DeliveryArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 delivery_destination_arn: Optional[pulumi.Input[builtins.str]] = None,
                 delivery_source_name: Optional[pulumi.Input[builtins.str]] = None,
                 field_delimiter: Optional[pulumi.Input[builtins.str]] = None,
                 record_fields: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
                 s3_enable_hive_compatible_path: Optional[pulumi.Input[builtins.bool]] = None,
                 s3_suffix_path: Optional[pulumi.Input[builtins.str]] = None,
                 tags: Optional[pulumi.Input[Sequence[pulumi.Input[Union['_root_inputs.TagArgs', '_root_inputs.TagArgsDict']]]]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = DeliveryArgs.__new__(DeliveryArgs)

            if delivery_destination_arn is None and not opts.urn:
                raise TypeError("Missing required property 'delivery_destination_arn'")
            __props__.__dict__["delivery_destination_arn"] = delivery_destination_arn
            if delivery_source_name is None and not opts.urn:
                raise TypeError("Missing required property 'delivery_source_name'")
            __props__.__dict__["delivery_source_name"] = delivery_source_name
            __props__.__dict__["field_delimiter"] = field_delimiter
            __props__.__dict__["record_fields"] = record_fields
            __props__.__dict__["s3_enable_hive_compatible_path"] = s3_enable_hive_compatible_path
            __props__.__dict__["s3_suffix_path"] = s3_suffix_path
            __props__.__dict__["tags"] = tags
            __props__.__dict__["arn"] = None
            __props__.__dict__["delivery_destination_type"] = None
            __props__.__dict__["delivery_id"] = None
        replace_on_changes = pulumi.ResourceOptions(replace_on_changes=["deliveryDestinationArn", "deliverySourceName"])
        opts = pulumi.ResourceOptions.merge(opts, replace_on_changes)
        super(Delivery, __self__).__init__(
            'aws-native:logs:Delivery',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None) -> 'Delivery':
        """
        Get an existing Delivery resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = DeliveryArgs.__new__(DeliveryArgs)

        __props__.__dict__["arn"] = None
        __props__.__dict__["delivery_destination_arn"] = None
        __props__.__dict__["delivery_destination_type"] = None
        __props__.__dict__["delivery_id"] = None
        __props__.__dict__["delivery_source_name"] = None
        __props__.__dict__["field_delimiter"] = None
        __props__.__dict__["record_fields"] = None
        __props__.__dict__["s3_enable_hive_compatible_path"] = None
        __props__.__dict__["s3_suffix_path"] = None
        __props__.__dict__["tags"] = None
        return Delivery(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter
    def arn(self) -> pulumi.Output[builtins.str]:
        """
        The Amazon Resource Name (ARN) that uniquely identifies this delivery.
        """
        return pulumi.get(self, "arn")

    @property
    @pulumi.getter(name="deliveryDestinationArn")
    def delivery_destination_arn(self) -> pulumi.Output[builtins.str]:
        """
        The ARN of the delivery destination that is associated with this delivery.
        """
        return pulumi.get(self, "delivery_destination_arn")

    @property
    @pulumi.getter(name="deliveryDestinationType")
    def delivery_destination_type(self) -> pulumi.Output[builtins.str]:
        """
        Displays whether the delivery destination associated with this delivery is CloudWatch Logs, Amazon S3, or Kinesis Data Firehose.
        """
        return pulumi.get(self, "delivery_destination_type")

    @property
    @pulumi.getter(name="deliveryId")
    def delivery_id(self) -> pulumi.Output[builtins.str]:
        """
        The unique ID that identifies this delivery in your account.
        """
        return pulumi.get(self, "delivery_id")

    @property
    @pulumi.getter(name="deliverySourceName")
    def delivery_source_name(self) -> pulumi.Output[builtins.str]:
        """
        The name of the delivery source that is associated with this delivery.
        """
        return pulumi.get(self, "delivery_source_name")

    @property
    @pulumi.getter(name="fieldDelimiter")
    def field_delimiter(self) -> pulumi.Output[Optional[builtins.str]]:
        """
        The field delimiter to use between record fields when the final output format of a delivery is in Plain , W3C , or Raw format.
        """
        return pulumi.get(self, "field_delimiter")

    @property
    @pulumi.getter(name="recordFields")
    def record_fields(self) -> pulumi.Output[Optional[Sequence[builtins.str]]]:
        """
        The list of record fields to be delivered to the destination, in order. If the delivery's log source has mandatory fields, they must be included in this list.
        """
        return pulumi.get(self, "record_fields")

    @property
    @pulumi.getter(name="s3EnableHiveCompatiblePath")
    def s3_enable_hive_compatible_path(self) -> pulumi.Output[Optional[builtins.bool]]:
        """
        This parameter causes the S3 objects that contain delivered logs to use a prefix structure that allows for integration with Apache Hive.
        """
        return pulumi.get(self, "s3_enable_hive_compatible_path")

    @property
    @pulumi.getter(name="s3SuffixPath")
    def s3_suffix_path(self) -> pulumi.Output[Optional[builtins.str]]:
        """
        This string allows re-configuring the S3 object prefix to contain either static or variable sections. The valid variables to use in the suffix path will vary by each log source. See ConfigurationTemplate$allowedSuffixPathFields for more info on what values are supported in the suffix path for each log source.
        """
        return pulumi.get(self, "s3_suffix_path")

    @property
    @pulumi.getter
    def tags(self) -> pulumi.Output[Optional[Sequence['_root_outputs.Tag']]]:
        """
        The tags that have been assigned to this delivery.
        """
        return pulumi.get(self, "tags")

