# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities

__all__ = ['TrackerConsumerArgs', 'TrackerConsumer']

@pulumi.input_type
class TrackerConsumerArgs:
    def __init__(__self__, *,
                 consumer_arn: pulumi.Input[builtins.str],
                 tracker_name: pulumi.Input[builtins.str]):
        """
        The set of arguments for constructing a TrackerConsumer resource.
        :param pulumi.Input[builtins.str] consumer_arn: The Amazon Resource Name (ARN) for the geofence collection to be associated to tracker resource. Used when you need to specify a resource across all AWS .
               
               - Format example: `arn:aws:geo:region:account-id:geofence-collection/ExampleGeofenceCollectionConsumer`
        :param pulumi.Input[builtins.str] tracker_name: The name for the tracker resource.
               
               Requirements:
               
               - Contain only alphanumeric characters (A-Z, a-z, 0-9) , hyphens (-), periods (.), and underscores (_).
               - Must be a unique tracker resource name.
               - No spaces allowed. For example, `ExampleTracker` .
        """
        pulumi.set(__self__, "consumer_arn", consumer_arn)
        pulumi.set(__self__, "tracker_name", tracker_name)

    @property
    @pulumi.getter(name="consumerArn")
    def consumer_arn(self) -> pulumi.Input[builtins.str]:
        """
        The Amazon Resource Name (ARN) for the geofence collection to be associated to tracker resource. Used when you need to specify a resource across all AWS .

        - Format example: `arn:aws:geo:region:account-id:geofence-collection/ExampleGeofenceCollectionConsumer`
        """
        return pulumi.get(self, "consumer_arn")

    @consumer_arn.setter
    def consumer_arn(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "consumer_arn", value)

    @property
    @pulumi.getter(name="trackerName")
    def tracker_name(self) -> pulumi.Input[builtins.str]:
        """
        The name for the tracker resource.

        Requirements:

        - Contain only alphanumeric characters (A-Z, a-z, 0-9) , hyphens (-), periods (.), and underscores (_).
        - Must be a unique tracker resource name.
        - No spaces allowed. For example, `ExampleTracker` .
        """
        return pulumi.get(self, "tracker_name")

    @tracker_name.setter
    def tracker_name(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "tracker_name", value)


@pulumi.type_token("aws-native:location:TrackerConsumer")
class TrackerConsumer(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 consumer_arn: Optional[pulumi.Input[builtins.str]] = None,
                 tracker_name: Optional[pulumi.Input[builtins.str]] = None,
                 __props__=None):
        """
        Definition of AWS::Location::TrackerConsumer Resource Type

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[builtins.str] consumer_arn: The Amazon Resource Name (ARN) for the geofence collection to be associated to tracker resource. Used when you need to specify a resource across all AWS .
               
               - Format example: `arn:aws:geo:region:account-id:geofence-collection/ExampleGeofenceCollectionConsumer`
        :param pulumi.Input[builtins.str] tracker_name: The name for the tracker resource.
               
               Requirements:
               
               - Contain only alphanumeric characters (A-Z, a-z, 0-9) , hyphens (-), periods (.), and underscores (_).
               - Must be a unique tracker resource name.
               - No spaces allowed. For example, `ExampleTracker` .
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: TrackerConsumerArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Definition of AWS::Location::TrackerConsumer Resource Type

        :param str resource_name: The name of the resource.
        :param TrackerConsumerArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(TrackerConsumerArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 consumer_arn: Optional[pulumi.Input[builtins.str]] = None,
                 tracker_name: Optional[pulumi.Input[builtins.str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = TrackerConsumerArgs.__new__(TrackerConsumerArgs)

            if consumer_arn is None and not opts.urn:
                raise TypeError("Missing required property 'consumer_arn'")
            __props__.__dict__["consumer_arn"] = consumer_arn
            if tracker_name is None and not opts.urn:
                raise TypeError("Missing required property 'tracker_name'")
            __props__.__dict__["tracker_name"] = tracker_name
        replace_on_changes = pulumi.ResourceOptions(replace_on_changes=["consumerArn", "trackerName"])
        opts = pulumi.ResourceOptions.merge(opts, replace_on_changes)
        super(TrackerConsumer, __self__).__init__(
            'aws-native:location:TrackerConsumer',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None) -> 'TrackerConsumer':
        """
        Get an existing TrackerConsumer resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = TrackerConsumerArgs.__new__(TrackerConsumerArgs)

        __props__.__dict__["consumer_arn"] = None
        __props__.__dict__["tracker_name"] = None
        return TrackerConsumer(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter(name="consumerArn")
    def consumer_arn(self) -> pulumi.Output[builtins.str]:
        """
        The Amazon Resource Name (ARN) for the geofence collection to be associated to tracker resource. Used when you need to specify a resource across all AWS .

        - Format example: `arn:aws:geo:region:account-id:geofence-collection/ExampleGeofenceCollectionConsumer`
        """
        return pulumi.get(self, "consumer_arn")

    @property
    @pulumi.getter(name="trackerName")
    def tracker_name(self) -> pulumi.Output[builtins.str]:
        """
        The name for the tracker resource.

        Requirements:

        - Contain only alphanumeric characters (A-Z, a-z, 0-9) , hyphens (-), periods (.), and underscores (_).
        - Must be a unique tracker resource name.
        - No spaces allowed. For example, `ExampleTracker` .
        """
        return pulumi.get(self, "tracker_name")

