# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from .. import _inputs as _root_inputs
from .. import outputs as _root_outputs
from ._enums import *

__all__ = ['RouteCalculatorArgs', 'RouteCalculator']

@pulumi.input_type
class RouteCalculatorArgs:
    def __init__(__self__, *,
                 data_source: pulumi.Input[builtins.str],
                 calculator_name: Optional[pulumi.Input[builtins.str]] = None,
                 description: Optional[pulumi.Input[builtins.str]] = None,
                 pricing_plan: Optional[pulumi.Input['RouteCalculatorPricingPlan']] = None,
                 tags: Optional[pulumi.Input[Sequence[pulumi.Input['_root_inputs.TagArgs']]]] = None):
        """
        The set of arguments for constructing a RouteCalculator resource.
        :param pulumi.Input[builtins.str] data_source: Specifies the data provider of traffic and road network data.
               
               > This field is case-sensitive. Enter the valid values as shown. For example, entering `HERE` returns an error. 
               
               Valid values include:
               
               - `Esri` – For additional information about [Esri](https://docs.aws.amazon.com/location/previous/developerguide/esri.html) 's coverage in your region of interest, see [Esri details on street networks and traffic coverage](https://docs.aws.amazon.com/https://doc.arcgis.com/en/arcgis-online/reference/network-coverage.htm) .
               
               Route calculators that use Esri as a data source only calculate routes that are shorter than 400 km.
               - `Grab` – Grab provides routing functionality for Southeast Asia. For additional information about [GrabMaps](https://docs.aws.amazon.com/location/previous/developerguide/grab.html) ' coverage, see [GrabMaps countries and areas covered](https://docs.aws.amazon.com/location/previous/developerguide/grab.html#grab-coverage-area) .
               - `Here` – For additional information about [HERE Technologies](https://docs.aws.amazon.com/location/previous/developerguide/HERE.html) ' coverage in your region of interest, see [HERE car routing coverage](https://docs.aws.amazon.com/https://developer.here.com/documentation/routing-api/dev_guide/topics/coverage/car-routing.html) and [HERE truck routing coverage](https://docs.aws.amazon.com/https://developer.here.com/documentation/routing-api/dev_guide/topics/coverage/truck-routing.html) .
               
               For additional information , see [Data providers](https://docs.aws.amazon.com/location/previous/developerguide/what-is-data-provider.html) on the *Amazon Location Service Developer Guide* .
        :param pulumi.Input[builtins.str] calculator_name: The name of the route calculator resource.
               
               Requirements:
               
               - Can use alphanumeric characters (A–Z, a–z, 0–9) , hyphens (-), periods (.), and underscores (_).
               - Must be a unique Route calculator resource name.
               - No spaces allowed. For example, `ExampleRouteCalculator` .
        :param pulumi.Input[builtins.str] description: The optional description for the route calculator resource.
        :param pulumi.Input['RouteCalculatorPricingPlan'] pricing_plan: No longer used. If included, the only allowed value is `RequestBasedUsage` .
               
               *Allowed Values* : `RequestBasedUsage`
        :param pulumi.Input[Sequence[pulumi.Input['_root_inputs.TagArgs']]] tags: An array of key-value pairs to apply to this resource.
        """
        pulumi.set(__self__, "data_source", data_source)
        if calculator_name is not None:
            pulumi.set(__self__, "calculator_name", calculator_name)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if pricing_plan is not None:
            pulumi.set(__self__, "pricing_plan", pricing_plan)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)

    @property
    @pulumi.getter(name="dataSource")
    def data_source(self) -> pulumi.Input[builtins.str]:
        """
        Specifies the data provider of traffic and road network data.

        > This field is case-sensitive. Enter the valid values as shown. For example, entering `HERE` returns an error. 

        Valid values include:

        - `Esri` – For additional information about [Esri](https://docs.aws.amazon.com/location/previous/developerguide/esri.html) 's coverage in your region of interest, see [Esri details on street networks and traffic coverage](https://docs.aws.amazon.com/https://doc.arcgis.com/en/arcgis-online/reference/network-coverage.htm) .

        Route calculators that use Esri as a data source only calculate routes that are shorter than 400 km.
        - `Grab` – Grab provides routing functionality for Southeast Asia. For additional information about [GrabMaps](https://docs.aws.amazon.com/location/previous/developerguide/grab.html) ' coverage, see [GrabMaps countries and areas covered](https://docs.aws.amazon.com/location/previous/developerguide/grab.html#grab-coverage-area) .
        - `Here` – For additional information about [HERE Technologies](https://docs.aws.amazon.com/location/previous/developerguide/HERE.html) ' coverage in your region of interest, see [HERE car routing coverage](https://docs.aws.amazon.com/https://developer.here.com/documentation/routing-api/dev_guide/topics/coverage/car-routing.html) and [HERE truck routing coverage](https://docs.aws.amazon.com/https://developer.here.com/documentation/routing-api/dev_guide/topics/coverage/truck-routing.html) .

        For additional information , see [Data providers](https://docs.aws.amazon.com/location/previous/developerguide/what-is-data-provider.html) on the *Amazon Location Service Developer Guide* .
        """
        return pulumi.get(self, "data_source")

    @data_source.setter
    def data_source(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "data_source", value)

    @property
    @pulumi.getter(name="calculatorName")
    def calculator_name(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The name of the route calculator resource.

        Requirements:

        - Can use alphanumeric characters (A–Z, a–z, 0–9) , hyphens (-), periods (.), and underscores (_).
        - Must be a unique Route calculator resource name.
        - No spaces allowed. For example, `ExampleRouteCalculator` .
        """
        return pulumi.get(self, "calculator_name")

    @calculator_name.setter
    def calculator_name(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "calculator_name", value)

    @property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The optional description for the route calculator resource.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "description", value)

    @property
    @pulumi.getter(name="pricingPlan")
    def pricing_plan(self) -> Optional[pulumi.Input['RouteCalculatorPricingPlan']]:
        """
        No longer used. If included, the only allowed value is `RequestBasedUsage` .

        *Allowed Values* : `RequestBasedUsage`
        """
        return pulumi.get(self, "pricing_plan")

    @pricing_plan.setter
    def pricing_plan(self, value: Optional[pulumi.Input['RouteCalculatorPricingPlan']]):
        pulumi.set(self, "pricing_plan", value)

    @property
    @pulumi.getter
    def tags(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['_root_inputs.TagArgs']]]]:
        """
        An array of key-value pairs to apply to this resource.
        """
        return pulumi.get(self, "tags")

    @tags.setter
    def tags(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['_root_inputs.TagArgs']]]]):
        pulumi.set(self, "tags", value)


@pulumi.type_token("aws-native:location:RouteCalculator")
class RouteCalculator(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 calculator_name: Optional[pulumi.Input[builtins.str]] = None,
                 data_source: Optional[pulumi.Input[builtins.str]] = None,
                 description: Optional[pulumi.Input[builtins.str]] = None,
                 pricing_plan: Optional[pulumi.Input['RouteCalculatorPricingPlan']] = None,
                 tags: Optional[pulumi.Input[Sequence[pulumi.Input[Union['_root_inputs.TagArgs', '_root_inputs.TagArgsDict']]]]] = None,
                 __props__=None):
        """
        Definition of AWS::Location::RouteCalculator Resource Type

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[builtins.str] calculator_name: The name of the route calculator resource.
               
               Requirements:
               
               - Can use alphanumeric characters (A–Z, a–z, 0–9) , hyphens (-), periods (.), and underscores (_).
               - Must be a unique Route calculator resource name.
               - No spaces allowed. For example, `ExampleRouteCalculator` .
        :param pulumi.Input[builtins.str] data_source: Specifies the data provider of traffic and road network data.
               
               > This field is case-sensitive. Enter the valid values as shown. For example, entering `HERE` returns an error. 
               
               Valid values include:
               
               - `Esri` – For additional information about [Esri](https://docs.aws.amazon.com/location/previous/developerguide/esri.html) 's coverage in your region of interest, see [Esri details on street networks and traffic coverage](https://docs.aws.amazon.com/https://doc.arcgis.com/en/arcgis-online/reference/network-coverage.htm) .
               
               Route calculators that use Esri as a data source only calculate routes that are shorter than 400 km.
               - `Grab` – Grab provides routing functionality for Southeast Asia. For additional information about [GrabMaps](https://docs.aws.amazon.com/location/previous/developerguide/grab.html) ' coverage, see [GrabMaps countries and areas covered](https://docs.aws.amazon.com/location/previous/developerguide/grab.html#grab-coverage-area) .
               - `Here` – For additional information about [HERE Technologies](https://docs.aws.amazon.com/location/previous/developerguide/HERE.html) ' coverage in your region of interest, see [HERE car routing coverage](https://docs.aws.amazon.com/https://developer.here.com/documentation/routing-api/dev_guide/topics/coverage/car-routing.html) and [HERE truck routing coverage](https://docs.aws.amazon.com/https://developer.here.com/documentation/routing-api/dev_guide/topics/coverage/truck-routing.html) .
               
               For additional information , see [Data providers](https://docs.aws.amazon.com/location/previous/developerguide/what-is-data-provider.html) on the *Amazon Location Service Developer Guide* .
        :param pulumi.Input[builtins.str] description: The optional description for the route calculator resource.
        :param pulumi.Input['RouteCalculatorPricingPlan'] pricing_plan: No longer used. If included, the only allowed value is `RequestBasedUsage` .
               
               *Allowed Values* : `RequestBasedUsage`
        :param pulumi.Input[Sequence[pulumi.Input[Union['_root_inputs.TagArgs', '_root_inputs.TagArgsDict']]]] tags: An array of key-value pairs to apply to this resource.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: RouteCalculatorArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Definition of AWS::Location::RouteCalculator Resource Type

        :param str resource_name: The name of the resource.
        :param RouteCalculatorArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(RouteCalculatorArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 calculator_name: Optional[pulumi.Input[builtins.str]] = None,
                 data_source: Optional[pulumi.Input[builtins.str]] = None,
                 description: Optional[pulumi.Input[builtins.str]] = None,
                 pricing_plan: Optional[pulumi.Input['RouteCalculatorPricingPlan']] = None,
                 tags: Optional[pulumi.Input[Sequence[pulumi.Input[Union['_root_inputs.TagArgs', '_root_inputs.TagArgsDict']]]]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = RouteCalculatorArgs.__new__(RouteCalculatorArgs)

            __props__.__dict__["calculator_name"] = calculator_name
            if data_source is None and not opts.urn:
                raise TypeError("Missing required property 'data_source'")
            __props__.__dict__["data_source"] = data_source
            __props__.__dict__["description"] = description
            __props__.__dict__["pricing_plan"] = pricing_plan
            __props__.__dict__["tags"] = tags
            __props__.__dict__["arn"] = None
            __props__.__dict__["calculator_arn"] = None
            __props__.__dict__["create_time"] = None
            __props__.__dict__["update_time"] = None
        replace_on_changes = pulumi.ResourceOptions(replace_on_changes=["calculatorName", "dataSource"])
        opts = pulumi.ResourceOptions.merge(opts, replace_on_changes)
        super(RouteCalculator, __self__).__init__(
            'aws-native:location:RouteCalculator',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None) -> 'RouteCalculator':
        """
        Get an existing RouteCalculator resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = RouteCalculatorArgs.__new__(RouteCalculatorArgs)

        __props__.__dict__["arn"] = None
        __props__.__dict__["calculator_arn"] = None
        __props__.__dict__["calculator_name"] = None
        __props__.__dict__["create_time"] = None
        __props__.__dict__["data_source"] = None
        __props__.__dict__["description"] = None
        __props__.__dict__["pricing_plan"] = None
        __props__.__dict__["tags"] = None
        __props__.__dict__["update_time"] = None
        return RouteCalculator(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter
    def arn(self) -> pulumi.Output[builtins.str]:
        """
        The Amazon Resource Name (ARN) for the route calculator resource. Use the ARN when you specify a resource across all AWS .

        - Format example: `arn:aws:geo:region:account-id:route-calculator/ExampleCalculator`
        """
        return pulumi.get(self, "arn")

    @property
    @pulumi.getter(name="calculatorArn")
    def calculator_arn(self) -> pulumi.Output[builtins.str]:
        """
        Synonym for `Arn` . The Amazon Resource Name (ARN) for the route calculator resource. Use the ARN when you specify a resource across all AWS .

        - Format example: `arn:aws:geo:region:account-id:route-calculator/ExampleCalculator`
        """
        return pulumi.get(self, "calculator_arn")

    @property
    @pulumi.getter(name="calculatorName")
    def calculator_name(self) -> pulumi.Output[builtins.str]:
        """
        The name of the route calculator resource.

        Requirements:

        - Can use alphanumeric characters (A–Z, a–z, 0–9) , hyphens (-), periods (.), and underscores (_).
        - Must be a unique Route calculator resource name.
        - No spaces allowed. For example, `ExampleRouteCalculator` .
        """
        return pulumi.get(self, "calculator_name")

    @property
    @pulumi.getter(name="createTime")
    def create_time(self) -> pulumi.Output[builtins.str]:
        """
        The timestamp for when the route calculator resource was created in [ISO 8601](https://docs.aws.amazon.com/https://www.iso.org/iso-8601-date-and-time-format.html) format: `YYYY-MM-DDThh:mm:ss.sssZ` .
        """
        return pulumi.get(self, "create_time")

    @property
    @pulumi.getter(name="dataSource")
    def data_source(self) -> pulumi.Output[builtins.str]:
        """
        Specifies the data provider of traffic and road network data.

        > This field is case-sensitive. Enter the valid values as shown. For example, entering `HERE` returns an error. 

        Valid values include:

        - `Esri` – For additional information about [Esri](https://docs.aws.amazon.com/location/previous/developerguide/esri.html) 's coverage in your region of interest, see [Esri details on street networks and traffic coverage](https://docs.aws.amazon.com/https://doc.arcgis.com/en/arcgis-online/reference/network-coverage.htm) .

        Route calculators that use Esri as a data source only calculate routes that are shorter than 400 km.
        - `Grab` – Grab provides routing functionality for Southeast Asia. For additional information about [GrabMaps](https://docs.aws.amazon.com/location/previous/developerguide/grab.html) ' coverage, see [GrabMaps countries and areas covered](https://docs.aws.amazon.com/location/previous/developerguide/grab.html#grab-coverage-area) .
        - `Here` – For additional information about [HERE Technologies](https://docs.aws.amazon.com/location/previous/developerguide/HERE.html) ' coverage in your region of interest, see [HERE car routing coverage](https://docs.aws.amazon.com/https://developer.here.com/documentation/routing-api/dev_guide/topics/coverage/car-routing.html) and [HERE truck routing coverage](https://docs.aws.amazon.com/https://developer.here.com/documentation/routing-api/dev_guide/topics/coverage/truck-routing.html) .

        For additional information , see [Data providers](https://docs.aws.amazon.com/location/previous/developerguide/what-is-data-provider.html) on the *Amazon Location Service Developer Guide* .
        """
        return pulumi.get(self, "data_source")

    @property
    @pulumi.getter
    def description(self) -> pulumi.Output[Optional[builtins.str]]:
        """
        The optional description for the route calculator resource.
        """
        return pulumi.get(self, "description")

    @property
    @pulumi.getter(name="pricingPlan")
    def pricing_plan(self) -> pulumi.Output[Optional['RouteCalculatorPricingPlan']]:
        """
        No longer used. If included, the only allowed value is `RequestBasedUsage` .

        *Allowed Values* : `RequestBasedUsage`
        """
        return pulumi.get(self, "pricing_plan")

    @property
    @pulumi.getter
    def tags(self) -> pulumi.Output[Optional[Sequence['_root_outputs.Tag']]]:
        """
        An array of key-value pairs to apply to this resource.
        """
        return pulumi.get(self, "tags")

    @property
    @pulumi.getter(name="updateTime")
    def update_time(self) -> pulumi.Output[builtins.str]:
        """
        The timestamp for when the route calculator resource was last updated in [ISO 8601](https://docs.aws.amazon.com/https://www.iso.org/iso-8601-date-and-time-format.html) format: `YYYY-MM-DDThh:mm:ss.sssZ` .
        """
        return pulumi.get(self, "update_time")

