# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs
from ._enums import *

__all__ = [
    'BucketAccessRules',
    'Container',
    'ContainerEnvironmentVariable',
    'ContainerHealthCheckConfig',
    'ContainerPortInfo',
    'ContainerPrivateRegistryAccess',
    'ContainerPrivateRegistryAccessEcrImagePullerRoleProperties',
    'ContainerPublicDomainName',
    'ContainerPublicEndpoint',
    'ContainerServiceDeployment',
    'DatabaseRelationalDatabaseParameter',
    'DiskAddOn',
    'DiskAutoSnapshotAddOn',
    'DiskLocation',
    'InstanceAddOn',
    'InstanceAutoSnapshotAddOn',
    'InstanceDisk',
    'InstanceHardware',
    'InstanceLocation',
    'InstanceMonthlyTransfer',
    'InstanceNetworking',
    'InstancePort',
    'InstanceSnapshotLocation',
    'InstanceState',
]

@pulumi.output_type
class BucketAccessRules(dict):
    """
    An object that sets the public accessibility of objects in the specified bucket.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "allowPublicOverrides":
            suggest = "allow_public_overrides"
        elif key == "getObject":
            suggest = "get_object"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in BucketAccessRules. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        BucketAccessRules.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        BucketAccessRules.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 allow_public_overrides: Optional[builtins.bool] = None,
                 get_object: Optional[builtins.str] = None):
        """
        An object that sets the public accessibility of objects in the specified bucket.
        :param builtins.bool allow_public_overrides: A Boolean value that indicates whether the access control list (ACL) permissions that are applied to individual objects override the getObject option that is currently specified.
        :param builtins.str get_object: Specifies the anonymous access to all objects in a bucket.
        """
        if allow_public_overrides is not None:
            pulumi.set(__self__, "allow_public_overrides", allow_public_overrides)
        if get_object is not None:
            pulumi.set(__self__, "get_object", get_object)

    @property
    @pulumi.getter(name="allowPublicOverrides")
    def allow_public_overrides(self) -> Optional[builtins.bool]:
        """
        A Boolean value that indicates whether the access control list (ACL) permissions that are applied to individual objects override the getObject option that is currently specified.
        """
        return pulumi.get(self, "allow_public_overrides")

    @property
    @pulumi.getter(name="getObject")
    def get_object(self) -> Optional[builtins.str]:
        """
        Specifies the anonymous access to all objects in a bucket.
        """
        return pulumi.get(self, "get_object")


@pulumi.output_type
class Container(dict):
    """
    Describes the settings of a container that will be launched, or that is launched, to an Amazon Lightsail container service.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "containerName":
            suggest = "container_name"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in Container. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        Container.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        Container.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 command: Optional[Sequence[builtins.str]] = None,
                 container_name: Optional[builtins.str] = None,
                 environment: Optional[Sequence['outputs.ContainerEnvironmentVariable']] = None,
                 image: Optional[builtins.str] = None,
                 ports: Optional[Sequence['outputs.ContainerPortInfo']] = None):
        """
        Describes the settings of a container that will be launched, or that is launched, to an Amazon Lightsail container service.
        :param Sequence[builtins.str] command: The launch command for the container.
        :param builtins.str container_name: The name of the container.
        :param Sequence['ContainerEnvironmentVariable'] environment: The environment variables of the container.
        :param builtins.str image: The name of the image used for the container.
        :param Sequence['ContainerPortInfo'] ports: The open firewall ports of the container.
        """
        if command is not None:
            pulumi.set(__self__, "command", command)
        if container_name is not None:
            pulumi.set(__self__, "container_name", container_name)
        if environment is not None:
            pulumi.set(__self__, "environment", environment)
        if image is not None:
            pulumi.set(__self__, "image", image)
        if ports is not None:
            pulumi.set(__self__, "ports", ports)

    @property
    @pulumi.getter
    def command(self) -> Optional[Sequence[builtins.str]]:
        """
        The launch command for the container.
        """
        return pulumi.get(self, "command")

    @property
    @pulumi.getter(name="containerName")
    def container_name(self) -> Optional[builtins.str]:
        """
        The name of the container.
        """
        return pulumi.get(self, "container_name")

    @property
    @pulumi.getter
    def environment(self) -> Optional[Sequence['outputs.ContainerEnvironmentVariable']]:
        """
        The environment variables of the container.
        """
        return pulumi.get(self, "environment")

    @property
    @pulumi.getter
    def image(self) -> Optional[builtins.str]:
        """
        The name of the image used for the container.
        """
        return pulumi.get(self, "image")

    @property
    @pulumi.getter
    def ports(self) -> Optional[Sequence['outputs.ContainerPortInfo']]:
        """
        The open firewall ports of the container.
        """
        return pulumi.get(self, "ports")


@pulumi.output_type
class ContainerEnvironmentVariable(dict):
    def __init__(__self__, *,
                 value: Optional[builtins.str] = None,
                 variable: Optional[builtins.str] = None):
        """
        :param builtins.str value: The environment variable value.
        :param builtins.str variable: The environment variable key.
        """
        if value is not None:
            pulumi.set(__self__, "value", value)
        if variable is not None:
            pulumi.set(__self__, "variable", variable)

    @property
    @pulumi.getter
    def value(self) -> Optional[builtins.str]:
        """
        The environment variable value.
        """
        return pulumi.get(self, "value")

    @property
    @pulumi.getter
    def variable(self) -> Optional[builtins.str]:
        """
        The environment variable key.
        """
        return pulumi.get(self, "variable")


@pulumi.output_type
class ContainerHealthCheckConfig(dict):
    """
    Describes the health check configuration of an Amazon Lightsail container service.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "healthyThreshold":
            suggest = "healthy_threshold"
        elif key == "intervalSeconds":
            suggest = "interval_seconds"
        elif key == "successCodes":
            suggest = "success_codes"
        elif key == "timeoutSeconds":
            suggest = "timeout_seconds"
        elif key == "unhealthyThreshold":
            suggest = "unhealthy_threshold"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ContainerHealthCheckConfig. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ContainerHealthCheckConfig.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ContainerHealthCheckConfig.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 healthy_threshold: Optional[builtins.int] = None,
                 interval_seconds: Optional[builtins.int] = None,
                 path: Optional[builtins.str] = None,
                 success_codes: Optional[builtins.str] = None,
                 timeout_seconds: Optional[builtins.int] = None,
                 unhealthy_threshold: Optional[builtins.int] = None):
        """
        Describes the health check configuration of an Amazon Lightsail container service.
        :param builtins.int healthy_threshold: The number of consecutive health checks successes required before moving the container to the Healthy state. The default value is 2.
        :param builtins.int interval_seconds: The approximate interval, in seconds, between health checks of an individual container. You can specify between 5 and 300 seconds. The default value is 5.
        :param builtins.str path: The path on the container on which to perform the health check. The default value is /.
        :param builtins.str success_codes: The HTTP codes to use when checking for a successful response from a container. You can specify values between 200 and 499. You can specify multiple values (for example, 200,202) or a range of values (for example, 200-299).
        :param builtins.int timeout_seconds: The amount of time, in seconds, during which no response means a failed health check. You can specify between 2 and 60 seconds. The default value is 2.
        :param builtins.int unhealthy_threshold: The number of consecutive health check failures required before moving the container to the Unhealthy state. The default value is 2.
        """
        if healthy_threshold is not None:
            pulumi.set(__self__, "healthy_threshold", healthy_threshold)
        if interval_seconds is not None:
            pulumi.set(__self__, "interval_seconds", interval_seconds)
        if path is not None:
            pulumi.set(__self__, "path", path)
        if success_codes is not None:
            pulumi.set(__self__, "success_codes", success_codes)
        if timeout_seconds is not None:
            pulumi.set(__self__, "timeout_seconds", timeout_seconds)
        if unhealthy_threshold is not None:
            pulumi.set(__self__, "unhealthy_threshold", unhealthy_threshold)

    @property
    @pulumi.getter(name="healthyThreshold")
    def healthy_threshold(self) -> Optional[builtins.int]:
        """
        The number of consecutive health checks successes required before moving the container to the Healthy state. The default value is 2.
        """
        return pulumi.get(self, "healthy_threshold")

    @property
    @pulumi.getter(name="intervalSeconds")
    def interval_seconds(self) -> Optional[builtins.int]:
        """
        The approximate interval, in seconds, between health checks of an individual container. You can specify between 5 and 300 seconds. The default value is 5.
        """
        return pulumi.get(self, "interval_seconds")

    @property
    @pulumi.getter
    def path(self) -> Optional[builtins.str]:
        """
        The path on the container on which to perform the health check. The default value is /.
        """
        return pulumi.get(self, "path")

    @property
    @pulumi.getter(name="successCodes")
    def success_codes(self) -> Optional[builtins.str]:
        """
        The HTTP codes to use when checking for a successful response from a container. You can specify values between 200 and 499. You can specify multiple values (for example, 200,202) or a range of values (for example, 200-299).
        """
        return pulumi.get(self, "success_codes")

    @property
    @pulumi.getter(name="timeoutSeconds")
    def timeout_seconds(self) -> Optional[builtins.int]:
        """
        The amount of time, in seconds, during which no response means a failed health check. You can specify between 2 and 60 seconds. The default value is 2.
        """
        return pulumi.get(self, "timeout_seconds")

    @property
    @pulumi.getter(name="unhealthyThreshold")
    def unhealthy_threshold(self) -> Optional[builtins.int]:
        """
        The number of consecutive health check failures required before moving the container to the Unhealthy state. The default value is 2.
        """
        return pulumi.get(self, "unhealthy_threshold")


@pulumi.output_type
class ContainerPortInfo(dict):
    def __init__(__self__, *,
                 port: Optional[builtins.str] = None,
                 protocol: Optional[builtins.str] = None):
        """
        :param builtins.str port: The open firewall ports of the container.
        :param builtins.str protocol: The protocol name for the open ports.
               
               *Allowed values* : `HTTP` | `HTTPS` | `TCP` | `UDP`
        """
        if port is not None:
            pulumi.set(__self__, "port", port)
        if protocol is not None:
            pulumi.set(__self__, "protocol", protocol)

    @property
    @pulumi.getter
    def port(self) -> Optional[builtins.str]:
        """
        The open firewall ports of the container.
        """
        return pulumi.get(self, "port")

    @property
    @pulumi.getter
    def protocol(self) -> Optional[builtins.str]:
        """
        The protocol name for the open ports.

        *Allowed values* : `HTTP` | `HTTPS` | `TCP` | `UDP`
        """
        return pulumi.get(self, "protocol")


@pulumi.output_type
class ContainerPrivateRegistryAccess(dict):
    """
    An object to describe the configuration for the container service to access private container image repositories, such as Amazon Elastic Container Registry (Amazon ECR) private repositories.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "ecrImagePullerRole":
            suggest = "ecr_image_puller_role"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ContainerPrivateRegistryAccess. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ContainerPrivateRegistryAccess.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ContainerPrivateRegistryAccess.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 ecr_image_puller_role: Optional['outputs.ContainerPrivateRegistryAccessEcrImagePullerRoleProperties'] = None):
        """
        An object to describe the configuration for the container service to access private container image repositories, such as Amazon Elastic Container Registry (Amazon ECR) private repositories.
        :param 'ContainerPrivateRegistryAccessEcrImagePullerRoleProperties' ecr_image_puller_role: An object to describe a request to activate or deactivate the role that you can use to grant an Amazon Lightsail container service access to Amazon Elastic Container Registry (Amazon ECR) private repositories.
        """
        if ecr_image_puller_role is not None:
            pulumi.set(__self__, "ecr_image_puller_role", ecr_image_puller_role)

    @property
    @pulumi.getter(name="ecrImagePullerRole")
    def ecr_image_puller_role(self) -> Optional['outputs.ContainerPrivateRegistryAccessEcrImagePullerRoleProperties']:
        """
        An object to describe a request to activate or deactivate the role that you can use to grant an Amazon Lightsail container service access to Amazon Elastic Container Registry (Amazon ECR) private repositories.
        """
        return pulumi.get(self, "ecr_image_puller_role")


@pulumi.output_type
class ContainerPrivateRegistryAccessEcrImagePullerRoleProperties(dict):
    """
    An object to describe a request to activate or deactivate the role that you can use to grant an Amazon Lightsail container service access to Amazon Elastic Container Registry (Amazon ECR) private repositories.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "isActive":
            suggest = "is_active"
        elif key == "principalArn":
            suggest = "principal_arn"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ContainerPrivateRegistryAccessEcrImagePullerRoleProperties. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ContainerPrivateRegistryAccessEcrImagePullerRoleProperties.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ContainerPrivateRegistryAccessEcrImagePullerRoleProperties.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 is_active: Optional[builtins.bool] = None,
                 principal_arn: Optional[builtins.str] = None):
        """
        An object to describe a request to activate or deactivate the role that you can use to grant an Amazon Lightsail container service access to Amazon Elastic Container Registry (Amazon ECR) private repositories.
        :param builtins.bool is_active: A Boolean value that indicates whether to activate the role.
        :param builtins.str principal_arn: The Amazon Resource Name (ARN) of the role, if it is activated.
        """
        if is_active is not None:
            pulumi.set(__self__, "is_active", is_active)
        if principal_arn is not None:
            pulumi.set(__self__, "principal_arn", principal_arn)

    @property
    @pulumi.getter(name="isActive")
    def is_active(self) -> Optional[builtins.bool]:
        """
        A Boolean value that indicates whether to activate the role.
        """
        return pulumi.get(self, "is_active")

    @property
    @pulumi.getter(name="principalArn")
    def principal_arn(self) -> Optional[builtins.str]:
        """
        The Amazon Resource Name (ARN) of the role, if it is activated.
        """
        return pulumi.get(self, "principal_arn")


@pulumi.output_type
class ContainerPublicDomainName(dict):
    """
    The public domain name to use with the container service, such as example.com and www.example.com.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "certificateName":
            suggest = "certificate_name"
        elif key == "domainNames":
            suggest = "domain_names"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ContainerPublicDomainName. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ContainerPublicDomainName.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ContainerPublicDomainName.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 certificate_name: Optional[builtins.str] = None,
                 domain_names: Optional[Sequence[builtins.str]] = None):
        """
        The public domain name to use with the container service, such as example.com and www.example.com.
        :param builtins.str certificate_name: The name of the certificate for the public domains.
        :param Sequence[builtins.str] domain_names: An object that describes the configuration for the containers of the deployment.
        """
        if certificate_name is not None:
            pulumi.set(__self__, "certificate_name", certificate_name)
        if domain_names is not None:
            pulumi.set(__self__, "domain_names", domain_names)

    @property
    @pulumi.getter(name="certificateName")
    def certificate_name(self) -> Optional[builtins.str]:
        """
        The name of the certificate for the public domains.
        """
        return pulumi.get(self, "certificate_name")

    @property
    @pulumi.getter(name="domainNames")
    def domain_names(self) -> Optional[Sequence[builtins.str]]:
        """
        An object that describes the configuration for the containers of the deployment.
        """
        return pulumi.get(self, "domain_names")


@pulumi.output_type
class ContainerPublicEndpoint(dict):
    """
    Describes the settings of a public endpoint for an Amazon Lightsail container service.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "containerName":
            suggest = "container_name"
        elif key == "containerPort":
            suggest = "container_port"
        elif key == "healthCheckConfig":
            suggest = "health_check_config"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ContainerPublicEndpoint. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ContainerPublicEndpoint.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ContainerPublicEndpoint.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 container_name: Optional[builtins.str] = None,
                 container_port: Optional[builtins.int] = None,
                 health_check_config: Optional['outputs.ContainerHealthCheckConfig'] = None):
        """
        Describes the settings of a public endpoint for an Amazon Lightsail container service.
        :param builtins.str container_name: The name of the container for the endpoint.
        :param builtins.int container_port: The port of the container to which traffic is forwarded to.
        :param 'ContainerHealthCheckConfig' health_check_config: An object that describes the health check configuration of the container.
        """
        if container_name is not None:
            pulumi.set(__self__, "container_name", container_name)
        if container_port is not None:
            pulumi.set(__self__, "container_port", container_port)
        if health_check_config is not None:
            pulumi.set(__self__, "health_check_config", health_check_config)

    @property
    @pulumi.getter(name="containerName")
    def container_name(self) -> Optional[builtins.str]:
        """
        The name of the container for the endpoint.
        """
        return pulumi.get(self, "container_name")

    @property
    @pulumi.getter(name="containerPort")
    def container_port(self) -> Optional[builtins.int]:
        """
        The port of the container to which traffic is forwarded to.
        """
        return pulumi.get(self, "container_port")

    @property
    @pulumi.getter(name="healthCheckConfig")
    def health_check_config(self) -> Optional['outputs.ContainerHealthCheckConfig']:
        """
        An object that describes the health check configuration of the container.
        """
        return pulumi.get(self, "health_check_config")


@pulumi.output_type
class ContainerServiceDeployment(dict):
    """
    Describes a container deployment configuration of an Amazon Lightsail container service.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "publicEndpoint":
            suggest = "public_endpoint"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ContainerServiceDeployment. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ContainerServiceDeployment.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ContainerServiceDeployment.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 containers: Optional[Sequence['outputs.Container']] = None,
                 public_endpoint: Optional['outputs.ContainerPublicEndpoint'] = None):
        """
        Describes a container deployment configuration of an Amazon Lightsail container service.
        :param Sequence['Container'] containers: An object that describes the configuration for the containers of the deployment.
        :param 'ContainerPublicEndpoint' public_endpoint: An object that describes the endpoint of the deployment.
        """
        if containers is not None:
            pulumi.set(__self__, "containers", containers)
        if public_endpoint is not None:
            pulumi.set(__self__, "public_endpoint", public_endpoint)

    @property
    @pulumi.getter
    def containers(self) -> Optional[Sequence['outputs.Container']]:
        """
        An object that describes the configuration for the containers of the deployment.
        """
        return pulumi.get(self, "containers")

    @property
    @pulumi.getter(name="publicEndpoint")
    def public_endpoint(self) -> Optional['outputs.ContainerPublicEndpoint']:
        """
        An object that describes the endpoint of the deployment.
        """
        return pulumi.get(self, "public_endpoint")


@pulumi.output_type
class DatabaseRelationalDatabaseParameter(dict):
    """
    Describes the parameters of the database.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "allowedValues":
            suggest = "allowed_values"
        elif key == "applyMethod":
            suggest = "apply_method"
        elif key == "applyType":
            suggest = "apply_type"
        elif key == "dataType":
            suggest = "data_type"
        elif key == "isModifiable":
            suggest = "is_modifiable"
        elif key == "parameterName":
            suggest = "parameter_name"
        elif key == "parameterValue":
            suggest = "parameter_value"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in DatabaseRelationalDatabaseParameter. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        DatabaseRelationalDatabaseParameter.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        DatabaseRelationalDatabaseParameter.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 allowed_values: Optional[builtins.str] = None,
                 apply_method: Optional[builtins.str] = None,
                 apply_type: Optional[builtins.str] = None,
                 data_type: Optional[builtins.str] = None,
                 description: Optional[builtins.str] = None,
                 is_modifiable: Optional[builtins.bool] = None,
                 parameter_name: Optional[builtins.str] = None,
                 parameter_value: Optional[builtins.str] = None):
        """
        Describes the parameters of the database.
        :param builtins.str allowed_values: Specifies the valid range of values for the parameter.
        :param builtins.str apply_method: Indicates when parameter updates are applied. Can be immediate or pending-reboot.
        :param builtins.str apply_type: Specifies the engine-specific parameter type.
        :param builtins.str data_type: Specifies the valid data type for the parameter.
        :param builtins.str description: Provides a description of the parameter.
        :param builtins.bool is_modifiable: A Boolean value indicating whether the parameter can be modified.
        :param builtins.str parameter_name: Specifies the name of the parameter.
        :param builtins.str parameter_value: Specifies the value of the parameter.
        """
        if allowed_values is not None:
            pulumi.set(__self__, "allowed_values", allowed_values)
        if apply_method is not None:
            pulumi.set(__self__, "apply_method", apply_method)
        if apply_type is not None:
            pulumi.set(__self__, "apply_type", apply_type)
        if data_type is not None:
            pulumi.set(__self__, "data_type", data_type)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if is_modifiable is not None:
            pulumi.set(__self__, "is_modifiable", is_modifiable)
        if parameter_name is not None:
            pulumi.set(__self__, "parameter_name", parameter_name)
        if parameter_value is not None:
            pulumi.set(__self__, "parameter_value", parameter_value)

    @property
    @pulumi.getter(name="allowedValues")
    def allowed_values(self) -> Optional[builtins.str]:
        """
        Specifies the valid range of values for the parameter.
        """
        return pulumi.get(self, "allowed_values")

    @property
    @pulumi.getter(name="applyMethod")
    def apply_method(self) -> Optional[builtins.str]:
        """
        Indicates when parameter updates are applied. Can be immediate or pending-reboot.
        """
        return pulumi.get(self, "apply_method")

    @property
    @pulumi.getter(name="applyType")
    def apply_type(self) -> Optional[builtins.str]:
        """
        Specifies the engine-specific parameter type.
        """
        return pulumi.get(self, "apply_type")

    @property
    @pulumi.getter(name="dataType")
    def data_type(self) -> Optional[builtins.str]:
        """
        Specifies the valid data type for the parameter.
        """
        return pulumi.get(self, "data_type")

    @property
    @pulumi.getter
    def description(self) -> Optional[builtins.str]:
        """
        Provides a description of the parameter.
        """
        return pulumi.get(self, "description")

    @property
    @pulumi.getter(name="isModifiable")
    def is_modifiable(self) -> Optional[builtins.bool]:
        """
        A Boolean value indicating whether the parameter can be modified.
        """
        return pulumi.get(self, "is_modifiable")

    @property
    @pulumi.getter(name="parameterName")
    def parameter_name(self) -> Optional[builtins.str]:
        """
        Specifies the name of the parameter.
        """
        return pulumi.get(self, "parameter_name")

    @property
    @pulumi.getter(name="parameterValue")
    def parameter_value(self) -> Optional[builtins.str]:
        """
        Specifies the value of the parameter.
        """
        return pulumi.get(self, "parameter_value")


@pulumi.output_type
class DiskAddOn(dict):
    """
    A addon associate with a resource.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "addOnType":
            suggest = "add_on_type"
        elif key == "autoSnapshotAddOnRequest":
            suggest = "auto_snapshot_add_on_request"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in DiskAddOn. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        DiskAddOn.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        DiskAddOn.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 add_on_type: builtins.str,
                 auto_snapshot_add_on_request: Optional['outputs.DiskAutoSnapshotAddOn'] = None,
                 status: Optional['DiskAddOnStatus'] = None):
        """
        A addon associate with a resource.
        :param builtins.str add_on_type: The add-on type
        :param 'DiskAutoSnapshotAddOn' auto_snapshot_add_on_request: The parameters for the automatic snapshot add-on, such as the daily time when an automatic snapshot will be created.
        :param 'DiskAddOnStatus' status: Status of the Addon
        """
        pulumi.set(__self__, "add_on_type", add_on_type)
        if auto_snapshot_add_on_request is not None:
            pulumi.set(__self__, "auto_snapshot_add_on_request", auto_snapshot_add_on_request)
        if status is not None:
            pulumi.set(__self__, "status", status)

    @property
    @pulumi.getter(name="addOnType")
    def add_on_type(self) -> builtins.str:
        """
        The add-on type
        """
        return pulumi.get(self, "add_on_type")

    @property
    @pulumi.getter(name="autoSnapshotAddOnRequest")
    def auto_snapshot_add_on_request(self) -> Optional['outputs.DiskAutoSnapshotAddOn']:
        """
        The parameters for the automatic snapshot add-on, such as the daily time when an automatic snapshot will be created.
        """
        return pulumi.get(self, "auto_snapshot_add_on_request")

    @property
    @pulumi.getter
    def status(self) -> Optional['DiskAddOnStatus']:
        """
        Status of the Addon
        """
        return pulumi.get(self, "status")


@pulumi.output_type
class DiskAutoSnapshotAddOn(dict):
    """
    An object that represents additional parameters when enabling or modifying the automatic snapshot add-on
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "snapshotTimeOfDay":
            suggest = "snapshot_time_of_day"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in DiskAutoSnapshotAddOn. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        DiskAutoSnapshotAddOn.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        DiskAutoSnapshotAddOn.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 snapshot_time_of_day: Optional[builtins.str] = None):
        """
        An object that represents additional parameters when enabling or modifying the automatic snapshot add-on
        :param builtins.str snapshot_time_of_day: The daily time when an automatic snapshot will be created.
        """
        if snapshot_time_of_day is not None:
            pulumi.set(__self__, "snapshot_time_of_day", snapshot_time_of_day)

    @property
    @pulumi.getter(name="snapshotTimeOfDay")
    def snapshot_time_of_day(self) -> Optional[builtins.str]:
        """
        The daily time when an automatic snapshot will be created.
        """
        return pulumi.get(self, "snapshot_time_of_day")


@pulumi.output_type
class DiskLocation(dict):
    """
    Location of a resource.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "availabilityZone":
            suggest = "availability_zone"
        elif key == "regionName":
            suggest = "region_name"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in DiskLocation. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        DiskLocation.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        DiskLocation.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 availability_zone: Optional[builtins.str] = None,
                 region_name: Optional[builtins.str] = None):
        """
        Location of a resource.
        :param builtins.str availability_zone: The Availability Zone in which to create your disk. Use the following format: us-east-2a (case sensitive). Be sure to add the include Availability Zones parameter to your request.
        :param builtins.str region_name: The Region Name in which to create your disk.
        """
        if availability_zone is not None:
            pulumi.set(__self__, "availability_zone", availability_zone)
        if region_name is not None:
            pulumi.set(__self__, "region_name", region_name)

    @property
    @pulumi.getter(name="availabilityZone")
    def availability_zone(self) -> Optional[builtins.str]:
        """
        The Availability Zone in which to create your disk. Use the following format: us-east-2a (case sensitive). Be sure to add the include Availability Zones parameter to your request.
        """
        return pulumi.get(self, "availability_zone")

    @property
    @pulumi.getter(name="regionName")
    def region_name(self) -> Optional[builtins.str]:
        """
        The Region Name in which to create your disk.
        """
        return pulumi.get(self, "region_name")


@pulumi.output_type
class InstanceAddOn(dict):
    """
    A addon associate with a resource.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "addOnType":
            suggest = "add_on_type"
        elif key == "autoSnapshotAddOnRequest":
            suggest = "auto_snapshot_add_on_request"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in InstanceAddOn. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        InstanceAddOn.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        InstanceAddOn.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 add_on_type: builtins.str,
                 auto_snapshot_add_on_request: Optional['outputs.InstanceAutoSnapshotAddOn'] = None,
                 status: Optional['InstanceAddOnStatus'] = None):
        """
        A addon associate with a resource.
        :param builtins.str add_on_type: The add-on type
        :param 'InstanceAutoSnapshotAddOn' auto_snapshot_add_on_request: The parameters for the automatic snapshot add-on, such as the daily time when an automatic snapshot will be created.
        :param 'InstanceAddOnStatus' status: Status of the Addon
        """
        pulumi.set(__self__, "add_on_type", add_on_type)
        if auto_snapshot_add_on_request is not None:
            pulumi.set(__self__, "auto_snapshot_add_on_request", auto_snapshot_add_on_request)
        if status is not None:
            pulumi.set(__self__, "status", status)

    @property
    @pulumi.getter(name="addOnType")
    def add_on_type(self) -> builtins.str:
        """
        The add-on type
        """
        return pulumi.get(self, "add_on_type")

    @property
    @pulumi.getter(name="autoSnapshotAddOnRequest")
    def auto_snapshot_add_on_request(self) -> Optional['outputs.InstanceAutoSnapshotAddOn']:
        """
        The parameters for the automatic snapshot add-on, such as the daily time when an automatic snapshot will be created.
        """
        return pulumi.get(self, "auto_snapshot_add_on_request")

    @property
    @pulumi.getter
    def status(self) -> Optional['InstanceAddOnStatus']:
        """
        Status of the Addon
        """
        return pulumi.get(self, "status")


@pulumi.output_type
class InstanceAutoSnapshotAddOn(dict):
    """
    An object that represents additional parameters when enabling or modifying the automatic snapshot add-on
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "snapshotTimeOfDay":
            suggest = "snapshot_time_of_day"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in InstanceAutoSnapshotAddOn. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        InstanceAutoSnapshotAddOn.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        InstanceAutoSnapshotAddOn.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 snapshot_time_of_day: Optional[builtins.str] = None):
        """
        An object that represents additional parameters when enabling or modifying the automatic snapshot add-on
        :param builtins.str snapshot_time_of_day: The daily time when an automatic snapshot will be created.
        """
        if snapshot_time_of_day is not None:
            pulumi.set(__self__, "snapshot_time_of_day", snapshot_time_of_day)

    @property
    @pulumi.getter(name="snapshotTimeOfDay")
    def snapshot_time_of_day(self) -> Optional[builtins.str]:
        """
        The daily time when an automatic snapshot will be created.
        """
        return pulumi.get(self, "snapshot_time_of_day")


@pulumi.output_type
class InstanceDisk(dict):
    """
    Disk associated with the Instance.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "diskName":
            suggest = "disk_name"
        elif key == "attachedTo":
            suggest = "attached_to"
        elif key == "attachmentState":
            suggest = "attachment_state"
        elif key == "isSystemDisk":
            suggest = "is_system_disk"
        elif key == "sizeInGb":
            suggest = "size_in_gb"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in InstanceDisk. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        InstanceDisk.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        InstanceDisk.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 disk_name: builtins.str,
                 path: builtins.str,
                 attached_to: Optional[builtins.str] = None,
                 attachment_state: Optional[builtins.str] = None,
                 iops: Optional[builtins.int] = None,
                 is_system_disk: Optional[builtins.bool] = None,
                 size_in_gb: Optional[builtins.str] = None):
        """
        Disk associated with the Instance.
        :param builtins.str disk_name: The names to use for your new Lightsail disk.
        :param builtins.str path: Path of the disk attached to the instance.
        :param builtins.str attached_to: Instance attached to the disk.
        :param builtins.str attachment_state: Attachment state of the disk.
        :param builtins.int iops: IOPS of disk.
        :param builtins.bool is_system_disk: Is the Attached disk is the system disk of the Instance.
        :param builtins.str size_in_gb: Size of the disk attached to the Instance.
        """
        pulumi.set(__self__, "disk_name", disk_name)
        pulumi.set(__self__, "path", path)
        if attached_to is not None:
            pulumi.set(__self__, "attached_to", attached_to)
        if attachment_state is not None:
            pulumi.set(__self__, "attachment_state", attachment_state)
        if iops is not None:
            pulumi.set(__self__, "iops", iops)
        if is_system_disk is not None:
            pulumi.set(__self__, "is_system_disk", is_system_disk)
        if size_in_gb is not None:
            pulumi.set(__self__, "size_in_gb", size_in_gb)

    @property
    @pulumi.getter(name="diskName")
    def disk_name(self) -> builtins.str:
        """
        The names to use for your new Lightsail disk.
        """
        return pulumi.get(self, "disk_name")

    @property
    @pulumi.getter
    def path(self) -> builtins.str:
        """
        Path of the disk attached to the instance.
        """
        return pulumi.get(self, "path")

    @property
    @pulumi.getter(name="attachedTo")
    def attached_to(self) -> Optional[builtins.str]:
        """
        Instance attached to the disk.
        """
        return pulumi.get(self, "attached_to")

    @property
    @pulumi.getter(name="attachmentState")
    def attachment_state(self) -> Optional[builtins.str]:
        """
        Attachment state of the disk.
        """
        return pulumi.get(self, "attachment_state")

    @property
    @pulumi.getter
    def iops(self) -> Optional[builtins.int]:
        """
        IOPS of disk.
        """
        return pulumi.get(self, "iops")

    @property
    @pulumi.getter(name="isSystemDisk")
    def is_system_disk(self) -> Optional[builtins.bool]:
        """
        Is the Attached disk is the system disk of the Instance.
        """
        return pulumi.get(self, "is_system_disk")

    @property
    @pulumi.getter(name="sizeInGb")
    def size_in_gb(self) -> Optional[builtins.str]:
        """
        Size of the disk attached to the Instance.
        """
        return pulumi.get(self, "size_in_gb")


@pulumi.output_type
class InstanceHardware(dict):
    """
    Hardware of the Instance.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "cpuCount":
            suggest = "cpu_count"
        elif key == "ramSizeInGb":
            suggest = "ram_size_in_gb"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in InstanceHardware. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        InstanceHardware.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        InstanceHardware.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 cpu_count: Optional[builtins.int] = None,
                 disks: Optional[Sequence['outputs.InstanceDisk']] = None,
                 ram_size_in_gb: Optional[builtins.int] = None):
        """
        Hardware of the Instance.
        :param builtins.int cpu_count: CPU count of the Instance.
        :param Sequence['InstanceDisk'] disks: Disks attached to the Instance.
        :param builtins.int ram_size_in_gb: RAM Size of the Instance.
        """
        if cpu_count is not None:
            pulumi.set(__self__, "cpu_count", cpu_count)
        if disks is not None:
            pulumi.set(__self__, "disks", disks)
        if ram_size_in_gb is not None:
            pulumi.set(__self__, "ram_size_in_gb", ram_size_in_gb)

    @property
    @pulumi.getter(name="cpuCount")
    def cpu_count(self) -> Optional[builtins.int]:
        """
        CPU count of the Instance.
        """
        return pulumi.get(self, "cpu_count")

    @property
    @pulumi.getter
    def disks(self) -> Optional[Sequence['outputs.InstanceDisk']]:
        """
        Disks attached to the Instance.
        """
        return pulumi.get(self, "disks")

    @property
    @pulumi.getter(name="ramSizeInGb")
    def ram_size_in_gb(self) -> Optional[builtins.int]:
        """
        RAM Size of the Instance.
        """
        return pulumi.get(self, "ram_size_in_gb")


@pulumi.output_type
class InstanceLocation(dict):
    """
    Location of a resource.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "availabilityZone":
            suggest = "availability_zone"
        elif key == "regionName":
            suggest = "region_name"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in InstanceLocation. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        InstanceLocation.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        InstanceLocation.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 availability_zone: Optional[builtins.str] = None,
                 region_name: Optional[builtins.str] = None):
        """
        Location of a resource.
        :param builtins.str availability_zone: The Availability Zone in which to create your instance. Use the following format: us-east-2a (case sensitive). Be sure to add the include Availability Zones parameter to your request.
        :param builtins.str region_name: The Region Name in which to create your instance.
        """
        if availability_zone is not None:
            pulumi.set(__self__, "availability_zone", availability_zone)
        if region_name is not None:
            pulumi.set(__self__, "region_name", region_name)

    @property
    @pulumi.getter(name="availabilityZone")
    def availability_zone(self) -> Optional[builtins.str]:
        """
        The Availability Zone in which to create your instance. Use the following format: us-east-2a (case sensitive). Be sure to add the include Availability Zones parameter to your request.
        """
        return pulumi.get(self, "availability_zone")

    @property
    @pulumi.getter(name="regionName")
    def region_name(self) -> Optional[builtins.str]:
        """
        The Region Name in which to create your instance.
        """
        return pulumi.get(self, "region_name")


@pulumi.output_type
class InstanceMonthlyTransfer(dict):
    """
    Monthly Transfer of the Instance.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "gbPerMonthAllocated":
            suggest = "gb_per_month_allocated"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in InstanceMonthlyTransfer. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        InstanceMonthlyTransfer.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        InstanceMonthlyTransfer.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 gb_per_month_allocated: Optional[builtins.str] = None):
        """
        Monthly Transfer of the Instance.
        :param builtins.str gb_per_month_allocated: GbPerMonthAllocated of the Instance.
        """
        if gb_per_month_allocated is not None:
            pulumi.set(__self__, "gb_per_month_allocated", gb_per_month_allocated)

    @property
    @pulumi.getter(name="gbPerMonthAllocated")
    def gb_per_month_allocated(self) -> Optional[builtins.str]:
        """
        GbPerMonthAllocated of the Instance.
        """
        return pulumi.get(self, "gb_per_month_allocated")


@pulumi.output_type
class InstanceNetworking(dict):
    """
    Networking of the Instance.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "monthlyTransfer":
            suggest = "monthly_transfer"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in InstanceNetworking. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        InstanceNetworking.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        InstanceNetworking.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 ports: Sequence['outputs.InstancePort'],
                 monthly_transfer: Optional['outputs.InstanceMonthlyTransfer'] = None):
        """
        Networking of the Instance.
        :param Sequence['InstancePort'] ports: Ports to the Instance.
        :param 'InstanceMonthlyTransfer' monthly_transfer: The monthly amount of data transfer, in GB, allocated for the instance
        """
        pulumi.set(__self__, "ports", ports)
        if monthly_transfer is not None:
            pulumi.set(__self__, "monthly_transfer", monthly_transfer)

    @property
    @pulumi.getter
    def ports(self) -> Sequence['outputs.InstancePort']:
        """
        Ports to the Instance.
        """
        return pulumi.get(self, "ports")

    @property
    @pulumi.getter(name="monthlyTransfer")
    def monthly_transfer(self) -> Optional['outputs.InstanceMonthlyTransfer']:
        """
        The monthly amount of data transfer, in GB, allocated for the instance
        """
        return pulumi.get(self, "monthly_transfer")


@pulumi.output_type
class InstancePort(dict):
    """
    Port of the Instance.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "accessDirection":
            suggest = "access_direction"
        elif key == "accessFrom":
            suggest = "access_from"
        elif key == "accessType":
            suggest = "access_type"
        elif key == "cidrListAliases":
            suggest = "cidr_list_aliases"
        elif key == "commonName":
            suggest = "common_name"
        elif key == "fromPort":
            suggest = "from_port"
        elif key == "ipv6Cidrs":
            suggest = "ipv6_cidrs"
        elif key == "toPort":
            suggest = "to_port"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in InstancePort. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        InstancePort.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        InstancePort.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 access_direction: Optional[builtins.str] = None,
                 access_from: Optional[builtins.str] = None,
                 access_type: Optional[builtins.str] = None,
                 cidr_list_aliases: Optional[Sequence[builtins.str]] = None,
                 cidrs: Optional[Sequence[builtins.str]] = None,
                 common_name: Optional[builtins.str] = None,
                 from_port: Optional[builtins.int] = None,
                 ipv6_cidrs: Optional[Sequence[builtins.str]] = None,
                 protocol: Optional[builtins.str] = None,
                 to_port: Optional[builtins.int] = None):
        """
        Port of the Instance.
        :param builtins.str access_direction: Access Direction for Protocol of the Instance(inbound/outbound).
        :param builtins.str access_from: Access From Protocol of the Instance.
        :param builtins.str access_type: Access Type Protocol of the Instance.
        :param Sequence[builtins.str] cidr_list_aliases: An alias that defines access for a preconfigured range of IP addresses.
               
               The only alias currently supported is `lightsail-connect` , which allows IP addresses of the browser-based RDP/SSH client in the Lightsail console to connect to your instance.
        :param Sequence[builtins.str] cidrs: The IPv4 address, or range of IPv4 addresses (in CIDR notation) that are allowed to connect to an instance through the ports, and the protocol.
               
               > The `ipv6Cidrs` parameter lists the IPv6 addresses that are allowed to connect to an instance. 
               
               Examples:
               
               - To allow the IP address `192.0.2.44` , specify `192.0.2.44` or `192.0.2.44/32` .
               - To allow the IP addresses `192.0.2.0` to `192.0.2.255` , specify `192.0.2.0/24` .
        :param builtins.str common_name: CommonName for Protocol of the Instance.
        :param builtins.int from_port: From Port of the Instance.
        :param Sequence[builtins.str] ipv6_cidrs: The IPv6 address, or range of IPv6 addresses (in CIDR notation) that are allowed to connect to an instance through the ports, and the protocol. Only devices with an IPv6 address can connect to an instance through IPv6; otherwise, IPv4 should be used.
               
               > The `cidrs` parameter lists the IPv4 addresses that are allowed to connect to an instance.
        :param builtins.str protocol: Port Protocol of the Instance.
        :param builtins.int to_port: To Port of the Instance.
        """
        if access_direction is not None:
            pulumi.set(__self__, "access_direction", access_direction)
        if access_from is not None:
            pulumi.set(__self__, "access_from", access_from)
        if access_type is not None:
            pulumi.set(__self__, "access_type", access_type)
        if cidr_list_aliases is not None:
            pulumi.set(__self__, "cidr_list_aliases", cidr_list_aliases)
        if cidrs is not None:
            pulumi.set(__self__, "cidrs", cidrs)
        if common_name is not None:
            pulumi.set(__self__, "common_name", common_name)
        if from_port is not None:
            pulumi.set(__self__, "from_port", from_port)
        if ipv6_cidrs is not None:
            pulumi.set(__self__, "ipv6_cidrs", ipv6_cidrs)
        if protocol is not None:
            pulumi.set(__self__, "protocol", protocol)
        if to_port is not None:
            pulumi.set(__self__, "to_port", to_port)

    @property
    @pulumi.getter(name="accessDirection")
    def access_direction(self) -> Optional[builtins.str]:
        """
        Access Direction for Protocol of the Instance(inbound/outbound).
        """
        return pulumi.get(self, "access_direction")

    @property
    @pulumi.getter(name="accessFrom")
    def access_from(self) -> Optional[builtins.str]:
        """
        Access From Protocol of the Instance.
        """
        return pulumi.get(self, "access_from")

    @property
    @pulumi.getter(name="accessType")
    def access_type(self) -> Optional[builtins.str]:
        """
        Access Type Protocol of the Instance.
        """
        return pulumi.get(self, "access_type")

    @property
    @pulumi.getter(name="cidrListAliases")
    def cidr_list_aliases(self) -> Optional[Sequence[builtins.str]]:
        """
        An alias that defines access for a preconfigured range of IP addresses.

        The only alias currently supported is `lightsail-connect` , which allows IP addresses of the browser-based RDP/SSH client in the Lightsail console to connect to your instance.
        """
        return pulumi.get(self, "cidr_list_aliases")

    @property
    @pulumi.getter
    def cidrs(self) -> Optional[Sequence[builtins.str]]:
        """
        The IPv4 address, or range of IPv4 addresses (in CIDR notation) that are allowed to connect to an instance through the ports, and the protocol.

        > The `ipv6Cidrs` parameter lists the IPv6 addresses that are allowed to connect to an instance. 

        Examples:

        - To allow the IP address `192.0.2.44` , specify `192.0.2.44` or `192.0.2.44/32` .
        - To allow the IP addresses `192.0.2.0` to `192.0.2.255` , specify `192.0.2.0/24` .
        """
        return pulumi.get(self, "cidrs")

    @property
    @pulumi.getter(name="commonName")
    def common_name(self) -> Optional[builtins.str]:
        """
        CommonName for Protocol of the Instance.
        """
        return pulumi.get(self, "common_name")

    @property
    @pulumi.getter(name="fromPort")
    def from_port(self) -> Optional[builtins.int]:
        """
        From Port of the Instance.
        """
        return pulumi.get(self, "from_port")

    @property
    @pulumi.getter(name="ipv6Cidrs")
    def ipv6_cidrs(self) -> Optional[Sequence[builtins.str]]:
        """
        The IPv6 address, or range of IPv6 addresses (in CIDR notation) that are allowed to connect to an instance through the ports, and the protocol. Only devices with an IPv6 address can connect to an instance through IPv6; otherwise, IPv4 should be used.

        > The `cidrs` parameter lists the IPv4 addresses that are allowed to connect to an instance.
        """
        return pulumi.get(self, "ipv6_cidrs")

    @property
    @pulumi.getter
    def protocol(self) -> Optional[builtins.str]:
        """
        Port Protocol of the Instance.
        """
        return pulumi.get(self, "protocol")

    @property
    @pulumi.getter(name="toPort")
    def to_port(self) -> Optional[builtins.int]:
        """
        To Port of the Instance.
        """
        return pulumi.get(self, "to_port")


@pulumi.output_type
class InstanceSnapshotLocation(dict):
    """
    The region name and Availability Zone where you created the snapshot.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "availabilityZone":
            suggest = "availability_zone"
        elif key == "regionName":
            suggest = "region_name"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in InstanceSnapshotLocation. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        InstanceSnapshotLocation.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        InstanceSnapshotLocation.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 availability_zone: Optional[builtins.str] = None,
                 region_name: Optional[builtins.str] = None):
        """
        The region name and Availability Zone where you created the snapshot.
        :param builtins.str availability_zone: The Availability Zone. Follows the format us-east-2a (case-sensitive).
        :param builtins.str region_name: The AWS Region name.
        """
        if availability_zone is not None:
            pulumi.set(__self__, "availability_zone", availability_zone)
        if region_name is not None:
            pulumi.set(__self__, "region_name", region_name)

    @property
    @pulumi.getter(name="availabilityZone")
    def availability_zone(self) -> Optional[builtins.str]:
        """
        The Availability Zone. Follows the format us-east-2a (case-sensitive).
        """
        return pulumi.get(self, "availability_zone")

    @property
    @pulumi.getter(name="regionName")
    def region_name(self) -> Optional[builtins.str]:
        """
        The AWS Region name.
        """
        return pulumi.get(self, "region_name")


@pulumi.output_type
class InstanceState(dict):
    """
    Current State of the Instance.
    """
    def __init__(__self__, *,
                 code: Optional[builtins.int] = None,
                 name: Optional[builtins.str] = None):
        """
        Current State of the Instance.
        :param builtins.int code: Status code of the Instance.
        :param builtins.str name: Status code of the Instance.
        """
        if code is not None:
            pulumi.set(__self__, "code", code)
        if name is not None:
            pulumi.set(__self__, "name", name)

    @property
    @pulumi.getter
    def code(self) -> Optional[builtins.int]:
        """
        Status code of the Instance.
        """
        return pulumi.get(self, "code")

    @property
    @pulumi.getter
    def name(self) -> Optional[builtins.str]:
        """
        Status code of the Instance.
        """
        return pulumi.get(self, "name")


