# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities

__all__ = ['LoadBalancerTlsCertificateArgs', 'LoadBalancerTlsCertificate']

@pulumi.input_type
class LoadBalancerTlsCertificateArgs:
    def __init__(__self__, *,
                 certificate_domain_name: pulumi.Input[builtins.str],
                 load_balancer_name: pulumi.Input[builtins.str],
                 certificate_alternative_names: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
                 certificate_name: Optional[pulumi.Input[builtins.str]] = None,
                 https_redirection_enabled: Optional[pulumi.Input[builtins.bool]] = None,
                 is_attached: Optional[pulumi.Input[builtins.bool]] = None):
        """
        The set of arguments for constructing a LoadBalancerTlsCertificate resource.
        :param pulumi.Input[builtins.str] certificate_domain_name: The domain name (e.g., example.com ) for your SSL/TLS certificate.
        :param pulumi.Input[builtins.str] load_balancer_name: The name of your load balancer.
        :param pulumi.Input[Sequence[pulumi.Input[builtins.str]]] certificate_alternative_names: An array of strings listing alternative domains and subdomains for your SSL/TLS certificate.
        :param pulumi.Input[builtins.str] certificate_name: The SSL/TLS certificate name.
        :param pulumi.Input[builtins.bool] https_redirection_enabled: A Boolean value that indicates whether HTTPS redirection is enabled for the load balancer.
        :param pulumi.Input[builtins.bool] is_attached: When true, the SSL/TLS certificate is attached to the Lightsail load balancer.
        """
        pulumi.set(__self__, "certificate_domain_name", certificate_domain_name)
        pulumi.set(__self__, "load_balancer_name", load_balancer_name)
        if certificate_alternative_names is not None:
            pulumi.set(__self__, "certificate_alternative_names", certificate_alternative_names)
        if certificate_name is not None:
            pulumi.set(__self__, "certificate_name", certificate_name)
        if https_redirection_enabled is not None:
            pulumi.set(__self__, "https_redirection_enabled", https_redirection_enabled)
        if is_attached is not None:
            pulumi.set(__self__, "is_attached", is_attached)

    @property
    @pulumi.getter(name="certificateDomainName")
    def certificate_domain_name(self) -> pulumi.Input[builtins.str]:
        """
        The domain name (e.g., example.com ) for your SSL/TLS certificate.
        """
        return pulumi.get(self, "certificate_domain_name")

    @certificate_domain_name.setter
    def certificate_domain_name(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "certificate_domain_name", value)

    @property
    @pulumi.getter(name="loadBalancerName")
    def load_balancer_name(self) -> pulumi.Input[builtins.str]:
        """
        The name of your load balancer.
        """
        return pulumi.get(self, "load_balancer_name")

    @load_balancer_name.setter
    def load_balancer_name(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "load_balancer_name", value)

    @property
    @pulumi.getter(name="certificateAlternativeNames")
    def certificate_alternative_names(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]:
        """
        An array of strings listing alternative domains and subdomains for your SSL/TLS certificate.
        """
        return pulumi.get(self, "certificate_alternative_names")

    @certificate_alternative_names.setter
    def certificate_alternative_names(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "certificate_alternative_names", value)

    @property
    @pulumi.getter(name="certificateName")
    def certificate_name(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The SSL/TLS certificate name.
        """
        return pulumi.get(self, "certificate_name")

    @certificate_name.setter
    def certificate_name(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "certificate_name", value)

    @property
    @pulumi.getter(name="httpsRedirectionEnabled")
    def https_redirection_enabled(self) -> Optional[pulumi.Input[builtins.bool]]:
        """
        A Boolean value that indicates whether HTTPS redirection is enabled for the load balancer.
        """
        return pulumi.get(self, "https_redirection_enabled")

    @https_redirection_enabled.setter
    def https_redirection_enabled(self, value: Optional[pulumi.Input[builtins.bool]]):
        pulumi.set(self, "https_redirection_enabled", value)

    @property
    @pulumi.getter(name="isAttached")
    def is_attached(self) -> Optional[pulumi.Input[builtins.bool]]:
        """
        When true, the SSL/TLS certificate is attached to the Lightsail load balancer.
        """
        return pulumi.get(self, "is_attached")

    @is_attached.setter
    def is_attached(self, value: Optional[pulumi.Input[builtins.bool]]):
        pulumi.set(self, "is_attached", value)


@pulumi.type_token("aws-native:lightsail:LoadBalancerTlsCertificate")
class LoadBalancerTlsCertificate(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 certificate_alternative_names: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
                 certificate_domain_name: Optional[pulumi.Input[builtins.str]] = None,
                 certificate_name: Optional[pulumi.Input[builtins.str]] = None,
                 https_redirection_enabled: Optional[pulumi.Input[builtins.bool]] = None,
                 is_attached: Optional[pulumi.Input[builtins.bool]] = None,
                 load_balancer_name: Optional[pulumi.Input[builtins.str]] = None,
                 __props__=None):
        """
        Resource Type definition for AWS::Lightsail::LoadBalancerTlsCertificate

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[Sequence[pulumi.Input[builtins.str]]] certificate_alternative_names: An array of strings listing alternative domains and subdomains for your SSL/TLS certificate.
        :param pulumi.Input[builtins.str] certificate_domain_name: The domain name (e.g., example.com ) for your SSL/TLS certificate.
        :param pulumi.Input[builtins.str] certificate_name: The SSL/TLS certificate name.
        :param pulumi.Input[builtins.bool] https_redirection_enabled: A Boolean value that indicates whether HTTPS redirection is enabled for the load balancer.
        :param pulumi.Input[builtins.bool] is_attached: When true, the SSL/TLS certificate is attached to the Lightsail load balancer.
        :param pulumi.Input[builtins.str] load_balancer_name: The name of your load balancer.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: LoadBalancerTlsCertificateArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Resource Type definition for AWS::Lightsail::LoadBalancerTlsCertificate

        :param str resource_name: The name of the resource.
        :param LoadBalancerTlsCertificateArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(LoadBalancerTlsCertificateArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 certificate_alternative_names: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
                 certificate_domain_name: Optional[pulumi.Input[builtins.str]] = None,
                 certificate_name: Optional[pulumi.Input[builtins.str]] = None,
                 https_redirection_enabled: Optional[pulumi.Input[builtins.bool]] = None,
                 is_attached: Optional[pulumi.Input[builtins.bool]] = None,
                 load_balancer_name: Optional[pulumi.Input[builtins.str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = LoadBalancerTlsCertificateArgs.__new__(LoadBalancerTlsCertificateArgs)

            __props__.__dict__["certificate_alternative_names"] = certificate_alternative_names
            if certificate_domain_name is None and not opts.urn:
                raise TypeError("Missing required property 'certificate_domain_name'")
            __props__.__dict__["certificate_domain_name"] = certificate_domain_name
            __props__.__dict__["certificate_name"] = certificate_name
            __props__.__dict__["https_redirection_enabled"] = https_redirection_enabled
            __props__.__dict__["is_attached"] = is_attached
            if load_balancer_name is None and not opts.urn:
                raise TypeError("Missing required property 'load_balancer_name'")
            __props__.__dict__["load_balancer_name"] = load_balancer_name
            __props__.__dict__["load_balancer_tls_certificate_arn"] = None
            __props__.__dict__["status"] = None
        replace_on_changes = pulumi.ResourceOptions(replace_on_changes=["certificateAlternativeNames[*]", "certificateDomainName", "certificateName", "loadBalancerName"])
        opts = pulumi.ResourceOptions.merge(opts, replace_on_changes)
        super(LoadBalancerTlsCertificate, __self__).__init__(
            'aws-native:lightsail:LoadBalancerTlsCertificate',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None) -> 'LoadBalancerTlsCertificate':
        """
        Get an existing LoadBalancerTlsCertificate resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = LoadBalancerTlsCertificateArgs.__new__(LoadBalancerTlsCertificateArgs)

        __props__.__dict__["certificate_alternative_names"] = None
        __props__.__dict__["certificate_domain_name"] = None
        __props__.__dict__["certificate_name"] = None
        __props__.__dict__["https_redirection_enabled"] = None
        __props__.__dict__["is_attached"] = None
        __props__.__dict__["load_balancer_name"] = None
        __props__.__dict__["load_balancer_tls_certificate_arn"] = None
        __props__.__dict__["status"] = None
        return LoadBalancerTlsCertificate(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter(name="certificateAlternativeNames")
    def certificate_alternative_names(self) -> pulumi.Output[Optional[Sequence[builtins.str]]]:
        """
        An array of strings listing alternative domains and subdomains for your SSL/TLS certificate.
        """
        return pulumi.get(self, "certificate_alternative_names")

    @property
    @pulumi.getter(name="certificateDomainName")
    def certificate_domain_name(self) -> pulumi.Output[builtins.str]:
        """
        The domain name (e.g., example.com ) for your SSL/TLS certificate.
        """
        return pulumi.get(self, "certificate_domain_name")

    @property
    @pulumi.getter(name="certificateName")
    def certificate_name(self) -> pulumi.Output[builtins.str]:
        """
        The SSL/TLS certificate name.
        """
        return pulumi.get(self, "certificate_name")

    @property
    @pulumi.getter(name="httpsRedirectionEnabled")
    def https_redirection_enabled(self) -> pulumi.Output[Optional[builtins.bool]]:
        """
        A Boolean value that indicates whether HTTPS redirection is enabled for the load balancer.
        """
        return pulumi.get(self, "https_redirection_enabled")

    @property
    @pulumi.getter(name="isAttached")
    def is_attached(self) -> pulumi.Output[Optional[builtins.bool]]:
        """
        When true, the SSL/TLS certificate is attached to the Lightsail load balancer.
        """
        return pulumi.get(self, "is_attached")

    @property
    @pulumi.getter(name="loadBalancerName")
    def load_balancer_name(self) -> pulumi.Output[builtins.str]:
        """
        The name of your load balancer.
        """
        return pulumi.get(self, "load_balancer_name")

    @property
    @pulumi.getter(name="loadBalancerTlsCertificateArn")
    def load_balancer_tls_certificate_arn(self) -> pulumi.Output[builtins.str]:
        """
        The Amazon Resource Name (ARN) of the SSL/TLS certificate.
        """
        return pulumi.get(self, "load_balancer_tls_certificate_arn")

    @property
    @pulumi.getter
    def status(self) -> pulumi.Output[builtins.str]:
        """
        The validation status of the SSL/TLS certificate.
        """
        return pulumi.get(self, "status")

