# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs
from .. import _inputs as _root_inputs
from .. import outputs as _root_outputs

__all__ = ['InstanceSnapshotArgs', 'InstanceSnapshot']

@pulumi.input_type
class InstanceSnapshotArgs:
    def __init__(__self__, *,
                 instance_name: pulumi.Input[builtins.str],
                 instance_snapshot_name: Optional[pulumi.Input[builtins.str]] = None,
                 tags: Optional[pulumi.Input[Sequence[pulumi.Input['_root_inputs.TagArgs']]]] = None):
        """
        The set of arguments for constructing a InstanceSnapshot resource.
        :param pulumi.Input[builtins.str] instance_name: The instance from which the snapshot was created.
        :param pulumi.Input[builtins.str] instance_snapshot_name: The name of the snapshot.
        :param pulumi.Input[Sequence[pulumi.Input['_root_inputs.TagArgs']]] tags: An array of key-value pairs to apply to this resource.
        """
        pulumi.set(__self__, "instance_name", instance_name)
        if instance_snapshot_name is not None:
            pulumi.set(__self__, "instance_snapshot_name", instance_snapshot_name)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)

    @property
    @pulumi.getter(name="instanceName")
    def instance_name(self) -> pulumi.Input[builtins.str]:
        """
        The instance from which the snapshot was created.
        """
        return pulumi.get(self, "instance_name")

    @instance_name.setter
    def instance_name(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "instance_name", value)

    @property
    @pulumi.getter(name="instanceSnapshotName")
    def instance_snapshot_name(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The name of the snapshot.
        """
        return pulumi.get(self, "instance_snapshot_name")

    @instance_snapshot_name.setter
    def instance_snapshot_name(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "instance_snapshot_name", value)

    @property
    @pulumi.getter
    def tags(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['_root_inputs.TagArgs']]]]:
        """
        An array of key-value pairs to apply to this resource.
        """
        return pulumi.get(self, "tags")

    @tags.setter
    def tags(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['_root_inputs.TagArgs']]]]):
        pulumi.set(self, "tags", value)


@pulumi.type_token("aws-native:lightsail:InstanceSnapshot")
class InstanceSnapshot(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 instance_name: Optional[pulumi.Input[builtins.str]] = None,
                 instance_snapshot_name: Optional[pulumi.Input[builtins.str]] = None,
                 tags: Optional[pulumi.Input[Sequence[pulumi.Input[Union['_root_inputs.TagArgs', '_root_inputs.TagArgsDict']]]]] = None,
                 __props__=None):
        """
        Resource Type definition for AWS::Lightsail::InstanceSnapshot

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[builtins.str] instance_name: The instance from which the snapshot was created.
        :param pulumi.Input[builtins.str] instance_snapshot_name: The name of the snapshot.
        :param pulumi.Input[Sequence[pulumi.Input[Union['_root_inputs.TagArgs', '_root_inputs.TagArgsDict']]]] tags: An array of key-value pairs to apply to this resource.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: InstanceSnapshotArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Resource Type definition for AWS::Lightsail::InstanceSnapshot

        :param str resource_name: The name of the resource.
        :param InstanceSnapshotArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(InstanceSnapshotArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 instance_name: Optional[pulumi.Input[builtins.str]] = None,
                 instance_snapshot_name: Optional[pulumi.Input[builtins.str]] = None,
                 tags: Optional[pulumi.Input[Sequence[pulumi.Input[Union['_root_inputs.TagArgs', '_root_inputs.TagArgsDict']]]]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = InstanceSnapshotArgs.__new__(InstanceSnapshotArgs)

            if instance_name is None and not opts.urn:
                raise TypeError("Missing required property 'instance_name'")
            __props__.__dict__["instance_name"] = instance_name
            __props__.__dict__["instance_snapshot_name"] = instance_snapshot_name
            __props__.__dict__["tags"] = tags
            __props__.__dict__["arn"] = None
            __props__.__dict__["from_instance_arn"] = None
            __props__.__dict__["from_instance_name"] = None
            __props__.__dict__["is_from_auto_snapshot"] = None
            __props__.__dict__["location"] = None
            __props__.__dict__["resource_type"] = None
            __props__.__dict__["size_in_gb"] = None
            __props__.__dict__["state"] = None
            __props__.__dict__["support_code"] = None
        replace_on_changes = pulumi.ResourceOptions(replace_on_changes=["instanceName", "instanceSnapshotName"])
        opts = pulumi.ResourceOptions.merge(opts, replace_on_changes)
        super(InstanceSnapshot, __self__).__init__(
            'aws-native:lightsail:InstanceSnapshot',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None) -> 'InstanceSnapshot':
        """
        Get an existing InstanceSnapshot resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = InstanceSnapshotArgs.__new__(InstanceSnapshotArgs)

        __props__.__dict__["arn"] = None
        __props__.__dict__["from_instance_arn"] = None
        __props__.__dict__["from_instance_name"] = None
        __props__.__dict__["instance_name"] = None
        __props__.__dict__["instance_snapshot_name"] = None
        __props__.__dict__["is_from_auto_snapshot"] = None
        __props__.__dict__["location"] = None
        __props__.__dict__["resource_type"] = None
        __props__.__dict__["size_in_gb"] = None
        __props__.__dict__["state"] = None
        __props__.__dict__["support_code"] = None
        __props__.__dict__["tags"] = None
        return InstanceSnapshot(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter
    def arn(self) -> pulumi.Output[builtins.str]:
        """
        The Amazon Resource Name (ARN) of the snapshot.
        """
        return pulumi.get(self, "arn")

    @property
    @pulumi.getter(name="fromInstanceArn")
    def from_instance_arn(self) -> pulumi.Output[builtins.str]:
        """
        The Amazon Resource Name (ARN) of the instance from which the snapshot was created.
        """
        return pulumi.get(self, "from_instance_arn")

    @property
    @pulumi.getter(name="fromInstanceName")
    def from_instance_name(self) -> pulumi.Output[builtins.str]:
        """
        The instance from which the snapshot was created.
        """
        return pulumi.get(self, "from_instance_name")

    @property
    @pulumi.getter(name="instanceName")
    def instance_name(self) -> pulumi.Output[builtins.str]:
        """
        The instance from which the snapshot was created.
        """
        return pulumi.get(self, "instance_name")

    @property
    @pulumi.getter(name="instanceSnapshotName")
    def instance_snapshot_name(self) -> pulumi.Output[builtins.str]:
        """
        The name of the snapshot.
        """
        return pulumi.get(self, "instance_snapshot_name")

    @property
    @pulumi.getter(name="isFromAutoSnapshot")
    def is_from_auto_snapshot(self) -> pulumi.Output[builtins.bool]:
        """
        A Boolean value indicating whether the snapshot was created from an automatic snapshot.
        """
        return pulumi.get(self, "is_from_auto_snapshot")

    @property
    @pulumi.getter
    def location(self) -> pulumi.Output['outputs.InstanceSnapshotLocation']:
        return pulumi.get(self, "location")

    @property
    @pulumi.getter(name="resourceType")
    def resource_type(self) -> pulumi.Output[builtins.str]:
        """
        The type of resource (usually InstanceSnapshot).
        """
        return pulumi.get(self, "resource_type")

    @property
    @pulumi.getter(name="sizeInGb")
    def size_in_gb(self) -> pulumi.Output[builtins.int]:
        """
        The size in GB of the SSD
        """
        return pulumi.get(self, "size_in_gb")

    @property
    @pulumi.getter
    def state(self) -> pulumi.Output[builtins.str]:
        """
        The state the snapshot is in.
        """
        return pulumi.get(self, "state")

    @property
    @pulumi.getter(name="supportCode")
    def support_code(self) -> pulumi.Output[builtins.str]:
        """
        Support code to help identify any issues
        """
        return pulumi.get(self, "support_code")

    @property
    @pulumi.getter
    def tags(self) -> pulumi.Output[Optional[Sequence['_root_outputs.Tag']]]:
        """
        An array of key-value pairs to apply to this resource.
        """
        return pulumi.get(self, "tags")

