# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs
from .. import outputs as _root_outputs

__all__ = [
    'GetInstanceSnapshotResult',
    'AwaitableGetInstanceSnapshotResult',
    'get_instance_snapshot',
    'get_instance_snapshot_output',
]

@pulumi.output_type
class GetInstanceSnapshotResult:
    def __init__(__self__, arn=None, from_instance_arn=None, from_instance_name=None, is_from_auto_snapshot=None, location=None, resource_type=None, size_in_gb=None, state=None, support_code=None, tags=None):
        if arn and not isinstance(arn, str):
            raise TypeError("Expected argument 'arn' to be a str")
        pulumi.set(__self__, "arn", arn)
        if from_instance_arn and not isinstance(from_instance_arn, str):
            raise TypeError("Expected argument 'from_instance_arn' to be a str")
        pulumi.set(__self__, "from_instance_arn", from_instance_arn)
        if from_instance_name and not isinstance(from_instance_name, str):
            raise TypeError("Expected argument 'from_instance_name' to be a str")
        pulumi.set(__self__, "from_instance_name", from_instance_name)
        if is_from_auto_snapshot and not isinstance(is_from_auto_snapshot, bool):
            raise TypeError("Expected argument 'is_from_auto_snapshot' to be a bool")
        pulumi.set(__self__, "is_from_auto_snapshot", is_from_auto_snapshot)
        if location and not isinstance(location, dict):
            raise TypeError("Expected argument 'location' to be a dict")
        pulumi.set(__self__, "location", location)
        if resource_type and not isinstance(resource_type, str):
            raise TypeError("Expected argument 'resource_type' to be a str")
        pulumi.set(__self__, "resource_type", resource_type)
        if size_in_gb and not isinstance(size_in_gb, int):
            raise TypeError("Expected argument 'size_in_gb' to be a int")
        pulumi.set(__self__, "size_in_gb", size_in_gb)
        if state and not isinstance(state, str):
            raise TypeError("Expected argument 'state' to be a str")
        pulumi.set(__self__, "state", state)
        if support_code and not isinstance(support_code, str):
            raise TypeError("Expected argument 'support_code' to be a str")
        pulumi.set(__self__, "support_code", support_code)
        if tags and not isinstance(tags, list):
            raise TypeError("Expected argument 'tags' to be a list")
        pulumi.set(__self__, "tags", tags)

    @property
    @pulumi.getter
    def arn(self) -> Optional[builtins.str]:
        """
        The Amazon Resource Name (ARN) of the snapshot.
        """
        return pulumi.get(self, "arn")

    @property
    @pulumi.getter(name="fromInstanceArn")
    def from_instance_arn(self) -> Optional[builtins.str]:
        """
        The Amazon Resource Name (ARN) of the instance from which the snapshot was created.
        """
        return pulumi.get(self, "from_instance_arn")

    @property
    @pulumi.getter(name="fromInstanceName")
    def from_instance_name(self) -> Optional[builtins.str]:
        """
        The instance from which the snapshot was created.
        """
        return pulumi.get(self, "from_instance_name")

    @property
    @pulumi.getter(name="isFromAutoSnapshot")
    def is_from_auto_snapshot(self) -> Optional[builtins.bool]:
        """
        A Boolean value indicating whether the snapshot was created from an automatic snapshot.
        """
        return pulumi.get(self, "is_from_auto_snapshot")

    @property
    @pulumi.getter
    def location(self) -> Optional['outputs.InstanceSnapshotLocation']:
        return pulumi.get(self, "location")

    @property
    @pulumi.getter(name="resourceType")
    def resource_type(self) -> Optional[builtins.str]:
        """
        The type of resource (usually InstanceSnapshot).
        """
        return pulumi.get(self, "resource_type")

    @property
    @pulumi.getter(name="sizeInGb")
    def size_in_gb(self) -> Optional[builtins.int]:
        """
        The size in GB of the SSD
        """
        return pulumi.get(self, "size_in_gb")

    @property
    @pulumi.getter
    def state(self) -> Optional[builtins.str]:
        """
        The state the snapshot is in.
        """
        return pulumi.get(self, "state")

    @property
    @pulumi.getter(name="supportCode")
    def support_code(self) -> Optional[builtins.str]:
        """
        Support code to help identify any issues
        """
        return pulumi.get(self, "support_code")

    @property
    @pulumi.getter
    def tags(self) -> Optional[Sequence['_root_outputs.Tag']]:
        """
        An array of key-value pairs to apply to this resource.
        """
        return pulumi.get(self, "tags")


class AwaitableGetInstanceSnapshotResult(GetInstanceSnapshotResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetInstanceSnapshotResult(
            arn=self.arn,
            from_instance_arn=self.from_instance_arn,
            from_instance_name=self.from_instance_name,
            is_from_auto_snapshot=self.is_from_auto_snapshot,
            location=self.location,
            resource_type=self.resource_type,
            size_in_gb=self.size_in_gb,
            state=self.state,
            support_code=self.support_code,
            tags=self.tags)


def get_instance_snapshot(instance_snapshot_name: Optional[builtins.str] = None,
                          opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetInstanceSnapshotResult:
    """
    Resource Type definition for AWS::Lightsail::InstanceSnapshot


    :param builtins.str instance_snapshot_name: The name of the snapshot.
    """
    __args__ = dict()
    __args__['instanceSnapshotName'] = instance_snapshot_name
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('aws-native:lightsail:getInstanceSnapshot', __args__, opts=opts, typ=GetInstanceSnapshotResult).value

    return AwaitableGetInstanceSnapshotResult(
        arn=pulumi.get(__ret__, 'arn'),
        from_instance_arn=pulumi.get(__ret__, 'from_instance_arn'),
        from_instance_name=pulumi.get(__ret__, 'from_instance_name'),
        is_from_auto_snapshot=pulumi.get(__ret__, 'is_from_auto_snapshot'),
        location=pulumi.get(__ret__, 'location'),
        resource_type=pulumi.get(__ret__, 'resource_type'),
        size_in_gb=pulumi.get(__ret__, 'size_in_gb'),
        state=pulumi.get(__ret__, 'state'),
        support_code=pulumi.get(__ret__, 'support_code'),
        tags=pulumi.get(__ret__, 'tags'))
def get_instance_snapshot_output(instance_snapshot_name: Optional[pulumi.Input[builtins.str]] = None,
                                 opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetInstanceSnapshotResult]:
    """
    Resource Type definition for AWS::Lightsail::InstanceSnapshot


    :param builtins.str instance_snapshot_name: The name of the snapshot.
    """
    __args__ = dict()
    __args__['instanceSnapshotName'] = instance_snapshot_name
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('aws-native:lightsail:getInstanceSnapshot', __args__, opts=opts, typ=GetInstanceSnapshotResult)
    return __ret__.apply(lambda __response__: GetInstanceSnapshotResult(
        arn=pulumi.get(__response__, 'arn'),
        from_instance_arn=pulumi.get(__response__, 'from_instance_arn'),
        from_instance_name=pulumi.get(__response__, 'from_instance_name'),
        is_from_auto_snapshot=pulumi.get(__response__, 'is_from_auto_snapshot'),
        location=pulumi.get(__response__, 'location'),
        resource_type=pulumi.get(__response__, 'resource_type'),
        size_in_gb=pulumi.get(__response__, 'size_in_gb'),
        state=pulumi.get(__response__, 'state'),
        support_code=pulumi.get(__response__, 'support_code'),
        tags=pulumi.get(__response__, 'tags')))
