# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities

__all__ = [
    'LicenseBorrowConfigurationArgs',
    'LicenseBorrowConfigurationArgsDict',
    'LicenseConsumptionConfigurationArgs',
    'LicenseConsumptionConfigurationArgsDict',
    'LicenseEntitlementArgs',
    'LicenseEntitlementArgsDict',
    'LicenseIssuerDataArgs',
    'LicenseIssuerDataArgsDict',
    'LicenseMetadataArgs',
    'LicenseMetadataArgsDict',
    'LicenseProvisionalConfigurationArgs',
    'LicenseProvisionalConfigurationArgsDict',
    'LicenseValidityDateFormatArgs',
    'LicenseValidityDateFormatArgsDict',
]

MYPY = False

if not MYPY:
    class LicenseBorrowConfigurationArgsDict(TypedDict):
        allow_early_check_in: pulumi.Input[builtins.bool]
        """
        Indicates whether early check-ins are allowed.
        """
        max_time_to_live_in_minutes: pulumi.Input[builtins.int]
        """
        Maximum time for the borrow configuration, in minutes.
        """
elif False:
    LicenseBorrowConfigurationArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class LicenseBorrowConfigurationArgs:
    def __init__(__self__, *,
                 allow_early_check_in: pulumi.Input[builtins.bool],
                 max_time_to_live_in_minutes: pulumi.Input[builtins.int]):
        """
        :param pulumi.Input[builtins.bool] allow_early_check_in: Indicates whether early check-ins are allowed.
        :param pulumi.Input[builtins.int] max_time_to_live_in_minutes: Maximum time for the borrow configuration, in minutes.
        """
        pulumi.set(__self__, "allow_early_check_in", allow_early_check_in)
        pulumi.set(__self__, "max_time_to_live_in_minutes", max_time_to_live_in_minutes)

    @property
    @pulumi.getter(name="allowEarlyCheckIn")
    def allow_early_check_in(self) -> pulumi.Input[builtins.bool]:
        """
        Indicates whether early check-ins are allowed.
        """
        return pulumi.get(self, "allow_early_check_in")

    @allow_early_check_in.setter
    def allow_early_check_in(self, value: pulumi.Input[builtins.bool]):
        pulumi.set(self, "allow_early_check_in", value)

    @property
    @pulumi.getter(name="maxTimeToLiveInMinutes")
    def max_time_to_live_in_minutes(self) -> pulumi.Input[builtins.int]:
        """
        Maximum time for the borrow configuration, in minutes.
        """
        return pulumi.get(self, "max_time_to_live_in_minutes")

    @max_time_to_live_in_minutes.setter
    def max_time_to_live_in_minutes(self, value: pulumi.Input[builtins.int]):
        pulumi.set(self, "max_time_to_live_in_minutes", value)


if not MYPY:
    class LicenseConsumptionConfigurationArgsDict(TypedDict):
        borrow_configuration: NotRequired[pulumi.Input['LicenseBorrowConfigurationArgsDict']]
        """
        Details about a borrow configuration.
        """
        provisional_configuration: NotRequired[pulumi.Input['LicenseProvisionalConfigurationArgsDict']]
        """
        Details about a provisional configuration.
        """
        renew_type: NotRequired[pulumi.Input[builtins.str]]
        """
        Renewal frequency.
        """
elif False:
    LicenseConsumptionConfigurationArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class LicenseConsumptionConfigurationArgs:
    def __init__(__self__, *,
                 borrow_configuration: Optional[pulumi.Input['LicenseBorrowConfigurationArgs']] = None,
                 provisional_configuration: Optional[pulumi.Input['LicenseProvisionalConfigurationArgs']] = None,
                 renew_type: Optional[pulumi.Input[builtins.str]] = None):
        """
        :param pulumi.Input['LicenseBorrowConfigurationArgs'] borrow_configuration: Details about a borrow configuration.
        :param pulumi.Input['LicenseProvisionalConfigurationArgs'] provisional_configuration: Details about a provisional configuration.
        :param pulumi.Input[builtins.str] renew_type: Renewal frequency.
        """
        if borrow_configuration is not None:
            pulumi.set(__self__, "borrow_configuration", borrow_configuration)
        if provisional_configuration is not None:
            pulumi.set(__self__, "provisional_configuration", provisional_configuration)
        if renew_type is not None:
            pulumi.set(__self__, "renew_type", renew_type)

    @property
    @pulumi.getter(name="borrowConfiguration")
    def borrow_configuration(self) -> Optional[pulumi.Input['LicenseBorrowConfigurationArgs']]:
        """
        Details about a borrow configuration.
        """
        return pulumi.get(self, "borrow_configuration")

    @borrow_configuration.setter
    def borrow_configuration(self, value: Optional[pulumi.Input['LicenseBorrowConfigurationArgs']]):
        pulumi.set(self, "borrow_configuration", value)

    @property
    @pulumi.getter(name="provisionalConfiguration")
    def provisional_configuration(self) -> Optional[pulumi.Input['LicenseProvisionalConfigurationArgs']]:
        """
        Details about a provisional configuration.
        """
        return pulumi.get(self, "provisional_configuration")

    @provisional_configuration.setter
    def provisional_configuration(self, value: Optional[pulumi.Input['LicenseProvisionalConfigurationArgs']]):
        pulumi.set(self, "provisional_configuration", value)

    @property
    @pulumi.getter(name="renewType")
    def renew_type(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Renewal frequency.
        """
        return pulumi.get(self, "renew_type")

    @renew_type.setter
    def renew_type(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "renew_type", value)


if not MYPY:
    class LicenseEntitlementArgsDict(TypedDict):
        name: pulumi.Input[builtins.str]
        """
        Entitlement name.
        """
        unit: pulumi.Input[builtins.str]
        """
        Entitlement unit.
        """
        allow_check_in: NotRequired[pulumi.Input[builtins.bool]]
        """
        Indicates whether check-ins are allowed.
        """
        max_count: NotRequired[pulumi.Input[builtins.int]]
        """
        Maximum entitlement count. Use if the unit is not None.
        """
        overage: NotRequired[pulumi.Input[builtins.bool]]
        """
        Indicates whether overages are allowed.
        """
        value: NotRequired[pulumi.Input[builtins.str]]
        """
        Entitlement resource. Use only if the unit is None.
        """
elif False:
    LicenseEntitlementArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class LicenseEntitlementArgs:
    def __init__(__self__, *,
                 name: pulumi.Input[builtins.str],
                 unit: pulumi.Input[builtins.str],
                 allow_check_in: Optional[pulumi.Input[builtins.bool]] = None,
                 max_count: Optional[pulumi.Input[builtins.int]] = None,
                 overage: Optional[pulumi.Input[builtins.bool]] = None,
                 value: Optional[pulumi.Input[builtins.str]] = None):
        """
        :param pulumi.Input[builtins.str] name: Entitlement name.
        :param pulumi.Input[builtins.str] unit: Entitlement unit.
        :param pulumi.Input[builtins.bool] allow_check_in: Indicates whether check-ins are allowed.
        :param pulumi.Input[builtins.int] max_count: Maximum entitlement count. Use if the unit is not None.
        :param pulumi.Input[builtins.bool] overage: Indicates whether overages are allowed.
        :param pulumi.Input[builtins.str] value: Entitlement resource. Use only if the unit is None.
        """
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "unit", unit)
        if allow_check_in is not None:
            pulumi.set(__self__, "allow_check_in", allow_check_in)
        if max_count is not None:
            pulumi.set(__self__, "max_count", max_count)
        if overage is not None:
            pulumi.set(__self__, "overage", overage)
        if value is not None:
            pulumi.set(__self__, "value", value)

    @property
    @pulumi.getter
    def name(self) -> pulumi.Input[builtins.str]:
        """
        Entitlement name.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter
    def unit(self) -> pulumi.Input[builtins.str]:
        """
        Entitlement unit.
        """
        return pulumi.get(self, "unit")

    @unit.setter
    def unit(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "unit", value)

    @property
    @pulumi.getter(name="allowCheckIn")
    def allow_check_in(self) -> Optional[pulumi.Input[builtins.bool]]:
        """
        Indicates whether check-ins are allowed.
        """
        return pulumi.get(self, "allow_check_in")

    @allow_check_in.setter
    def allow_check_in(self, value: Optional[pulumi.Input[builtins.bool]]):
        pulumi.set(self, "allow_check_in", value)

    @property
    @pulumi.getter(name="maxCount")
    def max_count(self) -> Optional[pulumi.Input[builtins.int]]:
        """
        Maximum entitlement count. Use if the unit is not None.
        """
        return pulumi.get(self, "max_count")

    @max_count.setter
    def max_count(self, value: Optional[pulumi.Input[builtins.int]]):
        pulumi.set(self, "max_count", value)

    @property
    @pulumi.getter
    def overage(self) -> Optional[pulumi.Input[builtins.bool]]:
        """
        Indicates whether overages are allowed.
        """
        return pulumi.get(self, "overage")

    @overage.setter
    def overage(self, value: Optional[pulumi.Input[builtins.bool]]):
        pulumi.set(self, "overage", value)

    @property
    @pulumi.getter
    def value(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Entitlement resource. Use only if the unit is None.
        """
        return pulumi.get(self, "value")

    @value.setter
    def value(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "value", value)


if not MYPY:
    class LicenseIssuerDataArgsDict(TypedDict):
        name: pulumi.Input[builtins.str]
        """
        Issuer name.
        """
        sign_key: NotRequired[pulumi.Input[builtins.str]]
        """
        Asymmetric KMS key from AWS Key Management Service . The KMS key must have a key usage of sign and verify, and support the RSASSA-PSS SHA-256 signing algorithm.
        """
elif False:
    LicenseIssuerDataArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class LicenseIssuerDataArgs:
    def __init__(__self__, *,
                 name: pulumi.Input[builtins.str],
                 sign_key: Optional[pulumi.Input[builtins.str]] = None):
        """
        :param pulumi.Input[builtins.str] name: Issuer name.
        :param pulumi.Input[builtins.str] sign_key: Asymmetric KMS key from AWS Key Management Service . The KMS key must have a key usage of sign and verify, and support the RSASSA-PSS SHA-256 signing algorithm.
        """
        pulumi.set(__self__, "name", name)
        if sign_key is not None:
            pulumi.set(__self__, "sign_key", sign_key)

    @property
    @pulumi.getter
    def name(self) -> pulumi.Input[builtins.str]:
        """
        Issuer name.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter(name="signKey")
    def sign_key(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Asymmetric KMS key from AWS Key Management Service . The KMS key must have a key usage of sign and verify, and support the RSASSA-PSS SHA-256 signing algorithm.
        """
        return pulumi.get(self, "sign_key")

    @sign_key.setter
    def sign_key(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "sign_key", value)


if not MYPY:
    class LicenseMetadataArgsDict(TypedDict):
        name: pulumi.Input[builtins.str]
        """
        The key name.
        """
        value: pulumi.Input[builtins.str]
        """
        The value.
        """
elif False:
    LicenseMetadataArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class LicenseMetadataArgs:
    def __init__(__self__, *,
                 name: pulumi.Input[builtins.str],
                 value: pulumi.Input[builtins.str]):
        """
        :param pulumi.Input[builtins.str] name: The key name.
        :param pulumi.Input[builtins.str] value: The value.
        """
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "value", value)

    @property
    @pulumi.getter
    def name(self) -> pulumi.Input[builtins.str]:
        """
        The key name.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter
    def value(self) -> pulumi.Input[builtins.str]:
        """
        The value.
        """
        return pulumi.get(self, "value")

    @value.setter
    def value(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "value", value)


if not MYPY:
    class LicenseProvisionalConfigurationArgsDict(TypedDict):
        max_time_to_live_in_minutes: pulumi.Input[builtins.int]
        """
        Maximum time for the provisional configuration, in minutes.
        """
elif False:
    LicenseProvisionalConfigurationArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class LicenseProvisionalConfigurationArgs:
    def __init__(__self__, *,
                 max_time_to_live_in_minutes: pulumi.Input[builtins.int]):
        """
        :param pulumi.Input[builtins.int] max_time_to_live_in_minutes: Maximum time for the provisional configuration, in minutes.
        """
        pulumi.set(__self__, "max_time_to_live_in_minutes", max_time_to_live_in_minutes)

    @property
    @pulumi.getter(name="maxTimeToLiveInMinutes")
    def max_time_to_live_in_minutes(self) -> pulumi.Input[builtins.int]:
        """
        Maximum time for the provisional configuration, in minutes.
        """
        return pulumi.get(self, "max_time_to_live_in_minutes")

    @max_time_to_live_in_minutes.setter
    def max_time_to_live_in_minutes(self, value: pulumi.Input[builtins.int]):
        pulumi.set(self, "max_time_to_live_in_minutes", value)


if not MYPY:
    class LicenseValidityDateFormatArgsDict(TypedDict):
        begin: pulumi.Input[builtins.str]
        """
        Validity begin date for the license.
        """
        end: pulumi.Input[builtins.str]
        """
        Validity begin date for the license.
        """
elif False:
    LicenseValidityDateFormatArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class LicenseValidityDateFormatArgs:
    def __init__(__self__, *,
                 begin: pulumi.Input[builtins.str],
                 end: pulumi.Input[builtins.str]):
        """
        :param pulumi.Input[builtins.str] begin: Validity begin date for the license.
        :param pulumi.Input[builtins.str] end: Validity begin date for the license.
        """
        pulumi.set(__self__, "begin", begin)
        pulumi.set(__self__, "end", end)

    @property
    @pulumi.getter
    def begin(self) -> pulumi.Input[builtins.str]:
        """
        Validity begin date for the license.
        """
        return pulumi.get(self, "begin")

    @begin.setter
    def begin(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "begin", value)

    @property
    @pulumi.getter
    def end(self) -> pulumi.Input[builtins.str]:
        """
        Validity begin date for the license.
        """
        return pulumi.get(self, "end")

    @end.setter
    def end(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "end", value)


