# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities

__all__ = [
    'GetBotVersionResult',
    'AwaitableGetBotVersionResult',
    'get_bot_version',
    'get_bot_version_output',
]

@pulumi.output_type
class GetBotVersionResult:
    def __init__(__self__, bot_version=None, description=None):
        if bot_version and not isinstance(bot_version, str):
            raise TypeError("Expected argument 'bot_version' to be a str")
        pulumi.set(__self__, "bot_version", bot_version)
        if description and not isinstance(description, str):
            raise TypeError("Expected argument 'description' to be a str")
        pulumi.set(__self__, "description", description)

    @property
    @pulumi.getter(name="botVersion")
    def bot_version(self) -> Optional[builtins.str]:
        """
        The version of the bot.
        """
        return pulumi.get(self, "bot_version")

    @property
    @pulumi.getter
    def description(self) -> Optional[builtins.str]:
        """
        The description of the version.
        """
        return pulumi.get(self, "description")


class AwaitableGetBotVersionResult(GetBotVersionResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetBotVersionResult(
            bot_version=self.bot_version,
            description=self.description)


def get_bot_version(bot_id: Optional[builtins.str] = None,
                    bot_version: Optional[builtins.str] = None,
                    opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetBotVersionResult:
    """
    A version is a numbered snapshot of your work that you can publish for use in different parts of your workflow, such as development, beta deployment, and production.


    :param builtins.str bot_id: The unique identifier of the bot.
    :param builtins.str bot_version: The version of the bot.
    """
    __args__ = dict()
    __args__['botId'] = bot_id
    __args__['botVersion'] = bot_version
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('aws-native:lex:getBotVersion', __args__, opts=opts, typ=GetBotVersionResult).value

    return AwaitableGetBotVersionResult(
        bot_version=pulumi.get(__ret__, 'bot_version'),
        description=pulumi.get(__ret__, 'description'))
def get_bot_version_output(bot_id: Optional[pulumi.Input[builtins.str]] = None,
                           bot_version: Optional[pulumi.Input[builtins.str]] = None,
                           opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetBotVersionResult]:
    """
    A version is a numbered snapshot of your work that you can publish for use in different parts of your workflow, such as development, beta deployment, and production.


    :param builtins.str bot_id: The unique identifier of the bot.
    :param builtins.str bot_version: The version of the bot.
    """
    __args__ = dict()
    __args__['botId'] = bot_id
    __args__['botVersion'] = bot_version
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('aws-native:lex:getBotVersion', __args__, opts=opts, typ=GetBotVersionResult)
    return __ret__.apply(lambda __response__: GetBotVersionResult(
        bot_version=pulumi.get(__response__, 'bot_version'),
        description=pulumi.get(__response__, 'description')))
