# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs
from ._enums import *

__all__ = [
    'GetBotAliasResult',
    'AwaitableGetBotAliasResult',
    'get_bot_alias',
    'get_bot_alias_output',
]

@pulumi.output_type
class GetBotAliasResult:
    def __init__(__self__, arn=None, bot_alias_id=None, bot_alias_locale_settings=None, bot_alias_name=None, bot_alias_status=None, bot_version=None, conversation_log_settings=None, description=None, sentiment_analysis_settings=None):
        if arn and not isinstance(arn, str):
            raise TypeError("Expected argument 'arn' to be a str")
        pulumi.set(__self__, "arn", arn)
        if bot_alias_id and not isinstance(bot_alias_id, str):
            raise TypeError("Expected argument 'bot_alias_id' to be a str")
        pulumi.set(__self__, "bot_alias_id", bot_alias_id)
        if bot_alias_locale_settings and not isinstance(bot_alias_locale_settings, list):
            raise TypeError("Expected argument 'bot_alias_locale_settings' to be a list")
        pulumi.set(__self__, "bot_alias_locale_settings", bot_alias_locale_settings)
        if bot_alias_name and not isinstance(bot_alias_name, str):
            raise TypeError("Expected argument 'bot_alias_name' to be a str")
        pulumi.set(__self__, "bot_alias_name", bot_alias_name)
        if bot_alias_status and not isinstance(bot_alias_status, str):
            raise TypeError("Expected argument 'bot_alias_status' to be a str")
        pulumi.set(__self__, "bot_alias_status", bot_alias_status)
        if bot_version and not isinstance(bot_version, str):
            raise TypeError("Expected argument 'bot_version' to be a str")
        pulumi.set(__self__, "bot_version", bot_version)
        if conversation_log_settings and not isinstance(conversation_log_settings, dict):
            raise TypeError("Expected argument 'conversation_log_settings' to be a dict")
        pulumi.set(__self__, "conversation_log_settings", conversation_log_settings)
        if description and not isinstance(description, str):
            raise TypeError("Expected argument 'description' to be a str")
        pulumi.set(__self__, "description", description)
        if sentiment_analysis_settings and not isinstance(sentiment_analysis_settings, dict):
            raise TypeError("Expected argument 'sentiment_analysis_settings' to be a dict")
        pulumi.set(__self__, "sentiment_analysis_settings", sentiment_analysis_settings)

    @property
    @pulumi.getter
    def arn(self) -> Optional[builtins.str]:
        """
        The Amazon Resource Name (ARN) of the bot alias.
        """
        return pulumi.get(self, "arn")

    @property
    @pulumi.getter(name="botAliasId")
    def bot_alias_id(self) -> Optional[builtins.str]:
        """
        The unique identifier of the bot alias.
        """
        return pulumi.get(self, "bot_alias_id")

    @property
    @pulumi.getter(name="botAliasLocaleSettings")
    def bot_alias_locale_settings(self) -> Optional[Sequence['outputs.BotAliasLocaleSettingsItem']]:
        """
        Specifies settings that are unique to a locale. For example, you can use different Lambda function depending on the bot's locale.
        """
        return pulumi.get(self, "bot_alias_locale_settings")

    @property
    @pulumi.getter(name="botAliasName")
    def bot_alias_name(self) -> Optional[builtins.str]:
        """
        The name of the bot alias.
        """
        return pulumi.get(self, "bot_alias_name")

    @property
    @pulumi.getter(name="botAliasStatus")
    def bot_alias_status(self) -> Optional['BotAliasStatus']:
        """
        The current status of the bot alias. When the status is Available the alias is ready for use with your bot.
        """
        return pulumi.get(self, "bot_alias_status")

    @property
    @pulumi.getter(name="botVersion")
    def bot_version(self) -> Optional[builtins.str]:
        """
        The version of the bot that the bot alias references.
        """
        return pulumi.get(self, "bot_version")

    @property
    @pulumi.getter(name="conversationLogSettings")
    def conversation_log_settings(self) -> Optional['outputs.BotAliasConversationLogSettings']:
        """
        Specifies whether Amazon Lex logs text and audio for conversations with the bot. When you enable conversation logs, text logs store text input, transcripts of audio input, and associated metadata in Amazon CloudWatch logs. Audio logs store input in Amazon S3 .
        """
        return pulumi.get(self, "conversation_log_settings")

    @property
    @pulumi.getter
    def description(self) -> Optional[builtins.str]:
        """
        The description of the bot alias.
        """
        return pulumi.get(self, "description")

    @property
    @pulumi.getter(name="sentimentAnalysisSettings")
    def sentiment_analysis_settings(self) -> Optional['outputs.SentimentAnalysisSettingsProperties']:
        """
        Determines whether Amazon Lex will use Amazon Comprehend to detect the sentiment of user utterances.
        """
        return pulumi.get(self, "sentiment_analysis_settings")


class AwaitableGetBotAliasResult(GetBotAliasResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetBotAliasResult(
            arn=self.arn,
            bot_alias_id=self.bot_alias_id,
            bot_alias_locale_settings=self.bot_alias_locale_settings,
            bot_alias_name=self.bot_alias_name,
            bot_alias_status=self.bot_alias_status,
            bot_version=self.bot_version,
            conversation_log_settings=self.conversation_log_settings,
            description=self.description,
            sentiment_analysis_settings=self.sentiment_analysis_settings)


def get_bot_alias(bot_alias_id: Optional[builtins.str] = None,
                  bot_id: Optional[builtins.str] = None,
                  opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetBotAliasResult:
    """
    A Bot Alias enables you to change the version of a bot without updating applications that use the bot


    :param builtins.str bot_alias_id: The unique identifier of the bot alias.
    :param builtins.str bot_id: The unique identifier of the bot.
    """
    __args__ = dict()
    __args__['botAliasId'] = bot_alias_id
    __args__['botId'] = bot_id
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('aws-native:lex:getBotAlias', __args__, opts=opts, typ=GetBotAliasResult).value

    return AwaitableGetBotAliasResult(
        arn=pulumi.get(__ret__, 'arn'),
        bot_alias_id=pulumi.get(__ret__, 'bot_alias_id'),
        bot_alias_locale_settings=pulumi.get(__ret__, 'bot_alias_locale_settings'),
        bot_alias_name=pulumi.get(__ret__, 'bot_alias_name'),
        bot_alias_status=pulumi.get(__ret__, 'bot_alias_status'),
        bot_version=pulumi.get(__ret__, 'bot_version'),
        conversation_log_settings=pulumi.get(__ret__, 'conversation_log_settings'),
        description=pulumi.get(__ret__, 'description'),
        sentiment_analysis_settings=pulumi.get(__ret__, 'sentiment_analysis_settings'))
def get_bot_alias_output(bot_alias_id: Optional[pulumi.Input[builtins.str]] = None,
                         bot_id: Optional[pulumi.Input[builtins.str]] = None,
                         opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetBotAliasResult]:
    """
    A Bot Alias enables you to change the version of a bot without updating applications that use the bot


    :param builtins.str bot_alias_id: The unique identifier of the bot alias.
    :param builtins.str bot_id: The unique identifier of the bot.
    """
    __args__ = dict()
    __args__['botAliasId'] = bot_alias_id
    __args__['botId'] = bot_id
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('aws-native:lex:getBotAlias', __args__, opts=opts, typ=GetBotAliasResult)
    return __ret__.apply(lambda __response__: GetBotAliasResult(
        arn=pulumi.get(__response__, 'arn'),
        bot_alias_id=pulumi.get(__response__, 'bot_alias_id'),
        bot_alias_locale_settings=pulumi.get(__response__, 'bot_alias_locale_settings'),
        bot_alias_name=pulumi.get(__response__, 'bot_alias_name'),
        bot_alias_status=pulumi.get(__response__, 'bot_alias_status'),
        bot_version=pulumi.get(__response__, 'bot_version'),
        conversation_log_settings=pulumi.get(__response__, 'conversation_log_settings'),
        description=pulumi.get(__response__, 'description'),
        sentiment_analysis_settings=pulumi.get(__response__, 'sentiment_analysis_settings')))
