# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = ['BotVersionArgs', 'BotVersion']

@pulumi.input_type
class BotVersionArgs:
    def __init__(__self__, *,
                 bot_id: pulumi.Input[builtins.str],
                 bot_version_locale_specification: pulumi.Input[Sequence[pulumi.Input['BotVersionLocaleSpecificationArgs']]],
                 description: Optional[pulumi.Input[builtins.str]] = None):
        """
        The set of arguments for constructing a BotVersion resource.
        :param pulumi.Input[builtins.str] bot_id: The unique identifier of the bot.
        :param pulumi.Input[Sequence[pulumi.Input['BotVersionLocaleSpecificationArgs']]] bot_version_locale_specification: Specifies the locales that Amazon Lex adds to this version. You can choose the Draft version or any other previously published version for each locale. When you specify a source version, the locale data is copied from the source version to the new version.
        :param pulumi.Input[builtins.str] description: The description of the version.
        """
        pulumi.set(__self__, "bot_id", bot_id)
        pulumi.set(__self__, "bot_version_locale_specification", bot_version_locale_specification)
        if description is not None:
            pulumi.set(__self__, "description", description)

    @property
    @pulumi.getter(name="botId")
    def bot_id(self) -> pulumi.Input[builtins.str]:
        """
        The unique identifier of the bot.
        """
        return pulumi.get(self, "bot_id")

    @bot_id.setter
    def bot_id(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "bot_id", value)

    @property
    @pulumi.getter(name="botVersionLocaleSpecification")
    def bot_version_locale_specification(self) -> pulumi.Input[Sequence[pulumi.Input['BotVersionLocaleSpecificationArgs']]]:
        """
        Specifies the locales that Amazon Lex adds to this version. You can choose the Draft version or any other previously published version for each locale. When you specify a source version, the locale data is copied from the source version to the new version.
        """
        return pulumi.get(self, "bot_version_locale_specification")

    @bot_version_locale_specification.setter
    def bot_version_locale_specification(self, value: pulumi.Input[Sequence[pulumi.Input['BotVersionLocaleSpecificationArgs']]]):
        pulumi.set(self, "bot_version_locale_specification", value)

    @property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The description of the version.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "description", value)


@pulumi.type_token("aws-native:lex:BotVersion")
class BotVersion(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 bot_id: Optional[pulumi.Input[builtins.str]] = None,
                 bot_version_locale_specification: Optional[pulumi.Input[Sequence[pulumi.Input[Union['BotVersionLocaleSpecificationArgs', 'BotVersionLocaleSpecificationArgsDict']]]]] = None,
                 description: Optional[pulumi.Input[builtins.str]] = None,
                 __props__=None):
        """
        A version is a numbered snapshot of your work that you can publish for use in different parts of your workflow, such as development, beta deployment, and production.

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[builtins.str] bot_id: The unique identifier of the bot.
        :param pulumi.Input[Sequence[pulumi.Input[Union['BotVersionLocaleSpecificationArgs', 'BotVersionLocaleSpecificationArgsDict']]]] bot_version_locale_specification: Specifies the locales that Amazon Lex adds to this version. You can choose the Draft version or any other previously published version for each locale. When you specify a source version, the locale data is copied from the source version to the new version.
        :param pulumi.Input[builtins.str] description: The description of the version.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: BotVersionArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        A version is a numbered snapshot of your work that you can publish for use in different parts of your workflow, such as development, beta deployment, and production.

        :param str resource_name: The name of the resource.
        :param BotVersionArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(BotVersionArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 bot_id: Optional[pulumi.Input[builtins.str]] = None,
                 bot_version_locale_specification: Optional[pulumi.Input[Sequence[pulumi.Input[Union['BotVersionLocaleSpecificationArgs', 'BotVersionLocaleSpecificationArgsDict']]]]] = None,
                 description: Optional[pulumi.Input[builtins.str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = BotVersionArgs.__new__(BotVersionArgs)

            if bot_id is None and not opts.urn:
                raise TypeError("Missing required property 'bot_id'")
            __props__.__dict__["bot_id"] = bot_id
            if bot_version_locale_specification is None and not opts.urn:
                raise TypeError("Missing required property 'bot_version_locale_specification'")
            __props__.__dict__["bot_version_locale_specification"] = bot_version_locale_specification
            __props__.__dict__["description"] = description
            __props__.__dict__["bot_version"] = None
        replace_on_changes = pulumi.ResourceOptions(replace_on_changes=["botId"])
        opts = pulumi.ResourceOptions.merge(opts, replace_on_changes)
        super(BotVersion, __self__).__init__(
            'aws-native:lex:BotVersion',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None) -> 'BotVersion':
        """
        Get an existing BotVersion resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = BotVersionArgs.__new__(BotVersionArgs)

        __props__.__dict__["bot_id"] = None
        __props__.__dict__["bot_version"] = None
        __props__.__dict__["bot_version_locale_specification"] = None
        __props__.__dict__["description"] = None
        return BotVersion(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter(name="botId")
    def bot_id(self) -> pulumi.Output[builtins.str]:
        """
        The unique identifier of the bot.
        """
        return pulumi.get(self, "bot_id")

    @property
    @pulumi.getter(name="botVersion")
    def bot_version(self) -> pulumi.Output[builtins.str]:
        """
        The version of the bot.
        """
        return pulumi.get(self, "bot_version")

    @property
    @pulumi.getter(name="botVersionLocaleSpecification")
    def bot_version_locale_specification(self) -> pulumi.Output[Sequence['outputs.BotVersionLocaleSpecification']]:
        """
        Specifies the locales that Amazon Lex adds to this version. You can choose the Draft version or any other previously published version for each locale. When you specify a source version, the locale data is copied from the source version to the new version.
        """
        return pulumi.get(self, "bot_version_locale_specification")

    @property
    @pulumi.getter
    def description(self) -> pulumi.Output[Optional[builtins.str]]:
        """
        The description of the version.
        """
        return pulumi.get(self, "description")

