# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs
from .. import outputs as _root_outputs
from ._enums import *

__all__ = [
    'GetEventSourceMappingResult',
    'AwaitableGetEventSourceMappingResult',
    'get_event_source_mapping',
    'get_event_source_mapping_output',
]

@pulumi.output_type
class GetEventSourceMappingResult:
    def __init__(__self__, batch_size=None, bisect_batch_on_function_error=None, destination_config=None, document_db_event_source_config=None, enabled=None, event_source_mapping_arn=None, filter_criteria=None, function_name=None, function_response_types=None, id=None, kms_key_arn=None, maximum_batching_window_in_seconds=None, maximum_record_age_in_seconds=None, maximum_retry_attempts=None, metrics_config=None, parallelization_factor=None, provisioned_poller_config=None, queues=None, scaling_config=None, source_access_configurations=None, tags=None, topics=None, tumbling_window_in_seconds=None):
        if batch_size and not isinstance(batch_size, int):
            raise TypeError("Expected argument 'batch_size' to be a int")
        pulumi.set(__self__, "batch_size", batch_size)
        if bisect_batch_on_function_error and not isinstance(bisect_batch_on_function_error, bool):
            raise TypeError("Expected argument 'bisect_batch_on_function_error' to be a bool")
        pulumi.set(__self__, "bisect_batch_on_function_error", bisect_batch_on_function_error)
        if destination_config and not isinstance(destination_config, dict):
            raise TypeError("Expected argument 'destination_config' to be a dict")
        pulumi.set(__self__, "destination_config", destination_config)
        if document_db_event_source_config and not isinstance(document_db_event_source_config, dict):
            raise TypeError("Expected argument 'document_db_event_source_config' to be a dict")
        pulumi.set(__self__, "document_db_event_source_config", document_db_event_source_config)
        if enabled and not isinstance(enabled, bool):
            raise TypeError("Expected argument 'enabled' to be a bool")
        pulumi.set(__self__, "enabled", enabled)
        if event_source_mapping_arn and not isinstance(event_source_mapping_arn, str):
            raise TypeError("Expected argument 'event_source_mapping_arn' to be a str")
        pulumi.set(__self__, "event_source_mapping_arn", event_source_mapping_arn)
        if filter_criteria and not isinstance(filter_criteria, dict):
            raise TypeError("Expected argument 'filter_criteria' to be a dict")
        pulumi.set(__self__, "filter_criteria", filter_criteria)
        if function_name and not isinstance(function_name, str):
            raise TypeError("Expected argument 'function_name' to be a str")
        pulumi.set(__self__, "function_name", function_name)
        if function_response_types and not isinstance(function_response_types, list):
            raise TypeError("Expected argument 'function_response_types' to be a list")
        pulumi.set(__self__, "function_response_types", function_response_types)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if kms_key_arn and not isinstance(kms_key_arn, str):
            raise TypeError("Expected argument 'kms_key_arn' to be a str")
        pulumi.set(__self__, "kms_key_arn", kms_key_arn)
        if maximum_batching_window_in_seconds and not isinstance(maximum_batching_window_in_seconds, int):
            raise TypeError("Expected argument 'maximum_batching_window_in_seconds' to be a int")
        pulumi.set(__self__, "maximum_batching_window_in_seconds", maximum_batching_window_in_seconds)
        if maximum_record_age_in_seconds and not isinstance(maximum_record_age_in_seconds, int):
            raise TypeError("Expected argument 'maximum_record_age_in_seconds' to be a int")
        pulumi.set(__self__, "maximum_record_age_in_seconds", maximum_record_age_in_seconds)
        if maximum_retry_attempts and not isinstance(maximum_retry_attempts, int):
            raise TypeError("Expected argument 'maximum_retry_attempts' to be a int")
        pulumi.set(__self__, "maximum_retry_attempts", maximum_retry_attempts)
        if metrics_config and not isinstance(metrics_config, dict):
            raise TypeError("Expected argument 'metrics_config' to be a dict")
        pulumi.set(__self__, "metrics_config", metrics_config)
        if parallelization_factor and not isinstance(parallelization_factor, int):
            raise TypeError("Expected argument 'parallelization_factor' to be a int")
        pulumi.set(__self__, "parallelization_factor", parallelization_factor)
        if provisioned_poller_config and not isinstance(provisioned_poller_config, dict):
            raise TypeError("Expected argument 'provisioned_poller_config' to be a dict")
        pulumi.set(__self__, "provisioned_poller_config", provisioned_poller_config)
        if queues and not isinstance(queues, list):
            raise TypeError("Expected argument 'queues' to be a list")
        pulumi.set(__self__, "queues", queues)
        if scaling_config and not isinstance(scaling_config, dict):
            raise TypeError("Expected argument 'scaling_config' to be a dict")
        pulumi.set(__self__, "scaling_config", scaling_config)
        if source_access_configurations and not isinstance(source_access_configurations, list):
            raise TypeError("Expected argument 'source_access_configurations' to be a list")
        pulumi.set(__self__, "source_access_configurations", source_access_configurations)
        if tags and not isinstance(tags, list):
            raise TypeError("Expected argument 'tags' to be a list")
        pulumi.set(__self__, "tags", tags)
        if topics and not isinstance(topics, list):
            raise TypeError("Expected argument 'topics' to be a list")
        pulumi.set(__self__, "topics", topics)
        if tumbling_window_in_seconds and not isinstance(tumbling_window_in_seconds, int):
            raise TypeError("Expected argument 'tumbling_window_in_seconds' to be a int")
        pulumi.set(__self__, "tumbling_window_in_seconds", tumbling_window_in_seconds)

    @property
    @pulumi.getter(name="batchSize")
    def batch_size(self) -> Optional[builtins.int]:
        """
        The maximum number of records in each batch that Lambda pulls from your stream or queue and sends to your function. Lambda passes all of the records in the batch to the function in a single call, up to the payload limit for synchronous invocation (6 MB).
          +   *Amazon Kinesis* – Default 100. Max 10,000.
          +   *Amazon DynamoDB Streams* – Default 100. Max 10,000.
          +   *Amazon Simple Queue Service* – Default 10. For standard queues the max is 10,000. For FIFO queues the max is 10.
          +   *Amazon Managed Streaming for Apache Kafka* – Default 100. Max 10,000.
          +   *Self-managed Apache Kafka* – Default 100. Max 10,000.
          +   *Amazon MQ (ActiveMQ and RabbitMQ)* – Default 100. Max 10,000.
          +   *DocumentDB* – Default 100. Max 10,000.
        """
        return pulumi.get(self, "batch_size")

    @property
    @pulumi.getter(name="bisectBatchOnFunctionError")
    def bisect_batch_on_function_error(self) -> Optional[builtins.bool]:
        """
        (Kinesis and DynamoDB Streams only) If the function returns an error, split the batch in two and retry. The default value is false.
          When using ``BisectBatchOnFunctionError``, check the ``BatchSize`` parameter in the ``OnFailure`` destination message's metadata. The ``BatchSize`` could be greater than 1 since LAM consolidates failed messages metadata when writing to the ``OnFailure`` destination.
        """
        return pulumi.get(self, "bisect_batch_on_function_error")

    @property
    @pulumi.getter(name="destinationConfig")
    def destination_config(self) -> Optional['outputs.EventSourceMappingDestinationConfig']:
        """
        (Kinesis, DynamoDB Streams, Amazon MSK, and self-managed Apache Kafka event sources only) A configuration object that specifies the destination of an event after Lambda processes it.
        """
        return pulumi.get(self, "destination_config")

    @property
    @pulumi.getter(name="documentDbEventSourceConfig")
    def document_db_event_source_config(self) -> Optional['outputs.EventSourceMappingDocumentDbEventSourceConfig']:
        """
        Specific configuration settings for a DocumentDB event source.
        """
        return pulumi.get(self, "document_db_event_source_config")

    @property
    @pulumi.getter
    def enabled(self) -> Optional[builtins.bool]:
        """
        When true, the event source mapping is active. When false, Lambda pauses polling and invocation.
         Default: True
        """
        return pulumi.get(self, "enabled")

    @property
    @pulumi.getter(name="eventSourceMappingArn")
    def event_source_mapping_arn(self) -> Optional[builtins.str]:
        """
        The Amazon Resource Name (ARN) of the event source mapping.
        """
        return pulumi.get(self, "event_source_mapping_arn")

    @property
    @pulumi.getter(name="filterCriteria")
    def filter_criteria(self) -> Optional['outputs.EventSourceMappingFilterCriteria']:
        """
        An object that defines the filter criteria that determine whether Lambda should process an event. For more information, see [Lambda event filtering](https://docs.aws.amazon.com/lambda/latest/dg/invocation-eventfiltering.html).
        """
        return pulumi.get(self, "filter_criteria")

    @property
    @pulumi.getter(name="functionName")
    def function_name(self) -> Optional[builtins.str]:
        """
        The name or ARN of the Lambda function.
          **Name formats**
         +   *Function name* – ``MyFunction``.
          +   *Function ARN* – ``arn:aws:lambda:us-west-2:123456789012:function:MyFunction``.
          +   *Version or Alias ARN* – ``arn:aws:lambda:us-west-2:123456789012:function:MyFunction:PROD``.
          +   *Partial ARN* – ``123456789012:function:MyFunction``.
          
         The length constraint applies only to the full ARN. If you specify only the function name, it's limited to 64 characters in length.
        """
        return pulumi.get(self, "function_name")

    @property
    @pulumi.getter(name="functionResponseTypes")
    def function_response_types(self) -> Optional[Sequence['EventSourceMappingFunctionResponseTypesItem']]:
        """
        (Kinesis, DynamoDB Streams, and SQS) A list of current response type enums applied to the event source mapping.
         Valid Values: ``ReportBatchItemFailures``
        """
        return pulumi.get(self, "function_response_types")

    @property
    @pulumi.getter
    def id(self) -> Optional[builtins.str]:
        """
        The event source mapping's ID.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter(name="kmsKeyArn")
    def kms_key_arn(self) -> Optional[builtins.str]:
        """
        The ARN of the KMSlong (KMS) customer managed key that Lambda uses to encrypt your function's [filter criteria](https://docs.aws.amazon.com/lambda/latest/dg/invocation-eventfiltering.html#filtering-basics).
        """
        return pulumi.get(self, "kms_key_arn")

    @property
    @pulumi.getter(name="maximumBatchingWindowInSeconds")
    def maximum_batching_window_in_seconds(self) -> Optional[builtins.int]:
        """
        The maximum amount of time, in seconds, that Lambda spends gathering records before invoking the function.
          *Default (, , event sources)*: 0
          *Default (, Kafka, , event sources)*: 500 ms
          *Related setting:* For SQS event sources, when you set ``BatchSize`` to a value greater than 10, you must set ``MaximumBatchingWindowInSeconds`` to at least 1.
        """
        return pulumi.get(self, "maximum_batching_window_in_seconds")

    @property
    @pulumi.getter(name="maximumRecordAgeInSeconds")
    def maximum_record_age_in_seconds(self) -> Optional[builtins.int]:
        """
        (Kinesis and DynamoDB Streams only) Discard records older than the specified age. The default value is -1, which sets the maximum age to infinite. When the value is set to infinite, Lambda never discards old records.
          The minimum valid value for maximum record age is 60s. Although values less than 60 and greater than -1 fall within the parameter's absolute range, they are not allowed
        """
        return pulumi.get(self, "maximum_record_age_in_seconds")

    @property
    @pulumi.getter(name="maximumRetryAttempts")
    def maximum_retry_attempts(self) -> Optional[builtins.int]:
        """
        (Kinesis and DynamoDB Streams only) Discard records after the specified number of retries. The default value is -1, which sets the maximum number of retries to infinite. When MaximumRetryAttempts is infinite, Lambda retries failed records until the record expires in the event source.
        """
        return pulumi.get(self, "maximum_retry_attempts")

    @property
    @pulumi.getter(name="metricsConfig")
    def metrics_config(self) -> Optional['outputs.EventSourceMappingMetricsConfig']:
        """
        The metrics configuration for your event source. For more information, see [Event source mapping metrics](https://docs.aws.amazon.com/lambda/latest/dg/monitoring-metrics-types.html#event-source-mapping-metrics).
        """
        return pulumi.get(self, "metrics_config")

    @property
    @pulumi.getter(name="parallelizationFactor")
    def parallelization_factor(self) -> Optional[builtins.int]:
        """
        (Kinesis and DynamoDB Streams only) The number of batches to process concurrently from each shard. The default value is 1.
        """
        return pulumi.get(self, "parallelization_factor")

    @property
    @pulumi.getter(name="provisionedPollerConfig")
    def provisioned_poller_config(self) -> Optional['outputs.EventSourceMappingProvisionedPollerConfig']:
        """
        (Amazon MSK and self-managed Apache Kafka only) The provisioned mode configuration for the event source. For more information, see [provisioned mode](https://docs.aws.amazon.com/lambda/latest/dg/invocation-eventsourcemapping.html#invocation-eventsourcemapping-provisioned-mode).
        """
        return pulumi.get(self, "provisioned_poller_config")

    @property
    @pulumi.getter
    def queues(self) -> Optional[Sequence[builtins.str]]:
        """
        (Amazon MQ) The name of the Amazon MQ broker destination queue to consume.
        """
        return pulumi.get(self, "queues")

    @property
    @pulumi.getter(name="scalingConfig")
    def scaling_config(self) -> Optional['outputs.EventSourceMappingScalingConfig']:
        """
        (Amazon SQS only) The scaling configuration for the event source. For more information, see [Configuring maximum concurrency for Amazon SQS event sources](https://docs.aws.amazon.com/lambda/latest/dg/with-sqs.html#events-sqs-max-concurrency).
        """
        return pulumi.get(self, "scaling_config")

    @property
    @pulumi.getter(name="sourceAccessConfigurations")
    def source_access_configurations(self) -> Optional[Sequence['outputs.EventSourceMappingSourceAccessConfiguration']]:
        """
        An array of the authentication protocol, VPC components, or virtual host to secure and define your event source.
        """
        return pulumi.get(self, "source_access_configurations")

    @property
    @pulumi.getter
    def tags(self) -> Optional[Sequence['_root_outputs.Tag']]:
        """
        A list of tags to add to the event source mapping.
          You must have the ``lambda:TagResource``, ``lambda:UntagResource``, and ``lambda:ListTags`` permissions for your [principal](https://docs.aws.amazon.com/IAM/latest/UserGuide/id_roles_terms-and-concepts.html) to manage the CFN stack. If you don't have these permissions, there might be unexpected behavior with stack-level tags propagating to the resource during resource creation and update.
        """
        return pulumi.get(self, "tags")

    @property
    @pulumi.getter
    def topics(self) -> Optional[Sequence[builtins.str]]:
        """
        The name of the Kafka topic.
        """
        return pulumi.get(self, "topics")

    @property
    @pulumi.getter(name="tumblingWindowInSeconds")
    def tumbling_window_in_seconds(self) -> Optional[builtins.int]:
        """
        (Kinesis and DynamoDB Streams only) The duration in seconds of a processing window for DynamoDB and Kinesis Streams event sources. A value of 0 seconds indicates no tumbling window.
        """
        return pulumi.get(self, "tumbling_window_in_seconds")


class AwaitableGetEventSourceMappingResult(GetEventSourceMappingResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetEventSourceMappingResult(
            batch_size=self.batch_size,
            bisect_batch_on_function_error=self.bisect_batch_on_function_error,
            destination_config=self.destination_config,
            document_db_event_source_config=self.document_db_event_source_config,
            enabled=self.enabled,
            event_source_mapping_arn=self.event_source_mapping_arn,
            filter_criteria=self.filter_criteria,
            function_name=self.function_name,
            function_response_types=self.function_response_types,
            id=self.id,
            kms_key_arn=self.kms_key_arn,
            maximum_batching_window_in_seconds=self.maximum_batching_window_in_seconds,
            maximum_record_age_in_seconds=self.maximum_record_age_in_seconds,
            maximum_retry_attempts=self.maximum_retry_attempts,
            metrics_config=self.metrics_config,
            parallelization_factor=self.parallelization_factor,
            provisioned_poller_config=self.provisioned_poller_config,
            queues=self.queues,
            scaling_config=self.scaling_config,
            source_access_configurations=self.source_access_configurations,
            tags=self.tags,
            topics=self.topics,
            tumbling_window_in_seconds=self.tumbling_window_in_seconds)


def get_event_source_mapping(id: Optional[builtins.str] = None,
                             opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetEventSourceMappingResult:
    """
    The ``AWS::Lambda::EventSourceMapping`` resource creates a mapping between an event source and an LAMlong function. LAM reads items from the event source and triggers the function.
     For details about each event source type, see the following topics. In particular, each of the topics describes the required and optional parameters for the specific event source.
      +   [Configuring a Dynamo DB stream as an event source](https://docs.aws.amazon.com/lambda/latest/dg/with-ddb.html#services-dynamodb-eventsourcemapping)
      +   [Configuring a Kinesis stream as an event source](https://docs.aws.amazon.com/lambda/latest/dg/with-kinesis.html#services-kinesis-eventsourcemapping)
      +   [Configuring an SQS queue as an event source](https://docs.aws.amazon.com/lambda/latest/dg/with-sqs.html#events-sqs-eventsource)
      +   [Configuring an MQ broker as an event source](https://docs.aws.amazon.com/lambda/latest/dg/with-mq.html#services-mq-eventsourcemapping)
      +   [Configuring MSK as an event source](https://docs.aws.amazon.com/lambda/latest/dg/with-msk.html)
      +   [Configuring Self-Managed Apache Kafka as an event source](https://docs.aws.amazon.com/lambda/latest/dg/kafka-smaa.html)
      +   [Configuring Amazon DocumentDB as an event source](https://docs.aws.amazon.com/lambda/latest/dg/with-documentdb.html)


    :param builtins.str id: The event source mapping's ID.
    """
    __args__ = dict()
    __args__['id'] = id
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('aws-native:lambda:getEventSourceMapping', __args__, opts=opts, typ=GetEventSourceMappingResult).value

    return AwaitableGetEventSourceMappingResult(
        batch_size=pulumi.get(__ret__, 'batch_size'),
        bisect_batch_on_function_error=pulumi.get(__ret__, 'bisect_batch_on_function_error'),
        destination_config=pulumi.get(__ret__, 'destination_config'),
        document_db_event_source_config=pulumi.get(__ret__, 'document_db_event_source_config'),
        enabled=pulumi.get(__ret__, 'enabled'),
        event_source_mapping_arn=pulumi.get(__ret__, 'event_source_mapping_arn'),
        filter_criteria=pulumi.get(__ret__, 'filter_criteria'),
        function_name=pulumi.get(__ret__, 'function_name'),
        function_response_types=pulumi.get(__ret__, 'function_response_types'),
        id=pulumi.get(__ret__, 'id'),
        kms_key_arn=pulumi.get(__ret__, 'kms_key_arn'),
        maximum_batching_window_in_seconds=pulumi.get(__ret__, 'maximum_batching_window_in_seconds'),
        maximum_record_age_in_seconds=pulumi.get(__ret__, 'maximum_record_age_in_seconds'),
        maximum_retry_attempts=pulumi.get(__ret__, 'maximum_retry_attempts'),
        metrics_config=pulumi.get(__ret__, 'metrics_config'),
        parallelization_factor=pulumi.get(__ret__, 'parallelization_factor'),
        provisioned_poller_config=pulumi.get(__ret__, 'provisioned_poller_config'),
        queues=pulumi.get(__ret__, 'queues'),
        scaling_config=pulumi.get(__ret__, 'scaling_config'),
        source_access_configurations=pulumi.get(__ret__, 'source_access_configurations'),
        tags=pulumi.get(__ret__, 'tags'),
        topics=pulumi.get(__ret__, 'topics'),
        tumbling_window_in_seconds=pulumi.get(__ret__, 'tumbling_window_in_seconds'))
def get_event_source_mapping_output(id: Optional[pulumi.Input[builtins.str]] = None,
                                    opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetEventSourceMappingResult]:
    """
    The ``AWS::Lambda::EventSourceMapping`` resource creates a mapping between an event source and an LAMlong function. LAM reads items from the event source and triggers the function.
     For details about each event source type, see the following topics. In particular, each of the topics describes the required and optional parameters for the specific event source.
      +   [Configuring a Dynamo DB stream as an event source](https://docs.aws.amazon.com/lambda/latest/dg/with-ddb.html#services-dynamodb-eventsourcemapping)
      +   [Configuring a Kinesis stream as an event source](https://docs.aws.amazon.com/lambda/latest/dg/with-kinesis.html#services-kinesis-eventsourcemapping)
      +   [Configuring an SQS queue as an event source](https://docs.aws.amazon.com/lambda/latest/dg/with-sqs.html#events-sqs-eventsource)
      +   [Configuring an MQ broker as an event source](https://docs.aws.amazon.com/lambda/latest/dg/with-mq.html#services-mq-eventsourcemapping)
      +   [Configuring MSK as an event source](https://docs.aws.amazon.com/lambda/latest/dg/with-msk.html)
      +   [Configuring Self-Managed Apache Kafka as an event source](https://docs.aws.amazon.com/lambda/latest/dg/kafka-smaa.html)
      +   [Configuring Amazon DocumentDB as an event source](https://docs.aws.amazon.com/lambda/latest/dg/with-documentdb.html)


    :param builtins.str id: The event source mapping's ID.
    """
    __args__ = dict()
    __args__['id'] = id
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('aws-native:lambda:getEventSourceMapping', __args__, opts=opts, typ=GetEventSourceMappingResult)
    return __ret__.apply(lambda __response__: GetEventSourceMappingResult(
        batch_size=pulumi.get(__response__, 'batch_size'),
        bisect_batch_on_function_error=pulumi.get(__response__, 'bisect_batch_on_function_error'),
        destination_config=pulumi.get(__response__, 'destination_config'),
        document_db_event_source_config=pulumi.get(__response__, 'document_db_event_source_config'),
        enabled=pulumi.get(__response__, 'enabled'),
        event_source_mapping_arn=pulumi.get(__response__, 'event_source_mapping_arn'),
        filter_criteria=pulumi.get(__response__, 'filter_criteria'),
        function_name=pulumi.get(__response__, 'function_name'),
        function_response_types=pulumi.get(__response__, 'function_response_types'),
        id=pulumi.get(__response__, 'id'),
        kms_key_arn=pulumi.get(__response__, 'kms_key_arn'),
        maximum_batching_window_in_seconds=pulumi.get(__response__, 'maximum_batching_window_in_seconds'),
        maximum_record_age_in_seconds=pulumi.get(__response__, 'maximum_record_age_in_seconds'),
        maximum_retry_attempts=pulumi.get(__response__, 'maximum_retry_attempts'),
        metrics_config=pulumi.get(__response__, 'metrics_config'),
        parallelization_factor=pulumi.get(__response__, 'parallelization_factor'),
        provisioned_poller_config=pulumi.get(__response__, 'provisioned_poller_config'),
        queues=pulumi.get(__response__, 'queues'),
        scaling_config=pulumi.get(__response__, 'scaling_config'),
        source_access_configurations=pulumi.get(__response__, 'source_access_configurations'),
        tags=pulumi.get(__response__, 'tags'),
        topics=pulumi.get(__response__, 'topics'),
        tumbling_window_in_seconds=pulumi.get(__response__, 'tumbling_window_in_seconds')))
