# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs
from ._enums import *

__all__ = [
    'DataCellsFilterColumnWildcard',
    'DataCellsFilterRowFilter',
    'PrincipalPermissionsCatalogResource',
    'PrincipalPermissionsColumnWildcard',
    'PrincipalPermissionsDataCellsFilterResource',
    'PrincipalPermissionsDataLakePrincipal',
    'PrincipalPermissionsDataLocationResource',
    'PrincipalPermissionsDatabaseResource',
    'PrincipalPermissionsLfTag',
    'PrincipalPermissionsLfTagKeyResource',
    'PrincipalPermissionsLfTagPolicyResource',
    'PrincipalPermissionsResource',
    'PrincipalPermissionsTableResource',
    'PrincipalPermissionsTableWildcard',
    'PrincipalPermissionsTableWithColumnsResource',
    'TagAssociationCatalogResource',
    'TagAssociationDatabaseResource',
    'TagAssociationLfTagPair',
    'TagAssociationResource',
    'TagAssociationTableResource',
    'TagAssociationTableWildcard',
    'TagAssociationTableWithColumnsResource',
]

@pulumi.output_type
class DataCellsFilterColumnWildcard(dict):
    """
    An object representing the Data Cells Filter's Columns. Either Column Names or a Wildcard is required.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "excludedColumnNames":
            suggest = "excluded_column_names"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in DataCellsFilterColumnWildcard. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        DataCellsFilterColumnWildcard.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        DataCellsFilterColumnWildcard.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 excluded_column_names: Optional[Sequence[builtins.str]] = None):
        """
        An object representing the Data Cells Filter's Columns. Either Column Names or a Wildcard is required.
        :param Sequence[builtins.str] excluded_column_names: A list of column names to be excluded from the Data Cells Filter.
        """
        if excluded_column_names is not None:
            pulumi.set(__self__, "excluded_column_names", excluded_column_names)

    @property
    @pulumi.getter(name="excludedColumnNames")
    def excluded_column_names(self) -> Optional[Sequence[builtins.str]]:
        """
        A list of column names to be excluded from the Data Cells Filter.
        """
        return pulumi.get(self, "excluded_column_names")


@pulumi.output_type
class DataCellsFilterRowFilter(dict):
    """
    An object representing the Data Cells Filter's Row Filter. Either a Filter Expression or a Wildcard is required.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "allRowsWildcard":
            suggest = "all_rows_wildcard"
        elif key == "filterExpression":
            suggest = "filter_expression"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in DataCellsFilterRowFilter. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        DataCellsFilterRowFilter.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        DataCellsFilterRowFilter.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 all_rows_wildcard: Optional[Any] = None,
                 filter_expression: Optional[builtins.str] = None):
        """
        An object representing the Data Cells Filter's Row Filter. Either a Filter Expression or a Wildcard is required.
        :param Any all_rows_wildcard: An empty object representing a row wildcard.
        :param builtins.str filter_expression: A PartiQL predicate.
        """
        if all_rows_wildcard is not None:
            pulumi.set(__self__, "all_rows_wildcard", all_rows_wildcard)
        if filter_expression is not None:
            pulumi.set(__self__, "filter_expression", filter_expression)

    @property
    @pulumi.getter(name="allRowsWildcard")
    def all_rows_wildcard(self) -> Optional[Any]:
        """
        An empty object representing a row wildcard.
        """
        return pulumi.get(self, "all_rows_wildcard")

    @property
    @pulumi.getter(name="filterExpression")
    def filter_expression(self) -> Optional[builtins.str]:
        """
        A PartiQL predicate.
        """
        return pulumi.get(self, "filter_expression")


@pulumi.output_type
class PrincipalPermissionsCatalogResource(dict):
    def __init__(__self__):
        pass


@pulumi.output_type
class PrincipalPermissionsColumnWildcard(dict):
    """
    A wildcard object, consisting of an optional list of excluded column names or indexes.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "excludedColumnNames":
            suggest = "excluded_column_names"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in PrincipalPermissionsColumnWildcard. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        PrincipalPermissionsColumnWildcard.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        PrincipalPermissionsColumnWildcard.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 excluded_column_names: Optional[Sequence[builtins.str]] = None):
        """
        A wildcard object, consisting of an optional list of excluded column names or indexes.
        :param Sequence[builtins.str] excluded_column_names: Excludes column names. Any column with this name will be excluded.
        """
        if excluded_column_names is not None:
            pulumi.set(__self__, "excluded_column_names", excluded_column_names)

    @property
    @pulumi.getter(name="excludedColumnNames")
    def excluded_column_names(self) -> Optional[Sequence[builtins.str]]:
        """
        Excludes column names. Any column with this name will be excluded.
        """
        return pulumi.get(self, "excluded_column_names")


@pulumi.output_type
class PrincipalPermissionsDataCellsFilterResource(dict):
    """
    A structure that describes certain columns on certain rows.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "databaseName":
            suggest = "database_name"
        elif key == "tableCatalogId":
            suggest = "table_catalog_id"
        elif key == "tableName":
            suggest = "table_name"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in PrincipalPermissionsDataCellsFilterResource. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        PrincipalPermissionsDataCellsFilterResource.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        PrincipalPermissionsDataCellsFilterResource.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 database_name: builtins.str,
                 name: builtins.str,
                 table_catalog_id: builtins.str,
                 table_name: builtins.str):
        """
        A structure that describes certain columns on certain rows.
        :param builtins.str database_name: A database in the GLUDC.
        :param builtins.str name: The name given by the user to the data filter cell.
        :param builtins.str table_catalog_id: The ID of the catalog to which the table belongs.
        :param builtins.str table_name: The name of the table.
        """
        pulumi.set(__self__, "database_name", database_name)
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "table_catalog_id", table_catalog_id)
        pulumi.set(__self__, "table_name", table_name)

    @property
    @pulumi.getter(name="databaseName")
    def database_name(self) -> builtins.str:
        """
        A database in the GLUDC.
        """
        return pulumi.get(self, "database_name")

    @property
    @pulumi.getter
    def name(self) -> builtins.str:
        """
        The name given by the user to the data filter cell.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="tableCatalogId")
    def table_catalog_id(self) -> builtins.str:
        """
        The ID of the catalog to which the table belongs.
        """
        return pulumi.get(self, "table_catalog_id")

    @property
    @pulumi.getter(name="tableName")
    def table_name(self) -> builtins.str:
        """
        The name of the table.
        """
        return pulumi.get(self, "table_name")


@pulumi.output_type
class PrincipalPermissionsDataLakePrincipal(dict):
    """
    The LFlong principal.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "dataLakePrincipalIdentifier":
            suggest = "data_lake_principal_identifier"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in PrincipalPermissionsDataLakePrincipal. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        PrincipalPermissionsDataLakePrincipal.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        PrincipalPermissionsDataLakePrincipal.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 data_lake_principal_identifier: Optional[builtins.str] = None):
        """
        The LFlong principal.
        :param builtins.str data_lake_principal_identifier: An identifier for the LFlong principal.
        """
        if data_lake_principal_identifier is not None:
            pulumi.set(__self__, "data_lake_principal_identifier", data_lake_principal_identifier)

    @property
    @pulumi.getter(name="dataLakePrincipalIdentifier")
    def data_lake_principal_identifier(self) -> Optional[builtins.str]:
        """
        An identifier for the LFlong principal.
        """
        return pulumi.get(self, "data_lake_principal_identifier")


@pulumi.output_type
class PrincipalPermissionsDataLocationResource(dict):
    """
    A structure for a data location object where permissions are granted or revoked.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "catalogId":
            suggest = "catalog_id"
        elif key == "resourceArn":
            suggest = "resource_arn"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in PrincipalPermissionsDataLocationResource. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        PrincipalPermissionsDataLocationResource.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        PrincipalPermissionsDataLocationResource.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 catalog_id: builtins.str,
                 resource_arn: builtins.str):
        """
        A structure for a data location object where permissions are granted or revoked.
        :param builtins.str catalog_id: The identifier for the GLUDC where the location is registered with LFlong.
        :param builtins.str resource_arn: The Amazon Resource Name (ARN) that uniquely identifies the data location resource.
        """
        pulumi.set(__self__, "catalog_id", catalog_id)
        pulumi.set(__self__, "resource_arn", resource_arn)

    @property
    @pulumi.getter(name="catalogId")
    def catalog_id(self) -> builtins.str:
        """
        The identifier for the GLUDC where the location is registered with LFlong.
        """
        return pulumi.get(self, "catalog_id")

    @property
    @pulumi.getter(name="resourceArn")
    def resource_arn(self) -> builtins.str:
        """
        The Amazon Resource Name (ARN) that uniquely identifies the data location resource.
        """
        return pulumi.get(self, "resource_arn")


@pulumi.output_type
class PrincipalPermissionsDatabaseResource(dict):
    """
    A structure for the database object.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "catalogId":
            suggest = "catalog_id"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in PrincipalPermissionsDatabaseResource. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        PrincipalPermissionsDatabaseResource.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        PrincipalPermissionsDatabaseResource.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 catalog_id: builtins.str,
                 name: builtins.str):
        """
        A structure for the database object.
        :param builtins.str catalog_id: The identifier for the Data Catalog. By default, it is the account ID of the caller.
        :param builtins.str name: The name of the database resource. Unique to the Data Catalog.
        """
        pulumi.set(__self__, "catalog_id", catalog_id)
        pulumi.set(__self__, "name", name)

    @property
    @pulumi.getter(name="catalogId")
    def catalog_id(self) -> builtins.str:
        """
        The identifier for the Data Catalog. By default, it is the account ID of the caller.
        """
        return pulumi.get(self, "catalog_id")

    @property
    @pulumi.getter
    def name(self) -> builtins.str:
        """
        The name of the database resource. Unique to the Data Catalog.
        """
        return pulumi.get(self, "name")


@pulumi.output_type
class PrincipalPermissionsLfTag(dict):
    """
    The LF-tag key and values attached to a resource.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "tagKey":
            suggest = "tag_key"
        elif key == "tagValues":
            suggest = "tag_values"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in PrincipalPermissionsLfTag. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        PrincipalPermissionsLfTag.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        PrincipalPermissionsLfTag.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 tag_key: Optional[builtins.str] = None,
                 tag_values: Optional[Sequence[builtins.str]] = None):
        """
        The LF-tag key and values attached to a resource.
        :param builtins.str tag_key: The key-name for the LF-tag.
        :param Sequence[builtins.str] tag_values: A list of possible values of the corresponding ``TagKey`` of an LF-tag key-value pair.
        """
        if tag_key is not None:
            pulumi.set(__self__, "tag_key", tag_key)
        if tag_values is not None:
            pulumi.set(__self__, "tag_values", tag_values)

    @property
    @pulumi.getter(name="tagKey")
    def tag_key(self) -> Optional[builtins.str]:
        """
        The key-name for the LF-tag.
        """
        return pulumi.get(self, "tag_key")

    @property
    @pulumi.getter(name="tagValues")
    def tag_values(self) -> Optional[Sequence[builtins.str]]:
        """
        A list of possible values of the corresponding ``TagKey`` of an LF-tag key-value pair.
        """
        return pulumi.get(self, "tag_values")


@pulumi.output_type
class PrincipalPermissionsLfTagKeyResource(dict):
    """
    A structure containing an LF-tag key and values for a resource.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "catalogId":
            suggest = "catalog_id"
        elif key == "tagKey":
            suggest = "tag_key"
        elif key == "tagValues":
            suggest = "tag_values"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in PrincipalPermissionsLfTagKeyResource. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        PrincipalPermissionsLfTagKeyResource.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        PrincipalPermissionsLfTagKeyResource.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 catalog_id: builtins.str,
                 tag_key: builtins.str,
                 tag_values: Sequence[builtins.str]):
        """
        A structure containing an LF-tag key and values for a resource.
        :param builtins.str catalog_id: The identifier for the GLUDC where the location is registered with GLUDC.
        :param builtins.str tag_key: The key-name for the LF-tag.
        :param Sequence[builtins.str] tag_values: A list of possible values for the corresponding ``TagKey`` of an LF-tag key-value pair.
        """
        pulumi.set(__self__, "catalog_id", catalog_id)
        pulumi.set(__self__, "tag_key", tag_key)
        pulumi.set(__self__, "tag_values", tag_values)

    @property
    @pulumi.getter(name="catalogId")
    def catalog_id(self) -> builtins.str:
        """
        The identifier for the GLUDC where the location is registered with GLUDC.
        """
        return pulumi.get(self, "catalog_id")

    @property
    @pulumi.getter(name="tagKey")
    def tag_key(self) -> builtins.str:
        """
        The key-name for the LF-tag.
        """
        return pulumi.get(self, "tag_key")

    @property
    @pulumi.getter(name="tagValues")
    def tag_values(self) -> Sequence[builtins.str]:
        """
        A list of possible values for the corresponding ``TagKey`` of an LF-tag key-value pair.
        """
        return pulumi.get(self, "tag_values")


@pulumi.output_type
class PrincipalPermissionsLfTagPolicyResource(dict):
    """
    A list of LF-tag conditions that define a resource's LF-tag policy.
     A structure that allows an admin to grant user permissions on certain conditions. For example, granting a role access to all columns that do not have the LF-tag 'PII' in tables that have the LF-tag 'Prod'.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "catalogId":
            suggest = "catalog_id"
        elif key == "resourceType":
            suggest = "resource_type"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in PrincipalPermissionsLfTagPolicyResource. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        PrincipalPermissionsLfTagPolicyResource.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        PrincipalPermissionsLfTagPolicyResource.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 catalog_id: builtins.str,
                 expression: Sequence['outputs.PrincipalPermissionsLfTag'],
                 resource_type: 'PrincipalPermissionsResourceType'):
        """
        A list of LF-tag conditions that define a resource's LF-tag policy.
         A structure that allows an admin to grant user permissions on certain conditions. For example, granting a role access to all columns that do not have the LF-tag 'PII' in tables that have the LF-tag 'Prod'.
        :param builtins.str catalog_id: The identifier for the GLUDC. The GLUDC is the persistent metadata store. It contains database definitions, table definitions, and other control information to manage your LFlong environment.
        :param Sequence['PrincipalPermissionsLfTag'] expression: A list of LF-tag conditions that apply to the resource's LF-tag policy.
        :param 'PrincipalPermissionsResourceType' resource_type: The resource type for which the LF-tag policy applies.
        """
        pulumi.set(__self__, "catalog_id", catalog_id)
        pulumi.set(__self__, "expression", expression)
        pulumi.set(__self__, "resource_type", resource_type)

    @property
    @pulumi.getter(name="catalogId")
    def catalog_id(self) -> builtins.str:
        """
        The identifier for the GLUDC. The GLUDC is the persistent metadata store. It contains database definitions, table definitions, and other control information to manage your LFlong environment.
        """
        return pulumi.get(self, "catalog_id")

    @property
    @pulumi.getter
    def expression(self) -> Sequence['outputs.PrincipalPermissionsLfTag']:
        """
        A list of LF-tag conditions that apply to the resource's LF-tag policy.
        """
        return pulumi.get(self, "expression")

    @property
    @pulumi.getter(name="resourceType")
    def resource_type(self) -> 'PrincipalPermissionsResourceType':
        """
        The resource type for which the LF-tag policy applies.
        """
        return pulumi.get(self, "resource_type")


@pulumi.output_type
class PrincipalPermissionsResource(dict):
    """
    A structure for the resource.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "dataCellsFilter":
            suggest = "data_cells_filter"
        elif key == "dataLocation":
            suggest = "data_location"
        elif key == "lfTag":
            suggest = "lf_tag"
        elif key == "lfTagPolicy":
            suggest = "lf_tag_policy"
        elif key == "tableWithColumns":
            suggest = "table_with_columns"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in PrincipalPermissionsResource. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        PrincipalPermissionsResource.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        PrincipalPermissionsResource.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 catalog: Optional['outputs.PrincipalPermissionsCatalogResource'] = None,
                 data_cells_filter: Optional['outputs.PrincipalPermissionsDataCellsFilterResource'] = None,
                 data_location: Optional['outputs.PrincipalPermissionsDataLocationResource'] = None,
                 database: Optional['outputs.PrincipalPermissionsDatabaseResource'] = None,
                 lf_tag: Optional['outputs.PrincipalPermissionsLfTagKeyResource'] = None,
                 lf_tag_policy: Optional['outputs.PrincipalPermissionsLfTagPolicyResource'] = None,
                 table: Optional['outputs.PrincipalPermissionsTableResource'] = None,
                 table_with_columns: Optional['outputs.PrincipalPermissionsTableWithColumnsResource'] = None):
        """
        A structure for the resource.
        :param 'PrincipalPermissionsCatalogResource' catalog: The identifier for the Data Catalog. By default, the account ID. The Data Catalog is the persistent metadata store. It contains database definitions, table definitions, and other control information to manage your LFlong environment.
        :param 'PrincipalPermissionsDataCellsFilterResource' data_cells_filter: A data cell filter.
        :param 'PrincipalPermissionsDataLocationResource' data_location: The location of an Amazon S3 path where permissions are granted or revoked.
        :param 'PrincipalPermissionsDatabaseResource' database: The database for the resource. Unique to the Data Catalog. A database is a set of associated table definitions organized into a logical group. You can Grant and Revoke database permissions to a principal.
        :param 'PrincipalPermissionsLfTagKeyResource' lf_tag: The LF-tag key and values attached to a resource.
        :param 'PrincipalPermissionsLfTagPolicyResource' lf_tag_policy: A list of LF-tag conditions that define a resource's LF-tag policy.
        :param 'PrincipalPermissionsTableResource' table: The table for the resource. A table is a metadata definition that represents your data. You can Grant and Revoke table privileges to a principal.
        :param 'PrincipalPermissionsTableWithColumnsResource' table_with_columns: The table with columns for the resource. A principal with permissions to this resource can select metadata from the columns of a table in the Data Catalog and the underlying data in Amazon S3.
        """
        if catalog is not None:
            pulumi.set(__self__, "catalog", catalog)
        if data_cells_filter is not None:
            pulumi.set(__self__, "data_cells_filter", data_cells_filter)
        if data_location is not None:
            pulumi.set(__self__, "data_location", data_location)
        if database is not None:
            pulumi.set(__self__, "database", database)
        if lf_tag is not None:
            pulumi.set(__self__, "lf_tag", lf_tag)
        if lf_tag_policy is not None:
            pulumi.set(__self__, "lf_tag_policy", lf_tag_policy)
        if table is not None:
            pulumi.set(__self__, "table", table)
        if table_with_columns is not None:
            pulumi.set(__self__, "table_with_columns", table_with_columns)

    @property
    @pulumi.getter
    def catalog(self) -> Optional['outputs.PrincipalPermissionsCatalogResource']:
        """
        The identifier for the Data Catalog. By default, the account ID. The Data Catalog is the persistent metadata store. It contains database definitions, table definitions, and other control information to manage your LFlong environment.
        """
        return pulumi.get(self, "catalog")

    @property
    @pulumi.getter(name="dataCellsFilter")
    def data_cells_filter(self) -> Optional['outputs.PrincipalPermissionsDataCellsFilterResource']:
        """
        A data cell filter.
        """
        return pulumi.get(self, "data_cells_filter")

    @property
    @pulumi.getter(name="dataLocation")
    def data_location(self) -> Optional['outputs.PrincipalPermissionsDataLocationResource']:
        """
        The location of an Amazon S3 path where permissions are granted or revoked.
        """
        return pulumi.get(self, "data_location")

    @property
    @pulumi.getter
    def database(self) -> Optional['outputs.PrincipalPermissionsDatabaseResource']:
        """
        The database for the resource. Unique to the Data Catalog. A database is a set of associated table definitions organized into a logical group. You can Grant and Revoke database permissions to a principal.
        """
        return pulumi.get(self, "database")

    @property
    @pulumi.getter(name="lfTag")
    def lf_tag(self) -> Optional['outputs.PrincipalPermissionsLfTagKeyResource']:
        """
        The LF-tag key and values attached to a resource.
        """
        return pulumi.get(self, "lf_tag")

    @property
    @pulumi.getter(name="lfTagPolicy")
    def lf_tag_policy(self) -> Optional['outputs.PrincipalPermissionsLfTagPolicyResource']:
        """
        A list of LF-tag conditions that define a resource's LF-tag policy.
        """
        return pulumi.get(self, "lf_tag_policy")

    @property
    @pulumi.getter
    def table(self) -> Optional['outputs.PrincipalPermissionsTableResource']:
        """
        The table for the resource. A table is a metadata definition that represents your data. You can Grant and Revoke table privileges to a principal.
        """
        return pulumi.get(self, "table")

    @property
    @pulumi.getter(name="tableWithColumns")
    def table_with_columns(self) -> Optional['outputs.PrincipalPermissionsTableWithColumnsResource']:
        """
        The table with columns for the resource. A principal with permissions to this resource can select metadata from the columns of a table in the Data Catalog and the underlying data in Amazon S3.
        """
        return pulumi.get(self, "table_with_columns")


@pulumi.output_type
class PrincipalPermissionsTableResource(dict):
    """
    A structure for the table object. A table is a metadata definition that represents your data. You can Grant and Revoke table privileges to a principal.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "catalogId":
            suggest = "catalog_id"
        elif key == "databaseName":
            suggest = "database_name"
        elif key == "tableWildcard":
            suggest = "table_wildcard"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in PrincipalPermissionsTableResource. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        PrincipalPermissionsTableResource.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        PrincipalPermissionsTableResource.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 catalog_id: builtins.str,
                 database_name: builtins.str,
                 name: Optional[builtins.str] = None,
                 table_wildcard: Optional['outputs.PrincipalPermissionsTableWildcard'] = None):
        """
        A structure for the table object. A table is a metadata definition that represents your data. You can Grant and Revoke table privileges to a principal.
        :param builtins.str catalog_id: The identifier for the Data Catalog. By default, it is the account ID of the caller.
        :param builtins.str database_name: The name of the database for the table. Unique to a Data Catalog. A database is a set of associated table definitions organized into a logical group. You can Grant and Revoke database privileges to a principal.
        :param builtins.str name: The name of the table.
        :param 'PrincipalPermissionsTableWildcard' table_wildcard: A wildcard object representing every table under a database.
                At least one of ``TableResource$Name`` or ``TableResource$TableWildcard`` is required.
        """
        pulumi.set(__self__, "catalog_id", catalog_id)
        pulumi.set(__self__, "database_name", database_name)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if table_wildcard is not None:
            pulumi.set(__self__, "table_wildcard", table_wildcard)

    @property
    @pulumi.getter(name="catalogId")
    def catalog_id(self) -> builtins.str:
        """
        The identifier for the Data Catalog. By default, it is the account ID of the caller.
        """
        return pulumi.get(self, "catalog_id")

    @property
    @pulumi.getter(name="databaseName")
    def database_name(self) -> builtins.str:
        """
        The name of the database for the table. Unique to a Data Catalog. A database is a set of associated table definitions organized into a logical group. You can Grant and Revoke database privileges to a principal.
        """
        return pulumi.get(self, "database_name")

    @property
    @pulumi.getter
    def name(self) -> Optional[builtins.str]:
        """
        The name of the table.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="tableWildcard")
    def table_wildcard(self) -> Optional['outputs.PrincipalPermissionsTableWildcard']:
        """
        A wildcard object representing every table under a database.
         At least one of ``TableResource$Name`` or ``TableResource$TableWildcard`` is required.
        """
        return pulumi.get(self, "table_wildcard")


@pulumi.output_type
class PrincipalPermissionsTableWildcard(dict):
    def __init__(__self__):
        pass


@pulumi.output_type
class PrincipalPermissionsTableWithColumnsResource(dict):
    """
    A structure for a table with columns object. This object is only used when granting a SELECT permission.
     This object must take a value for at least one of ``ColumnsNames``, ``ColumnsIndexes``, or ``ColumnsWildcard``.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "catalogId":
            suggest = "catalog_id"
        elif key == "databaseName":
            suggest = "database_name"
        elif key == "columnNames":
            suggest = "column_names"
        elif key == "columnWildcard":
            suggest = "column_wildcard"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in PrincipalPermissionsTableWithColumnsResource. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        PrincipalPermissionsTableWithColumnsResource.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        PrincipalPermissionsTableWithColumnsResource.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 catalog_id: builtins.str,
                 database_name: builtins.str,
                 name: builtins.str,
                 column_names: Optional[Sequence[builtins.str]] = None,
                 column_wildcard: Optional['outputs.PrincipalPermissionsColumnWildcard'] = None):
        """
        A structure for a table with columns object. This object is only used when granting a SELECT permission.
         This object must take a value for at least one of ``ColumnsNames``, ``ColumnsIndexes``, or ``ColumnsWildcard``.
        :param builtins.str catalog_id: The identifier for the GLUDC where the location is registered with LFlong.
        :param builtins.str database_name: The name of the database for the table with columns resource. Unique to the Data Catalog. A database is a set of associated table definitions organized into a logical group. You can Grant and Revoke database privileges to a principal.
        :param builtins.str name: The name of the table resource. A table is a metadata definition that represents your data. You can Grant and Revoke table privileges to a principal.
        :param Sequence[builtins.str] column_names: The list of column names for the table. At least one of ``ColumnNames`` or ``ColumnWildcard`` is required.
        :param 'PrincipalPermissionsColumnWildcard' column_wildcard: A wildcard specified by a ``ColumnWildcard`` object. At least one of ``ColumnNames`` or ``ColumnWildcard`` is required.
        """
        pulumi.set(__self__, "catalog_id", catalog_id)
        pulumi.set(__self__, "database_name", database_name)
        pulumi.set(__self__, "name", name)
        if column_names is not None:
            pulumi.set(__self__, "column_names", column_names)
        if column_wildcard is not None:
            pulumi.set(__self__, "column_wildcard", column_wildcard)

    @property
    @pulumi.getter(name="catalogId")
    def catalog_id(self) -> builtins.str:
        """
        The identifier for the GLUDC where the location is registered with LFlong.
        """
        return pulumi.get(self, "catalog_id")

    @property
    @pulumi.getter(name="databaseName")
    def database_name(self) -> builtins.str:
        """
        The name of the database for the table with columns resource. Unique to the Data Catalog. A database is a set of associated table definitions organized into a logical group. You can Grant and Revoke database privileges to a principal.
        """
        return pulumi.get(self, "database_name")

    @property
    @pulumi.getter
    def name(self) -> builtins.str:
        """
        The name of the table resource. A table is a metadata definition that represents your data. You can Grant and Revoke table privileges to a principal.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="columnNames")
    def column_names(self) -> Optional[Sequence[builtins.str]]:
        """
        The list of column names for the table. At least one of ``ColumnNames`` or ``ColumnWildcard`` is required.
        """
        return pulumi.get(self, "column_names")

    @property
    @pulumi.getter(name="columnWildcard")
    def column_wildcard(self) -> Optional['outputs.PrincipalPermissionsColumnWildcard']:
        """
        A wildcard specified by a ``ColumnWildcard`` object. At least one of ``ColumnNames`` or ``ColumnWildcard`` is required.
        """
        return pulumi.get(self, "column_wildcard")


@pulumi.output_type
class TagAssociationCatalogResource(dict):
    def __init__(__self__):
        pass


@pulumi.output_type
class TagAssociationDatabaseResource(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "catalogId":
            suggest = "catalog_id"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in TagAssociationDatabaseResource. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        TagAssociationDatabaseResource.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        TagAssociationDatabaseResource.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 catalog_id: builtins.str,
                 name: builtins.str):
        """
        :param builtins.str catalog_id: The identifier for the Data Catalog . By default, it should be the account ID of the caller.
        :param builtins.str name: The name of the database resource. Unique to the Data Catalog.
        """
        pulumi.set(__self__, "catalog_id", catalog_id)
        pulumi.set(__self__, "name", name)

    @property
    @pulumi.getter(name="catalogId")
    def catalog_id(self) -> builtins.str:
        """
        The identifier for the Data Catalog . By default, it should be the account ID of the caller.
        """
        return pulumi.get(self, "catalog_id")

    @property
    @pulumi.getter
    def name(self) -> builtins.str:
        """
        The name of the database resource. Unique to the Data Catalog.
        """
        return pulumi.get(self, "name")


@pulumi.output_type
class TagAssociationLfTagPair(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "catalogId":
            suggest = "catalog_id"
        elif key == "tagKey":
            suggest = "tag_key"
        elif key == "tagValues":
            suggest = "tag_values"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in TagAssociationLfTagPair. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        TagAssociationLfTagPair.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        TagAssociationLfTagPair.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 catalog_id: builtins.str,
                 tag_key: builtins.str,
                 tag_values: Sequence[builtins.str]):
        pulumi.set(__self__, "catalog_id", catalog_id)
        pulumi.set(__self__, "tag_key", tag_key)
        pulumi.set(__self__, "tag_values", tag_values)

    @property
    @pulumi.getter(name="catalogId")
    def catalog_id(self) -> builtins.str:
        return pulumi.get(self, "catalog_id")

    @property
    @pulumi.getter(name="tagKey")
    def tag_key(self) -> builtins.str:
        return pulumi.get(self, "tag_key")

    @property
    @pulumi.getter(name="tagValues")
    def tag_values(self) -> Sequence[builtins.str]:
        return pulumi.get(self, "tag_values")


@pulumi.output_type
class TagAssociationResource(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "tableWithColumns":
            suggest = "table_with_columns"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in TagAssociationResource. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        TagAssociationResource.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        TagAssociationResource.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 catalog: Optional['outputs.TagAssociationCatalogResource'] = None,
                 database: Optional['outputs.TagAssociationDatabaseResource'] = None,
                 table: Optional['outputs.TagAssociationTableResource'] = None,
                 table_with_columns: Optional['outputs.TagAssociationTableWithColumnsResource'] = None):
        """
        :param 'TagAssociationCatalogResource' catalog: The identifier for the Data Catalog. By default, the account ID. The Data Catalog is the persistent metadata store. It contains database definitions, table definitions, and other control information to manage your AWS Lake Formation environment.
        :param 'TagAssociationDatabaseResource' database: The database for the resource. Unique to the Data Catalog. A database is a set of associated table definitions organized into a logical group. You can Grant and Revoke database permissions to a principal.
        :param 'TagAssociationTableResource' table: The table for the resource. A table is a metadata definition that represents your data. You can Grant and Revoke table privileges to a principal.
        :param 'TagAssociationTableWithColumnsResource' table_with_columns: The table with columns for the resource. A principal with permissions to this resource can select metadata from the columns of a table in the Data Catalog and the underlying data in Amazon S3.
        """
        if catalog is not None:
            pulumi.set(__self__, "catalog", catalog)
        if database is not None:
            pulumi.set(__self__, "database", database)
        if table is not None:
            pulumi.set(__self__, "table", table)
        if table_with_columns is not None:
            pulumi.set(__self__, "table_with_columns", table_with_columns)

    @property
    @pulumi.getter
    def catalog(self) -> Optional['outputs.TagAssociationCatalogResource']:
        """
        The identifier for the Data Catalog. By default, the account ID. The Data Catalog is the persistent metadata store. It contains database definitions, table definitions, and other control information to manage your AWS Lake Formation environment.
        """
        return pulumi.get(self, "catalog")

    @property
    @pulumi.getter
    def database(self) -> Optional['outputs.TagAssociationDatabaseResource']:
        """
        The database for the resource. Unique to the Data Catalog. A database is a set of associated table definitions organized into a logical group. You can Grant and Revoke database permissions to a principal.
        """
        return pulumi.get(self, "database")

    @property
    @pulumi.getter
    def table(self) -> Optional['outputs.TagAssociationTableResource']:
        """
        The table for the resource. A table is a metadata definition that represents your data. You can Grant and Revoke table privileges to a principal.
        """
        return pulumi.get(self, "table")

    @property
    @pulumi.getter(name="tableWithColumns")
    def table_with_columns(self) -> Optional['outputs.TagAssociationTableWithColumnsResource']:
        """
        The table with columns for the resource. A principal with permissions to this resource can select metadata from the columns of a table in the Data Catalog and the underlying data in Amazon S3.
        """
        return pulumi.get(self, "table_with_columns")


@pulumi.output_type
class TagAssociationTableResource(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "catalogId":
            suggest = "catalog_id"
        elif key == "databaseName":
            suggest = "database_name"
        elif key == "tableWildcard":
            suggest = "table_wildcard"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in TagAssociationTableResource. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        TagAssociationTableResource.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        TagAssociationTableResource.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 catalog_id: builtins.str,
                 database_name: builtins.str,
                 name: Optional[builtins.str] = None,
                 table_wildcard: Optional['outputs.TagAssociationTableWildcard'] = None):
        """
        :param builtins.str catalog_id: The identifier for the Data Catalog . By default, it is the account ID of the caller.
        :param builtins.str database_name: The name of the database for the table. Unique to a Data Catalog. A database is a set of associated table definitions organized into a logical group. You can Grant and Revoke database privileges to a principal.
        :param builtins.str name: The name of the table.
        :param 'TagAssociationTableWildcard' table_wildcard: A wildcard object representing every table under a database.This is an object with no properties that effectively behaves as a true or false depending on whether not it is passed as a parameter. The valid inputs for a property with this type in either yaml or json is null or {}.
               
               At least one of `TableResource$Name` or `TableResource$TableWildcard` is required.
        """
        pulumi.set(__self__, "catalog_id", catalog_id)
        pulumi.set(__self__, "database_name", database_name)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if table_wildcard is not None:
            pulumi.set(__self__, "table_wildcard", table_wildcard)

    @property
    @pulumi.getter(name="catalogId")
    def catalog_id(self) -> builtins.str:
        """
        The identifier for the Data Catalog . By default, it is the account ID of the caller.
        """
        return pulumi.get(self, "catalog_id")

    @property
    @pulumi.getter(name="databaseName")
    def database_name(self) -> builtins.str:
        """
        The name of the database for the table. Unique to a Data Catalog. A database is a set of associated table definitions organized into a logical group. You can Grant and Revoke database privileges to a principal.
        """
        return pulumi.get(self, "database_name")

    @property
    @pulumi.getter
    def name(self) -> Optional[builtins.str]:
        """
        The name of the table.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="tableWildcard")
    def table_wildcard(self) -> Optional['outputs.TagAssociationTableWildcard']:
        """
        A wildcard object representing every table under a database.This is an object with no properties that effectively behaves as a true or false depending on whether not it is passed as a parameter. The valid inputs for a property with this type in either yaml or json is null or {}.

        At least one of `TableResource$Name` or `TableResource$TableWildcard` is required.
        """
        return pulumi.get(self, "table_wildcard")


@pulumi.output_type
class TagAssociationTableWildcard(dict):
    def __init__(__self__):
        pass


@pulumi.output_type
class TagAssociationTableWithColumnsResource(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "catalogId":
            suggest = "catalog_id"
        elif key == "columnNames":
            suggest = "column_names"
        elif key == "databaseName":
            suggest = "database_name"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in TagAssociationTableWithColumnsResource. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        TagAssociationTableWithColumnsResource.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        TagAssociationTableWithColumnsResource.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 catalog_id: builtins.str,
                 column_names: Sequence[builtins.str],
                 database_name: builtins.str,
                 name: builtins.str):
        """
        :param builtins.str catalog_id: A wildcard object representing every table under a database.
               
               At least one of TableResource$Name or TableResource$TableWildcard is required.
        :param Sequence[builtins.str] column_names: The list of column names for the table. At least one of `ColumnNames` or `ColumnWildcard` is required.
        :param builtins.str database_name: The name of the database for the table with columns resource. Unique to the Data Catalog. A database is a set of associated table definitions organized into a logical group. You can Grant and Revoke database privileges to a principal.
        :param builtins.str name: The name of the table resource. A table is a metadata definition that represents your data. You can Grant and Revoke table privileges to a principal.
        """
        pulumi.set(__self__, "catalog_id", catalog_id)
        pulumi.set(__self__, "column_names", column_names)
        pulumi.set(__self__, "database_name", database_name)
        pulumi.set(__self__, "name", name)

    @property
    @pulumi.getter(name="catalogId")
    def catalog_id(self) -> builtins.str:
        """
        A wildcard object representing every table under a database.

        At least one of TableResource$Name or TableResource$TableWildcard is required.
        """
        return pulumi.get(self, "catalog_id")

    @property
    @pulumi.getter(name="columnNames")
    def column_names(self) -> Sequence[builtins.str]:
        """
        The list of column names for the table. At least one of `ColumnNames` or `ColumnWildcard` is required.
        """
        return pulumi.get(self, "column_names")

    @property
    @pulumi.getter(name="databaseName")
    def database_name(self) -> builtins.str:
        """
        The name of the database for the table with columns resource. Unique to the Data Catalog. A database is a set of associated table definitions organized into a logical group. You can Grant and Revoke database privileges to a principal.
        """
        return pulumi.get(self, "database_name")

    @property
    @pulumi.getter
    def name(self) -> builtins.str:
        """
        The name of the table resource. A table is a metadata definition that represents your data. You can Grant and Revoke table privileges to a principal.
        """
        return pulumi.get(self, "name")


