# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs
from ._enums import *

__all__ = [
    'DeliveryStreamAmazonOpenSearchServerlessBufferingHints',
    'DeliveryStreamAmazonOpenSearchServerlessDestinationConfiguration',
    'DeliveryStreamAmazonOpenSearchServerlessRetryOptions',
    'DeliveryStreamAmazonopensearchserviceBufferingHints',
    'DeliveryStreamAmazonopensearchserviceDestinationConfiguration',
    'DeliveryStreamAmazonopensearchserviceRetryOptions',
    'DeliveryStreamAuthenticationConfiguration',
    'DeliveryStreamBufferingHints',
    'DeliveryStreamCatalogConfiguration',
    'DeliveryStreamCloudWatchLoggingOptions',
    'DeliveryStreamCopyCommand',
    'DeliveryStreamDataFormatConversionConfiguration',
    'DeliveryStreamDatabaseColumns',
    'DeliveryStreamDatabaseSourceAuthenticationConfiguration',
    'DeliveryStreamDatabaseSourceConfiguration',
    'DeliveryStreamDatabaseSourceVpcConfiguration',
    'DeliveryStreamDatabaseTables',
    'DeliveryStreamDatabases',
    'DeliveryStreamDeserializer',
    'DeliveryStreamDestinationTableConfiguration',
    'DeliveryStreamDirectPutSourceConfiguration',
    'DeliveryStreamDocumentIdOptions',
    'DeliveryStreamDynamicPartitioningConfiguration',
    'DeliveryStreamElasticsearchBufferingHints',
    'DeliveryStreamElasticsearchDestinationConfiguration',
    'DeliveryStreamElasticsearchRetryOptions',
    'DeliveryStreamEncryptionConfiguration',
    'DeliveryStreamEncryptionConfigurationInput',
    'DeliveryStreamExtendedS3DestinationConfiguration',
    'DeliveryStreamHiveJsonSerDe',
    'DeliveryStreamHttpEndpointCommonAttribute',
    'DeliveryStreamHttpEndpointConfiguration',
    'DeliveryStreamHttpEndpointDestinationConfiguration',
    'DeliveryStreamHttpEndpointRequestConfiguration',
    'DeliveryStreamIcebergDestinationConfiguration',
    'DeliveryStreamInputFormatConfiguration',
    'DeliveryStreamKinesisStreamSourceConfiguration',
    'DeliveryStreamKmsEncryptionConfig',
    'DeliveryStreamMskSourceConfiguration',
    'DeliveryStreamOpenXJsonSerDe',
    'DeliveryStreamOrcSerDe',
    'DeliveryStreamOutputFormatConfiguration',
    'DeliveryStreamParquetSerDe',
    'DeliveryStreamProcessingConfiguration',
    'DeliveryStreamProcessor',
    'DeliveryStreamProcessorParameter',
    'DeliveryStreamRedshiftDestinationConfiguration',
    'DeliveryStreamRedshiftRetryOptions',
    'DeliveryStreamRetryOptions',
    'DeliveryStreamS3DestinationConfiguration',
    'DeliveryStreamSchemaConfiguration',
    'DeliveryStreamSecretsManagerConfiguration',
    'DeliveryStreamSerializer',
    'DeliveryStreamSnowflakeBufferingHints',
    'DeliveryStreamSnowflakeDestinationConfiguration',
    'DeliveryStreamSnowflakeRetryOptions',
    'DeliveryStreamSnowflakeRoleConfiguration',
    'DeliveryStreamSnowflakeVpcConfiguration',
    'DeliveryStreamSplunkBufferingHints',
    'DeliveryStreamSplunkDestinationConfiguration',
    'DeliveryStreamSplunkRetryOptions',
    'DeliveryStreamVpcConfiguration',
]

@pulumi.output_type
class DeliveryStreamAmazonOpenSearchServerlessBufferingHints(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "intervalInSeconds":
            suggest = "interval_in_seconds"
        elif key == "sizeInMbs":
            suggest = "size_in_mbs"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in DeliveryStreamAmazonOpenSearchServerlessBufferingHints. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        DeliveryStreamAmazonOpenSearchServerlessBufferingHints.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        DeliveryStreamAmazonOpenSearchServerlessBufferingHints.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 interval_in_seconds: Optional[builtins.int] = None,
                 size_in_mbs: Optional[builtins.int] = None):
        """
        :param builtins.int interval_in_seconds: Buffer incoming data for the specified period of time, in seconds, before delivering it to the destination. The default value is 300 (5 minutes).
        :param builtins.int size_in_mbs: Buffer incoming data to the specified size, in MBs, before delivering it to the destination. The default value is 5.
               
               We recommend setting this parameter to a value greater than the amount of data you typically ingest into the Firehose stream in 10 seconds. For example, if you typically ingest data at 1 MB/sec, the value should be 10 MB or higher.
        """
        if interval_in_seconds is not None:
            pulumi.set(__self__, "interval_in_seconds", interval_in_seconds)
        if size_in_mbs is not None:
            pulumi.set(__self__, "size_in_mbs", size_in_mbs)

    @property
    @pulumi.getter(name="intervalInSeconds")
    def interval_in_seconds(self) -> Optional[builtins.int]:
        """
        Buffer incoming data for the specified period of time, in seconds, before delivering it to the destination. The default value is 300 (5 minutes).
        """
        return pulumi.get(self, "interval_in_seconds")

    @property
    @pulumi.getter(name="sizeInMbs")
    def size_in_mbs(self) -> Optional[builtins.int]:
        """
        Buffer incoming data to the specified size, in MBs, before delivering it to the destination. The default value is 5.

        We recommend setting this parameter to a value greater than the amount of data you typically ingest into the Firehose stream in 10 seconds. For example, if you typically ingest data at 1 MB/sec, the value should be 10 MB or higher.
        """
        return pulumi.get(self, "size_in_mbs")


@pulumi.output_type
class DeliveryStreamAmazonOpenSearchServerlessDestinationConfiguration(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "indexName":
            suggest = "index_name"
        elif key == "roleArn":
            suggest = "role_arn"
        elif key == "s3Configuration":
            suggest = "s3_configuration"
        elif key == "bufferingHints":
            suggest = "buffering_hints"
        elif key == "cloudWatchLoggingOptions":
            suggest = "cloud_watch_logging_options"
        elif key == "collectionEndpoint":
            suggest = "collection_endpoint"
        elif key == "processingConfiguration":
            suggest = "processing_configuration"
        elif key == "retryOptions":
            suggest = "retry_options"
        elif key == "s3BackupMode":
            suggest = "s3_backup_mode"
        elif key == "vpcConfiguration":
            suggest = "vpc_configuration"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in DeliveryStreamAmazonOpenSearchServerlessDestinationConfiguration. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        DeliveryStreamAmazonOpenSearchServerlessDestinationConfiguration.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        DeliveryStreamAmazonOpenSearchServerlessDestinationConfiguration.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 index_name: builtins.str,
                 role_arn: builtins.str,
                 s3_configuration: 'outputs.DeliveryStreamS3DestinationConfiguration',
                 buffering_hints: Optional['outputs.DeliveryStreamAmazonOpenSearchServerlessBufferingHints'] = None,
                 cloud_watch_logging_options: Optional['outputs.DeliveryStreamCloudWatchLoggingOptions'] = None,
                 collection_endpoint: Optional[builtins.str] = None,
                 processing_configuration: Optional['outputs.DeliveryStreamProcessingConfiguration'] = None,
                 retry_options: Optional['outputs.DeliveryStreamAmazonOpenSearchServerlessRetryOptions'] = None,
                 s3_backup_mode: Optional['DeliveryStreamAmazonOpenSearchServerlessDestinationConfigurationS3BackupMode'] = None,
                 vpc_configuration: Optional['outputs.DeliveryStreamVpcConfiguration'] = None):
        """
        :param builtins.str index_name: The Serverless offering for Amazon OpenSearch Service index name.
        :param builtins.str role_arn: The Amazon Resource Name (ARN) of the IAM role to be assumed by Firehose for calling the Serverless offering for Amazon OpenSearch Service Configuration API and for indexing documents.
        :param 'DeliveryStreamAmazonOpenSearchServerlessBufferingHints' buffering_hints: The buffering options. If no value is specified, the default values for AmazonopensearchserviceBufferingHints are used.
        :param builtins.str collection_endpoint: The endpoint to use when communicating with the collection in the Serverless offering for Amazon OpenSearch Service.
        :param 'DeliveryStreamAmazonOpenSearchServerlessRetryOptions' retry_options: The retry behavior in case Firehose is unable to deliver documents to the Serverless offering for Amazon OpenSearch Service. The default value is 300 (5 minutes).
        :param 'DeliveryStreamAmazonOpenSearchServerlessDestinationConfigurationS3BackupMode' s3_backup_mode: Defines how documents should be delivered to Amazon S3. When it is set to FailedDocumentsOnly, Firehose writes any documents that could not be indexed to the configured Amazon S3 destination, with AmazonOpenSearchService-failed/ appended to the key prefix. When set to AllDocuments, Firehose delivers all incoming records to Amazon S3, and also writes failed documents with AmazonOpenSearchService-failed/ appended to the prefix.
        """
        pulumi.set(__self__, "index_name", index_name)
        pulumi.set(__self__, "role_arn", role_arn)
        pulumi.set(__self__, "s3_configuration", s3_configuration)
        if buffering_hints is not None:
            pulumi.set(__self__, "buffering_hints", buffering_hints)
        if cloud_watch_logging_options is not None:
            pulumi.set(__self__, "cloud_watch_logging_options", cloud_watch_logging_options)
        if collection_endpoint is not None:
            pulumi.set(__self__, "collection_endpoint", collection_endpoint)
        if processing_configuration is not None:
            pulumi.set(__self__, "processing_configuration", processing_configuration)
        if retry_options is not None:
            pulumi.set(__self__, "retry_options", retry_options)
        if s3_backup_mode is not None:
            pulumi.set(__self__, "s3_backup_mode", s3_backup_mode)
        if vpc_configuration is not None:
            pulumi.set(__self__, "vpc_configuration", vpc_configuration)

    @property
    @pulumi.getter(name="indexName")
    def index_name(self) -> builtins.str:
        """
        The Serverless offering for Amazon OpenSearch Service index name.
        """
        return pulumi.get(self, "index_name")

    @property
    @pulumi.getter(name="roleArn")
    def role_arn(self) -> builtins.str:
        """
        The Amazon Resource Name (ARN) of the IAM role to be assumed by Firehose for calling the Serverless offering for Amazon OpenSearch Service Configuration API and for indexing documents.
        """
        return pulumi.get(self, "role_arn")

    @property
    @pulumi.getter(name="s3Configuration")
    def s3_configuration(self) -> 'outputs.DeliveryStreamS3DestinationConfiguration':
        return pulumi.get(self, "s3_configuration")

    @property
    @pulumi.getter(name="bufferingHints")
    def buffering_hints(self) -> Optional['outputs.DeliveryStreamAmazonOpenSearchServerlessBufferingHints']:
        """
        The buffering options. If no value is specified, the default values for AmazonopensearchserviceBufferingHints are used.
        """
        return pulumi.get(self, "buffering_hints")

    @property
    @pulumi.getter(name="cloudWatchLoggingOptions")
    def cloud_watch_logging_options(self) -> Optional['outputs.DeliveryStreamCloudWatchLoggingOptions']:
        return pulumi.get(self, "cloud_watch_logging_options")

    @property
    @pulumi.getter(name="collectionEndpoint")
    def collection_endpoint(self) -> Optional[builtins.str]:
        """
        The endpoint to use when communicating with the collection in the Serverless offering for Amazon OpenSearch Service.
        """
        return pulumi.get(self, "collection_endpoint")

    @property
    @pulumi.getter(name="processingConfiguration")
    def processing_configuration(self) -> Optional['outputs.DeliveryStreamProcessingConfiguration']:
        return pulumi.get(self, "processing_configuration")

    @property
    @pulumi.getter(name="retryOptions")
    def retry_options(self) -> Optional['outputs.DeliveryStreamAmazonOpenSearchServerlessRetryOptions']:
        """
        The retry behavior in case Firehose is unable to deliver documents to the Serverless offering for Amazon OpenSearch Service. The default value is 300 (5 minutes).
        """
        return pulumi.get(self, "retry_options")

    @property
    @pulumi.getter(name="s3BackupMode")
    def s3_backup_mode(self) -> Optional['DeliveryStreamAmazonOpenSearchServerlessDestinationConfigurationS3BackupMode']:
        """
        Defines how documents should be delivered to Amazon S3. When it is set to FailedDocumentsOnly, Firehose writes any documents that could not be indexed to the configured Amazon S3 destination, with AmazonOpenSearchService-failed/ appended to the key prefix. When set to AllDocuments, Firehose delivers all incoming records to Amazon S3, and also writes failed documents with AmazonOpenSearchService-failed/ appended to the prefix.
        """
        return pulumi.get(self, "s3_backup_mode")

    @property
    @pulumi.getter(name="vpcConfiguration")
    def vpc_configuration(self) -> Optional['outputs.DeliveryStreamVpcConfiguration']:
        return pulumi.get(self, "vpc_configuration")


@pulumi.output_type
class DeliveryStreamAmazonOpenSearchServerlessRetryOptions(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "durationInSeconds":
            suggest = "duration_in_seconds"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in DeliveryStreamAmazonOpenSearchServerlessRetryOptions. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        DeliveryStreamAmazonOpenSearchServerlessRetryOptions.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        DeliveryStreamAmazonOpenSearchServerlessRetryOptions.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 duration_in_seconds: Optional[builtins.int] = None):
        """
        :param builtins.int duration_in_seconds: After an initial failure to deliver to the Serverless offering for Amazon OpenSearch Service, the total amount of time during which Firehose retries delivery (including the first attempt). After this time has elapsed, the failed documents are written to Amazon S3. Default value is 300 seconds (5 minutes). A value of 0 (zero) results in no retries.
        """
        if duration_in_seconds is not None:
            pulumi.set(__self__, "duration_in_seconds", duration_in_seconds)

    @property
    @pulumi.getter(name="durationInSeconds")
    def duration_in_seconds(self) -> Optional[builtins.int]:
        """
        After an initial failure to deliver to the Serverless offering for Amazon OpenSearch Service, the total amount of time during which Firehose retries delivery (including the first attempt). After this time has elapsed, the failed documents are written to Amazon S3. Default value is 300 seconds (5 minutes). A value of 0 (zero) results in no retries.
        """
        return pulumi.get(self, "duration_in_seconds")


@pulumi.output_type
class DeliveryStreamAmazonopensearchserviceBufferingHints(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "intervalInSeconds":
            suggest = "interval_in_seconds"
        elif key == "sizeInMbs":
            suggest = "size_in_mbs"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in DeliveryStreamAmazonopensearchserviceBufferingHints. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        DeliveryStreamAmazonopensearchserviceBufferingHints.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        DeliveryStreamAmazonopensearchserviceBufferingHints.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 interval_in_seconds: Optional[builtins.int] = None,
                 size_in_mbs: Optional[builtins.int] = None):
        """
        :param builtins.int interval_in_seconds: Buffer incoming data for the specified period of time, in seconds, before delivering it to the destination. The default value is 300 (5 minutes).
        :param builtins.int size_in_mbs: Buffer incoming data to the specified size, in MBs, before delivering it to the destination. The default value is 5. We recommend setting this parameter to a value greater than the amount of data you typically ingest into the delivery stream in 10 seconds. For example, if you typically ingest data at 1 MB/sec, the value should be 10 MB or higher.
        """
        if interval_in_seconds is not None:
            pulumi.set(__self__, "interval_in_seconds", interval_in_seconds)
        if size_in_mbs is not None:
            pulumi.set(__self__, "size_in_mbs", size_in_mbs)

    @property
    @pulumi.getter(name="intervalInSeconds")
    def interval_in_seconds(self) -> Optional[builtins.int]:
        """
        Buffer incoming data for the specified period of time, in seconds, before delivering it to the destination. The default value is 300 (5 minutes).
        """
        return pulumi.get(self, "interval_in_seconds")

    @property
    @pulumi.getter(name="sizeInMbs")
    def size_in_mbs(self) -> Optional[builtins.int]:
        """
        Buffer incoming data to the specified size, in MBs, before delivering it to the destination. The default value is 5. We recommend setting this parameter to a value greater than the amount of data you typically ingest into the delivery stream in 10 seconds. For example, if you typically ingest data at 1 MB/sec, the value should be 10 MB or higher.
        """
        return pulumi.get(self, "size_in_mbs")


@pulumi.output_type
class DeliveryStreamAmazonopensearchserviceDestinationConfiguration(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "indexName":
            suggest = "index_name"
        elif key == "roleArn":
            suggest = "role_arn"
        elif key == "s3Configuration":
            suggest = "s3_configuration"
        elif key == "bufferingHints":
            suggest = "buffering_hints"
        elif key == "cloudWatchLoggingOptions":
            suggest = "cloud_watch_logging_options"
        elif key == "clusterEndpoint":
            suggest = "cluster_endpoint"
        elif key == "documentIdOptions":
            suggest = "document_id_options"
        elif key == "domainArn":
            suggest = "domain_arn"
        elif key == "indexRotationPeriod":
            suggest = "index_rotation_period"
        elif key == "processingConfiguration":
            suggest = "processing_configuration"
        elif key == "retryOptions":
            suggest = "retry_options"
        elif key == "s3BackupMode":
            suggest = "s3_backup_mode"
        elif key == "typeName":
            suggest = "type_name"
        elif key == "vpcConfiguration":
            suggest = "vpc_configuration"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in DeliveryStreamAmazonopensearchserviceDestinationConfiguration. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        DeliveryStreamAmazonopensearchserviceDestinationConfiguration.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        DeliveryStreamAmazonopensearchserviceDestinationConfiguration.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 index_name: builtins.str,
                 role_arn: builtins.str,
                 s3_configuration: 'outputs.DeliveryStreamS3DestinationConfiguration',
                 buffering_hints: Optional['outputs.DeliveryStreamAmazonopensearchserviceBufferingHints'] = None,
                 cloud_watch_logging_options: Optional['outputs.DeliveryStreamCloudWatchLoggingOptions'] = None,
                 cluster_endpoint: Optional[builtins.str] = None,
                 document_id_options: Optional['outputs.DeliveryStreamDocumentIdOptions'] = None,
                 domain_arn: Optional[builtins.str] = None,
                 index_rotation_period: Optional['DeliveryStreamAmazonopensearchserviceDestinationConfigurationIndexRotationPeriod'] = None,
                 processing_configuration: Optional['outputs.DeliveryStreamProcessingConfiguration'] = None,
                 retry_options: Optional['outputs.DeliveryStreamAmazonopensearchserviceRetryOptions'] = None,
                 s3_backup_mode: Optional['DeliveryStreamAmazonopensearchserviceDestinationConfigurationS3BackupMode'] = None,
                 type_name: Optional[builtins.str] = None,
                 vpc_configuration: Optional['outputs.DeliveryStreamVpcConfiguration'] = None):
        """
        :param builtins.str index_name: The Amazon OpenSearch Service index name.
        :param builtins.str role_arn: The Amazon Resource Name (ARN) of the IAM role to be assumed by Kinesis Data Firehose for calling the Amazon OpenSearch Service Configuration API and for indexing documents.
        :param 'DeliveryStreamS3DestinationConfiguration' s3_configuration: Describes the configuration of a destination in Amazon S3.
        :param 'DeliveryStreamAmazonopensearchserviceBufferingHints' buffering_hints: The buffering options. If no value is specified, the default values for AmazonopensearchserviceBufferingHints are used.
        :param 'DeliveryStreamCloudWatchLoggingOptions' cloud_watch_logging_options: Describes the Amazon CloudWatch logging options for your delivery stream.
        :param builtins.str cluster_endpoint: The endpoint to use when communicating with the cluster. Specify either this ClusterEndpoint or the DomainARN field.
        :param 'DeliveryStreamDocumentIdOptions' document_id_options: Indicates the method for setting up document ID. The supported methods are Firehose generated document ID and OpenSearch Service generated document ID.
        :param builtins.str domain_arn: The ARN of the Amazon OpenSearch Service domain.
        :param 'DeliveryStreamAmazonopensearchserviceDestinationConfigurationIndexRotationPeriod' index_rotation_period: The Amazon OpenSearch Service index rotation period. Index rotation appends a timestamp to the IndexName to facilitate the expiration of old data.
        :param 'DeliveryStreamProcessingConfiguration' processing_configuration: Describes a data processing configuration.
        :param 'DeliveryStreamAmazonopensearchserviceRetryOptions' retry_options: The retry behavior in case Kinesis Data Firehose is unable to deliver documents to Amazon OpenSearch Service. The default value is 300 (5 minutes).
        :param 'DeliveryStreamAmazonopensearchserviceDestinationConfigurationS3BackupMode' s3_backup_mode: Defines how documents should be delivered to Amazon S3.
        :param builtins.str type_name: The Amazon OpenSearch Service type name.
        :param 'DeliveryStreamVpcConfiguration' vpc_configuration: The details of the VPC of the Amazon OpenSearch Service destination.
        """
        pulumi.set(__self__, "index_name", index_name)
        pulumi.set(__self__, "role_arn", role_arn)
        pulumi.set(__self__, "s3_configuration", s3_configuration)
        if buffering_hints is not None:
            pulumi.set(__self__, "buffering_hints", buffering_hints)
        if cloud_watch_logging_options is not None:
            pulumi.set(__self__, "cloud_watch_logging_options", cloud_watch_logging_options)
        if cluster_endpoint is not None:
            pulumi.set(__self__, "cluster_endpoint", cluster_endpoint)
        if document_id_options is not None:
            pulumi.set(__self__, "document_id_options", document_id_options)
        if domain_arn is not None:
            pulumi.set(__self__, "domain_arn", domain_arn)
        if index_rotation_period is not None:
            pulumi.set(__self__, "index_rotation_period", index_rotation_period)
        if processing_configuration is not None:
            pulumi.set(__self__, "processing_configuration", processing_configuration)
        if retry_options is not None:
            pulumi.set(__self__, "retry_options", retry_options)
        if s3_backup_mode is not None:
            pulumi.set(__self__, "s3_backup_mode", s3_backup_mode)
        if type_name is not None:
            pulumi.set(__self__, "type_name", type_name)
        if vpc_configuration is not None:
            pulumi.set(__self__, "vpc_configuration", vpc_configuration)

    @property
    @pulumi.getter(name="indexName")
    def index_name(self) -> builtins.str:
        """
        The Amazon OpenSearch Service index name.
        """
        return pulumi.get(self, "index_name")

    @property
    @pulumi.getter(name="roleArn")
    def role_arn(self) -> builtins.str:
        """
        The Amazon Resource Name (ARN) of the IAM role to be assumed by Kinesis Data Firehose for calling the Amazon OpenSearch Service Configuration API and for indexing documents.
        """
        return pulumi.get(self, "role_arn")

    @property
    @pulumi.getter(name="s3Configuration")
    def s3_configuration(self) -> 'outputs.DeliveryStreamS3DestinationConfiguration':
        """
        Describes the configuration of a destination in Amazon S3.
        """
        return pulumi.get(self, "s3_configuration")

    @property
    @pulumi.getter(name="bufferingHints")
    def buffering_hints(self) -> Optional['outputs.DeliveryStreamAmazonopensearchserviceBufferingHints']:
        """
        The buffering options. If no value is specified, the default values for AmazonopensearchserviceBufferingHints are used.
        """
        return pulumi.get(self, "buffering_hints")

    @property
    @pulumi.getter(name="cloudWatchLoggingOptions")
    def cloud_watch_logging_options(self) -> Optional['outputs.DeliveryStreamCloudWatchLoggingOptions']:
        """
        Describes the Amazon CloudWatch logging options for your delivery stream.
        """
        return pulumi.get(self, "cloud_watch_logging_options")

    @property
    @pulumi.getter(name="clusterEndpoint")
    def cluster_endpoint(self) -> Optional[builtins.str]:
        """
        The endpoint to use when communicating with the cluster. Specify either this ClusterEndpoint or the DomainARN field.
        """
        return pulumi.get(self, "cluster_endpoint")

    @property
    @pulumi.getter(name="documentIdOptions")
    def document_id_options(self) -> Optional['outputs.DeliveryStreamDocumentIdOptions']:
        """
        Indicates the method for setting up document ID. The supported methods are Firehose generated document ID and OpenSearch Service generated document ID.
        """
        return pulumi.get(self, "document_id_options")

    @property
    @pulumi.getter(name="domainArn")
    def domain_arn(self) -> Optional[builtins.str]:
        """
        The ARN of the Amazon OpenSearch Service domain.
        """
        return pulumi.get(self, "domain_arn")

    @property
    @pulumi.getter(name="indexRotationPeriod")
    def index_rotation_period(self) -> Optional['DeliveryStreamAmazonopensearchserviceDestinationConfigurationIndexRotationPeriod']:
        """
        The Amazon OpenSearch Service index rotation period. Index rotation appends a timestamp to the IndexName to facilitate the expiration of old data.
        """
        return pulumi.get(self, "index_rotation_period")

    @property
    @pulumi.getter(name="processingConfiguration")
    def processing_configuration(self) -> Optional['outputs.DeliveryStreamProcessingConfiguration']:
        """
        Describes a data processing configuration.
        """
        return pulumi.get(self, "processing_configuration")

    @property
    @pulumi.getter(name="retryOptions")
    def retry_options(self) -> Optional['outputs.DeliveryStreamAmazonopensearchserviceRetryOptions']:
        """
        The retry behavior in case Kinesis Data Firehose is unable to deliver documents to Amazon OpenSearch Service. The default value is 300 (5 minutes).
        """
        return pulumi.get(self, "retry_options")

    @property
    @pulumi.getter(name="s3BackupMode")
    def s3_backup_mode(self) -> Optional['DeliveryStreamAmazonopensearchserviceDestinationConfigurationS3BackupMode']:
        """
        Defines how documents should be delivered to Amazon S3.
        """
        return pulumi.get(self, "s3_backup_mode")

    @property
    @pulumi.getter(name="typeName")
    def type_name(self) -> Optional[builtins.str]:
        """
        The Amazon OpenSearch Service type name.
        """
        return pulumi.get(self, "type_name")

    @property
    @pulumi.getter(name="vpcConfiguration")
    def vpc_configuration(self) -> Optional['outputs.DeliveryStreamVpcConfiguration']:
        """
        The details of the VPC of the Amazon OpenSearch Service destination.
        """
        return pulumi.get(self, "vpc_configuration")


@pulumi.output_type
class DeliveryStreamAmazonopensearchserviceRetryOptions(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "durationInSeconds":
            suggest = "duration_in_seconds"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in DeliveryStreamAmazonopensearchserviceRetryOptions. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        DeliveryStreamAmazonopensearchserviceRetryOptions.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        DeliveryStreamAmazonopensearchserviceRetryOptions.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 duration_in_seconds: Optional[builtins.int] = None):
        """
        :param builtins.int duration_in_seconds: After an initial failure to deliver to Amazon OpenSearch Service, the total amount of time during which Kinesis Data Firehose retries delivery (including the first attempt). After this time has elapsed, the failed documents are written to Amazon S3. Default value is 300 seconds (5 minutes). A value of 0 (zero) results in no retries.
        """
        if duration_in_seconds is not None:
            pulumi.set(__self__, "duration_in_seconds", duration_in_seconds)

    @property
    @pulumi.getter(name="durationInSeconds")
    def duration_in_seconds(self) -> Optional[builtins.int]:
        """
        After an initial failure to deliver to Amazon OpenSearch Service, the total amount of time during which Kinesis Data Firehose retries delivery (including the first attempt). After this time has elapsed, the failed documents are written to Amazon S3. Default value is 300 seconds (5 minutes). A value of 0 (zero) results in no retries.
        """
        return pulumi.get(self, "duration_in_seconds")


@pulumi.output_type
class DeliveryStreamAuthenticationConfiguration(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "roleArn":
            suggest = "role_arn"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in DeliveryStreamAuthenticationConfiguration. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        DeliveryStreamAuthenticationConfiguration.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        DeliveryStreamAuthenticationConfiguration.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 connectivity: 'DeliveryStreamAuthenticationConfigurationConnectivity',
                 role_arn: builtins.str):
        """
        :param 'DeliveryStreamAuthenticationConfigurationConnectivity' connectivity: The type of connectivity used to access the Amazon MSK cluster.
        :param builtins.str role_arn: The ARN of the role used to access the Amazon MSK cluster.
        """
        pulumi.set(__self__, "connectivity", connectivity)
        pulumi.set(__self__, "role_arn", role_arn)

    @property
    @pulumi.getter
    def connectivity(self) -> 'DeliveryStreamAuthenticationConfigurationConnectivity':
        """
        The type of connectivity used to access the Amazon MSK cluster.
        """
        return pulumi.get(self, "connectivity")

    @property
    @pulumi.getter(name="roleArn")
    def role_arn(self) -> builtins.str:
        """
        The ARN of the role used to access the Amazon MSK cluster.
        """
        return pulumi.get(self, "role_arn")


@pulumi.output_type
class DeliveryStreamBufferingHints(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "intervalInSeconds":
            suggest = "interval_in_seconds"
        elif key == "sizeInMbs":
            suggest = "size_in_mbs"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in DeliveryStreamBufferingHints. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        DeliveryStreamBufferingHints.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        DeliveryStreamBufferingHints.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 interval_in_seconds: Optional[builtins.int] = None,
                 size_in_mbs: Optional[builtins.int] = None):
        """
        :param builtins.int interval_in_seconds: The length of time, in seconds, that Kinesis Data Firehose buffers incoming data before delivering it to the destination. For valid values, see the `IntervalInSeconds` content for the [BufferingHints](https://docs.aws.amazon.com/firehose/latest/APIReference/API_BufferingHints.html) data type in the *Amazon Kinesis Data Firehose API Reference* .
        :param builtins.int size_in_mbs: The size of the buffer, in MBs, that Kinesis Data Firehose uses for incoming data before delivering it to the destination. For valid values, see the `SizeInMBs` content for the [BufferingHints](https://docs.aws.amazon.com/firehose/latest/APIReference/API_BufferingHints.html) data type in the *Amazon Kinesis Data Firehose API Reference* .
        """
        if interval_in_seconds is not None:
            pulumi.set(__self__, "interval_in_seconds", interval_in_seconds)
        if size_in_mbs is not None:
            pulumi.set(__self__, "size_in_mbs", size_in_mbs)

    @property
    @pulumi.getter(name="intervalInSeconds")
    def interval_in_seconds(self) -> Optional[builtins.int]:
        """
        The length of time, in seconds, that Kinesis Data Firehose buffers incoming data before delivering it to the destination. For valid values, see the `IntervalInSeconds` content for the [BufferingHints](https://docs.aws.amazon.com/firehose/latest/APIReference/API_BufferingHints.html) data type in the *Amazon Kinesis Data Firehose API Reference* .
        """
        return pulumi.get(self, "interval_in_seconds")

    @property
    @pulumi.getter(name="sizeInMbs")
    def size_in_mbs(self) -> Optional[builtins.int]:
        """
        The size of the buffer, in MBs, that Kinesis Data Firehose uses for incoming data before delivering it to the destination. For valid values, see the `SizeInMBs` content for the [BufferingHints](https://docs.aws.amazon.com/firehose/latest/APIReference/API_BufferingHints.html) data type in the *Amazon Kinesis Data Firehose API Reference* .
        """
        return pulumi.get(self, "size_in_mbs")


@pulumi.output_type
class DeliveryStreamCatalogConfiguration(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "catalogArn":
            suggest = "catalog_arn"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in DeliveryStreamCatalogConfiguration. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        DeliveryStreamCatalogConfiguration.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        DeliveryStreamCatalogConfiguration.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 catalog_arn: Optional[builtins.str] = None):
        """
        :param builtins.str catalog_arn: Specifies the Glue catalog ARN identifier of the destination Apache Iceberg Tables. You must specify the ARN in the format `arn:aws:glue:region:account-id:catalog` .
        """
        if catalog_arn is not None:
            pulumi.set(__self__, "catalog_arn", catalog_arn)

    @property
    @pulumi.getter(name="catalogArn")
    def catalog_arn(self) -> Optional[builtins.str]:
        """
        Specifies the Glue catalog ARN identifier of the destination Apache Iceberg Tables. You must specify the ARN in the format `arn:aws:glue:region:account-id:catalog` .
        """
        return pulumi.get(self, "catalog_arn")


@pulumi.output_type
class DeliveryStreamCloudWatchLoggingOptions(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "logGroupName":
            suggest = "log_group_name"
        elif key == "logStreamName":
            suggest = "log_stream_name"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in DeliveryStreamCloudWatchLoggingOptions. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        DeliveryStreamCloudWatchLoggingOptions.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        DeliveryStreamCloudWatchLoggingOptions.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 enabled: Optional[builtins.bool] = None,
                 log_group_name: Optional[builtins.str] = None,
                 log_stream_name: Optional[builtins.str] = None):
        """
        :param builtins.bool enabled: Indicates whether CloudWatch Logs logging is enabled.
        :param builtins.str log_group_name: The name of the CloudWatch Logs log group that contains the log stream that Kinesis Data Firehose will use.
               
               Conditional. If you enable logging, you must specify this property.
        :param builtins.str log_stream_name: The name of the CloudWatch Logs log stream that Kinesis Data Firehose uses to send logs about data delivery.
               
               Conditional. If you enable logging, you must specify this property.
        """
        if enabled is not None:
            pulumi.set(__self__, "enabled", enabled)
        if log_group_name is not None:
            pulumi.set(__self__, "log_group_name", log_group_name)
        if log_stream_name is not None:
            pulumi.set(__self__, "log_stream_name", log_stream_name)

    @property
    @pulumi.getter
    def enabled(self) -> Optional[builtins.bool]:
        """
        Indicates whether CloudWatch Logs logging is enabled.
        """
        return pulumi.get(self, "enabled")

    @property
    @pulumi.getter(name="logGroupName")
    def log_group_name(self) -> Optional[builtins.str]:
        """
        The name of the CloudWatch Logs log group that contains the log stream that Kinesis Data Firehose will use.

        Conditional. If you enable logging, you must specify this property.
        """
        return pulumi.get(self, "log_group_name")

    @property
    @pulumi.getter(name="logStreamName")
    def log_stream_name(self) -> Optional[builtins.str]:
        """
        The name of the CloudWatch Logs log stream that Kinesis Data Firehose uses to send logs about data delivery.

        Conditional. If you enable logging, you must specify this property.
        """
        return pulumi.get(self, "log_stream_name")


@pulumi.output_type
class DeliveryStreamCopyCommand(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "dataTableName":
            suggest = "data_table_name"
        elif key == "copyOptions":
            suggest = "copy_options"
        elif key == "dataTableColumns":
            suggest = "data_table_columns"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in DeliveryStreamCopyCommand. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        DeliveryStreamCopyCommand.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        DeliveryStreamCopyCommand.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 data_table_name: builtins.str,
                 copy_options: Optional[builtins.str] = None,
                 data_table_columns: Optional[builtins.str] = None):
        """
        :param builtins.str data_table_name: The name of the target table. The table must already exist in the database.
        :param builtins.str copy_options: Parameters to use with the Amazon Redshift `COPY` command. For examples, see the `CopyOptions` content for the [CopyCommand](https://docs.aws.amazon.com/firehose/latest/APIReference/API_CopyCommand.html) data type in the *Amazon Kinesis Data Firehose API Reference* .
        :param builtins.str data_table_columns: A comma-separated list of column names.
        """
        pulumi.set(__self__, "data_table_name", data_table_name)
        if copy_options is not None:
            pulumi.set(__self__, "copy_options", copy_options)
        if data_table_columns is not None:
            pulumi.set(__self__, "data_table_columns", data_table_columns)

    @property
    @pulumi.getter(name="dataTableName")
    def data_table_name(self) -> builtins.str:
        """
        The name of the target table. The table must already exist in the database.
        """
        return pulumi.get(self, "data_table_name")

    @property
    @pulumi.getter(name="copyOptions")
    def copy_options(self) -> Optional[builtins.str]:
        """
        Parameters to use with the Amazon Redshift `COPY` command. For examples, see the `CopyOptions` content for the [CopyCommand](https://docs.aws.amazon.com/firehose/latest/APIReference/API_CopyCommand.html) data type in the *Amazon Kinesis Data Firehose API Reference* .
        """
        return pulumi.get(self, "copy_options")

    @property
    @pulumi.getter(name="dataTableColumns")
    def data_table_columns(self) -> Optional[builtins.str]:
        """
        A comma-separated list of column names.
        """
        return pulumi.get(self, "data_table_columns")


@pulumi.output_type
class DeliveryStreamDataFormatConversionConfiguration(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "inputFormatConfiguration":
            suggest = "input_format_configuration"
        elif key == "outputFormatConfiguration":
            suggest = "output_format_configuration"
        elif key == "schemaConfiguration":
            suggest = "schema_configuration"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in DeliveryStreamDataFormatConversionConfiguration. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        DeliveryStreamDataFormatConversionConfiguration.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        DeliveryStreamDataFormatConversionConfiguration.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 enabled: Optional[builtins.bool] = None,
                 input_format_configuration: Optional['outputs.DeliveryStreamInputFormatConfiguration'] = None,
                 output_format_configuration: Optional['outputs.DeliveryStreamOutputFormatConfiguration'] = None,
                 schema_configuration: Optional['outputs.DeliveryStreamSchemaConfiguration'] = None):
        """
        :param builtins.bool enabled: Defaults to `true` . Set it to `false` if you want to disable format conversion while preserving the configuration details.
        :param 'DeliveryStreamInputFormatConfiguration' input_format_configuration: Specifies the deserializer that you want Firehose to use to convert the format of your data from JSON. This parameter is required if `Enabled` is set to true.
        :param 'DeliveryStreamOutputFormatConfiguration' output_format_configuration: Specifies the serializer that you want Firehose to use to convert the format of your data to the Parquet or ORC format. This parameter is required if `Enabled` is set to true.
        :param 'DeliveryStreamSchemaConfiguration' schema_configuration: Specifies the AWS Glue Data Catalog table that contains the column information. This parameter is required if `Enabled` is set to true.
        """
        if enabled is not None:
            pulumi.set(__self__, "enabled", enabled)
        if input_format_configuration is not None:
            pulumi.set(__self__, "input_format_configuration", input_format_configuration)
        if output_format_configuration is not None:
            pulumi.set(__self__, "output_format_configuration", output_format_configuration)
        if schema_configuration is not None:
            pulumi.set(__self__, "schema_configuration", schema_configuration)

    @property
    @pulumi.getter
    def enabled(self) -> Optional[builtins.bool]:
        """
        Defaults to `true` . Set it to `false` if you want to disable format conversion while preserving the configuration details.
        """
        return pulumi.get(self, "enabled")

    @property
    @pulumi.getter(name="inputFormatConfiguration")
    def input_format_configuration(self) -> Optional['outputs.DeliveryStreamInputFormatConfiguration']:
        """
        Specifies the deserializer that you want Firehose to use to convert the format of your data from JSON. This parameter is required if `Enabled` is set to true.
        """
        return pulumi.get(self, "input_format_configuration")

    @property
    @pulumi.getter(name="outputFormatConfiguration")
    def output_format_configuration(self) -> Optional['outputs.DeliveryStreamOutputFormatConfiguration']:
        """
        Specifies the serializer that you want Firehose to use to convert the format of your data to the Parquet or ORC format. This parameter is required if `Enabled` is set to true.
        """
        return pulumi.get(self, "output_format_configuration")

    @property
    @pulumi.getter(name="schemaConfiguration")
    def schema_configuration(self) -> Optional['outputs.DeliveryStreamSchemaConfiguration']:
        """
        Specifies the AWS Glue Data Catalog table that contains the column information. This parameter is required if `Enabled` is set to true.
        """
        return pulumi.get(self, "schema_configuration")


@pulumi.output_type
class DeliveryStreamDatabaseColumns(dict):
    def __init__(__self__, *,
                 exclude: Optional[Sequence[builtins.str]] = None,
                 include: Optional[Sequence[builtins.str]] = None):
        if exclude is not None:
            pulumi.set(__self__, "exclude", exclude)
        if include is not None:
            pulumi.set(__self__, "include", include)

    @property
    @pulumi.getter
    def exclude(self) -> Optional[Sequence[builtins.str]]:
        return pulumi.get(self, "exclude")

    @property
    @pulumi.getter
    def include(self) -> Optional[Sequence[builtins.str]]:
        return pulumi.get(self, "include")


@pulumi.output_type
class DeliveryStreamDatabaseSourceAuthenticationConfiguration(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "secretsManagerConfiguration":
            suggest = "secrets_manager_configuration"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in DeliveryStreamDatabaseSourceAuthenticationConfiguration. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        DeliveryStreamDatabaseSourceAuthenticationConfiguration.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        DeliveryStreamDatabaseSourceAuthenticationConfiguration.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 secrets_manager_configuration: 'outputs.DeliveryStreamSecretsManagerConfiguration'):
        pulumi.set(__self__, "secrets_manager_configuration", secrets_manager_configuration)

    @property
    @pulumi.getter(name="secretsManagerConfiguration")
    def secrets_manager_configuration(self) -> 'outputs.DeliveryStreamSecretsManagerConfiguration':
        return pulumi.get(self, "secrets_manager_configuration")


@pulumi.output_type
class DeliveryStreamDatabaseSourceConfiguration(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "databaseSourceAuthenticationConfiguration":
            suggest = "database_source_authentication_configuration"
        elif key == "databaseSourceVpcConfiguration":
            suggest = "database_source_vpc_configuration"
        elif key == "snapshotWatermarkTable":
            suggest = "snapshot_watermark_table"
        elif key == "publicCertificate":
            suggest = "public_certificate"
        elif key == "sslMode":
            suggest = "ssl_mode"
        elif key == "surrogateKeys":
            suggest = "surrogate_keys"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in DeliveryStreamDatabaseSourceConfiguration. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        DeliveryStreamDatabaseSourceConfiguration.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        DeliveryStreamDatabaseSourceConfiguration.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 database_source_authentication_configuration: 'outputs.DeliveryStreamDatabaseSourceAuthenticationConfiguration',
                 database_source_vpc_configuration: 'outputs.DeliveryStreamDatabaseSourceVpcConfiguration',
                 databases: 'outputs.DeliveryStreamDatabases',
                 endpoint: builtins.str,
                 port: builtins.int,
                 snapshot_watermark_table: builtins.str,
                 tables: 'outputs.DeliveryStreamDatabaseTables',
                 type: 'DeliveryStreamDatabaseSourceConfigurationType',
                 columns: Optional['outputs.DeliveryStreamDatabaseColumns'] = None,
                 digest: Optional[builtins.str] = None,
                 public_certificate: Optional[builtins.str] = None,
                 ssl_mode: Optional['DeliveryStreamDatabaseSourceConfigurationSslMode'] = None,
                 surrogate_keys: Optional[Sequence[builtins.str]] = None):
        """
        :param 'DeliveryStreamDatabaseSourceAuthenticationConfiguration' database_source_authentication_configuration: The structure to configure the authentication methods for Firehose to connect to source database endpoint.
               
               Amazon Data Firehose is in preview release and is subject to change.
        :param 'DeliveryStreamDatabaseSourceVpcConfiguration' database_source_vpc_configuration: The details of the VPC Endpoint Service which Firehose uses to create a PrivateLink to the database.
               
               Amazon Data Firehose is in preview release and is subject to change.
        :param 'DeliveryStreamDatabases' databases: The list of database patterns in source database endpoint for Firehose to read from.
               
               Amazon Data Firehose is in preview release and is subject to change.
        :param builtins.str endpoint: The endpoint of the database server.
               
               Amazon Data Firehose is in preview release and is subject to change.
        :param builtins.int port: The port of the database. This can be one of the following values.
               
               - 3306 for MySQL database type
               - 5432 for PostgreSQL database type
               
               Amazon Data Firehose is in preview release and is subject to change.
        :param builtins.str snapshot_watermark_table: The fully qualified name of the table in source database endpoint that Firehose uses to track snapshot progress.
               
               Amazon Data Firehose is in preview release and is subject to change.
        :param 'DeliveryStreamDatabaseTables' tables: The list of table patterns in source database endpoint for Firehose to read from.
               
               Amazon Data Firehose is in preview release and is subject to change.
        :param 'DeliveryStreamDatabaseSourceConfigurationType' type: The type of database engine. This can be one of the following values.
               
               - MySQL
               - PostgreSQL
               
               Amazon Data Firehose is in preview release and is subject to change.
        :param 'DeliveryStreamDatabaseColumns' columns: The list of column patterns in source database endpoint for Firehose to read from.
               
               Amazon Data Firehose is in preview release and is subject to change.
        :param 'DeliveryStreamDatabaseSourceConfigurationSslMode' ssl_mode: The mode to enable or disable SSL when Firehose connects to the database endpoint.
               
               Amazon Data Firehose is in preview release and is subject to change.
        :param Sequence[builtins.str] surrogate_keys: The optional list of table and column names used as unique key columns when taking snapshot if the tables don’t have primary keys configured.
               
               Amazon Data Firehose is in preview release and is subject to change.
        """
        pulumi.set(__self__, "database_source_authentication_configuration", database_source_authentication_configuration)
        pulumi.set(__self__, "database_source_vpc_configuration", database_source_vpc_configuration)
        pulumi.set(__self__, "databases", databases)
        pulumi.set(__self__, "endpoint", endpoint)
        pulumi.set(__self__, "port", port)
        pulumi.set(__self__, "snapshot_watermark_table", snapshot_watermark_table)
        pulumi.set(__self__, "tables", tables)
        pulumi.set(__self__, "type", type)
        if columns is not None:
            pulumi.set(__self__, "columns", columns)
        if digest is not None:
            pulumi.set(__self__, "digest", digest)
        if public_certificate is not None:
            pulumi.set(__self__, "public_certificate", public_certificate)
        if ssl_mode is not None:
            pulumi.set(__self__, "ssl_mode", ssl_mode)
        if surrogate_keys is not None:
            pulumi.set(__self__, "surrogate_keys", surrogate_keys)

    @property
    @pulumi.getter(name="databaseSourceAuthenticationConfiguration")
    def database_source_authentication_configuration(self) -> 'outputs.DeliveryStreamDatabaseSourceAuthenticationConfiguration':
        """
        The structure to configure the authentication methods for Firehose to connect to source database endpoint.

        Amazon Data Firehose is in preview release and is subject to change.
        """
        return pulumi.get(self, "database_source_authentication_configuration")

    @property
    @pulumi.getter(name="databaseSourceVpcConfiguration")
    def database_source_vpc_configuration(self) -> 'outputs.DeliveryStreamDatabaseSourceVpcConfiguration':
        """
        The details of the VPC Endpoint Service which Firehose uses to create a PrivateLink to the database.

        Amazon Data Firehose is in preview release and is subject to change.
        """
        return pulumi.get(self, "database_source_vpc_configuration")

    @property
    @pulumi.getter
    def databases(self) -> 'outputs.DeliveryStreamDatabases':
        """
        The list of database patterns in source database endpoint for Firehose to read from.

        Amazon Data Firehose is in preview release and is subject to change.
        """
        return pulumi.get(self, "databases")

    @property
    @pulumi.getter
    def endpoint(self) -> builtins.str:
        """
        The endpoint of the database server.

        Amazon Data Firehose is in preview release and is subject to change.
        """
        return pulumi.get(self, "endpoint")

    @property
    @pulumi.getter
    def port(self) -> builtins.int:
        """
        The port of the database. This can be one of the following values.

        - 3306 for MySQL database type
        - 5432 for PostgreSQL database type

        Amazon Data Firehose is in preview release and is subject to change.
        """
        return pulumi.get(self, "port")

    @property
    @pulumi.getter(name="snapshotWatermarkTable")
    def snapshot_watermark_table(self) -> builtins.str:
        """
        The fully qualified name of the table in source database endpoint that Firehose uses to track snapshot progress.

        Amazon Data Firehose is in preview release and is subject to change.
        """
        return pulumi.get(self, "snapshot_watermark_table")

    @property
    @pulumi.getter
    def tables(self) -> 'outputs.DeliveryStreamDatabaseTables':
        """
        The list of table patterns in source database endpoint for Firehose to read from.

        Amazon Data Firehose is in preview release and is subject to change.
        """
        return pulumi.get(self, "tables")

    @property
    @pulumi.getter
    def type(self) -> 'DeliveryStreamDatabaseSourceConfigurationType':
        """
        The type of database engine. This can be one of the following values.

        - MySQL
        - PostgreSQL

        Amazon Data Firehose is in preview release and is subject to change.
        """
        return pulumi.get(self, "type")

    @property
    @pulumi.getter
    def columns(self) -> Optional['outputs.DeliveryStreamDatabaseColumns']:
        """
        The list of column patterns in source database endpoint for Firehose to read from.

        Amazon Data Firehose is in preview release and is subject to change.
        """
        return pulumi.get(self, "columns")

    @property
    @pulumi.getter
    def digest(self) -> Optional[builtins.str]:
        return pulumi.get(self, "digest")

    @property
    @pulumi.getter(name="publicCertificate")
    def public_certificate(self) -> Optional[builtins.str]:
        return pulumi.get(self, "public_certificate")

    @property
    @pulumi.getter(name="sslMode")
    def ssl_mode(self) -> Optional['DeliveryStreamDatabaseSourceConfigurationSslMode']:
        """
        The mode to enable or disable SSL when Firehose connects to the database endpoint.

        Amazon Data Firehose is in preview release and is subject to change.
        """
        return pulumi.get(self, "ssl_mode")

    @property
    @pulumi.getter(name="surrogateKeys")
    def surrogate_keys(self) -> Optional[Sequence[builtins.str]]:
        """
        The optional list of table and column names used as unique key columns when taking snapshot if the tables don’t have primary keys configured.

        Amazon Data Firehose is in preview release and is subject to change.
        """
        return pulumi.get(self, "surrogate_keys")


@pulumi.output_type
class DeliveryStreamDatabaseSourceVpcConfiguration(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "vpcEndpointServiceName":
            suggest = "vpc_endpoint_service_name"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in DeliveryStreamDatabaseSourceVpcConfiguration. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        DeliveryStreamDatabaseSourceVpcConfiguration.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        DeliveryStreamDatabaseSourceVpcConfiguration.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 vpc_endpoint_service_name: builtins.str):
        """
        :param builtins.str vpc_endpoint_service_name: The VPC endpoint service name which Firehose uses to create a PrivateLink to the database. The endpoint service must have the Firehose service principle `firehose.amazonaws.com` as an allowed principal on the VPC endpoint service. The VPC endpoint service name is a string that looks like `com.amazonaws.vpce.<region>.<vpc-endpoint-service-id>` .
               
               Amazon Data Firehose is in preview release and is subject to change.
        """
        pulumi.set(__self__, "vpc_endpoint_service_name", vpc_endpoint_service_name)

    @property
    @pulumi.getter(name="vpcEndpointServiceName")
    def vpc_endpoint_service_name(self) -> builtins.str:
        """
        The VPC endpoint service name which Firehose uses to create a PrivateLink to the database. The endpoint service must have the Firehose service principle `firehose.amazonaws.com` as an allowed principal on the VPC endpoint service. The VPC endpoint service name is a string that looks like `com.amazonaws.vpce.<region>.<vpc-endpoint-service-id>` .

        Amazon Data Firehose is in preview release and is subject to change.
        """
        return pulumi.get(self, "vpc_endpoint_service_name")


@pulumi.output_type
class DeliveryStreamDatabaseTables(dict):
    def __init__(__self__, *,
                 exclude: Optional[Sequence[builtins.str]] = None,
                 include: Optional[Sequence[builtins.str]] = None):
        if exclude is not None:
            pulumi.set(__self__, "exclude", exclude)
        if include is not None:
            pulumi.set(__self__, "include", include)

    @property
    @pulumi.getter
    def exclude(self) -> Optional[Sequence[builtins.str]]:
        return pulumi.get(self, "exclude")

    @property
    @pulumi.getter
    def include(self) -> Optional[Sequence[builtins.str]]:
        return pulumi.get(self, "include")


@pulumi.output_type
class DeliveryStreamDatabases(dict):
    def __init__(__self__, *,
                 exclude: Optional[Sequence[builtins.str]] = None,
                 include: Optional[Sequence[builtins.str]] = None):
        if exclude is not None:
            pulumi.set(__self__, "exclude", exclude)
        if include is not None:
            pulumi.set(__self__, "include", include)

    @property
    @pulumi.getter
    def exclude(self) -> Optional[Sequence[builtins.str]]:
        return pulumi.get(self, "exclude")

    @property
    @pulumi.getter
    def include(self) -> Optional[Sequence[builtins.str]]:
        return pulumi.get(self, "include")


@pulumi.output_type
class DeliveryStreamDeserializer(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "hiveJsonSerDe":
            suggest = "hive_json_ser_de"
        elif key == "openXJsonSerDe":
            suggest = "open_x_json_ser_de"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in DeliveryStreamDeserializer. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        DeliveryStreamDeserializer.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        DeliveryStreamDeserializer.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 hive_json_ser_de: Optional['outputs.DeliveryStreamHiveJsonSerDe'] = None,
                 open_x_json_ser_de: Optional['outputs.DeliveryStreamOpenXJsonSerDe'] = None):
        """
        :param 'DeliveryStreamHiveJsonSerDe' hive_json_ser_de: The native Hive / HCatalog JsonSerDe. Used by Firehose for deserializing data, which means converting it from the JSON format in preparation for serializing it to the Parquet or ORC format. This is one of two deserializers you can choose, depending on which one offers the functionality you need. The other option is the OpenX SerDe.
        :param 'DeliveryStreamOpenXJsonSerDe' open_x_json_ser_de: The OpenX SerDe. Used by Firehose for deserializing data, which means converting it from the JSON format in preparation for serializing it to the Parquet or ORC format. This is one of two deserializers you can choose, depending on which one offers the functionality you need. The other option is the native Hive / HCatalog JsonSerDe.
        """
        if hive_json_ser_de is not None:
            pulumi.set(__self__, "hive_json_ser_de", hive_json_ser_de)
        if open_x_json_ser_de is not None:
            pulumi.set(__self__, "open_x_json_ser_de", open_x_json_ser_de)

    @property
    @pulumi.getter(name="hiveJsonSerDe")
    def hive_json_ser_de(self) -> Optional['outputs.DeliveryStreamHiveJsonSerDe']:
        """
        The native Hive / HCatalog JsonSerDe. Used by Firehose for deserializing data, which means converting it from the JSON format in preparation for serializing it to the Parquet or ORC format. This is one of two deserializers you can choose, depending on which one offers the functionality you need. The other option is the OpenX SerDe.
        """
        return pulumi.get(self, "hive_json_ser_de")

    @property
    @pulumi.getter(name="openXJsonSerDe")
    def open_x_json_ser_de(self) -> Optional['outputs.DeliveryStreamOpenXJsonSerDe']:
        """
        The OpenX SerDe. Used by Firehose for deserializing data, which means converting it from the JSON format in preparation for serializing it to the Parquet or ORC format. This is one of two deserializers you can choose, depending on which one offers the functionality you need. The other option is the native Hive / HCatalog JsonSerDe.
        """
        return pulumi.get(self, "open_x_json_ser_de")


@pulumi.output_type
class DeliveryStreamDestinationTableConfiguration(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "destinationDatabaseName":
            suggest = "destination_database_name"
        elif key == "destinationTableName":
            suggest = "destination_table_name"
        elif key == "s3ErrorOutputPrefix":
            suggest = "s3_error_output_prefix"
        elif key == "uniqueKeys":
            suggest = "unique_keys"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in DeliveryStreamDestinationTableConfiguration. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        DeliveryStreamDestinationTableConfiguration.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        DeliveryStreamDestinationTableConfiguration.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 destination_database_name: builtins.str,
                 destination_table_name: builtins.str,
                 s3_error_output_prefix: Optional[builtins.str] = None,
                 unique_keys: Optional[Sequence[builtins.str]] = None):
        pulumi.set(__self__, "destination_database_name", destination_database_name)
        pulumi.set(__self__, "destination_table_name", destination_table_name)
        if s3_error_output_prefix is not None:
            pulumi.set(__self__, "s3_error_output_prefix", s3_error_output_prefix)
        if unique_keys is not None:
            pulumi.set(__self__, "unique_keys", unique_keys)

    @property
    @pulumi.getter(name="destinationDatabaseName")
    def destination_database_name(self) -> builtins.str:
        return pulumi.get(self, "destination_database_name")

    @property
    @pulumi.getter(name="destinationTableName")
    def destination_table_name(self) -> builtins.str:
        return pulumi.get(self, "destination_table_name")

    @property
    @pulumi.getter(name="s3ErrorOutputPrefix")
    def s3_error_output_prefix(self) -> Optional[builtins.str]:
        return pulumi.get(self, "s3_error_output_prefix")

    @property
    @pulumi.getter(name="uniqueKeys")
    def unique_keys(self) -> Optional[Sequence[builtins.str]]:
        return pulumi.get(self, "unique_keys")


@pulumi.output_type
class DeliveryStreamDirectPutSourceConfiguration(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "throughputHintInMbs":
            suggest = "throughput_hint_in_mbs"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in DeliveryStreamDirectPutSourceConfiguration. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        DeliveryStreamDirectPutSourceConfiguration.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        DeliveryStreamDirectPutSourceConfiguration.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 throughput_hint_in_mbs: Optional[builtins.int] = None):
        """
        :param builtins.int throughput_hint_in_mbs: The value that you configure for this parameter is for information purpose only and does not affect Firehose delivery throughput limit. You can use the [Firehose Limits form](https://docs.aws.amazon.com/https://support.console.aws.amazon.com/support/home#/case/create%3FissueType=service-limit-increase%26limitType=kinesis-firehose-limits) to request a throughput limit increase.
        """
        if throughput_hint_in_mbs is not None:
            pulumi.set(__self__, "throughput_hint_in_mbs", throughput_hint_in_mbs)

    @property
    @pulumi.getter(name="throughputHintInMbs")
    def throughput_hint_in_mbs(self) -> Optional[builtins.int]:
        """
        The value that you configure for this parameter is for information purpose only and does not affect Firehose delivery throughput limit. You can use the [Firehose Limits form](https://docs.aws.amazon.com/https://support.console.aws.amazon.com/support/home#/case/create%3FissueType=service-limit-increase%26limitType=kinesis-firehose-limits) to request a throughput limit increase.
        """
        return pulumi.get(self, "throughput_hint_in_mbs")


@pulumi.output_type
class DeliveryStreamDocumentIdOptions(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "defaultDocumentIdFormat":
            suggest = "default_document_id_format"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in DeliveryStreamDocumentIdOptions. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        DeliveryStreamDocumentIdOptions.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        DeliveryStreamDocumentIdOptions.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 default_document_id_format: 'DeliveryStreamDocumentIdOptionsDefaultDocumentIdFormat'):
        """
        :param 'DeliveryStreamDocumentIdOptionsDefaultDocumentIdFormat' default_document_id_format: When the `FIREHOSE_DEFAULT` option is chosen, Firehose generates a unique document ID for each record based on a unique internal identifier. The generated document ID is stable across multiple delivery attempts, which helps prevent the same record from being indexed multiple times with different document IDs.
               
               When the `NO_DOCUMENT_ID` option is chosen, Firehose does not include any document IDs in the requests it sends to the Amazon OpenSearch Service. This causes the Amazon OpenSearch Service domain to generate document IDs. In case of multiple delivery attempts, this may cause the same record to be indexed more than once with different document IDs. This option enables write-heavy operations, such as the ingestion of logs and observability data, to consume less resources in the Amazon OpenSearch Service domain, resulting in improved performance.
        """
        pulumi.set(__self__, "default_document_id_format", default_document_id_format)

    @property
    @pulumi.getter(name="defaultDocumentIdFormat")
    def default_document_id_format(self) -> 'DeliveryStreamDocumentIdOptionsDefaultDocumentIdFormat':
        """
        When the `FIREHOSE_DEFAULT` option is chosen, Firehose generates a unique document ID for each record based on a unique internal identifier. The generated document ID is stable across multiple delivery attempts, which helps prevent the same record from being indexed multiple times with different document IDs.

        When the `NO_DOCUMENT_ID` option is chosen, Firehose does not include any document IDs in the requests it sends to the Amazon OpenSearch Service. This causes the Amazon OpenSearch Service domain to generate document IDs. In case of multiple delivery attempts, this may cause the same record to be indexed more than once with different document IDs. This option enables write-heavy operations, such as the ingestion of logs and observability data, to consume less resources in the Amazon OpenSearch Service domain, resulting in improved performance.
        """
        return pulumi.get(self, "default_document_id_format")


@pulumi.output_type
class DeliveryStreamDynamicPartitioningConfiguration(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "retryOptions":
            suggest = "retry_options"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in DeliveryStreamDynamicPartitioningConfiguration. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        DeliveryStreamDynamicPartitioningConfiguration.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        DeliveryStreamDynamicPartitioningConfiguration.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 enabled: Optional[builtins.bool] = None,
                 retry_options: Optional['outputs.DeliveryStreamRetryOptions'] = None):
        """
        :param builtins.bool enabled: Specifies whether dynamic partitioning is enabled for this Kinesis Data Firehose delivery stream.
        :param 'DeliveryStreamRetryOptions' retry_options: Specifies the retry behavior in case Kinesis Data Firehose is unable to deliver data to an Amazon S3 prefix.
        """
        if enabled is not None:
            pulumi.set(__self__, "enabled", enabled)
        if retry_options is not None:
            pulumi.set(__self__, "retry_options", retry_options)

    @property
    @pulumi.getter
    def enabled(self) -> Optional[builtins.bool]:
        """
        Specifies whether dynamic partitioning is enabled for this Kinesis Data Firehose delivery stream.
        """
        return pulumi.get(self, "enabled")

    @property
    @pulumi.getter(name="retryOptions")
    def retry_options(self) -> Optional['outputs.DeliveryStreamRetryOptions']:
        """
        Specifies the retry behavior in case Kinesis Data Firehose is unable to deliver data to an Amazon S3 prefix.
        """
        return pulumi.get(self, "retry_options")


@pulumi.output_type
class DeliveryStreamElasticsearchBufferingHints(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "intervalInSeconds":
            suggest = "interval_in_seconds"
        elif key == "sizeInMbs":
            suggest = "size_in_mbs"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in DeliveryStreamElasticsearchBufferingHints. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        DeliveryStreamElasticsearchBufferingHints.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        DeliveryStreamElasticsearchBufferingHints.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 interval_in_seconds: Optional[builtins.int] = None,
                 size_in_mbs: Optional[builtins.int] = None):
        """
        :param builtins.int interval_in_seconds: The length of time, in seconds, that Kinesis Data Firehose buffers incoming data before delivering it to the destination. For valid values, see the `IntervalInSeconds` content for the [BufferingHints](https://docs.aws.amazon.com/firehose/latest/APIReference/API_BufferingHints.html) data type in the *Amazon Kinesis Data Firehose API Reference* .
        :param builtins.int size_in_mbs: The size of the buffer, in MBs, that Kinesis Data Firehose uses for incoming data before delivering it to the destination. For valid values, see the `SizeInMBs` content for the [BufferingHints](https://docs.aws.amazon.com/firehose/latest/APIReference/API_BufferingHints.html) data type in the *Amazon Kinesis Data Firehose API Reference* .
        """
        if interval_in_seconds is not None:
            pulumi.set(__self__, "interval_in_seconds", interval_in_seconds)
        if size_in_mbs is not None:
            pulumi.set(__self__, "size_in_mbs", size_in_mbs)

    @property
    @pulumi.getter(name="intervalInSeconds")
    def interval_in_seconds(self) -> Optional[builtins.int]:
        """
        The length of time, in seconds, that Kinesis Data Firehose buffers incoming data before delivering it to the destination. For valid values, see the `IntervalInSeconds` content for the [BufferingHints](https://docs.aws.amazon.com/firehose/latest/APIReference/API_BufferingHints.html) data type in the *Amazon Kinesis Data Firehose API Reference* .
        """
        return pulumi.get(self, "interval_in_seconds")

    @property
    @pulumi.getter(name="sizeInMbs")
    def size_in_mbs(self) -> Optional[builtins.int]:
        """
        The size of the buffer, in MBs, that Kinesis Data Firehose uses for incoming data before delivering it to the destination. For valid values, see the `SizeInMBs` content for the [BufferingHints](https://docs.aws.amazon.com/firehose/latest/APIReference/API_BufferingHints.html) data type in the *Amazon Kinesis Data Firehose API Reference* .
        """
        return pulumi.get(self, "size_in_mbs")


@pulumi.output_type
class DeliveryStreamElasticsearchDestinationConfiguration(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "indexName":
            suggest = "index_name"
        elif key == "roleArn":
            suggest = "role_arn"
        elif key == "s3Configuration":
            suggest = "s3_configuration"
        elif key == "bufferingHints":
            suggest = "buffering_hints"
        elif key == "cloudWatchLoggingOptions":
            suggest = "cloud_watch_logging_options"
        elif key == "clusterEndpoint":
            suggest = "cluster_endpoint"
        elif key == "documentIdOptions":
            suggest = "document_id_options"
        elif key == "domainArn":
            suggest = "domain_arn"
        elif key == "indexRotationPeriod":
            suggest = "index_rotation_period"
        elif key == "processingConfiguration":
            suggest = "processing_configuration"
        elif key == "retryOptions":
            suggest = "retry_options"
        elif key == "s3BackupMode":
            suggest = "s3_backup_mode"
        elif key == "typeName":
            suggest = "type_name"
        elif key == "vpcConfiguration":
            suggest = "vpc_configuration"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in DeliveryStreamElasticsearchDestinationConfiguration. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        DeliveryStreamElasticsearchDestinationConfiguration.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        DeliveryStreamElasticsearchDestinationConfiguration.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 index_name: builtins.str,
                 role_arn: builtins.str,
                 s3_configuration: 'outputs.DeliveryStreamS3DestinationConfiguration',
                 buffering_hints: Optional['outputs.DeliveryStreamElasticsearchBufferingHints'] = None,
                 cloud_watch_logging_options: Optional['outputs.DeliveryStreamCloudWatchLoggingOptions'] = None,
                 cluster_endpoint: Optional[builtins.str] = None,
                 document_id_options: Optional['outputs.DeliveryStreamDocumentIdOptions'] = None,
                 domain_arn: Optional[builtins.str] = None,
                 index_rotation_period: Optional['DeliveryStreamElasticsearchDestinationConfigurationIndexRotationPeriod'] = None,
                 processing_configuration: Optional['outputs.DeliveryStreamProcessingConfiguration'] = None,
                 retry_options: Optional['outputs.DeliveryStreamElasticsearchRetryOptions'] = None,
                 s3_backup_mode: Optional['DeliveryStreamElasticsearchDestinationConfigurationS3BackupMode'] = None,
                 type_name: Optional[builtins.str] = None,
                 vpc_configuration: Optional['outputs.DeliveryStreamVpcConfiguration'] = None):
        """
        :param builtins.str index_name: The name of the Elasticsearch index to which Kinesis Data Firehose adds data for indexing.
        :param builtins.str role_arn: The Amazon Resource Name (ARN) of the IAM role to be assumed by Kinesis Data Firehose for calling the Amazon ES Configuration API and for indexing documents. For more information, see [Controlling Access with Amazon Kinesis Data Firehose](https://docs.aws.amazon.com/firehose/latest/dev/controlling-access.html) .
        :param 'DeliveryStreamS3DestinationConfiguration' s3_configuration: The S3 bucket where Kinesis Data Firehose backs up incoming data.
        :param 'DeliveryStreamElasticsearchBufferingHints' buffering_hints: Configures how Kinesis Data Firehose buffers incoming data while delivering it to the Amazon ES domain.
        :param 'DeliveryStreamCloudWatchLoggingOptions' cloud_watch_logging_options: The Amazon CloudWatch Logs logging options for the delivery stream.
        :param builtins.str cluster_endpoint: The endpoint to use when communicating with the cluster. Specify either this `ClusterEndpoint` or the `DomainARN` field.
        :param 'DeliveryStreamDocumentIdOptions' document_id_options: Indicates the method for setting up document ID. The supported methods are Firehose generated document ID and OpenSearch Service generated document ID.
        :param builtins.str domain_arn: The ARN of the Amazon ES domain. The IAM role must have permissions for `DescribeElasticsearchDomain` , `DescribeElasticsearchDomains` , and `DescribeElasticsearchDomainConfig` after assuming the role specified in *RoleARN* .
               
               Specify either `ClusterEndpoint` or `DomainARN` .
        :param 'DeliveryStreamElasticsearchDestinationConfigurationIndexRotationPeriod' index_rotation_period: The frequency of Elasticsearch index rotation. If you enable index rotation, Kinesis Data Firehose appends a portion of the UTC arrival timestamp to the specified index name, and rotates the appended timestamp accordingly. For more information, see [Index Rotation for the Amazon ES Destination](https://docs.aws.amazon.com/firehose/latest/dev/basic-deliver.html#es-index-rotation) in the *Amazon Kinesis Data Firehose Developer Guide* .
        :param 'DeliveryStreamProcessingConfiguration' processing_configuration: The data processing configuration for the Kinesis Data Firehose delivery stream.
        :param 'DeliveryStreamElasticsearchRetryOptions' retry_options: The retry behavior when Kinesis Data Firehose is unable to deliver data to Amazon ES.
        :param 'DeliveryStreamElasticsearchDestinationConfigurationS3BackupMode' s3_backup_mode: The condition under which Kinesis Data Firehose delivers data to Amazon Simple Storage Service (Amazon S3). You can send Amazon S3 all documents (all data) or only the documents that Kinesis Data Firehose could not deliver to the Amazon ES destination. For more information and valid values, see the `S3BackupMode` content for the [ElasticsearchDestinationConfiguration](https://docs.aws.amazon.com/firehose/latest/APIReference/API_ElasticsearchDestinationConfiguration.html) data type in the *Amazon Kinesis Data Firehose API Reference* .
        :param builtins.str type_name: The Elasticsearch type name that Amazon ES adds to documents when indexing data.
        :param 'DeliveryStreamVpcConfiguration' vpc_configuration: The details of the VPC of the Amazon ES destination.
        """
        pulumi.set(__self__, "index_name", index_name)
        pulumi.set(__self__, "role_arn", role_arn)
        pulumi.set(__self__, "s3_configuration", s3_configuration)
        if buffering_hints is not None:
            pulumi.set(__self__, "buffering_hints", buffering_hints)
        if cloud_watch_logging_options is not None:
            pulumi.set(__self__, "cloud_watch_logging_options", cloud_watch_logging_options)
        if cluster_endpoint is not None:
            pulumi.set(__self__, "cluster_endpoint", cluster_endpoint)
        if document_id_options is not None:
            pulumi.set(__self__, "document_id_options", document_id_options)
        if domain_arn is not None:
            pulumi.set(__self__, "domain_arn", domain_arn)
        if index_rotation_period is not None:
            pulumi.set(__self__, "index_rotation_period", index_rotation_period)
        if processing_configuration is not None:
            pulumi.set(__self__, "processing_configuration", processing_configuration)
        if retry_options is not None:
            pulumi.set(__self__, "retry_options", retry_options)
        if s3_backup_mode is not None:
            pulumi.set(__self__, "s3_backup_mode", s3_backup_mode)
        if type_name is not None:
            pulumi.set(__self__, "type_name", type_name)
        if vpc_configuration is not None:
            pulumi.set(__self__, "vpc_configuration", vpc_configuration)

    @property
    @pulumi.getter(name="indexName")
    def index_name(self) -> builtins.str:
        """
        The name of the Elasticsearch index to which Kinesis Data Firehose adds data for indexing.
        """
        return pulumi.get(self, "index_name")

    @property
    @pulumi.getter(name="roleArn")
    def role_arn(self) -> builtins.str:
        """
        The Amazon Resource Name (ARN) of the IAM role to be assumed by Kinesis Data Firehose for calling the Amazon ES Configuration API and for indexing documents. For more information, see [Controlling Access with Amazon Kinesis Data Firehose](https://docs.aws.amazon.com/firehose/latest/dev/controlling-access.html) .
        """
        return pulumi.get(self, "role_arn")

    @property
    @pulumi.getter(name="s3Configuration")
    def s3_configuration(self) -> 'outputs.DeliveryStreamS3DestinationConfiguration':
        """
        The S3 bucket where Kinesis Data Firehose backs up incoming data.
        """
        return pulumi.get(self, "s3_configuration")

    @property
    @pulumi.getter(name="bufferingHints")
    def buffering_hints(self) -> Optional['outputs.DeliveryStreamElasticsearchBufferingHints']:
        """
        Configures how Kinesis Data Firehose buffers incoming data while delivering it to the Amazon ES domain.
        """
        return pulumi.get(self, "buffering_hints")

    @property
    @pulumi.getter(name="cloudWatchLoggingOptions")
    def cloud_watch_logging_options(self) -> Optional['outputs.DeliveryStreamCloudWatchLoggingOptions']:
        """
        The Amazon CloudWatch Logs logging options for the delivery stream.
        """
        return pulumi.get(self, "cloud_watch_logging_options")

    @property
    @pulumi.getter(name="clusterEndpoint")
    def cluster_endpoint(self) -> Optional[builtins.str]:
        """
        The endpoint to use when communicating with the cluster. Specify either this `ClusterEndpoint` or the `DomainARN` field.
        """
        return pulumi.get(self, "cluster_endpoint")

    @property
    @pulumi.getter(name="documentIdOptions")
    def document_id_options(self) -> Optional['outputs.DeliveryStreamDocumentIdOptions']:
        """
        Indicates the method for setting up document ID. The supported methods are Firehose generated document ID and OpenSearch Service generated document ID.
        """
        return pulumi.get(self, "document_id_options")

    @property
    @pulumi.getter(name="domainArn")
    def domain_arn(self) -> Optional[builtins.str]:
        """
        The ARN of the Amazon ES domain. The IAM role must have permissions for `DescribeElasticsearchDomain` , `DescribeElasticsearchDomains` , and `DescribeElasticsearchDomainConfig` after assuming the role specified in *RoleARN* .

        Specify either `ClusterEndpoint` or `DomainARN` .
        """
        return pulumi.get(self, "domain_arn")

    @property
    @pulumi.getter(name="indexRotationPeriod")
    def index_rotation_period(self) -> Optional['DeliveryStreamElasticsearchDestinationConfigurationIndexRotationPeriod']:
        """
        The frequency of Elasticsearch index rotation. If you enable index rotation, Kinesis Data Firehose appends a portion of the UTC arrival timestamp to the specified index name, and rotates the appended timestamp accordingly. For more information, see [Index Rotation for the Amazon ES Destination](https://docs.aws.amazon.com/firehose/latest/dev/basic-deliver.html#es-index-rotation) in the *Amazon Kinesis Data Firehose Developer Guide* .
        """
        return pulumi.get(self, "index_rotation_period")

    @property
    @pulumi.getter(name="processingConfiguration")
    def processing_configuration(self) -> Optional['outputs.DeliveryStreamProcessingConfiguration']:
        """
        The data processing configuration for the Kinesis Data Firehose delivery stream.
        """
        return pulumi.get(self, "processing_configuration")

    @property
    @pulumi.getter(name="retryOptions")
    def retry_options(self) -> Optional['outputs.DeliveryStreamElasticsearchRetryOptions']:
        """
        The retry behavior when Kinesis Data Firehose is unable to deliver data to Amazon ES.
        """
        return pulumi.get(self, "retry_options")

    @property
    @pulumi.getter(name="s3BackupMode")
    def s3_backup_mode(self) -> Optional['DeliveryStreamElasticsearchDestinationConfigurationS3BackupMode']:
        """
        The condition under which Kinesis Data Firehose delivers data to Amazon Simple Storage Service (Amazon S3). You can send Amazon S3 all documents (all data) or only the documents that Kinesis Data Firehose could not deliver to the Amazon ES destination. For more information and valid values, see the `S3BackupMode` content for the [ElasticsearchDestinationConfiguration](https://docs.aws.amazon.com/firehose/latest/APIReference/API_ElasticsearchDestinationConfiguration.html) data type in the *Amazon Kinesis Data Firehose API Reference* .
        """
        return pulumi.get(self, "s3_backup_mode")

    @property
    @pulumi.getter(name="typeName")
    def type_name(self) -> Optional[builtins.str]:
        """
        The Elasticsearch type name that Amazon ES adds to documents when indexing data.
        """
        return pulumi.get(self, "type_name")

    @property
    @pulumi.getter(name="vpcConfiguration")
    def vpc_configuration(self) -> Optional['outputs.DeliveryStreamVpcConfiguration']:
        """
        The details of the VPC of the Amazon ES destination.
        """
        return pulumi.get(self, "vpc_configuration")


@pulumi.output_type
class DeliveryStreamElasticsearchRetryOptions(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "durationInSeconds":
            suggest = "duration_in_seconds"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in DeliveryStreamElasticsearchRetryOptions. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        DeliveryStreamElasticsearchRetryOptions.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        DeliveryStreamElasticsearchRetryOptions.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 duration_in_seconds: Optional[builtins.int] = None):
        """
        :param builtins.int duration_in_seconds: After an initial failure to deliver to Amazon ES, the total amount of time during which Kinesis Data Firehose re-attempts delivery (including the first attempt). If Kinesis Data Firehose can't deliver the data within the specified time, it writes the data to the backup S3 bucket. For valid values, see the `DurationInSeconds` content for the [ElasticsearchRetryOptions](https://docs.aws.amazon.com/firehose/latest/APIReference/API_ElasticsearchRetryOptions.html) data type in the *Amazon Kinesis Data Firehose API Reference* .
        """
        if duration_in_seconds is not None:
            pulumi.set(__self__, "duration_in_seconds", duration_in_seconds)

    @property
    @pulumi.getter(name="durationInSeconds")
    def duration_in_seconds(self) -> Optional[builtins.int]:
        """
        After an initial failure to deliver to Amazon ES, the total amount of time during which Kinesis Data Firehose re-attempts delivery (including the first attempt). If Kinesis Data Firehose can't deliver the data within the specified time, it writes the data to the backup S3 bucket. For valid values, see the `DurationInSeconds` content for the [ElasticsearchRetryOptions](https://docs.aws.amazon.com/firehose/latest/APIReference/API_ElasticsearchRetryOptions.html) data type in the *Amazon Kinesis Data Firehose API Reference* .
        """
        return pulumi.get(self, "duration_in_seconds")


@pulumi.output_type
class DeliveryStreamEncryptionConfiguration(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "kmsEncryptionConfig":
            suggest = "kms_encryption_config"
        elif key == "noEncryptionConfig":
            suggest = "no_encryption_config"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in DeliveryStreamEncryptionConfiguration. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        DeliveryStreamEncryptionConfiguration.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        DeliveryStreamEncryptionConfiguration.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 kms_encryption_config: Optional['outputs.DeliveryStreamKmsEncryptionConfig'] = None,
                 no_encryption_config: Optional['DeliveryStreamEncryptionConfigurationNoEncryptionConfig'] = None):
        """
        :param 'DeliveryStreamKmsEncryptionConfig' kms_encryption_config: The AWS Key Management Service ( AWS KMS) encryption key that Amazon S3 uses to encrypt your data.
        :param 'DeliveryStreamEncryptionConfigurationNoEncryptionConfig' no_encryption_config: Disables encryption. For valid values, see the `NoEncryptionConfig` content for the [EncryptionConfiguration](https://docs.aws.amazon.com/firehose/latest/APIReference/API_EncryptionConfiguration.html) data type in the *Amazon Kinesis Data Firehose API Reference* .
        """
        if kms_encryption_config is not None:
            pulumi.set(__self__, "kms_encryption_config", kms_encryption_config)
        if no_encryption_config is not None:
            pulumi.set(__self__, "no_encryption_config", no_encryption_config)

    @property
    @pulumi.getter(name="kmsEncryptionConfig")
    def kms_encryption_config(self) -> Optional['outputs.DeliveryStreamKmsEncryptionConfig']:
        """
        The AWS Key Management Service ( AWS KMS) encryption key that Amazon S3 uses to encrypt your data.
        """
        return pulumi.get(self, "kms_encryption_config")

    @property
    @pulumi.getter(name="noEncryptionConfig")
    def no_encryption_config(self) -> Optional['DeliveryStreamEncryptionConfigurationNoEncryptionConfig']:
        """
        Disables encryption. For valid values, see the `NoEncryptionConfig` content for the [EncryptionConfiguration](https://docs.aws.amazon.com/firehose/latest/APIReference/API_EncryptionConfiguration.html) data type in the *Amazon Kinesis Data Firehose API Reference* .
        """
        return pulumi.get(self, "no_encryption_config")


@pulumi.output_type
class DeliveryStreamEncryptionConfigurationInput(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "keyType":
            suggest = "key_type"
        elif key == "keyArn":
            suggest = "key_arn"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in DeliveryStreamEncryptionConfigurationInput. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        DeliveryStreamEncryptionConfigurationInput.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        DeliveryStreamEncryptionConfigurationInput.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 key_type: 'DeliveryStreamEncryptionConfigurationInputKeyType',
                 key_arn: Optional[builtins.str] = None):
        """
        :param 'DeliveryStreamEncryptionConfigurationInputKeyType' key_type: Indicates the type of customer master key (CMK) to use for encryption. The default setting is `AWS_OWNED_CMK` . For more information about CMKs, see [Customer Master Keys (CMKs)](https://docs.aws.amazon.com/kms/latest/developerguide/concepts.html#master_keys) .
               
               You can use a CMK of type CUSTOMER_MANAGED_CMK to encrypt up to 500 delivery streams.
               
               > To encrypt your delivery stream, use symmetric CMKs. Kinesis Data Firehose doesn't support asymmetric CMKs. For information about symmetric and asymmetric CMKs, see [About Symmetric and Asymmetric CMKs](https://docs.aws.amazon.com/kms/latest/developerguide/symm-asymm-concepts.html) in the AWS Key Management Service developer guide.
        :param builtins.str key_arn: If you set `KeyType` to `CUSTOMER_MANAGED_CMK` , you must specify the Amazon Resource Name (ARN) of the CMK. If you set `KeyType` to `AWS _OWNED_CMK` , Firehose uses a service-account CMK.
        """
        pulumi.set(__self__, "key_type", key_type)
        if key_arn is not None:
            pulumi.set(__self__, "key_arn", key_arn)

    @property
    @pulumi.getter(name="keyType")
    def key_type(self) -> 'DeliveryStreamEncryptionConfigurationInputKeyType':
        """
        Indicates the type of customer master key (CMK) to use for encryption. The default setting is `AWS_OWNED_CMK` . For more information about CMKs, see [Customer Master Keys (CMKs)](https://docs.aws.amazon.com/kms/latest/developerguide/concepts.html#master_keys) .

        You can use a CMK of type CUSTOMER_MANAGED_CMK to encrypt up to 500 delivery streams.

        > To encrypt your delivery stream, use symmetric CMKs. Kinesis Data Firehose doesn't support asymmetric CMKs. For information about symmetric and asymmetric CMKs, see [About Symmetric and Asymmetric CMKs](https://docs.aws.amazon.com/kms/latest/developerguide/symm-asymm-concepts.html) in the AWS Key Management Service developer guide.
        """
        return pulumi.get(self, "key_type")

    @property
    @pulumi.getter(name="keyArn")
    def key_arn(self) -> Optional[builtins.str]:
        """
        If you set `KeyType` to `CUSTOMER_MANAGED_CMK` , you must specify the Amazon Resource Name (ARN) of the CMK. If you set `KeyType` to `AWS _OWNED_CMK` , Firehose uses a service-account CMK.
        """
        return pulumi.get(self, "key_arn")


@pulumi.output_type
class DeliveryStreamExtendedS3DestinationConfiguration(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "bucketArn":
            suggest = "bucket_arn"
        elif key == "roleArn":
            suggest = "role_arn"
        elif key == "bufferingHints":
            suggest = "buffering_hints"
        elif key == "cloudWatchLoggingOptions":
            suggest = "cloud_watch_logging_options"
        elif key == "compressionFormat":
            suggest = "compression_format"
        elif key == "customTimeZone":
            suggest = "custom_time_zone"
        elif key == "dataFormatConversionConfiguration":
            suggest = "data_format_conversion_configuration"
        elif key == "dynamicPartitioningConfiguration":
            suggest = "dynamic_partitioning_configuration"
        elif key == "encryptionConfiguration":
            suggest = "encryption_configuration"
        elif key == "errorOutputPrefix":
            suggest = "error_output_prefix"
        elif key == "fileExtension":
            suggest = "file_extension"
        elif key == "processingConfiguration":
            suggest = "processing_configuration"
        elif key == "s3BackupConfiguration":
            suggest = "s3_backup_configuration"
        elif key == "s3BackupMode":
            suggest = "s3_backup_mode"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in DeliveryStreamExtendedS3DestinationConfiguration. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        DeliveryStreamExtendedS3DestinationConfiguration.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        DeliveryStreamExtendedS3DestinationConfiguration.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 bucket_arn: builtins.str,
                 role_arn: builtins.str,
                 buffering_hints: Optional['outputs.DeliveryStreamBufferingHints'] = None,
                 cloud_watch_logging_options: Optional['outputs.DeliveryStreamCloudWatchLoggingOptions'] = None,
                 compression_format: Optional['DeliveryStreamExtendedS3DestinationConfigurationCompressionFormat'] = None,
                 custom_time_zone: Optional[builtins.str] = None,
                 data_format_conversion_configuration: Optional['outputs.DeliveryStreamDataFormatConversionConfiguration'] = None,
                 dynamic_partitioning_configuration: Optional['outputs.DeliveryStreamDynamicPartitioningConfiguration'] = None,
                 encryption_configuration: Optional['outputs.DeliveryStreamEncryptionConfiguration'] = None,
                 error_output_prefix: Optional[builtins.str] = None,
                 file_extension: Optional[builtins.str] = None,
                 prefix: Optional[builtins.str] = None,
                 processing_configuration: Optional['outputs.DeliveryStreamProcessingConfiguration'] = None,
                 s3_backup_configuration: Optional['outputs.DeliveryStreamS3DestinationConfiguration'] = None,
                 s3_backup_mode: Optional['DeliveryStreamExtendedS3DestinationConfigurationS3BackupMode'] = None):
        """
        :param builtins.str bucket_arn: The Amazon Resource Name (ARN) of the Amazon S3 bucket. For constraints, see [ExtendedS3DestinationConfiguration](https://docs.aws.amazon.com/firehose/latest/APIReference/API_ExtendedS3DestinationConfiguration.html) in the *Amazon Kinesis Data Firehose API Reference* .
        :param builtins.str role_arn: The Amazon Resource Name (ARN) of the AWS credentials. For constraints, see [ExtendedS3DestinationConfiguration](https://docs.aws.amazon.com/firehose/latest/APIReference/API_ExtendedS3DestinationConfiguration.html) in the *Amazon Kinesis Data Firehose API Reference* .
        :param 'DeliveryStreamBufferingHints' buffering_hints: The buffering option.
        :param 'DeliveryStreamCloudWatchLoggingOptions' cloud_watch_logging_options: The Amazon CloudWatch logging options for your Firehose stream.
        :param 'DeliveryStreamExtendedS3DestinationConfigurationCompressionFormat' compression_format: The compression format. If no value is specified, the default is `UNCOMPRESSED` .
        :param builtins.str custom_time_zone: The time zone you prefer. UTC is the default.
        :param 'DeliveryStreamDataFormatConversionConfiguration' data_format_conversion_configuration: The serializer, deserializer, and schema for converting data from the JSON format to the Parquet or ORC format before writing it to Amazon S3.
        :param 'DeliveryStreamDynamicPartitioningConfiguration' dynamic_partitioning_configuration: The configuration of the dynamic partitioning mechanism that creates targeted data sets from the streaming data by partitioning it based on partition keys.
        :param 'DeliveryStreamEncryptionConfiguration' encryption_configuration: The encryption configuration for the Kinesis Data Firehose delivery stream. The default value is `NoEncryption` .
        :param builtins.str error_output_prefix: A prefix that Kinesis Data Firehose evaluates and adds to failed records before writing them to S3. This prefix appears immediately following the bucket name. For information about how to specify this prefix, see [Custom Prefixes for Amazon S3 Objects](https://docs.aws.amazon.com/firehose/latest/dev/s3-prefixes.html) .
        :param builtins.str file_extension: Specify a file extension. It will override the default file extension
        :param builtins.str prefix: The `YYYY/MM/DD/HH` time format prefix is automatically used for delivered Amazon S3 files. For more information, see [ExtendedS3DestinationConfiguration](https://docs.aws.amazon.com/firehose/latest/APIReference/API_ExtendedS3DestinationConfiguration.html) in the *Amazon Kinesis Data Firehose API Reference* .
        :param 'DeliveryStreamProcessingConfiguration' processing_configuration: The data processing configuration for the Kinesis Data Firehose delivery stream.
        :param 'DeliveryStreamS3DestinationConfiguration' s3_backup_configuration: The configuration for backup in Amazon S3.
        :param 'DeliveryStreamExtendedS3DestinationConfigurationS3BackupMode' s3_backup_mode: The Amazon S3 backup mode. After you create a Firehose stream, you can update it to enable Amazon S3 backup if it is disabled. If backup is enabled, you can't update the Firehose stream to disable it.
        """
        pulumi.set(__self__, "bucket_arn", bucket_arn)
        pulumi.set(__self__, "role_arn", role_arn)
        if buffering_hints is not None:
            pulumi.set(__self__, "buffering_hints", buffering_hints)
        if cloud_watch_logging_options is not None:
            pulumi.set(__self__, "cloud_watch_logging_options", cloud_watch_logging_options)
        if compression_format is not None:
            pulumi.set(__self__, "compression_format", compression_format)
        if custom_time_zone is not None:
            pulumi.set(__self__, "custom_time_zone", custom_time_zone)
        if data_format_conversion_configuration is not None:
            pulumi.set(__self__, "data_format_conversion_configuration", data_format_conversion_configuration)
        if dynamic_partitioning_configuration is not None:
            pulumi.set(__self__, "dynamic_partitioning_configuration", dynamic_partitioning_configuration)
        if encryption_configuration is not None:
            pulumi.set(__self__, "encryption_configuration", encryption_configuration)
        if error_output_prefix is not None:
            pulumi.set(__self__, "error_output_prefix", error_output_prefix)
        if file_extension is not None:
            pulumi.set(__self__, "file_extension", file_extension)
        if prefix is not None:
            pulumi.set(__self__, "prefix", prefix)
        if processing_configuration is not None:
            pulumi.set(__self__, "processing_configuration", processing_configuration)
        if s3_backup_configuration is not None:
            pulumi.set(__self__, "s3_backup_configuration", s3_backup_configuration)
        if s3_backup_mode is not None:
            pulumi.set(__self__, "s3_backup_mode", s3_backup_mode)

    @property
    @pulumi.getter(name="bucketArn")
    def bucket_arn(self) -> builtins.str:
        """
        The Amazon Resource Name (ARN) of the Amazon S3 bucket. For constraints, see [ExtendedS3DestinationConfiguration](https://docs.aws.amazon.com/firehose/latest/APIReference/API_ExtendedS3DestinationConfiguration.html) in the *Amazon Kinesis Data Firehose API Reference* .
        """
        return pulumi.get(self, "bucket_arn")

    @property
    @pulumi.getter(name="roleArn")
    def role_arn(self) -> builtins.str:
        """
        The Amazon Resource Name (ARN) of the AWS credentials. For constraints, see [ExtendedS3DestinationConfiguration](https://docs.aws.amazon.com/firehose/latest/APIReference/API_ExtendedS3DestinationConfiguration.html) in the *Amazon Kinesis Data Firehose API Reference* .
        """
        return pulumi.get(self, "role_arn")

    @property
    @pulumi.getter(name="bufferingHints")
    def buffering_hints(self) -> Optional['outputs.DeliveryStreamBufferingHints']:
        """
        The buffering option.
        """
        return pulumi.get(self, "buffering_hints")

    @property
    @pulumi.getter(name="cloudWatchLoggingOptions")
    def cloud_watch_logging_options(self) -> Optional['outputs.DeliveryStreamCloudWatchLoggingOptions']:
        """
        The Amazon CloudWatch logging options for your Firehose stream.
        """
        return pulumi.get(self, "cloud_watch_logging_options")

    @property
    @pulumi.getter(name="compressionFormat")
    def compression_format(self) -> Optional['DeliveryStreamExtendedS3DestinationConfigurationCompressionFormat']:
        """
        The compression format. If no value is specified, the default is `UNCOMPRESSED` .
        """
        return pulumi.get(self, "compression_format")

    @property
    @pulumi.getter(name="customTimeZone")
    def custom_time_zone(self) -> Optional[builtins.str]:
        """
        The time zone you prefer. UTC is the default.
        """
        return pulumi.get(self, "custom_time_zone")

    @property
    @pulumi.getter(name="dataFormatConversionConfiguration")
    def data_format_conversion_configuration(self) -> Optional['outputs.DeliveryStreamDataFormatConversionConfiguration']:
        """
        The serializer, deserializer, and schema for converting data from the JSON format to the Parquet or ORC format before writing it to Amazon S3.
        """
        return pulumi.get(self, "data_format_conversion_configuration")

    @property
    @pulumi.getter(name="dynamicPartitioningConfiguration")
    def dynamic_partitioning_configuration(self) -> Optional['outputs.DeliveryStreamDynamicPartitioningConfiguration']:
        """
        The configuration of the dynamic partitioning mechanism that creates targeted data sets from the streaming data by partitioning it based on partition keys.
        """
        return pulumi.get(self, "dynamic_partitioning_configuration")

    @property
    @pulumi.getter(name="encryptionConfiguration")
    def encryption_configuration(self) -> Optional['outputs.DeliveryStreamEncryptionConfiguration']:
        """
        The encryption configuration for the Kinesis Data Firehose delivery stream. The default value is `NoEncryption` .
        """
        return pulumi.get(self, "encryption_configuration")

    @property
    @pulumi.getter(name="errorOutputPrefix")
    def error_output_prefix(self) -> Optional[builtins.str]:
        """
        A prefix that Kinesis Data Firehose evaluates and adds to failed records before writing them to S3. This prefix appears immediately following the bucket name. For information about how to specify this prefix, see [Custom Prefixes for Amazon S3 Objects](https://docs.aws.amazon.com/firehose/latest/dev/s3-prefixes.html) .
        """
        return pulumi.get(self, "error_output_prefix")

    @property
    @pulumi.getter(name="fileExtension")
    def file_extension(self) -> Optional[builtins.str]:
        """
        Specify a file extension. It will override the default file extension
        """
        return pulumi.get(self, "file_extension")

    @property
    @pulumi.getter
    def prefix(self) -> Optional[builtins.str]:
        """
        The `YYYY/MM/DD/HH` time format prefix is automatically used for delivered Amazon S3 files. For more information, see [ExtendedS3DestinationConfiguration](https://docs.aws.amazon.com/firehose/latest/APIReference/API_ExtendedS3DestinationConfiguration.html) in the *Amazon Kinesis Data Firehose API Reference* .
        """
        return pulumi.get(self, "prefix")

    @property
    @pulumi.getter(name="processingConfiguration")
    def processing_configuration(self) -> Optional['outputs.DeliveryStreamProcessingConfiguration']:
        """
        The data processing configuration for the Kinesis Data Firehose delivery stream.
        """
        return pulumi.get(self, "processing_configuration")

    @property
    @pulumi.getter(name="s3BackupConfiguration")
    def s3_backup_configuration(self) -> Optional['outputs.DeliveryStreamS3DestinationConfiguration']:
        """
        The configuration for backup in Amazon S3.
        """
        return pulumi.get(self, "s3_backup_configuration")

    @property
    @pulumi.getter(name="s3BackupMode")
    def s3_backup_mode(self) -> Optional['DeliveryStreamExtendedS3DestinationConfigurationS3BackupMode']:
        """
        The Amazon S3 backup mode. After you create a Firehose stream, you can update it to enable Amazon S3 backup if it is disabled. If backup is enabled, you can't update the Firehose stream to disable it.
        """
        return pulumi.get(self, "s3_backup_mode")


@pulumi.output_type
class DeliveryStreamHiveJsonSerDe(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "timestampFormats":
            suggest = "timestamp_formats"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in DeliveryStreamHiveJsonSerDe. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        DeliveryStreamHiveJsonSerDe.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        DeliveryStreamHiveJsonSerDe.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 timestamp_formats: Optional[Sequence[builtins.str]] = None):
        """
        :param Sequence[builtins.str] timestamp_formats: Indicates how you want Firehose to parse the date and timestamps that may be present in your input data JSON. To specify these format strings, follow the pattern syntax of JodaTime's DateTimeFormat format strings. For more information, see [Class DateTimeFormat](https://docs.aws.amazon.com/https://www.joda.org/joda-time/apidocs/org/joda/time/format/DateTimeFormat.html) . You can also use the special value `millis` to parse timestamps in epoch milliseconds. If you don't specify a format, Firehose uses `java.sql.Timestamp::valueOf` by default.
        """
        if timestamp_formats is not None:
            pulumi.set(__self__, "timestamp_formats", timestamp_formats)

    @property
    @pulumi.getter(name="timestampFormats")
    def timestamp_formats(self) -> Optional[Sequence[builtins.str]]:
        """
        Indicates how you want Firehose to parse the date and timestamps that may be present in your input data JSON. To specify these format strings, follow the pattern syntax of JodaTime's DateTimeFormat format strings. For more information, see [Class DateTimeFormat](https://docs.aws.amazon.com/https://www.joda.org/joda-time/apidocs/org/joda/time/format/DateTimeFormat.html) . You can also use the special value `millis` to parse timestamps in epoch milliseconds. If you don't specify a format, Firehose uses `java.sql.Timestamp::valueOf` by default.
        """
        return pulumi.get(self, "timestamp_formats")


@pulumi.output_type
class DeliveryStreamHttpEndpointCommonAttribute(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "attributeName":
            suggest = "attribute_name"
        elif key == "attributeValue":
            suggest = "attribute_value"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in DeliveryStreamHttpEndpointCommonAttribute. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        DeliveryStreamHttpEndpointCommonAttribute.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        DeliveryStreamHttpEndpointCommonAttribute.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 attribute_name: builtins.str,
                 attribute_value: builtins.str):
        """
        :param builtins.str attribute_name: The name of the HTTP endpoint common attribute.
        :param builtins.str attribute_value: The value of the HTTP endpoint common attribute.
        """
        pulumi.set(__self__, "attribute_name", attribute_name)
        pulumi.set(__self__, "attribute_value", attribute_value)

    @property
    @pulumi.getter(name="attributeName")
    def attribute_name(self) -> builtins.str:
        """
        The name of the HTTP endpoint common attribute.
        """
        return pulumi.get(self, "attribute_name")

    @property
    @pulumi.getter(name="attributeValue")
    def attribute_value(self) -> builtins.str:
        """
        The value of the HTTP endpoint common attribute.
        """
        return pulumi.get(self, "attribute_value")


@pulumi.output_type
class DeliveryStreamHttpEndpointConfiguration(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "accessKey":
            suggest = "access_key"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in DeliveryStreamHttpEndpointConfiguration. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        DeliveryStreamHttpEndpointConfiguration.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        DeliveryStreamHttpEndpointConfiguration.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 url: builtins.str,
                 access_key: Optional[builtins.str] = None,
                 name: Optional[builtins.str] = None):
        """
        :param builtins.str url: The URL of the HTTP endpoint selected as the destination.
        :param builtins.str access_key: The access key required for Kinesis Firehose to authenticate with the HTTP endpoint selected as the destination.
        :param builtins.str name: The name of the HTTP endpoint selected as the destination.
        """
        pulumi.set(__self__, "url", url)
        if access_key is not None:
            pulumi.set(__self__, "access_key", access_key)
        if name is not None:
            pulumi.set(__self__, "name", name)

    @property
    @pulumi.getter
    def url(self) -> builtins.str:
        """
        The URL of the HTTP endpoint selected as the destination.
        """
        return pulumi.get(self, "url")

    @property
    @pulumi.getter(name="accessKey")
    def access_key(self) -> Optional[builtins.str]:
        """
        The access key required for Kinesis Firehose to authenticate with the HTTP endpoint selected as the destination.
        """
        return pulumi.get(self, "access_key")

    @property
    @pulumi.getter
    def name(self) -> Optional[builtins.str]:
        """
        The name of the HTTP endpoint selected as the destination.
        """
        return pulumi.get(self, "name")


@pulumi.output_type
class DeliveryStreamHttpEndpointDestinationConfiguration(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "endpointConfiguration":
            suggest = "endpoint_configuration"
        elif key == "s3Configuration":
            suggest = "s3_configuration"
        elif key == "bufferingHints":
            suggest = "buffering_hints"
        elif key == "cloudWatchLoggingOptions":
            suggest = "cloud_watch_logging_options"
        elif key == "processingConfiguration":
            suggest = "processing_configuration"
        elif key == "requestConfiguration":
            suggest = "request_configuration"
        elif key == "retryOptions":
            suggest = "retry_options"
        elif key == "roleArn":
            suggest = "role_arn"
        elif key == "s3BackupMode":
            suggest = "s3_backup_mode"
        elif key == "secretsManagerConfiguration":
            suggest = "secrets_manager_configuration"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in DeliveryStreamHttpEndpointDestinationConfiguration. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        DeliveryStreamHttpEndpointDestinationConfiguration.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        DeliveryStreamHttpEndpointDestinationConfiguration.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 endpoint_configuration: 'outputs.DeliveryStreamHttpEndpointConfiguration',
                 s3_configuration: 'outputs.DeliveryStreamS3DestinationConfiguration',
                 buffering_hints: Optional['outputs.DeliveryStreamBufferingHints'] = None,
                 cloud_watch_logging_options: Optional['outputs.DeliveryStreamCloudWatchLoggingOptions'] = None,
                 processing_configuration: Optional['outputs.DeliveryStreamProcessingConfiguration'] = None,
                 request_configuration: Optional['outputs.DeliveryStreamHttpEndpointRequestConfiguration'] = None,
                 retry_options: Optional['outputs.DeliveryStreamRetryOptions'] = None,
                 role_arn: Optional[builtins.str] = None,
                 s3_backup_mode: Optional[builtins.str] = None,
                 secrets_manager_configuration: Optional['outputs.DeliveryStreamSecretsManagerConfiguration'] = None):
        """
        :param 'DeliveryStreamHttpEndpointConfiguration' endpoint_configuration: The configuration of the HTTP endpoint selected as the destination.
        :param 'DeliveryStreamS3DestinationConfiguration' s3_configuration: Describes the configuration of a destination in Amazon S3.
        :param 'DeliveryStreamBufferingHints' buffering_hints: The buffering options that can be used before data is delivered to the specified destination. Kinesis Data Firehose treats these options as hints, and it might choose to use more optimal values. The SizeInMBs and IntervalInSeconds parameters are optional. However, if you specify a value for one of them, you must also provide a value for the other.
        :param 'DeliveryStreamCloudWatchLoggingOptions' cloud_watch_logging_options: Describes the Amazon CloudWatch logging options for your delivery stream.
        :param 'DeliveryStreamProcessingConfiguration' processing_configuration: Describes the data processing configuration.
        :param 'DeliveryStreamHttpEndpointRequestConfiguration' request_configuration: The configuration of the request sent to the HTTP endpoint specified as the destination.
        :param 'DeliveryStreamRetryOptions' retry_options: Describes the retry behavior in case Kinesis Data Firehose is unable to deliver data to the specified HTTP endpoint destination, or if it doesn't receive a valid acknowledgment of receipt from the specified HTTP endpoint destination.
        :param builtins.str role_arn: Kinesis Data Firehose uses this IAM role for all the permissions that the delivery stream needs.
        :param builtins.str s3_backup_mode: Describes the S3 bucket backup options for the data that Kinesis Data Firehose delivers to the HTTP endpoint destination. You can back up all documents (AllData) or only the documents that Kinesis Data Firehose could not deliver to the specified HTTP endpoint destination (FailedDataOnly).
        :param 'DeliveryStreamSecretsManagerConfiguration' secrets_manager_configuration: The configuration that defines how you access secrets for HTTP Endpoint destination.
        """
        pulumi.set(__self__, "endpoint_configuration", endpoint_configuration)
        pulumi.set(__self__, "s3_configuration", s3_configuration)
        if buffering_hints is not None:
            pulumi.set(__self__, "buffering_hints", buffering_hints)
        if cloud_watch_logging_options is not None:
            pulumi.set(__self__, "cloud_watch_logging_options", cloud_watch_logging_options)
        if processing_configuration is not None:
            pulumi.set(__self__, "processing_configuration", processing_configuration)
        if request_configuration is not None:
            pulumi.set(__self__, "request_configuration", request_configuration)
        if retry_options is not None:
            pulumi.set(__self__, "retry_options", retry_options)
        if role_arn is not None:
            pulumi.set(__self__, "role_arn", role_arn)
        if s3_backup_mode is not None:
            pulumi.set(__self__, "s3_backup_mode", s3_backup_mode)
        if secrets_manager_configuration is not None:
            pulumi.set(__self__, "secrets_manager_configuration", secrets_manager_configuration)

    @property
    @pulumi.getter(name="endpointConfiguration")
    def endpoint_configuration(self) -> 'outputs.DeliveryStreamHttpEndpointConfiguration':
        """
        The configuration of the HTTP endpoint selected as the destination.
        """
        return pulumi.get(self, "endpoint_configuration")

    @property
    @pulumi.getter(name="s3Configuration")
    def s3_configuration(self) -> 'outputs.DeliveryStreamS3DestinationConfiguration':
        """
        Describes the configuration of a destination in Amazon S3.
        """
        return pulumi.get(self, "s3_configuration")

    @property
    @pulumi.getter(name="bufferingHints")
    def buffering_hints(self) -> Optional['outputs.DeliveryStreamBufferingHints']:
        """
        The buffering options that can be used before data is delivered to the specified destination. Kinesis Data Firehose treats these options as hints, and it might choose to use more optimal values. The SizeInMBs and IntervalInSeconds parameters are optional. However, if you specify a value for one of them, you must also provide a value for the other.
        """
        return pulumi.get(self, "buffering_hints")

    @property
    @pulumi.getter(name="cloudWatchLoggingOptions")
    def cloud_watch_logging_options(self) -> Optional['outputs.DeliveryStreamCloudWatchLoggingOptions']:
        """
        Describes the Amazon CloudWatch logging options for your delivery stream.
        """
        return pulumi.get(self, "cloud_watch_logging_options")

    @property
    @pulumi.getter(name="processingConfiguration")
    def processing_configuration(self) -> Optional['outputs.DeliveryStreamProcessingConfiguration']:
        """
        Describes the data processing configuration.
        """
        return pulumi.get(self, "processing_configuration")

    @property
    @pulumi.getter(name="requestConfiguration")
    def request_configuration(self) -> Optional['outputs.DeliveryStreamHttpEndpointRequestConfiguration']:
        """
        The configuration of the request sent to the HTTP endpoint specified as the destination.
        """
        return pulumi.get(self, "request_configuration")

    @property
    @pulumi.getter(name="retryOptions")
    def retry_options(self) -> Optional['outputs.DeliveryStreamRetryOptions']:
        """
        Describes the retry behavior in case Kinesis Data Firehose is unable to deliver data to the specified HTTP endpoint destination, or if it doesn't receive a valid acknowledgment of receipt from the specified HTTP endpoint destination.
        """
        return pulumi.get(self, "retry_options")

    @property
    @pulumi.getter(name="roleArn")
    def role_arn(self) -> Optional[builtins.str]:
        """
        Kinesis Data Firehose uses this IAM role for all the permissions that the delivery stream needs.
        """
        return pulumi.get(self, "role_arn")

    @property
    @pulumi.getter(name="s3BackupMode")
    def s3_backup_mode(self) -> Optional[builtins.str]:
        """
        Describes the S3 bucket backup options for the data that Kinesis Data Firehose delivers to the HTTP endpoint destination. You can back up all documents (AllData) or only the documents that Kinesis Data Firehose could not deliver to the specified HTTP endpoint destination (FailedDataOnly).
        """
        return pulumi.get(self, "s3_backup_mode")

    @property
    @pulumi.getter(name="secretsManagerConfiguration")
    def secrets_manager_configuration(self) -> Optional['outputs.DeliveryStreamSecretsManagerConfiguration']:
        """
        The configuration that defines how you access secrets for HTTP Endpoint destination.
        """
        return pulumi.get(self, "secrets_manager_configuration")


@pulumi.output_type
class DeliveryStreamHttpEndpointRequestConfiguration(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "commonAttributes":
            suggest = "common_attributes"
        elif key == "contentEncoding":
            suggest = "content_encoding"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in DeliveryStreamHttpEndpointRequestConfiguration. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        DeliveryStreamHttpEndpointRequestConfiguration.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        DeliveryStreamHttpEndpointRequestConfiguration.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 common_attributes: Optional[Sequence['outputs.DeliveryStreamHttpEndpointCommonAttribute']] = None,
                 content_encoding: Optional['DeliveryStreamHttpEndpointRequestConfigurationContentEncoding'] = None):
        """
        :param Sequence['DeliveryStreamHttpEndpointCommonAttribute'] common_attributes: Describes the metadata sent to the HTTP endpoint destination.
        :param 'DeliveryStreamHttpEndpointRequestConfigurationContentEncoding' content_encoding: Kinesis Data Firehose uses the content encoding to compress the body of a request before sending the request to the destination. For more information, see Content-Encoding in MDN Web Docs, the official Mozilla documentation.
        """
        if common_attributes is not None:
            pulumi.set(__self__, "common_attributes", common_attributes)
        if content_encoding is not None:
            pulumi.set(__self__, "content_encoding", content_encoding)

    @property
    @pulumi.getter(name="commonAttributes")
    def common_attributes(self) -> Optional[Sequence['outputs.DeliveryStreamHttpEndpointCommonAttribute']]:
        """
        Describes the metadata sent to the HTTP endpoint destination.
        """
        return pulumi.get(self, "common_attributes")

    @property
    @pulumi.getter(name="contentEncoding")
    def content_encoding(self) -> Optional['DeliveryStreamHttpEndpointRequestConfigurationContentEncoding']:
        """
        Kinesis Data Firehose uses the content encoding to compress the body of a request before sending the request to the destination. For more information, see Content-Encoding in MDN Web Docs, the official Mozilla documentation.
        """
        return pulumi.get(self, "content_encoding")


@pulumi.output_type
class DeliveryStreamIcebergDestinationConfiguration(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "catalogConfiguration":
            suggest = "catalog_configuration"
        elif key == "roleArn":
            suggest = "role_arn"
        elif key == "s3Configuration":
            suggest = "s3_configuration"
        elif key == "appendOnly":
            suggest = "append_only"
        elif key == "bufferingHints":
            suggest = "buffering_hints"
        elif key == "cloudWatchLoggingOptions":
            suggest = "cloud_watch_logging_options"
        elif key == "destinationTableConfigurationList":
            suggest = "destination_table_configuration_list"
        elif key == "processingConfiguration":
            suggest = "processing_configuration"
        elif key == "retryOptions":
            suggest = "retry_options"
        elif key == "s3BackupMode":
            suggest = "s3_backup_mode"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in DeliveryStreamIcebergDestinationConfiguration. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        DeliveryStreamIcebergDestinationConfiguration.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        DeliveryStreamIcebergDestinationConfiguration.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 catalog_configuration: 'outputs.DeliveryStreamCatalogConfiguration',
                 role_arn: builtins.str,
                 s3_configuration: 'outputs.DeliveryStreamS3DestinationConfiguration',
                 append_only: Optional[builtins.bool] = None,
                 buffering_hints: Optional['outputs.DeliveryStreamBufferingHints'] = None,
                 cloud_watch_logging_options: Optional['outputs.DeliveryStreamCloudWatchLoggingOptions'] = None,
                 destination_table_configuration_list: Optional[Sequence['outputs.DeliveryStreamDestinationTableConfiguration']] = None,
                 processing_configuration: Optional['outputs.DeliveryStreamProcessingConfiguration'] = None,
                 retry_options: Optional['outputs.DeliveryStreamRetryOptions'] = None,
                 s3_backup_mode: Optional['DeliveryStreamIcebergDestinationConfigurations3BackupMode'] = None):
        """
        :param 'DeliveryStreamCatalogConfiguration' catalog_configuration: Configuration describing where the destination Apache Iceberg Tables are persisted.
        :param builtins.str role_arn: The Amazon Resource Name (ARN) of the IAM role to be assumed by Firehose for calling Apache Iceberg Tables.
        :param builtins.bool append_only: Describes whether all incoming data for this delivery stream will be append only (inserts only and not for updates and deletes) for Iceberg delivery. This feature is only applicable for Apache Iceberg Tables.
               
               The default value is false. If you set this value to true, Firehose automatically increases the throughput limit of a stream based on the throttling levels of the stream. If you set this parameter to true for a stream with updates and deletes, you will see out of order delivery.
        :param Sequence['DeliveryStreamDestinationTableConfiguration'] destination_table_configuration_list: Provides a list of `DestinationTableConfigurations` which Firehose uses to deliver data to Apache Iceberg Tables. Firehose will write data with insert if table specific configuration is not provided here.
        :param 'DeliveryStreamIcebergDestinationConfigurations3BackupMode' s3_backup_mode: Describes how Firehose will backup records. Currently,S3 backup only supports `FailedDataOnly` .
        """
        pulumi.set(__self__, "catalog_configuration", catalog_configuration)
        pulumi.set(__self__, "role_arn", role_arn)
        pulumi.set(__self__, "s3_configuration", s3_configuration)
        if append_only is not None:
            pulumi.set(__self__, "append_only", append_only)
        if buffering_hints is not None:
            pulumi.set(__self__, "buffering_hints", buffering_hints)
        if cloud_watch_logging_options is not None:
            pulumi.set(__self__, "cloud_watch_logging_options", cloud_watch_logging_options)
        if destination_table_configuration_list is not None:
            pulumi.set(__self__, "destination_table_configuration_list", destination_table_configuration_list)
        if processing_configuration is not None:
            pulumi.set(__self__, "processing_configuration", processing_configuration)
        if retry_options is not None:
            pulumi.set(__self__, "retry_options", retry_options)
        if s3_backup_mode is not None:
            pulumi.set(__self__, "s3_backup_mode", s3_backup_mode)

    @property
    @pulumi.getter(name="catalogConfiguration")
    def catalog_configuration(self) -> 'outputs.DeliveryStreamCatalogConfiguration':
        """
        Configuration describing where the destination Apache Iceberg Tables are persisted.
        """
        return pulumi.get(self, "catalog_configuration")

    @property
    @pulumi.getter(name="roleArn")
    def role_arn(self) -> builtins.str:
        """
        The Amazon Resource Name (ARN) of the IAM role to be assumed by Firehose for calling Apache Iceberg Tables.
        """
        return pulumi.get(self, "role_arn")

    @property
    @pulumi.getter(name="s3Configuration")
    def s3_configuration(self) -> 'outputs.DeliveryStreamS3DestinationConfiguration':
        return pulumi.get(self, "s3_configuration")

    @property
    @pulumi.getter(name="appendOnly")
    def append_only(self) -> Optional[builtins.bool]:
        """
        Describes whether all incoming data for this delivery stream will be append only (inserts only and not for updates and deletes) for Iceberg delivery. This feature is only applicable for Apache Iceberg Tables.

        The default value is false. If you set this value to true, Firehose automatically increases the throughput limit of a stream based on the throttling levels of the stream. If you set this parameter to true for a stream with updates and deletes, you will see out of order delivery.
        """
        return pulumi.get(self, "append_only")

    @property
    @pulumi.getter(name="bufferingHints")
    def buffering_hints(self) -> Optional['outputs.DeliveryStreamBufferingHints']:
        return pulumi.get(self, "buffering_hints")

    @property
    @pulumi.getter(name="cloudWatchLoggingOptions")
    def cloud_watch_logging_options(self) -> Optional['outputs.DeliveryStreamCloudWatchLoggingOptions']:
        return pulumi.get(self, "cloud_watch_logging_options")

    @property
    @pulumi.getter(name="destinationTableConfigurationList")
    def destination_table_configuration_list(self) -> Optional[Sequence['outputs.DeliveryStreamDestinationTableConfiguration']]:
        """
        Provides a list of `DestinationTableConfigurations` which Firehose uses to deliver data to Apache Iceberg Tables. Firehose will write data with insert if table specific configuration is not provided here.
        """
        return pulumi.get(self, "destination_table_configuration_list")

    @property
    @pulumi.getter(name="processingConfiguration")
    def processing_configuration(self) -> Optional['outputs.DeliveryStreamProcessingConfiguration']:
        return pulumi.get(self, "processing_configuration")

    @property
    @pulumi.getter(name="retryOptions")
    def retry_options(self) -> Optional['outputs.DeliveryStreamRetryOptions']:
        return pulumi.get(self, "retry_options")

    @property
    @pulumi.getter(name="s3BackupMode")
    def s3_backup_mode(self) -> Optional['DeliveryStreamIcebergDestinationConfigurations3BackupMode']:
        """
        Describes how Firehose will backup records. Currently,S3 backup only supports `FailedDataOnly` .
        """
        return pulumi.get(self, "s3_backup_mode")


@pulumi.output_type
class DeliveryStreamInputFormatConfiguration(dict):
    def __init__(__self__, *,
                 deserializer: Optional['outputs.DeliveryStreamDeserializer'] = None):
        """
        :param 'DeliveryStreamDeserializer' deserializer: Specifies which deserializer to use. You can choose either the Apache Hive JSON SerDe or the OpenX JSON SerDe. If both are non-null, the server rejects the request.
        """
        if deserializer is not None:
            pulumi.set(__self__, "deserializer", deserializer)

    @property
    @pulumi.getter
    def deserializer(self) -> Optional['outputs.DeliveryStreamDeserializer']:
        """
        Specifies which deserializer to use. You can choose either the Apache Hive JSON SerDe or the OpenX JSON SerDe. If both are non-null, the server rejects the request.
        """
        return pulumi.get(self, "deserializer")


@pulumi.output_type
class DeliveryStreamKinesisStreamSourceConfiguration(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "kinesisStreamArn":
            suggest = "kinesis_stream_arn"
        elif key == "roleArn":
            suggest = "role_arn"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in DeliveryStreamKinesisStreamSourceConfiguration. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        DeliveryStreamKinesisStreamSourceConfiguration.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        DeliveryStreamKinesisStreamSourceConfiguration.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 kinesis_stream_arn: builtins.str,
                 role_arn: builtins.str):
        """
        :param builtins.str kinesis_stream_arn: The ARN of the source Kinesis data stream.
        :param builtins.str role_arn: The ARN of the role that provides access to the source Kinesis data stream.
        """
        pulumi.set(__self__, "kinesis_stream_arn", kinesis_stream_arn)
        pulumi.set(__self__, "role_arn", role_arn)

    @property
    @pulumi.getter(name="kinesisStreamArn")
    def kinesis_stream_arn(self) -> builtins.str:
        """
        The ARN of the source Kinesis data stream.
        """
        return pulumi.get(self, "kinesis_stream_arn")

    @property
    @pulumi.getter(name="roleArn")
    def role_arn(self) -> builtins.str:
        """
        The ARN of the role that provides access to the source Kinesis data stream.
        """
        return pulumi.get(self, "role_arn")


@pulumi.output_type
class DeliveryStreamKmsEncryptionConfig(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "awskmsKeyArn":
            suggest = "awskms_key_arn"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in DeliveryStreamKmsEncryptionConfig. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        DeliveryStreamKmsEncryptionConfig.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        DeliveryStreamKmsEncryptionConfig.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 awskms_key_arn: builtins.str):
        """
        :param builtins.str awskms_key_arn: The Amazon Resource Name (ARN) of the AWS KMS encryption key that Amazon S3 uses to encrypt data delivered by the Kinesis Data Firehose stream. The key must belong to the same region as the destination S3 bucket.
        """
        pulumi.set(__self__, "awskms_key_arn", awskms_key_arn)

    @property
    @pulumi.getter(name="awskmsKeyArn")
    def awskms_key_arn(self) -> builtins.str:
        """
        The Amazon Resource Name (ARN) of the AWS KMS encryption key that Amazon S3 uses to encrypt data delivered by the Kinesis Data Firehose stream. The key must belong to the same region as the destination S3 bucket.
        """
        return pulumi.get(self, "awskms_key_arn")


@pulumi.output_type
class DeliveryStreamMskSourceConfiguration(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "authenticationConfiguration":
            suggest = "authentication_configuration"
        elif key == "mskClusterArn":
            suggest = "msk_cluster_arn"
        elif key == "topicName":
            suggest = "topic_name"
        elif key == "readFromTimestamp":
            suggest = "read_from_timestamp"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in DeliveryStreamMskSourceConfiguration. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        DeliveryStreamMskSourceConfiguration.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        DeliveryStreamMskSourceConfiguration.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 authentication_configuration: 'outputs.DeliveryStreamAuthenticationConfiguration',
                 msk_cluster_arn: builtins.str,
                 topic_name: builtins.str,
                 read_from_timestamp: Optional[builtins.str] = None):
        """
        :param 'DeliveryStreamAuthenticationConfiguration' authentication_configuration: The authentication configuration of the Amazon MSK cluster.
        :param builtins.str msk_cluster_arn: The ARN of the Amazon MSK cluster.
        :param builtins.str topic_name: The topic name within the Amazon MSK cluster.
        :param builtins.str read_from_timestamp: The start date and time in UTC for the offset position within your MSK topic from where Firehose begins to read. By default, this is set to timestamp when Firehose becomes Active.
               
               If you want to create a Firehose stream with Earliest start position from SDK or CLI, you need to set the `ReadFromTimestamp` parameter to Epoch (1970-01-01T00:00:00Z).
        """
        pulumi.set(__self__, "authentication_configuration", authentication_configuration)
        pulumi.set(__self__, "msk_cluster_arn", msk_cluster_arn)
        pulumi.set(__self__, "topic_name", topic_name)
        if read_from_timestamp is not None:
            pulumi.set(__self__, "read_from_timestamp", read_from_timestamp)

    @property
    @pulumi.getter(name="authenticationConfiguration")
    def authentication_configuration(self) -> 'outputs.DeliveryStreamAuthenticationConfiguration':
        """
        The authentication configuration of the Amazon MSK cluster.
        """
        return pulumi.get(self, "authentication_configuration")

    @property
    @pulumi.getter(name="mskClusterArn")
    def msk_cluster_arn(self) -> builtins.str:
        """
        The ARN of the Amazon MSK cluster.
        """
        return pulumi.get(self, "msk_cluster_arn")

    @property
    @pulumi.getter(name="topicName")
    def topic_name(self) -> builtins.str:
        """
        The topic name within the Amazon MSK cluster.
        """
        return pulumi.get(self, "topic_name")

    @property
    @pulumi.getter(name="readFromTimestamp")
    def read_from_timestamp(self) -> Optional[builtins.str]:
        """
        The start date and time in UTC for the offset position within your MSK topic from where Firehose begins to read. By default, this is set to timestamp when Firehose becomes Active.

        If you want to create a Firehose stream with Earliest start position from SDK or CLI, you need to set the `ReadFromTimestamp` parameter to Epoch (1970-01-01T00:00:00Z).
        """
        return pulumi.get(self, "read_from_timestamp")


@pulumi.output_type
class DeliveryStreamOpenXJsonSerDe(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "caseInsensitive":
            suggest = "case_insensitive"
        elif key == "columnToJsonKeyMappings":
            suggest = "column_to_json_key_mappings"
        elif key == "convertDotsInJsonKeysToUnderscores":
            suggest = "convert_dots_in_json_keys_to_underscores"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in DeliveryStreamOpenXJsonSerDe. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        DeliveryStreamOpenXJsonSerDe.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        DeliveryStreamOpenXJsonSerDe.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 case_insensitive: Optional[builtins.bool] = None,
                 column_to_json_key_mappings: Optional[Mapping[str, builtins.str]] = None,
                 convert_dots_in_json_keys_to_underscores: Optional[builtins.bool] = None):
        """
        :param builtins.bool case_insensitive: When set to `true` , which is the default, Firehose converts JSON keys to lowercase before deserializing them.
        :param Mapping[str, builtins.str] column_to_json_key_mappings: Maps column names to JSON keys that aren't identical to the column names. This is useful when the JSON contains keys that are Hive keywords. For example, `timestamp` is a Hive keyword. If you have a JSON key named `timestamp` , set this parameter to `{"ts": "timestamp"}` to map this key to a column named `ts` .
        :param builtins.bool convert_dots_in_json_keys_to_underscores: When set to `true` , specifies that the names of the keys include dots and that you want Firehose to replace them with underscores. This is useful because Apache Hive does not allow dots in column names. For example, if the JSON contains a key whose name is "a.b", you can define the column name to be "a_b" when using this option.
               
               The default is `false` .
        """
        if case_insensitive is not None:
            pulumi.set(__self__, "case_insensitive", case_insensitive)
        if column_to_json_key_mappings is not None:
            pulumi.set(__self__, "column_to_json_key_mappings", column_to_json_key_mappings)
        if convert_dots_in_json_keys_to_underscores is not None:
            pulumi.set(__self__, "convert_dots_in_json_keys_to_underscores", convert_dots_in_json_keys_to_underscores)

    @property
    @pulumi.getter(name="caseInsensitive")
    def case_insensitive(self) -> Optional[builtins.bool]:
        """
        When set to `true` , which is the default, Firehose converts JSON keys to lowercase before deserializing them.
        """
        return pulumi.get(self, "case_insensitive")

    @property
    @pulumi.getter(name="columnToJsonKeyMappings")
    def column_to_json_key_mappings(self) -> Optional[Mapping[str, builtins.str]]:
        """
        Maps column names to JSON keys that aren't identical to the column names. This is useful when the JSON contains keys that are Hive keywords. For example, `timestamp` is a Hive keyword. If you have a JSON key named `timestamp` , set this parameter to `{"ts": "timestamp"}` to map this key to a column named `ts` .
        """
        return pulumi.get(self, "column_to_json_key_mappings")

    @property
    @pulumi.getter(name="convertDotsInJsonKeysToUnderscores")
    def convert_dots_in_json_keys_to_underscores(self) -> Optional[builtins.bool]:
        """
        When set to `true` , specifies that the names of the keys include dots and that you want Firehose to replace them with underscores. This is useful because Apache Hive does not allow dots in column names. For example, if the JSON contains a key whose name is "a.b", you can define the column name to be "a_b" when using this option.

        The default is `false` .
        """
        return pulumi.get(self, "convert_dots_in_json_keys_to_underscores")


@pulumi.output_type
class DeliveryStreamOrcSerDe(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "blockSizeBytes":
            suggest = "block_size_bytes"
        elif key == "bloomFilterColumns":
            suggest = "bloom_filter_columns"
        elif key == "bloomFilterFalsePositiveProbability":
            suggest = "bloom_filter_false_positive_probability"
        elif key == "dictionaryKeyThreshold":
            suggest = "dictionary_key_threshold"
        elif key == "enablePadding":
            suggest = "enable_padding"
        elif key == "formatVersion":
            suggest = "format_version"
        elif key == "paddingTolerance":
            suggest = "padding_tolerance"
        elif key == "rowIndexStride":
            suggest = "row_index_stride"
        elif key == "stripeSizeBytes":
            suggest = "stripe_size_bytes"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in DeliveryStreamOrcSerDe. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        DeliveryStreamOrcSerDe.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        DeliveryStreamOrcSerDe.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 block_size_bytes: Optional[builtins.int] = None,
                 bloom_filter_columns: Optional[Sequence[builtins.str]] = None,
                 bloom_filter_false_positive_probability: Optional[builtins.float] = None,
                 compression: Optional[builtins.str] = None,
                 dictionary_key_threshold: Optional[builtins.float] = None,
                 enable_padding: Optional[builtins.bool] = None,
                 format_version: Optional[builtins.str] = None,
                 padding_tolerance: Optional[builtins.float] = None,
                 row_index_stride: Optional[builtins.int] = None,
                 stripe_size_bytes: Optional[builtins.int] = None):
        """
        :param builtins.int block_size_bytes: The Hadoop Distributed File System (HDFS) block size. This is useful if you intend to copy the data from Amazon S3 to HDFS before querying. The default is 256 MiB and the minimum is 64 MiB. Firehose uses this value for padding calculations.
        :param Sequence[builtins.str] bloom_filter_columns: The column names for which you want Firehose to create bloom filters. The default is `null` .
        :param builtins.float bloom_filter_false_positive_probability: The Bloom filter false positive probability (FPP). The lower the FPP, the bigger the Bloom filter. The default value is 0.05, the minimum is 0, and the maximum is 1.
        :param builtins.str compression: The compression code to use over data blocks. The default is `SNAPPY` .
        :param builtins.float dictionary_key_threshold: Represents the fraction of the total number of non-null rows. To turn off dictionary encoding, set this fraction to a number that is less than the number of distinct keys in a dictionary. To always use dictionary encoding, set this threshold to 1.
        :param builtins.bool enable_padding: Set this to `true` to indicate that you want stripes to be padded to the HDFS block boundaries. This is useful if you intend to copy the data from Amazon S3 to HDFS before querying. The default is `false` .
        :param builtins.str format_version: The version of the file to write. The possible values are `V0_11` and `V0_12` . The default is `V0_12` .
        :param builtins.float padding_tolerance: A number between 0 and 1 that defines the tolerance for block padding as a decimal fraction of stripe size. The default value is 0.05, which means 5 percent of stripe size.
               
               For the default values of 64 MiB ORC stripes and 256 MiB HDFS blocks, the default block padding tolerance of 5 percent reserves a maximum of 3.2 MiB for padding within the 256 MiB block. In such a case, if the available size within the block is more than 3.2 MiB, a new, smaller stripe is inserted to fit within that space. This ensures that no stripe crosses block boundaries and causes remote reads within a node-local task.
               
               Kinesis Data Firehose ignores this parameter when `EnablePadding` is `false` .
        :param builtins.int row_index_stride: The number of rows between index entries. The default is 10,000 and the minimum is 1,000.
        :param builtins.int stripe_size_bytes: The number of bytes in each stripe. The default is 64 MiB and the minimum is 8 MiB.
        """
        if block_size_bytes is not None:
            pulumi.set(__self__, "block_size_bytes", block_size_bytes)
        if bloom_filter_columns is not None:
            pulumi.set(__self__, "bloom_filter_columns", bloom_filter_columns)
        if bloom_filter_false_positive_probability is not None:
            pulumi.set(__self__, "bloom_filter_false_positive_probability", bloom_filter_false_positive_probability)
        if compression is not None:
            pulumi.set(__self__, "compression", compression)
        if dictionary_key_threshold is not None:
            pulumi.set(__self__, "dictionary_key_threshold", dictionary_key_threshold)
        if enable_padding is not None:
            pulumi.set(__self__, "enable_padding", enable_padding)
        if format_version is not None:
            pulumi.set(__self__, "format_version", format_version)
        if padding_tolerance is not None:
            pulumi.set(__self__, "padding_tolerance", padding_tolerance)
        if row_index_stride is not None:
            pulumi.set(__self__, "row_index_stride", row_index_stride)
        if stripe_size_bytes is not None:
            pulumi.set(__self__, "stripe_size_bytes", stripe_size_bytes)

    @property
    @pulumi.getter(name="blockSizeBytes")
    def block_size_bytes(self) -> Optional[builtins.int]:
        """
        The Hadoop Distributed File System (HDFS) block size. This is useful if you intend to copy the data from Amazon S3 to HDFS before querying. The default is 256 MiB and the minimum is 64 MiB. Firehose uses this value for padding calculations.
        """
        return pulumi.get(self, "block_size_bytes")

    @property
    @pulumi.getter(name="bloomFilterColumns")
    def bloom_filter_columns(self) -> Optional[Sequence[builtins.str]]:
        """
        The column names for which you want Firehose to create bloom filters. The default is `null` .
        """
        return pulumi.get(self, "bloom_filter_columns")

    @property
    @pulumi.getter(name="bloomFilterFalsePositiveProbability")
    def bloom_filter_false_positive_probability(self) -> Optional[builtins.float]:
        """
        The Bloom filter false positive probability (FPP). The lower the FPP, the bigger the Bloom filter. The default value is 0.05, the minimum is 0, and the maximum is 1.
        """
        return pulumi.get(self, "bloom_filter_false_positive_probability")

    @property
    @pulumi.getter
    def compression(self) -> Optional[builtins.str]:
        """
        The compression code to use over data blocks. The default is `SNAPPY` .
        """
        return pulumi.get(self, "compression")

    @property
    @pulumi.getter(name="dictionaryKeyThreshold")
    def dictionary_key_threshold(self) -> Optional[builtins.float]:
        """
        Represents the fraction of the total number of non-null rows. To turn off dictionary encoding, set this fraction to a number that is less than the number of distinct keys in a dictionary. To always use dictionary encoding, set this threshold to 1.
        """
        return pulumi.get(self, "dictionary_key_threshold")

    @property
    @pulumi.getter(name="enablePadding")
    def enable_padding(self) -> Optional[builtins.bool]:
        """
        Set this to `true` to indicate that you want stripes to be padded to the HDFS block boundaries. This is useful if you intend to copy the data from Amazon S3 to HDFS before querying. The default is `false` .
        """
        return pulumi.get(self, "enable_padding")

    @property
    @pulumi.getter(name="formatVersion")
    def format_version(self) -> Optional[builtins.str]:
        """
        The version of the file to write. The possible values are `V0_11` and `V0_12` . The default is `V0_12` .
        """
        return pulumi.get(self, "format_version")

    @property
    @pulumi.getter(name="paddingTolerance")
    def padding_tolerance(self) -> Optional[builtins.float]:
        """
        A number between 0 and 1 that defines the tolerance for block padding as a decimal fraction of stripe size. The default value is 0.05, which means 5 percent of stripe size.

        For the default values of 64 MiB ORC stripes and 256 MiB HDFS blocks, the default block padding tolerance of 5 percent reserves a maximum of 3.2 MiB for padding within the 256 MiB block. In such a case, if the available size within the block is more than 3.2 MiB, a new, smaller stripe is inserted to fit within that space. This ensures that no stripe crosses block boundaries and causes remote reads within a node-local task.

        Kinesis Data Firehose ignores this parameter when `EnablePadding` is `false` .
        """
        return pulumi.get(self, "padding_tolerance")

    @property
    @pulumi.getter(name="rowIndexStride")
    def row_index_stride(self) -> Optional[builtins.int]:
        """
        The number of rows between index entries. The default is 10,000 and the minimum is 1,000.
        """
        return pulumi.get(self, "row_index_stride")

    @property
    @pulumi.getter(name="stripeSizeBytes")
    def stripe_size_bytes(self) -> Optional[builtins.int]:
        """
        The number of bytes in each stripe. The default is 64 MiB and the minimum is 8 MiB.
        """
        return pulumi.get(self, "stripe_size_bytes")


@pulumi.output_type
class DeliveryStreamOutputFormatConfiguration(dict):
    def __init__(__self__, *,
                 serializer: Optional['outputs.DeliveryStreamSerializer'] = None):
        """
        :param 'DeliveryStreamSerializer' serializer: Specifies which serializer to use. You can choose either the ORC SerDe or the Parquet SerDe. If both are non-null, the server rejects the request.
        """
        if serializer is not None:
            pulumi.set(__self__, "serializer", serializer)

    @property
    @pulumi.getter
    def serializer(self) -> Optional['outputs.DeliveryStreamSerializer']:
        """
        Specifies which serializer to use. You can choose either the ORC SerDe or the Parquet SerDe. If both are non-null, the server rejects the request.
        """
        return pulumi.get(self, "serializer")


@pulumi.output_type
class DeliveryStreamParquetSerDe(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "blockSizeBytes":
            suggest = "block_size_bytes"
        elif key == "enableDictionaryCompression":
            suggest = "enable_dictionary_compression"
        elif key == "maxPaddingBytes":
            suggest = "max_padding_bytes"
        elif key == "pageSizeBytes":
            suggest = "page_size_bytes"
        elif key == "writerVersion":
            suggest = "writer_version"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in DeliveryStreamParquetSerDe. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        DeliveryStreamParquetSerDe.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        DeliveryStreamParquetSerDe.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 block_size_bytes: Optional[builtins.int] = None,
                 compression: Optional[builtins.str] = None,
                 enable_dictionary_compression: Optional[builtins.bool] = None,
                 max_padding_bytes: Optional[builtins.int] = None,
                 page_size_bytes: Optional[builtins.int] = None,
                 writer_version: Optional[builtins.str] = None):
        """
        :param builtins.int block_size_bytes: The Hadoop Distributed File System (HDFS) block size. This is useful if you intend to copy the data from Amazon S3 to HDFS before querying. The default is 256 MiB and the minimum is 64 MiB. Firehose uses this value for padding calculations.
        :param builtins.str compression: The compression code to use over data blocks. The possible values are `UNCOMPRESSED` , `SNAPPY` , and `GZIP` , with the default being `SNAPPY` . Use `SNAPPY` for higher decompression speed. Use `GZIP` if the compression ratio is more important than speed.
        :param builtins.bool enable_dictionary_compression: Indicates whether to enable dictionary compression.
        :param builtins.int max_padding_bytes: The maximum amount of padding to apply. This is useful if you intend to copy the data from Amazon S3 to HDFS before querying. The default is 0.
        :param builtins.int page_size_bytes: The Parquet page size. Column chunks are divided into pages. A page is conceptually an indivisible unit (in terms of compression and encoding). The minimum value is 64 KiB and the default is 1 MiB.
        :param builtins.str writer_version: Indicates the version of row format to output. The possible values are `V1` and `V2` . The default is `V1` .
        """
        if block_size_bytes is not None:
            pulumi.set(__self__, "block_size_bytes", block_size_bytes)
        if compression is not None:
            pulumi.set(__self__, "compression", compression)
        if enable_dictionary_compression is not None:
            pulumi.set(__self__, "enable_dictionary_compression", enable_dictionary_compression)
        if max_padding_bytes is not None:
            pulumi.set(__self__, "max_padding_bytes", max_padding_bytes)
        if page_size_bytes is not None:
            pulumi.set(__self__, "page_size_bytes", page_size_bytes)
        if writer_version is not None:
            pulumi.set(__self__, "writer_version", writer_version)

    @property
    @pulumi.getter(name="blockSizeBytes")
    def block_size_bytes(self) -> Optional[builtins.int]:
        """
        The Hadoop Distributed File System (HDFS) block size. This is useful if you intend to copy the data from Amazon S3 to HDFS before querying. The default is 256 MiB and the minimum is 64 MiB. Firehose uses this value for padding calculations.
        """
        return pulumi.get(self, "block_size_bytes")

    @property
    @pulumi.getter
    def compression(self) -> Optional[builtins.str]:
        """
        The compression code to use over data blocks. The possible values are `UNCOMPRESSED` , `SNAPPY` , and `GZIP` , with the default being `SNAPPY` . Use `SNAPPY` for higher decompression speed. Use `GZIP` if the compression ratio is more important than speed.
        """
        return pulumi.get(self, "compression")

    @property
    @pulumi.getter(name="enableDictionaryCompression")
    def enable_dictionary_compression(self) -> Optional[builtins.bool]:
        """
        Indicates whether to enable dictionary compression.
        """
        return pulumi.get(self, "enable_dictionary_compression")

    @property
    @pulumi.getter(name="maxPaddingBytes")
    def max_padding_bytes(self) -> Optional[builtins.int]:
        """
        The maximum amount of padding to apply. This is useful if you intend to copy the data from Amazon S3 to HDFS before querying. The default is 0.
        """
        return pulumi.get(self, "max_padding_bytes")

    @property
    @pulumi.getter(name="pageSizeBytes")
    def page_size_bytes(self) -> Optional[builtins.int]:
        """
        The Parquet page size. Column chunks are divided into pages. A page is conceptually an indivisible unit (in terms of compression and encoding). The minimum value is 64 KiB and the default is 1 MiB.
        """
        return pulumi.get(self, "page_size_bytes")

    @property
    @pulumi.getter(name="writerVersion")
    def writer_version(self) -> Optional[builtins.str]:
        """
        Indicates the version of row format to output. The possible values are `V1` and `V2` . The default is `V1` .
        """
        return pulumi.get(self, "writer_version")


@pulumi.output_type
class DeliveryStreamProcessingConfiguration(dict):
    def __init__(__self__, *,
                 enabled: Optional[builtins.bool] = None,
                 processors: Optional[Sequence['outputs.DeliveryStreamProcessor']] = None):
        """
        :param builtins.bool enabled: Indicates whether data processing is enabled (true) or disabled (false).
        :param Sequence['DeliveryStreamProcessor'] processors: The data processors.
        """
        if enabled is not None:
            pulumi.set(__self__, "enabled", enabled)
        if processors is not None:
            pulumi.set(__self__, "processors", processors)

    @property
    @pulumi.getter
    def enabled(self) -> Optional[builtins.bool]:
        """
        Indicates whether data processing is enabled (true) or disabled (false).
        """
        return pulumi.get(self, "enabled")

    @property
    @pulumi.getter
    def processors(self) -> Optional[Sequence['outputs.DeliveryStreamProcessor']]:
        """
        The data processors.
        """
        return pulumi.get(self, "processors")


@pulumi.output_type
class DeliveryStreamProcessor(dict):
    def __init__(__self__, *,
                 type: 'DeliveryStreamProcessorType',
                 parameters: Optional[Sequence['outputs.DeliveryStreamProcessorParameter']] = None):
        """
        :param 'DeliveryStreamProcessorType' type: The type of processor. Valid values: `Lambda` .
        :param Sequence['DeliveryStreamProcessorParameter'] parameters: The processor parameters.
        """
        pulumi.set(__self__, "type", type)
        if parameters is not None:
            pulumi.set(__self__, "parameters", parameters)

    @property
    @pulumi.getter
    def type(self) -> 'DeliveryStreamProcessorType':
        """
        The type of processor. Valid values: `Lambda` .
        """
        return pulumi.get(self, "type")

    @property
    @pulumi.getter
    def parameters(self) -> Optional[Sequence['outputs.DeliveryStreamProcessorParameter']]:
        """
        The processor parameters.
        """
        return pulumi.get(self, "parameters")


@pulumi.output_type
class DeliveryStreamProcessorParameter(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "parameterName":
            suggest = "parameter_name"
        elif key == "parameterValue":
            suggest = "parameter_value"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in DeliveryStreamProcessorParameter. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        DeliveryStreamProcessorParameter.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        DeliveryStreamProcessorParameter.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 parameter_name: builtins.str,
                 parameter_value: builtins.str):
        """
        :param builtins.str parameter_name: The name of the parameter. Currently the following default values are supported: 3 for `NumberOfRetries` and 60 for the `BufferIntervalInSeconds` . The `BufferSizeInMBs` ranges between 0.2 MB and up to 3MB. The default buffering hint is 1MB for all destinations, except Splunk. For Splunk, the default buffering hint is 256 KB.
        :param builtins.str parameter_value: The parameter value.
        """
        pulumi.set(__self__, "parameter_name", parameter_name)
        pulumi.set(__self__, "parameter_value", parameter_value)

    @property
    @pulumi.getter(name="parameterName")
    def parameter_name(self) -> builtins.str:
        """
        The name of the parameter. Currently the following default values are supported: 3 for `NumberOfRetries` and 60 for the `BufferIntervalInSeconds` . The `BufferSizeInMBs` ranges between 0.2 MB and up to 3MB. The default buffering hint is 1MB for all destinations, except Splunk. For Splunk, the default buffering hint is 256 KB.
        """
        return pulumi.get(self, "parameter_name")

    @property
    @pulumi.getter(name="parameterValue")
    def parameter_value(self) -> builtins.str:
        """
        The parameter value.
        """
        return pulumi.get(self, "parameter_value")


@pulumi.output_type
class DeliveryStreamRedshiftDestinationConfiguration(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "clusterJdbcurl":
            suggest = "cluster_jdbcurl"
        elif key == "copyCommand":
            suggest = "copy_command"
        elif key == "roleArn":
            suggest = "role_arn"
        elif key == "s3Configuration":
            suggest = "s3_configuration"
        elif key == "cloudWatchLoggingOptions":
            suggest = "cloud_watch_logging_options"
        elif key == "processingConfiguration":
            suggest = "processing_configuration"
        elif key == "retryOptions":
            suggest = "retry_options"
        elif key == "s3BackupConfiguration":
            suggest = "s3_backup_configuration"
        elif key == "s3BackupMode":
            suggest = "s3_backup_mode"
        elif key == "secretsManagerConfiguration":
            suggest = "secrets_manager_configuration"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in DeliveryStreamRedshiftDestinationConfiguration. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        DeliveryStreamRedshiftDestinationConfiguration.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        DeliveryStreamRedshiftDestinationConfiguration.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 cluster_jdbcurl: builtins.str,
                 copy_command: 'outputs.DeliveryStreamCopyCommand',
                 role_arn: builtins.str,
                 s3_configuration: 'outputs.DeliveryStreamS3DestinationConfiguration',
                 cloud_watch_logging_options: Optional['outputs.DeliveryStreamCloudWatchLoggingOptions'] = None,
                 password: Optional[builtins.str] = None,
                 processing_configuration: Optional['outputs.DeliveryStreamProcessingConfiguration'] = None,
                 retry_options: Optional['outputs.DeliveryStreamRedshiftRetryOptions'] = None,
                 s3_backup_configuration: Optional['outputs.DeliveryStreamS3DestinationConfiguration'] = None,
                 s3_backup_mode: Optional['DeliveryStreamRedshiftDestinationConfigurationS3BackupMode'] = None,
                 secrets_manager_configuration: Optional['outputs.DeliveryStreamSecretsManagerConfiguration'] = None,
                 username: Optional[builtins.str] = None):
        """
        :param builtins.str cluster_jdbcurl: The connection string that Kinesis Data Firehose uses to connect to the Amazon Redshift cluster.
        :param 'DeliveryStreamCopyCommand' copy_command: Configures the Amazon Redshift `COPY` command that Kinesis Data Firehose uses to load data into the cluster from the Amazon S3 bucket.
        :param builtins.str role_arn: The ARN of the AWS Identity and Access Management (IAM) role that grants Kinesis Data Firehose access to your Amazon S3 bucket and AWS KMS (if you enable data encryption). For more information, see [Grant Kinesis Data Firehose Access to an Amazon Redshift Destination](https://docs.aws.amazon.com/firehose/latest/dev/controlling-access.html#using-iam-rs) in the *Amazon Kinesis Data Firehose Developer Guide* .
        :param 'DeliveryStreamS3DestinationConfiguration' s3_configuration: The S3 bucket where Kinesis Data Firehose first delivers data. After the data is in the bucket, Kinesis Data Firehose uses the `COPY` command to load the data into the Amazon Redshift cluster. For the Amazon S3 bucket's compression format, don't specify `SNAPPY` or `ZIP` because the Amazon Redshift `COPY` command doesn't support them.
        :param 'DeliveryStreamCloudWatchLoggingOptions' cloud_watch_logging_options: The CloudWatch logging options for your Firehose stream.
        :param builtins.str password: The password for the Amazon Redshift user that you specified in the `Username` property.
        :param 'DeliveryStreamProcessingConfiguration' processing_configuration: The data processing configuration for the Kinesis Data Firehose delivery stream.
        :param 'DeliveryStreamRedshiftRetryOptions' retry_options: The retry behavior in case Firehose is unable to deliver documents to Amazon Redshift. Default value is 3600 (60 minutes).
        :param 'DeliveryStreamS3DestinationConfiguration' s3_backup_configuration: The configuration for backup in Amazon S3.
        :param 'DeliveryStreamRedshiftDestinationConfigurationS3BackupMode' s3_backup_mode: The Amazon S3 backup mode. After you create a Firehose stream, you can update it to enable Amazon S3 backup if it is disabled. If backup is enabled, you can't update the Firehose stream to disable it.
        :param 'DeliveryStreamSecretsManagerConfiguration' secrets_manager_configuration: The configuration that defines how you access secrets for Amazon Redshift.
        :param builtins.str username: The Amazon Redshift user that has permission to access the Amazon Redshift cluster. This user must have `INSERT` privileges for copying data from the Amazon S3 bucket to the cluster.
        """
        pulumi.set(__self__, "cluster_jdbcurl", cluster_jdbcurl)
        pulumi.set(__self__, "copy_command", copy_command)
        pulumi.set(__self__, "role_arn", role_arn)
        pulumi.set(__self__, "s3_configuration", s3_configuration)
        if cloud_watch_logging_options is not None:
            pulumi.set(__self__, "cloud_watch_logging_options", cloud_watch_logging_options)
        if password is not None:
            pulumi.set(__self__, "password", password)
        if processing_configuration is not None:
            pulumi.set(__self__, "processing_configuration", processing_configuration)
        if retry_options is not None:
            pulumi.set(__self__, "retry_options", retry_options)
        if s3_backup_configuration is not None:
            pulumi.set(__self__, "s3_backup_configuration", s3_backup_configuration)
        if s3_backup_mode is not None:
            pulumi.set(__self__, "s3_backup_mode", s3_backup_mode)
        if secrets_manager_configuration is not None:
            pulumi.set(__self__, "secrets_manager_configuration", secrets_manager_configuration)
        if username is not None:
            pulumi.set(__self__, "username", username)

    @property
    @pulumi.getter(name="clusterJdbcurl")
    def cluster_jdbcurl(self) -> builtins.str:
        """
        The connection string that Kinesis Data Firehose uses to connect to the Amazon Redshift cluster.
        """
        return pulumi.get(self, "cluster_jdbcurl")

    @property
    @pulumi.getter(name="copyCommand")
    def copy_command(self) -> 'outputs.DeliveryStreamCopyCommand':
        """
        Configures the Amazon Redshift `COPY` command that Kinesis Data Firehose uses to load data into the cluster from the Amazon S3 bucket.
        """
        return pulumi.get(self, "copy_command")

    @property
    @pulumi.getter(name="roleArn")
    def role_arn(self) -> builtins.str:
        """
        The ARN of the AWS Identity and Access Management (IAM) role that grants Kinesis Data Firehose access to your Amazon S3 bucket and AWS KMS (if you enable data encryption). For more information, see [Grant Kinesis Data Firehose Access to an Amazon Redshift Destination](https://docs.aws.amazon.com/firehose/latest/dev/controlling-access.html#using-iam-rs) in the *Amazon Kinesis Data Firehose Developer Guide* .
        """
        return pulumi.get(self, "role_arn")

    @property
    @pulumi.getter(name="s3Configuration")
    def s3_configuration(self) -> 'outputs.DeliveryStreamS3DestinationConfiguration':
        """
        The S3 bucket where Kinesis Data Firehose first delivers data. After the data is in the bucket, Kinesis Data Firehose uses the `COPY` command to load the data into the Amazon Redshift cluster. For the Amazon S3 bucket's compression format, don't specify `SNAPPY` or `ZIP` because the Amazon Redshift `COPY` command doesn't support them.
        """
        return pulumi.get(self, "s3_configuration")

    @property
    @pulumi.getter(name="cloudWatchLoggingOptions")
    def cloud_watch_logging_options(self) -> Optional['outputs.DeliveryStreamCloudWatchLoggingOptions']:
        """
        The CloudWatch logging options for your Firehose stream.
        """
        return pulumi.get(self, "cloud_watch_logging_options")

    @property
    @pulumi.getter
    def password(self) -> Optional[builtins.str]:
        """
        The password for the Amazon Redshift user that you specified in the `Username` property.
        """
        return pulumi.get(self, "password")

    @property
    @pulumi.getter(name="processingConfiguration")
    def processing_configuration(self) -> Optional['outputs.DeliveryStreamProcessingConfiguration']:
        """
        The data processing configuration for the Kinesis Data Firehose delivery stream.
        """
        return pulumi.get(self, "processing_configuration")

    @property
    @pulumi.getter(name="retryOptions")
    def retry_options(self) -> Optional['outputs.DeliveryStreamRedshiftRetryOptions']:
        """
        The retry behavior in case Firehose is unable to deliver documents to Amazon Redshift. Default value is 3600 (60 minutes).
        """
        return pulumi.get(self, "retry_options")

    @property
    @pulumi.getter(name="s3BackupConfiguration")
    def s3_backup_configuration(self) -> Optional['outputs.DeliveryStreamS3DestinationConfiguration']:
        """
        The configuration for backup in Amazon S3.
        """
        return pulumi.get(self, "s3_backup_configuration")

    @property
    @pulumi.getter(name="s3BackupMode")
    def s3_backup_mode(self) -> Optional['DeliveryStreamRedshiftDestinationConfigurationS3BackupMode']:
        """
        The Amazon S3 backup mode. After you create a Firehose stream, you can update it to enable Amazon S3 backup if it is disabled. If backup is enabled, you can't update the Firehose stream to disable it.
        """
        return pulumi.get(self, "s3_backup_mode")

    @property
    @pulumi.getter(name="secretsManagerConfiguration")
    def secrets_manager_configuration(self) -> Optional['outputs.DeliveryStreamSecretsManagerConfiguration']:
        """
        The configuration that defines how you access secrets for Amazon Redshift.
        """
        return pulumi.get(self, "secrets_manager_configuration")

    @property
    @pulumi.getter
    def username(self) -> Optional[builtins.str]:
        """
        The Amazon Redshift user that has permission to access the Amazon Redshift cluster. This user must have `INSERT` privileges for copying data from the Amazon S3 bucket to the cluster.
        """
        return pulumi.get(self, "username")


@pulumi.output_type
class DeliveryStreamRedshiftRetryOptions(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "durationInSeconds":
            suggest = "duration_in_seconds"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in DeliveryStreamRedshiftRetryOptions. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        DeliveryStreamRedshiftRetryOptions.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        DeliveryStreamRedshiftRetryOptions.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 duration_in_seconds: Optional[builtins.int] = None):
        """
        :param builtins.int duration_in_seconds: The length of time during which Firehose retries delivery after a failure, starting from the initial request and including the first attempt. The default value is 3600 seconds (60 minutes). Firehose does not retry if the value of `DurationInSeconds` is 0 (zero) or if the first delivery attempt takes longer than the current value.
        """
        if duration_in_seconds is not None:
            pulumi.set(__self__, "duration_in_seconds", duration_in_seconds)

    @property
    @pulumi.getter(name="durationInSeconds")
    def duration_in_seconds(self) -> Optional[builtins.int]:
        """
        The length of time during which Firehose retries delivery after a failure, starting from the initial request and including the first attempt. The default value is 3600 seconds (60 minutes). Firehose does not retry if the value of `DurationInSeconds` is 0 (zero) or if the first delivery attempt takes longer than the current value.
        """
        return pulumi.get(self, "duration_in_seconds")


@pulumi.output_type
class DeliveryStreamRetryOptions(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "durationInSeconds":
            suggest = "duration_in_seconds"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in DeliveryStreamRetryOptions. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        DeliveryStreamRetryOptions.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        DeliveryStreamRetryOptions.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 duration_in_seconds: Optional[builtins.int] = None):
        """
        :param builtins.int duration_in_seconds: The total amount of time that Kinesis Data Firehose spends on retries. This duration starts after the initial attempt to send data to the custom destination via HTTPS endpoint fails. It doesn't include the periods during which Kinesis Data Firehose waits for acknowledgment from the specified destination after each attempt.
        """
        if duration_in_seconds is not None:
            pulumi.set(__self__, "duration_in_seconds", duration_in_seconds)

    @property
    @pulumi.getter(name="durationInSeconds")
    def duration_in_seconds(self) -> Optional[builtins.int]:
        """
        The total amount of time that Kinesis Data Firehose spends on retries. This duration starts after the initial attempt to send data to the custom destination via HTTPS endpoint fails. It doesn't include the periods during which Kinesis Data Firehose waits for acknowledgment from the specified destination after each attempt.
        """
        return pulumi.get(self, "duration_in_seconds")


@pulumi.output_type
class DeliveryStreamS3DestinationConfiguration(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "bucketArn":
            suggest = "bucket_arn"
        elif key == "roleArn":
            suggest = "role_arn"
        elif key == "bufferingHints":
            suggest = "buffering_hints"
        elif key == "cloudWatchLoggingOptions":
            suggest = "cloud_watch_logging_options"
        elif key == "compressionFormat":
            suggest = "compression_format"
        elif key == "encryptionConfiguration":
            suggest = "encryption_configuration"
        elif key == "errorOutputPrefix":
            suggest = "error_output_prefix"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in DeliveryStreamS3DestinationConfiguration. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        DeliveryStreamS3DestinationConfiguration.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        DeliveryStreamS3DestinationConfiguration.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 bucket_arn: builtins.str,
                 role_arn: builtins.str,
                 buffering_hints: Optional['outputs.DeliveryStreamBufferingHints'] = None,
                 cloud_watch_logging_options: Optional['outputs.DeliveryStreamCloudWatchLoggingOptions'] = None,
                 compression_format: Optional['DeliveryStreamS3DestinationConfigurationCompressionFormat'] = None,
                 encryption_configuration: Optional['outputs.DeliveryStreamEncryptionConfiguration'] = None,
                 error_output_prefix: Optional[builtins.str] = None,
                 prefix: Optional[builtins.str] = None):
        """
        :param builtins.str bucket_arn: The Amazon Resource Name (ARN) of the Amazon S3 bucket to send data to.
        :param builtins.str role_arn: The ARN of an AWS Identity and Access Management (IAM) role that grants Kinesis Data Firehose access to your Amazon S3 bucket and AWS KMS (if you enable data encryption). For more information, see [Grant Kinesis Data Firehose Access to an Amazon S3 Destination](https://docs.aws.amazon.com/firehose/latest/dev/controlling-access.html#using-iam-s3) in the *Amazon Kinesis Data Firehose Developer Guide* .
        :param 'DeliveryStreamBufferingHints' buffering_hints: Configures how Kinesis Data Firehose buffers incoming data while delivering it to the Amazon S3 bucket.
        :param 'DeliveryStreamCloudWatchLoggingOptions' cloud_watch_logging_options: The CloudWatch logging options for your Firehose stream.
        :param 'DeliveryStreamS3DestinationConfigurationCompressionFormat' compression_format: The type of compression that Kinesis Data Firehose uses to compress the data that it delivers to the Amazon S3 bucket. For valid values, see the `CompressionFormat` content for the [S3DestinationConfiguration](https://docs.aws.amazon.com/firehose/latest/APIReference/API_S3DestinationConfiguration.html) data type in the *Amazon Kinesis Data Firehose API Reference* .
        :param 'DeliveryStreamEncryptionConfiguration' encryption_configuration: Configures Amazon Simple Storage Service (Amazon S3) server-side encryption. Kinesis Data Firehose uses AWS Key Management Service ( AWS KMS) to encrypt the data that it delivers to your Amazon S3 bucket.
        :param builtins.str error_output_prefix: A prefix that Kinesis Data Firehose evaluates and adds to failed records before writing them to S3. This prefix appears immediately following the bucket name. For information about how to specify this prefix, see [Custom Prefixes for Amazon S3 Objects](https://docs.aws.amazon.com/firehose/latest/dev/s3-prefixes.html) .
        :param builtins.str prefix: A prefix that Kinesis Data Firehose adds to the files that it delivers to the Amazon S3 bucket. The prefix helps you identify the files that Kinesis Data Firehose delivered.
        """
        pulumi.set(__self__, "bucket_arn", bucket_arn)
        pulumi.set(__self__, "role_arn", role_arn)
        if buffering_hints is not None:
            pulumi.set(__self__, "buffering_hints", buffering_hints)
        if cloud_watch_logging_options is not None:
            pulumi.set(__self__, "cloud_watch_logging_options", cloud_watch_logging_options)
        if compression_format is not None:
            pulumi.set(__self__, "compression_format", compression_format)
        if encryption_configuration is not None:
            pulumi.set(__self__, "encryption_configuration", encryption_configuration)
        if error_output_prefix is not None:
            pulumi.set(__self__, "error_output_prefix", error_output_prefix)
        if prefix is not None:
            pulumi.set(__self__, "prefix", prefix)

    @property
    @pulumi.getter(name="bucketArn")
    def bucket_arn(self) -> builtins.str:
        """
        The Amazon Resource Name (ARN) of the Amazon S3 bucket to send data to.
        """
        return pulumi.get(self, "bucket_arn")

    @property
    @pulumi.getter(name="roleArn")
    def role_arn(self) -> builtins.str:
        """
        The ARN of an AWS Identity and Access Management (IAM) role that grants Kinesis Data Firehose access to your Amazon S3 bucket and AWS KMS (if you enable data encryption). For more information, see [Grant Kinesis Data Firehose Access to an Amazon S3 Destination](https://docs.aws.amazon.com/firehose/latest/dev/controlling-access.html#using-iam-s3) in the *Amazon Kinesis Data Firehose Developer Guide* .
        """
        return pulumi.get(self, "role_arn")

    @property
    @pulumi.getter(name="bufferingHints")
    def buffering_hints(self) -> Optional['outputs.DeliveryStreamBufferingHints']:
        """
        Configures how Kinesis Data Firehose buffers incoming data while delivering it to the Amazon S3 bucket.
        """
        return pulumi.get(self, "buffering_hints")

    @property
    @pulumi.getter(name="cloudWatchLoggingOptions")
    def cloud_watch_logging_options(self) -> Optional['outputs.DeliveryStreamCloudWatchLoggingOptions']:
        """
        The CloudWatch logging options for your Firehose stream.
        """
        return pulumi.get(self, "cloud_watch_logging_options")

    @property
    @pulumi.getter(name="compressionFormat")
    def compression_format(self) -> Optional['DeliveryStreamS3DestinationConfigurationCompressionFormat']:
        """
        The type of compression that Kinesis Data Firehose uses to compress the data that it delivers to the Amazon S3 bucket. For valid values, see the `CompressionFormat` content for the [S3DestinationConfiguration](https://docs.aws.amazon.com/firehose/latest/APIReference/API_S3DestinationConfiguration.html) data type in the *Amazon Kinesis Data Firehose API Reference* .
        """
        return pulumi.get(self, "compression_format")

    @property
    @pulumi.getter(name="encryptionConfiguration")
    def encryption_configuration(self) -> Optional['outputs.DeliveryStreamEncryptionConfiguration']:
        """
        Configures Amazon Simple Storage Service (Amazon S3) server-side encryption. Kinesis Data Firehose uses AWS Key Management Service ( AWS KMS) to encrypt the data that it delivers to your Amazon S3 bucket.
        """
        return pulumi.get(self, "encryption_configuration")

    @property
    @pulumi.getter(name="errorOutputPrefix")
    def error_output_prefix(self) -> Optional[builtins.str]:
        """
        A prefix that Kinesis Data Firehose evaluates and adds to failed records before writing them to S3. This prefix appears immediately following the bucket name. For information about how to specify this prefix, see [Custom Prefixes for Amazon S3 Objects](https://docs.aws.amazon.com/firehose/latest/dev/s3-prefixes.html) .
        """
        return pulumi.get(self, "error_output_prefix")

    @property
    @pulumi.getter
    def prefix(self) -> Optional[builtins.str]:
        """
        A prefix that Kinesis Data Firehose adds to the files that it delivers to the Amazon S3 bucket. The prefix helps you identify the files that Kinesis Data Firehose delivered.
        """
        return pulumi.get(self, "prefix")


@pulumi.output_type
class DeliveryStreamSchemaConfiguration(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "catalogId":
            suggest = "catalog_id"
        elif key == "databaseName":
            suggest = "database_name"
        elif key == "roleArn":
            suggest = "role_arn"
        elif key == "tableName":
            suggest = "table_name"
        elif key == "versionId":
            suggest = "version_id"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in DeliveryStreamSchemaConfiguration. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        DeliveryStreamSchemaConfiguration.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        DeliveryStreamSchemaConfiguration.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 catalog_id: Optional[builtins.str] = None,
                 database_name: Optional[builtins.str] = None,
                 region: Optional[builtins.str] = None,
                 role_arn: Optional[builtins.str] = None,
                 table_name: Optional[builtins.str] = None,
                 version_id: Optional[builtins.str] = None):
        """
        :param builtins.str catalog_id: The ID of the AWS Glue Data Catalog. If you don't supply this, the AWS account ID is used by default.
        :param builtins.str database_name: Specifies the name of the AWS Glue database that contains the schema for the output data.
               
               > If the `SchemaConfiguration` request parameter is used as part of invoking the `CreateDeliveryStream` API, then the `DatabaseName` property is required and its value must be specified.
        :param builtins.str region: If you don't specify an AWS Region, the default is the current Region.
        :param builtins.str role_arn: The role that Firehose can use to access AWS Glue. This role must be in the same account you use for Firehose. Cross-account roles aren't allowed.
               
               > If the `SchemaConfiguration` request parameter is used as part of invoking the `CreateDeliveryStream` API, then the `RoleARN` property is required and its value must be specified.
        :param builtins.str table_name: Specifies the AWS Glue table that contains the column information that constitutes your data schema.
               
               > If the `SchemaConfiguration` request parameter is used as part of invoking the `CreateDeliveryStream` API, then the `TableName` property is required and its value must be specified.
        :param builtins.str version_id: Specifies the table version for the output data schema. If you don't specify this version ID, or if you set it to `LATEST` , Firehose uses the most recent version. This means that any updates to the table are automatically picked up.
        """
        if catalog_id is not None:
            pulumi.set(__self__, "catalog_id", catalog_id)
        if database_name is not None:
            pulumi.set(__self__, "database_name", database_name)
        if region is not None:
            pulumi.set(__self__, "region", region)
        if role_arn is not None:
            pulumi.set(__self__, "role_arn", role_arn)
        if table_name is not None:
            pulumi.set(__self__, "table_name", table_name)
        if version_id is not None:
            pulumi.set(__self__, "version_id", version_id)

    @property
    @pulumi.getter(name="catalogId")
    def catalog_id(self) -> Optional[builtins.str]:
        """
        The ID of the AWS Glue Data Catalog. If you don't supply this, the AWS account ID is used by default.
        """
        return pulumi.get(self, "catalog_id")

    @property
    @pulumi.getter(name="databaseName")
    def database_name(self) -> Optional[builtins.str]:
        """
        Specifies the name of the AWS Glue database that contains the schema for the output data.

        > If the `SchemaConfiguration` request parameter is used as part of invoking the `CreateDeliveryStream` API, then the `DatabaseName` property is required and its value must be specified.
        """
        return pulumi.get(self, "database_name")

    @property
    @pulumi.getter
    def region(self) -> Optional[builtins.str]:
        """
        If you don't specify an AWS Region, the default is the current Region.
        """
        return pulumi.get(self, "region")

    @property
    @pulumi.getter(name="roleArn")
    def role_arn(self) -> Optional[builtins.str]:
        """
        The role that Firehose can use to access AWS Glue. This role must be in the same account you use for Firehose. Cross-account roles aren't allowed.

        > If the `SchemaConfiguration` request parameter is used as part of invoking the `CreateDeliveryStream` API, then the `RoleARN` property is required and its value must be specified.
        """
        return pulumi.get(self, "role_arn")

    @property
    @pulumi.getter(name="tableName")
    def table_name(self) -> Optional[builtins.str]:
        """
        Specifies the AWS Glue table that contains the column information that constitutes your data schema.

        > If the `SchemaConfiguration` request parameter is used as part of invoking the `CreateDeliveryStream` API, then the `TableName` property is required and its value must be specified.
        """
        return pulumi.get(self, "table_name")

    @property
    @pulumi.getter(name="versionId")
    def version_id(self) -> Optional[builtins.str]:
        """
        Specifies the table version for the output data schema. If you don't specify this version ID, or if you set it to `LATEST` , Firehose uses the most recent version. This means that any updates to the table are automatically picked up.
        """
        return pulumi.get(self, "version_id")


@pulumi.output_type
class DeliveryStreamSecretsManagerConfiguration(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "roleArn":
            suggest = "role_arn"
        elif key == "secretArn":
            suggest = "secret_arn"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in DeliveryStreamSecretsManagerConfiguration. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        DeliveryStreamSecretsManagerConfiguration.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        DeliveryStreamSecretsManagerConfiguration.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 enabled: builtins.bool,
                 role_arn: Optional[builtins.str] = None,
                 secret_arn: Optional[builtins.str] = None):
        """
        :param builtins.bool enabled: Specifies whether you want to use the secrets manager feature. When set as `True` the secrets manager configuration overwrites the existing secrets in the destination configuration. When it's set to `False` Firehose falls back to the credentials in the destination configuration.
        :param builtins.str role_arn: Specifies the role that Firehose assumes when calling the Secrets Manager API operation. When you provide the role, it overrides any destination specific role defined in the destination configuration. If you do not provide the then we use the destination specific role. This parameter is required for Splunk.
        :param builtins.str secret_arn: The ARN of the secret that stores your credentials. It must be in the same region as the Firehose stream and the role. The secret ARN can reside in a different account than the Firehose stream and role as Firehose supports cross-account secret access. This parameter is required when *Enabled* is set to `True` .
        """
        pulumi.set(__self__, "enabled", enabled)
        if role_arn is not None:
            pulumi.set(__self__, "role_arn", role_arn)
        if secret_arn is not None:
            pulumi.set(__self__, "secret_arn", secret_arn)

    @property
    @pulumi.getter
    def enabled(self) -> builtins.bool:
        """
        Specifies whether you want to use the secrets manager feature. When set as `True` the secrets manager configuration overwrites the existing secrets in the destination configuration. When it's set to `False` Firehose falls back to the credentials in the destination configuration.
        """
        return pulumi.get(self, "enabled")

    @property
    @pulumi.getter(name="roleArn")
    def role_arn(self) -> Optional[builtins.str]:
        """
        Specifies the role that Firehose assumes when calling the Secrets Manager API operation. When you provide the role, it overrides any destination specific role defined in the destination configuration. If you do not provide the then we use the destination specific role. This parameter is required for Splunk.
        """
        return pulumi.get(self, "role_arn")

    @property
    @pulumi.getter(name="secretArn")
    def secret_arn(self) -> Optional[builtins.str]:
        """
        The ARN of the secret that stores your credentials. It must be in the same region as the Firehose stream and the role. The secret ARN can reside in a different account than the Firehose stream and role as Firehose supports cross-account secret access. This parameter is required when *Enabled* is set to `True` .
        """
        return pulumi.get(self, "secret_arn")


@pulumi.output_type
class DeliveryStreamSerializer(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "orcSerDe":
            suggest = "orc_ser_de"
        elif key == "parquetSerDe":
            suggest = "parquet_ser_de"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in DeliveryStreamSerializer. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        DeliveryStreamSerializer.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        DeliveryStreamSerializer.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 orc_ser_de: Optional['outputs.DeliveryStreamOrcSerDe'] = None,
                 parquet_ser_de: Optional['outputs.DeliveryStreamParquetSerDe'] = None):
        """
        :param 'DeliveryStreamOrcSerDe' orc_ser_de: A serializer to use for converting data to the ORC format before storing it in Amazon S3. For more information, see [Apache ORC](https://docs.aws.amazon.com/https://orc.apache.org/docs/) .
        :param 'DeliveryStreamParquetSerDe' parquet_ser_de: A serializer to use for converting data to the Parquet format before storing it in Amazon S3. For more information, see [Apache Parquet](https://docs.aws.amazon.com/https://parquet.apache.org/docs/contribution-guidelines/) .
        """
        if orc_ser_de is not None:
            pulumi.set(__self__, "orc_ser_de", orc_ser_de)
        if parquet_ser_de is not None:
            pulumi.set(__self__, "parquet_ser_de", parquet_ser_de)

    @property
    @pulumi.getter(name="orcSerDe")
    def orc_ser_de(self) -> Optional['outputs.DeliveryStreamOrcSerDe']:
        """
        A serializer to use for converting data to the ORC format before storing it in Amazon S3. For more information, see [Apache ORC](https://docs.aws.amazon.com/https://orc.apache.org/docs/) .
        """
        return pulumi.get(self, "orc_ser_de")

    @property
    @pulumi.getter(name="parquetSerDe")
    def parquet_ser_de(self) -> Optional['outputs.DeliveryStreamParquetSerDe']:
        """
        A serializer to use for converting data to the Parquet format before storing it in Amazon S3. For more information, see [Apache Parquet](https://docs.aws.amazon.com/https://parquet.apache.org/docs/contribution-guidelines/) .
        """
        return pulumi.get(self, "parquet_ser_de")


@pulumi.output_type
class DeliveryStreamSnowflakeBufferingHints(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "intervalInSeconds":
            suggest = "interval_in_seconds"
        elif key == "sizeInMbs":
            suggest = "size_in_mbs"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in DeliveryStreamSnowflakeBufferingHints. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        DeliveryStreamSnowflakeBufferingHints.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        DeliveryStreamSnowflakeBufferingHints.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 interval_in_seconds: Optional[builtins.int] = None,
                 size_in_mbs: Optional[builtins.int] = None):
        """
        :param builtins.int interval_in_seconds: Buffer incoming data for the specified period of time, in seconds, before delivering it to the destination. The default value is 0.
        :param builtins.int size_in_mbs: Buffer incoming data to the specified size, in MBs, before delivering it to the destination. The default value is 128.
        """
        if interval_in_seconds is not None:
            pulumi.set(__self__, "interval_in_seconds", interval_in_seconds)
        if size_in_mbs is not None:
            pulumi.set(__self__, "size_in_mbs", size_in_mbs)

    @property
    @pulumi.getter(name="intervalInSeconds")
    def interval_in_seconds(self) -> Optional[builtins.int]:
        """
        Buffer incoming data for the specified period of time, in seconds, before delivering it to the destination. The default value is 0.
        """
        return pulumi.get(self, "interval_in_seconds")

    @property
    @pulumi.getter(name="sizeInMbs")
    def size_in_mbs(self) -> Optional[builtins.int]:
        """
        Buffer incoming data to the specified size, in MBs, before delivering it to the destination. The default value is 128.
        """
        return pulumi.get(self, "size_in_mbs")


@pulumi.output_type
class DeliveryStreamSnowflakeDestinationConfiguration(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "accountUrl":
            suggest = "account_url"
        elif key == "roleArn":
            suggest = "role_arn"
        elif key == "s3Configuration":
            suggest = "s3_configuration"
        elif key == "bufferingHints":
            suggest = "buffering_hints"
        elif key == "cloudWatchLoggingOptions":
            suggest = "cloud_watch_logging_options"
        elif key == "contentColumnName":
            suggest = "content_column_name"
        elif key == "dataLoadingOption":
            suggest = "data_loading_option"
        elif key == "keyPassphrase":
            suggest = "key_passphrase"
        elif key == "metaDataColumnName":
            suggest = "meta_data_column_name"
        elif key == "privateKey":
            suggest = "private_key"
        elif key == "processingConfiguration":
            suggest = "processing_configuration"
        elif key == "retryOptions":
            suggest = "retry_options"
        elif key == "s3BackupMode":
            suggest = "s3_backup_mode"
        elif key == "secretsManagerConfiguration":
            suggest = "secrets_manager_configuration"
        elif key == "snowflakeRoleConfiguration":
            suggest = "snowflake_role_configuration"
        elif key == "snowflakeVpcConfiguration":
            suggest = "snowflake_vpc_configuration"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in DeliveryStreamSnowflakeDestinationConfiguration. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        DeliveryStreamSnowflakeDestinationConfiguration.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        DeliveryStreamSnowflakeDestinationConfiguration.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 account_url: builtins.str,
                 database: builtins.str,
                 role_arn: builtins.str,
                 s3_configuration: 'outputs.DeliveryStreamS3DestinationConfiguration',
                 schema: builtins.str,
                 table: builtins.str,
                 buffering_hints: Optional['outputs.DeliveryStreamSnowflakeBufferingHints'] = None,
                 cloud_watch_logging_options: Optional['outputs.DeliveryStreamCloudWatchLoggingOptions'] = None,
                 content_column_name: Optional[builtins.str] = None,
                 data_loading_option: Optional['DeliveryStreamSnowflakeDestinationConfigurationDataLoadingOption'] = None,
                 key_passphrase: Optional[builtins.str] = None,
                 meta_data_column_name: Optional[builtins.str] = None,
                 private_key: Optional[builtins.str] = None,
                 processing_configuration: Optional['outputs.DeliveryStreamProcessingConfiguration'] = None,
                 retry_options: Optional['outputs.DeliveryStreamSnowflakeRetryOptions'] = None,
                 s3_backup_mode: Optional['DeliveryStreamSnowflakeDestinationConfigurationS3BackupMode'] = None,
                 secrets_manager_configuration: Optional['outputs.DeliveryStreamSecretsManagerConfiguration'] = None,
                 snowflake_role_configuration: Optional['outputs.DeliveryStreamSnowflakeRoleConfiguration'] = None,
                 snowflake_vpc_configuration: Optional['outputs.DeliveryStreamSnowflakeVpcConfiguration'] = None,
                 user: Optional[builtins.str] = None):
        """
        :param builtins.str account_url: URL for accessing your Snowflake account. This URL must include your [account identifier](https://docs.aws.amazon.com/https://docs.snowflake.com/en/user-guide/admin-account-identifier) . Note that the protocol (https://) and port number are optional.
        :param builtins.str database: All data in Snowflake is maintained in databases.
        :param builtins.str role_arn: The Amazon Resource Name (ARN) of the Snowflake role
        :param builtins.str schema: Each database consists of one or more schemas, which are logical groupings of database objects, such as tables and views
        :param builtins.str table: All data in Snowflake is stored in database tables, logically structured as collections of columns and rows.
        :param 'DeliveryStreamSnowflakeBufferingHints' buffering_hints: Describes the buffering to perform before delivering data to the Snowflake destination. If you do not specify any value, Firehose uses the default values.
        :param builtins.str content_column_name: The name of the record content column.
        :param 'DeliveryStreamSnowflakeDestinationConfigurationDataLoadingOption' data_loading_option: Choose to load JSON keys mapped to table column names or choose to split the JSON payload where content is mapped to a record content column and source metadata is mapped to a record metadata column.
        :param builtins.str key_passphrase: Passphrase to decrypt the private key when the key is encrypted. For information, see [Using Key Pair Authentication & Key Rotation](https://docs.aws.amazon.com/https://docs.snowflake.com/en/user-guide/data-load-snowpipe-streaming-configuration#using-key-pair-authentication-key-rotation) .
        :param builtins.str meta_data_column_name: Specify a column name in the table, where the metadata information has to be loaded. When you enable this field, you will see the following column in the snowflake table, which differs based on the source type.
               
               For Direct PUT as source
               
               `{ "firehoseDeliveryStreamName" : "streamname", "IngestionTime" : "timestamp" }`
               
               For Kinesis Data Stream as source
               
               `"kinesisStreamName" : "streamname", "kinesisShardId" : "Id", "kinesisPartitionKey" : "key", "kinesisSequenceNumber" : "1234", "subsequenceNumber" : "2334", "IngestionTime" : "timestamp" }`
        :param builtins.str private_key: The private key used to encrypt your Snowflake client. For information, see [Using Key Pair Authentication & Key Rotation](https://docs.aws.amazon.com/https://docs.snowflake.com/en/user-guide/data-load-snowpipe-streaming-configuration#using-key-pair-authentication-key-rotation) .
        :param 'DeliveryStreamSnowflakeRetryOptions' retry_options: The time period where Firehose will retry sending data to the chosen HTTP endpoint.
        :param 'DeliveryStreamSnowflakeDestinationConfigurationS3BackupMode' s3_backup_mode: Choose an S3 backup mode
        :param 'DeliveryStreamSecretsManagerConfiguration' secrets_manager_configuration: The configuration that defines how you access secrets for Snowflake.
        :param 'DeliveryStreamSnowflakeRoleConfiguration' snowflake_role_configuration: Optionally configure a Snowflake role. Otherwise the default user role will be used.
        :param 'DeliveryStreamSnowflakeVpcConfiguration' snowflake_vpc_configuration: The VPCE ID for Firehose to privately connect with Snowflake. The ID format is com.amazonaws.vpce.[region].vpce-svc-<[id]>. For more information, see [Amazon PrivateLink & Snowflake](https://docs.aws.amazon.com/https://docs.snowflake.com/en/user-guide/admin-security-privatelink)
        :param builtins.str user: User login name for the Snowflake account.
        """
        pulumi.set(__self__, "account_url", account_url)
        pulumi.set(__self__, "database", database)
        pulumi.set(__self__, "role_arn", role_arn)
        pulumi.set(__self__, "s3_configuration", s3_configuration)
        pulumi.set(__self__, "schema", schema)
        pulumi.set(__self__, "table", table)
        if buffering_hints is not None:
            pulumi.set(__self__, "buffering_hints", buffering_hints)
        if cloud_watch_logging_options is not None:
            pulumi.set(__self__, "cloud_watch_logging_options", cloud_watch_logging_options)
        if content_column_name is not None:
            pulumi.set(__self__, "content_column_name", content_column_name)
        if data_loading_option is not None:
            pulumi.set(__self__, "data_loading_option", data_loading_option)
        if key_passphrase is not None:
            pulumi.set(__self__, "key_passphrase", key_passphrase)
        if meta_data_column_name is not None:
            pulumi.set(__self__, "meta_data_column_name", meta_data_column_name)
        if private_key is not None:
            pulumi.set(__self__, "private_key", private_key)
        if processing_configuration is not None:
            pulumi.set(__self__, "processing_configuration", processing_configuration)
        if retry_options is not None:
            pulumi.set(__self__, "retry_options", retry_options)
        if s3_backup_mode is not None:
            pulumi.set(__self__, "s3_backup_mode", s3_backup_mode)
        if secrets_manager_configuration is not None:
            pulumi.set(__self__, "secrets_manager_configuration", secrets_manager_configuration)
        if snowflake_role_configuration is not None:
            pulumi.set(__self__, "snowflake_role_configuration", snowflake_role_configuration)
        if snowflake_vpc_configuration is not None:
            pulumi.set(__self__, "snowflake_vpc_configuration", snowflake_vpc_configuration)
        if user is not None:
            pulumi.set(__self__, "user", user)

    @property
    @pulumi.getter(name="accountUrl")
    def account_url(self) -> builtins.str:
        """
        URL for accessing your Snowflake account. This URL must include your [account identifier](https://docs.aws.amazon.com/https://docs.snowflake.com/en/user-guide/admin-account-identifier) . Note that the protocol (https://) and port number are optional.
        """
        return pulumi.get(self, "account_url")

    @property
    @pulumi.getter
    def database(self) -> builtins.str:
        """
        All data in Snowflake is maintained in databases.
        """
        return pulumi.get(self, "database")

    @property
    @pulumi.getter(name="roleArn")
    def role_arn(self) -> builtins.str:
        """
        The Amazon Resource Name (ARN) of the Snowflake role
        """
        return pulumi.get(self, "role_arn")

    @property
    @pulumi.getter(name="s3Configuration")
    def s3_configuration(self) -> 'outputs.DeliveryStreamS3DestinationConfiguration':
        return pulumi.get(self, "s3_configuration")

    @property
    @pulumi.getter
    def schema(self) -> builtins.str:
        """
        Each database consists of one or more schemas, which are logical groupings of database objects, such as tables and views
        """
        return pulumi.get(self, "schema")

    @property
    @pulumi.getter
    def table(self) -> builtins.str:
        """
        All data in Snowflake is stored in database tables, logically structured as collections of columns and rows.
        """
        return pulumi.get(self, "table")

    @property
    @pulumi.getter(name="bufferingHints")
    def buffering_hints(self) -> Optional['outputs.DeliveryStreamSnowflakeBufferingHints']:
        """
        Describes the buffering to perform before delivering data to the Snowflake destination. If you do not specify any value, Firehose uses the default values.
        """
        return pulumi.get(self, "buffering_hints")

    @property
    @pulumi.getter(name="cloudWatchLoggingOptions")
    def cloud_watch_logging_options(self) -> Optional['outputs.DeliveryStreamCloudWatchLoggingOptions']:
        return pulumi.get(self, "cloud_watch_logging_options")

    @property
    @pulumi.getter(name="contentColumnName")
    def content_column_name(self) -> Optional[builtins.str]:
        """
        The name of the record content column.
        """
        return pulumi.get(self, "content_column_name")

    @property
    @pulumi.getter(name="dataLoadingOption")
    def data_loading_option(self) -> Optional['DeliveryStreamSnowflakeDestinationConfigurationDataLoadingOption']:
        """
        Choose to load JSON keys mapped to table column names or choose to split the JSON payload where content is mapped to a record content column and source metadata is mapped to a record metadata column.
        """
        return pulumi.get(self, "data_loading_option")

    @property
    @pulumi.getter(name="keyPassphrase")
    def key_passphrase(self) -> Optional[builtins.str]:
        """
        Passphrase to decrypt the private key when the key is encrypted. For information, see [Using Key Pair Authentication & Key Rotation](https://docs.aws.amazon.com/https://docs.snowflake.com/en/user-guide/data-load-snowpipe-streaming-configuration#using-key-pair-authentication-key-rotation) .
        """
        return pulumi.get(self, "key_passphrase")

    @property
    @pulumi.getter(name="metaDataColumnName")
    def meta_data_column_name(self) -> Optional[builtins.str]:
        """
        Specify a column name in the table, where the metadata information has to be loaded. When you enable this field, you will see the following column in the snowflake table, which differs based on the source type.

        For Direct PUT as source

        `{ "firehoseDeliveryStreamName" : "streamname", "IngestionTime" : "timestamp" }`

        For Kinesis Data Stream as source

        `"kinesisStreamName" : "streamname", "kinesisShardId" : "Id", "kinesisPartitionKey" : "key", "kinesisSequenceNumber" : "1234", "subsequenceNumber" : "2334", "IngestionTime" : "timestamp" }`
        """
        return pulumi.get(self, "meta_data_column_name")

    @property
    @pulumi.getter(name="privateKey")
    def private_key(self) -> Optional[builtins.str]:
        """
        The private key used to encrypt your Snowflake client. For information, see [Using Key Pair Authentication & Key Rotation](https://docs.aws.amazon.com/https://docs.snowflake.com/en/user-guide/data-load-snowpipe-streaming-configuration#using-key-pair-authentication-key-rotation) .
        """
        return pulumi.get(self, "private_key")

    @property
    @pulumi.getter(name="processingConfiguration")
    def processing_configuration(self) -> Optional['outputs.DeliveryStreamProcessingConfiguration']:
        return pulumi.get(self, "processing_configuration")

    @property
    @pulumi.getter(name="retryOptions")
    def retry_options(self) -> Optional['outputs.DeliveryStreamSnowflakeRetryOptions']:
        """
        The time period where Firehose will retry sending data to the chosen HTTP endpoint.
        """
        return pulumi.get(self, "retry_options")

    @property
    @pulumi.getter(name="s3BackupMode")
    def s3_backup_mode(self) -> Optional['DeliveryStreamSnowflakeDestinationConfigurationS3BackupMode']:
        """
        Choose an S3 backup mode
        """
        return pulumi.get(self, "s3_backup_mode")

    @property
    @pulumi.getter(name="secretsManagerConfiguration")
    def secrets_manager_configuration(self) -> Optional['outputs.DeliveryStreamSecretsManagerConfiguration']:
        """
        The configuration that defines how you access secrets for Snowflake.
        """
        return pulumi.get(self, "secrets_manager_configuration")

    @property
    @pulumi.getter(name="snowflakeRoleConfiguration")
    def snowflake_role_configuration(self) -> Optional['outputs.DeliveryStreamSnowflakeRoleConfiguration']:
        """
        Optionally configure a Snowflake role. Otherwise the default user role will be used.
        """
        return pulumi.get(self, "snowflake_role_configuration")

    @property
    @pulumi.getter(name="snowflakeVpcConfiguration")
    def snowflake_vpc_configuration(self) -> Optional['outputs.DeliveryStreamSnowflakeVpcConfiguration']:
        """
        The VPCE ID for Firehose to privately connect with Snowflake. The ID format is com.amazonaws.vpce.[region].vpce-svc-<[id]>. For more information, see [Amazon PrivateLink & Snowflake](https://docs.aws.amazon.com/https://docs.snowflake.com/en/user-guide/admin-security-privatelink)
        """
        return pulumi.get(self, "snowflake_vpc_configuration")

    @property
    @pulumi.getter
    def user(self) -> Optional[builtins.str]:
        """
        User login name for the Snowflake account.
        """
        return pulumi.get(self, "user")


@pulumi.output_type
class DeliveryStreamSnowflakeRetryOptions(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "durationInSeconds":
            suggest = "duration_in_seconds"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in DeliveryStreamSnowflakeRetryOptions. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        DeliveryStreamSnowflakeRetryOptions.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        DeliveryStreamSnowflakeRetryOptions.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 duration_in_seconds: Optional[builtins.int] = None):
        """
        :param builtins.int duration_in_seconds: the time period where Firehose will retry sending data to the chosen HTTP endpoint.
        """
        if duration_in_seconds is not None:
            pulumi.set(__self__, "duration_in_seconds", duration_in_seconds)

    @property
    @pulumi.getter(name="durationInSeconds")
    def duration_in_seconds(self) -> Optional[builtins.int]:
        """
        the time period where Firehose will retry sending data to the chosen HTTP endpoint.
        """
        return pulumi.get(self, "duration_in_seconds")


@pulumi.output_type
class DeliveryStreamSnowflakeRoleConfiguration(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "snowflakeRole":
            suggest = "snowflake_role"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in DeliveryStreamSnowflakeRoleConfiguration. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        DeliveryStreamSnowflakeRoleConfiguration.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        DeliveryStreamSnowflakeRoleConfiguration.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 enabled: Optional[builtins.bool] = None,
                 snowflake_role: Optional[builtins.str] = None):
        """
        :param builtins.bool enabled: Enable Snowflake role
        :param builtins.str snowflake_role: The Snowflake role you wish to configure
        """
        if enabled is not None:
            pulumi.set(__self__, "enabled", enabled)
        if snowflake_role is not None:
            pulumi.set(__self__, "snowflake_role", snowflake_role)

    @property
    @pulumi.getter
    def enabled(self) -> Optional[builtins.bool]:
        """
        Enable Snowflake role
        """
        return pulumi.get(self, "enabled")

    @property
    @pulumi.getter(name="snowflakeRole")
    def snowflake_role(self) -> Optional[builtins.str]:
        """
        The Snowflake role you wish to configure
        """
        return pulumi.get(self, "snowflake_role")


@pulumi.output_type
class DeliveryStreamSnowflakeVpcConfiguration(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "privateLinkVpceId":
            suggest = "private_link_vpce_id"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in DeliveryStreamSnowflakeVpcConfiguration. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        DeliveryStreamSnowflakeVpcConfiguration.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        DeliveryStreamSnowflakeVpcConfiguration.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 private_link_vpce_id: builtins.str):
        """
        :param builtins.str private_link_vpce_id: The VPCE ID for Firehose to privately connect with Snowflake. The ID format is com.amazonaws.vpce.[region].vpce-svc-<[id]>. For more information, see [Amazon PrivateLink & Snowflake](https://docs.aws.amazon.com/https://docs.snowflake.com/en/user-guide/admin-security-privatelink)
        """
        pulumi.set(__self__, "private_link_vpce_id", private_link_vpce_id)

    @property
    @pulumi.getter(name="privateLinkVpceId")
    def private_link_vpce_id(self) -> builtins.str:
        """
        The VPCE ID for Firehose to privately connect with Snowflake. The ID format is com.amazonaws.vpce.[region].vpce-svc-<[id]>. For more information, see [Amazon PrivateLink & Snowflake](https://docs.aws.amazon.com/https://docs.snowflake.com/en/user-guide/admin-security-privatelink)
        """
        return pulumi.get(self, "private_link_vpce_id")


@pulumi.output_type
class DeliveryStreamSplunkBufferingHints(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "intervalInSeconds":
            suggest = "interval_in_seconds"
        elif key == "sizeInMbs":
            suggest = "size_in_mbs"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in DeliveryStreamSplunkBufferingHints. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        DeliveryStreamSplunkBufferingHints.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        DeliveryStreamSplunkBufferingHints.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 interval_in_seconds: Optional[builtins.int] = None,
                 size_in_mbs: Optional[builtins.int] = None):
        """
        :param builtins.int interval_in_seconds: Buffer incoming data for the specified period of time, in seconds, before delivering it to the destination. The default value is 60 (1 minute).
        :param builtins.int size_in_mbs: Buffer incoming data to the specified size, in MBs, before delivering it to the destination. The default value is 5.
        """
        if interval_in_seconds is not None:
            pulumi.set(__self__, "interval_in_seconds", interval_in_seconds)
        if size_in_mbs is not None:
            pulumi.set(__self__, "size_in_mbs", size_in_mbs)

    @property
    @pulumi.getter(name="intervalInSeconds")
    def interval_in_seconds(self) -> Optional[builtins.int]:
        """
        Buffer incoming data for the specified period of time, in seconds, before delivering it to the destination. The default value is 60 (1 minute).
        """
        return pulumi.get(self, "interval_in_seconds")

    @property
    @pulumi.getter(name="sizeInMbs")
    def size_in_mbs(self) -> Optional[builtins.int]:
        """
        Buffer incoming data to the specified size, in MBs, before delivering it to the destination. The default value is 5.
        """
        return pulumi.get(self, "size_in_mbs")


@pulumi.output_type
class DeliveryStreamSplunkDestinationConfiguration(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "hecEndpoint":
            suggest = "hec_endpoint"
        elif key == "hecEndpointType":
            suggest = "hec_endpoint_type"
        elif key == "s3Configuration":
            suggest = "s3_configuration"
        elif key == "bufferingHints":
            suggest = "buffering_hints"
        elif key == "cloudWatchLoggingOptions":
            suggest = "cloud_watch_logging_options"
        elif key == "hecAcknowledgmentTimeoutInSeconds":
            suggest = "hec_acknowledgment_timeout_in_seconds"
        elif key == "hecToken":
            suggest = "hec_token"
        elif key == "processingConfiguration":
            suggest = "processing_configuration"
        elif key == "retryOptions":
            suggest = "retry_options"
        elif key == "s3BackupMode":
            suggest = "s3_backup_mode"
        elif key == "secretsManagerConfiguration":
            suggest = "secrets_manager_configuration"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in DeliveryStreamSplunkDestinationConfiguration. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        DeliveryStreamSplunkDestinationConfiguration.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        DeliveryStreamSplunkDestinationConfiguration.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 hec_endpoint: builtins.str,
                 hec_endpoint_type: 'DeliveryStreamSplunkDestinationConfigurationHecEndpointType',
                 s3_configuration: 'outputs.DeliveryStreamS3DestinationConfiguration',
                 buffering_hints: Optional['outputs.DeliveryStreamSplunkBufferingHints'] = None,
                 cloud_watch_logging_options: Optional['outputs.DeliveryStreamCloudWatchLoggingOptions'] = None,
                 hec_acknowledgment_timeout_in_seconds: Optional[builtins.int] = None,
                 hec_token: Optional[builtins.str] = None,
                 processing_configuration: Optional['outputs.DeliveryStreamProcessingConfiguration'] = None,
                 retry_options: Optional['outputs.DeliveryStreamSplunkRetryOptions'] = None,
                 s3_backup_mode: Optional[builtins.str] = None,
                 secrets_manager_configuration: Optional['outputs.DeliveryStreamSecretsManagerConfiguration'] = None):
        """
        :param builtins.str hec_endpoint: The HTTP Event Collector (HEC) endpoint to which Firehose sends your data.
        :param 'DeliveryStreamSplunkDestinationConfigurationHecEndpointType' hec_endpoint_type: This type can be either `Raw` or `Event` .
        :param 'DeliveryStreamS3DestinationConfiguration' s3_configuration: The configuration for the backup Amazon S3 location.
        :param 'DeliveryStreamSplunkBufferingHints' buffering_hints: The buffering options. If no value is specified, the default values for Splunk are used.
        :param 'DeliveryStreamCloudWatchLoggingOptions' cloud_watch_logging_options: The Amazon CloudWatch logging options for your Firehose stream.
        :param builtins.int hec_acknowledgment_timeout_in_seconds: The amount of time that Firehose waits to receive an acknowledgment from Splunk after it sends it data. At the end of the timeout period, Firehose either tries to send the data again or considers it an error, based on your retry settings.
        :param builtins.str hec_token: This is a GUID that you obtain from your Splunk cluster when you create a new HEC endpoint.
        :param 'DeliveryStreamProcessingConfiguration' processing_configuration: The data processing configuration.
        :param 'DeliveryStreamSplunkRetryOptions' retry_options: The retry behavior in case Firehose is unable to deliver data to Splunk, or if it doesn't receive an acknowledgment of receipt from Splunk.
        :param builtins.str s3_backup_mode: Defines how documents should be delivered to Amazon S3. When set to `FailedEventsOnly` , Firehose writes any data that could not be indexed to the configured Amazon S3 destination. When set to `AllEvents` , Firehose delivers all incoming records to Amazon S3, and also writes failed documents to Amazon S3. The default value is `FailedEventsOnly` .
               
               You can update this backup mode from `FailedEventsOnly` to `AllEvents` . You can't update it from `AllEvents` to `FailedEventsOnly` .
        :param 'DeliveryStreamSecretsManagerConfiguration' secrets_manager_configuration: The configuration that defines how you access secrets for Splunk.
        """
        pulumi.set(__self__, "hec_endpoint", hec_endpoint)
        pulumi.set(__self__, "hec_endpoint_type", hec_endpoint_type)
        pulumi.set(__self__, "s3_configuration", s3_configuration)
        if buffering_hints is not None:
            pulumi.set(__self__, "buffering_hints", buffering_hints)
        if cloud_watch_logging_options is not None:
            pulumi.set(__self__, "cloud_watch_logging_options", cloud_watch_logging_options)
        if hec_acknowledgment_timeout_in_seconds is not None:
            pulumi.set(__self__, "hec_acknowledgment_timeout_in_seconds", hec_acknowledgment_timeout_in_seconds)
        if hec_token is not None:
            pulumi.set(__self__, "hec_token", hec_token)
        if processing_configuration is not None:
            pulumi.set(__self__, "processing_configuration", processing_configuration)
        if retry_options is not None:
            pulumi.set(__self__, "retry_options", retry_options)
        if s3_backup_mode is not None:
            pulumi.set(__self__, "s3_backup_mode", s3_backup_mode)
        if secrets_manager_configuration is not None:
            pulumi.set(__self__, "secrets_manager_configuration", secrets_manager_configuration)

    @property
    @pulumi.getter(name="hecEndpoint")
    def hec_endpoint(self) -> builtins.str:
        """
        The HTTP Event Collector (HEC) endpoint to which Firehose sends your data.
        """
        return pulumi.get(self, "hec_endpoint")

    @property
    @pulumi.getter(name="hecEndpointType")
    def hec_endpoint_type(self) -> 'DeliveryStreamSplunkDestinationConfigurationHecEndpointType':
        """
        This type can be either `Raw` or `Event` .
        """
        return pulumi.get(self, "hec_endpoint_type")

    @property
    @pulumi.getter(name="s3Configuration")
    def s3_configuration(self) -> 'outputs.DeliveryStreamS3DestinationConfiguration':
        """
        The configuration for the backup Amazon S3 location.
        """
        return pulumi.get(self, "s3_configuration")

    @property
    @pulumi.getter(name="bufferingHints")
    def buffering_hints(self) -> Optional['outputs.DeliveryStreamSplunkBufferingHints']:
        """
        The buffering options. If no value is specified, the default values for Splunk are used.
        """
        return pulumi.get(self, "buffering_hints")

    @property
    @pulumi.getter(name="cloudWatchLoggingOptions")
    def cloud_watch_logging_options(self) -> Optional['outputs.DeliveryStreamCloudWatchLoggingOptions']:
        """
        The Amazon CloudWatch logging options for your Firehose stream.
        """
        return pulumi.get(self, "cloud_watch_logging_options")

    @property
    @pulumi.getter(name="hecAcknowledgmentTimeoutInSeconds")
    def hec_acknowledgment_timeout_in_seconds(self) -> Optional[builtins.int]:
        """
        The amount of time that Firehose waits to receive an acknowledgment from Splunk after it sends it data. At the end of the timeout period, Firehose either tries to send the data again or considers it an error, based on your retry settings.
        """
        return pulumi.get(self, "hec_acknowledgment_timeout_in_seconds")

    @property
    @pulumi.getter(name="hecToken")
    def hec_token(self) -> Optional[builtins.str]:
        """
        This is a GUID that you obtain from your Splunk cluster when you create a new HEC endpoint.
        """
        return pulumi.get(self, "hec_token")

    @property
    @pulumi.getter(name="processingConfiguration")
    def processing_configuration(self) -> Optional['outputs.DeliveryStreamProcessingConfiguration']:
        """
        The data processing configuration.
        """
        return pulumi.get(self, "processing_configuration")

    @property
    @pulumi.getter(name="retryOptions")
    def retry_options(self) -> Optional['outputs.DeliveryStreamSplunkRetryOptions']:
        """
        The retry behavior in case Firehose is unable to deliver data to Splunk, or if it doesn't receive an acknowledgment of receipt from Splunk.
        """
        return pulumi.get(self, "retry_options")

    @property
    @pulumi.getter(name="s3BackupMode")
    def s3_backup_mode(self) -> Optional[builtins.str]:
        """
        Defines how documents should be delivered to Amazon S3. When set to `FailedEventsOnly` , Firehose writes any data that could not be indexed to the configured Amazon S3 destination. When set to `AllEvents` , Firehose delivers all incoming records to Amazon S3, and also writes failed documents to Amazon S3. The default value is `FailedEventsOnly` .

        You can update this backup mode from `FailedEventsOnly` to `AllEvents` . You can't update it from `AllEvents` to `FailedEventsOnly` .
        """
        return pulumi.get(self, "s3_backup_mode")

    @property
    @pulumi.getter(name="secretsManagerConfiguration")
    def secrets_manager_configuration(self) -> Optional['outputs.DeliveryStreamSecretsManagerConfiguration']:
        """
        The configuration that defines how you access secrets for Splunk.
        """
        return pulumi.get(self, "secrets_manager_configuration")


@pulumi.output_type
class DeliveryStreamSplunkRetryOptions(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "durationInSeconds":
            suggest = "duration_in_seconds"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in DeliveryStreamSplunkRetryOptions. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        DeliveryStreamSplunkRetryOptions.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        DeliveryStreamSplunkRetryOptions.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 duration_in_seconds: Optional[builtins.int] = None):
        """
        :param builtins.int duration_in_seconds: The total amount of time that Firehose spends on retries. This duration starts after the initial attempt to send data to Splunk fails. It doesn't include the periods during which Firehose waits for acknowledgment from Splunk after each attempt.
        """
        if duration_in_seconds is not None:
            pulumi.set(__self__, "duration_in_seconds", duration_in_seconds)

    @property
    @pulumi.getter(name="durationInSeconds")
    def duration_in_seconds(self) -> Optional[builtins.int]:
        """
        The total amount of time that Firehose spends on retries. This duration starts after the initial attempt to send data to Splunk fails. It doesn't include the periods during which Firehose waits for acknowledgment from Splunk after each attempt.
        """
        return pulumi.get(self, "duration_in_seconds")


@pulumi.output_type
class DeliveryStreamVpcConfiguration(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "roleArn":
            suggest = "role_arn"
        elif key == "securityGroupIds":
            suggest = "security_group_ids"
        elif key == "subnetIds":
            suggest = "subnet_ids"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in DeliveryStreamVpcConfiguration. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        DeliveryStreamVpcConfiguration.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        DeliveryStreamVpcConfiguration.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 role_arn: builtins.str,
                 security_group_ids: Sequence[builtins.str],
                 subnet_ids: Sequence[builtins.str]):
        """
        :param builtins.str role_arn: The ARN of the IAM role that you want the delivery stream to use to create endpoints in the destination VPC. You can use your existing Kinesis Data Firehose delivery role or you can specify a new role. In either case, make sure that the role trusts the Kinesis Data Firehose service principal and that it grants the following permissions:
               
               - `ec2:DescribeVpcs`
               - `ec2:DescribeVpcAttribute`
               - `ec2:DescribeSubnets`
               - `ec2:DescribeSecurityGroups`
               - `ec2:DescribeNetworkInterfaces`
               - `ec2:CreateNetworkInterface`
               - `ec2:CreateNetworkInterfacePermission`
               - `ec2:DeleteNetworkInterface`
               
               If you revoke these permissions after you create the delivery stream, Kinesis Data Firehose can't scale out by creating more ENIs when necessary. You might therefore see a degradation in performance.
        :param Sequence[builtins.str] security_group_ids: The IDs of the security groups that you want Kinesis Data Firehose to use when it creates ENIs in the VPC of the Amazon ES destination. You can use the same security group that the Amazon ES domain uses or different ones. If you specify different security groups here, ensure that they allow outbound HTTPS traffic to the Amazon ES domain's security group. Also ensure that the Amazon ES domain's security group allows HTTPS traffic from the security groups specified here. If you use the same security group for both your delivery stream and the Amazon ES domain, make sure the security group inbound rule allows HTTPS traffic.
        :param Sequence[builtins.str] subnet_ids: The IDs of the subnets that Kinesis Data Firehose uses to create ENIs in the VPC of the Amazon ES destination. Make sure that the routing tables and inbound and outbound rules allow traffic to flow from the subnets whose IDs are specified here to the subnets that have the destination Amazon ES endpoints. Kinesis Data Firehose creates at least one ENI in each of the subnets that are specified here. Do not delete or modify these ENIs.
               
               The number of ENIs that Kinesis Data Firehose creates in the subnets specified here scales up and down automatically based on throughput. To enable Kinesis Data Firehose to scale up the number of ENIs to match throughput, ensure that you have sufficient quota. To help you calculate the quota you need, assume that Kinesis Data Firehose can create up to three ENIs for this delivery stream for each of the subnets specified here.
        """
        pulumi.set(__self__, "role_arn", role_arn)
        pulumi.set(__self__, "security_group_ids", security_group_ids)
        pulumi.set(__self__, "subnet_ids", subnet_ids)

    @property
    @pulumi.getter(name="roleArn")
    def role_arn(self) -> builtins.str:
        """
        The ARN of the IAM role that you want the delivery stream to use to create endpoints in the destination VPC. You can use your existing Kinesis Data Firehose delivery role or you can specify a new role. In either case, make sure that the role trusts the Kinesis Data Firehose service principal and that it grants the following permissions:

        - `ec2:DescribeVpcs`
        - `ec2:DescribeVpcAttribute`
        - `ec2:DescribeSubnets`
        - `ec2:DescribeSecurityGroups`
        - `ec2:DescribeNetworkInterfaces`
        - `ec2:CreateNetworkInterface`
        - `ec2:CreateNetworkInterfacePermission`
        - `ec2:DeleteNetworkInterface`

        If you revoke these permissions after you create the delivery stream, Kinesis Data Firehose can't scale out by creating more ENIs when necessary. You might therefore see a degradation in performance.
        """
        return pulumi.get(self, "role_arn")

    @property
    @pulumi.getter(name="securityGroupIds")
    def security_group_ids(self) -> Sequence[builtins.str]:
        """
        The IDs of the security groups that you want Kinesis Data Firehose to use when it creates ENIs in the VPC of the Amazon ES destination. You can use the same security group that the Amazon ES domain uses or different ones. If you specify different security groups here, ensure that they allow outbound HTTPS traffic to the Amazon ES domain's security group. Also ensure that the Amazon ES domain's security group allows HTTPS traffic from the security groups specified here. If you use the same security group for both your delivery stream and the Amazon ES domain, make sure the security group inbound rule allows HTTPS traffic.
        """
        return pulumi.get(self, "security_group_ids")

    @property
    @pulumi.getter(name="subnetIds")
    def subnet_ids(self) -> Sequence[builtins.str]:
        """
        The IDs of the subnets that Kinesis Data Firehose uses to create ENIs in the VPC of the Amazon ES destination. Make sure that the routing tables and inbound and outbound rules allow traffic to flow from the subnets whose IDs are specified here to the subnets that have the destination Amazon ES endpoints. Kinesis Data Firehose creates at least one ENI in each of the subnets that are specified here. Do not delete or modify these ENIs.

        The number of ENIs that Kinesis Data Firehose creates in the subnets specified here scales up and down automatically based on throughput. To enable Kinesis Data Firehose to scale up the number of ENIs to match throughput, ensure that you have sufficient quota. To help you calculate the quota you need, assume that Kinesis Data Firehose can create up to three ENIs for this delivery stream for each of the subnets specified here.
        """
        return pulumi.get(self, "subnet_ids")


