# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs
from .. import _inputs as _root_inputs
from .. import outputs as _root_outputs
from ._enums import *
from ._inputs import *

__all__ = ['FaqArgs', 'Faq']

@pulumi.input_type
class FaqArgs:
    def __init__(__self__, *,
                 index_id: pulumi.Input[builtins.str],
                 role_arn: pulumi.Input[builtins.str],
                 s3_path: pulumi.Input['FaqS3PathArgs'],
                 description: Optional[pulumi.Input[builtins.str]] = None,
                 file_format: Optional[pulumi.Input['FaqFileFormat']] = None,
                 language_code: Optional[pulumi.Input[builtins.str]] = None,
                 name: Optional[pulumi.Input[builtins.str]] = None,
                 tags: Optional[pulumi.Input[Sequence[pulumi.Input['_root_inputs.TagArgs']]]] = None):
        """
        The set of arguments for constructing a Faq resource.
        :param pulumi.Input[builtins.str] index_id: Index ID
        :param pulumi.Input[builtins.str] role_arn: FAQ role ARN
        :param pulumi.Input['FaqS3PathArgs'] s3_path: FAQ S3 path
        :param pulumi.Input[builtins.str] description: FAQ description
        :param pulumi.Input['FaqFileFormat'] file_format: FAQ file format
        :param pulumi.Input[builtins.str] language_code: The code for a language. This shows a supported language for the FAQ document as part of the summary information for FAQs. English is supported by default. For more information on supported languages, including their codes, see [Adding documents in languages other than English](https://docs.aws.amazon.com/kendra/latest/dg/in-adding-languages.html) .
        :param pulumi.Input[builtins.str] name: FAQ name
        :param pulumi.Input[Sequence[pulumi.Input['_root_inputs.TagArgs']]] tags: Tags for labeling the FAQ
        """
        pulumi.set(__self__, "index_id", index_id)
        pulumi.set(__self__, "role_arn", role_arn)
        pulumi.set(__self__, "s3_path", s3_path)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if file_format is not None:
            pulumi.set(__self__, "file_format", file_format)
        if language_code is not None:
            pulumi.set(__self__, "language_code", language_code)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)

    @property
    @pulumi.getter(name="indexId")
    def index_id(self) -> pulumi.Input[builtins.str]:
        """
        Index ID
        """
        return pulumi.get(self, "index_id")

    @index_id.setter
    def index_id(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "index_id", value)

    @property
    @pulumi.getter(name="roleArn")
    def role_arn(self) -> pulumi.Input[builtins.str]:
        """
        FAQ role ARN
        """
        return pulumi.get(self, "role_arn")

    @role_arn.setter
    def role_arn(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "role_arn", value)

    @property
    @pulumi.getter(name="s3Path")
    def s3_path(self) -> pulumi.Input['FaqS3PathArgs']:
        """
        FAQ S3 path
        """
        return pulumi.get(self, "s3_path")

    @s3_path.setter
    def s3_path(self, value: pulumi.Input['FaqS3PathArgs']):
        pulumi.set(self, "s3_path", value)

    @property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        FAQ description
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "description", value)

    @property
    @pulumi.getter(name="fileFormat")
    def file_format(self) -> Optional[pulumi.Input['FaqFileFormat']]:
        """
        FAQ file format
        """
        return pulumi.get(self, "file_format")

    @file_format.setter
    def file_format(self, value: Optional[pulumi.Input['FaqFileFormat']]):
        pulumi.set(self, "file_format", value)

    @property
    @pulumi.getter(name="languageCode")
    def language_code(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The code for a language. This shows a supported language for the FAQ document as part of the summary information for FAQs. English is supported by default. For more information on supported languages, including their codes, see [Adding documents in languages other than English](https://docs.aws.amazon.com/kendra/latest/dg/in-adding-languages.html) .
        """
        return pulumi.get(self, "language_code")

    @language_code.setter
    def language_code(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "language_code", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        FAQ name
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter
    def tags(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['_root_inputs.TagArgs']]]]:
        """
        Tags for labeling the FAQ
        """
        return pulumi.get(self, "tags")

    @tags.setter
    def tags(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['_root_inputs.TagArgs']]]]):
        pulumi.set(self, "tags", value)


@pulumi.type_token("aws-native:kendra:Faq")
class Faq(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 description: Optional[pulumi.Input[builtins.str]] = None,
                 file_format: Optional[pulumi.Input['FaqFileFormat']] = None,
                 index_id: Optional[pulumi.Input[builtins.str]] = None,
                 language_code: Optional[pulumi.Input[builtins.str]] = None,
                 name: Optional[pulumi.Input[builtins.str]] = None,
                 role_arn: Optional[pulumi.Input[builtins.str]] = None,
                 s3_path: Optional[pulumi.Input[Union['FaqS3PathArgs', 'FaqS3PathArgsDict']]] = None,
                 tags: Optional[pulumi.Input[Sequence[pulumi.Input[Union['_root_inputs.TagArgs', '_root_inputs.TagArgsDict']]]]] = None,
                 __props__=None):
        """
        A Kendra FAQ resource

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[builtins.str] description: FAQ description
        :param pulumi.Input['FaqFileFormat'] file_format: FAQ file format
        :param pulumi.Input[builtins.str] index_id: Index ID
        :param pulumi.Input[builtins.str] language_code: The code for a language. This shows a supported language for the FAQ document as part of the summary information for FAQs. English is supported by default. For more information on supported languages, including their codes, see [Adding documents in languages other than English](https://docs.aws.amazon.com/kendra/latest/dg/in-adding-languages.html) .
        :param pulumi.Input[builtins.str] name: FAQ name
        :param pulumi.Input[builtins.str] role_arn: FAQ role ARN
        :param pulumi.Input[Union['FaqS3PathArgs', 'FaqS3PathArgsDict']] s3_path: FAQ S3 path
        :param pulumi.Input[Sequence[pulumi.Input[Union['_root_inputs.TagArgs', '_root_inputs.TagArgsDict']]]] tags: Tags for labeling the FAQ
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: FaqArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        A Kendra FAQ resource

        :param str resource_name: The name of the resource.
        :param FaqArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(FaqArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 description: Optional[pulumi.Input[builtins.str]] = None,
                 file_format: Optional[pulumi.Input['FaqFileFormat']] = None,
                 index_id: Optional[pulumi.Input[builtins.str]] = None,
                 language_code: Optional[pulumi.Input[builtins.str]] = None,
                 name: Optional[pulumi.Input[builtins.str]] = None,
                 role_arn: Optional[pulumi.Input[builtins.str]] = None,
                 s3_path: Optional[pulumi.Input[Union['FaqS3PathArgs', 'FaqS3PathArgsDict']]] = None,
                 tags: Optional[pulumi.Input[Sequence[pulumi.Input[Union['_root_inputs.TagArgs', '_root_inputs.TagArgsDict']]]]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = FaqArgs.__new__(FaqArgs)

            __props__.__dict__["description"] = description
            __props__.__dict__["file_format"] = file_format
            if index_id is None and not opts.urn:
                raise TypeError("Missing required property 'index_id'")
            __props__.__dict__["index_id"] = index_id
            __props__.__dict__["language_code"] = language_code
            __props__.__dict__["name"] = name
            if role_arn is None and not opts.urn:
                raise TypeError("Missing required property 'role_arn'")
            __props__.__dict__["role_arn"] = role_arn
            if s3_path is None and not opts.urn:
                raise TypeError("Missing required property 's3_path'")
            __props__.__dict__["s3_path"] = s3_path
            __props__.__dict__["tags"] = tags
            __props__.__dict__["arn"] = None
            __props__.__dict__["aws_id"] = None
        replace_on_changes = pulumi.ResourceOptions(replace_on_changes=["description", "fileFormat", "indexId", "name", "roleArn", "s3Path"])
        opts = pulumi.ResourceOptions.merge(opts, replace_on_changes)
        super(Faq, __self__).__init__(
            'aws-native:kendra:Faq',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None) -> 'Faq':
        """
        Get an existing Faq resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = FaqArgs.__new__(FaqArgs)

        __props__.__dict__["arn"] = None
        __props__.__dict__["aws_id"] = None
        __props__.__dict__["description"] = None
        __props__.__dict__["file_format"] = None
        __props__.__dict__["index_id"] = None
        __props__.__dict__["language_code"] = None
        __props__.__dict__["name"] = None
        __props__.__dict__["role_arn"] = None
        __props__.__dict__["s3_path"] = None
        __props__.__dict__["tags"] = None
        return Faq(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter
    def arn(self) -> pulumi.Output[builtins.str]:
        """
        `arn:aws:kendra:us-west-2:111122223333:index/335c3741-41df-46a6-b5d3-61f85b787884/faq/f61995a6-cd5c-4e99-9cfc-58816d8bfaa7`
        """
        return pulumi.get(self, "arn")

    @property
    @pulumi.getter(name="awsId")
    def aws_id(self) -> pulumi.Output[builtins.str]:
        """
        The identifier for the FAQ. For example:

        `f61995a6-cd5c-4e99-9cfc-58816d8bfaa7`
        """
        return pulumi.get(self, "aws_id")

    @property
    @pulumi.getter
    def description(self) -> pulumi.Output[Optional[builtins.str]]:
        """
        FAQ description
        """
        return pulumi.get(self, "description")

    @property
    @pulumi.getter(name="fileFormat")
    def file_format(self) -> pulumi.Output[Optional['FaqFileFormat']]:
        """
        FAQ file format
        """
        return pulumi.get(self, "file_format")

    @property
    @pulumi.getter(name="indexId")
    def index_id(self) -> pulumi.Output[builtins.str]:
        """
        Index ID
        """
        return pulumi.get(self, "index_id")

    @property
    @pulumi.getter(name="languageCode")
    def language_code(self) -> pulumi.Output[Optional[builtins.str]]:
        """
        The code for a language. This shows a supported language for the FAQ document as part of the summary information for FAQs. English is supported by default. For more information on supported languages, including their codes, see [Adding documents in languages other than English](https://docs.aws.amazon.com/kendra/latest/dg/in-adding-languages.html) .
        """
        return pulumi.get(self, "language_code")

    @property
    @pulumi.getter
    def name(self) -> pulumi.Output[builtins.str]:
        """
        FAQ name
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="roleArn")
    def role_arn(self) -> pulumi.Output[builtins.str]:
        """
        FAQ role ARN
        """
        return pulumi.get(self, "role_arn")

    @property
    @pulumi.getter(name="s3Path")
    def s3_path(self) -> pulumi.Output['outputs.FaqS3Path']:
        """
        FAQ S3 path
        """
        return pulumi.get(self, "s3_path")

    @property
    @pulumi.getter
    def tags(self) -> pulumi.Output[Optional[Sequence['_root_outputs.Tag']]]:
        """
        Tags for labeling the FAQ
        """
        return pulumi.get(self, "tags")

