# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from .. import _inputs as _root_inputs
from .. import outputs as _root_outputs
from ._enums import *

__all__ = ['IngestConfigurationArgs', 'IngestConfiguration']

@pulumi.input_type
class IngestConfigurationArgs:
    def __init__(__self__, *,
                 ingest_protocol: Optional[pulumi.Input['IngestConfigurationIngestProtocol']] = None,
                 insecure_ingest: Optional[pulumi.Input[builtins.bool]] = None,
                 name: Optional[pulumi.Input[builtins.str]] = None,
                 stage_arn: Optional[pulumi.Input[builtins.str]] = None,
                 tags: Optional[pulumi.Input[Sequence[pulumi.Input['_root_inputs.TagArgs']]]] = None,
                 user_id: Optional[pulumi.Input[builtins.str]] = None):
        """
        The set of arguments for constructing a IngestConfiguration resource.
        :param pulumi.Input['IngestConfigurationIngestProtocol'] ingest_protocol: Ingest Protocol.
        :param pulumi.Input[builtins.bool] insecure_ingest: Whether ingest configuration allows insecure ingest.
        :param pulumi.Input[builtins.str] name: IngestConfiguration
        :param pulumi.Input[builtins.str] stage_arn: Stage ARN. A value other than an empty string indicates that stage is linked to IngestConfiguration. Default: "" (recording is disabled).
        :param pulumi.Input[Sequence[pulumi.Input['_root_inputs.TagArgs']]] tags: A list of key-value pairs that contain metadata for the asset model.
        :param pulumi.Input[builtins.str] user_id: User defined indentifier for participant associated with IngestConfiguration.
        """
        if ingest_protocol is not None:
            pulumi.set(__self__, "ingest_protocol", ingest_protocol)
        if insecure_ingest is not None:
            pulumi.set(__self__, "insecure_ingest", insecure_ingest)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if stage_arn is not None:
            pulumi.set(__self__, "stage_arn", stage_arn)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)
        if user_id is not None:
            pulumi.set(__self__, "user_id", user_id)

    @property
    @pulumi.getter(name="ingestProtocol")
    def ingest_protocol(self) -> Optional[pulumi.Input['IngestConfigurationIngestProtocol']]:
        """
        Ingest Protocol.
        """
        return pulumi.get(self, "ingest_protocol")

    @ingest_protocol.setter
    def ingest_protocol(self, value: Optional[pulumi.Input['IngestConfigurationIngestProtocol']]):
        pulumi.set(self, "ingest_protocol", value)

    @property
    @pulumi.getter(name="insecureIngest")
    def insecure_ingest(self) -> Optional[pulumi.Input[builtins.bool]]:
        """
        Whether ingest configuration allows insecure ingest.
        """
        return pulumi.get(self, "insecure_ingest")

    @insecure_ingest.setter
    def insecure_ingest(self, value: Optional[pulumi.Input[builtins.bool]]):
        pulumi.set(self, "insecure_ingest", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        IngestConfiguration
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter(name="stageArn")
    def stage_arn(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Stage ARN. A value other than an empty string indicates that stage is linked to IngestConfiguration. Default: "" (recording is disabled).
        """
        return pulumi.get(self, "stage_arn")

    @stage_arn.setter
    def stage_arn(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "stage_arn", value)

    @property
    @pulumi.getter
    def tags(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['_root_inputs.TagArgs']]]]:
        """
        A list of key-value pairs that contain metadata for the asset model.
        """
        return pulumi.get(self, "tags")

    @tags.setter
    def tags(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['_root_inputs.TagArgs']]]]):
        pulumi.set(self, "tags", value)

    @property
    @pulumi.getter(name="userId")
    def user_id(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        User defined indentifier for participant associated with IngestConfiguration.
        """
        return pulumi.get(self, "user_id")

    @user_id.setter
    def user_id(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "user_id", value)


@pulumi.type_token("aws-native:ivs:IngestConfiguration")
class IngestConfiguration(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 ingest_protocol: Optional[pulumi.Input['IngestConfigurationIngestProtocol']] = None,
                 insecure_ingest: Optional[pulumi.Input[builtins.bool]] = None,
                 name: Optional[pulumi.Input[builtins.str]] = None,
                 stage_arn: Optional[pulumi.Input[builtins.str]] = None,
                 tags: Optional[pulumi.Input[Sequence[pulumi.Input[Union['_root_inputs.TagArgs', '_root_inputs.TagArgsDict']]]]] = None,
                 user_id: Optional[pulumi.Input[builtins.str]] = None,
                 __props__=None):
        """
        Resource Type definition for AWS::IVS::IngestConfiguration

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input['IngestConfigurationIngestProtocol'] ingest_protocol: Ingest Protocol.
        :param pulumi.Input[builtins.bool] insecure_ingest: Whether ingest configuration allows insecure ingest.
        :param pulumi.Input[builtins.str] name: IngestConfiguration
        :param pulumi.Input[builtins.str] stage_arn: Stage ARN. A value other than an empty string indicates that stage is linked to IngestConfiguration. Default: "" (recording is disabled).
        :param pulumi.Input[Sequence[pulumi.Input[Union['_root_inputs.TagArgs', '_root_inputs.TagArgsDict']]]] tags: A list of key-value pairs that contain metadata for the asset model.
        :param pulumi.Input[builtins.str] user_id: User defined indentifier for participant associated with IngestConfiguration.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: Optional[IngestConfigurationArgs] = None,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Resource Type definition for AWS::IVS::IngestConfiguration

        :param str resource_name: The name of the resource.
        :param IngestConfigurationArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(IngestConfigurationArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 ingest_protocol: Optional[pulumi.Input['IngestConfigurationIngestProtocol']] = None,
                 insecure_ingest: Optional[pulumi.Input[builtins.bool]] = None,
                 name: Optional[pulumi.Input[builtins.str]] = None,
                 stage_arn: Optional[pulumi.Input[builtins.str]] = None,
                 tags: Optional[pulumi.Input[Sequence[pulumi.Input[Union['_root_inputs.TagArgs', '_root_inputs.TagArgsDict']]]]] = None,
                 user_id: Optional[pulumi.Input[builtins.str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = IngestConfigurationArgs.__new__(IngestConfigurationArgs)

            __props__.__dict__["ingest_protocol"] = ingest_protocol
            __props__.__dict__["insecure_ingest"] = insecure_ingest
            __props__.__dict__["name"] = name
            __props__.__dict__["stage_arn"] = stage_arn
            __props__.__dict__["tags"] = tags
            __props__.__dict__["user_id"] = user_id
            __props__.__dict__["arn"] = None
            __props__.__dict__["participant_id"] = None
            __props__.__dict__["state"] = None
            __props__.__dict__["stream_key"] = None
        replace_on_changes = pulumi.ResourceOptions(replace_on_changes=["ingestProtocol", "insecureIngest", "name", "userId"])
        opts = pulumi.ResourceOptions.merge(opts, replace_on_changes)
        super(IngestConfiguration, __self__).__init__(
            'aws-native:ivs:IngestConfiguration',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None) -> 'IngestConfiguration':
        """
        Get an existing IngestConfiguration resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = IngestConfigurationArgs.__new__(IngestConfigurationArgs)

        __props__.__dict__["arn"] = None
        __props__.__dict__["ingest_protocol"] = None
        __props__.__dict__["insecure_ingest"] = None
        __props__.__dict__["name"] = None
        __props__.__dict__["participant_id"] = None
        __props__.__dict__["stage_arn"] = None
        __props__.__dict__["state"] = None
        __props__.__dict__["stream_key"] = None
        __props__.__dict__["tags"] = None
        __props__.__dict__["user_id"] = None
        return IngestConfiguration(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter
    def arn(self) -> pulumi.Output[builtins.str]:
        """
        IngestConfiguration ARN is automatically generated on creation and assigned as the unique identifier.
        """
        return pulumi.get(self, "arn")

    @property
    @pulumi.getter(name="ingestProtocol")
    def ingest_protocol(self) -> pulumi.Output[Optional['IngestConfigurationIngestProtocol']]:
        """
        Ingest Protocol.
        """
        return pulumi.get(self, "ingest_protocol")

    @property
    @pulumi.getter(name="insecureIngest")
    def insecure_ingest(self) -> pulumi.Output[Optional[builtins.bool]]:
        """
        Whether ingest configuration allows insecure ingest.
        """
        return pulumi.get(self, "insecure_ingest")

    @property
    @pulumi.getter
    def name(self) -> pulumi.Output[Optional[builtins.str]]:
        """
        IngestConfiguration
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="participantId")
    def participant_id(self) -> pulumi.Output[builtins.str]:
        """
        Participant Id is automatically generated on creation and assigned.
        """
        return pulumi.get(self, "participant_id")

    @property
    @pulumi.getter(name="stageArn")
    def stage_arn(self) -> pulumi.Output[Optional[builtins.str]]:
        """
        Stage ARN. A value other than an empty string indicates that stage is linked to IngestConfiguration. Default: "" (recording is disabled).
        """
        return pulumi.get(self, "stage_arn")

    @property
    @pulumi.getter
    def state(self) -> pulumi.Output['IngestConfigurationState']:
        """
        State of IngestConfiguration which determines whether IngestConfiguration is in use or not.
        """
        return pulumi.get(self, "state")

    @property
    @pulumi.getter(name="streamKey")
    def stream_key(self) -> pulumi.Output[builtins.str]:
        """
        Stream-key value.
        """
        return pulumi.get(self, "stream_key")

    @property
    @pulumi.getter
    def tags(self) -> pulumi.Output[Optional[Sequence['_root_outputs.Tag']]]:
        """
        A list of key-value pairs that contain metadata for the asset model.
        """
        return pulumi.get(self, "tags")

    @property
    @pulumi.getter(name="userId")
    def user_id(self) -> pulumi.Output[Optional[builtins.str]]:
        """
        User defined indentifier for participant associated with IngestConfiguration.
        """
        return pulumi.get(self, "user_id")

