# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from .. import outputs as _root_outputs
from ._enums import *

__all__ = [
    'GetIngestConfigurationResult',
    'AwaitableGetIngestConfigurationResult',
    'get_ingest_configuration',
    'get_ingest_configuration_output',
]

@pulumi.output_type
class GetIngestConfigurationResult:
    def __init__(__self__, arn=None, participant_id=None, stage_arn=None, state=None, stream_key=None, tags=None):
        if arn and not isinstance(arn, str):
            raise TypeError("Expected argument 'arn' to be a str")
        pulumi.set(__self__, "arn", arn)
        if participant_id and not isinstance(participant_id, str):
            raise TypeError("Expected argument 'participant_id' to be a str")
        pulumi.set(__self__, "participant_id", participant_id)
        if stage_arn and not isinstance(stage_arn, str):
            raise TypeError("Expected argument 'stage_arn' to be a str")
        pulumi.set(__self__, "stage_arn", stage_arn)
        if state and not isinstance(state, str):
            raise TypeError("Expected argument 'state' to be a str")
        pulumi.set(__self__, "state", state)
        if stream_key and not isinstance(stream_key, str):
            raise TypeError("Expected argument 'stream_key' to be a str")
        pulumi.set(__self__, "stream_key", stream_key)
        if tags and not isinstance(tags, list):
            raise TypeError("Expected argument 'tags' to be a list")
        pulumi.set(__self__, "tags", tags)

    @property
    @pulumi.getter
    def arn(self) -> Optional[builtins.str]:
        """
        IngestConfiguration ARN is automatically generated on creation and assigned as the unique identifier.
        """
        return pulumi.get(self, "arn")

    @property
    @pulumi.getter(name="participantId")
    def participant_id(self) -> Optional[builtins.str]:
        """
        Participant Id is automatically generated on creation and assigned.
        """
        return pulumi.get(self, "participant_id")

    @property
    @pulumi.getter(name="stageArn")
    def stage_arn(self) -> Optional[builtins.str]:
        """
        Stage ARN. A value other than an empty string indicates that stage is linked to IngestConfiguration. Default: "" (recording is disabled).
        """
        return pulumi.get(self, "stage_arn")

    @property
    @pulumi.getter
    def state(self) -> Optional['IngestConfigurationState']:
        """
        State of IngestConfiguration which determines whether IngestConfiguration is in use or not.
        """
        return pulumi.get(self, "state")

    @property
    @pulumi.getter(name="streamKey")
    def stream_key(self) -> Optional[builtins.str]:
        """
        Stream-key value.
        """
        return pulumi.get(self, "stream_key")

    @property
    @pulumi.getter
    def tags(self) -> Optional[Sequence['_root_outputs.Tag']]:
        """
        A list of key-value pairs that contain metadata for the asset model.
        """
        return pulumi.get(self, "tags")


class AwaitableGetIngestConfigurationResult(GetIngestConfigurationResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetIngestConfigurationResult(
            arn=self.arn,
            participant_id=self.participant_id,
            stage_arn=self.stage_arn,
            state=self.state,
            stream_key=self.stream_key,
            tags=self.tags)


def get_ingest_configuration(arn: Optional[builtins.str] = None,
                             opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetIngestConfigurationResult:
    """
    Resource Type definition for AWS::IVS::IngestConfiguration


    :param builtins.str arn: IngestConfiguration ARN is automatically generated on creation and assigned as the unique identifier.
    """
    __args__ = dict()
    __args__['arn'] = arn
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('aws-native:ivs:getIngestConfiguration', __args__, opts=opts, typ=GetIngestConfigurationResult).value

    return AwaitableGetIngestConfigurationResult(
        arn=pulumi.get(__ret__, 'arn'),
        participant_id=pulumi.get(__ret__, 'participant_id'),
        stage_arn=pulumi.get(__ret__, 'stage_arn'),
        state=pulumi.get(__ret__, 'state'),
        stream_key=pulumi.get(__ret__, 'stream_key'),
        tags=pulumi.get(__ret__, 'tags'))
def get_ingest_configuration_output(arn: Optional[pulumi.Input[builtins.str]] = None,
                                    opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetIngestConfigurationResult]:
    """
    Resource Type definition for AWS::IVS::IngestConfiguration


    :param builtins.str arn: IngestConfiguration ARN is automatically generated on creation and assigned as the unique identifier.
    """
    __args__ = dict()
    __args__['arn'] = arn
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('aws-native:ivs:getIngestConfiguration', __args__, opts=opts, typ=GetIngestConfigurationResult)
    return __ret__.apply(lambda __response__: GetIngestConfigurationResult(
        arn=pulumi.get(__response__, 'arn'),
        participant_id=pulumi.get(__response__, 'participant_id'),
        stage_arn=pulumi.get(__response__, 'stage_arn'),
        state=pulumi.get(__response__, 'state'),
        stream_key=pulumi.get(__response__, 'stream_key'),
        tags=pulumi.get(__response__, 'tags')))
