# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs
from .. import _inputs as _root_inputs
from .. import outputs as _root_outputs
from ._enums import *
from ._inputs import *

__all__ = ['ChannelArgs', 'Channel']

@pulumi.input_type
class ChannelArgs:
    def __init__(__self__, *,
                 authorized: Optional[pulumi.Input[builtins.bool]] = None,
                 container_format: Optional[pulumi.Input['ChannelContainerFormat']] = None,
                 insecure_ingest: Optional[pulumi.Input[builtins.bool]] = None,
                 latency_mode: Optional[pulumi.Input['ChannelLatencyMode']] = None,
                 multitrack_input_configuration: Optional[pulumi.Input['ChannelMultitrackInputConfigurationArgs']] = None,
                 name: Optional[pulumi.Input[builtins.str]] = None,
                 preset: Optional[pulumi.Input['ChannelPreset']] = None,
                 recording_configuration_arn: Optional[pulumi.Input[builtins.str]] = None,
                 tags: Optional[pulumi.Input[Sequence[pulumi.Input['_root_inputs.TagArgs']]]] = None,
                 type: Optional[pulumi.Input['ChannelType']] = None):
        """
        The set of arguments for constructing a Channel resource.
        :param pulumi.Input[builtins.bool] authorized: Whether the channel is authorized.
        :param pulumi.Input['ChannelContainerFormat'] container_format: Indicates which content-packaging format is used (MPEG-TS or fMP4). If multitrackInputConfiguration is specified and enabled is true, then containerFormat is required and must be set to FRAGMENTED_MP4. Otherwise, containerFormat may be set to TS or FRAGMENTED_MP4. Default: TS.
        :param pulumi.Input[builtins.bool] insecure_ingest: Whether the channel allows insecure ingest.
        :param pulumi.Input['ChannelLatencyMode'] latency_mode: Channel latency mode.
        :param pulumi.Input['ChannelMultitrackInputConfigurationArgs'] multitrack_input_configuration: Object specifying multitrack input configuration. Default: no multitrack input configuration is specified.
        :param pulumi.Input[builtins.str] name: Channel
        :param pulumi.Input['ChannelPreset'] preset: Optional transcode preset for the channel. This is selectable only for ADVANCED_HD and ADVANCED_SD channel types. For those channel types, the default preset is HIGHER_BANDWIDTH_DELIVERY. For other channel types (BASIC and STANDARD), preset is the empty string ("").
        :param pulumi.Input[builtins.str] recording_configuration_arn: Recording Configuration ARN. A value other than an empty string indicates that recording is enabled. Default: "" (recording is disabled).
        :param pulumi.Input[Sequence[pulumi.Input['_root_inputs.TagArgs']]] tags: A list of key-value pairs that contain metadata for the asset model.
        :param pulumi.Input['ChannelType'] type: Channel type, which determines the allowable resolution and bitrate. If you exceed the allowable resolution or bitrate, the stream probably will disconnect immediately.
        """
        if authorized is not None:
            pulumi.set(__self__, "authorized", authorized)
        if container_format is not None:
            pulumi.set(__self__, "container_format", container_format)
        if insecure_ingest is not None:
            pulumi.set(__self__, "insecure_ingest", insecure_ingest)
        if latency_mode is not None:
            pulumi.set(__self__, "latency_mode", latency_mode)
        if multitrack_input_configuration is not None:
            pulumi.set(__self__, "multitrack_input_configuration", multitrack_input_configuration)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if preset is not None:
            pulumi.set(__self__, "preset", preset)
        if recording_configuration_arn is not None:
            pulumi.set(__self__, "recording_configuration_arn", recording_configuration_arn)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)
        if type is not None:
            pulumi.set(__self__, "type", type)

    @property
    @pulumi.getter
    def authorized(self) -> Optional[pulumi.Input[builtins.bool]]:
        """
        Whether the channel is authorized.
        """
        return pulumi.get(self, "authorized")

    @authorized.setter
    def authorized(self, value: Optional[pulumi.Input[builtins.bool]]):
        pulumi.set(self, "authorized", value)

    @property
    @pulumi.getter(name="containerFormat")
    def container_format(self) -> Optional[pulumi.Input['ChannelContainerFormat']]:
        """
        Indicates which content-packaging format is used (MPEG-TS or fMP4). If multitrackInputConfiguration is specified and enabled is true, then containerFormat is required and must be set to FRAGMENTED_MP4. Otherwise, containerFormat may be set to TS or FRAGMENTED_MP4. Default: TS.
        """
        return pulumi.get(self, "container_format")

    @container_format.setter
    def container_format(self, value: Optional[pulumi.Input['ChannelContainerFormat']]):
        pulumi.set(self, "container_format", value)

    @property
    @pulumi.getter(name="insecureIngest")
    def insecure_ingest(self) -> Optional[pulumi.Input[builtins.bool]]:
        """
        Whether the channel allows insecure ingest.
        """
        return pulumi.get(self, "insecure_ingest")

    @insecure_ingest.setter
    def insecure_ingest(self, value: Optional[pulumi.Input[builtins.bool]]):
        pulumi.set(self, "insecure_ingest", value)

    @property
    @pulumi.getter(name="latencyMode")
    def latency_mode(self) -> Optional[pulumi.Input['ChannelLatencyMode']]:
        """
        Channel latency mode.
        """
        return pulumi.get(self, "latency_mode")

    @latency_mode.setter
    def latency_mode(self, value: Optional[pulumi.Input['ChannelLatencyMode']]):
        pulumi.set(self, "latency_mode", value)

    @property
    @pulumi.getter(name="multitrackInputConfiguration")
    def multitrack_input_configuration(self) -> Optional[pulumi.Input['ChannelMultitrackInputConfigurationArgs']]:
        """
        Object specifying multitrack input configuration. Default: no multitrack input configuration is specified.
        """
        return pulumi.get(self, "multitrack_input_configuration")

    @multitrack_input_configuration.setter
    def multitrack_input_configuration(self, value: Optional[pulumi.Input['ChannelMultitrackInputConfigurationArgs']]):
        pulumi.set(self, "multitrack_input_configuration", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Channel
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter
    def preset(self) -> Optional[pulumi.Input['ChannelPreset']]:
        """
        Optional transcode preset for the channel. This is selectable only for ADVANCED_HD and ADVANCED_SD channel types. For those channel types, the default preset is HIGHER_BANDWIDTH_DELIVERY. For other channel types (BASIC and STANDARD), preset is the empty string ("").
        """
        return pulumi.get(self, "preset")

    @preset.setter
    def preset(self, value: Optional[pulumi.Input['ChannelPreset']]):
        pulumi.set(self, "preset", value)

    @property
    @pulumi.getter(name="recordingConfigurationArn")
    def recording_configuration_arn(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Recording Configuration ARN. A value other than an empty string indicates that recording is enabled. Default: "" (recording is disabled).
        """
        return pulumi.get(self, "recording_configuration_arn")

    @recording_configuration_arn.setter
    def recording_configuration_arn(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "recording_configuration_arn", value)

    @property
    @pulumi.getter
    def tags(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['_root_inputs.TagArgs']]]]:
        """
        A list of key-value pairs that contain metadata for the asset model.
        """
        return pulumi.get(self, "tags")

    @tags.setter
    def tags(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['_root_inputs.TagArgs']]]]):
        pulumi.set(self, "tags", value)

    @property
    @pulumi.getter
    def type(self) -> Optional[pulumi.Input['ChannelType']]:
        """
        Channel type, which determines the allowable resolution and bitrate. If you exceed the allowable resolution or bitrate, the stream probably will disconnect immediately.
        """
        return pulumi.get(self, "type")

    @type.setter
    def type(self, value: Optional[pulumi.Input['ChannelType']]):
        pulumi.set(self, "type", value)


@pulumi.type_token("aws-native:ivs:Channel")
class Channel(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 authorized: Optional[pulumi.Input[builtins.bool]] = None,
                 container_format: Optional[pulumi.Input['ChannelContainerFormat']] = None,
                 insecure_ingest: Optional[pulumi.Input[builtins.bool]] = None,
                 latency_mode: Optional[pulumi.Input['ChannelLatencyMode']] = None,
                 multitrack_input_configuration: Optional[pulumi.Input[Union['ChannelMultitrackInputConfigurationArgs', 'ChannelMultitrackInputConfigurationArgsDict']]] = None,
                 name: Optional[pulumi.Input[builtins.str]] = None,
                 preset: Optional[pulumi.Input['ChannelPreset']] = None,
                 recording_configuration_arn: Optional[pulumi.Input[builtins.str]] = None,
                 tags: Optional[pulumi.Input[Sequence[pulumi.Input[Union['_root_inputs.TagArgs', '_root_inputs.TagArgsDict']]]]] = None,
                 type: Optional[pulumi.Input['ChannelType']] = None,
                 __props__=None):
        """
        Resource Type definition for AWS::IVS::Channel

        ## Example Usage
        ### Example

        ```python
        import pulumi
        import pulumi_aws_native as aws_native

        channel = aws_native.ivs.Channel("channel",
            name="MyChannel",
            tags=[{
                "key": "MyKey",
                "value": "MyValue",
            }],
            insecure_ingest=True)
        stream_key = aws_native.ivs.StreamKey("streamKey",
            channel_arn=channel.id,
            tags=[{
                "key": "MyKey",
                "value": "MyValue",
            }])
        pulumi.export("channelArn", channel.id)
        pulumi.export("channelIngestEndpoint", channel.ingest_endpoint)
        pulumi.export("channelPlaybackUrl", channel.playback_url)
        pulumi.export("streamKeyArn", stream_key.id)

        ```
        ### Example

        ```python
        import pulumi
        import pulumi_aws_native as aws_native

        channel = aws_native.ivs.Channel("channel",
            name="MyChannel",
            tags=[{
                "key": "MyKey",
                "value": "MyValue",
            }],
            insecure_ingest=True)
        stream_key = aws_native.ivs.StreamKey("streamKey",
            channel_arn=channel.id,
            tags=[{
                "key": "MyKey",
                "value": "MyValue",
            }])
        pulumi.export("channelArn", channel.id)
        pulumi.export("channelIngestEndpoint", channel.ingest_endpoint)
        pulumi.export("channelPlaybackUrl", channel.playback_url)
        pulumi.export("streamKeyArn", stream_key.id)

        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[builtins.bool] authorized: Whether the channel is authorized.
        :param pulumi.Input['ChannelContainerFormat'] container_format: Indicates which content-packaging format is used (MPEG-TS or fMP4). If multitrackInputConfiguration is specified and enabled is true, then containerFormat is required and must be set to FRAGMENTED_MP4. Otherwise, containerFormat may be set to TS or FRAGMENTED_MP4. Default: TS.
        :param pulumi.Input[builtins.bool] insecure_ingest: Whether the channel allows insecure ingest.
        :param pulumi.Input['ChannelLatencyMode'] latency_mode: Channel latency mode.
        :param pulumi.Input[Union['ChannelMultitrackInputConfigurationArgs', 'ChannelMultitrackInputConfigurationArgsDict']] multitrack_input_configuration: Object specifying multitrack input configuration. Default: no multitrack input configuration is specified.
        :param pulumi.Input[builtins.str] name: Channel
        :param pulumi.Input['ChannelPreset'] preset: Optional transcode preset for the channel. This is selectable only for ADVANCED_HD and ADVANCED_SD channel types. For those channel types, the default preset is HIGHER_BANDWIDTH_DELIVERY. For other channel types (BASIC and STANDARD), preset is the empty string ("").
        :param pulumi.Input[builtins.str] recording_configuration_arn: Recording Configuration ARN. A value other than an empty string indicates that recording is enabled. Default: "" (recording is disabled).
        :param pulumi.Input[Sequence[pulumi.Input[Union['_root_inputs.TagArgs', '_root_inputs.TagArgsDict']]]] tags: A list of key-value pairs that contain metadata for the asset model.
        :param pulumi.Input['ChannelType'] type: Channel type, which determines the allowable resolution and bitrate. If you exceed the allowable resolution or bitrate, the stream probably will disconnect immediately.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: Optional[ChannelArgs] = None,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Resource Type definition for AWS::IVS::Channel

        ## Example Usage
        ### Example

        ```python
        import pulumi
        import pulumi_aws_native as aws_native

        channel = aws_native.ivs.Channel("channel",
            name="MyChannel",
            tags=[{
                "key": "MyKey",
                "value": "MyValue",
            }],
            insecure_ingest=True)
        stream_key = aws_native.ivs.StreamKey("streamKey",
            channel_arn=channel.id,
            tags=[{
                "key": "MyKey",
                "value": "MyValue",
            }])
        pulumi.export("channelArn", channel.id)
        pulumi.export("channelIngestEndpoint", channel.ingest_endpoint)
        pulumi.export("channelPlaybackUrl", channel.playback_url)
        pulumi.export("streamKeyArn", stream_key.id)

        ```
        ### Example

        ```python
        import pulumi
        import pulumi_aws_native as aws_native

        channel = aws_native.ivs.Channel("channel",
            name="MyChannel",
            tags=[{
                "key": "MyKey",
                "value": "MyValue",
            }],
            insecure_ingest=True)
        stream_key = aws_native.ivs.StreamKey("streamKey",
            channel_arn=channel.id,
            tags=[{
                "key": "MyKey",
                "value": "MyValue",
            }])
        pulumi.export("channelArn", channel.id)
        pulumi.export("channelIngestEndpoint", channel.ingest_endpoint)
        pulumi.export("channelPlaybackUrl", channel.playback_url)
        pulumi.export("streamKeyArn", stream_key.id)

        ```

        :param str resource_name: The name of the resource.
        :param ChannelArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(ChannelArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 authorized: Optional[pulumi.Input[builtins.bool]] = None,
                 container_format: Optional[pulumi.Input['ChannelContainerFormat']] = None,
                 insecure_ingest: Optional[pulumi.Input[builtins.bool]] = None,
                 latency_mode: Optional[pulumi.Input['ChannelLatencyMode']] = None,
                 multitrack_input_configuration: Optional[pulumi.Input[Union['ChannelMultitrackInputConfigurationArgs', 'ChannelMultitrackInputConfigurationArgsDict']]] = None,
                 name: Optional[pulumi.Input[builtins.str]] = None,
                 preset: Optional[pulumi.Input['ChannelPreset']] = None,
                 recording_configuration_arn: Optional[pulumi.Input[builtins.str]] = None,
                 tags: Optional[pulumi.Input[Sequence[pulumi.Input[Union['_root_inputs.TagArgs', '_root_inputs.TagArgsDict']]]]] = None,
                 type: Optional[pulumi.Input['ChannelType']] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = ChannelArgs.__new__(ChannelArgs)

            __props__.__dict__["authorized"] = authorized
            __props__.__dict__["container_format"] = container_format
            __props__.__dict__["insecure_ingest"] = insecure_ingest
            __props__.__dict__["latency_mode"] = latency_mode
            __props__.__dict__["multitrack_input_configuration"] = multitrack_input_configuration
            __props__.__dict__["name"] = name
            __props__.__dict__["preset"] = preset
            __props__.__dict__["recording_configuration_arn"] = recording_configuration_arn
            __props__.__dict__["tags"] = tags
            __props__.__dict__["type"] = type
            __props__.__dict__["arn"] = None
            __props__.__dict__["ingest_endpoint"] = None
            __props__.__dict__["playback_url"] = None
        super(Channel, __self__).__init__(
            'aws-native:ivs:Channel',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None) -> 'Channel':
        """
        Get an existing Channel resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = ChannelArgs.__new__(ChannelArgs)

        __props__.__dict__["arn"] = None
        __props__.__dict__["authorized"] = None
        __props__.__dict__["container_format"] = None
        __props__.__dict__["ingest_endpoint"] = None
        __props__.__dict__["insecure_ingest"] = None
        __props__.__dict__["latency_mode"] = None
        __props__.__dict__["multitrack_input_configuration"] = None
        __props__.__dict__["name"] = None
        __props__.__dict__["playback_url"] = None
        __props__.__dict__["preset"] = None
        __props__.__dict__["recording_configuration_arn"] = None
        __props__.__dict__["tags"] = None
        __props__.__dict__["type"] = None
        return Channel(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter
    def arn(self) -> pulumi.Output[builtins.str]:
        """
        Channel ARN is automatically generated on creation and assigned as the unique identifier.
        """
        return pulumi.get(self, "arn")

    @property
    @pulumi.getter
    def authorized(self) -> pulumi.Output[Optional[builtins.bool]]:
        """
        Whether the channel is authorized.
        """
        return pulumi.get(self, "authorized")

    @property
    @pulumi.getter(name="containerFormat")
    def container_format(self) -> pulumi.Output[Optional['ChannelContainerFormat']]:
        """
        Indicates which content-packaging format is used (MPEG-TS or fMP4). If multitrackInputConfiguration is specified and enabled is true, then containerFormat is required and must be set to FRAGMENTED_MP4. Otherwise, containerFormat may be set to TS or FRAGMENTED_MP4. Default: TS.
        """
        return pulumi.get(self, "container_format")

    @property
    @pulumi.getter(name="ingestEndpoint")
    def ingest_endpoint(self) -> pulumi.Output[builtins.str]:
        """
        Channel ingest endpoint, part of the definition of an ingest server, used when you set up streaming software.
        """
        return pulumi.get(self, "ingest_endpoint")

    @property
    @pulumi.getter(name="insecureIngest")
    def insecure_ingest(self) -> pulumi.Output[Optional[builtins.bool]]:
        """
        Whether the channel allows insecure ingest.
        """
        return pulumi.get(self, "insecure_ingest")

    @property
    @pulumi.getter(name="latencyMode")
    def latency_mode(self) -> pulumi.Output[Optional['ChannelLatencyMode']]:
        """
        Channel latency mode.
        """
        return pulumi.get(self, "latency_mode")

    @property
    @pulumi.getter(name="multitrackInputConfiguration")
    def multitrack_input_configuration(self) -> pulumi.Output[Optional['outputs.ChannelMultitrackInputConfiguration']]:
        """
        Object specifying multitrack input configuration. Default: no multitrack input configuration is specified.
        """
        return pulumi.get(self, "multitrack_input_configuration")

    @property
    @pulumi.getter
    def name(self) -> pulumi.Output[Optional[builtins.str]]:
        """
        Channel
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="playbackUrl")
    def playback_url(self) -> pulumi.Output[builtins.str]:
        """
        Channel Playback URL.
        """
        return pulumi.get(self, "playback_url")

    @property
    @pulumi.getter
    def preset(self) -> pulumi.Output[Optional['ChannelPreset']]:
        """
        Optional transcode preset for the channel. This is selectable only for ADVANCED_HD and ADVANCED_SD channel types. For those channel types, the default preset is HIGHER_BANDWIDTH_DELIVERY. For other channel types (BASIC and STANDARD), preset is the empty string ("").
        """
        return pulumi.get(self, "preset")

    @property
    @pulumi.getter(name="recordingConfigurationArn")
    def recording_configuration_arn(self) -> pulumi.Output[Optional[builtins.str]]:
        """
        Recording Configuration ARN. A value other than an empty string indicates that recording is enabled. Default: "" (recording is disabled).
        """
        return pulumi.get(self, "recording_configuration_arn")

    @property
    @pulumi.getter
    def tags(self) -> pulumi.Output[Optional[Sequence['_root_outputs.Tag']]]:
        """
        A list of key-value pairs that contain metadata for the asset model.
        """
        return pulumi.get(self, "tags")

    @property
    @pulumi.getter
    def type(self) -> pulumi.Output[Optional['ChannelType']]:
        """
        Channel type, which determines the allowable resolution and bitrate. If you exceed the allowable resolution or bitrate, the stream probably will disconnect immediately.
        """
        return pulumi.get(self, "type")

