# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs
from .. import outputs as _root_outputs
from ._enums import *

__all__ = [
    'GetNetworkAnalyzerConfigurationResult',
    'AwaitableGetNetworkAnalyzerConfigurationResult',
    'get_network_analyzer_configuration',
    'get_network_analyzer_configuration_output',
]

@pulumi.output_type
class GetNetworkAnalyzerConfigurationResult:
    def __init__(__self__, arn=None, description=None, tags=None, trace_content=None, wireless_devices=None, wireless_gateways=None):
        if arn and not isinstance(arn, str):
            raise TypeError("Expected argument 'arn' to be a str")
        pulumi.set(__self__, "arn", arn)
        if description and not isinstance(description, str):
            raise TypeError("Expected argument 'description' to be a str")
        pulumi.set(__self__, "description", description)
        if tags and not isinstance(tags, list):
            raise TypeError("Expected argument 'tags' to be a list")
        pulumi.set(__self__, "tags", tags)
        if trace_content and not isinstance(trace_content, dict):
            raise TypeError("Expected argument 'trace_content' to be a dict")
        pulumi.set(__self__, "trace_content", trace_content)
        if wireless_devices and not isinstance(wireless_devices, list):
            raise TypeError("Expected argument 'wireless_devices' to be a list")
        pulumi.set(__self__, "wireless_devices", wireless_devices)
        if wireless_gateways and not isinstance(wireless_gateways, list):
            raise TypeError("Expected argument 'wireless_gateways' to be a list")
        pulumi.set(__self__, "wireless_gateways", wireless_gateways)

    @property
    @pulumi.getter
    def arn(self) -> Optional[builtins.str]:
        """
        Arn for network analyzer configuration, Returned upon successful create.
        """
        return pulumi.get(self, "arn")

    @property
    @pulumi.getter
    def description(self) -> Optional[builtins.str]:
        """
        The description of the new resource
        """
        return pulumi.get(self, "description")

    @property
    @pulumi.getter
    def tags(self) -> Optional[Sequence['_root_outputs.Tag']]:
        """
        An array of key-value pairs to apply to this resource.
        """
        return pulumi.get(self, "tags")

    @property
    @pulumi.getter(name="traceContent")
    def trace_content(self) -> Optional['outputs.TraceContentProperties']:
        """
        Trace content for your wireless gateway and wireless device resources
        """
        return pulumi.get(self, "trace_content")

    @property
    @pulumi.getter(name="wirelessDevices")
    def wireless_devices(self) -> Optional[Sequence[builtins.str]]:
        """
        List of wireless gateway resources that have been added to the network analyzer configuration
        """
        return pulumi.get(self, "wireless_devices")

    @property
    @pulumi.getter(name="wirelessGateways")
    def wireless_gateways(self) -> Optional[Sequence[builtins.str]]:
        """
        List of wireless gateway resources that have been added to the network analyzer configuration
        """
        return pulumi.get(self, "wireless_gateways")


class AwaitableGetNetworkAnalyzerConfigurationResult(GetNetworkAnalyzerConfigurationResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetNetworkAnalyzerConfigurationResult(
            arn=self.arn,
            description=self.description,
            tags=self.tags,
            trace_content=self.trace_content,
            wireless_devices=self.wireless_devices,
            wireless_gateways=self.wireless_gateways)


def get_network_analyzer_configuration(name: Optional[builtins.str] = None,
                                       opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetNetworkAnalyzerConfigurationResult:
    """
    Create and manage NetworkAnalyzerConfiguration resource.


    :param builtins.str name: Name of the network analyzer configuration
    """
    __args__ = dict()
    __args__['name'] = name
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('aws-native:iotwireless:getNetworkAnalyzerConfiguration', __args__, opts=opts, typ=GetNetworkAnalyzerConfigurationResult).value

    return AwaitableGetNetworkAnalyzerConfigurationResult(
        arn=pulumi.get(__ret__, 'arn'),
        description=pulumi.get(__ret__, 'description'),
        tags=pulumi.get(__ret__, 'tags'),
        trace_content=pulumi.get(__ret__, 'trace_content'),
        wireless_devices=pulumi.get(__ret__, 'wireless_devices'),
        wireless_gateways=pulumi.get(__ret__, 'wireless_gateways'))
def get_network_analyzer_configuration_output(name: Optional[pulumi.Input[builtins.str]] = None,
                                              opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetNetworkAnalyzerConfigurationResult]:
    """
    Create and manage NetworkAnalyzerConfiguration resource.


    :param builtins.str name: Name of the network analyzer configuration
    """
    __args__ = dict()
    __args__['name'] = name
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('aws-native:iotwireless:getNetworkAnalyzerConfiguration', __args__, opts=opts, typ=GetNetworkAnalyzerConfigurationResult)
    return __ret__.apply(lambda __response__: GetNetworkAnalyzerConfigurationResult(
        arn=pulumi.get(__response__, 'arn'),
        description=pulumi.get(__response__, 'description'),
        tags=pulumi.get(__response__, 'tags'),
        trace_content=pulumi.get(__response__, 'trace_content'),
        wireless_devices=pulumi.get(__response__, 'wireless_devices'),
        wireless_gateways=pulumi.get(__response__, 'wireless_gateways')))
