# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs
from ._enums import *

__all__ = [
    'ComponentTypeCompositeComponentType',
    'ComponentTypeDataConnector',
    'ComponentTypeDataType',
    'ComponentTypeDataValue',
    'ComponentTypeDataValueRelationshipValueProperties',
    'ComponentTypeFunction',
    'ComponentTypeLambdaFunction',
    'ComponentTypePropertyDefinition',
    'ComponentTypePropertyGroup',
    'ComponentTypeRelationship',
    'ComponentTypeStatus',
    'ComponentTypeStatusErrorProperties',
    'EntityComponent',
    'EntityCompositeComponent',
    'EntityDataType',
    'EntityDataValue',
    'EntityDataValueRelationshipValueProperties',
    'EntityDefinition',
    'EntityProperty',
    'EntityPropertyGroup',
    'EntityRelationship',
    'EntityStatus',
    'EntityStatusErrorProperties',
]

@pulumi.output_type
class ComponentTypeCompositeComponentType(dict):
    """
    An object that sets information about a composite component type.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "componentTypeId":
            suggest = "component_type_id"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ComponentTypeCompositeComponentType. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ComponentTypeCompositeComponentType.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ComponentTypeCompositeComponentType.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 component_type_id: Optional[builtins.str] = None):
        """
        An object that sets information about a composite component type.
        :param builtins.str component_type_id: The id of the composite component type.
        """
        if component_type_id is not None:
            pulumi.set(__self__, "component_type_id", component_type_id)

    @property
    @pulumi.getter(name="componentTypeId")
    def component_type_id(self) -> Optional[builtins.str]:
        """
        The id of the composite component type.
        """
        return pulumi.get(self, "component_type_id")


@pulumi.output_type
class ComponentTypeDataConnector(dict):
    """
    The data connector.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "isNative":
            suggest = "is_native"
        elif key == "lambda":
            suggest = "lambda_"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ComponentTypeDataConnector. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ComponentTypeDataConnector.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ComponentTypeDataConnector.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 is_native: Optional[builtins.bool] = None,
                 lambda_: Optional['outputs.ComponentTypeLambdaFunction'] = None):
        """
        The data connector.
        :param builtins.bool is_native: A Boolean value that specifies whether the data connector is native to IoT TwinMaker.
        :param 'ComponentTypeLambdaFunction' lambda_: The Lambda function associated with this data connector.
        """
        if is_native is not None:
            pulumi.set(__self__, "is_native", is_native)
        if lambda_ is not None:
            pulumi.set(__self__, "lambda_", lambda_)

    @property
    @pulumi.getter(name="isNative")
    def is_native(self) -> Optional[builtins.bool]:
        """
        A Boolean value that specifies whether the data connector is native to IoT TwinMaker.
        """
        return pulumi.get(self, "is_native")

    @property
    @pulumi.getter(name="lambda")
    def lambda_(self) -> Optional['outputs.ComponentTypeLambdaFunction']:
        """
        The Lambda function associated with this data connector.
        """
        return pulumi.get(self, "lambda_")


@pulumi.output_type
class ComponentTypeDataType(dict):
    """
    An object that specifies the data type of a property.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "allowedValues":
            suggest = "allowed_values"
        elif key == "nestedType":
            suggest = "nested_type"
        elif key == "unitOfMeasure":
            suggest = "unit_of_measure"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ComponentTypeDataType. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ComponentTypeDataType.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ComponentTypeDataType.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 type: 'ComponentTypeDataTypeType',
                 allowed_values: Optional[Sequence['outputs.ComponentTypeDataValue']] = None,
                 nested_type: Optional['outputs.ComponentTypeDataType'] = None,
                 relationship: Optional['outputs.ComponentTypeRelationship'] = None,
                 unit_of_measure: Optional[builtins.str] = None):
        """
        An object that specifies the data type of a property.
        :param 'ComponentTypeDataTypeType' type: The underlying type of the data type.
        :param Sequence['ComponentTypeDataValue'] allowed_values: The allowed values for this data type.
        :param 'ComponentTypeDataType' nested_type: The nested type in the data type.
        :param 'ComponentTypeRelationship' relationship: A relationship that associates a component with another component.
        :param builtins.str unit_of_measure: The unit of measure used in this data type.
        """
        pulumi.set(__self__, "type", type)
        if allowed_values is not None:
            pulumi.set(__self__, "allowed_values", allowed_values)
        if nested_type is not None:
            pulumi.set(__self__, "nested_type", nested_type)
        if relationship is not None:
            pulumi.set(__self__, "relationship", relationship)
        if unit_of_measure is not None:
            pulumi.set(__self__, "unit_of_measure", unit_of_measure)

    @property
    @pulumi.getter
    def type(self) -> 'ComponentTypeDataTypeType':
        """
        The underlying type of the data type.
        """
        return pulumi.get(self, "type")

    @property
    @pulumi.getter(name="allowedValues")
    def allowed_values(self) -> Optional[Sequence['outputs.ComponentTypeDataValue']]:
        """
        The allowed values for this data type.
        """
        return pulumi.get(self, "allowed_values")

    @property
    @pulumi.getter(name="nestedType")
    def nested_type(self) -> Optional['outputs.ComponentTypeDataType']:
        """
        The nested type in the data type.
        """
        return pulumi.get(self, "nested_type")

    @property
    @pulumi.getter
    def relationship(self) -> Optional['outputs.ComponentTypeRelationship']:
        """
        A relationship that associates a component with another component.
        """
        return pulumi.get(self, "relationship")

    @property
    @pulumi.getter(name="unitOfMeasure")
    def unit_of_measure(self) -> Optional[builtins.str]:
        """
        The unit of measure used in this data type.
        """
        return pulumi.get(self, "unit_of_measure")


@pulumi.output_type
class ComponentTypeDataValue(dict):
    """
    An object that specifies a value for a property.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "booleanValue":
            suggest = "boolean_value"
        elif key == "doubleValue":
            suggest = "double_value"
        elif key == "integerValue":
            suggest = "integer_value"
        elif key == "listValue":
            suggest = "list_value"
        elif key == "longValue":
            suggest = "long_value"
        elif key == "mapValue":
            suggest = "map_value"
        elif key == "relationshipValue":
            suggest = "relationship_value"
        elif key == "stringValue":
            suggest = "string_value"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ComponentTypeDataValue. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ComponentTypeDataValue.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ComponentTypeDataValue.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 boolean_value: Optional[builtins.bool] = None,
                 double_value: Optional[builtins.float] = None,
                 expression: Optional[builtins.str] = None,
                 integer_value: Optional[builtins.int] = None,
                 list_value: Optional[Sequence['outputs.ComponentTypeDataValue']] = None,
                 long_value: Optional[builtins.float] = None,
                 map_value: Optional[Mapping[str, 'outputs.ComponentTypeDataValue']] = None,
                 relationship_value: Optional['outputs.ComponentTypeDataValueRelationshipValueProperties'] = None,
                 string_value: Optional[builtins.str] = None):
        """
        An object that specifies a value for a property.
        :param builtins.bool boolean_value: A Boolean value.
        :param builtins.float double_value: A double value.
        :param builtins.str expression: An expression that produces the value.
        :param builtins.int integer_value: An integer value.
        :param Sequence['ComponentTypeDataValue'] list_value: A list of multiple values.
        :param builtins.float long_value: A long value.
        :param Mapping[str, 'ComponentTypeDataValue'] map_value: An object that maps strings to multiple DataValue objects. 
        :param 'ComponentTypeDataValueRelationshipValueProperties' relationship_value: A value that relates a component to another component.
        :param builtins.str string_value: A string value.
        """
        if boolean_value is not None:
            pulumi.set(__self__, "boolean_value", boolean_value)
        if double_value is not None:
            pulumi.set(__self__, "double_value", double_value)
        if expression is not None:
            pulumi.set(__self__, "expression", expression)
        if integer_value is not None:
            pulumi.set(__self__, "integer_value", integer_value)
        if list_value is not None:
            pulumi.set(__self__, "list_value", list_value)
        if long_value is not None:
            pulumi.set(__self__, "long_value", long_value)
        if map_value is not None:
            pulumi.set(__self__, "map_value", map_value)
        if relationship_value is not None:
            pulumi.set(__self__, "relationship_value", relationship_value)
        if string_value is not None:
            pulumi.set(__self__, "string_value", string_value)

    @property
    @pulumi.getter(name="booleanValue")
    def boolean_value(self) -> Optional[builtins.bool]:
        """
        A Boolean value.
        """
        return pulumi.get(self, "boolean_value")

    @property
    @pulumi.getter(name="doubleValue")
    def double_value(self) -> Optional[builtins.float]:
        """
        A double value.
        """
        return pulumi.get(self, "double_value")

    @property
    @pulumi.getter
    def expression(self) -> Optional[builtins.str]:
        """
        An expression that produces the value.
        """
        return pulumi.get(self, "expression")

    @property
    @pulumi.getter(name="integerValue")
    def integer_value(self) -> Optional[builtins.int]:
        """
        An integer value.
        """
        return pulumi.get(self, "integer_value")

    @property
    @pulumi.getter(name="listValue")
    def list_value(self) -> Optional[Sequence['outputs.ComponentTypeDataValue']]:
        """
        A list of multiple values.
        """
        return pulumi.get(self, "list_value")

    @property
    @pulumi.getter(name="longValue")
    def long_value(self) -> Optional[builtins.float]:
        """
        A long value.
        """
        return pulumi.get(self, "long_value")

    @property
    @pulumi.getter(name="mapValue")
    def map_value(self) -> Optional[Mapping[str, 'outputs.ComponentTypeDataValue']]:
        """
        An object that maps strings to multiple DataValue objects. 
        """
        return pulumi.get(self, "map_value")

    @property
    @pulumi.getter(name="relationshipValue")
    def relationship_value(self) -> Optional['outputs.ComponentTypeDataValueRelationshipValueProperties']:
        """
        A value that relates a component to another component.
        """
        return pulumi.get(self, "relationship_value")

    @property
    @pulumi.getter(name="stringValue")
    def string_value(self) -> Optional[builtins.str]:
        """
        A string value.
        """
        return pulumi.get(self, "string_value")


@pulumi.output_type
class ComponentTypeDataValueRelationshipValueProperties(dict):
    """
    A value that relates a component to another component.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "targetComponentName":
            suggest = "target_component_name"
        elif key == "targetEntityId":
            suggest = "target_entity_id"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ComponentTypeDataValueRelationshipValueProperties. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ComponentTypeDataValueRelationshipValueProperties.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ComponentTypeDataValueRelationshipValueProperties.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 target_component_name: Optional[builtins.str] = None,
                 target_entity_id: Optional[builtins.str] = None):
        """
        A value that relates a component to another component.
        """
        if target_component_name is not None:
            pulumi.set(__self__, "target_component_name", target_component_name)
        if target_entity_id is not None:
            pulumi.set(__self__, "target_entity_id", target_entity_id)

    @property
    @pulumi.getter(name="targetComponentName")
    def target_component_name(self) -> Optional[builtins.str]:
        return pulumi.get(self, "target_component_name")

    @property
    @pulumi.getter(name="targetEntityId")
    def target_entity_id(self) -> Optional[builtins.str]:
        return pulumi.get(self, "target_entity_id")


@pulumi.output_type
class ComponentTypeFunction(dict):
    """
    The function of component type.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "implementedBy":
            suggest = "implemented_by"
        elif key == "requiredProperties":
            suggest = "required_properties"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ComponentTypeFunction. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ComponentTypeFunction.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ComponentTypeFunction.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 implemented_by: Optional['outputs.ComponentTypeDataConnector'] = None,
                 required_properties: Optional[Sequence[builtins.str]] = None,
                 scope: Optional['ComponentTypeFunctionScope'] = None):
        """
        The function of component type.
        :param 'ComponentTypeDataConnector' implemented_by: The data connector.
        :param Sequence[builtins.str] required_properties: The required properties of the function.
        :param 'ComponentTypeFunctionScope' scope: The scope of the function.
        """
        if implemented_by is not None:
            pulumi.set(__self__, "implemented_by", implemented_by)
        if required_properties is not None:
            pulumi.set(__self__, "required_properties", required_properties)
        if scope is not None:
            pulumi.set(__self__, "scope", scope)

    @property
    @pulumi.getter(name="implementedBy")
    def implemented_by(self) -> Optional['outputs.ComponentTypeDataConnector']:
        """
        The data connector.
        """
        return pulumi.get(self, "implemented_by")

    @property
    @pulumi.getter(name="requiredProperties")
    def required_properties(self) -> Optional[Sequence[builtins.str]]:
        """
        The required properties of the function.
        """
        return pulumi.get(self, "required_properties")

    @property
    @pulumi.getter
    def scope(self) -> Optional['ComponentTypeFunctionScope']:
        """
        The scope of the function.
        """
        return pulumi.get(self, "scope")


@pulumi.output_type
class ComponentTypeLambdaFunction(dict):
    def __init__(__self__, *,
                 arn: builtins.str):
        pulumi.set(__self__, "arn", arn)

    @property
    @pulumi.getter
    def arn(self) -> builtins.str:
        return pulumi.get(self, "arn")


@pulumi.output_type
class ComponentTypePropertyDefinition(dict):
    """
    An object that sets information about a property.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "dataType":
            suggest = "data_type"
        elif key == "defaultValue":
            suggest = "default_value"
        elif key == "isExternalId":
            suggest = "is_external_id"
        elif key == "isRequiredInEntity":
            suggest = "is_required_in_entity"
        elif key == "isStoredExternally":
            suggest = "is_stored_externally"
        elif key == "isTimeSeries":
            suggest = "is_time_series"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ComponentTypePropertyDefinition. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ComponentTypePropertyDefinition.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ComponentTypePropertyDefinition.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 configurations: Optional[Mapping[str, builtins.str]] = None,
                 data_type: Optional['outputs.ComponentTypeDataType'] = None,
                 default_value: Optional['outputs.ComponentTypeDataValue'] = None,
                 is_external_id: Optional[builtins.bool] = None,
                 is_required_in_entity: Optional[builtins.bool] = None,
                 is_stored_externally: Optional[builtins.bool] = None,
                 is_time_series: Optional[builtins.bool] = None):
        """
        An object that sets information about a property.
        :param Mapping[str, builtins.str] configurations: An object that specifies information about a property.
        :param 'ComponentTypeDataType' data_type: An object that contains information about the data type.
        :param 'ComponentTypeDataValue' default_value: An object that contains the default value.
        :param builtins.bool is_external_id: A Boolean value that specifies whether the property ID comes from an external data store.
        :param builtins.bool is_required_in_entity: A Boolean value that specifies whether the property is required.
        :param builtins.bool is_stored_externally: A Boolean value that specifies whether the property is stored externally.
        :param builtins.bool is_time_series: A Boolean value that specifies whether the property consists of time series data.
        """
        if configurations is not None:
            pulumi.set(__self__, "configurations", configurations)
        if data_type is not None:
            pulumi.set(__self__, "data_type", data_type)
        if default_value is not None:
            pulumi.set(__self__, "default_value", default_value)
        if is_external_id is not None:
            pulumi.set(__self__, "is_external_id", is_external_id)
        if is_required_in_entity is not None:
            pulumi.set(__self__, "is_required_in_entity", is_required_in_entity)
        if is_stored_externally is not None:
            pulumi.set(__self__, "is_stored_externally", is_stored_externally)
        if is_time_series is not None:
            pulumi.set(__self__, "is_time_series", is_time_series)

    @property
    @pulumi.getter
    def configurations(self) -> Optional[Mapping[str, builtins.str]]:
        """
        An object that specifies information about a property.
        """
        return pulumi.get(self, "configurations")

    @property
    @pulumi.getter(name="dataType")
    def data_type(self) -> Optional['outputs.ComponentTypeDataType']:
        """
        An object that contains information about the data type.
        """
        return pulumi.get(self, "data_type")

    @property
    @pulumi.getter(name="defaultValue")
    def default_value(self) -> Optional['outputs.ComponentTypeDataValue']:
        """
        An object that contains the default value.
        """
        return pulumi.get(self, "default_value")

    @property
    @pulumi.getter(name="isExternalId")
    def is_external_id(self) -> Optional[builtins.bool]:
        """
        A Boolean value that specifies whether the property ID comes from an external data store.
        """
        return pulumi.get(self, "is_external_id")

    @property
    @pulumi.getter(name="isRequiredInEntity")
    def is_required_in_entity(self) -> Optional[builtins.bool]:
        """
        A Boolean value that specifies whether the property is required.
        """
        return pulumi.get(self, "is_required_in_entity")

    @property
    @pulumi.getter(name="isStoredExternally")
    def is_stored_externally(self) -> Optional[builtins.bool]:
        """
        A Boolean value that specifies whether the property is stored externally.
        """
        return pulumi.get(self, "is_stored_externally")

    @property
    @pulumi.getter(name="isTimeSeries")
    def is_time_series(self) -> Optional[builtins.bool]:
        """
        A Boolean value that specifies whether the property consists of time series data.
        """
        return pulumi.get(self, "is_time_series")


@pulumi.output_type
class ComponentTypePropertyGroup(dict):
    """
    An object that sets information about a property group.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "groupType":
            suggest = "group_type"
        elif key == "propertyNames":
            suggest = "property_names"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ComponentTypePropertyGroup. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ComponentTypePropertyGroup.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ComponentTypePropertyGroup.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 group_type: Optional['ComponentTypePropertyGroupGroupType'] = None,
                 property_names: Optional[Sequence[builtins.str]] = None):
        """
        An object that sets information about a property group.
        :param 'ComponentTypePropertyGroupGroupType' group_type: The type of property group.
        :param Sequence[builtins.str] property_names: The list of property names in the property group.
        """
        if group_type is not None:
            pulumi.set(__self__, "group_type", group_type)
        if property_names is not None:
            pulumi.set(__self__, "property_names", property_names)

    @property
    @pulumi.getter(name="groupType")
    def group_type(self) -> Optional['ComponentTypePropertyGroupGroupType']:
        """
        The type of property group.
        """
        return pulumi.get(self, "group_type")

    @property
    @pulumi.getter(name="propertyNames")
    def property_names(self) -> Optional[Sequence[builtins.str]]:
        """
        The list of property names in the property group.
        """
        return pulumi.get(self, "property_names")


@pulumi.output_type
class ComponentTypeRelationship(dict):
    """
    The type of the relationship.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "relationshipType":
            suggest = "relationship_type"
        elif key == "targetComponentTypeId":
            suggest = "target_component_type_id"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ComponentTypeRelationship. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ComponentTypeRelationship.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ComponentTypeRelationship.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 relationship_type: Optional[builtins.str] = None,
                 target_component_type_id: Optional[builtins.str] = None):
        """
        The type of the relationship.
        :param builtins.str relationship_type: The type of the relationship.
        :param builtins.str target_component_type_id: The ID of the target component type associated with this relationship.
        """
        if relationship_type is not None:
            pulumi.set(__self__, "relationship_type", relationship_type)
        if target_component_type_id is not None:
            pulumi.set(__self__, "target_component_type_id", target_component_type_id)

    @property
    @pulumi.getter(name="relationshipType")
    def relationship_type(self) -> Optional[builtins.str]:
        """
        The type of the relationship.
        """
        return pulumi.get(self, "relationship_type")

    @property
    @pulumi.getter(name="targetComponentTypeId")
    def target_component_type_id(self) -> Optional[builtins.str]:
        """
        The ID of the target component type associated with this relationship.
        """
        return pulumi.get(self, "target_component_type_id")


@pulumi.output_type
class ComponentTypeStatus(dict):
    def __init__(__self__, *,
                 error: Optional[Any] = None,
                 state: Optional['ComponentTypeStatusState'] = None):
        """
        :param Union[Any, 'ComponentTypeStatusErrorProperties'] error: The component type error.
        :param 'ComponentTypeStatusState' state: The component type status state.
        """
        if error is not None:
            pulumi.set(__self__, "error", error)
        if state is not None:
            pulumi.set(__self__, "state", state)

    @property
    @pulumi.getter
    def error(self) -> Optional[Any]:
        """
        The component type error.
        """
        return pulumi.get(self, "error")

    @property
    @pulumi.getter
    def state(self) -> Optional['ComponentTypeStatusState']:
        """
        The component type status state.
        """
        return pulumi.get(self, "state")


@pulumi.output_type
class ComponentTypeStatusErrorProperties(dict):
    """
    Error object with Message and Code.
    """
    def __init__(__self__, *,
                 code: Optional['ComponentTypeStatusErrorPropertiesCode'] = None,
                 message: Optional[builtins.str] = None):
        """
        Error object with Message and Code.
        """
        if code is not None:
            pulumi.set(__self__, "code", code)
        if message is not None:
            pulumi.set(__self__, "message", message)

    @property
    @pulumi.getter
    def code(self) -> Optional['ComponentTypeStatusErrorPropertiesCode']:
        return pulumi.get(self, "code")

    @property
    @pulumi.getter
    def message(self) -> Optional[builtins.str]:
        return pulumi.get(self, "message")


@pulumi.output_type
class EntityComponent(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "componentName":
            suggest = "component_name"
        elif key == "componentTypeId":
            suggest = "component_type_id"
        elif key == "definedIn":
            suggest = "defined_in"
        elif key == "propertyGroups":
            suggest = "property_groups"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in EntityComponent. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        EntityComponent.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        EntityComponent.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 component_name: Optional[builtins.str] = None,
                 component_type_id: Optional[builtins.str] = None,
                 defined_in: Optional[builtins.str] = None,
                 description: Optional[builtins.str] = None,
                 properties: Optional[Mapping[str, 'outputs.EntityProperty']] = None,
                 property_groups: Optional[Mapping[str, 'outputs.EntityPropertyGroup']] = None,
                 status: Optional['outputs.EntityStatus'] = None):
        """
        :param builtins.str component_name: The name of the component.
        :param builtins.str component_type_id: The ID of the component type.
        :param builtins.str defined_in: The name of the property definition set in the component.
        :param builtins.str description: The description of the component.
        :param Mapping[str, 'EntityProperty'] properties: An object that maps strings to the properties to set in the component type. Each string in the mapping must be unique to this object.
        :param Mapping[str, 'EntityPropertyGroup'] property_groups: An object that maps strings to the property groups to set in the component type. Each string in the mapping must be unique to this object.
        :param 'EntityStatus' status: The current status of the entity.
        """
        if component_name is not None:
            pulumi.set(__self__, "component_name", component_name)
        if component_type_id is not None:
            pulumi.set(__self__, "component_type_id", component_type_id)
        if defined_in is not None:
            pulumi.set(__self__, "defined_in", defined_in)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if properties is not None:
            pulumi.set(__self__, "properties", properties)
        if property_groups is not None:
            pulumi.set(__self__, "property_groups", property_groups)
        if status is not None:
            pulumi.set(__self__, "status", status)

    @property
    @pulumi.getter(name="componentName")
    def component_name(self) -> Optional[builtins.str]:
        """
        The name of the component.
        """
        return pulumi.get(self, "component_name")

    @property
    @pulumi.getter(name="componentTypeId")
    def component_type_id(self) -> Optional[builtins.str]:
        """
        The ID of the component type.
        """
        return pulumi.get(self, "component_type_id")

    @property
    @pulumi.getter(name="definedIn")
    def defined_in(self) -> Optional[builtins.str]:
        """
        The name of the property definition set in the component.
        """
        return pulumi.get(self, "defined_in")

    @property
    @pulumi.getter
    def description(self) -> Optional[builtins.str]:
        """
        The description of the component.
        """
        return pulumi.get(self, "description")

    @property
    @pulumi.getter
    def properties(self) -> Optional[Mapping[str, 'outputs.EntityProperty']]:
        """
        An object that maps strings to the properties to set in the component type. Each string in the mapping must be unique to this object.
        """
        return pulumi.get(self, "properties")

    @property
    @pulumi.getter(name="propertyGroups")
    def property_groups(self) -> Optional[Mapping[str, 'outputs.EntityPropertyGroup']]:
        """
        An object that maps strings to the property groups to set in the component type. Each string in the mapping must be unique to this object.
        """
        return pulumi.get(self, "property_groups")

    @property
    @pulumi.getter
    def status(self) -> Optional['outputs.EntityStatus']:
        """
        The current status of the entity.
        """
        return pulumi.get(self, "status")


@pulumi.output_type
class EntityCompositeComponent(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "componentName":
            suggest = "component_name"
        elif key == "componentPath":
            suggest = "component_path"
        elif key == "componentTypeId":
            suggest = "component_type_id"
        elif key == "propertyGroups":
            suggest = "property_groups"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in EntityCompositeComponent. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        EntityCompositeComponent.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        EntityCompositeComponent.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 component_name: Optional[builtins.str] = None,
                 component_path: Optional[builtins.str] = None,
                 component_type_id: Optional[builtins.str] = None,
                 description: Optional[builtins.str] = None,
                 properties: Optional[Mapping[str, 'outputs.EntityProperty']] = None,
                 property_groups: Optional[Mapping[str, 'outputs.EntityPropertyGroup']] = None,
                 status: Optional['outputs.EntityStatus'] = None):
        """
        :param builtins.str component_name: The name of the component.
        :param builtins.str component_path: The path of the component.
        :param builtins.str component_type_id: The ID of the component type.
        :param builtins.str description: The description of the component.
        :param Mapping[str, 'EntityProperty'] properties: An object that maps strings to the properties to set in the component type. Each string in the mapping must be unique to this object.
        :param Mapping[str, 'EntityPropertyGroup'] property_groups: An object that maps strings to the property groups to set in the component type. Each string in the mapping must be unique to this object.
        :param 'EntityStatus' status: The current status of the component.
        """
        if component_name is not None:
            pulumi.set(__self__, "component_name", component_name)
        if component_path is not None:
            pulumi.set(__self__, "component_path", component_path)
        if component_type_id is not None:
            pulumi.set(__self__, "component_type_id", component_type_id)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if properties is not None:
            pulumi.set(__self__, "properties", properties)
        if property_groups is not None:
            pulumi.set(__self__, "property_groups", property_groups)
        if status is not None:
            pulumi.set(__self__, "status", status)

    @property
    @pulumi.getter(name="componentName")
    def component_name(self) -> Optional[builtins.str]:
        """
        The name of the component.
        """
        return pulumi.get(self, "component_name")

    @property
    @pulumi.getter(name="componentPath")
    def component_path(self) -> Optional[builtins.str]:
        """
        The path of the component.
        """
        return pulumi.get(self, "component_path")

    @property
    @pulumi.getter(name="componentTypeId")
    def component_type_id(self) -> Optional[builtins.str]:
        """
        The ID of the component type.
        """
        return pulumi.get(self, "component_type_id")

    @property
    @pulumi.getter
    def description(self) -> Optional[builtins.str]:
        """
        The description of the component.
        """
        return pulumi.get(self, "description")

    @property
    @pulumi.getter
    def properties(self) -> Optional[Mapping[str, 'outputs.EntityProperty']]:
        """
        An object that maps strings to the properties to set in the component type. Each string in the mapping must be unique to this object.
        """
        return pulumi.get(self, "properties")

    @property
    @pulumi.getter(name="propertyGroups")
    def property_groups(self) -> Optional[Mapping[str, 'outputs.EntityPropertyGroup']]:
        """
        An object that maps strings to the property groups to set in the component type. Each string in the mapping must be unique to this object.
        """
        return pulumi.get(self, "property_groups")

    @property
    @pulumi.getter
    def status(self) -> Optional['outputs.EntityStatus']:
        """
        The current status of the component.
        """
        return pulumi.get(self, "status")


@pulumi.output_type
class EntityDataType(dict):
    """
    An object that specifies the data type of a property.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "allowedValues":
            suggest = "allowed_values"
        elif key == "nestedType":
            suggest = "nested_type"
        elif key == "unitOfMeasure":
            suggest = "unit_of_measure"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in EntityDataType. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        EntityDataType.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        EntityDataType.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 allowed_values: Optional[Sequence['outputs.EntityDataValue']] = None,
                 nested_type: Optional['outputs.EntityDataType'] = None,
                 relationship: Optional['outputs.EntityRelationship'] = None,
                 type: Optional['EntityDataTypeType'] = None,
                 unit_of_measure: Optional[builtins.str] = None):
        """
        An object that specifies the data type of a property.
        :param Sequence['EntityDataValue'] allowed_values: The allowed values for this data type.
        :param 'EntityDataType' nested_type: The nested type in the data type.
        :param 'EntityRelationship' relationship: A relationship that associates a component with another component.
        :param 'EntityDataTypeType' type: The underlying type of the data type.
        :param builtins.str unit_of_measure: The unit of measure used in this data type.
        """
        if allowed_values is not None:
            pulumi.set(__self__, "allowed_values", allowed_values)
        if nested_type is not None:
            pulumi.set(__self__, "nested_type", nested_type)
        if relationship is not None:
            pulumi.set(__self__, "relationship", relationship)
        if type is not None:
            pulumi.set(__self__, "type", type)
        if unit_of_measure is not None:
            pulumi.set(__self__, "unit_of_measure", unit_of_measure)

    @property
    @pulumi.getter(name="allowedValues")
    def allowed_values(self) -> Optional[Sequence['outputs.EntityDataValue']]:
        """
        The allowed values for this data type.
        """
        return pulumi.get(self, "allowed_values")

    @property
    @pulumi.getter(name="nestedType")
    def nested_type(self) -> Optional['outputs.EntityDataType']:
        """
        The nested type in the data type.
        """
        return pulumi.get(self, "nested_type")

    @property
    @pulumi.getter
    def relationship(self) -> Optional['outputs.EntityRelationship']:
        """
        A relationship that associates a component with another component.
        """
        return pulumi.get(self, "relationship")

    @property
    @pulumi.getter
    def type(self) -> Optional['EntityDataTypeType']:
        """
        The underlying type of the data type.
        """
        return pulumi.get(self, "type")

    @property
    @pulumi.getter(name="unitOfMeasure")
    def unit_of_measure(self) -> Optional[builtins.str]:
        """
        The unit of measure used in this data type.
        """
        return pulumi.get(self, "unit_of_measure")


@pulumi.output_type
class EntityDataValue(dict):
    """
    An object that specifies a value for a property.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "booleanValue":
            suggest = "boolean_value"
        elif key == "doubleValue":
            suggest = "double_value"
        elif key == "integerValue":
            suggest = "integer_value"
        elif key == "listValue":
            suggest = "list_value"
        elif key == "longValue":
            suggest = "long_value"
        elif key == "mapValue":
            suggest = "map_value"
        elif key == "relationshipValue":
            suggest = "relationship_value"
        elif key == "stringValue":
            suggest = "string_value"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in EntityDataValue. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        EntityDataValue.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        EntityDataValue.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 boolean_value: Optional[builtins.bool] = None,
                 double_value: Optional[builtins.float] = None,
                 expression: Optional[builtins.str] = None,
                 integer_value: Optional[builtins.int] = None,
                 list_value: Optional[Sequence['outputs.EntityDataValue']] = None,
                 long_value: Optional[builtins.float] = None,
                 map_value: Optional[Mapping[str, 'outputs.EntityDataValue']] = None,
                 relationship_value: Optional['outputs.EntityDataValueRelationshipValueProperties'] = None,
                 string_value: Optional[builtins.str] = None):
        """
        An object that specifies a value for a property.
        :param builtins.bool boolean_value: A Boolean value.
        :param builtins.float double_value: A double value.
        :param builtins.str expression: An expression that produces the value.
        :param builtins.int integer_value: An integer value.
        :param Sequence['EntityDataValue'] list_value: A list of multiple values.
        :param builtins.float long_value: A long value.
        :param Mapping[str, 'EntityDataValue'] map_value: An object that maps strings to multiple DataValue objects.
        :param 'EntityDataValueRelationshipValueProperties' relationship_value: A value that relates a component to another component.
        :param builtins.str string_value: A string value.
        """
        if boolean_value is not None:
            pulumi.set(__self__, "boolean_value", boolean_value)
        if double_value is not None:
            pulumi.set(__self__, "double_value", double_value)
        if expression is not None:
            pulumi.set(__self__, "expression", expression)
        if integer_value is not None:
            pulumi.set(__self__, "integer_value", integer_value)
        if list_value is not None:
            pulumi.set(__self__, "list_value", list_value)
        if long_value is not None:
            pulumi.set(__self__, "long_value", long_value)
        if map_value is not None:
            pulumi.set(__self__, "map_value", map_value)
        if relationship_value is not None:
            pulumi.set(__self__, "relationship_value", relationship_value)
        if string_value is not None:
            pulumi.set(__self__, "string_value", string_value)

    @property
    @pulumi.getter(name="booleanValue")
    def boolean_value(self) -> Optional[builtins.bool]:
        """
        A Boolean value.
        """
        return pulumi.get(self, "boolean_value")

    @property
    @pulumi.getter(name="doubleValue")
    def double_value(self) -> Optional[builtins.float]:
        """
        A double value.
        """
        return pulumi.get(self, "double_value")

    @property
    @pulumi.getter
    def expression(self) -> Optional[builtins.str]:
        """
        An expression that produces the value.
        """
        return pulumi.get(self, "expression")

    @property
    @pulumi.getter(name="integerValue")
    def integer_value(self) -> Optional[builtins.int]:
        """
        An integer value.
        """
        return pulumi.get(self, "integer_value")

    @property
    @pulumi.getter(name="listValue")
    def list_value(self) -> Optional[Sequence['outputs.EntityDataValue']]:
        """
        A list of multiple values.
        """
        return pulumi.get(self, "list_value")

    @property
    @pulumi.getter(name="longValue")
    def long_value(self) -> Optional[builtins.float]:
        """
        A long value.
        """
        return pulumi.get(self, "long_value")

    @property
    @pulumi.getter(name="mapValue")
    def map_value(self) -> Optional[Mapping[str, 'outputs.EntityDataValue']]:
        """
        An object that maps strings to multiple DataValue objects.
        """
        return pulumi.get(self, "map_value")

    @property
    @pulumi.getter(name="relationshipValue")
    def relationship_value(self) -> Optional['outputs.EntityDataValueRelationshipValueProperties']:
        """
        A value that relates a component to another component.
        """
        return pulumi.get(self, "relationship_value")

    @property
    @pulumi.getter(name="stringValue")
    def string_value(self) -> Optional[builtins.str]:
        """
        A string value.
        """
        return pulumi.get(self, "string_value")


@pulumi.output_type
class EntityDataValueRelationshipValueProperties(dict):
    """
    A value that relates a component to another component.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "targetComponentName":
            suggest = "target_component_name"
        elif key == "targetEntityId":
            suggest = "target_entity_id"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in EntityDataValueRelationshipValueProperties. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        EntityDataValueRelationshipValueProperties.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        EntityDataValueRelationshipValueProperties.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 target_component_name: Optional[builtins.str] = None,
                 target_entity_id: Optional[builtins.str] = None):
        """
        A value that relates a component to another component.
        """
        if target_component_name is not None:
            pulumi.set(__self__, "target_component_name", target_component_name)
        if target_entity_id is not None:
            pulumi.set(__self__, "target_entity_id", target_entity_id)

    @property
    @pulumi.getter(name="targetComponentName")
    def target_component_name(self) -> Optional[builtins.str]:
        return pulumi.get(self, "target_component_name")

    @property
    @pulumi.getter(name="targetEntityId")
    def target_entity_id(self) -> Optional[builtins.str]:
        return pulumi.get(self, "target_entity_id")


@pulumi.output_type
class EntityDefinition(dict):
    """
    An object that specifies information about a property definition.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "dataType":
            suggest = "data_type"
        elif key == "defaultValue":
            suggest = "default_value"
        elif key == "isExternalId":
            suggest = "is_external_id"
        elif key == "isFinal":
            suggest = "is_final"
        elif key == "isImported":
            suggest = "is_imported"
        elif key == "isInherited":
            suggest = "is_inherited"
        elif key == "isRequiredInEntity":
            suggest = "is_required_in_entity"
        elif key == "isStoredExternally":
            suggest = "is_stored_externally"
        elif key == "isTimeSeries":
            suggest = "is_time_series"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in EntityDefinition. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        EntityDefinition.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        EntityDefinition.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 configuration: Optional[Mapping[str, builtins.str]] = None,
                 data_type: Optional['outputs.EntityDataType'] = None,
                 default_value: Optional['outputs.EntityDataValue'] = None,
                 is_external_id: Optional[builtins.bool] = None,
                 is_final: Optional[builtins.bool] = None,
                 is_imported: Optional[builtins.bool] = None,
                 is_inherited: Optional[builtins.bool] = None,
                 is_required_in_entity: Optional[builtins.bool] = None,
                 is_stored_externally: Optional[builtins.bool] = None,
                 is_time_series: Optional[builtins.bool] = None):
        """
        An object that specifies information about a property definition.
        :param Mapping[str, builtins.str] configuration: An object that specifies information about a property configuration.
        :param 'EntityDataType' data_type: An object that contains information about the data type.
        :param 'EntityDataValue' default_value: An object that contains the default value.
        :param builtins.bool is_external_id: A Boolean value that specifies whether the property ID comes from an external data store.
        :param builtins.bool is_final: A Boolean value that specifies whether the property definition can be updated.
        :param builtins.bool is_imported: A Boolean value that specifies whether the property definition is imported from an external data store.
        :param builtins.bool is_inherited: A Boolean value that specifies whether the property definition is inherited from a parent entity.
        :param builtins.bool is_required_in_entity: A Boolean value that specifies whether the property is required.
        :param builtins.bool is_stored_externally: A Boolean value that specifies whether the property is stored externally.
        :param builtins.bool is_time_series: A Boolean value that specifies whether the property consists of time series data.
        """
        if configuration is not None:
            pulumi.set(__self__, "configuration", configuration)
        if data_type is not None:
            pulumi.set(__self__, "data_type", data_type)
        if default_value is not None:
            pulumi.set(__self__, "default_value", default_value)
        if is_external_id is not None:
            pulumi.set(__self__, "is_external_id", is_external_id)
        if is_final is not None:
            pulumi.set(__self__, "is_final", is_final)
        if is_imported is not None:
            pulumi.set(__self__, "is_imported", is_imported)
        if is_inherited is not None:
            pulumi.set(__self__, "is_inherited", is_inherited)
        if is_required_in_entity is not None:
            pulumi.set(__self__, "is_required_in_entity", is_required_in_entity)
        if is_stored_externally is not None:
            pulumi.set(__self__, "is_stored_externally", is_stored_externally)
        if is_time_series is not None:
            pulumi.set(__self__, "is_time_series", is_time_series)

    @property
    @pulumi.getter
    def configuration(self) -> Optional[Mapping[str, builtins.str]]:
        """
        An object that specifies information about a property configuration.
        """
        return pulumi.get(self, "configuration")

    @property
    @pulumi.getter(name="dataType")
    def data_type(self) -> Optional['outputs.EntityDataType']:
        """
        An object that contains information about the data type.
        """
        return pulumi.get(self, "data_type")

    @property
    @pulumi.getter(name="defaultValue")
    def default_value(self) -> Optional['outputs.EntityDataValue']:
        """
        An object that contains the default value.
        """
        return pulumi.get(self, "default_value")

    @property
    @pulumi.getter(name="isExternalId")
    def is_external_id(self) -> Optional[builtins.bool]:
        """
        A Boolean value that specifies whether the property ID comes from an external data store.
        """
        return pulumi.get(self, "is_external_id")

    @property
    @pulumi.getter(name="isFinal")
    def is_final(self) -> Optional[builtins.bool]:
        """
        A Boolean value that specifies whether the property definition can be updated.
        """
        return pulumi.get(self, "is_final")

    @property
    @pulumi.getter(name="isImported")
    def is_imported(self) -> Optional[builtins.bool]:
        """
        A Boolean value that specifies whether the property definition is imported from an external data store.
        """
        return pulumi.get(self, "is_imported")

    @property
    @pulumi.getter(name="isInherited")
    def is_inherited(self) -> Optional[builtins.bool]:
        """
        A Boolean value that specifies whether the property definition is inherited from a parent entity.
        """
        return pulumi.get(self, "is_inherited")

    @property
    @pulumi.getter(name="isRequiredInEntity")
    def is_required_in_entity(self) -> Optional[builtins.bool]:
        """
        A Boolean value that specifies whether the property is required.
        """
        return pulumi.get(self, "is_required_in_entity")

    @property
    @pulumi.getter(name="isStoredExternally")
    def is_stored_externally(self) -> Optional[builtins.bool]:
        """
        A Boolean value that specifies whether the property is stored externally.
        """
        return pulumi.get(self, "is_stored_externally")

    @property
    @pulumi.getter(name="isTimeSeries")
    def is_time_series(self) -> Optional[builtins.bool]:
        """
        A Boolean value that specifies whether the property consists of time series data.
        """
        return pulumi.get(self, "is_time_series")


@pulumi.output_type
class EntityProperty(dict):
    """
    An object that specifies information about a property.
    """
    def __init__(__self__, *,
                 definition: Optional['outputs.EntityDefinition'] = None,
                 value: Optional['outputs.EntityDataValue'] = None):
        """
        An object that specifies information about a property.
        :param 'EntityDefinition' definition: The definition of the property.
        :param 'EntityDataValue' value: The value of the property.
        """
        if definition is not None:
            pulumi.set(__self__, "definition", definition)
        if value is not None:
            pulumi.set(__self__, "value", value)

    @property
    @pulumi.getter
    def definition(self) -> Optional['outputs.EntityDefinition']:
        """
        The definition of the property.
        """
        return pulumi.get(self, "definition")

    @property
    @pulumi.getter
    def value(self) -> Optional['outputs.EntityDataValue']:
        """
        The value of the property.
        """
        return pulumi.get(self, "value")


@pulumi.output_type
class EntityPropertyGroup(dict):
    """
    An object that specifies information about a property group.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "groupType":
            suggest = "group_type"
        elif key == "propertyNames":
            suggest = "property_names"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in EntityPropertyGroup. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        EntityPropertyGroup.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        EntityPropertyGroup.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 group_type: Optional['EntityPropertyGroupGroupType'] = None,
                 property_names: Optional[Sequence[builtins.str]] = None):
        """
        An object that specifies information about a property group.
        :param 'EntityPropertyGroupGroupType' group_type: The type of property group.
        :param Sequence[builtins.str] property_names: The list of property names in the property group.
        """
        if group_type is not None:
            pulumi.set(__self__, "group_type", group_type)
        if property_names is not None:
            pulumi.set(__self__, "property_names", property_names)

    @property
    @pulumi.getter(name="groupType")
    def group_type(self) -> Optional['EntityPropertyGroupGroupType']:
        """
        The type of property group.
        """
        return pulumi.get(self, "group_type")

    @property
    @pulumi.getter(name="propertyNames")
    def property_names(self) -> Optional[Sequence[builtins.str]]:
        """
        The list of property names in the property group.
        """
        return pulumi.get(self, "property_names")


@pulumi.output_type
class EntityRelationship(dict):
    """
    The type of the relationship.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "relationshipType":
            suggest = "relationship_type"
        elif key == "targetComponentTypeId":
            suggest = "target_component_type_id"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in EntityRelationship. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        EntityRelationship.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        EntityRelationship.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 relationship_type: Optional[builtins.str] = None,
                 target_component_type_id: Optional[builtins.str] = None):
        """
        The type of the relationship.
        :param builtins.str relationship_type: The type of the relationship.
        :param builtins.str target_component_type_id: The ID of the target component type associated with this relationship.
        """
        if relationship_type is not None:
            pulumi.set(__self__, "relationship_type", relationship_type)
        if target_component_type_id is not None:
            pulumi.set(__self__, "target_component_type_id", target_component_type_id)

    @property
    @pulumi.getter(name="relationshipType")
    def relationship_type(self) -> Optional[builtins.str]:
        """
        The type of the relationship.
        """
        return pulumi.get(self, "relationship_type")

    @property
    @pulumi.getter(name="targetComponentTypeId")
    def target_component_type_id(self) -> Optional[builtins.str]:
        """
        The ID of the target component type associated with this relationship.
        """
        return pulumi.get(self, "target_component_type_id")


@pulumi.output_type
class EntityStatus(dict):
    def __init__(__self__, *,
                 error: Optional[Any] = None,
                 state: Optional['EntityStatusState'] = None):
        if error is not None:
            pulumi.set(__self__, "error", error)
        if state is not None:
            pulumi.set(__self__, "state", state)

    @property
    @pulumi.getter
    def error(self) -> Optional[Any]:
        return pulumi.get(self, "error")

    @property
    @pulumi.getter
    def state(self) -> Optional['EntityStatusState']:
        return pulumi.get(self, "state")


@pulumi.output_type
class EntityStatusErrorProperties(dict):
    """
    Error object with Message and Code.
    """
    def __init__(__self__, *,
                 code: Optional['EntityStatusErrorPropertiesCode'] = None,
                 message: Optional[builtins.str] = None):
        """
        Error object with Message and Code.
        """
        if code is not None:
            pulumi.set(__self__, "code", code)
        if message is not None:
            pulumi.set(__self__, "message", message)

    @property
    @pulumi.getter
    def code(self) -> Optional['EntityStatusErrorPropertiesCode']:
        return pulumi.get(self, "code")

    @property
    @pulumi.getter
    def message(self) -> Optional[builtins.str]:
        return pulumi.get(self, "message")


