# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs
from ._enums import *

__all__ = [
    'AccessPolicyIamRole',
    'AccessPolicyIamUser',
    'AccessPolicyIdentity',
    'AccessPolicyPortal',
    'AccessPolicyProject',
    'AccessPolicyResource',
    'AccessPolicyUser',
    'AlarmsProperties',
    'AssetHierarchy',
    'AssetModelAttribute',
    'AssetModelCompositeModel',
    'AssetModelExpressionVariable',
    'AssetModelHierarchy',
    'AssetModelMetric',
    'AssetModelMetricWindow',
    'AssetModelProperty',
    'AssetModelPropertyPathDefinition',
    'AssetModelPropertyType',
    'AssetModelTransform',
    'AssetModelTumblingWindow',
    'AssetModelVariableValue',
    'AssetProperty',
    'DatasetKendraSourceDetail',
    'DatasetSource',
    'DatasetSourceDetail',
    'GatewayCapabilitySummary',
    'GatewayGreengrassV2',
    'GatewayPlatform',
    'GatewaySiemensIe',
    'PortalTypeEntry',
]

@pulumi.output_type
class AccessPolicyIamRole(dict):
    """
    Contains information for an IAM role identity in an access policy.
    """
    def __init__(__self__, *,
                 arn: Optional[builtins.str] = None):
        """
        Contains information for an IAM role identity in an access policy.
        :param builtins.str arn: The ARN of the IAM role.
        """
        if arn is not None:
            pulumi.set(__self__, "arn", arn)

    @property
    @pulumi.getter
    def arn(self) -> Optional[builtins.str]:
        """
        The ARN of the IAM role.
        """
        return pulumi.get(self, "arn")


@pulumi.output_type
class AccessPolicyIamUser(dict):
    """
    Contains information for an IAM user identity in an access policy.
    """
    def __init__(__self__, *,
                 arn: Optional[builtins.str] = None):
        """
        Contains information for an IAM user identity in an access policy.
        :param builtins.str arn: The ARN of the IAM user.
        """
        if arn is not None:
            pulumi.set(__self__, "arn", arn)

    @property
    @pulumi.getter
    def arn(self) -> Optional[builtins.str]:
        """
        The ARN of the IAM user.
        """
        return pulumi.get(self, "arn")


@pulumi.output_type
class AccessPolicyIdentity(dict):
    """
    The identity for this access policy. Choose either an SSO user or group or an IAM user or role.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "iamRole":
            suggest = "iam_role"
        elif key == "iamUser":
            suggest = "iam_user"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in AccessPolicyIdentity. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        AccessPolicyIdentity.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        AccessPolicyIdentity.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 iam_role: Optional['outputs.AccessPolicyIamRole'] = None,
                 iam_user: Optional['outputs.AccessPolicyIamUser'] = None,
                 user: Optional['outputs.AccessPolicyUser'] = None):
        """
        The identity for this access policy. Choose either an SSO user or group or an IAM user or role.
        :param 'AccessPolicyIamRole' iam_role: An IAM role identity.
        :param 'AccessPolicyIamUser' iam_user: An IAM user identity.
        :param 'AccessPolicyUser' user: An IAM Identity Center user identity.
        """
        if iam_role is not None:
            pulumi.set(__self__, "iam_role", iam_role)
        if iam_user is not None:
            pulumi.set(__self__, "iam_user", iam_user)
        if user is not None:
            pulumi.set(__self__, "user", user)

    @property
    @pulumi.getter(name="iamRole")
    def iam_role(self) -> Optional['outputs.AccessPolicyIamRole']:
        """
        An IAM role identity.
        """
        return pulumi.get(self, "iam_role")

    @property
    @pulumi.getter(name="iamUser")
    def iam_user(self) -> Optional['outputs.AccessPolicyIamUser']:
        """
        An IAM user identity.
        """
        return pulumi.get(self, "iam_user")

    @property
    @pulumi.getter
    def user(self) -> Optional['outputs.AccessPolicyUser']:
        """
        An IAM Identity Center user identity.
        """
        return pulumi.get(self, "user")


@pulumi.output_type
class AccessPolicyPortal(dict):
    """
    A portal resource.
    """
    def __init__(__self__, *,
                 id: Optional[builtins.str] = None):
        """
        A portal resource.
        :param builtins.str id: The ID of the portal.
        """
        if id is not None:
            pulumi.set(__self__, "id", id)

    @property
    @pulumi.getter
    def id(self) -> Optional[builtins.str]:
        """
        The ID of the portal.
        """
        return pulumi.get(self, "id")


@pulumi.output_type
class AccessPolicyProject(dict):
    """
    A project resource.
    """
    def __init__(__self__, *,
                 id: Optional[builtins.str] = None):
        """
        A project resource.
        :param builtins.str id: The ID of the project.
        """
        if id is not None:
            pulumi.set(__self__, "id", id)

    @property
    @pulumi.getter
    def id(self) -> Optional[builtins.str]:
        """
        The ID of the project.
        """
        return pulumi.get(self, "id")


@pulumi.output_type
class AccessPolicyResource(dict):
    """
    The AWS IoT SiteWise Monitor resource for this access policy. Choose either portal or project but not both.
    """
    def __init__(__self__, *,
                 portal: Optional['outputs.AccessPolicyPortal'] = None,
                 project: Optional['outputs.AccessPolicyProject'] = None):
        """
        The AWS IoT SiteWise Monitor resource for this access policy. Choose either portal or project but not both.
        :param 'AccessPolicyPortal' portal: Identifies an AWS IoT SiteWise Monitor portal.
        :param 'AccessPolicyProject' project: Identifies a specific AWS IoT SiteWise Monitor project.
        """
        if portal is not None:
            pulumi.set(__self__, "portal", portal)
        if project is not None:
            pulumi.set(__self__, "project", project)

    @property
    @pulumi.getter
    def portal(self) -> Optional['outputs.AccessPolicyPortal']:
        """
        Identifies an AWS IoT SiteWise Monitor portal.
        """
        return pulumi.get(self, "portal")

    @property
    @pulumi.getter
    def project(self) -> Optional['outputs.AccessPolicyProject']:
        """
        Identifies a specific AWS IoT SiteWise Monitor project.
        """
        return pulumi.get(self, "project")


@pulumi.output_type
class AccessPolicyUser(dict):
    """
    Contains information for a user identity in an access policy.
    """
    def __init__(__self__, *,
                 id: Optional[builtins.str] = None):
        """
        Contains information for a user identity in an access policy.
        :param builtins.str id: The AWS SSO ID of the user.
        """
        if id is not None:
            pulumi.set(__self__, "id", id)

    @property
    @pulumi.getter
    def id(self) -> Optional[builtins.str]:
        """
        The AWS SSO ID of the user.
        """
        return pulumi.get(self, "id")


@pulumi.output_type
class AlarmsProperties(dict):
    """
    Contains the configuration information of an alarm created in an AWS IoT SiteWise Monitor portal. You can use the alarm to monitor an asset property and get notified when the asset property value is outside a specified range.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "alarmRoleArn":
            suggest = "alarm_role_arn"
        elif key == "notificationLambdaArn":
            suggest = "notification_lambda_arn"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in AlarmsProperties. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        AlarmsProperties.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        AlarmsProperties.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 alarm_role_arn: Optional[builtins.str] = None,
                 notification_lambda_arn: Optional[builtins.str] = None):
        """
        Contains the configuration information of an alarm created in an AWS IoT SiteWise Monitor portal. You can use the alarm to monitor an asset property and get notified when the asset property value is outside a specified range.
        :param builtins.str alarm_role_arn: The ARN of the IAM role that allows the alarm to perform actions and access AWS resources and services, such as AWS IoT Events.
        :param builtins.str notification_lambda_arn: The ARN of the AWS Lambda function that manages alarm notifications. For more information, see Managing alarm notifications in the AWS IoT Events Developer Guide.
        """
        if alarm_role_arn is not None:
            pulumi.set(__self__, "alarm_role_arn", alarm_role_arn)
        if notification_lambda_arn is not None:
            pulumi.set(__self__, "notification_lambda_arn", notification_lambda_arn)

    @property
    @pulumi.getter(name="alarmRoleArn")
    def alarm_role_arn(self) -> Optional[builtins.str]:
        """
        The ARN of the IAM role that allows the alarm to perform actions and access AWS resources and services, such as AWS IoT Events.
        """
        return pulumi.get(self, "alarm_role_arn")

    @property
    @pulumi.getter(name="notificationLambdaArn")
    def notification_lambda_arn(self) -> Optional[builtins.str]:
        """
        The ARN of the AWS Lambda function that manages alarm notifications. For more information, see Managing alarm notifications in the AWS IoT Events Developer Guide.
        """
        return pulumi.get(self, "notification_lambda_arn")


@pulumi.output_type
class AssetHierarchy(dict):
    """
    A hierarchy specifies allowed parent/child asset relationships.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "childAssetId":
            suggest = "child_asset_id"
        elif key == "externalId":
            suggest = "external_id"
        elif key == "logicalId":
            suggest = "logical_id"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in AssetHierarchy. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        AssetHierarchy.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        AssetHierarchy.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 child_asset_id: builtins.str,
                 external_id: Optional[builtins.str] = None,
                 id: Optional[builtins.str] = None,
                 logical_id: Optional[builtins.str] = None):
        """
        A hierarchy specifies allowed parent/child asset relationships.
        :param builtins.str child_asset_id: The ID of the child asset to be associated.
        :param builtins.str external_id: String-friendly customer provided external ID
        :param builtins.str id: Customer provided actual UUID for property
        :param builtins.str logical_id: The LogicalID of a hierarchy in the parent asset's model.
        """
        pulumi.set(__self__, "child_asset_id", child_asset_id)
        if external_id is not None:
            pulumi.set(__self__, "external_id", external_id)
        if id is not None:
            pulumi.set(__self__, "id", id)
        if logical_id is not None:
            pulumi.set(__self__, "logical_id", logical_id)

    @property
    @pulumi.getter(name="childAssetId")
    def child_asset_id(self) -> builtins.str:
        """
        The ID of the child asset to be associated.
        """
        return pulumi.get(self, "child_asset_id")

    @property
    @pulumi.getter(name="externalId")
    def external_id(self) -> Optional[builtins.str]:
        """
        String-friendly customer provided external ID
        """
        return pulumi.get(self, "external_id")

    @property
    @pulumi.getter
    def id(self) -> Optional[builtins.str]:
        """
        Customer provided actual UUID for property
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter(name="logicalId")
    def logical_id(self) -> Optional[builtins.str]:
        """
        The LogicalID of a hierarchy in the parent asset's model.
        """
        return pulumi.get(self, "logical_id")


@pulumi.output_type
class AssetModelAttribute(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "defaultValue":
            suggest = "default_value"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in AssetModelAttribute. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        AssetModelAttribute.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        AssetModelAttribute.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 default_value: Optional[builtins.str] = None):
        """
        :param builtins.str default_value: The default value of the asset model property attribute. All assets that you create from the asset model contain this attribute value. You can update an attribute's value after you create an asset. For more information, see [Updating attribute values](https://docs.aws.amazon.com/iot-sitewise/latest/userguide/update-attribute-values.html) in the *AWS IoT SiteWise User Guide* .
        """
        if default_value is not None:
            pulumi.set(__self__, "default_value", default_value)

    @property
    @pulumi.getter(name="defaultValue")
    def default_value(self) -> Optional[builtins.str]:
        """
        The default value of the asset model property attribute. All assets that you create from the asset model contain this attribute value. You can update an attribute's value after you create an asset. For more information, see [Updating attribute values](https://docs.aws.amazon.com/iot-sitewise/latest/userguide/update-attribute-values.html) in the *AWS IoT SiteWise User Guide* .
        """
        return pulumi.get(self, "default_value")


@pulumi.output_type
class AssetModelCompositeModel(dict):
    """
    Contains a composite model definition in an asset model. This composite model definition is applied to all assets created from the asset model.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "composedAssetModelId":
            suggest = "composed_asset_model_id"
        elif key == "compositeModelProperties":
            suggest = "composite_model_properties"
        elif key == "externalId":
            suggest = "external_id"
        elif key == "parentAssetModelCompositeModelExternalId":
            suggest = "parent_asset_model_composite_model_external_id"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in AssetModelCompositeModel. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        AssetModelCompositeModel.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        AssetModelCompositeModel.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 name: builtins.str,
                 type: builtins.str,
                 composed_asset_model_id: Optional[builtins.str] = None,
                 composite_model_properties: Optional[Sequence['outputs.AssetModelProperty']] = None,
                 description: Optional[builtins.str] = None,
                 external_id: Optional[builtins.str] = None,
                 id: Optional[builtins.str] = None,
                 parent_asset_model_composite_model_external_id: Optional[builtins.str] = None,
                 path: Optional[Sequence[builtins.str]] = None):
        """
        Contains a composite model definition in an asset model. This composite model definition is applied to all assets created from the asset model.
        :param builtins.str name: A unique, friendly name for the asset composite model.
        :param builtins.str type: The type of the composite model. For alarm composite models, this type is AWS/ALARM
        :param builtins.str composed_asset_model_id: The component model ID for which the composite model is composed of
        :param Sequence['AssetModelProperty'] composite_model_properties: The property definitions of the asset model. You can specify up to 200 properties per asset model.
        :param builtins.str description: A description for the asset composite model.
        :param builtins.str external_id: The External ID of the composite model
        :param builtins.str id: The Actual ID of the composite model
        :param builtins.str parent_asset_model_composite_model_external_id: The parent composite model External ID
        :param Sequence[builtins.str] path: The path of the composite model. This is only for derived composite models
        """
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "type", type)
        if composed_asset_model_id is not None:
            pulumi.set(__self__, "composed_asset_model_id", composed_asset_model_id)
        if composite_model_properties is not None:
            pulumi.set(__self__, "composite_model_properties", composite_model_properties)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if external_id is not None:
            pulumi.set(__self__, "external_id", external_id)
        if id is not None:
            pulumi.set(__self__, "id", id)
        if parent_asset_model_composite_model_external_id is not None:
            pulumi.set(__self__, "parent_asset_model_composite_model_external_id", parent_asset_model_composite_model_external_id)
        if path is not None:
            pulumi.set(__self__, "path", path)

    @property
    @pulumi.getter
    def name(self) -> builtins.str:
        """
        A unique, friendly name for the asset composite model.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def type(self) -> builtins.str:
        """
        The type of the composite model. For alarm composite models, this type is AWS/ALARM
        """
        return pulumi.get(self, "type")

    @property
    @pulumi.getter(name="composedAssetModelId")
    def composed_asset_model_id(self) -> Optional[builtins.str]:
        """
        The component model ID for which the composite model is composed of
        """
        return pulumi.get(self, "composed_asset_model_id")

    @property
    @pulumi.getter(name="compositeModelProperties")
    def composite_model_properties(self) -> Optional[Sequence['outputs.AssetModelProperty']]:
        """
        The property definitions of the asset model. You can specify up to 200 properties per asset model.
        """
        return pulumi.get(self, "composite_model_properties")

    @property
    @pulumi.getter
    def description(self) -> Optional[builtins.str]:
        """
        A description for the asset composite model.
        """
        return pulumi.get(self, "description")

    @property
    @pulumi.getter(name="externalId")
    def external_id(self) -> Optional[builtins.str]:
        """
        The External ID of the composite model
        """
        return pulumi.get(self, "external_id")

    @property
    @pulumi.getter
    def id(self) -> Optional[builtins.str]:
        """
        The Actual ID of the composite model
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter(name="parentAssetModelCompositeModelExternalId")
    def parent_asset_model_composite_model_external_id(self) -> Optional[builtins.str]:
        """
        The parent composite model External ID
        """
        return pulumi.get(self, "parent_asset_model_composite_model_external_id")

    @property
    @pulumi.getter
    def path(self) -> Optional[Sequence[builtins.str]]:
        """
        The path of the composite model. This is only for derived composite models
        """
        return pulumi.get(self, "path")


@pulumi.output_type
class AssetModelExpressionVariable(dict):
    def __init__(__self__, *,
                 name: builtins.str,
                 value: 'outputs.AssetModelVariableValue'):
        """
        :param builtins.str name: The friendly name of the variable to be used in the expression.
        :param 'AssetModelVariableValue' value: The variable that identifies an asset property from which to use values.
        """
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "value", value)

    @property
    @pulumi.getter
    def name(self) -> builtins.str:
        """
        The friendly name of the variable to be used in the expression.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def value(self) -> 'outputs.AssetModelVariableValue':
        """
        The variable that identifies an asset property from which to use values.
        """
        return pulumi.get(self, "value")


@pulumi.output_type
class AssetModelHierarchy(dict):
    """
    Contains information about an asset model hierarchy.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "childAssetModelId":
            suggest = "child_asset_model_id"
        elif key == "externalId":
            suggest = "external_id"
        elif key == "logicalId":
            suggest = "logical_id"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in AssetModelHierarchy. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        AssetModelHierarchy.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        AssetModelHierarchy.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 child_asset_model_id: builtins.str,
                 name: builtins.str,
                 external_id: Optional[builtins.str] = None,
                 id: Optional[builtins.str] = None,
                 logical_id: Optional[builtins.str] = None):
        """
        Contains information about an asset model hierarchy.
        :param builtins.str child_asset_model_id: The ID of the asset model. All assets in this hierarchy must be instances of the child AssetModelId asset model.
        :param builtins.str name: The name of the asset model hierarchy.
        :param builtins.str external_id: Customer provided external ID for hierarchy
        :param builtins.str id: Customer provided actual ID for hierarchy
        :param builtins.str logical_id: Customer provided logical ID for hierarchy.
        """
        pulumi.set(__self__, "child_asset_model_id", child_asset_model_id)
        pulumi.set(__self__, "name", name)
        if external_id is not None:
            pulumi.set(__self__, "external_id", external_id)
        if id is not None:
            pulumi.set(__self__, "id", id)
        if logical_id is not None:
            pulumi.set(__self__, "logical_id", logical_id)

    @property
    @pulumi.getter(name="childAssetModelId")
    def child_asset_model_id(self) -> builtins.str:
        """
        The ID of the asset model. All assets in this hierarchy must be instances of the child AssetModelId asset model.
        """
        return pulumi.get(self, "child_asset_model_id")

    @property
    @pulumi.getter
    def name(self) -> builtins.str:
        """
        The name of the asset model hierarchy.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="externalId")
    def external_id(self) -> Optional[builtins.str]:
        """
        Customer provided external ID for hierarchy
        """
        return pulumi.get(self, "external_id")

    @property
    @pulumi.getter
    def id(self) -> Optional[builtins.str]:
        """
        Customer provided actual ID for hierarchy
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter(name="logicalId")
    def logical_id(self) -> Optional[builtins.str]:
        """
        Customer provided logical ID for hierarchy.
        """
        return pulumi.get(self, "logical_id")


@pulumi.output_type
class AssetModelMetric(dict):
    def __init__(__self__, *,
                 expression: builtins.str,
                 variables: Sequence['outputs.AssetModelExpressionVariable'],
                 window: 'outputs.AssetModelMetricWindow'):
        """
        :param builtins.str expression: The mathematical expression that defines the metric aggregation function. You can specify up to 10 functions per expression.
        :param Sequence['AssetModelExpressionVariable'] variables: The list of variables used in the expression.
        :param 'AssetModelMetricWindow' window: The window (time interval) over which AWS IoT SiteWise computes the metric's aggregation expression
        """
        pulumi.set(__self__, "expression", expression)
        pulumi.set(__self__, "variables", variables)
        pulumi.set(__self__, "window", window)

    @property
    @pulumi.getter
    def expression(self) -> builtins.str:
        """
        The mathematical expression that defines the metric aggregation function. You can specify up to 10 functions per expression.
        """
        return pulumi.get(self, "expression")

    @property
    @pulumi.getter
    def variables(self) -> Sequence['outputs.AssetModelExpressionVariable']:
        """
        The list of variables used in the expression.
        """
        return pulumi.get(self, "variables")

    @property
    @pulumi.getter
    def window(self) -> 'outputs.AssetModelMetricWindow':
        """
        The window (time interval) over which AWS IoT SiteWise computes the metric's aggregation expression
        """
        return pulumi.get(self, "window")


@pulumi.output_type
class AssetModelMetricWindow(dict):
    """
    Contains a time interval window used for data aggregate computations (for example, average, sum, count, and so on).
    """
    def __init__(__self__, *,
                 tumbling: Optional['outputs.AssetModelTumblingWindow'] = None):
        """
        Contains a time interval window used for data aggregate computations (for example, average, sum, count, and so on).
        :param 'AssetModelTumblingWindow' tumbling: The tumbling time interval window.
        """
        if tumbling is not None:
            pulumi.set(__self__, "tumbling", tumbling)

    @property
    @pulumi.getter
    def tumbling(self) -> Optional['outputs.AssetModelTumblingWindow']:
        """
        The tumbling time interval window.
        """
        return pulumi.get(self, "tumbling")


@pulumi.output_type
class AssetModelProperty(dict):
    """
    Contains information about an asset model property.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "dataType":
            suggest = "data_type"
        elif key == "dataTypeSpec":
            suggest = "data_type_spec"
        elif key == "externalId":
            suggest = "external_id"
        elif key == "logicalId":
            suggest = "logical_id"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in AssetModelProperty. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        AssetModelProperty.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        AssetModelProperty.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 data_type: 'AssetModelDataType',
                 name: builtins.str,
                 type: 'outputs.AssetModelPropertyType',
                 data_type_spec: Optional['AssetModelDataTypeSpec'] = None,
                 external_id: Optional[builtins.str] = None,
                 id: Optional[builtins.str] = None,
                 logical_id: Optional[builtins.str] = None,
                 unit: Optional[builtins.str] = None):
        """
        Contains information about an asset model property.
        :param 'AssetModelDataType' data_type: The data type of the asset model property.
        :param builtins.str name: The name of the asset model property.
        :param 'AssetModelPropertyType' type: The property type
        :param 'AssetModelDataTypeSpec' data_type_spec: The data type of the structure for this property.
        :param builtins.str external_id: The External ID of the Asset Model Property
        :param builtins.str id: The ID of the Asset Model Property
        :param builtins.str logical_id: Customer provided Logical ID for property.
        :param builtins.str unit: The unit of the asset model property, such as Newtons or RPM.
        """
        pulumi.set(__self__, "data_type", data_type)
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "type", type)
        if data_type_spec is not None:
            pulumi.set(__self__, "data_type_spec", data_type_spec)
        if external_id is not None:
            pulumi.set(__self__, "external_id", external_id)
        if id is not None:
            pulumi.set(__self__, "id", id)
        if logical_id is not None:
            pulumi.set(__self__, "logical_id", logical_id)
        if unit is not None:
            pulumi.set(__self__, "unit", unit)

    @property
    @pulumi.getter(name="dataType")
    def data_type(self) -> 'AssetModelDataType':
        """
        The data type of the asset model property.
        """
        return pulumi.get(self, "data_type")

    @property
    @pulumi.getter
    def name(self) -> builtins.str:
        """
        The name of the asset model property.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def type(self) -> 'outputs.AssetModelPropertyType':
        """
        The property type
        """
        return pulumi.get(self, "type")

    @property
    @pulumi.getter(name="dataTypeSpec")
    def data_type_spec(self) -> Optional['AssetModelDataTypeSpec']:
        """
        The data type of the structure for this property.
        """
        return pulumi.get(self, "data_type_spec")

    @property
    @pulumi.getter(name="externalId")
    def external_id(self) -> Optional[builtins.str]:
        """
        The External ID of the Asset Model Property
        """
        return pulumi.get(self, "external_id")

    @property
    @pulumi.getter
    def id(self) -> Optional[builtins.str]:
        """
        The ID of the Asset Model Property
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter(name="logicalId")
    def logical_id(self) -> Optional[builtins.str]:
        """
        Customer provided Logical ID for property.
        """
        return pulumi.get(self, "logical_id")

    @property
    @pulumi.getter
    def unit(self) -> Optional[builtins.str]:
        """
        The unit of the asset model property, such as Newtons or RPM.
        """
        return pulumi.get(self, "unit")


@pulumi.output_type
class AssetModelPropertyPathDefinition(dict):
    """
    The definition for property path which is used to reference properties in transforms/metrics
    """
    def __init__(__self__, *,
                 name: builtins.str):
        """
        The definition for property path which is used to reference properties in transforms/metrics
        :param builtins.str name: The name of the property
        """
        pulumi.set(__self__, "name", name)

    @property
    @pulumi.getter
    def name(self) -> builtins.str:
        """
        The name of the property
        """
        return pulumi.get(self, "name")


@pulumi.output_type
class AssetModelPropertyType(dict):
    """
    Contains a property type, which can be one of attribute, measurement, metric, or transform.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "typeName":
            suggest = "type_name"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in AssetModelPropertyType. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        AssetModelPropertyType.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        AssetModelPropertyType.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 type_name: 'AssetModelTypeName',
                 attribute: Optional['outputs.AssetModelAttribute'] = None,
                 metric: Optional['outputs.AssetModelMetric'] = None,
                 transform: Optional['outputs.AssetModelTransform'] = None):
        """
        Contains a property type, which can be one of attribute, measurement, metric, or transform.
        :param 'AssetModelTypeName' type_name: The type of property type, which can be one of `Attribute` , `Measurement` , `Metric` , or `Transform` .
        :param 'AssetModelAttribute' attribute: Specifies an asset attribute property. An attribute generally contains static information, such as the serial number of an [IIoT](https://docs.aws.amazon.com/https://en.wikipedia.org/wiki/Internet_of_things#Industrial_applications) wind turbine.
        :param 'AssetModelMetric' metric: Specifies an asset metric property. A metric contains a mathematical expression that uses aggregate functions to process all input data points over a time interval and output a single data point, such as to calculate the average hourly temperature.
        :param 'AssetModelTransform' transform: Specifies an asset transform property. A transform contains a mathematical expression that maps a property's data points from one form to another, such as a unit conversion from Celsius to Fahrenheit.
        """
        pulumi.set(__self__, "type_name", type_name)
        if attribute is not None:
            pulumi.set(__self__, "attribute", attribute)
        if metric is not None:
            pulumi.set(__self__, "metric", metric)
        if transform is not None:
            pulumi.set(__self__, "transform", transform)

    @property
    @pulumi.getter(name="typeName")
    def type_name(self) -> 'AssetModelTypeName':
        """
        The type of property type, which can be one of `Attribute` , `Measurement` , `Metric` , or `Transform` .
        """
        return pulumi.get(self, "type_name")

    @property
    @pulumi.getter
    def attribute(self) -> Optional['outputs.AssetModelAttribute']:
        """
        Specifies an asset attribute property. An attribute generally contains static information, such as the serial number of an [IIoT](https://docs.aws.amazon.com/https://en.wikipedia.org/wiki/Internet_of_things#Industrial_applications) wind turbine.
        """
        return pulumi.get(self, "attribute")

    @property
    @pulumi.getter
    def metric(self) -> Optional['outputs.AssetModelMetric']:
        """
        Specifies an asset metric property. A metric contains a mathematical expression that uses aggregate functions to process all input data points over a time interval and output a single data point, such as to calculate the average hourly temperature.
        """
        return pulumi.get(self, "metric")

    @property
    @pulumi.getter
    def transform(self) -> Optional['outputs.AssetModelTransform']:
        """
        Specifies an asset transform property. A transform contains a mathematical expression that maps a property's data points from one form to another, such as a unit conversion from Celsius to Fahrenheit.
        """
        return pulumi.get(self, "transform")


@pulumi.output_type
class AssetModelTransform(dict):
    def __init__(__self__, *,
                 expression: builtins.str,
                 variables: Sequence['outputs.AssetModelExpressionVariable']):
        """
        :param builtins.str expression: The mathematical expression that defines the transformation function. You can specify up to 10 functions per expression.
        :param Sequence['AssetModelExpressionVariable'] variables: The list of variables used in the expression.
        """
        pulumi.set(__self__, "expression", expression)
        pulumi.set(__self__, "variables", variables)

    @property
    @pulumi.getter
    def expression(self) -> builtins.str:
        """
        The mathematical expression that defines the transformation function. You can specify up to 10 functions per expression.
        """
        return pulumi.get(self, "expression")

    @property
    @pulumi.getter
    def variables(self) -> Sequence['outputs.AssetModelExpressionVariable']:
        """
        The list of variables used in the expression.
        """
        return pulumi.get(self, "variables")


@pulumi.output_type
class AssetModelTumblingWindow(dict):
    """
    Contains a tumbling window, which is a repeating fixed-sized, non-overlapping, and contiguous time interval. This window is used in metric and aggregation computations.
    """
    def __init__(__self__, *,
                 interval: builtins.str,
                 offset: Optional[builtins.str] = None):
        """
        Contains a tumbling window, which is a repeating fixed-sized, non-overlapping, and contiguous time interval. This window is used in metric and aggregation computations.
        :param builtins.str interval: The time interval for the tumbling window. The interval time must be between 1 minute and 1 week.
               
               AWS IoT SiteWise computes the `1w` interval the end of Sunday at midnight each week (UTC), the `1d` interval at the end of each day at midnight (UTC), the `1h` interval at the end of each hour, and so on.
               
               When AWS IoT SiteWise aggregates data points for metric computations, the start of each interval is exclusive and the end of each interval is inclusive. AWS IoT SiteWise places the computed data point at the end of the interval.
        :param builtins.str offset: The offset for the tumbling window. The `offset` parameter accepts the following:
               
               - The offset time.
               
               For example, if you specify `18h` for `offset` and `1d` for `interval` , AWS IoT SiteWise aggregates data in one of the following ways:
               
               - If you create the metric before or at 6 PM (UTC), you get the first aggregation result at 6 PM (UTC) on the day when you create the metric.
               - If you create the metric after 6 PM (UTC), you get the first aggregation result at 6 PM (UTC) the next day.
               - The ISO 8601 format.
               
               For example, if you specify `PT18H` for `offset` and `1d` for `interval` , AWS IoT SiteWise aggregates data in one of the following ways:
               
               - If you create the metric before or at 6 PM (UTC), you get the first aggregation result at 6 PM (UTC) on the day when you create the metric.
               - If you create the metric after 6 PM (UTC), you get the first aggregation result at 6 PM (UTC) the next day.
               - The 24-hour clock.
               
               For example, if you specify `00:03:00` for `offset` , `5m` for `interval` , and you create the metric at 2 PM (UTC), you get the first aggregation result at 2:03 PM (UTC). You get the second aggregation result at 2:08 PM (UTC).
               - The offset time zone.
               
               For example, if you specify `2021-07-23T18:00-08` for `offset` and `1d` for `interval` , AWS IoT SiteWise aggregates data in one of the following ways:
               
               - If you create the metric before or at 6 PM (PST), you get the first aggregation result at 6 PM (PST) on the day when you create the metric.
               - If you create the metric after 6 PM (PST), you get the first aggregation result at 6 PM (PST) the next day.
        """
        pulumi.set(__self__, "interval", interval)
        if offset is not None:
            pulumi.set(__self__, "offset", offset)

    @property
    @pulumi.getter
    def interval(self) -> builtins.str:
        """
        The time interval for the tumbling window. The interval time must be between 1 minute and 1 week.

        AWS IoT SiteWise computes the `1w` interval the end of Sunday at midnight each week (UTC), the `1d` interval at the end of each day at midnight (UTC), the `1h` interval at the end of each hour, and so on.

        When AWS IoT SiteWise aggregates data points for metric computations, the start of each interval is exclusive and the end of each interval is inclusive. AWS IoT SiteWise places the computed data point at the end of the interval.
        """
        return pulumi.get(self, "interval")

    @property
    @pulumi.getter
    def offset(self) -> Optional[builtins.str]:
        """
        The offset for the tumbling window. The `offset` parameter accepts the following:

        - The offset time.

        For example, if you specify `18h` for `offset` and `1d` for `interval` , AWS IoT SiteWise aggregates data in one of the following ways:

        - If you create the metric before or at 6 PM (UTC), you get the first aggregation result at 6 PM (UTC) on the day when you create the metric.
        - If you create the metric after 6 PM (UTC), you get the first aggregation result at 6 PM (UTC) the next day.
        - The ISO 8601 format.

        For example, if you specify `PT18H` for `offset` and `1d` for `interval` , AWS IoT SiteWise aggregates data in one of the following ways:

        - If you create the metric before or at 6 PM (UTC), you get the first aggregation result at 6 PM (UTC) on the day when you create the metric.
        - If you create the metric after 6 PM (UTC), you get the first aggregation result at 6 PM (UTC) the next day.
        - The 24-hour clock.

        For example, if you specify `00:03:00` for `offset` , `5m` for `interval` , and you create the metric at 2 PM (UTC), you get the first aggregation result at 2:03 PM (UTC). You get the second aggregation result at 2:08 PM (UTC).
        - The offset time zone.

        For example, if you specify `2021-07-23T18:00-08` for `offset` and `1d` for `interval` , AWS IoT SiteWise aggregates data in one of the following ways:

        - If you create the metric before or at 6 PM (PST), you get the first aggregation result at 6 PM (PST) on the day when you create the metric.
        - If you create the metric after 6 PM (PST), you get the first aggregation result at 6 PM (PST) the next day.
        """
        return pulumi.get(self, "offset")


@pulumi.output_type
class AssetModelVariableValue(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "hierarchyExternalId":
            suggest = "hierarchy_external_id"
        elif key == "hierarchyId":
            suggest = "hierarchy_id"
        elif key == "hierarchyLogicalId":
            suggest = "hierarchy_logical_id"
        elif key == "propertyExternalId":
            suggest = "property_external_id"
        elif key == "propertyId":
            suggest = "property_id"
        elif key == "propertyLogicalId":
            suggest = "property_logical_id"
        elif key == "propertyPath":
            suggest = "property_path"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in AssetModelVariableValue. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        AssetModelVariableValue.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        AssetModelVariableValue.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 hierarchy_external_id: Optional[builtins.str] = None,
                 hierarchy_id: Optional[builtins.str] = None,
                 hierarchy_logical_id: Optional[builtins.str] = None,
                 property_external_id: Optional[builtins.str] = None,
                 property_id: Optional[builtins.str] = None,
                 property_logical_id: Optional[builtins.str] = None,
                 property_path: Optional[Sequence['outputs.AssetModelPropertyPathDefinition']] = None):
        """
        :param builtins.str hierarchy_external_id: The External ID of the hierarchy that is trying to be referenced
        :param builtins.str hierarchy_id: The ID of the hierarchy that is trying to be referenced
        :param builtins.str hierarchy_logical_id: The `LogicalID` of the hierarchy to query for the `PropertyLogicalID` .
               
               You use a `hierarchyLogicalID` instead of a model ID because you can have several hierarchies using the same model and therefore the same property. For example, you might have separately grouped assets that come from the same asset model. For more information, see [Defining relationships between asset models (hierarchies)](https://docs.aws.amazon.com/iot-sitewise/latest/userguide/asset-hierarchies.html) in the *AWS IoT SiteWise User Guide* .
        :param builtins.str property_external_id: The External ID of the property that is trying to be referenced
        :param builtins.str property_id: The ID of the property that is trying to be referenced
        :param builtins.str property_logical_id: The `LogicalID` of the property that is being referenced.
        :param Sequence['AssetModelPropertyPathDefinition'] property_path: The path of the property that is trying to be referenced
        """
        if hierarchy_external_id is not None:
            pulumi.set(__self__, "hierarchy_external_id", hierarchy_external_id)
        if hierarchy_id is not None:
            pulumi.set(__self__, "hierarchy_id", hierarchy_id)
        if hierarchy_logical_id is not None:
            pulumi.set(__self__, "hierarchy_logical_id", hierarchy_logical_id)
        if property_external_id is not None:
            pulumi.set(__self__, "property_external_id", property_external_id)
        if property_id is not None:
            pulumi.set(__self__, "property_id", property_id)
        if property_logical_id is not None:
            pulumi.set(__self__, "property_logical_id", property_logical_id)
        if property_path is not None:
            pulumi.set(__self__, "property_path", property_path)

    @property
    @pulumi.getter(name="hierarchyExternalId")
    def hierarchy_external_id(self) -> Optional[builtins.str]:
        """
        The External ID of the hierarchy that is trying to be referenced
        """
        return pulumi.get(self, "hierarchy_external_id")

    @property
    @pulumi.getter(name="hierarchyId")
    def hierarchy_id(self) -> Optional[builtins.str]:
        """
        The ID of the hierarchy that is trying to be referenced
        """
        return pulumi.get(self, "hierarchy_id")

    @property
    @pulumi.getter(name="hierarchyLogicalId")
    def hierarchy_logical_id(self) -> Optional[builtins.str]:
        """
        The `LogicalID` of the hierarchy to query for the `PropertyLogicalID` .

        You use a `hierarchyLogicalID` instead of a model ID because you can have several hierarchies using the same model and therefore the same property. For example, you might have separately grouped assets that come from the same asset model. For more information, see [Defining relationships between asset models (hierarchies)](https://docs.aws.amazon.com/iot-sitewise/latest/userguide/asset-hierarchies.html) in the *AWS IoT SiteWise User Guide* .
        """
        return pulumi.get(self, "hierarchy_logical_id")

    @property
    @pulumi.getter(name="propertyExternalId")
    def property_external_id(self) -> Optional[builtins.str]:
        """
        The External ID of the property that is trying to be referenced
        """
        return pulumi.get(self, "property_external_id")

    @property
    @pulumi.getter(name="propertyId")
    def property_id(self) -> Optional[builtins.str]:
        """
        The ID of the property that is trying to be referenced
        """
        return pulumi.get(self, "property_id")

    @property
    @pulumi.getter(name="propertyLogicalId")
    def property_logical_id(self) -> Optional[builtins.str]:
        """
        The `LogicalID` of the property that is being referenced.
        """
        return pulumi.get(self, "property_logical_id")

    @property
    @pulumi.getter(name="propertyPath")
    def property_path(self) -> Optional[Sequence['outputs.AssetModelPropertyPathDefinition']]:
        """
        The path of the property that is trying to be referenced
        """
        return pulumi.get(self, "property_path")


@pulumi.output_type
class AssetProperty(dict):
    """
    The asset property's definition, alias, unit, and notification state.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "externalId":
            suggest = "external_id"
        elif key == "logicalId":
            suggest = "logical_id"
        elif key == "notificationState":
            suggest = "notification_state"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in AssetProperty. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        AssetProperty.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        AssetProperty.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 alias: Optional[builtins.str] = None,
                 external_id: Optional[builtins.str] = None,
                 id: Optional[builtins.str] = None,
                 logical_id: Optional[builtins.str] = None,
                 notification_state: Optional['AssetPropertyNotificationState'] = None,
                 unit: Optional[builtins.str] = None):
        """
        The asset property's definition, alias, unit, and notification state.
        :param builtins.str alias: The property alias that identifies the property.
        :param builtins.str external_id: String-friendly customer provided external ID
        :param builtins.str id: Customer provided actual UUID for property
        :param builtins.str logical_id: Customer provided ID for property.
        :param 'AssetPropertyNotificationState' notification_state: The MQTT notification state (ENABLED or DISABLED) for this asset property.
        :param builtins.str unit: The unit of measure (such as Newtons or RPM) of the asset property. If you don't specify a value for this parameter, the service uses the value of the assetModelProperty in the asset model.
        """
        if alias is not None:
            pulumi.set(__self__, "alias", alias)
        if external_id is not None:
            pulumi.set(__self__, "external_id", external_id)
        if id is not None:
            pulumi.set(__self__, "id", id)
        if logical_id is not None:
            pulumi.set(__self__, "logical_id", logical_id)
        if notification_state is not None:
            pulumi.set(__self__, "notification_state", notification_state)
        if unit is not None:
            pulumi.set(__self__, "unit", unit)

    @property
    @pulumi.getter
    def alias(self) -> Optional[builtins.str]:
        """
        The property alias that identifies the property.
        """
        return pulumi.get(self, "alias")

    @property
    @pulumi.getter(name="externalId")
    def external_id(self) -> Optional[builtins.str]:
        """
        String-friendly customer provided external ID
        """
        return pulumi.get(self, "external_id")

    @property
    @pulumi.getter
    def id(self) -> Optional[builtins.str]:
        """
        Customer provided actual UUID for property
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter(name="logicalId")
    def logical_id(self) -> Optional[builtins.str]:
        """
        Customer provided ID for property.
        """
        return pulumi.get(self, "logical_id")

    @property
    @pulumi.getter(name="notificationState")
    def notification_state(self) -> Optional['AssetPropertyNotificationState']:
        """
        The MQTT notification state (ENABLED or DISABLED) for this asset property.
        """
        return pulumi.get(self, "notification_state")

    @property
    @pulumi.getter
    def unit(self) -> Optional[builtins.str]:
        """
        The unit of measure (such as Newtons or RPM) of the asset property. If you don't specify a value for this parameter, the service uses the value of the assetModelProperty in the asset model.
        """
        return pulumi.get(self, "unit")


@pulumi.output_type
class DatasetKendraSourceDetail(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "knowledgeBaseArn":
            suggest = "knowledge_base_arn"
        elif key == "roleArn":
            suggest = "role_arn"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in DatasetKendraSourceDetail. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        DatasetKendraSourceDetail.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        DatasetKendraSourceDetail.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 knowledge_base_arn: builtins.str,
                 role_arn: builtins.str):
        """
        :param builtins.str knowledge_base_arn: The knowledgeBaseArn details for the Kendra dataset source.
        :param builtins.str role_arn: The roleARN details for the Kendra dataset source.
        """
        pulumi.set(__self__, "knowledge_base_arn", knowledge_base_arn)
        pulumi.set(__self__, "role_arn", role_arn)

    @property
    @pulumi.getter(name="knowledgeBaseArn")
    def knowledge_base_arn(self) -> builtins.str:
        """
        The knowledgeBaseArn details for the Kendra dataset source.
        """
        return pulumi.get(self, "knowledge_base_arn")

    @property
    @pulumi.getter(name="roleArn")
    def role_arn(self) -> builtins.str:
        """
        The roleARN details for the Kendra dataset source.
        """
        return pulumi.get(self, "role_arn")


@pulumi.output_type
class DatasetSource(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "sourceFormat":
            suggest = "source_format"
        elif key == "sourceType":
            suggest = "source_type"
        elif key == "sourceDetail":
            suggest = "source_detail"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in DatasetSource. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        DatasetSource.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        DatasetSource.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 source_format: 'DatasetSourceSourceFormat',
                 source_type: 'DatasetSourceSourceType',
                 source_detail: Optional['outputs.DatasetSourceDetail'] = None):
        """
        :param 'DatasetSourceSourceFormat' source_format: The format of the dataset source associated with the dataset.
        :param 'DatasetSourceSourceType' source_type: The type of data source for the dataset.
        :param 'DatasetSourceDetail' source_detail: The details of the dataset source associated with the dataset.
        """
        pulumi.set(__self__, "source_format", source_format)
        pulumi.set(__self__, "source_type", source_type)
        if source_detail is not None:
            pulumi.set(__self__, "source_detail", source_detail)

    @property
    @pulumi.getter(name="sourceFormat")
    def source_format(self) -> 'DatasetSourceSourceFormat':
        """
        The format of the dataset source associated with the dataset.
        """
        return pulumi.get(self, "source_format")

    @property
    @pulumi.getter(name="sourceType")
    def source_type(self) -> 'DatasetSourceSourceType':
        """
        The type of data source for the dataset.
        """
        return pulumi.get(self, "source_type")

    @property
    @pulumi.getter(name="sourceDetail")
    def source_detail(self) -> Optional['outputs.DatasetSourceDetail']:
        """
        The details of the dataset source associated with the dataset.
        """
        return pulumi.get(self, "source_detail")


@pulumi.output_type
class DatasetSourceDetail(dict):
    def __init__(__self__, *,
                 kendra: Optional['outputs.DatasetKendraSourceDetail'] = None):
        """
        :param 'DatasetKendraSourceDetail' kendra: Contains details about the Kendra dataset source.
        """
        if kendra is not None:
            pulumi.set(__self__, "kendra", kendra)

    @property
    @pulumi.getter
    def kendra(self) -> Optional['outputs.DatasetKendraSourceDetail']:
        """
        Contains details about the Kendra dataset source.
        """
        return pulumi.get(self, "kendra")


@pulumi.output_type
class GatewayCapabilitySummary(dict):
    """
    Contains a summary of a gateway capability configuration.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "capabilityNamespace":
            suggest = "capability_namespace"
        elif key == "capabilityConfiguration":
            suggest = "capability_configuration"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in GatewayCapabilitySummary. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        GatewayCapabilitySummary.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        GatewayCapabilitySummary.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 capability_namespace: builtins.str,
                 capability_configuration: Optional[builtins.str] = None):
        """
        Contains a summary of a gateway capability configuration.
        :param builtins.str capability_namespace: The namespace of the capability configuration. For example, if you configure OPC-UA sources from the AWS IoT SiteWise console, your OPC-UA capability configuration has the namespace `iotsitewise:opcuacollector:version` , where `version` is a number such as `1` .
        :param builtins.str capability_configuration: The JSON document that defines the configuration for the gateway capability. For more information, see [Configuring data sources (CLI)](https://docs.aws.amazon.com/iot-sitewise/latest/userguide/configure-sources.html#configure-source-cli) in the *AWS IoT SiteWise User Guide* .
        """
        pulumi.set(__self__, "capability_namespace", capability_namespace)
        if capability_configuration is not None:
            pulumi.set(__self__, "capability_configuration", capability_configuration)

    @property
    @pulumi.getter(name="capabilityNamespace")
    def capability_namespace(self) -> builtins.str:
        """
        The namespace of the capability configuration. For example, if you configure OPC-UA sources from the AWS IoT SiteWise console, your OPC-UA capability configuration has the namespace `iotsitewise:opcuacollector:version` , where `version` is a number such as `1` .
        """
        return pulumi.get(self, "capability_namespace")

    @property
    @pulumi.getter(name="capabilityConfiguration")
    def capability_configuration(self) -> Optional[builtins.str]:
        """
        The JSON document that defines the configuration for the gateway capability. For more information, see [Configuring data sources (CLI)](https://docs.aws.amazon.com/iot-sitewise/latest/userguide/configure-sources.html#configure-source-cli) in the *AWS IoT SiteWise User Guide* .
        """
        return pulumi.get(self, "capability_configuration")


@pulumi.output_type
class GatewayGreengrassV2(dict):
    """
    Contains the CoreDeviceThingName of AWS IoT Greengrass Group V2 that the gateway runs on.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "coreDeviceThingName":
            suggest = "core_device_thing_name"
        elif key == "coreDeviceOperatingSystem":
            suggest = "core_device_operating_system"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in GatewayGreengrassV2. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        GatewayGreengrassV2.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        GatewayGreengrassV2.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 core_device_thing_name: builtins.str,
                 core_device_operating_system: Optional['GatewayGreengrassV2CoreDeviceOperatingSystem'] = None):
        """
        Contains the CoreDeviceThingName of AWS IoT Greengrass Group V2 that the gateway runs on.
        :param builtins.str core_device_thing_name: The name of the CoreDevice in GreenGrass V2.
        :param 'GatewayGreengrassV2CoreDeviceOperatingSystem' core_device_operating_system: The operating system of the core device in AWS IoT Greengrass V2.
        """
        pulumi.set(__self__, "core_device_thing_name", core_device_thing_name)
        if core_device_operating_system is not None:
            pulumi.set(__self__, "core_device_operating_system", core_device_operating_system)

    @property
    @pulumi.getter(name="coreDeviceThingName")
    def core_device_thing_name(self) -> builtins.str:
        """
        The name of the CoreDevice in GreenGrass V2.
        """
        return pulumi.get(self, "core_device_thing_name")

    @property
    @pulumi.getter(name="coreDeviceOperatingSystem")
    def core_device_operating_system(self) -> Optional['GatewayGreengrassV2CoreDeviceOperatingSystem']:
        """
        The operating system of the core device in AWS IoT Greengrass V2.
        """
        return pulumi.get(self, "core_device_operating_system")


@pulumi.output_type
class GatewayPlatform(dict):
    """
    Contains a gateway's platform information.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "greengrassV2":
            suggest = "greengrass_v2"
        elif key == "siemensIe":
            suggest = "siemens_ie"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in GatewayPlatform. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        GatewayPlatform.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        GatewayPlatform.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 greengrass_v2: Optional['outputs.GatewayGreengrassV2'] = None,
                 siemens_ie: Optional['outputs.GatewaySiemensIe'] = None):
        """
        Contains a gateway's platform information.
        :param 'GatewayGreengrassV2' greengrass_v2: A gateway that runs on AWS IoT Greengrass V2.
        :param 'GatewaySiemensIe' siemens_ie: A gateway that runs on Siemens Industrial Edge.
        """
        if greengrass_v2 is not None:
            pulumi.set(__self__, "greengrass_v2", greengrass_v2)
        if siemens_ie is not None:
            pulumi.set(__self__, "siemens_ie", siemens_ie)

    @property
    @pulumi.getter(name="greengrassV2")
    def greengrass_v2(self) -> Optional['outputs.GatewayGreengrassV2']:
        """
        A gateway that runs on AWS IoT Greengrass V2.
        """
        return pulumi.get(self, "greengrass_v2")

    @property
    @pulumi.getter(name="siemensIe")
    def siemens_ie(self) -> Optional['outputs.GatewaySiemensIe']:
        """
        A gateway that runs on Siemens Industrial Edge.
        """
        return pulumi.get(self, "siemens_ie")


@pulumi.output_type
class GatewaySiemensIe(dict):
    """
    Contains the IotCoreThingName of AWS IoT Thing that the gateway runs on.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "iotCoreThingName":
            suggest = "iot_core_thing_name"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in GatewaySiemensIe. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        GatewaySiemensIe.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        GatewaySiemensIe.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 iot_core_thing_name: builtins.str):
        """
        Contains the IotCoreThingName of AWS IoT Thing that the gateway runs on.
        :param builtins.str iot_core_thing_name: The name of the IoT Core Thing.
        """
        pulumi.set(__self__, "iot_core_thing_name", iot_core_thing_name)

    @property
    @pulumi.getter(name="iotCoreThingName")
    def iot_core_thing_name(self) -> builtins.str:
        """
        The name of the IoT Core Thing.
        """
        return pulumi.get(self, "iot_core_thing_name")


@pulumi.output_type
class PortalTypeEntry(dict):
    """
    Container associated a certain PortalType.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "portalTools":
            suggest = "portal_tools"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in PortalTypeEntry. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        PortalTypeEntry.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        PortalTypeEntry.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 portal_tools: Sequence[builtins.str]):
        """
        Container associated a certain PortalType.
        :param Sequence[builtins.str] portal_tools: The array of tools associated with the specified portal type. The possible values are `ASSISTANT` and `DASHBOARD` .
        """
        pulumi.set(__self__, "portal_tools", portal_tools)

    @property
    @pulumi.getter(name="portalTools")
    def portal_tools(self) -> Sequence[builtins.str]:
        """
        The array of tools associated with the specified portal type. The possible values are `ASSISTANT` and `DASHBOARD` .
        """
        return pulumi.get(self, "portal_tools")


