# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs
from .. import outputs as _root_outputs
from ._enums import *

__all__ = [
    'GetDatasetResult',
    'AwaitableGetDatasetResult',
    'get_dataset',
    'get_dataset_output',
]

@pulumi.output_type
class GetDatasetResult:
    def __init__(__self__, dataset_arn=None, dataset_description=None, dataset_id=None, dataset_name=None, dataset_source=None, tags=None):
        if dataset_arn and not isinstance(dataset_arn, str):
            raise TypeError("Expected argument 'dataset_arn' to be a str")
        pulumi.set(__self__, "dataset_arn", dataset_arn)
        if dataset_description and not isinstance(dataset_description, str):
            raise TypeError("Expected argument 'dataset_description' to be a str")
        pulumi.set(__self__, "dataset_description", dataset_description)
        if dataset_id and not isinstance(dataset_id, str):
            raise TypeError("Expected argument 'dataset_id' to be a str")
        pulumi.set(__self__, "dataset_id", dataset_id)
        if dataset_name and not isinstance(dataset_name, str):
            raise TypeError("Expected argument 'dataset_name' to be a str")
        pulumi.set(__self__, "dataset_name", dataset_name)
        if dataset_source and not isinstance(dataset_source, dict):
            raise TypeError("Expected argument 'dataset_source' to be a dict")
        pulumi.set(__self__, "dataset_source", dataset_source)
        if tags and not isinstance(tags, list):
            raise TypeError("Expected argument 'tags' to be a list")
        pulumi.set(__self__, "tags", tags)

    @property
    @pulumi.getter(name="datasetArn")
    def dataset_arn(self) -> Optional[builtins.str]:
        """
        The ARN of the dataset.
        """
        return pulumi.get(self, "dataset_arn")

    @property
    @pulumi.getter(name="datasetDescription")
    def dataset_description(self) -> Optional[builtins.str]:
        """
        A description about the dataset, and its functionality.
        """
        return pulumi.get(self, "dataset_description")

    @property
    @pulumi.getter(name="datasetId")
    def dataset_id(self) -> Optional[builtins.str]:
        """
        The ID of the dataset.
        """
        return pulumi.get(self, "dataset_id")

    @property
    @pulumi.getter(name="datasetName")
    def dataset_name(self) -> Optional[builtins.str]:
        """
        The name of the dataset.
        """
        return pulumi.get(self, "dataset_name")

    @property
    @pulumi.getter(name="datasetSource")
    def dataset_source(self) -> Optional['outputs.DatasetSource']:
        """
        The data source for the dataset.
        """
        return pulumi.get(self, "dataset_source")

    @property
    @pulumi.getter
    def tags(self) -> Optional[Sequence['_root_outputs.Tag']]:
        """
        An array of key-value pairs to apply to this resource.
        """
        return pulumi.get(self, "tags")


class AwaitableGetDatasetResult(GetDatasetResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetDatasetResult(
            dataset_arn=self.dataset_arn,
            dataset_description=self.dataset_description,
            dataset_id=self.dataset_id,
            dataset_name=self.dataset_name,
            dataset_source=self.dataset_source,
            tags=self.tags)


def get_dataset(dataset_id: Optional[builtins.str] = None,
                opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetDatasetResult:
    """
    Resource schema for AWS::IoTSiteWise::Dataset.


    :param builtins.str dataset_id: The ID of the dataset.
    """
    __args__ = dict()
    __args__['datasetId'] = dataset_id
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('aws-native:iotsitewise:getDataset', __args__, opts=opts, typ=GetDatasetResult).value

    return AwaitableGetDatasetResult(
        dataset_arn=pulumi.get(__ret__, 'dataset_arn'),
        dataset_description=pulumi.get(__ret__, 'dataset_description'),
        dataset_id=pulumi.get(__ret__, 'dataset_id'),
        dataset_name=pulumi.get(__ret__, 'dataset_name'),
        dataset_source=pulumi.get(__ret__, 'dataset_source'),
        tags=pulumi.get(__ret__, 'tags'))
def get_dataset_output(dataset_id: Optional[pulumi.Input[builtins.str]] = None,
                       opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetDatasetResult]:
    """
    Resource schema for AWS::IoTSiteWise::Dataset.


    :param builtins.str dataset_id: The ID of the dataset.
    """
    __args__ = dict()
    __args__['datasetId'] = dataset_id
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('aws-native:iotsitewise:getDataset', __args__, opts=opts, typ=GetDatasetResult)
    return __ret__.apply(lambda __response__: GetDatasetResult(
        dataset_arn=pulumi.get(__response__, 'dataset_arn'),
        dataset_description=pulumi.get(__response__, 'dataset_description'),
        dataset_id=pulumi.get(__response__, 'dataset_id'),
        dataset_name=pulumi.get(__response__, 'dataset_name'),
        dataset_source=pulumi.get(__response__, 'dataset_source'),
        tags=pulumi.get(__response__, 'tags')))
