# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs
from .. import _inputs as _root_inputs
from .. import outputs as _root_outputs
from ._enums import *
from ._inputs import *

__all__ = ['DatasetArgs', 'Dataset']

@pulumi.input_type
class DatasetArgs:
    def __init__(__self__, *,
                 dataset_source: pulumi.Input['DatasetSourceArgs'],
                 dataset_description: Optional[pulumi.Input[builtins.str]] = None,
                 dataset_name: Optional[pulumi.Input[builtins.str]] = None,
                 tags: Optional[pulumi.Input[Sequence[pulumi.Input['_root_inputs.TagArgs']]]] = None):
        """
        The set of arguments for constructing a Dataset resource.
        :param pulumi.Input['DatasetSourceArgs'] dataset_source: The data source for the dataset.
        :param pulumi.Input[builtins.str] dataset_description: A description about the dataset, and its functionality.
        :param pulumi.Input[builtins.str] dataset_name: The name of the dataset.
        :param pulumi.Input[Sequence[pulumi.Input['_root_inputs.TagArgs']]] tags: An array of key-value pairs to apply to this resource.
        """
        pulumi.set(__self__, "dataset_source", dataset_source)
        if dataset_description is not None:
            pulumi.set(__self__, "dataset_description", dataset_description)
        if dataset_name is not None:
            pulumi.set(__self__, "dataset_name", dataset_name)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)

    @property
    @pulumi.getter(name="datasetSource")
    def dataset_source(self) -> pulumi.Input['DatasetSourceArgs']:
        """
        The data source for the dataset.
        """
        return pulumi.get(self, "dataset_source")

    @dataset_source.setter
    def dataset_source(self, value: pulumi.Input['DatasetSourceArgs']):
        pulumi.set(self, "dataset_source", value)

    @property
    @pulumi.getter(name="datasetDescription")
    def dataset_description(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        A description about the dataset, and its functionality.
        """
        return pulumi.get(self, "dataset_description")

    @dataset_description.setter
    def dataset_description(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "dataset_description", value)

    @property
    @pulumi.getter(name="datasetName")
    def dataset_name(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The name of the dataset.
        """
        return pulumi.get(self, "dataset_name")

    @dataset_name.setter
    def dataset_name(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "dataset_name", value)

    @property
    @pulumi.getter
    def tags(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['_root_inputs.TagArgs']]]]:
        """
        An array of key-value pairs to apply to this resource.
        """
        return pulumi.get(self, "tags")

    @tags.setter
    def tags(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['_root_inputs.TagArgs']]]]):
        pulumi.set(self, "tags", value)


@pulumi.type_token("aws-native:iotsitewise:Dataset")
class Dataset(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 dataset_description: Optional[pulumi.Input[builtins.str]] = None,
                 dataset_name: Optional[pulumi.Input[builtins.str]] = None,
                 dataset_source: Optional[pulumi.Input[Union['DatasetSourceArgs', 'DatasetSourceArgsDict']]] = None,
                 tags: Optional[pulumi.Input[Sequence[pulumi.Input[Union['_root_inputs.TagArgs', '_root_inputs.TagArgsDict']]]]] = None,
                 __props__=None):
        """
        Resource schema for AWS::IoTSiteWise::Dataset.

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[builtins.str] dataset_description: A description about the dataset, and its functionality.
        :param pulumi.Input[builtins.str] dataset_name: The name of the dataset.
        :param pulumi.Input[Union['DatasetSourceArgs', 'DatasetSourceArgsDict']] dataset_source: The data source for the dataset.
        :param pulumi.Input[Sequence[pulumi.Input[Union['_root_inputs.TagArgs', '_root_inputs.TagArgsDict']]]] tags: An array of key-value pairs to apply to this resource.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: DatasetArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Resource schema for AWS::IoTSiteWise::Dataset.

        :param str resource_name: The name of the resource.
        :param DatasetArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(DatasetArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 dataset_description: Optional[pulumi.Input[builtins.str]] = None,
                 dataset_name: Optional[pulumi.Input[builtins.str]] = None,
                 dataset_source: Optional[pulumi.Input[Union['DatasetSourceArgs', 'DatasetSourceArgsDict']]] = None,
                 tags: Optional[pulumi.Input[Sequence[pulumi.Input[Union['_root_inputs.TagArgs', '_root_inputs.TagArgsDict']]]]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = DatasetArgs.__new__(DatasetArgs)

            __props__.__dict__["dataset_description"] = dataset_description
            __props__.__dict__["dataset_name"] = dataset_name
            if dataset_source is None and not opts.urn:
                raise TypeError("Missing required property 'dataset_source'")
            __props__.__dict__["dataset_source"] = dataset_source
            __props__.__dict__["tags"] = tags
            __props__.__dict__["dataset_arn"] = None
            __props__.__dict__["dataset_id"] = None
        super(Dataset, __self__).__init__(
            'aws-native:iotsitewise:Dataset',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None) -> 'Dataset':
        """
        Get an existing Dataset resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = DatasetArgs.__new__(DatasetArgs)

        __props__.__dict__["dataset_arn"] = None
        __props__.__dict__["dataset_description"] = None
        __props__.__dict__["dataset_id"] = None
        __props__.__dict__["dataset_name"] = None
        __props__.__dict__["dataset_source"] = None
        __props__.__dict__["tags"] = None
        return Dataset(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter(name="datasetArn")
    def dataset_arn(self) -> pulumi.Output[builtins.str]:
        """
        The ARN of the dataset.
        """
        return pulumi.get(self, "dataset_arn")

    @property
    @pulumi.getter(name="datasetDescription")
    def dataset_description(self) -> pulumi.Output[Optional[builtins.str]]:
        """
        A description about the dataset, and its functionality.
        """
        return pulumi.get(self, "dataset_description")

    @property
    @pulumi.getter(name="datasetId")
    def dataset_id(self) -> pulumi.Output[builtins.str]:
        """
        The ID of the dataset.
        """
        return pulumi.get(self, "dataset_id")

    @property
    @pulumi.getter(name="datasetName")
    def dataset_name(self) -> pulumi.Output[builtins.str]:
        """
        The name of the dataset.
        """
        return pulumi.get(self, "dataset_name")

    @property
    @pulumi.getter(name="datasetSource")
    def dataset_source(self) -> pulumi.Output['outputs.DatasetSource']:
        """
        The data source for the dataset.
        """
        return pulumi.get(self, "dataset_source")

    @property
    @pulumi.getter
    def tags(self) -> pulumi.Output[Optional[Sequence['_root_outputs.Tag']]]:
        """
        An array of key-value pairs to apply to this resource.
        """
        return pulumi.get(self, "tags")

