# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs
from ._enums import *

__all__ = [
    'AlarmModelAcknowledgeFlow',
    'AlarmModelAlarmAction',
    'AlarmModelAlarmCapabilities',
    'AlarmModelAlarmEventActions',
    'AlarmModelAlarmRule',
    'AlarmModelAssetPropertyTimestamp',
    'AlarmModelAssetPropertyValue',
    'AlarmModelAssetPropertyVariant',
    'AlarmModelDynamoDBv2',
    'AlarmModelDynamoDb',
    'AlarmModelFirehose',
    'AlarmModelInitializationConfiguration',
    'AlarmModelIotEvents',
    'AlarmModelIotSiteWise',
    'AlarmModelIotTopicPublish',
    'AlarmModelLambda',
    'AlarmModelPayload',
    'AlarmModelSimpleRule',
    'AlarmModelSns',
    'AlarmModelSqs',
    'DetectorModelAction',
    'DetectorModelAssetPropertyTimestamp',
    'DetectorModelAssetPropertyValue',
    'DetectorModelAssetPropertyVariant',
    'DetectorModelClearTimer',
    'DetectorModelDefinition',
    'DetectorModelDynamoDBv2',
    'DetectorModelDynamoDb',
    'DetectorModelEvent',
    'DetectorModelFirehose',
    'DetectorModelIotEvents',
    'DetectorModelIotSiteWise',
    'DetectorModelIotTopicPublish',
    'DetectorModelLambda',
    'DetectorModelOnEnter',
    'DetectorModelOnExit',
    'DetectorModelOnInput',
    'DetectorModelPayload',
    'DetectorModelResetTimer',
    'DetectorModelSetTimer',
    'DetectorModelSetVariable',
    'DetectorModelSns',
    'DetectorModelSqs',
    'DetectorModelState',
    'DetectorModelTransitionEvent',
    'InputAttribute',
    'InputDefinition',
]

@pulumi.output_type
class AlarmModelAcknowledgeFlow(dict):
    """
    Specifies whether to get notified for alarm state changes.
    """
    def __init__(__self__, *,
                 enabled: Optional[builtins.bool] = None):
        """
        Specifies whether to get notified for alarm state changes.
        :param builtins.bool enabled: The value must be ``TRUE`` or ``FALSE``. If ``TRUE``, you receive a notification when the alarm state changes. You must choose to acknowledge the notification before the alarm state can return to ``NORMAL``. If ``FALSE``, you won't receive notifications. The alarm automatically changes to the ``NORMAL`` state when the input property value returns to the specified range.
        """
        if enabled is not None:
            pulumi.set(__self__, "enabled", enabled)

    @property
    @pulumi.getter
    def enabled(self) -> Optional[builtins.bool]:
        """
        The value must be ``TRUE`` or ``FALSE``. If ``TRUE``, you receive a notification when the alarm state changes. You must choose to acknowledge the notification before the alarm state can return to ``NORMAL``. If ``FALSE``, you won't receive notifications. The alarm automatically changes to the ``NORMAL`` state when the input property value returns to the specified range.
        """
        return pulumi.get(self, "enabled")


@pulumi.output_type
class AlarmModelAlarmAction(dict):
    """
    Specifies one of the following actions to receive notifications when the alarm state changes.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "dynamoDBv2":
            suggest = "dynamo_d_bv2"
        elif key == "dynamoDb":
            suggest = "dynamo_db"
        elif key == "iotEvents":
            suggest = "iot_events"
        elif key == "iotSiteWise":
            suggest = "iot_site_wise"
        elif key == "iotTopicPublish":
            suggest = "iot_topic_publish"
        elif key == "lambda":
            suggest = "lambda_"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in AlarmModelAlarmAction. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        AlarmModelAlarmAction.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        AlarmModelAlarmAction.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 dynamo_d_bv2: Optional['outputs.AlarmModelDynamoDBv2'] = None,
                 dynamo_db: Optional['outputs.AlarmModelDynamoDb'] = None,
                 firehose: Optional['outputs.AlarmModelFirehose'] = None,
                 iot_events: Optional['outputs.AlarmModelIotEvents'] = None,
                 iot_site_wise: Optional['outputs.AlarmModelIotSiteWise'] = None,
                 iot_topic_publish: Optional['outputs.AlarmModelIotTopicPublish'] = None,
                 lambda_: Optional['outputs.AlarmModelLambda'] = None,
                 sns: Optional['outputs.AlarmModelSns'] = None,
                 sqs: Optional['outputs.AlarmModelSqs'] = None):
        """
        Specifies one of the following actions to receive notifications when the alarm state changes.
        :param 'AlarmModelDynamoDBv2' dynamo_d_bv2: Defines an action to write to the Amazon DynamoDB table that you created. The default action payload contains all the information about the detector model instance and the event that triggered the action. You can customize the [payload](https://docs.aws.amazon.com/iotevents/latest/apireference/API_Payload.html). A separate column of the DynamoDB table receives one attribute-value pair in the payload that you specify.
                You must use expressions for all parameters in ``DynamoDBv2Action``. The expressions accept literals, operators, functions, references, and substitution templates.
                 **Examples**
                +  For literal values, the expressions must contain single quotes. For example, the value for the ``tableName`` parameter can be ``'GreenhouseTemperatureTable'``.
                 +  For references, you must specify either variables or input values. For example, the value for the ``tableName`` parameter can be ``$variable.ddbtableName``.
                 +  For a substitution template, you must use ``${}``, and the template must be in single quotes. A substitution template can also contain a combination of literals, operators, functions, references, and substitution templates.
                In the following example, the value for the ``contentExpression`` parameter in ``Payload`` uses a substitution template. 
                 ``'{\\"sensorID\\": \\"${$input.GreenhouseInput.sensor_id}\\", \\"temperature\\": \\"${$input.GreenhouseInput.temperature * 9 / 5 + 32}\\"}'`` 
                 +  For a string concatenation, you must use ``+``. A string concatenation can also contain a combination of literals, operators, functions, references, and substitution templates.
                In the following example, the value for the ``tableName`` parameter uses a string concatenation. 
                 ``'GreenhouseTemperatureTable ' + $input.GreenhouseInput.date`` 
                 
                For more information, see [Expressions](https://docs.aws.amazon.com/iotevents/latest/developerguide/iotevents-expressions.html) in the *Developer Guide*.
                The value for the ``type`` parameter in ``Payload`` must be ``JSON``.
        :param 'AlarmModelDynamoDb' dynamo_db: Defines an action to write to the Amazon DynamoDB table that you created. The standard action payload contains all the information about the detector model instance and the event that triggered the action. You can customize the [payload](https://docs.aws.amazon.com/iotevents/latest/apireference/API_Payload.html). One column of the DynamoDB table receives all attribute-value pairs in the payload that you specify.
                You must use expressions for all parameters in ``DynamoDBAction``. The expressions accept literals, operators, functions, references, and substitution templates.
                 **Examples**
                +  For literal values, the expressions must contain single quotes. For example, the value for the ``hashKeyType`` parameter can be ``'STRING'``.
                 +  For references, you must specify either variables or input values. For example, the value for the ``hashKeyField`` parameter can be ``$input.GreenhouseInput.name``.
                 +  For a substitution template, you must use ``${}``, and the template must be in single quotes. A substitution template can also contain a combination of literals, operators, functions, references, and substitution templates.
                In the following example, the value for the ``hashKeyValue`` parameter uses a substitution template. 
                 ``'${$input.GreenhouseInput.temperature * 6 / 5 + 32} in Fahrenheit'`` 
                 +  For a string concatenation, you must use ``+``. A string concatenation can also contain a combination of literals, operators, functions, references, and substitution templates.
                In the following example, the value for the ``tableName`` parameter uses a string concatenation. 
                 ``'GreenhouseTemperatureTable ' + $input.GreenhouseInput.date`` 
                 
                For more information, see [Expressions](https://docs.aws.amazon.com/iotevents/latest/developerguide/iotevents-expressions.html) in the *Developer Guide*.
                If the defined payload type is a string, ``DynamoDBAction`` writes non-JSON data to the DynamoDB table as binary data. The DynamoDB console displays the data as Base64-encoded text. The value for the ``payloadField`` parameter is ``<payload-field>_raw``.
        :param 'AlarmModelFirehose' firehose: Sends information about the detector model instance and the event that triggered the action to an Amazon Kinesis Data Firehose delivery stream.
        :param 'AlarmModelIotEvents' iot_events: Sends an ITE input, passing in information about the detector model instance and the event that triggered the action.
        :param 'AlarmModelIotSiteWise' iot_site_wise: Sends information about the detector model instance and the event that triggered the action to a specified asset property in ITSW.
                You must use expressions for all parameters in ``IotSiteWiseAction``. The expressions accept literals, operators, functions, references, and substitutions templates.
                 **Examples**
                +  For literal values, the expressions must contain single quotes. For example, the value for the ``propertyAlias`` parameter can be ``'/company/windfarm/3/turbine/7/temperature'``.
                 +  For references, you must specify either variables or input values. For example, the value for the ``assetId`` parameter can be ``$input.TurbineInput.assetId1``.
                 +  For a substitution template, you must use ``${}``, and the template must be in single quotes. A substitution template can also contain a combination of literals, operators, functions, references, and substitution templates.
                In the following example, the value for the ``propertyAlias`` parameter uses a substitution template. 
                 ``'company/windfarm/${$input.TemperatureInput.sensorData.windfarmID}/turbine/ ${$input.TemperatureInput.sensorData.turbineID}/temperature'`` 
                 
                You must specify either ``propertyAlias`` or both ``assetId`` and ``propertyId`` to identify the target asset property in ITSW.
                For more information, see [Expressions](https://docs.aws.amazon.com/iotevents/latest/developerguide/iotevents-expressions.html) in the *Developer Guide*.
        :param 'AlarmModelIotTopicPublish' iot_topic_publish: Information required to publish the MQTT message through the IoT message broker.
        :param 'AlarmModelLambda' lambda_: Calls a Lambda function, passing in information about the detector model instance and the event that triggered the action.
        :param 'AlarmModelSns' sns: Information required to publish the Amazon SNS message.
        :param 'AlarmModelSqs' sqs: Sends information about the detector model instance and the event that triggered the action to an Amazon SQS queue.
        """
        if dynamo_d_bv2 is not None:
            pulumi.set(__self__, "dynamo_d_bv2", dynamo_d_bv2)
        if dynamo_db is not None:
            pulumi.set(__self__, "dynamo_db", dynamo_db)
        if firehose is not None:
            pulumi.set(__self__, "firehose", firehose)
        if iot_events is not None:
            pulumi.set(__self__, "iot_events", iot_events)
        if iot_site_wise is not None:
            pulumi.set(__self__, "iot_site_wise", iot_site_wise)
        if iot_topic_publish is not None:
            pulumi.set(__self__, "iot_topic_publish", iot_topic_publish)
        if lambda_ is not None:
            pulumi.set(__self__, "lambda_", lambda_)
        if sns is not None:
            pulumi.set(__self__, "sns", sns)
        if sqs is not None:
            pulumi.set(__self__, "sqs", sqs)

    @property
    @pulumi.getter(name="dynamoDBv2")
    def dynamo_d_bv2(self) -> Optional['outputs.AlarmModelDynamoDBv2']:
        """
        Defines an action to write to the Amazon DynamoDB table that you created. The default action payload contains all the information about the detector model instance and the event that triggered the action. You can customize the [payload](https://docs.aws.amazon.com/iotevents/latest/apireference/API_Payload.html). A separate column of the DynamoDB table receives one attribute-value pair in the payload that you specify.
         You must use expressions for all parameters in ``DynamoDBv2Action``. The expressions accept literals, operators, functions, references, and substitution templates.
          **Examples**
         +  For literal values, the expressions must contain single quotes. For example, the value for the ``tableName`` parameter can be ``'GreenhouseTemperatureTable'``.
          +  For references, you must specify either variables or input values. For example, the value for the ``tableName`` parameter can be ``$variable.ddbtableName``.
          +  For a substitution template, you must use ``${}``, and the template must be in single quotes. A substitution template can also contain a combination of literals, operators, functions, references, and substitution templates.
         In the following example, the value for the ``contentExpression`` parameter in ``Payload`` uses a substitution template. 
          ``'{\\"sensorID\\": \\"${$input.GreenhouseInput.sensor_id}\\", \\"temperature\\": \\"${$input.GreenhouseInput.temperature * 9 / 5 + 32}\\"}'`` 
          +  For a string concatenation, you must use ``+``. A string concatenation can also contain a combination of literals, operators, functions, references, and substitution templates.
         In the following example, the value for the ``tableName`` parameter uses a string concatenation. 
          ``'GreenhouseTemperatureTable ' + $input.GreenhouseInput.date`` 
          
         For more information, see [Expressions](https://docs.aws.amazon.com/iotevents/latest/developerguide/iotevents-expressions.html) in the *Developer Guide*.
         The value for the ``type`` parameter in ``Payload`` must be ``JSON``.
        """
        return pulumi.get(self, "dynamo_d_bv2")

    @property
    @pulumi.getter(name="dynamoDb")
    def dynamo_db(self) -> Optional['outputs.AlarmModelDynamoDb']:
        """
        Defines an action to write to the Amazon DynamoDB table that you created. The standard action payload contains all the information about the detector model instance and the event that triggered the action. You can customize the [payload](https://docs.aws.amazon.com/iotevents/latest/apireference/API_Payload.html). One column of the DynamoDB table receives all attribute-value pairs in the payload that you specify.
         You must use expressions for all parameters in ``DynamoDBAction``. The expressions accept literals, operators, functions, references, and substitution templates.
          **Examples**
         +  For literal values, the expressions must contain single quotes. For example, the value for the ``hashKeyType`` parameter can be ``'STRING'``.
          +  For references, you must specify either variables or input values. For example, the value for the ``hashKeyField`` parameter can be ``$input.GreenhouseInput.name``.
          +  For a substitution template, you must use ``${}``, and the template must be in single quotes. A substitution template can also contain a combination of literals, operators, functions, references, and substitution templates.
         In the following example, the value for the ``hashKeyValue`` parameter uses a substitution template. 
          ``'${$input.GreenhouseInput.temperature * 6 / 5 + 32} in Fahrenheit'`` 
          +  For a string concatenation, you must use ``+``. A string concatenation can also contain a combination of literals, operators, functions, references, and substitution templates.
         In the following example, the value for the ``tableName`` parameter uses a string concatenation. 
          ``'GreenhouseTemperatureTable ' + $input.GreenhouseInput.date`` 
          
         For more information, see [Expressions](https://docs.aws.amazon.com/iotevents/latest/developerguide/iotevents-expressions.html) in the *Developer Guide*.
         If the defined payload type is a string, ``DynamoDBAction`` writes non-JSON data to the DynamoDB table as binary data. The DynamoDB console displays the data as Base64-encoded text. The value for the ``payloadField`` parameter is ``<payload-field>_raw``.
        """
        return pulumi.get(self, "dynamo_db")

    @property
    @pulumi.getter
    def firehose(self) -> Optional['outputs.AlarmModelFirehose']:
        """
        Sends information about the detector model instance and the event that triggered the action to an Amazon Kinesis Data Firehose delivery stream.
        """
        return pulumi.get(self, "firehose")

    @property
    @pulumi.getter(name="iotEvents")
    def iot_events(self) -> Optional['outputs.AlarmModelIotEvents']:
        """
        Sends an ITE input, passing in information about the detector model instance and the event that triggered the action.
        """
        return pulumi.get(self, "iot_events")

    @property
    @pulumi.getter(name="iotSiteWise")
    def iot_site_wise(self) -> Optional['outputs.AlarmModelIotSiteWise']:
        """
        Sends information about the detector model instance and the event that triggered the action to a specified asset property in ITSW.
         You must use expressions for all parameters in ``IotSiteWiseAction``. The expressions accept literals, operators, functions, references, and substitutions templates.
          **Examples**
         +  For literal values, the expressions must contain single quotes. For example, the value for the ``propertyAlias`` parameter can be ``'/company/windfarm/3/turbine/7/temperature'``.
          +  For references, you must specify either variables or input values. For example, the value for the ``assetId`` parameter can be ``$input.TurbineInput.assetId1``.
          +  For a substitution template, you must use ``${}``, and the template must be in single quotes. A substitution template can also contain a combination of literals, operators, functions, references, and substitution templates.
         In the following example, the value for the ``propertyAlias`` parameter uses a substitution template. 
          ``'company/windfarm/${$input.TemperatureInput.sensorData.windfarmID}/turbine/ ${$input.TemperatureInput.sensorData.turbineID}/temperature'`` 
          
         You must specify either ``propertyAlias`` or both ``assetId`` and ``propertyId`` to identify the target asset property in ITSW.
         For more information, see [Expressions](https://docs.aws.amazon.com/iotevents/latest/developerguide/iotevents-expressions.html) in the *Developer Guide*.
        """
        return pulumi.get(self, "iot_site_wise")

    @property
    @pulumi.getter(name="iotTopicPublish")
    def iot_topic_publish(self) -> Optional['outputs.AlarmModelIotTopicPublish']:
        """
        Information required to publish the MQTT message through the IoT message broker.
        """
        return pulumi.get(self, "iot_topic_publish")

    @property
    @pulumi.getter(name="lambda")
    def lambda_(self) -> Optional['outputs.AlarmModelLambda']:
        """
        Calls a Lambda function, passing in information about the detector model instance and the event that triggered the action.
        """
        return pulumi.get(self, "lambda_")

    @property
    @pulumi.getter
    def sns(self) -> Optional['outputs.AlarmModelSns']:
        """
        Information required to publish the Amazon SNS message.
        """
        return pulumi.get(self, "sns")

    @property
    @pulumi.getter
    def sqs(self) -> Optional['outputs.AlarmModelSqs']:
        """
        Sends information about the detector model instance and the event that triggered the action to an Amazon SQS queue.
        """
        return pulumi.get(self, "sqs")


@pulumi.output_type
class AlarmModelAlarmCapabilities(dict):
    """
    Contains the configuration information of alarm state changes.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "acknowledgeFlow":
            suggest = "acknowledge_flow"
        elif key == "initializationConfiguration":
            suggest = "initialization_configuration"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in AlarmModelAlarmCapabilities. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        AlarmModelAlarmCapabilities.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        AlarmModelAlarmCapabilities.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 acknowledge_flow: Optional['outputs.AlarmModelAcknowledgeFlow'] = None,
                 initialization_configuration: Optional['outputs.AlarmModelInitializationConfiguration'] = None):
        """
        Contains the configuration information of alarm state changes.
        :param 'AlarmModelAcknowledgeFlow' acknowledge_flow: Specifies whether to get notified for alarm state changes.
        :param 'AlarmModelInitializationConfiguration' initialization_configuration: Specifies the default alarm state. The configuration applies to all alarms that were created based on this alarm model.
        """
        if acknowledge_flow is not None:
            pulumi.set(__self__, "acknowledge_flow", acknowledge_flow)
        if initialization_configuration is not None:
            pulumi.set(__self__, "initialization_configuration", initialization_configuration)

    @property
    @pulumi.getter(name="acknowledgeFlow")
    def acknowledge_flow(self) -> Optional['outputs.AlarmModelAcknowledgeFlow']:
        """
        Specifies whether to get notified for alarm state changes.
        """
        return pulumi.get(self, "acknowledge_flow")

    @property
    @pulumi.getter(name="initializationConfiguration")
    def initialization_configuration(self) -> Optional['outputs.AlarmModelInitializationConfiguration']:
        """
        Specifies the default alarm state. The configuration applies to all alarms that were created based on this alarm model.
        """
        return pulumi.get(self, "initialization_configuration")


@pulumi.output_type
class AlarmModelAlarmEventActions(dict):
    """
    Contains information about one or more alarm actions.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "alarmActions":
            suggest = "alarm_actions"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in AlarmModelAlarmEventActions. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        AlarmModelAlarmEventActions.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        AlarmModelAlarmEventActions.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 alarm_actions: Optional[Sequence['outputs.AlarmModelAlarmAction']] = None):
        """
        Contains information about one or more alarm actions.
        :param Sequence['AlarmModelAlarmAction'] alarm_actions: Specifies one or more supported actions to receive notifications when the alarm state changes.
        """
        if alarm_actions is not None:
            pulumi.set(__self__, "alarm_actions", alarm_actions)

    @property
    @pulumi.getter(name="alarmActions")
    def alarm_actions(self) -> Optional[Sequence['outputs.AlarmModelAlarmAction']]:
        """
        Specifies one or more supported actions to receive notifications when the alarm state changes.
        """
        return pulumi.get(self, "alarm_actions")


@pulumi.output_type
class AlarmModelAlarmRule(dict):
    """
    Defines when your alarm is invoked.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "simpleRule":
            suggest = "simple_rule"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in AlarmModelAlarmRule. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        AlarmModelAlarmRule.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        AlarmModelAlarmRule.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 simple_rule: Optional['outputs.AlarmModelSimpleRule'] = None):
        """
        Defines when your alarm is invoked.
        :param 'AlarmModelSimpleRule' simple_rule: A rule that compares an input property value to a threshold value with a comparison operator.
        """
        if simple_rule is not None:
            pulumi.set(__self__, "simple_rule", simple_rule)

    @property
    @pulumi.getter(name="simpleRule")
    def simple_rule(self) -> Optional['outputs.AlarmModelSimpleRule']:
        """
        A rule that compares an input property value to a threshold value with a comparison operator.
        """
        return pulumi.get(self, "simple_rule")


@pulumi.output_type
class AlarmModelAssetPropertyTimestamp(dict):
    """
    A structure that contains timestamp information. For more information, see [TimeInNanos](https://docs.aws.amazon.com/iot-sitewise/latest/APIReference/API_TimeInNanos.html) in the *API Reference*.
     You must use expressions for all parameters in ``AssetPropertyTimestamp``. The expressions accept literals, operators, functions, references, and substitution templates.
      **Examples**
     +  For literal values, the expressions must contain single quotes. For example, the value for the ``timeInSeconds`` parameter can be ``'1586400675'``.
      +  For references, you must specify either variables or input values. For example, the value for the ``offsetInNanos`` parameter can be ``$variable.time``.
      +  For a substitution template, you must use ``${}``, and the template must be in single quotes. A substitution template can also contain a combination of literals, operators, functions, references, and substitution templates.
     In the following example, the value for the ``timeInSeconds`` parameter uses a substitution template.
      ``'${$input.TemperatureInput.sensorData.timestamp / 1000}'`` 
      
     For more information, see [Expressions](https://docs.aws.amazon.com/iotevents/latest/developerguide/iotevents-expressions.html) in the *Developer Guide*.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "timeInSeconds":
            suggest = "time_in_seconds"
        elif key == "offsetInNanos":
            suggest = "offset_in_nanos"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in AlarmModelAssetPropertyTimestamp. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        AlarmModelAssetPropertyTimestamp.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        AlarmModelAssetPropertyTimestamp.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 time_in_seconds: builtins.str,
                 offset_in_nanos: Optional[builtins.str] = None):
        """
        A structure that contains timestamp information. For more information, see [TimeInNanos](https://docs.aws.amazon.com/iot-sitewise/latest/APIReference/API_TimeInNanos.html) in the *API Reference*.
         You must use expressions for all parameters in ``AssetPropertyTimestamp``. The expressions accept literals, operators, functions, references, and substitution templates.
          **Examples**
         +  For literal values, the expressions must contain single quotes. For example, the value for the ``timeInSeconds`` parameter can be ``'1586400675'``.
          +  For references, you must specify either variables or input values. For example, the value for the ``offsetInNanos`` parameter can be ``$variable.time``.
          +  For a substitution template, you must use ``${}``, and the template must be in single quotes. A substitution template can also contain a combination of literals, operators, functions, references, and substitution templates.
         In the following example, the value for the ``timeInSeconds`` parameter uses a substitution template.
          ``'${$input.TemperatureInput.sensorData.timestamp / 1000}'`` 
          
         For more information, see [Expressions](https://docs.aws.amazon.com/iotevents/latest/developerguide/iotevents-expressions.html) in the *Developer Guide*.
        :param builtins.str time_in_seconds: The timestamp, in seconds, in the Unix epoch format. The valid range is between 1-31556889864403199.
        :param builtins.str offset_in_nanos: The nanosecond offset converted from ``timeInSeconds``. The valid range is between 0-999999999.
        """
        pulumi.set(__self__, "time_in_seconds", time_in_seconds)
        if offset_in_nanos is not None:
            pulumi.set(__self__, "offset_in_nanos", offset_in_nanos)

    @property
    @pulumi.getter(name="timeInSeconds")
    def time_in_seconds(self) -> builtins.str:
        """
        The timestamp, in seconds, in the Unix epoch format. The valid range is between 1-31556889864403199.
        """
        return pulumi.get(self, "time_in_seconds")

    @property
    @pulumi.getter(name="offsetInNanos")
    def offset_in_nanos(self) -> Optional[builtins.str]:
        """
        The nanosecond offset converted from ``timeInSeconds``. The valid range is between 0-999999999.
        """
        return pulumi.get(self, "offset_in_nanos")


@pulumi.output_type
class AlarmModelAssetPropertyValue(dict):
    """
    A structure that contains value information. For more information, see [AssetPropertyValue](https://docs.aws.amazon.com/iot-sitewise/latest/APIReference/API_AssetPropertyValue.html) in the *API Reference*.
     You must use expressions for all parameters in ``AssetPropertyValue``. The expressions accept literals, operators, functions, references, and substitution templates.
      **Examples**
     +  For literal values, the expressions must contain single quotes. For example, the value for the ``quality`` parameter can be ``'GOOD'``.
      +  For references, you must specify either variables or input values. For example, the value for the ``quality`` parameter can be ``$input.TemperatureInput.sensorData.quality``.
      
     For more information, see [Expressions](https://docs.aws.amazon.com/iotevents/latest/developerguide/iotevents-expressions.html) in the *Developer Guide*.
    """
    def __init__(__self__, *,
                 value: 'outputs.AlarmModelAssetPropertyVariant',
                 quality: Optional[builtins.str] = None,
                 timestamp: Optional['outputs.AlarmModelAssetPropertyTimestamp'] = None):
        """
        A structure that contains value information. For more information, see [AssetPropertyValue](https://docs.aws.amazon.com/iot-sitewise/latest/APIReference/API_AssetPropertyValue.html) in the *API Reference*.
         You must use expressions for all parameters in ``AssetPropertyValue``. The expressions accept literals, operators, functions, references, and substitution templates.
          **Examples**
         +  For literal values, the expressions must contain single quotes. For example, the value for the ``quality`` parameter can be ``'GOOD'``.
          +  For references, you must specify either variables or input values. For example, the value for the ``quality`` parameter can be ``$input.TemperatureInput.sensorData.quality``.
          
         For more information, see [Expressions](https://docs.aws.amazon.com/iotevents/latest/developerguide/iotevents-expressions.html) in the *Developer Guide*.
        :param 'AlarmModelAssetPropertyVariant' value: The value to send to an asset property.
        :param builtins.str quality: The quality of the asset property value. The value must be ``'GOOD'``, ``'BAD'``, or ``'UNCERTAIN'``.
        :param 'AlarmModelAssetPropertyTimestamp' timestamp: The timestamp associated with the asset property value. The default is the current event time.
        """
        pulumi.set(__self__, "value", value)
        if quality is not None:
            pulumi.set(__self__, "quality", quality)
        if timestamp is not None:
            pulumi.set(__self__, "timestamp", timestamp)

    @property
    @pulumi.getter
    def value(self) -> 'outputs.AlarmModelAssetPropertyVariant':
        """
        The value to send to an asset property.
        """
        return pulumi.get(self, "value")

    @property
    @pulumi.getter
    def quality(self) -> Optional[builtins.str]:
        """
        The quality of the asset property value. The value must be ``'GOOD'``, ``'BAD'``, or ``'UNCERTAIN'``.
        """
        return pulumi.get(self, "quality")

    @property
    @pulumi.getter
    def timestamp(self) -> Optional['outputs.AlarmModelAssetPropertyTimestamp']:
        """
        The timestamp associated with the asset property value. The default is the current event time.
        """
        return pulumi.get(self, "timestamp")


@pulumi.output_type
class AlarmModelAssetPropertyVariant(dict):
    """
    A structure that contains an asset property value. For more information, see [Variant](https://docs.aws.amazon.com/iot-sitewise/latest/APIReference/API_Variant.html) in the *API Reference*.
     You must use expressions for all parameters in ``AssetPropertyVariant``. The expressions accept literals, operators, functions, references, and substitution templates.
      **Examples**
     +  For literal values, the expressions must contain single quotes. For example, the value for the ``integerValue`` parameter can be ``'100'``.
      +  For references, you must specify either variables or parameters. For example, the value for the ``booleanValue`` parameter can be ``$variable.offline``.
      +  For a substitution template, you must use ``${}``, and the template must be in single quotes. A substitution template can also contain a combination of literals, operators, functions, references, and substitution templates. 
     In the following example, the value for the ``doubleValue`` parameter uses a substitution template. 
      ``'${$input.TemperatureInput.sensorData.temperature * 6 / 5 + 32}'`` 
      
     For more information, see [Expressions](https://docs.aws.amazon.com/iotevents/latest/developerguide/iotevents-expressions.html) in the *Developer Guide*.
     You must specify one of the following value types, depending on the ``dataType`` of the specified asset property. For more information, see [AssetProperty](https://docs.aws.amazon.com/iot-sitewise/latest/APIReference/API_AssetProperty.html) in the *API Reference*.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "booleanValue":
            suggest = "boolean_value"
        elif key == "doubleValue":
            suggest = "double_value"
        elif key == "integerValue":
            suggest = "integer_value"
        elif key == "stringValue":
            suggest = "string_value"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in AlarmModelAssetPropertyVariant. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        AlarmModelAssetPropertyVariant.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        AlarmModelAssetPropertyVariant.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 boolean_value: Optional[builtins.str] = None,
                 double_value: Optional[builtins.str] = None,
                 integer_value: Optional[builtins.str] = None,
                 string_value: Optional[builtins.str] = None):
        """
        A structure that contains an asset property value. For more information, see [Variant](https://docs.aws.amazon.com/iot-sitewise/latest/APIReference/API_Variant.html) in the *API Reference*.
         You must use expressions for all parameters in ``AssetPropertyVariant``. The expressions accept literals, operators, functions, references, and substitution templates.
          **Examples**
         +  For literal values, the expressions must contain single quotes. For example, the value for the ``integerValue`` parameter can be ``'100'``.
          +  For references, you must specify either variables or parameters. For example, the value for the ``booleanValue`` parameter can be ``$variable.offline``.
          +  For a substitution template, you must use ``${}``, and the template must be in single quotes. A substitution template can also contain a combination of literals, operators, functions, references, and substitution templates. 
         In the following example, the value for the ``doubleValue`` parameter uses a substitution template. 
          ``'${$input.TemperatureInput.sensorData.temperature * 6 / 5 + 32}'`` 
          
         For more information, see [Expressions](https://docs.aws.amazon.com/iotevents/latest/developerguide/iotevents-expressions.html) in the *Developer Guide*.
         You must specify one of the following value types, depending on the ``dataType`` of the specified asset property. For more information, see [AssetProperty](https://docs.aws.amazon.com/iot-sitewise/latest/APIReference/API_AssetProperty.html) in the *API Reference*.
        :param builtins.str boolean_value: The asset property value is a Boolean value that must be ``'TRUE'`` or ``'FALSE'``. You must use an expression, and the evaluated result should be a Boolean value.
        :param builtins.str double_value: The asset property value is a double. You must use an expression, and the evaluated result should be a double.
        :param builtins.str integer_value: The asset property value is an integer. You must use an expression, and the evaluated result should be an integer.
        :param builtins.str string_value: The asset property value is a string. You must use an expression, and the evaluated result should be a string.
        """
        if boolean_value is not None:
            pulumi.set(__self__, "boolean_value", boolean_value)
        if double_value is not None:
            pulumi.set(__self__, "double_value", double_value)
        if integer_value is not None:
            pulumi.set(__self__, "integer_value", integer_value)
        if string_value is not None:
            pulumi.set(__self__, "string_value", string_value)

    @property
    @pulumi.getter(name="booleanValue")
    def boolean_value(self) -> Optional[builtins.str]:
        """
        The asset property value is a Boolean value that must be ``'TRUE'`` or ``'FALSE'``. You must use an expression, and the evaluated result should be a Boolean value.
        """
        return pulumi.get(self, "boolean_value")

    @property
    @pulumi.getter(name="doubleValue")
    def double_value(self) -> Optional[builtins.str]:
        """
        The asset property value is a double. You must use an expression, and the evaluated result should be a double.
        """
        return pulumi.get(self, "double_value")

    @property
    @pulumi.getter(name="integerValue")
    def integer_value(self) -> Optional[builtins.str]:
        """
        The asset property value is an integer. You must use an expression, and the evaluated result should be an integer.
        """
        return pulumi.get(self, "integer_value")

    @property
    @pulumi.getter(name="stringValue")
    def string_value(self) -> Optional[builtins.str]:
        """
        The asset property value is a string. You must use an expression, and the evaluated result should be a string.
        """
        return pulumi.get(self, "string_value")


@pulumi.output_type
class AlarmModelDynamoDBv2(dict):
    """
    Defines an action to write to the Amazon DynamoDB table that you created. The default action payload contains all the information about the detector model instance and the event that triggered the action. You can customize the [payload](https://docs.aws.amazon.com/iotevents/latest/apireference/API_Payload.html). A separate column of the DynamoDB table receives one attribute-value pair in the payload that you specify.
     You must use expressions for all parameters in ``DynamoDBv2Action``. The expressions accept literals, operators, functions, references, and substitution templates.
      **Examples**
     +  For literal values, the expressions must contain single quotes. For example, the value for the ``tableName`` parameter can be ``'GreenhouseTemperatureTable'``.
      +  For references, you must specify either variables or input values. For example, the value for the ``tableName`` parameter can be ``$variable.ddbtableName``.
      +  For a substitution template, you must use ``${}``, and the template must be in single quotes. A substitution template can also contain a combination of literals, operators, functions, references, and substitution templates.
     In the following example, the value for the ``contentExpression`` parameter in ``Payload`` uses a substitution template. 
      ``'{\\"sensorID\\": \\"${$input.GreenhouseInput.sensor_id}\\", \\"temperature\\": \\"${$input.GreenhouseInput.temperature * 9 / 5 + 32}\\"}'`` 
      +  For a string concatenation, you must use ``+``. A string concatenation can also contain a combination of literals, operators, functions, references, and substitution templates.
     In the following example, the value for the ``tableName`` parameter uses a string concatenation. 
      ``'GreenhouseTemperatureTable ' + $input.GreenhouseInput.date`` 
      
     For more information, see [Expressions](https://docs.aws.amazon.com/iotevents/latest/developerguide/iotevents-expressions.html) in the *Developer Guide*.
     The value for the ``type`` parameter in ``Payload`` must be ``JSON``.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "tableName":
            suggest = "table_name"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in AlarmModelDynamoDBv2. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        AlarmModelDynamoDBv2.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        AlarmModelDynamoDBv2.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 table_name: builtins.str,
                 payload: Optional['outputs.AlarmModelPayload'] = None):
        """
        Defines an action to write to the Amazon DynamoDB table that you created. The default action payload contains all the information about the detector model instance and the event that triggered the action. You can customize the [payload](https://docs.aws.amazon.com/iotevents/latest/apireference/API_Payload.html). A separate column of the DynamoDB table receives one attribute-value pair in the payload that you specify.
         You must use expressions for all parameters in ``DynamoDBv2Action``. The expressions accept literals, operators, functions, references, and substitution templates.
          **Examples**
         +  For literal values, the expressions must contain single quotes. For example, the value for the ``tableName`` parameter can be ``'GreenhouseTemperatureTable'``.
          +  For references, you must specify either variables or input values. For example, the value for the ``tableName`` parameter can be ``$variable.ddbtableName``.
          +  For a substitution template, you must use ``${}``, and the template must be in single quotes. A substitution template can also contain a combination of literals, operators, functions, references, and substitution templates.
         In the following example, the value for the ``contentExpression`` parameter in ``Payload`` uses a substitution template. 
          ``'{\\"sensorID\\": \\"${$input.GreenhouseInput.sensor_id}\\", \\"temperature\\": \\"${$input.GreenhouseInput.temperature * 9 / 5 + 32}\\"}'`` 
          +  For a string concatenation, you must use ``+``. A string concatenation can also contain a combination of literals, operators, functions, references, and substitution templates.
         In the following example, the value for the ``tableName`` parameter uses a string concatenation. 
          ``'GreenhouseTemperatureTable ' + $input.GreenhouseInput.date`` 
          
         For more information, see [Expressions](https://docs.aws.amazon.com/iotevents/latest/developerguide/iotevents-expressions.html) in the *Developer Guide*.
         The value for the ``type`` parameter in ``Payload`` must be ``JSON``.
        :param builtins.str table_name: The name of the DynamoDB table.
        :param 'AlarmModelPayload' payload: Information needed to configure the payload.
                By default, ITE generates a standard payload in JSON for any action. This action payload contains all attribute-value pairs that have the information about the detector model instance and the event triggered the action. To configure the action payload, you can use ``contentExpression``.
        """
        pulumi.set(__self__, "table_name", table_name)
        if payload is not None:
            pulumi.set(__self__, "payload", payload)

    @property
    @pulumi.getter(name="tableName")
    def table_name(self) -> builtins.str:
        """
        The name of the DynamoDB table.
        """
        return pulumi.get(self, "table_name")

    @property
    @pulumi.getter
    def payload(self) -> Optional['outputs.AlarmModelPayload']:
        """
        Information needed to configure the payload.
         By default, ITE generates a standard payload in JSON for any action. This action payload contains all attribute-value pairs that have the information about the detector model instance and the event triggered the action. To configure the action payload, you can use ``contentExpression``.
        """
        return pulumi.get(self, "payload")


@pulumi.output_type
class AlarmModelDynamoDb(dict):
    """
    Defines an action to write to the Amazon DynamoDB table that you created. The standard action payload contains all the information about the detector model instance and the event that triggered the action. You can customize the [payload](https://docs.aws.amazon.com/iotevents/latest/apireference/API_Payload.html). One column of the DynamoDB table receives all attribute-value pairs in the payload that you specify.
     You must use expressions for all parameters in ``DynamoDBAction``. The expressions accept literals, operators, functions, references, and substitution templates.
      **Examples**
     +  For literal values, the expressions must contain single quotes. For example, the value for the ``hashKeyType`` parameter can be ``'STRING'``.
      +  For references, you must specify either variables or input values. For example, the value for the ``hashKeyField`` parameter can be ``$input.GreenhouseInput.name``.
      +  For a substitution template, you must use ``${}``, and the template must be in single quotes. A substitution template can also contain a combination of literals, operators, functions, references, and substitution templates.
     In the following example, the value for the ``hashKeyValue`` parameter uses a substitution template. 
      ``'${$input.GreenhouseInput.temperature * 6 / 5 + 32} in Fahrenheit'`` 
      +  For a string concatenation, you must use ``+``. A string concatenation can also contain a combination of literals, operators, functions, references, and substitution templates.
     In the following example, the value for the ``tableName`` parameter uses a string concatenation. 
      ``'GreenhouseTemperatureTable ' + $input.GreenhouseInput.date`` 
      
     For more information, see [Expressions](https://docs.aws.amazon.com/iotevents/latest/developerguide/iotevents-expressions.html) in the *Developer Guide*.
     If the defined payload type is a string, ``DynamoDBAction`` writes non-JSON data to the DynamoDB table as binary data. The DynamoDB console displays the data as Base64-encoded text. The value for the ``payloadField`` parameter is ``<payload-field>_raw``.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "hashKeyField":
            suggest = "hash_key_field"
        elif key == "hashKeyValue":
            suggest = "hash_key_value"
        elif key == "tableName":
            suggest = "table_name"
        elif key == "hashKeyType":
            suggest = "hash_key_type"
        elif key == "payloadField":
            suggest = "payload_field"
        elif key == "rangeKeyField":
            suggest = "range_key_field"
        elif key == "rangeKeyType":
            suggest = "range_key_type"
        elif key == "rangeKeyValue":
            suggest = "range_key_value"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in AlarmModelDynamoDb. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        AlarmModelDynamoDb.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        AlarmModelDynamoDb.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 hash_key_field: builtins.str,
                 hash_key_value: builtins.str,
                 table_name: builtins.str,
                 hash_key_type: Optional[builtins.str] = None,
                 operation: Optional[builtins.str] = None,
                 payload: Optional['outputs.AlarmModelPayload'] = None,
                 payload_field: Optional[builtins.str] = None,
                 range_key_field: Optional[builtins.str] = None,
                 range_key_type: Optional[builtins.str] = None,
                 range_key_value: Optional[builtins.str] = None):
        """
        Defines an action to write to the Amazon DynamoDB table that you created. The standard action payload contains all the information about the detector model instance and the event that triggered the action. You can customize the [payload](https://docs.aws.amazon.com/iotevents/latest/apireference/API_Payload.html). One column of the DynamoDB table receives all attribute-value pairs in the payload that you specify.
         You must use expressions for all parameters in ``DynamoDBAction``. The expressions accept literals, operators, functions, references, and substitution templates.
          **Examples**
         +  For literal values, the expressions must contain single quotes. For example, the value for the ``hashKeyType`` parameter can be ``'STRING'``.
          +  For references, you must specify either variables or input values. For example, the value for the ``hashKeyField`` parameter can be ``$input.GreenhouseInput.name``.
          +  For a substitution template, you must use ``${}``, and the template must be in single quotes. A substitution template can also contain a combination of literals, operators, functions, references, and substitution templates.
         In the following example, the value for the ``hashKeyValue`` parameter uses a substitution template. 
          ``'${$input.GreenhouseInput.temperature * 6 / 5 + 32} in Fahrenheit'`` 
          +  For a string concatenation, you must use ``+``. A string concatenation can also contain a combination of literals, operators, functions, references, and substitution templates.
         In the following example, the value for the ``tableName`` parameter uses a string concatenation. 
          ``'GreenhouseTemperatureTable ' + $input.GreenhouseInput.date`` 
          
         For more information, see [Expressions](https://docs.aws.amazon.com/iotevents/latest/developerguide/iotevents-expressions.html) in the *Developer Guide*.
         If the defined payload type is a string, ``DynamoDBAction`` writes non-JSON data to the DynamoDB table as binary data. The DynamoDB console displays the data as Base64-encoded text. The value for the ``payloadField`` parameter is ``<payload-field>_raw``.
        :param builtins.str hash_key_field: The name of the hash key (also called the partition key). The ``hashKeyField`` value must match the partition key of the target DynamoDB table.
        :param builtins.str hash_key_value: The value of the hash key (also called the partition key).
        :param builtins.str table_name: The name of the DynamoDB table. The ``tableName`` value must match the table name of the target DynamoDB table.
        :param builtins.str hash_key_type: The data type for the hash key (also called the partition key). You can specify the following values:
                 +   ``'STRING'`` - The hash key is a string.
                 +   ``'NUMBER'`` - The hash key is a number.
                 
                If you don't specify ``hashKeyType``, the default value is ``'STRING'``.
        :param builtins.str operation: The type of operation to perform. You can specify the following values: 
                 +   ``'INSERT'`` - Insert data as a new item into the DynamoDB table. This item uses the specified hash key as a partition key. If you specified a range key, the item uses the range key as a sort key.
                 +   ``'UPDATE'`` - Update an existing item of the DynamoDB table with new data. This item's partition key must match the specified hash key. If you specified a range key, the range key must match the item's sort key.
                 +   ``'DELETE'`` - Delete an existing item of the DynamoDB table. This item's partition key must match the specified hash key. If you specified a range key, the range key must match the item's sort key.
                 
                If you don't specify this parameter, ITE triggers the ``'INSERT'`` operation.
        :param 'AlarmModelPayload' payload: Information needed to configure the payload.
                By default, ITE generates a standard payload in JSON for any action. This action payload contains all attribute-value pairs that have the information about the detector model instance and the event triggered the action. To configure the action payload, you can use ``contentExpression``.
        :param builtins.str payload_field: The name of the DynamoDB column that receives the action payload.
                If you don't specify this parameter, the name of the DynamoDB column is ``payload``.
        :param builtins.str range_key_field: The name of the range key (also called the sort key). The ``rangeKeyField`` value must match the sort key of the target DynamoDB table.
        :param builtins.str range_key_type: The data type for the range key (also called the sort key), You can specify the following values:
                 +   ``'STRING'`` - The range key is a string.
                 +   ``'NUMBER'`` - The range key is number.
                 
                If you don't specify ``rangeKeyField``, the default value is ``'STRING'``.
        :param builtins.str range_key_value: The value of the range key (also called the sort key).
        """
        pulumi.set(__self__, "hash_key_field", hash_key_field)
        pulumi.set(__self__, "hash_key_value", hash_key_value)
        pulumi.set(__self__, "table_name", table_name)
        if hash_key_type is not None:
            pulumi.set(__self__, "hash_key_type", hash_key_type)
        if operation is not None:
            pulumi.set(__self__, "operation", operation)
        if payload is not None:
            pulumi.set(__self__, "payload", payload)
        if payload_field is not None:
            pulumi.set(__self__, "payload_field", payload_field)
        if range_key_field is not None:
            pulumi.set(__self__, "range_key_field", range_key_field)
        if range_key_type is not None:
            pulumi.set(__self__, "range_key_type", range_key_type)
        if range_key_value is not None:
            pulumi.set(__self__, "range_key_value", range_key_value)

    @property
    @pulumi.getter(name="hashKeyField")
    def hash_key_field(self) -> builtins.str:
        """
        The name of the hash key (also called the partition key). The ``hashKeyField`` value must match the partition key of the target DynamoDB table.
        """
        return pulumi.get(self, "hash_key_field")

    @property
    @pulumi.getter(name="hashKeyValue")
    def hash_key_value(self) -> builtins.str:
        """
        The value of the hash key (also called the partition key).
        """
        return pulumi.get(self, "hash_key_value")

    @property
    @pulumi.getter(name="tableName")
    def table_name(self) -> builtins.str:
        """
        The name of the DynamoDB table. The ``tableName`` value must match the table name of the target DynamoDB table.
        """
        return pulumi.get(self, "table_name")

    @property
    @pulumi.getter(name="hashKeyType")
    def hash_key_type(self) -> Optional[builtins.str]:
        """
        The data type for the hash key (also called the partition key). You can specify the following values:
          +   ``'STRING'`` - The hash key is a string.
          +   ``'NUMBER'`` - The hash key is a number.
          
         If you don't specify ``hashKeyType``, the default value is ``'STRING'``.
        """
        return pulumi.get(self, "hash_key_type")

    @property
    @pulumi.getter
    def operation(self) -> Optional[builtins.str]:
        """
        The type of operation to perform. You can specify the following values: 
          +   ``'INSERT'`` - Insert data as a new item into the DynamoDB table. This item uses the specified hash key as a partition key. If you specified a range key, the item uses the range key as a sort key.
          +   ``'UPDATE'`` - Update an existing item of the DynamoDB table with new data. This item's partition key must match the specified hash key. If you specified a range key, the range key must match the item's sort key.
          +   ``'DELETE'`` - Delete an existing item of the DynamoDB table. This item's partition key must match the specified hash key. If you specified a range key, the range key must match the item's sort key.
          
         If you don't specify this parameter, ITE triggers the ``'INSERT'`` operation.
        """
        return pulumi.get(self, "operation")

    @property
    @pulumi.getter
    def payload(self) -> Optional['outputs.AlarmModelPayload']:
        """
        Information needed to configure the payload.
         By default, ITE generates a standard payload in JSON for any action. This action payload contains all attribute-value pairs that have the information about the detector model instance and the event triggered the action. To configure the action payload, you can use ``contentExpression``.
        """
        return pulumi.get(self, "payload")

    @property
    @pulumi.getter(name="payloadField")
    def payload_field(self) -> Optional[builtins.str]:
        """
        The name of the DynamoDB column that receives the action payload.
         If you don't specify this parameter, the name of the DynamoDB column is ``payload``.
        """
        return pulumi.get(self, "payload_field")

    @property
    @pulumi.getter(name="rangeKeyField")
    def range_key_field(self) -> Optional[builtins.str]:
        """
        The name of the range key (also called the sort key). The ``rangeKeyField`` value must match the sort key of the target DynamoDB table.
        """
        return pulumi.get(self, "range_key_field")

    @property
    @pulumi.getter(name="rangeKeyType")
    def range_key_type(self) -> Optional[builtins.str]:
        """
        The data type for the range key (also called the sort key), You can specify the following values:
          +   ``'STRING'`` - The range key is a string.
          +   ``'NUMBER'`` - The range key is number.
          
         If you don't specify ``rangeKeyField``, the default value is ``'STRING'``.
        """
        return pulumi.get(self, "range_key_type")

    @property
    @pulumi.getter(name="rangeKeyValue")
    def range_key_value(self) -> Optional[builtins.str]:
        """
        The value of the range key (also called the sort key).
        """
        return pulumi.get(self, "range_key_value")


@pulumi.output_type
class AlarmModelFirehose(dict):
    """
    Sends information about the detector model instance and the event that triggered the action to an Amazon Kinesis Data Firehose delivery stream.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "deliveryStreamName":
            suggest = "delivery_stream_name"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in AlarmModelFirehose. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        AlarmModelFirehose.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        AlarmModelFirehose.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 delivery_stream_name: builtins.str,
                 payload: Optional['outputs.AlarmModelPayload'] = None,
                 separator: Optional[builtins.str] = None):
        """
        Sends information about the detector model instance and the event that triggered the action to an Amazon Kinesis Data Firehose delivery stream.
        :param builtins.str delivery_stream_name: The name of the Kinesis Data Firehose delivery stream where the data is written.
        :param 'AlarmModelPayload' payload: You can configure the action payload when you send a message to an Amazon Data Firehose delivery stream.
        :param builtins.str separator: A character separator that is used to separate records written to the Kinesis Data Firehose delivery stream. Valid values are: '\\n' (newline), '\\t' (tab), '\\r\\n' (Windows newline), ',' (comma).
        """
        pulumi.set(__self__, "delivery_stream_name", delivery_stream_name)
        if payload is not None:
            pulumi.set(__self__, "payload", payload)
        if separator is not None:
            pulumi.set(__self__, "separator", separator)

    @property
    @pulumi.getter(name="deliveryStreamName")
    def delivery_stream_name(self) -> builtins.str:
        """
        The name of the Kinesis Data Firehose delivery stream where the data is written.
        """
        return pulumi.get(self, "delivery_stream_name")

    @property
    @pulumi.getter
    def payload(self) -> Optional['outputs.AlarmModelPayload']:
        """
        You can configure the action payload when you send a message to an Amazon Data Firehose delivery stream.
        """
        return pulumi.get(self, "payload")

    @property
    @pulumi.getter
    def separator(self) -> Optional[builtins.str]:
        """
        A character separator that is used to separate records written to the Kinesis Data Firehose delivery stream. Valid values are: '\\n' (newline), '\\t' (tab), '\\r\\n' (Windows newline), ',' (comma).
        """
        return pulumi.get(self, "separator")


@pulumi.output_type
class AlarmModelInitializationConfiguration(dict):
    """
    Specifies the default alarm state. The configuration applies to all alarms that were created based on this alarm model.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "disabledOnInitialization":
            suggest = "disabled_on_initialization"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in AlarmModelInitializationConfiguration. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        AlarmModelInitializationConfiguration.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        AlarmModelInitializationConfiguration.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 disabled_on_initialization: builtins.bool):
        """
        Specifies the default alarm state. The configuration applies to all alarms that were created based on this alarm model.
        :param builtins.bool disabled_on_initialization: The value must be ``TRUE`` or ``FALSE``. If ``FALSE``, all alarm instances created based on the alarm model are activated. The default value is ``TRUE``.
        """
        pulumi.set(__self__, "disabled_on_initialization", disabled_on_initialization)

    @property
    @pulumi.getter(name="disabledOnInitialization")
    def disabled_on_initialization(self) -> builtins.bool:
        """
        The value must be ``TRUE`` or ``FALSE``. If ``FALSE``, all alarm instances created based on the alarm model are activated. The default value is ``TRUE``.
        """
        return pulumi.get(self, "disabled_on_initialization")


@pulumi.output_type
class AlarmModelIotEvents(dict):
    """
    Sends an ITE input, passing in information about the detector model instance and the event that triggered the action.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "inputName":
            suggest = "input_name"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in AlarmModelIotEvents. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        AlarmModelIotEvents.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        AlarmModelIotEvents.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 input_name: builtins.str,
                 payload: Optional['outputs.AlarmModelPayload'] = None):
        """
        Sends an ITE input, passing in information about the detector model instance and the event that triggered the action.
        :param builtins.str input_name: The name of the ITE input where the data is sent.
        :param 'AlarmModelPayload' payload: You can configure the action payload when you send a message to an ITE input.
        """
        pulumi.set(__self__, "input_name", input_name)
        if payload is not None:
            pulumi.set(__self__, "payload", payload)

    @property
    @pulumi.getter(name="inputName")
    def input_name(self) -> builtins.str:
        """
        The name of the ITE input where the data is sent.
        """
        return pulumi.get(self, "input_name")

    @property
    @pulumi.getter
    def payload(self) -> Optional['outputs.AlarmModelPayload']:
        """
        You can configure the action payload when you send a message to an ITE input.
        """
        return pulumi.get(self, "payload")


@pulumi.output_type
class AlarmModelIotSiteWise(dict):
    """
    Sends information about the detector model instance and the event that triggered the action to a specified asset property in ITSW.
     You must use expressions for all parameters in ``IotSiteWiseAction``. The expressions accept literals, operators, functions, references, and substitutions templates.
      **Examples**
     +  For literal values, the expressions must contain single quotes. For example, the value for the ``propertyAlias`` parameter can be ``'/company/windfarm/3/turbine/7/temperature'``.
      +  For references, you must specify either variables or input values. For example, the value for the ``assetId`` parameter can be ``$input.TurbineInput.assetId1``.
      +  For a substitution template, you must use ``${}``, and the template must be in single quotes. A substitution template can also contain a combination of literals, operators, functions, references, and substitution templates.
     In the following example, the value for the ``propertyAlias`` parameter uses a substitution template. 
      ``'company/windfarm/${$input.TemperatureInput.sensorData.windfarmID}/turbine/ ${$input.TemperatureInput.sensorData.turbineID}/temperature'`` 
      
     You must specify either ``propertyAlias`` or both ``assetId`` and ``propertyId`` to identify the target asset property in ITSW.
     For more information, see [Expressions](https://docs.aws.amazon.com/iotevents/latest/developerguide/iotevents-expressions.html) in the *Developer Guide*.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "assetId":
            suggest = "asset_id"
        elif key == "entryId":
            suggest = "entry_id"
        elif key == "propertyAlias":
            suggest = "property_alias"
        elif key == "propertyId":
            suggest = "property_id"
        elif key == "propertyValue":
            suggest = "property_value"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in AlarmModelIotSiteWise. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        AlarmModelIotSiteWise.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        AlarmModelIotSiteWise.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 asset_id: Optional[builtins.str] = None,
                 entry_id: Optional[builtins.str] = None,
                 property_alias: Optional[builtins.str] = None,
                 property_id: Optional[builtins.str] = None,
                 property_value: Optional['outputs.AlarmModelAssetPropertyValue'] = None):
        """
        Sends information about the detector model instance and the event that triggered the action to a specified asset property in ITSW.
         You must use expressions for all parameters in ``IotSiteWiseAction``. The expressions accept literals, operators, functions, references, and substitutions templates.
          **Examples**
         +  For literal values, the expressions must contain single quotes. For example, the value for the ``propertyAlias`` parameter can be ``'/company/windfarm/3/turbine/7/temperature'``.
          +  For references, you must specify either variables or input values. For example, the value for the ``assetId`` parameter can be ``$input.TurbineInput.assetId1``.
          +  For a substitution template, you must use ``${}``, and the template must be in single quotes. A substitution template can also contain a combination of literals, operators, functions, references, and substitution templates.
         In the following example, the value for the ``propertyAlias`` parameter uses a substitution template. 
          ``'company/windfarm/${$input.TemperatureInput.sensorData.windfarmID}/turbine/ ${$input.TemperatureInput.sensorData.turbineID}/temperature'`` 
          
         You must specify either ``propertyAlias`` or both ``assetId`` and ``propertyId`` to identify the target asset property in ITSW.
         For more information, see [Expressions](https://docs.aws.amazon.com/iotevents/latest/developerguide/iotevents-expressions.html) in the *Developer Guide*.
        :param builtins.str asset_id: The ID of the asset that has the specified property.
        :param builtins.str entry_id: A unique identifier for this entry. You can use the entry ID to track which data entry causes an error in case of failure. The default is a new unique identifier.
        :param builtins.str property_alias: The alias of the asset property.
        :param builtins.str property_id: The ID of the asset property.
        :param 'AlarmModelAssetPropertyValue' property_value: The value to send to the asset property. This value contains timestamp, quality, and value (TQV) information.
        """
        if asset_id is not None:
            pulumi.set(__self__, "asset_id", asset_id)
        if entry_id is not None:
            pulumi.set(__self__, "entry_id", entry_id)
        if property_alias is not None:
            pulumi.set(__self__, "property_alias", property_alias)
        if property_id is not None:
            pulumi.set(__self__, "property_id", property_id)
        if property_value is not None:
            pulumi.set(__self__, "property_value", property_value)

    @property
    @pulumi.getter(name="assetId")
    def asset_id(self) -> Optional[builtins.str]:
        """
        The ID of the asset that has the specified property.
        """
        return pulumi.get(self, "asset_id")

    @property
    @pulumi.getter(name="entryId")
    def entry_id(self) -> Optional[builtins.str]:
        """
        A unique identifier for this entry. You can use the entry ID to track which data entry causes an error in case of failure. The default is a new unique identifier.
        """
        return pulumi.get(self, "entry_id")

    @property
    @pulumi.getter(name="propertyAlias")
    def property_alias(self) -> Optional[builtins.str]:
        """
        The alias of the asset property.
        """
        return pulumi.get(self, "property_alias")

    @property
    @pulumi.getter(name="propertyId")
    def property_id(self) -> Optional[builtins.str]:
        """
        The ID of the asset property.
        """
        return pulumi.get(self, "property_id")

    @property
    @pulumi.getter(name="propertyValue")
    def property_value(self) -> Optional['outputs.AlarmModelAssetPropertyValue']:
        """
        The value to send to the asset property. This value contains timestamp, quality, and value (TQV) information.
        """
        return pulumi.get(self, "property_value")


@pulumi.output_type
class AlarmModelIotTopicPublish(dict):
    """
    Information required to publish the MQTT message through the IoT message broker.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "mqttTopic":
            suggest = "mqtt_topic"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in AlarmModelIotTopicPublish. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        AlarmModelIotTopicPublish.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        AlarmModelIotTopicPublish.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 mqtt_topic: builtins.str,
                 payload: Optional['outputs.AlarmModelPayload'] = None):
        """
        Information required to publish the MQTT message through the IoT message broker.
        :param builtins.str mqtt_topic: The MQTT topic of the message. You can use a string expression that includes variables (``$variable.<variable-name>``) and input values (``$input.<input-name>.<path-to-datum>``) as the topic string.
        :param 'AlarmModelPayload' payload: You can configure the action payload when you publish a message to an IoTCore topic.
        """
        pulumi.set(__self__, "mqtt_topic", mqtt_topic)
        if payload is not None:
            pulumi.set(__self__, "payload", payload)

    @property
    @pulumi.getter(name="mqttTopic")
    def mqtt_topic(self) -> builtins.str:
        """
        The MQTT topic of the message. You can use a string expression that includes variables (``$variable.<variable-name>``) and input values (``$input.<input-name>.<path-to-datum>``) as the topic string.
        """
        return pulumi.get(self, "mqtt_topic")

    @property
    @pulumi.getter
    def payload(self) -> Optional['outputs.AlarmModelPayload']:
        """
        You can configure the action payload when you publish a message to an IoTCore topic.
        """
        return pulumi.get(self, "payload")


@pulumi.output_type
class AlarmModelLambda(dict):
    """
    Calls a Lambda function, passing in information about the detector model instance and the event that triggered the action.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "functionArn":
            suggest = "function_arn"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in AlarmModelLambda. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        AlarmModelLambda.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        AlarmModelLambda.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 function_arn: builtins.str,
                 payload: Optional['outputs.AlarmModelPayload'] = None):
        """
        Calls a Lambda function, passing in information about the detector model instance and the event that triggered the action.
        :param builtins.str function_arn: The ARN of the Lambda function that is executed.
        :param 'AlarmModelPayload' payload: You can configure the action payload when you send a message to a Lambda function.
        """
        pulumi.set(__self__, "function_arn", function_arn)
        if payload is not None:
            pulumi.set(__self__, "payload", payload)

    @property
    @pulumi.getter(name="functionArn")
    def function_arn(self) -> builtins.str:
        """
        The ARN of the Lambda function that is executed.
        """
        return pulumi.get(self, "function_arn")

    @property
    @pulumi.getter
    def payload(self) -> Optional['outputs.AlarmModelPayload']:
        """
        You can configure the action payload when you send a message to a Lambda function.
        """
        return pulumi.get(self, "payload")


@pulumi.output_type
class AlarmModelPayload(dict):
    """
    Information needed to configure the payload.
     By default, ITE generates a standard payload in JSON for any action. This action payload contains all attribute-value pairs that have the information about the detector model instance and the event triggered the action. To configure the action payload, you can use ``contentExpression``.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "contentExpression":
            suggest = "content_expression"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in AlarmModelPayload. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        AlarmModelPayload.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        AlarmModelPayload.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 content_expression: builtins.str,
                 type: builtins.str):
        """
        Information needed to configure the payload.
         By default, ITE generates a standard payload in JSON for any action. This action payload contains all attribute-value pairs that have the information about the detector model instance and the event triggered the action. To configure the action payload, you can use ``contentExpression``.
        :param builtins.str content_expression: The content of the payload. You can use a string expression that includes quoted strings (``'<string>'``), variables (``$variable.<variable-name>``), input values (``$input.<input-name>.<path-to-datum>``), string concatenations, and quoted strings that contain ``${}`` as the content. The recommended maximum size of a content expression is 1 KB.
        :param builtins.str type: The value of the payload type can be either ``STRING`` or ``JSON``.
        """
        pulumi.set(__self__, "content_expression", content_expression)
        pulumi.set(__self__, "type", type)

    @property
    @pulumi.getter(name="contentExpression")
    def content_expression(self) -> builtins.str:
        """
        The content of the payload. You can use a string expression that includes quoted strings (``'<string>'``), variables (``$variable.<variable-name>``), input values (``$input.<input-name>.<path-to-datum>``), string concatenations, and quoted strings that contain ``${}`` as the content. The recommended maximum size of a content expression is 1 KB.
        """
        return pulumi.get(self, "content_expression")

    @property
    @pulumi.getter
    def type(self) -> builtins.str:
        """
        The value of the payload type can be either ``STRING`` or ``JSON``.
        """
        return pulumi.get(self, "type")


@pulumi.output_type
class AlarmModelSimpleRule(dict):
    """
    A rule that compares an input property value to a threshold value with a comparison operator.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "comparisonOperator":
            suggest = "comparison_operator"
        elif key == "inputProperty":
            suggest = "input_property"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in AlarmModelSimpleRule. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        AlarmModelSimpleRule.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        AlarmModelSimpleRule.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 comparison_operator: 'AlarmModelSimpleRuleComparisonOperator',
                 input_property: builtins.str,
                 threshold: builtins.str):
        """
        A rule that compares an input property value to a threshold value with a comparison operator.
        :param 'AlarmModelSimpleRuleComparisonOperator' comparison_operator: The comparison operator.
        :param builtins.str input_property: The value on the left side of the comparison operator. You can specify an ITE input attribute as an input property.
        :param builtins.str threshold: The value on the right side of the comparison operator. You can enter a number or specify an ITE input attribute.
        """
        pulumi.set(__self__, "comparison_operator", comparison_operator)
        pulumi.set(__self__, "input_property", input_property)
        pulumi.set(__self__, "threshold", threshold)

    @property
    @pulumi.getter(name="comparisonOperator")
    def comparison_operator(self) -> 'AlarmModelSimpleRuleComparisonOperator':
        """
        The comparison operator.
        """
        return pulumi.get(self, "comparison_operator")

    @property
    @pulumi.getter(name="inputProperty")
    def input_property(self) -> builtins.str:
        """
        The value on the left side of the comparison operator. You can specify an ITE input attribute as an input property.
        """
        return pulumi.get(self, "input_property")

    @property
    @pulumi.getter
    def threshold(self) -> builtins.str:
        """
        The value on the right side of the comparison operator. You can enter a number or specify an ITE input attribute.
        """
        return pulumi.get(self, "threshold")


@pulumi.output_type
class AlarmModelSns(dict):
    """
    Information required to publish the Amazon SNS message.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "targetArn":
            suggest = "target_arn"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in AlarmModelSns. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        AlarmModelSns.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        AlarmModelSns.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 target_arn: builtins.str,
                 payload: Optional['outputs.AlarmModelPayload'] = None):
        """
        Information required to publish the Amazon SNS message.
        :param builtins.str target_arn: The ARN of the Amazon SNS target where the message is sent.
        :param 'AlarmModelPayload' payload: You can configure the action payload when you send a message as an Amazon SNS push notification.
        """
        pulumi.set(__self__, "target_arn", target_arn)
        if payload is not None:
            pulumi.set(__self__, "payload", payload)

    @property
    @pulumi.getter(name="targetArn")
    def target_arn(self) -> builtins.str:
        """
        The ARN of the Amazon SNS target where the message is sent.
        """
        return pulumi.get(self, "target_arn")

    @property
    @pulumi.getter
    def payload(self) -> Optional['outputs.AlarmModelPayload']:
        """
        You can configure the action payload when you send a message as an Amazon SNS push notification.
        """
        return pulumi.get(self, "payload")


@pulumi.output_type
class AlarmModelSqs(dict):
    """
    Sends information about the detector model instance and the event that triggered the action to an Amazon SQS queue.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "queueUrl":
            suggest = "queue_url"
        elif key == "useBase64":
            suggest = "use_base64"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in AlarmModelSqs. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        AlarmModelSqs.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        AlarmModelSqs.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 queue_url: builtins.str,
                 payload: Optional['outputs.AlarmModelPayload'] = None,
                 use_base64: Optional[builtins.bool] = None):
        """
        Sends information about the detector model instance and the event that triggered the action to an Amazon SQS queue.
        :param builtins.str queue_url: The URL of the SQS queue where the data is written.
        :param 'AlarmModelPayload' payload: You can configure the action payload when you send a message to an Amazon SQS queue.
        :param builtins.bool use_base64: Set this to TRUE if you want the data to be base-64 encoded before it is written to the queue. Otherwise, set this to FALSE.
        """
        pulumi.set(__self__, "queue_url", queue_url)
        if payload is not None:
            pulumi.set(__self__, "payload", payload)
        if use_base64 is not None:
            pulumi.set(__self__, "use_base64", use_base64)

    @property
    @pulumi.getter(name="queueUrl")
    def queue_url(self) -> builtins.str:
        """
        The URL of the SQS queue where the data is written.
        """
        return pulumi.get(self, "queue_url")

    @property
    @pulumi.getter
    def payload(self) -> Optional['outputs.AlarmModelPayload']:
        """
        You can configure the action payload when you send a message to an Amazon SQS queue.
        """
        return pulumi.get(self, "payload")

    @property
    @pulumi.getter(name="useBase64")
    def use_base64(self) -> Optional[builtins.bool]:
        """
        Set this to TRUE if you want the data to be base-64 encoded before it is written to the queue. Otherwise, set this to FALSE.
        """
        return pulumi.get(self, "use_base64")


@pulumi.output_type
class DetectorModelAction(dict):
    """
    An action to be performed when the ``condition`` is TRUE.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "clearTimer":
            suggest = "clear_timer"
        elif key == "dynamoDBv2":
            suggest = "dynamo_d_bv2"
        elif key == "dynamoDb":
            suggest = "dynamo_db"
        elif key == "iotEvents":
            suggest = "iot_events"
        elif key == "iotSiteWise":
            suggest = "iot_site_wise"
        elif key == "iotTopicPublish":
            suggest = "iot_topic_publish"
        elif key == "lambda":
            suggest = "lambda_"
        elif key == "resetTimer":
            suggest = "reset_timer"
        elif key == "setTimer":
            suggest = "set_timer"
        elif key == "setVariable":
            suggest = "set_variable"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in DetectorModelAction. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        DetectorModelAction.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        DetectorModelAction.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 clear_timer: Optional['outputs.DetectorModelClearTimer'] = None,
                 dynamo_d_bv2: Optional['outputs.DetectorModelDynamoDBv2'] = None,
                 dynamo_db: Optional['outputs.DetectorModelDynamoDb'] = None,
                 firehose: Optional['outputs.DetectorModelFirehose'] = None,
                 iot_events: Optional['outputs.DetectorModelIotEvents'] = None,
                 iot_site_wise: Optional['outputs.DetectorModelIotSiteWise'] = None,
                 iot_topic_publish: Optional['outputs.DetectorModelIotTopicPublish'] = None,
                 lambda_: Optional['outputs.DetectorModelLambda'] = None,
                 reset_timer: Optional['outputs.DetectorModelResetTimer'] = None,
                 set_timer: Optional['outputs.DetectorModelSetTimer'] = None,
                 set_variable: Optional['outputs.DetectorModelSetVariable'] = None,
                 sns: Optional['outputs.DetectorModelSns'] = None,
                 sqs: Optional['outputs.DetectorModelSqs'] = None):
        """
        An action to be performed when the ``condition`` is TRUE.
        :param 'DetectorModelClearTimer' clear_timer: Information needed to clear the timer.
        :param 'DetectorModelDynamoDBv2' dynamo_d_bv2: Writes to the DynamoDB table that you created. The default action payload contains all attribute-value pairs that have the information about the detector model instance and the event that triggered the action. You can customize the [payload](https://docs.aws.amazon.com/iotevents/latest/apireference/API_Payload.html). A separate column of the DynamoDB table receives one attribute-value pair in the payload that you specify. For more information, see [Actions](https://docs.aws.amazon.com/iotevents/latest/developerguide/iotevents-event-actions.html) in *Developer Guide*.
        :param 'DetectorModelDynamoDb' dynamo_db: Writes to the DynamoDB table that you created. The default action payload contains all attribute-value pairs that have the information about the detector model instance and the event that triggered the action. You can customize the [payload](https://docs.aws.amazon.com/iotevents/latest/apireference/API_Payload.html). One column of the DynamoDB table receives all attribute-value pairs in the payload that you specify. For more information, see [Actions](https://docs.aws.amazon.com/iotevents/latest/developerguide/iotevents-event-actions.html) in *Developer Guide*.
        :param 'DetectorModelFirehose' firehose: Sends information about the detector model instance and the event that triggered the action to an Amazon Kinesis Data Firehose delivery stream.
        :param 'DetectorModelIotEvents' iot_events: Sends ITE input, which passes information about the detector model instance and the event that triggered the action.
        :param 'DetectorModelIotSiteWise' iot_site_wise: Sends information about the detector model instance and the event that triggered the action to an asset property in ITSW .
        :param 'DetectorModelIotTopicPublish' iot_topic_publish: Publishes an MQTT message with the given topic to the IoT message broker.
        :param 'DetectorModelLambda' lambda_: Calls a Lambda function, passing in information about the detector model instance and the event that triggered the action.
        :param 'DetectorModelResetTimer' reset_timer: Information needed to reset the timer.
        :param 'DetectorModelSetTimer' set_timer: Information needed to set the timer.
        :param 'DetectorModelSetVariable' set_variable: Sets a variable to a specified value.
        :param 'DetectorModelSns' sns: Sends an Amazon SNS message.
        :param 'DetectorModelSqs' sqs: Sends an Amazon SNS message.
        """
        if clear_timer is not None:
            pulumi.set(__self__, "clear_timer", clear_timer)
        if dynamo_d_bv2 is not None:
            pulumi.set(__self__, "dynamo_d_bv2", dynamo_d_bv2)
        if dynamo_db is not None:
            pulumi.set(__self__, "dynamo_db", dynamo_db)
        if firehose is not None:
            pulumi.set(__self__, "firehose", firehose)
        if iot_events is not None:
            pulumi.set(__self__, "iot_events", iot_events)
        if iot_site_wise is not None:
            pulumi.set(__self__, "iot_site_wise", iot_site_wise)
        if iot_topic_publish is not None:
            pulumi.set(__self__, "iot_topic_publish", iot_topic_publish)
        if lambda_ is not None:
            pulumi.set(__self__, "lambda_", lambda_)
        if reset_timer is not None:
            pulumi.set(__self__, "reset_timer", reset_timer)
        if set_timer is not None:
            pulumi.set(__self__, "set_timer", set_timer)
        if set_variable is not None:
            pulumi.set(__self__, "set_variable", set_variable)
        if sns is not None:
            pulumi.set(__self__, "sns", sns)
        if sqs is not None:
            pulumi.set(__self__, "sqs", sqs)

    @property
    @pulumi.getter(name="clearTimer")
    def clear_timer(self) -> Optional['outputs.DetectorModelClearTimer']:
        """
        Information needed to clear the timer.
        """
        return pulumi.get(self, "clear_timer")

    @property
    @pulumi.getter(name="dynamoDBv2")
    def dynamo_d_bv2(self) -> Optional['outputs.DetectorModelDynamoDBv2']:
        """
        Writes to the DynamoDB table that you created. The default action payload contains all attribute-value pairs that have the information about the detector model instance and the event that triggered the action. You can customize the [payload](https://docs.aws.amazon.com/iotevents/latest/apireference/API_Payload.html). A separate column of the DynamoDB table receives one attribute-value pair in the payload that you specify. For more information, see [Actions](https://docs.aws.amazon.com/iotevents/latest/developerguide/iotevents-event-actions.html) in *Developer Guide*.
        """
        return pulumi.get(self, "dynamo_d_bv2")

    @property
    @pulumi.getter(name="dynamoDb")
    def dynamo_db(self) -> Optional['outputs.DetectorModelDynamoDb']:
        """
        Writes to the DynamoDB table that you created. The default action payload contains all attribute-value pairs that have the information about the detector model instance and the event that triggered the action. You can customize the [payload](https://docs.aws.amazon.com/iotevents/latest/apireference/API_Payload.html). One column of the DynamoDB table receives all attribute-value pairs in the payload that you specify. For more information, see [Actions](https://docs.aws.amazon.com/iotevents/latest/developerguide/iotevents-event-actions.html) in *Developer Guide*.
        """
        return pulumi.get(self, "dynamo_db")

    @property
    @pulumi.getter
    def firehose(self) -> Optional['outputs.DetectorModelFirehose']:
        """
        Sends information about the detector model instance and the event that triggered the action to an Amazon Kinesis Data Firehose delivery stream.
        """
        return pulumi.get(self, "firehose")

    @property
    @pulumi.getter(name="iotEvents")
    def iot_events(self) -> Optional['outputs.DetectorModelIotEvents']:
        """
        Sends ITE input, which passes information about the detector model instance and the event that triggered the action.
        """
        return pulumi.get(self, "iot_events")

    @property
    @pulumi.getter(name="iotSiteWise")
    def iot_site_wise(self) -> Optional['outputs.DetectorModelIotSiteWise']:
        """
        Sends information about the detector model instance and the event that triggered the action to an asset property in ITSW .
        """
        return pulumi.get(self, "iot_site_wise")

    @property
    @pulumi.getter(name="iotTopicPublish")
    def iot_topic_publish(self) -> Optional['outputs.DetectorModelIotTopicPublish']:
        """
        Publishes an MQTT message with the given topic to the IoT message broker.
        """
        return pulumi.get(self, "iot_topic_publish")

    @property
    @pulumi.getter(name="lambda")
    def lambda_(self) -> Optional['outputs.DetectorModelLambda']:
        """
        Calls a Lambda function, passing in information about the detector model instance and the event that triggered the action.
        """
        return pulumi.get(self, "lambda_")

    @property
    @pulumi.getter(name="resetTimer")
    def reset_timer(self) -> Optional['outputs.DetectorModelResetTimer']:
        """
        Information needed to reset the timer.
        """
        return pulumi.get(self, "reset_timer")

    @property
    @pulumi.getter(name="setTimer")
    def set_timer(self) -> Optional['outputs.DetectorModelSetTimer']:
        """
        Information needed to set the timer.
        """
        return pulumi.get(self, "set_timer")

    @property
    @pulumi.getter(name="setVariable")
    def set_variable(self) -> Optional['outputs.DetectorModelSetVariable']:
        """
        Sets a variable to a specified value.
        """
        return pulumi.get(self, "set_variable")

    @property
    @pulumi.getter
    def sns(self) -> Optional['outputs.DetectorModelSns']:
        """
        Sends an Amazon SNS message.
        """
        return pulumi.get(self, "sns")

    @property
    @pulumi.getter
    def sqs(self) -> Optional['outputs.DetectorModelSqs']:
        """
        Sends an Amazon SNS message.
        """
        return pulumi.get(self, "sqs")


@pulumi.output_type
class DetectorModelAssetPropertyTimestamp(dict):
    """
    A structure that contains timestamp information. For more information, see [TimeInNanos](https://docs.aws.amazon.com/iot-sitewise/latest/APIReference/API_TimeInNanos.html) in the *API Reference*.
     You must use expressions for all parameters in ``AssetPropertyTimestamp``. The expressions accept literals, operators, functions, references, and substitution templates.
      **Examples**
     +  For literal values, the expressions must contain single quotes. For example, the value for the ``timeInSeconds`` parameter can be ``'1586400675'``.
      +  For references, you must specify either variables or input values. For example, the value for the ``offsetInNanos`` parameter can be ``$variable.time``.
      +  For a substitution template, you must use ``${}``, and the template must be in single quotes. A substitution template can also contain a combination of literals, operators, functions, references, and substitution templates.
     In the following example, the value for the ``timeInSeconds`` parameter uses a substitution template.
      ``'${$input.TemperatureInput.sensorData.timestamp / 1000}'`` 
      
     For more information, see [Expressions](https://docs.aws.amazon.com/iotevents/latest/developerguide/iotevents-expressions.html) in the *Developer Guide*.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "timeInSeconds":
            suggest = "time_in_seconds"
        elif key == "offsetInNanos":
            suggest = "offset_in_nanos"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in DetectorModelAssetPropertyTimestamp. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        DetectorModelAssetPropertyTimestamp.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        DetectorModelAssetPropertyTimestamp.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 time_in_seconds: builtins.str,
                 offset_in_nanos: Optional[builtins.str] = None):
        """
        A structure that contains timestamp information. For more information, see [TimeInNanos](https://docs.aws.amazon.com/iot-sitewise/latest/APIReference/API_TimeInNanos.html) in the *API Reference*.
         You must use expressions for all parameters in ``AssetPropertyTimestamp``. The expressions accept literals, operators, functions, references, and substitution templates.
          **Examples**
         +  For literal values, the expressions must contain single quotes. For example, the value for the ``timeInSeconds`` parameter can be ``'1586400675'``.
          +  For references, you must specify either variables or input values. For example, the value for the ``offsetInNanos`` parameter can be ``$variable.time``.
          +  For a substitution template, you must use ``${}``, and the template must be in single quotes. A substitution template can also contain a combination of literals, operators, functions, references, and substitution templates.
         In the following example, the value for the ``timeInSeconds`` parameter uses a substitution template.
          ``'${$input.TemperatureInput.sensorData.timestamp / 1000}'`` 
          
         For more information, see [Expressions](https://docs.aws.amazon.com/iotevents/latest/developerguide/iotevents-expressions.html) in the *Developer Guide*.
        :param builtins.str time_in_seconds: The timestamp, in seconds, in the Unix epoch format. The valid range is between 1-31556889864403199.
        :param builtins.str offset_in_nanos: The nanosecond offset converted from ``timeInSeconds``. The valid range is between 0-999999999.
        """
        pulumi.set(__self__, "time_in_seconds", time_in_seconds)
        if offset_in_nanos is not None:
            pulumi.set(__self__, "offset_in_nanos", offset_in_nanos)

    @property
    @pulumi.getter(name="timeInSeconds")
    def time_in_seconds(self) -> builtins.str:
        """
        The timestamp, in seconds, in the Unix epoch format. The valid range is between 1-31556889864403199.
        """
        return pulumi.get(self, "time_in_seconds")

    @property
    @pulumi.getter(name="offsetInNanos")
    def offset_in_nanos(self) -> Optional[builtins.str]:
        """
        The nanosecond offset converted from ``timeInSeconds``. The valid range is between 0-999999999.
        """
        return pulumi.get(self, "offset_in_nanos")


@pulumi.output_type
class DetectorModelAssetPropertyValue(dict):
    """
    A structure that contains value information. For more information, see [AssetPropertyValue](https://docs.aws.amazon.com/iot-sitewise/latest/APIReference/API_AssetPropertyValue.html) in the *API Reference*.
     You must use expressions for all parameters in ``AssetPropertyValue``. The expressions accept literals, operators, functions, references, and substitution templates.
      **Examples**
     +  For literal values, the expressions must contain single quotes. For example, the value for the ``quality`` parameter can be ``'GOOD'``.
      +  For references, you must specify either variables or input values. For example, the value for the ``quality`` parameter can be ``$input.TemperatureInput.sensorData.quality``.
      
     For more information, see [Expressions](https://docs.aws.amazon.com/iotevents/latest/developerguide/iotevents-expressions.html) in the *Developer Guide*.
    """
    def __init__(__self__, *,
                 value: 'outputs.DetectorModelAssetPropertyVariant',
                 quality: Optional[builtins.str] = None,
                 timestamp: Optional['outputs.DetectorModelAssetPropertyTimestamp'] = None):
        """
        A structure that contains value information. For more information, see [AssetPropertyValue](https://docs.aws.amazon.com/iot-sitewise/latest/APIReference/API_AssetPropertyValue.html) in the *API Reference*.
         You must use expressions for all parameters in ``AssetPropertyValue``. The expressions accept literals, operators, functions, references, and substitution templates.
          **Examples**
         +  For literal values, the expressions must contain single quotes. For example, the value for the ``quality`` parameter can be ``'GOOD'``.
          +  For references, you must specify either variables or input values. For example, the value for the ``quality`` parameter can be ``$input.TemperatureInput.sensorData.quality``.
          
         For more information, see [Expressions](https://docs.aws.amazon.com/iotevents/latest/developerguide/iotevents-expressions.html) in the *Developer Guide*.
        :param 'DetectorModelAssetPropertyVariant' value: The value to send to an asset property.
        :param builtins.str quality: The quality of the asset property value. The value must be ``'GOOD'``, ``'BAD'``, or ``'UNCERTAIN'``.
        :param 'DetectorModelAssetPropertyTimestamp' timestamp: The timestamp associated with the asset property value. The default is the current event time.
        """
        pulumi.set(__self__, "value", value)
        if quality is not None:
            pulumi.set(__self__, "quality", quality)
        if timestamp is not None:
            pulumi.set(__self__, "timestamp", timestamp)

    @property
    @pulumi.getter
    def value(self) -> 'outputs.DetectorModelAssetPropertyVariant':
        """
        The value to send to an asset property.
        """
        return pulumi.get(self, "value")

    @property
    @pulumi.getter
    def quality(self) -> Optional[builtins.str]:
        """
        The quality of the asset property value. The value must be ``'GOOD'``, ``'BAD'``, or ``'UNCERTAIN'``.
        """
        return pulumi.get(self, "quality")

    @property
    @pulumi.getter
    def timestamp(self) -> Optional['outputs.DetectorModelAssetPropertyTimestamp']:
        """
        The timestamp associated with the asset property value. The default is the current event time.
        """
        return pulumi.get(self, "timestamp")


@pulumi.output_type
class DetectorModelAssetPropertyVariant(dict):
    """
    A structure that contains an asset property value. For more information, see [Variant](https://docs.aws.amazon.com/iot-sitewise/latest/APIReference/API_Variant.html) in the *API Reference*.
     You must use expressions for all parameters in ``AssetPropertyVariant``. The expressions accept literals, operators, functions, references, and substitution templates.
      **Examples**
     +  For literal values, the expressions must contain single quotes. For example, the value for the ``integerValue`` parameter can be ``'100'``.
      +  For references, you must specify either variables or parameters. For example, the value for the ``booleanValue`` parameter can be ``$variable.offline``.
      +  For a substitution template, you must use ``${}``, and the template must be in single quotes. A substitution template can also contain a combination of literals, operators, functions, references, and substitution templates. 
     In the following example, the value for the ``doubleValue`` parameter uses a substitution template. 
      ``'${$input.TemperatureInput.sensorData.temperature * 6 / 5 + 32}'`` 
      
     For more information, see [Expressions](https://docs.aws.amazon.com/iotevents/latest/developerguide/iotevents-expressions.html) in the *Developer Guide*.
     You must specify one of the following value types, depending on the ``dataType`` of the specified asset property. For more information, see [AssetProperty](https://docs.aws.amazon.com/iot-sitewise/latest/APIReference/API_AssetProperty.html) in the *API Reference*.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "booleanValue":
            suggest = "boolean_value"
        elif key == "doubleValue":
            suggest = "double_value"
        elif key == "integerValue":
            suggest = "integer_value"
        elif key == "stringValue":
            suggest = "string_value"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in DetectorModelAssetPropertyVariant. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        DetectorModelAssetPropertyVariant.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        DetectorModelAssetPropertyVariant.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 boolean_value: Optional[builtins.str] = None,
                 double_value: Optional[builtins.str] = None,
                 integer_value: Optional[builtins.str] = None,
                 string_value: Optional[builtins.str] = None):
        """
        A structure that contains an asset property value. For more information, see [Variant](https://docs.aws.amazon.com/iot-sitewise/latest/APIReference/API_Variant.html) in the *API Reference*.
         You must use expressions for all parameters in ``AssetPropertyVariant``. The expressions accept literals, operators, functions, references, and substitution templates.
          **Examples**
         +  For literal values, the expressions must contain single quotes. For example, the value for the ``integerValue`` parameter can be ``'100'``.
          +  For references, you must specify either variables or parameters. For example, the value for the ``booleanValue`` parameter can be ``$variable.offline``.
          +  For a substitution template, you must use ``${}``, and the template must be in single quotes. A substitution template can also contain a combination of literals, operators, functions, references, and substitution templates. 
         In the following example, the value for the ``doubleValue`` parameter uses a substitution template. 
          ``'${$input.TemperatureInput.sensorData.temperature * 6 / 5 + 32}'`` 
          
         For more information, see [Expressions](https://docs.aws.amazon.com/iotevents/latest/developerguide/iotevents-expressions.html) in the *Developer Guide*.
         You must specify one of the following value types, depending on the ``dataType`` of the specified asset property. For more information, see [AssetProperty](https://docs.aws.amazon.com/iot-sitewise/latest/APIReference/API_AssetProperty.html) in the *API Reference*.
        :param builtins.str boolean_value: The asset property value is a Boolean value that must be ``'TRUE'`` or ``'FALSE'``. You must use an expression, and the evaluated result should be a Boolean value.
        :param builtins.str double_value: The asset property value is a double. You must use an expression, and the evaluated result should be a double.
        :param builtins.str integer_value: The asset property value is an integer. You must use an expression, and the evaluated result should be an integer.
        :param builtins.str string_value: The asset property value is a string. You must use an expression, and the evaluated result should be a string.
        """
        if boolean_value is not None:
            pulumi.set(__self__, "boolean_value", boolean_value)
        if double_value is not None:
            pulumi.set(__self__, "double_value", double_value)
        if integer_value is not None:
            pulumi.set(__self__, "integer_value", integer_value)
        if string_value is not None:
            pulumi.set(__self__, "string_value", string_value)

    @property
    @pulumi.getter(name="booleanValue")
    def boolean_value(self) -> Optional[builtins.str]:
        """
        The asset property value is a Boolean value that must be ``'TRUE'`` or ``'FALSE'``. You must use an expression, and the evaluated result should be a Boolean value.
        """
        return pulumi.get(self, "boolean_value")

    @property
    @pulumi.getter(name="doubleValue")
    def double_value(self) -> Optional[builtins.str]:
        """
        The asset property value is a double. You must use an expression, and the evaluated result should be a double.
        """
        return pulumi.get(self, "double_value")

    @property
    @pulumi.getter(name="integerValue")
    def integer_value(self) -> Optional[builtins.str]:
        """
        The asset property value is an integer. You must use an expression, and the evaluated result should be an integer.
        """
        return pulumi.get(self, "integer_value")

    @property
    @pulumi.getter(name="stringValue")
    def string_value(self) -> Optional[builtins.str]:
        """
        The asset property value is a string. You must use an expression, and the evaluated result should be a string.
        """
        return pulumi.get(self, "string_value")


@pulumi.output_type
class DetectorModelClearTimer(dict):
    """
    Information needed to clear the timer.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "timerName":
            suggest = "timer_name"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in DetectorModelClearTimer. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        DetectorModelClearTimer.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        DetectorModelClearTimer.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 timer_name: builtins.str):
        """
        Information needed to clear the timer.
        :param builtins.str timer_name: The name of the timer to clear.
        """
        pulumi.set(__self__, "timer_name", timer_name)

    @property
    @pulumi.getter(name="timerName")
    def timer_name(self) -> builtins.str:
        """
        The name of the timer to clear.
        """
        return pulumi.get(self, "timer_name")


@pulumi.output_type
class DetectorModelDefinition(dict):
    """
    Information that defines how a detector operates.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "initialStateName":
            suggest = "initial_state_name"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in DetectorModelDefinition. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        DetectorModelDefinition.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        DetectorModelDefinition.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 initial_state_name: builtins.str,
                 states: Sequence['outputs.DetectorModelState']):
        """
        Information that defines how a detector operates.
        :param builtins.str initial_state_name: The state that is entered at the creation of each detector (instance).
        :param Sequence['DetectorModelState'] states: Information about the states of the detector.
        """
        pulumi.set(__self__, "initial_state_name", initial_state_name)
        pulumi.set(__self__, "states", states)

    @property
    @pulumi.getter(name="initialStateName")
    def initial_state_name(self) -> builtins.str:
        """
        The state that is entered at the creation of each detector (instance).
        """
        return pulumi.get(self, "initial_state_name")

    @property
    @pulumi.getter
    def states(self) -> Sequence['outputs.DetectorModelState']:
        """
        Information about the states of the detector.
        """
        return pulumi.get(self, "states")


@pulumi.output_type
class DetectorModelDynamoDBv2(dict):
    """
    Defines an action to write to the Amazon DynamoDB table that you created. The default action payload contains all the information about the detector model instance and the event that triggered the action. You can customize the [payload](https://docs.aws.amazon.com/iotevents/latest/apireference/API_Payload.html). A separate column of the DynamoDB table receives one attribute-value pair in the payload that you specify.
     You must use expressions for all parameters in ``DynamoDBv2Action``. The expressions accept literals, operators, functions, references, and substitution templates.
      **Examples**
     +  For literal values, the expressions must contain single quotes. For example, the value for the ``tableName`` parameter can be ``'GreenhouseTemperatureTable'``.
      +  For references, you must specify either variables or input values. For example, the value for the ``tableName`` parameter can be ``$variable.ddbtableName``.
      +  For a substitution template, you must use ``${}``, and the template must be in single quotes. A substitution template can also contain a combination of literals, operators, functions, references, and substitution templates.
     In the following example, the value for the ``contentExpression`` parameter in ``Payload`` uses a substitution template. 
      ``'{\\"sensorID\\": \\"${$input.GreenhouseInput.sensor_id}\\", \\"temperature\\": \\"${$input.GreenhouseInput.temperature * 9 / 5 + 32}\\"}'`` 
      +  For a string concatenation, you must use ``+``. A string concatenation can also contain a combination of literals, operators, functions, references, and substitution templates.
     In the following example, the value for the ``tableName`` parameter uses a string concatenation. 
      ``'GreenhouseTemperatureTable ' + $input.GreenhouseInput.date`` 
      
     For more information, see [Expressions](https://docs.aws.amazon.com/iotevents/latest/developerguide/iotevents-expressions.html) in the *Developer Guide*.
     The value for the ``type`` parameter in ``Payload`` must be ``JSON``.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "tableName":
            suggest = "table_name"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in DetectorModelDynamoDBv2. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        DetectorModelDynamoDBv2.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        DetectorModelDynamoDBv2.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 table_name: builtins.str,
                 payload: Optional['outputs.DetectorModelPayload'] = None):
        """
        Defines an action to write to the Amazon DynamoDB table that you created. The default action payload contains all the information about the detector model instance and the event that triggered the action. You can customize the [payload](https://docs.aws.amazon.com/iotevents/latest/apireference/API_Payload.html). A separate column of the DynamoDB table receives one attribute-value pair in the payload that you specify.
         You must use expressions for all parameters in ``DynamoDBv2Action``. The expressions accept literals, operators, functions, references, and substitution templates.
          **Examples**
         +  For literal values, the expressions must contain single quotes. For example, the value for the ``tableName`` parameter can be ``'GreenhouseTemperatureTable'``.
          +  For references, you must specify either variables or input values. For example, the value for the ``tableName`` parameter can be ``$variable.ddbtableName``.
          +  For a substitution template, you must use ``${}``, and the template must be in single quotes. A substitution template can also contain a combination of literals, operators, functions, references, and substitution templates.
         In the following example, the value for the ``contentExpression`` parameter in ``Payload`` uses a substitution template. 
          ``'{\\"sensorID\\": \\"${$input.GreenhouseInput.sensor_id}\\", \\"temperature\\": \\"${$input.GreenhouseInput.temperature * 9 / 5 + 32}\\"}'`` 
          +  For a string concatenation, you must use ``+``. A string concatenation can also contain a combination of literals, operators, functions, references, and substitution templates.
         In the following example, the value for the ``tableName`` parameter uses a string concatenation. 
          ``'GreenhouseTemperatureTable ' + $input.GreenhouseInput.date`` 
          
         For more information, see [Expressions](https://docs.aws.amazon.com/iotevents/latest/developerguide/iotevents-expressions.html) in the *Developer Guide*.
         The value for the ``type`` parameter in ``Payload`` must be ``JSON``.
        :param builtins.str table_name: The name of the DynamoDB table.
        :param 'DetectorModelPayload' payload: Information needed to configure the payload.
                By default, ITE generates a standard payload in JSON for any action. This action payload contains all attribute-value pairs that have the information about the detector model instance and the event triggered the action. To configure the action payload, you can use ``contentExpression``.
        """
        pulumi.set(__self__, "table_name", table_name)
        if payload is not None:
            pulumi.set(__self__, "payload", payload)

    @property
    @pulumi.getter(name="tableName")
    def table_name(self) -> builtins.str:
        """
        The name of the DynamoDB table.
        """
        return pulumi.get(self, "table_name")

    @property
    @pulumi.getter
    def payload(self) -> Optional['outputs.DetectorModelPayload']:
        """
        Information needed to configure the payload.
         By default, ITE generates a standard payload in JSON for any action. This action payload contains all attribute-value pairs that have the information about the detector model instance and the event triggered the action. To configure the action payload, you can use ``contentExpression``.
        """
        return pulumi.get(self, "payload")


@pulumi.output_type
class DetectorModelDynamoDb(dict):
    """
    Defines an action to write to the Amazon DynamoDB table that you created. The standard action payload contains all the information about the detector model instance and the event that triggered the action. You can customize the [payload](https://docs.aws.amazon.com/iotevents/latest/apireference/API_Payload.html). One column of the DynamoDB table receives all attribute-value pairs in the payload that you specify.
     You must use expressions for all parameters in ``DynamoDBAction``. The expressions accept literals, operators, functions, references, and substitution templates.
      **Examples**
     +  For literal values, the expressions must contain single quotes. For example, the value for the ``hashKeyType`` parameter can be ``'STRING'``.
      +  For references, you must specify either variables or input values. For example, the value for the ``hashKeyField`` parameter can be ``$input.GreenhouseInput.name``.
      +  For a substitution template, you must use ``${}``, and the template must be in single quotes. A substitution template can also contain a combination of literals, operators, functions, references, and substitution templates.
     In the following example, the value for the ``hashKeyValue`` parameter uses a substitution template. 
      ``'${$input.GreenhouseInput.temperature * 6 / 5 + 32} in Fahrenheit'`` 
      +  For a string concatenation, you must use ``+``. A string concatenation can also contain a combination of literals, operators, functions, references, and substitution templates.
     In the following example, the value for the ``tableName`` parameter uses a string concatenation. 
      ``'GreenhouseTemperatureTable ' + $input.GreenhouseInput.date`` 
      
     For more information, see [Expressions](https://docs.aws.amazon.com/iotevents/latest/developerguide/iotevents-expressions.html) in the *Developer Guide*.
     If the defined payload type is a string, ``DynamoDBAction`` writes non-JSON data to the DynamoDB table as binary data. The DynamoDB console displays the data as Base64-encoded text. The value for the ``payloadField`` parameter is ``<payload-field>_raw``.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "hashKeyField":
            suggest = "hash_key_field"
        elif key == "hashKeyValue":
            suggest = "hash_key_value"
        elif key == "tableName":
            suggest = "table_name"
        elif key == "hashKeyType":
            suggest = "hash_key_type"
        elif key == "payloadField":
            suggest = "payload_field"
        elif key == "rangeKeyField":
            suggest = "range_key_field"
        elif key == "rangeKeyType":
            suggest = "range_key_type"
        elif key == "rangeKeyValue":
            suggest = "range_key_value"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in DetectorModelDynamoDb. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        DetectorModelDynamoDb.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        DetectorModelDynamoDb.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 hash_key_field: builtins.str,
                 hash_key_value: builtins.str,
                 table_name: builtins.str,
                 hash_key_type: Optional[builtins.str] = None,
                 operation: Optional[builtins.str] = None,
                 payload: Optional['outputs.DetectorModelPayload'] = None,
                 payload_field: Optional[builtins.str] = None,
                 range_key_field: Optional[builtins.str] = None,
                 range_key_type: Optional[builtins.str] = None,
                 range_key_value: Optional[builtins.str] = None):
        """
        Defines an action to write to the Amazon DynamoDB table that you created. The standard action payload contains all the information about the detector model instance and the event that triggered the action. You can customize the [payload](https://docs.aws.amazon.com/iotevents/latest/apireference/API_Payload.html). One column of the DynamoDB table receives all attribute-value pairs in the payload that you specify.
         You must use expressions for all parameters in ``DynamoDBAction``. The expressions accept literals, operators, functions, references, and substitution templates.
          **Examples**
         +  For literal values, the expressions must contain single quotes. For example, the value for the ``hashKeyType`` parameter can be ``'STRING'``.
          +  For references, you must specify either variables or input values. For example, the value for the ``hashKeyField`` parameter can be ``$input.GreenhouseInput.name``.
          +  For a substitution template, you must use ``${}``, and the template must be in single quotes. A substitution template can also contain a combination of literals, operators, functions, references, and substitution templates.
         In the following example, the value for the ``hashKeyValue`` parameter uses a substitution template. 
          ``'${$input.GreenhouseInput.temperature * 6 / 5 + 32} in Fahrenheit'`` 
          +  For a string concatenation, you must use ``+``. A string concatenation can also contain a combination of literals, operators, functions, references, and substitution templates.
         In the following example, the value for the ``tableName`` parameter uses a string concatenation. 
          ``'GreenhouseTemperatureTable ' + $input.GreenhouseInput.date`` 
          
         For more information, see [Expressions](https://docs.aws.amazon.com/iotevents/latest/developerguide/iotevents-expressions.html) in the *Developer Guide*.
         If the defined payload type is a string, ``DynamoDBAction`` writes non-JSON data to the DynamoDB table as binary data. The DynamoDB console displays the data as Base64-encoded text. The value for the ``payloadField`` parameter is ``<payload-field>_raw``.
        :param builtins.str hash_key_field: The name of the hash key (also called the partition key). The ``hashKeyField`` value must match the partition key of the target DynamoDB table.
        :param builtins.str hash_key_value: The value of the hash key (also called the partition key).
        :param builtins.str table_name: The name of the DynamoDB table. The ``tableName`` value must match the table name of the target DynamoDB table.
        :param builtins.str hash_key_type: The data type for the hash key (also called the partition key). You can specify the following values:
                 +   ``'STRING'`` - The hash key is a string.
                 +   ``'NUMBER'`` - The hash key is a number.
                 
                If you don't specify ``hashKeyType``, the default value is ``'STRING'``.
        :param builtins.str operation: The type of operation to perform. You can specify the following values: 
                 +   ``'INSERT'`` - Insert data as a new item into the DynamoDB table. This item uses the specified hash key as a partition key. If you specified a range key, the item uses the range key as a sort key.
                 +   ``'UPDATE'`` - Update an existing item of the DynamoDB table with new data. This item's partition key must match the specified hash key. If you specified a range key, the range key must match the item's sort key.
                 +   ``'DELETE'`` - Delete an existing item of the DynamoDB table. This item's partition key must match the specified hash key. If you specified a range key, the range key must match the item's sort key.
                 
                If you don't specify this parameter, ITE triggers the ``'INSERT'`` operation.
        :param 'DetectorModelPayload' payload: Information needed to configure the payload.
                By default, ITE generates a standard payload in JSON for any action. This action payload contains all attribute-value pairs that have the information about the detector model instance and the event triggered the action. To configure the action payload, you can use ``contentExpression``.
        :param builtins.str payload_field: The name of the DynamoDB column that receives the action payload.
                If you don't specify this parameter, the name of the DynamoDB column is ``payload``.
        :param builtins.str range_key_field: The name of the range key (also called the sort key). The ``rangeKeyField`` value must match the sort key of the target DynamoDB table.
        :param builtins.str range_key_type: The data type for the range key (also called the sort key), You can specify the following values:
                 +   ``'STRING'`` - The range key is a string.
                 +   ``'NUMBER'`` - The range key is number.
                 
                If you don't specify ``rangeKeyField``, the default value is ``'STRING'``.
        :param builtins.str range_key_value: The value of the range key (also called the sort key).
        """
        pulumi.set(__self__, "hash_key_field", hash_key_field)
        pulumi.set(__self__, "hash_key_value", hash_key_value)
        pulumi.set(__self__, "table_name", table_name)
        if hash_key_type is not None:
            pulumi.set(__self__, "hash_key_type", hash_key_type)
        if operation is not None:
            pulumi.set(__self__, "operation", operation)
        if payload is not None:
            pulumi.set(__self__, "payload", payload)
        if payload_field is not None:
            pulumi.set(__self__, "payload_field", payload_field)
        if range_key_field is not None:
            pulumi.set(__self__, "range_key_field", range_key_field)
        if range_key_type is not None:
            pulumi.set(__self__, "range_key_type", range_key_type)
        if range_key_value is not None:
            pulumi.set(__self__, "range_key_value", range_key_value)

    @property
    @pulumi.getter(name="hashKeyField")
    def hash_key_field(self) -> builtins.str:
        """
        The name of the hash key (also called the partition key). The ``hashKeyField`` value must match the partition key of the target DynamoDB table.
        """
        return pulumi.get(self, "hash_key_field")

    @property
    @pulumi.getter(name="hashKeyValue")
    def hash_key_value(self) -> builtins.str:
        """
        The value of the hash key (also called the partition key).
        """
        return pulumi.get(self, "hash_key_value")

    @property
    @pulumi.getter(name="tableName")
    def table_name(self) -> builtins.str:
        """
        The name of the DynamoDB table. The ``tableName`` value must match the table name of the target DynamoDB table.
        """
        return pulumi.get(self, "table_name")

    @property
    @pulumi.getter(name="hashKeyType")
    def hash_key_type(self) -> Optional[builtins.str]:
        """
        The data type for the hash key (also called the partition key). You can specify the following values:
          +   ``'STRING'`` - The hash key is a string.
          +   ``'NUMBER'`` - The hash key is a number.
          
         If you don't specify ``hashKeyType``, the default value is ``'STRING'``.
        """
        return pulumi.get(self, "hash_key_type")

    @property
    @pulumi.getter
    def operation(self) -> Optional[builtins.str]:
        """
        The type of operation to perform. You can specify the following values: 
          +   ``'INSERT'`` - Insert data as a new item into the DynamoDB table. This item uses the specified hash key as a partition key. If you specified a range key, the item uses the range key as a sort key.
          +   ``'UPDATE'`` - Update an existing item of the DynamoDB table with new data. This item's partition key must match the specified hash key. If you specified a range key, the range key must match the item's sort key.
          +   ``'DELETE'`` - Delete an existing item of the DynamoDB table. This item's partition key must match the specified hash key. If you specified a range key, the range key must match the item's sort key.
          
         If you don't specify this parameter, ITE triggers the ``'INSERT'`` operation.
        """
        return pulumi.get(self, "operation")

    @property
    @pulumi.getter
    def payload(self) -> Optional['outputs.DetectorModelPayload']:
        """
        Information needed to configure the payload.
         By default, ITE generates a standard payload in JSON for any action. This action payload contains all attribute-value pairs that have the information about the detector model instance and the event triggered the action. To configure the action payload, you can use ``contentExpression``.
        """
        return pulumi.get(self, "payload")

    @property
    @pulumi.getter(name="payloadField")
    def payload_field(self) -> Optional[builtins.str]:
        """
        The name of the DynamoDB column that receives the action payload.
         If you don't specify this parameter, the name of the DynamoDB column is ``payload``.
        """
        return pulumi.get(self, "payload_field")

    @property
    @pulumi.getter(name="rangeKeyField")
    def range_key_field(self) -> Optional[builtins.str]:
        """
        The name of the range key (also called the sort key). The ``rangeKeyField`` value must match the sort key of the target DynamoDB table.
        """
        return pulumi.get(self, "range_key_field")

    @property
    @pulumi.getter(name="rangeKeyType")
    def range_key_type(self) -> Optional[builtins.str]:
        """
        The data type for the range key (also called the sort key), You can specify the following values:
          +   ``'STRING'`` - The range key is a string.
          +   ``'NUMBER'`` - The range key is number.
          
         If you don't specify ``rangeKeyField``, the default value is ``'STRING'``.
        """
        return pulumi.get(self, "range_key_type")

    @property
    @pulumi.getter(name="rangeKeyValue")
    def range_key_value(self) -> Optional[builtins.str]:
        """
        The value of the range key (also called the sort key).
        """
        return pulumi.get(self, "range_key_value")


@pulumi.output_type
class DetectorModelEvent(dict):
    """
    Specifies the ``actions`` to be performed when the ``condition`` evaluates to TRUE.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "eventName":
            suggest = "event_name"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in DetectorModelEvent. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        DetectorModelEvent.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        DetectorModelEvent.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 event_name: builtins.str,
                 actions: Optional[Sequence['outputs.DetectorModelAction']] = None,
                 condition: Optional[builtins.str] = None):
        """
        Specifies the ``actions`` to be performed when the ``condition`` evaluates to TRUE.
        :param builtins.str event_name: The name of the event.
        :param Sequence['DetectorModelAction'] actions: The actions to be performed.
        :param builtins.str condition: Optional. The Boolean expression that, when TRUE, causes the ``actions`` to be performed. If not present, the actions are performed (=TRUE). If the expression result is not a Boolean value, the actions are not performed (=FALSE).
        """
        pulumi.set(__self__, "event_name", event_name)
        if actions is not None:
            pulumi.set(__self__, "actions", actions)
        if condition is not None:
            pulumi.set(__self__, "condition", condition)

    @property
    @pulumi.getter(name="eventName")
    def event_name(self) -> builtins.str:
        """
        The name of the event.
        """
        return pulumi.get(self, "event_name")

    @property
    @pulumi.getter
    def actions(self) -> Optional[Sequence['outputs.DetectorModelAction']]:
        """
        The actions to be performed.
        """
        return pulumi.get(self, "actions")

    @property
    @pulumi.getter
    def condition(self) -> Optional[builtins.str]:
        """
        Optional. The Boolean expression that, when TRUE, causes the ``actions`` to be performed. If not present, the actions are performed (=TRUE). If the expression result is not a Boolean value, the actions are not performed (=FALSE).
        """
        return pulumi.get(self, "condition")


@pulumi.output_type
class DetectorModelFirehose(dict):
    """
    Sends information about the detector model instance and the event that triggered the action to an Amazon Kinesis Data Firehose delivery stream.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "deliveryStreamName":
            suggest = "delivery_stream_name"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in DetectorModelFirehose. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        DetectorModelFirehose.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        DetectorModelFirehose.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 delivery_stream_name: builtins.str,
                 payload: Optional['outputs.DetectorModelPayload'] = None,
                 separator: Optional[builtins.str] = None):
        """
        Sends information about the detector model instance and the event that triggered the action to an Amazon Kinesis Data Firehose delivery stream.
        :param builtins.str delivery_stream_name: The name of the Kinesis Data Firehose delivery stream where the data is written.
        :param 'DetectorModelPayload' payload: You can configure the action payload when you send a message to an Amazon Data Firehose delivery stream.
        :param builtins.str separator: A character separator that is used to separate records written to the Kinesis Data Firehose delivery stream. Valid values are: '\\n' (newline), '\\t' (tab), '\\r\\n' (Windows newline), ',' (comma).
        """
        pulumi.set(__self__, "delivery_stream_name", delivery_stream_name)
        if payload is not None:
            pulumi.set(__self__, "payload", payload)
        if separator is not None:
            pulumi.set(__self__, "separator", separator)

    @property
    @pulumi.getter(name="deliveryStreamName")
    def delivery_stream_name(self) -> builtins.str:
        """
        The name of the Kinesis Data Firehose delivery stream where the data is written.
        """
        return pulumi.get(self, "delivery_stream_name")

    @property
    @pulumi.getter
    def payload(self) -> Optional['outputs.DetectorModelPayload']:
        """
        You can configure the action payload when you send a message to an Amazon Data Firehose delivery stream.
        """
        return pulumi.get(self, "payload")

    @property
    @pulumi.getter
    def separator(self) -> Optional[builtins.str]:
        """
        A character separator that is used to separate records written to the Kinesis Data Firehose delivery stream. Valid values are: '\\n' (newline), '\\t' (tab), '\\r\\n' (Windows newline), ',' (comma).
        """
        return pulumi.get(self, "separator")


@pulumi.output_type
class DetectorModelIotEvents(dict):
    """
    Sends an ITE input, passing in information about the detector model instance and the event that triggered the action.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "inputName":
            suggest = "input_name"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in DetectorModelIotEvents. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        DetectorModelIotEvents.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        DetectorModelIotEvents.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 input_name: builtins.str,
                 payload: Optional['outputs.DetectorModelPayload'] = None):
        """
        Sends an ITE input, passing in information about the detector model instance and the event that triggered the action.
        :param builtins.str input_name: The name of the ITE input where the data is sent.
        :param 'DetectorModelPayload' payload: You can configure the action payload when you send a message to an ITE input.
        """
        pulumi.set(__self__, "input_name", input_name)
        if payload is not None:
            pulumi.set(__self__, "payload", payload)

    @property
    @pulumi.getter(name="inputName")
    def input_name(self) -> builtins.str:
        """
        The name of the ITE input where the data is sent.
        """
        return pulumi.get(self, "input_name")

    @property
    @pulumi.getter
    def payload(self) -> Optional['outputs.DetectorModelPayload']:
        """
        You can configure the action payload when you send a message to an ITE input.
        """
        return pulumi.get(self, "payload")


@pulumi.output_type
class DetectorModelIotSiteWise(dict):
    """
    Sends information about the detector model instance and the event that triggered the action to a specified asset property in ITSW.
     You must use expressions for all parameters in ``IotSiteWiseAction``. The expressions accept literals, operators, functions, references, and substitutions templates.
      **Examples**
     +  For literal values, the expressions must contain single quotes. For example, the value for the ``propertyAlias`` parameter can be ``'/company/windfarm/3/turbine/7/temperature'``.
      +  For references, you must specify either variables or input values. For example, the value for the ``assetId`` parameter can be ``$input.TurbineInput.assetId1``.
      +  For a substitution template, you must use ``${}``, and the template must be in single quotes. A substitution template can also contain a combination of literals, operators, functions, references, and substitution templates.
     In the following example, the value for the ``propertyAlias`` parameter uses a substitution template. 
      ``'company/windfarm/${$input.TemperatureInput.sensorData.windfarmID}/turbine/ ${$input.TemperatureInput.sensorData.turbineID}/temperature'`` 
      
     You must specify either ``propertyAlias`` or both ``assetId`` and ``propertyId`` to identify the target asset property in ITSW.
     For more information, see [Expressions](https://docs.aws.amazon.com/iotevents/latest/developerguide/iotevents-expressions.html) in the *Developer Guide*.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "propertyValue":
            suggest = "property_value"
        elif key == "assetId":
            suggest = "asset_id"
        elif key == "entryId":
            suggest = "entry_id"
        elif key == "propertyAlias":
            suggest = "property_alias"
        elif key == "propertyId":
            suggest = "property_id"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in DetectorModelIotSiteWise. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        DetectorModelIotSiteWise.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        DetectorModelIotSiteWise.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 property_value: 'outputs.DetectorModelAssetPropertyValue',
                 asset_id: Optional[builtins.str] = None,
                 entry_id: Optional[builtins.str] = None,
                 property_alias: Optional[builtins.str] = None,
                 property_id: Optional[builtins.str] = None):
        """
        Sends information about the detector model instance and the event that triggered the action to a specified asset property in ITSW.
         You must use expressions for all parameters in ``IotSiteWiseAction``. The expressions accept literals, operators, functions, references, and substitutions templates.
          **Examples**
         +  For literal values, the expressions must contain single quotes. For example, the value for the ``propertyAlias`` parameter can be ``'/company/windfarm/3/turbine/7/temperature'``.
          +  For references, you must specify either variables or input values. For example, the value for the ``assetId`` parameter can be ``$input.TurbineInput.assetId1``.
          +  For a substitution template, you must use ``${}``, and the template must be in single quotes. A substitution template can also contain a combination of literals, operators, functions, references, and substitution templates.
         In the following example, the value for the ``propertyAlias`` parameter uses a substitution template. 
          ``'company/windfarm/${$input.TemperatureInput.sensorData.windfarmID}/turbine/ ${$input.TemperatureInput.sensorData.turbineID}/temperature'`` 
          
         You must specify either ``propertyAlias`` or both ``assetId`` and ``propertyId`` to identify the target asset property in ITSW.
         For more information, see [Expressions](https://docs.aws.amazon.com/iotevents/latest/developerguide/iotevents-expressions.html) in the *Developer Guide*.
        :param 'DetectorModelAssetPropertyValue' property_value: The value to send to the asset property. This value contains timestamp, quality, and value (TQV) information.
        :param builtins.str asset_id: The ID of the asset that has the specified property.
        :param builtins.str entry_id: A unique identifier for this entry. You can use the entry ID to track which data entry causes an error in case of failure. The default is a new unique identifier.
        :param builtins.str property_alias: The alias of the asset property.
        :param builtins.str property_id: The ID of the asset property.
        """
        pulumi.set(__self__, "property_value", property_value)
        if asset_id is not None:
            pulumi.set(__self__, "asset_id", asset_id)
        if entry_id is not None:
            pulumi.set(__self__, "entry_id", entry_id)
        if property_alias is not None:
            pulumi.set(__self__, "property_alias", property_alias)
        if property_id is not None:
            pulumi.set(__self__, "property_id", property_id)

    @property
    @pulumi.getter(name="propertyValue")
    def property_value(self) -> 'outputs.DetectorModelAssetPropertyValue':
        """
        The value to send to the asset property. This value contains timestamp, quality, and value (TQV) information.
        """
        return pulumi.get(self, "property_value")

    @property
    @pulumi.getter(name="assetId")
    def asset_id(self) -> Optional[builtins.str]:
        """
        The ID of the asset that has the specified property.
        """
        return pulumi.get(self, "asset_id")

    @property
    @pulumi.getter(name="entryId")
    def entry_id(self) -> Optional[builtins.str]:
        """
        A unique identifier for this entry. You can use the entry ID to track which data entry causes an error in case of failure. The default is a new unique identifier.
        """
        return pulumi.get(self, "entry_id")

    @property
    @pulumi.getter(name="propertyAlias")
    def property_alias(self) -> Optional[builtins.str]:
        """
        The alias of the asset property.
        """
        return pulumi.get(self, "property_alias")

    @property
    @pulumi.getter(name="propertyId")
    def property_id(self) -> Optional[builtins.str]:
        """
        The ID of the asset property.
        """
        return pulumi.get(self, "property_id")


@pulumi.output_type
class DetectorModelIotTopicPublish(dict):
    """
    Information required to publish the MQTT message through the IoT message broker.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "mqttTopic":
            suggest = "mqtt_topic"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in DetectorModelIotTopicPublish. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        DetectorModelIotTopicPublish.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        DetectorModelIotTopicPublish.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 mqtt_topic: builtins.str,
                 payload: Optional['outputs.DetectorModelPayload'] = None):
        """
        Information required to publish the MQTT message through the IoT message broker.
        :param builtins.str mqtt_topic: The MQTT topic of the message. You can use a string expression that includes variables (``$variable.<variable-name>``) and input values (``$input.<input-name>.<path-to-datum>``) as the topic string.
        :param 'DetectorModelPayload' payload: You can configure the action payload when you publish a message to an IoTCore topic.
        """
        pulumi.set(__self__, "mqtt_topic", mqtt_topic)
        if payload is not None:
            pulumi.set(__self__, "payload", payload)

    @property
    @pulumi.getter(name="mqttTopic")
    def mqtt_topic(self) -> builtins.str:
        """
        The MQTT topic of the message. You can use a string expression that includes variables (``$variable.<variable-name>``) and input values (``$input.<input-name>.<path-to-datum>``) as the topic string.
        """
        return pulumi.get(self, "mqtt_topic")

    @property
    @pulumi.getter
    def payload(self) -> Optional['outputs.DetectorModelPayload']:
        """
        You can configure the action payload when you publish a message to an IoTCore topic.
        """
        return pulumi.get(self, "payload")


@pulumi.output_type
class DetectorModelLambda(dict):
    """
    Calls a Lambda function, passing in information about the detector model instance and the event that triggered the action.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "functionArn":
            suggest = "function_arn"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in DetectorModelLambda. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        DetectorModelLambda.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        DetectorModelLambda.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 function_arn: builtins.str,
                 payload: Optional['outputs.DetectorModelPayload'] = None):
        """
        Calls a Lambda function, passing in information about the detector model instance and the event that triggered the action.
        :param builtins.str function_arn: The ARN of the Lambda function that is executed.
        :param 'DetectorModelPayload' payload: You can configure the action payload when you send a message to a Lambda function.
        """
        pulumi.set(__self__, "function_arn", function_arn)
        if payload is not None:
            pulumi.set(__self__, "payload", payload)

    @property
    @pulumi.getter(name="functionArn")
    def function_arn(self) -> builtins.str:
        """
        The ARN of the Lambda function that is executed.
        """
        return pulumi.get(self, "function_arn")

    @property
    @pulumi.getter
    def payload(self) -> Optional['outputs.DetectorModelPayload']:
        """
        You can configure the action payload when you send a message to a Lambda function.
        """
        return pulumi.get(self, "payload")


@pulumi.output_type
class DetectorModelOnEnter(dict):
    """
    When entering this state, perform these ``actions`` if the ``condition`` is TRUE.
    """
    def __init__(__self__, *,
                 events: Optional[Sequence['outputs.DetectorModelEvent']] = None):
        """
        When entering this state, perform these ``actions`` if the ``condition`` is TRUE.
        :param Sequence['DetectorModelEvent'] events: Specifies the actions that are performed when the state is entered and the ``condition`` is ``TRUE``.
        """
        if events is not None:
            pulumi.set(__self__, "events", events)

    @property
    @pulumi.getter
    def events(self) -> Optional[Sequence['outputs.DetectorModelEvent']]:
        """
        Specifies the actions that are performed when the state is entered and the ``condition`` is ``TRUE``.
        """
        return pulumi.get(self, "events")


@pulumi.output_type
class DetectorModelOnExit(dict):
    """
    When exiting this state, perform these ``actions`` if the specified ``condition`` is ``TRUE``.
    """
    def __init__(__self__, *,
                 events: Optional[Sequence['outputs.DetectorModelEvent']] = None):
        """
        When exiting this state, perform these ``actions`` if the specified ``condition`` is ``TRUE``.
        :param Sequence['DetectorModelEvent'] events: Specifies the ``actions`` that are performed when the state is exited and the ``condition`` is ``TRUE``.
        """
        if events is not None:
            pulumi.set(__self__, "events", events)

    @property
    @pulumi.getter
    def events(self) -> Optional[Sequence['outputs.DetectorModelEvent']]:
        """
        Specifies the ``actions`` that are performed when the state is exited and the ``condition`` is ``TRUE``.
        """
        return pulumi.get(self, "events")


@pulumi.output_type
class DetectorModelOnInput(dict):
    """
    Specifies the actions performed when the ``condition`` evaluates to TRUE.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "transitionEvents":
            suggest = "transition_events"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in DetectorModelOnInput. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        DetectorModelOnInput.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        DetectorModelOnInput.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 events: Optional[Sequence['outputs.DetectorModelEvent']] = None,
                 transition_events: Optional[Sequence['outputs.DetectorModelTransitionEvent']] = None):
        """
        Specifies the actions performed when the ``condition`` evaluates to TRUE.
        :param Sequence['DetectorModelEvent'] events: Specifies the actions performed when the ``condition`` evaluates to TRUE.
        :param Sequence['DetectorModelTransitionEvent'] transition_events: Specifies the actions performed, and the next state entered, when a ``condition`` evaluates to TRUE.
        """
        if events is not None:
            pulumi.set(__self__, "events", events)
        if transition_events is not None:
            pulumi.set(__self__, "transition_events", transition_events)

    @property
    @pulumi.getter
    def events(self) -> Optional[Sequence['outputs.DetectorModelEvent']]:
        """
        Specifies the actions performed when the ``condition`` evaluates to TRUE.
        """
        return pulumi.get(self, "events")

    @property
    @pulumi.getter(name="transitionEvents")
    def transition_events(self) -> Optional[Sequence['outputs.DetectorModelTransitionEvent']]:
        """
        Specifies the actions performed, and the next state entered, when a ``condition`` evaluates to TRUE.
        """
        return pulumi.get(self, "transition_events")


@pulumi.output_type
class DetectorModelPayload(dict):
    """
    Information needed to configure the payload.
     By default, ITE generates a standard payload in JSON for any action. This action payload contains all attribute-value pairs that have the information about the detector model instance and the event triggered the action. To configure the action payload, you can use ``contentExpression``.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "contentExpression":
            suggest = "content_expression"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in DetectorModelPayload. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        DetectorModelPayload.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        DetectorModelPayload.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 content_expression: builtins.str,
                 type: builtins.str):
        """
        Information needed to configure the payload.
         By default, ITE generates a standard payload in JSON for any action. This action payload contains all attribute-value pairs that have the information about the detector model instance and the event triggered the action. To configure the action payload, you can use ``contentExpression``.
        :param builtins.str content_expression: The content of the payload. You can use a string expression that includes quoted strings (``'<string>'``), variables (``$variable.<variable-name>``), input values (``$input.<input-name>.<path-to-datum>``), string concatenations, and quoted strings that contain ``${}`` as the content. The recommended maximum size of a content expression is 1 KB.
        :param builtins.str type: The value of the payload type can be either ``STRING`` or ``JSON``.
        """
        pulumi.set(__self__, "content_expression", content_expression)
        pulumi.set(__self__, "type", type)

    @property
    @pulumi.getter(name="contentExpression")
    def content_expression(self) -> builtins.str:
        """
        The content of the payload. You can use a string expression that includes quoted strings (``'<string>'``), variables (``$variable.<variable-name>``), input values (``$input.<input-name>.<path-to-datum>``), string concatenations, and quoted strings that contain ``${}`` as the content. The recommended maximum size of a content expression is 1 KB.
        """
        return pulumi.get(self, "content_expression")

    @property
    @pulumi.getter
    def type(self) -> builtins.str:
        """
        The value of the payload type can be either ``STRING`` or ``JSON``.
        """
        return pulumi.get(self, "type")


@pulumi.output_type
class DetectorModelResetTimer(dict):
    """
    Information required to reset the timer. The timer is reset to the previously evaluated result of the duration. The duration expression isn't reevaluated when you reset the timer.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "timerName":
            suggest = "timer_name"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in DetectorModelResetTimer. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        DetectorModelResetTimer.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        DetectorModelResetTimer.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 timer_name: builtins.str):
        """
        Information required to reset the timer. The timer is reset to the previously evaluated result of the duration. The duration expression isn't reevaluated when you reset the timer.
        :param builtins.str timer_name: The name of the timer to reset.
        """
        pulumi.set(__self__, "timer_name", timer_name)

    @property
    @pulumi.getter(name="timerName")
    def timer_name(self) -> builtins.str:
        """
        The name of the timer to reset.
        """
        return pulumi.get(self, "timer_name")


@pulumi.output_type
class DetectorModelSetTimer(dict):
    """
    Information needed to set the timer.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "timerName":
            suggest = "timer_name"
        elif key == "durationExpression":
            suggest = "duration_expression"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in DetectorModelSetTimer. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        DetectorModelSetTimer.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        DetectorModelSetTimer.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 timer_name: builtins.str,
                 duration_expression: Optional[builtins.str] = None,
                 seconds: Optional[builtins.int] = None):
        """
        Information needed to set the timer.
        :param builtins.str timer_name: The name of the timer.
        :param builtins.str duration_expression: The duration of the timer, in seconds. You can use a string expression that includes numbers, variables (``$variable.<variable-name>``), and input values (``$input.<input-name>.<path-to-datum>``) as the duration. The range of the duration is 1-31622400 seconds. To ensure accuracy, the minimum duration is 60 seconds. The evaluated result of the duration is rounded down to the nearest whole number.
        :param builtins.int seconds: The number of seconds until the timer expires. The minimum value is 60 seconds to ensure accuracy. The maximum value is 31622400 seconds.
        """
        pulumi.set(__self__, "timer_name", timer_name)
        if duration_expression is not None:
            pulumi.set(__self__, "duration_expression", duration_expression)
        if seconds is not None:
            pulumi.set(__self__, "seconds", seconds)

    @property
    @pulumi.getter(name="timerName")
    def timer_name(self) -> builtins.str:
        """
        The name of the timer.
        """
        return pulumi.get(self, "timer_name")

    @property
    @pulumi.getter(name="durationExpression")
    def duration_expression(self) -> Optional[builtins.str]:
        """
        The duration of the timer, in seconds. You can use a string expression that includes numbers, variables (``$variable.<variable-name>``), and input values (``$input.<input-name>.<path-to-datum>``) as the duration. The range of the duration is 1-31622400 seconds. To ensure accuracy, the minimum duration is 60 seconds. The evaluated result of the duration is rounded down to the nearest whole number.
        """
        return pulumi.get(self, "duration_expression")

    @property
    @pulumi.getter
    def seconds(self) -> Optional[builtins.int]:
        """
        The number of seconds until the timer expires. The minimum value is 60 seconds to ensure accuracy. The maximum value is 31622400 seconds.
        """
        return pulumi.get(self, "seconds")


@pulumi.output_type
class DetectorModelSetVariable(dict):
    """
    Information about the variable and its new value.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "variableName":
            suggest = "variable_name"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in DetectorModelSetVariable. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        DetectorModelSetVariable.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        DetectorModelSetVariable.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 value: builtins.str,
                 variable_name: builtins.str):
        """
        Information about the variable and its new value.
        :param builtins.str value: The new value of the variable.
        :param builtins.str variable_name: The name of the variable.
        """
        pulumi.set(__self__, "value", value)
        pulumi.set(__self__, "variable_name", variable_name)

    @property
    @pulumi.getter
    def value(self) -> builtins.str:
        """
        The new value of the variable.
        """
        return pulumi.get(self, "value")

    @property
    @pulumi.getter(name="variableName")
    def variable_name(self) -> builtins.str:
        """
        The name of the variable.
        """
        return pulumi.get(self, "variable_name")


@pulumi.output_type
class DetectorModelSns(dict):
    """
    Information required to publish the Amazon SNS message.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "targetArn":
            suggest = "target_arn"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in DetectorModelSns. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        DetectorModelSns.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        DetectorModelSns.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 target_arn: builtins.str,
                 payload: Optional['outputs.DetectorModelPayload'] = None):
        """
        Information required to publish the Amazon SNS message.
        :param builtins.str target_arn: The ARN of the Amazon SNS target where the message is sent.
        :param 'DetectorModelPayload' payload: You can configure the action payload when you send a message as an Amazon SNS push notification.
        """
        pulumi.set(__self__, "target_arn", target_arn)
        if payload is not None:
            pulumi.set(__self__, "payload", payload)

    @property
    @pulumi.getter(name="targetArn")
    def target_arn(self) -> builtins.str:
        """
        The ARN of the Amazon SNS target where the message is sent.
        """
        return pulumi.get(self, "target_arn")

    @property
    @pulumi.getter
    def payload(self) -> Optional['outputs.DetectorModelPayload']:
        """
        You can configure the action payload when you send a message as an Amazon SNS push notification.
        """
        return pulumi.get(self, "payload")


@pulumi.output_type
class DetectorModelSqs(dict):
    """
    Sends information about the detector model instance and the event that triggered the action to an Amazon SQS queue.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "queueUrl":
            suggest = "queue_url"
        elif key == "useBase64":
            suggest = "use_base64"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in DetectorModelSqs. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        DetectorModelSqs.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        DetectorModelSqs.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 queue_url: builtins.str,
                 payload: Optional['outputs.DetectorModelPayload'] = None,
                 use_base64: Optional[builtins.bool] = None):
        """
        Sends information about the detector model instance and the event that triggered the action to an Amazon SQS queue.
        :param builtins.str queue_url: The URL of the SQS queue where the data is written.
        :param 'DetectorModelPayload' payload: You can configure the action payload when you send a message to an Amazon SQS queue.
        :param builtins.bool use_base64: Set this to TRUE if you want the data to be base-64 encoded before it is written to the queue. Otherwise, set this to FALSE.
        """
        pulumi.set(__self__, "queue_url", queue_url)
        if payload is not None:
            pulumi.set(__self__, "payload", payload)
        if use_base64 is not None:
            pulumi.set(__self__, "use_base64", use_base64)

    @property
    @pulumi.getter(name="queueUrl")
    def queue_url(self) -> builtins.str:
        """
        The URL of the SQS queue where the data is written.
        """
        return pulumi.get(self, "queue_url")

    @property
    @pulumi.getter
    def payload(self) -> Optional['outputs.DetectorModelPayload']:
        """
        You can configure the action payload when you send a message to an Amazon SQS queue.
        """
        return pulumi.get(self, "payload")

    @property
    @pulumi.getter(name="useBase64")
    def use_base64(self) -> Optional[builtins.bool]:
        """
        Set this to TRUE if you want the data to be base-64 encoded before it is written to the queue. Otherwise, set this to FALSE.
        """
        return pulumi.get(self, "use_base64")


@pulumi.output_type
class DetectorModelState(dict):
    """
    Information that defines a state of a detector.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "stateName":
            suggest = "state_name"
        elif key == "onEnter":
            suggest = "on_enter"
        elif key == "onExit":
            suggest = "on_exit"
        elif key == "onInput":
            suggest = "on_input"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in DetectorModelState. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        DetectorModelState.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        DetectorModelState.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 state_name: builtins.str,
                 on_enter: Optional['outputs.DetectorModelOnEnter'] = None,
                 on_exit: Optional['outputs.DetectorModelOnExit'] = None,
                 on_input: Optional['outputs.DetectorModelOnInput'] = None):
        """
        Information that defines a state of a detector.
        :param builtins.str state_name: The name of the state.
        :param 'DetectorModelOnEnter' on_enter: When entering this state, perform these ``actions`` if the ``condition`` is TRUE.
        :param 'DetectorModelOnExit' on_exit: When exiting this state, perform these ``actions`` if the specified ``condition`` is ``TRUE``.
        :param 'DetectorModelOnInput' on_input: When an input is received and the ``condition`` is TRUE, perform the specified ``actions``.
        """
        pulumi.set(__self__, "state_name", state_name)
        if on_enter is not None:
            pulumi.set(__self__, "on_enter", on_enter)
        if on_exit is not None:
            pulumi.set(__self__, "on_exit", on_exit)
        if on_input is not None:
            pulumi.set(__self__, "on_input", on_input)

    @property
    @pulumi.getter(name="stateName")
    def state_name(self) -> builtins.str:
        """
        The name of the state.
        """
        return pulumi.get(self, "state_name")

    @property
    @pulumi.getter(name="onEnter")
    def on_enter(self) -> Optional['outputs.DetectorModelOnEnter']:
        """
        When entering this state, perform these ``actions`` if the ``condition`` is TRUE.
        """
        return pulumi.get(self, "on_enter")

    @property
    @pulumi.getter(name="onExit")
    def on_exit(self) -> Optional['outputs.DetectorModelOnExit']:
        """
        When exiting this state, perform these ``actions`` if the specified ``condition`` is ``TRUE``.
        """
        return pulumi.get(self, "on_exit")

    @property
    @pulumi.getter(name="onInput")
    def on_input(self) -> Optional['outputs.DetectorModelOnInput']:
        """
        When an input is received and the ``condition`` is TRUE, perform the specified ``actions``.
        """
        return pulumi.get(self, "on_input")


@pulumi.output_type
class DetectorModelTransitionEvent(dict):
    """
    Specifies the actions performed and the next state entered when a ``condition`` evaluates to TRUE.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "eventName":
            suggest = "event_name"
        elif key == "nextState":
            suggest = "next_state"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in DetectorModelTransitionEvent. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        DetectorModelTransitionEvent.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        DetectorModelTransitionEvent.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 condition: builtins.str,
                 event_name: builtins.str,
                 next_state: builtins.str,
                 actions: Optional[Sequence['outputs.DetectorModelAction']] = None):
        """
        Specifies the actions performed and the next state entered when a ``condition`` evaluates to TRUE.
        :param builtins.str condition: Required. A Boolean expression that when TRUE causes the actions to be performed and the ``nextState`` to be entered.
        :param builtins.str event_name: The name of the transition event.
        :param builtins.str next_state: The next state to enter.
        :param Sequence['DetectorModelAction'] actions: The actions to be performed.
        """
        pulumi.set(__self__, "condition", condition)
        pulumi.set(__self__, "event_name", event_name)
        pulumi.set(__self__, "next_state", next_state)
        if actions is not None:
            pulumi.set(__self__, "actions", actions)

    @property
    @pulumi.getter
    def condition(self) -> builtins.str:
        """
        Required. A Boolean expression that when TRUE causes the actions to be performed and the ``nextState`` to be entered.
        """
        return pulumi.get(self, "condition")

    @property
    @pulumi.getter(name="eventName")
    def event_name(self) -> builtins.str:
        """
        The name of the transition event.
        """
        return pulumi.get(self, "event_name")

    @property
    @pulumi.getter(name="nextState")
    def next_state(self) -> builtins.str:
        """
        The next state to enter.
        """
        return pulumi.get(self, "next_state")

    @property
    @pulumi.getter
    def actions(self) -> Optional[Sequence['outputs.DetectorModelAction']]:
        """
        The actions to be performed.
        """
        return pulumi.get(self, "actions")


@pulumi.output_type
class InputAttribute(dict):
    """
    The attributes from the JSON payload that are made available by the input. Inputs are derived from messages sent to the ITE system using ``BatchPutMessage``. Each such message contains a JSON payload. Those attributes (and their paired values) specified here are available for use in the ``condition`` expressions used by detectors.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "jsonPath":
            suggest = "json_path"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in InputAttribute. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        InputAttribute.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        InputAttribute.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 json_path: builtins.str):
        """
        The attributes from the JSON payload that are made available by the input. Inputs are derived from messages sent to the ITE system using ``BatchPutMessage``. Each such message contains a JSON payload. Those attributes (and their paired values) specified here are available for use in the ``condition`` expressions used by detectors.
        :param builtins.str json_path: An expression that specifies an attribute-value pair in a JSON structure. Use this to specify an attribute from the JSON payload that is made available by the input. Inputs are derived from messages sent to ITE (``BatchPutMessage``). Each such message contains a JSON payload. The attribute (and its paired value) specified here are available for use in the ``condition`` expressions used by detectors. 
                Syntax: ``<field-name>.<field-name>...``
        """
        pulumi.set(__self__, "json_path", json_path)

    @property
    @pulumi.getter(name="jsonPath")
    def json_path(self) -> builtins.str:
        """
        An expression that specifies an attribute-value pair in a JSON structure. Use this to specify an attribute from the JSON payload that is made available by the input. Inputs are derived from messages sent to ITE (``BatchPutMessage``). Each such message contains a JSON payload. The attribute (and its paired value) specified here are available for use in the ``condition`` expressions used by detectors. 
         Syntax: ``<field-name>.<field-name>...``
        """
        return pulumi.get(self, "json_path")


@pulumi.output_type
class InputDefinition(dict):
    """
    The definition of the input.
    """
    def __init__(__self__, *,
                 attributes: Sequence['outputs.InputAttribute']):
        """
        The definition of the input.
        :param Sequence['InputAttribute'] attributes: The attributes from the JSON payload that are made available by the input. Inputs are derived from messages sent to the ITE system using ``BatchPutMessage``. Each such message contains a JSON payload, and those attributes (and their paired values) specified here are available for use in the ``condition`` expressions used by detectors that monitor this input.
        """
        pulumi.set(__self__, "attributes", attributes)

    @property
    @pulumi.getter
    def attributes(self) -> Sequence['outputs.InputAttribute']:
        """
        The attributes from the JSON payload that are made available by the input. Inputs are derived from messages sent to the ITE system using ``BatchPutMessage``. Each such message contains a JSON payload, and those attributes (and their paired values) specified here are available for use in the ``condition`` expressions used by detectors that monitor this input.
        """
        return pulumi.get(self, "attributes")


