# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs
from .. import _inputs as _root_inputs
from .. import outputs as _root_outputs
from ._enums import *
from ._inputs import *

__all__ = ['AlarmModelArgs', 'AlarmModel']

@pulumi.input_type
class AlarmModelArgs:
    def __init__(__self__, *,
                 alarm_rule: pulumi.Input['AlarmModelAlarmRuleArgs'],
                 role_arn: pulumi.Input[builtins.str],
                 alarm_capabilities: Optional[pulumi.Input['AlarmModelAlarmCapabilitiesArgs']] = None,
                 alarm_event_actions: Optional[pulumi.Input['AlarmModelAlarmEventActionsArgs']] = None,
                 alarm_model_description: Optional[pulumi.Input[builtins.str]] = None,
                 alarm_model_name: Optional[pulumi.Input[builtins.str]] = None,
                 key: Optional[pulumi.Input[builtins.str]] = None,
                 severity: Optional[pulumi.Input[builtins.int]] = None,
                 tags: Optional[pulumi.Input[Sequence[pulumi.Input['_root_inputs.TagArgs']]]] = None):
        """
        The set of arguments for constructing a AlarmModel resource.
        :param pulumi.Input['AlarmModelAlarmRuleArgs'] alarm_rule: Defines when your alarm is invoked.
        :param pulumi.Input[builtins.str] role_arn: The ARN of the IAM role that allows the alarm to perform actions and access AWS resources. For more information, see [Amazon Resource Names (ARNs)](https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html) in the *General Reference*.
        :param pulumi.Input['AlarmModelAlarmCapabilitiesArgs'] alarm_capabilities: Contains the configuration information of alarm state changes.
        :param pulumi.Input['AlarmModelAlarmEventActionsArgs'] alarm_event_actions: Contains information about one or more alarm actions.
        :param pulumi.Input[builtins.str] alarm_model_description: The description of the alarm model.
        :param pulumi.Input[builtins.str] alarm_model_name: The name of the alarm model.
        :param pulumi.Input[builtins.str] key: An input attribute used as a key to create an alarm. ITE routes [inputs](https://docs.aws.amazon.com/iotevents/latest/apireference/API_Input.html) associated with this key to the alarm.
        :param pulumi.Input[builtins.int] severity: A non-negative integer that reflects the severity level of the alarm.
        :param pulumi.Input[Sequence[pulumi.Input['_root_inputs.TagArgs']]] tags: A list of key-value pairs that contain metadata for the alarm model. The tags help you manage the alarm model. For more information, see [Tagging your resources](https://docs.aws.amazon.com/iotevents/latest/developerguide/tagging-iotevents.html) in the *Developer Guide*.
                You can create up to 50 tags for one alarm model.
        """
        pulumi.set(__self__, "alarm_rule", alarm_rule)
        pulumi.set(__self__, "role_arn", role_arn)
        if alarm_capabilities is not None:
            pulumi.set(__self__, "alarm_capabilities", alarm_capabilities)
        if alarm_event_actions is not None:
            pulumi.set(__self__, "alarm_event_actions", alarm_event_actions)
        if alarm_model_description is not None:
            pulumi.set(__self__, "alarm_model_description", alarm_model_description)
        if alarm_model_name is not None:
            pulumi.set(__self__, "alarm_model_name", alarm_model_name)
        if key is not None:
            pulumi.set(__self__, "key", key)
        if severity is not None:
            pulumi.set(__self__, "severity", severity)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)

    @property
    @pulumi.getter(name="alarmRule")
    def alarm_rule(self) -> pulumi.Input['AlarmModelAlarmRuleArgs']:
        """
        Defines when your alarm is invoked.
        """
        return pulumi.get(self, "alarm_rule")

    @alarm_rule.setter
    def alarm_rule(self, value: pulumi.Input['AlarmModelAlarmRuleArgs']):
        pulumi.set(self, "alarm_rule", value)

    @property
    @pulumi.getter(name="roleArn")
    def role_arn(self) -> pulumi.Input[builtins.str]:
        """
        The ARN of the IAM role that allows the alarm to perform actions and access AWS resources. For more information, see [Amazon Resource Names (ARNs)](https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html) in the *General Reference*.
        """
        return pulumi.get(self, "role_arn")

    @role_arn.setter
    def role_arn(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "role_arn", value)

    @property
    @pulumi.getter(name="alarmCapabilities")
    def alarm_capabilities(self) -> Optional[pulumi.Input['AlarmModelAlarmCapabilitiesArgs']]:
        """
        Contains the configuration information of alarm state changes.
        """
        return pulumi.get(self, "alarm_capabilities")

    @alarm_capabilities.setter
    def alarm_capabilities(self, value: Optional[pulumi.Input['AlarmModelAlarmCapabilitiesArgs']]):
        pulumi.set(self, "alarm_capabilities", value)

    @property
    @pulumi.getter(name="alarmEventActions")
    def alarm_event_actions(self) -> Optional[pulumi.Input['AlarmModelAlarmEventActionsArgs']]:
        """
        Contains information about one or more alarm actions.
        """
        return pulumi.get(self, "alarm_event_actions")

    @alarm_event_actions.setter
    def alarm_event_actions(self, value: Optional[pulumi.Input['AlarmModelAlarmEventActionsArgs']]):
        pulumi.set(self, "alarm_event_actions", value)

    @property
    @pulumi.getter(name="alarmModelDescription")
    def alarm_model_description(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The description of the alarm model.
        """
        return pulumi.get(self, "alarm_model_description")

    @alarm_model_description.setter
    def alarm_model_description(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "alarm_model_description", value)

    @property
    @pulumi.getter(name="alarmModelName")
    def alarm_model_name(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The name of the alarm model.
        """
        return pulumi.get(self, "alarm_model_name")

    @alarm_model_name.setter
    def alarm_model_name(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "alarm_model_name", value)

    @property
    @pulumi.getter
    def key(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        An input attribute used as a key to create an alarm. ITE routes [inputs](https://docs.aws.amazon.com/iotevents/latest/apireference/API_Input.html) associated with this key to the alarm.
        """
        return pulumi.get(self, "key")

    @key.setter
    def key(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "key", value)

    @property
    @pulumi.getter
    def severity(self) -> Optional[pulumi.Input[builtins.int]]:
        """
        A non-negative integer that reflects the severity level of the alarm.
        """
        return pulumi.get(self, "severity")

    @severity.setter
    def severity(self, value: Optional[pulumi.Input[builtins.int]]):
        pulumi.set(self, "severity", value)

    @property
    @pulumi.getter
    def tags(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['_root_inputs.TagArgs']]]]:
        """
        A list of key-value pairs that contain metadata for the alarm model. The tags help you manage the alarm model. For more information, see [Tagging your resources](https://docs.aws.amazon.com/iotevents/latest/developerguide/tagging-iotevents.html) in the *Developer Guide*.
         You can create up to 50 tags for one alarm model.
        """
        return pulumi.get(self, "tags")

    @tags.setter
    def tags(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['_root_inputs.TagArgs']]]]):
        pulumi.set(self, "tags", value)


@pulumi.type_token("aws-native:iotevents:AlarmModel")
class AlarmModel(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 alarm_capabilities: Optional[pulumi.Input[Union['AlarmModelAlarmCapabilitiesArgs', 'AlarmModelAlarmCapabilitiesArgsDict']]] = None,
                 alarm_event_actions: Optional[pulumi.Input[Union['AlarmModelAlarmEventActionsArgs', 'AlarmModelAlarmEventActionsArgsDict']]] = None,
                 alarm_model_description: Optional[pulumi.Input[builtins.str]] = None,
                 alarm_model_name: Optional[pulumi.Input[builtins.str]] = None,
                 alarm_rule: Optional[pulumi.Input[Union['AlarmModelAlarmRuleArgs', 'AlarmModelAlarmRuleArgsDict']]] = None,
                 key: Optional[pulumi.Input[builtins.str]] = None,
                 role_arn: Optional[pulumi.Input[builtins.str]] = None,
                 severity: Optional[pulumi.Input[builtins.int]] = None,
                 tags: Optional[pulumi.Input[Sequence[pulumi.Input[Union['_root_inputs.TagArgs', '_root_inputs.TagArgsDict']]]]] = None,
                 __props__=None):
        """
        Represents an alarm model to monitor an ITE input attribute. You can use the alarm to get notified when the value is outside a specified range. For more information, see [Create an alarm model](https://docs.aws.amazon.com/iotevents/latest/developerguide/create-alarms.html) in the *Developer Guide*.

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[Union['AlarmModelAlarmCapabilitiesArgs', 'AlarmModelAlarmCapabilitiesArgsDict']] alarm_capabilities: Contains the configuration information of alarm state changes.
        :param pulumi.Input[Union['AlarmModelAlarmEventActionsArgs', 'AlarmModelAlarmEventActionsArgsDict']] alarm_event_actions: Contains information about one or more alarm actions.
        :param pulumi.Input[builtins.str] alarm_model_description: The description of the alarm model.
        :param pulumi.Input[builtins.str] alarm_model_name: The name of the alarm model.
        :param pulumi.Input[Union['AlarmModelAlarmRuleArgs', 'AlarmModelAlarmRuleArgsDict']] alarm_rule: Defines when your alarm is invoked.
        :param pulumi.Input[builtins.str] key: An input attribute used as a key to create an alarm. ITE routes [inputs](https://docs.aws.amazon.com/iotevents/latest/apireference/API_Input.html) associated with this key to the alarm.
        :param pulumi.Input[builtins.str] role_arn: The ARN of the IAM role that allows the alarm to perform actions and access AWS resources. For more information, see [Amazon Resource Names (ARNs)](https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html) in the *General Reference*.
        :param pulumi.Input[builtins.int] severity: A non-negative integer that reflects the severity level of the alarm.
        :param pulumi.Input[Sequence[pulumi.Input[Union['_root_inputs.TagArgs', '_root_inputs.TagArgsDict']]]] tags: A list of key-value pairs that contain metadata for the alarm model. The tags help you manage the alarm model. For more information, see [Tagging your resources](https://docs.aws.amazon.com/iotevents/latest/developerguide/tagging-iotevents.html) in the *Developer Guide*.
                You can create up to 50 tags for one alarm model.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: AlarmModelArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Represents an alarm model to monitor an ITE input attribute. You can use the alarm to get notified when the value is outside a specified range. For more information, see [Create an alarm model](https://docs.aws.amazon.com/iotevents/latest/developerguide/create-alarms.html) in the *Developer Guide*.

        :param str resource_name: The name of the resource.
        :param AlarmModelArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(AlarmModelArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 alarm_capabilities: Optional[pulumi.Input[Union['AlarmModelAlarmCapabilitiesArgs', 'AlarmModelAlarmCapabilitiesArgsDict']]] = None,
                 alarm_event_actions: Optional[pulumi.Input[Union['AlarmModelAlarmEventActionsArgs', 'AlarmModelAlarmEventActionsArgsDict']]] = None,
                 alarm_model_description: Optional[pulumi.Input[builtins.str]] = None,
                 alarm_model_name: Optional[pulumi.Input[builtins.str]] = None,
                 alarm_rule: Optional[pulumi.Input[Union['AlarmModelAlarmRuleArgs', 'AlarmModelAlarmRuleArgsDict']]] = None,
                 key: Optional[pulumi.Input[builtins.str]] = None,
                 role_arn: Optional[pulumi.Input[builtins.str]] = None,
                 severity: Optional[pulumi.Input[builtins.int]] = None,
                 tags: Optional[pulumi.Input[Sequence[pulumi.Input[Union['_root_inputs.TagArgs', '_root_inputs.TagArgsDict']]]]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = AlarmModelArgs.__new__(AlarmModelArgs)

            __props__.__dict__["alarm_capabilities"] = alarm_capabilities
            __props__.__dict__["alarm_event_actions"] = alarm_event_actions
            __props__.__dict__["alarm_model_description"] = alarm_model_description
            __props__.__dict__["alarm_model_name"] = alarm_model_name
            if alarm_rule is None and not opts.urn:
                raise TypeError("Missing required property 'alarm_rule'")
            __props__.__dict__["alarm_rule"] = alarm_rule
            __props__.__dict__["key"] = key
            if role_arn is None and not opts.urn:
                raise TypeError("Missing required property 'role_arn'")
            __props__.__dict__["role_arn"] = role_arn
            __props__.__dict__["severity"] = severity
            __props__.__dict__["tags"] = tags
        replace_on_changes = pulumi.ResourceOptions(replace_on_changes=["alarmModelName", "key"])
        opts = pulumi.ResourceOptions.merge(opts, replace_on_changes)
        super(AlarmModel, __self__).__init__(
            'aws-native:iotevents:AlarmModel',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None) -> 'AlarmModel':
        """
        Get an existing AlarmModel resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = AlarmModelArgs.__new__(AlarmModelArgs)

        __props__.__dict__["alarm_capabilities"] = None
        __props__.__dict__["alarm_event_actions"] = None
        __props__.__dict__["alarm_model_description"] = None
        __props__.__dict__["alarm_model_name"] = None
        __props__.__dict__["alarm_rule"] = None
        __props__.__dict__["key"] = None
        __props__.__dict__["role_arn"] = None
        __props__.__dict__["severity"] = None
        __props__.__dict__["tags"] = None
        return AlarmModel(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter(name="alarmCapabilities")
    def alarm_capabilities(self) -> pulumi.Output[Optional['outputs.AlarmModelAlarmCapabilities']]:
        """
        Contains the configuration information of alarm state changes.
        """
        return pulumi.get(self, "alarm_capabilities")

    @property
    @pulumi.getter(name="alarmEventActions")
    def alarm_event_actions(self) -> pulumi.Output[Optional['outputs.AlarmModelAlarmEventActions']]:
        """
        Contains information about one or more alarm actions.
        """
        return pulumi.get(self, "alarm_event_actions")

    @property
    @pulumi.getter(name="alarmModelDescription")
    def alarm_model_description(self) -> pulumi.Output[Optional[builtins.str]]:
        """
        The description of the alarm model.
        """
        return pulumi.get(self, "alarm_model_description")

    @property
    @pulumi.getter(name="alarmModelName")
    def alarm_model_name(self) -> pulumi.Output[Optional[builtins.str]]:
        """
        The name of the alarm model.
        """
        return pulumi.get(self, "alarm_model_name")

    @property
    @pulumi.getter(name="alarmRule")
    def alarm_rule(self) -> pulumi.Output['outputs.AlarmModelAlarmRule']:
        """
        Defines when your alarm is invoked.
        """
        return pulumi.get(self, "alarm_rule")

    @property
    @pulumi.getter
    def key(self) -> pulumi.Output[Optional[builtins.str]]:
        """
        An input attribute used as a key to create an alarm. ITE routes [inputs](https://docs.aws.amazon.com/iotevents/latest/apireference/API_Input.html) associated with this key to the alarm.
        """
        return pulumi.get(self, "key")

    @property
    @pulumi.getter(name="roleArn")
    def role_arn(self) -> pulumi.Output[builtins.str]:
        """
        The ARN of the IAM role that allows the alarm to perform actions and access AWS resources. For more information, see [Amazon Resource Names (ARNs)](https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html) in the *General Reference*.
        """
        return pulumi.get(self, "role_arn")

    @property
    @pulumi.getter
    def severity(self) -> pulumi.Output[Optional[builtins.int]]:
        """
        A non-negative integer that reflects the severity level of the alarm.
        """
        return pulumi.get(self, "severity")

    @property
    @pulumi.getter
    def tags(self) -> pulumi.Output[Optional[Sequence['_root_outputs.Tag']]]:
        """
        A list of key-value pairs that contain metadata for the alarm model. The tags help you manage the alarm model. For more information, see [Tagging your resources](https://docs.aws.amazon.com/iotevents/latest/developerguide/tagging-iotevents.html) in the *Developer Guide*.
         You can create up to 50 tags for one alarm model.
        """
        return pulumi.get(self, "tags")

