# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs

__all__ = [
    'SuiteDefinitionConfigurationProperties',
    'SuiteDefinitionDeviceUnderTest',
]

@pulumi.output_type
class SuiteDefinitionConfigurationProperties(dict):
    """
    The configuration of the Suite Definition. Listed below are the required elements of the `SuiteDefinitionConfiguration` .

    - ***devicePermissionRoleArn*** - The device permission arn.

    This is a required element.

    *Type:* String
    - ***devices*** - The list of configured devices under test. For more information on devices under test, see [DeviceUnderTest](https://docs.aws.amazon.com/iot/latest/apireference/API_iotdeviceadvisor_DeviceUnderTest.html)

    Not a required element.

    *Type:* List of devices under test
    - ***intendedForQualification*** - The tests intended for qualification in a suite.

    Not a required element.

    *Type:* Boolean
    - ***rootGroup*** - The test suite root group. For more information on creating and using root groups see the [Device Advisor workflow](https://docs.aws.amazon.com/iot/latest/developerguide/device-advisor-workflow.html) .

    This is a required element.

    *Type:* String
    - ***suiteDefinitionName*** - The Suite Definition Configuration name.

    This is a required element.

    *Type:* String
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "devicePermissionRoleArn":
            suggest = "device_permission_role_arn"
        elif key == "rootGroup":
            suggest = "root_group"
        elif key == "intendedForQualification":
            suggest = "intended_for_qualification"
        elif key == "suiteDefinitionName":
            suggest = "suite_definition_name"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in SuiteDefinitionConfigurationProperties. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        SuiteDefinitionConfigurationProperties.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        SuiteDefinitionConfigurationProperties.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 device_permission_role_arn: builtins.str,
                 root_group: builtins.str,
                 devices: Optional[Sequence['outputs.SuiteDefinitionDeviceUnderTest']] = None,
                 intended_for_qualification: Optional[builtins.bool] = None,
                 suite_definition_name: Optional[builtins.str] = None):
        """
        The configuration of the Suite Definition. Listed below are the required elements of the `SuiteDefinitionConfiguration` .

        - ***devicePermissionRoleArn*** - The device permission arn.

        This is a required element.

        *Type:* String
        - ***devices*** - The list of configured devices under test. For more information on devices under test, see [DeviceUnderTest](https://docs.aws.amazon.com/iot/latest/apireference/API_iotdeviceadvisor_DeviceUnderTest.html)

        Not a required element.

        *Type:* List of devices under test
        - ***intendedForQualification*** - The tests intended for qualification in a suite.

        Not a required element.

        *Type:* Boolean
        - ***rootGroup*** - The test suite root group. For more information on creating and using root groups see the [Device Advisor workflow](https://docs.aws.amazon.com/iot/latest/developerguide/device-advisor-workflow.html) .

        This is a required element.

        *Type:* String
        - ***suiteDefinitionName*** - The Suite Definition Configuration name.

        This is a required element.

        *Type:* String
        :param builtins.str device_permission_role_arn: Gets the device permission ARN. This is a required parameter.
        :param builtins.str root_group: Gets the test suite root group. This is a required parameter. For updating or creating the latest qualification suite, if `intendedForQualification` is set to true, `rootGroup` can be an empty string. If `intendedForQualification` is false, `rootGroup` cannot be an empty string. If `rootGroup` is empty, and `intendedForQualification` is set to true, all the qualification tests are included, and the configuration is default.
               
               For a qualification suite, the minimum length is 0, and the maximum is 2048. For a non-qualification suite, the minimum length is 1, and the maximum is 2048.
        :param Sequence['SuiteDefinitionDeviceUnderTest'] devices: Gets the devices configured.
        :param builtins.bool intended_for_qualification: Gets the tests intended for qualification in a suite.
        :param builtins.str suite_definition_name: Gets the suite definition name. This is a required parameter.
        """
        pulumi.set(__self__, "device_permission_role_arn", device_permission_role_arn)
        pulumi.set(__self__, "root_group", root_group)
        if devices is not None:
            pulumi.set(__self__, "devices", devices)
        if intended_for_qualification is not None:
            pulumi.set(__self__, "intended_for_qualification", intended_for_qualification)
        if suite_definition_name is not None:
            pulumi.set(__self__, "suite_definition_name", suite_definition_name)

    @property
    @pulumi.getter(name="devicePermissionRoleArn")
    def device_permission_role_arn(self) -> builtins.str:
        """
        Gets the device permission ARN. This is a required parameter.
        """
        return pulumi.get(self, "device_permission_role_arn")

    @property
    @pulumi.getter(name="rootGroup")
    def root_group(self) -> builtins.str:
        """
        Gets the test suite root group. This is a required parameter. For updating or creating the latest qualification suite, if `intendedForQualification` is set to true, `rootGroup` can be an empty string. If `intendedForQualification` is false, `rootGroup` cannot be an empty string. If `rootGroup` is empty, and `intendedForQualification` is set to true, all the qualification tests are included, and the configuration is default.

        For a qualification suite, the minimum length is 0, and the maximum is 2048. For a non-qualification suite, the minimum length is 1, and the maximum is 2048.
        """
        return pulumi.get(self, "root_group")

    @property
    @pulumi.getter
    def devices(self) -> Optional[Sequence['outputs.SuiteDefinitionDeviceUnderTest']]:
        """
        Gets the devices configured.
        """
        return pulumi.get(self, "devices")

    @property
    @pulumi.getter(name="intendedForQualification")
    def intended_for_qualification(self) -> Optional[builtins.bool]:
        """
        Gets the tests intended for qualification in a suite.
        """
        return pulumi.get(self, "intended_for_qualification")

    @property
    @pulumi.getter(name="suiteDefinitionName")
    def suite_definition_name(self) -> Optional[builtins.str]:
        """
        Gets the suite definition name. This is a required parameter.
        """
        return pulumi.get(self, "suite_definition_name")


@pulumi.output_type
class SuiteDefinitionDeviceUnderTest(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "certificateArn":
            suggest = "certificate_arn"
        elif key == "thingArn":
            suggest = "thing_arn"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in SuiteDefinitionDeviceUnderTest. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        SuiteDefinitionDeviceUnderTest.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        SuiteDefinitionDeviceUnderTest.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 certificate_arn: Optional[builtins.str] = None,
                 thing_arn: Optional[builtins.str] = None):
        if certificate_arn is not None:
            pulumi.set(__self__, "certificate_arn", certificate_arn)
        if thing_arn is not None:
            pulumi.set(__self__, "thing_arn", thing_arn)

    @property
    @pulumi.getter(name="certificateArn")
    def certificate_arn(self) -> Optional[builtins.str]:
        return pulumi.get(self, "certificate_arn")

    @property
    @pulumi.getter(name="thingArn")
    def thing_arn(self) -> Optional[builtins.str]:
        return pulumi.get(self, "thing_arn")


